/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import java.util.Vector;
import org.xml.sax.SAXException;

public class Round
extends Function {
    public String getName() {
        return "round";
    }

    public int getDataType() {
        return 2;
    }

    public boolean isNumeric() {
        return true;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        int n = this.checkArgumentCount(1, 1);
        double d = ((Value)vector.elementAt(0)).asNumber();
        return new NumericValue(Round.round(d));
    }

    public static double round(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (Double.isInfinite(d)) {
            return d;
        }
        if (d == 0.0) {
            return d;
        }
        if (d > -0.5 && d < 0.0) {
            return -0.0;
        }
        if (d > -9.223372036854776E18 && d < 9.223372036854776E18) {
            return Math.round(d);
        }
        double d2 = d % 1.0;
        if (d2 < 0.5) {
            return d - d2;
        }
        return d - d2 + 1.0;
    }

    public Expression simplify() throws SAXException {
        return this.simplifyPureFunction();
    }
}

