/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.DifferenceEnumeration;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.IntersectionEnumeration;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Round;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.output.Outputter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXException;

public class Extensions {
    private static Name rangeName = new Name("saxon-range");
    private static Name tokenName = new Name("saxon-token");

    public static NodeSetValue nodeset(Value value) throws SAXException {
        if (value instanceof NodeSetValue) {
            return (NodeSetValue)value;
        }
        return new FragmentValue(value.asString());
    }

    public static String systemid(Context context) throws SAXException {
        return context.getContextNode().getSystemId();
    }

    public static double linenumber(Context context) throws SAXException {
        return context.getContextNode().getLineNumber();
    }

    public static NodeSetValue intersection(NodeSetValue nodeSetValue, NodeSetValue nodeSetValue2) throws SAXException {
        NodeEnumeration nodeEnumeration = nodeSetValue.enumerate();
        NodeEnumeration nodeEnumeration2 = nodeSetValue2.enumerate();
        IntersectionEnumeration intersectionEnumeration = new IntersectionEnumeration(nodeEnumeration, nodeEnumeration2);
        return new NodeSetExtent(intersectionEnumeration);
    }

    public static NodeSetValue difference(NodeSetValue nodeSetValue, NodeSetValue nodeSetValue2) throws SAXException {
        NodeEnumeration nodeEnumeration = nodeSetValue.enumerate();
        NodeEnumeration nodeEnumeration2 = nodeSetValue2.enumerate();
        DifferenceEnumeration differenceEnumeration = new DifferenceEnumeration(nodeEnumeration, nodeEnumeration2);
        return new NodeSetExtent(differenceEnumeration);
    }

    public static boolean hasSameNodes(NodeSetValue nodeSetValue, NodeSetValue nodeSetValue2) throws SAXException {
        NodeEnumeration nodeEnumeration;
        if (nodeSetValue.getCount() != nodeSetValue2.getCount()) {
            return false;
        }
        NodeEnumeration nodeEnumeration2 = nodeSetValue.enumerate();
        DifferenceEnumeration differenceEnumeration = new DifferenceEnumeration(nodeEnumeration2, nodeEnumeration = nodeSetValue2.enumerate());
        return !differenceEnumeration.hasMoreElements();
    }

    public static Value IF(Value value, Value value2, Value value3) throws SAXException {
        return value.asBoolean() ? value2 : value3;
    }

    public static Value evaluate(Context context, String string) throws SAXException {
        Expression expression = Expression.make(string, context.getStaticContext());
        return expression.evaluate(context);
    }

    public static Value eval(Context context, Expression expression) throws SAXException {
        return expression.evaluate(context);
    }

    public static Value expression(Context context, String string) throws SAXException {
        Expression expression = Expression.make(string, context.getStaticContext());
        Expression expression2 = expression.reduce(1, context).simplify();
        return new ObjectValue(expression2);
    }

    public static double sum(Context context, NodeSetValue nodeSetValue, Expression expression) throws SAXException {
        double d = 0.0;
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        Context context2 = context.newContext();
        context2.setLast(nodeInfoArray.length);
        int n = 0;
        while (n < nodeInfoArray.length) {
            context2.setContextNode(nodeInfoArray[n]);
            context2.setPosition(n + 1);
            double d2 = expression.evaluateAsNumber(context2);
            d += d2;
            ++n;
        }
        return d;
    }

    public static double max(NodeSetValue nodeSetValue) throws SAXException {
        double d = Double.NEGATIVE_INFINITY;
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        int n = 0;
        while (n < nodeInfoArray.length) {
            double d2 = Value.stringToNumber(nodeInfoArray[n].getValue());
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public static double max(Context context, NodeSetValue nodeSetValue, Expression expression) throws SAXException {
        double d = Double.NEGATIVE_INFINITY;
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        Context context2 = context.newContext();
        context2.setLast(nodeInfoArray.length);
        int n = 0;
        while (n < nodeInfoArray.length) {
            context2.setContextNode(nodeInfoArray[n]);
            context2.setPosition(n + 1);
            double d2 = expression.evaluateAsNumber(context2);
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public static double min(NodeSetValue nodeSetValue) throws SAXException {
        double d = Double.POSITIVE_INFINITY;
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        int n = 0;
        while (n < nodeInfoArray.length) {
            double d2 = Value.stringToNumber(nodeInfoArray[n].getValue());
            if (d2 < d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public static double min(Context context, NodeSetValue nodeSetValue, Expression expression) throws SAXException {
        double d = Double.POSITIVE_INFINITY;
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        Context context2 = context.newContext();
        context2.setLast(nodeInfoArray.length);
        int n = 0;
        while (n < nodeInfoArray.length) {
            context2.setContextNode(nodeInfoArray[n]);
            context2.setPosition(n + 1);
            double d2 = expression.evaluateAsNumber(context2);
            if (d2 < d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public static NodeSetValue highest(NodeSetValue nodeSetValue) throws SAXException {
        double d = Double.NEGATIVE_INFINITY;
        NodeInfo nodeInfo = null;
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        int n = 0;
        while (n < nodeInfoArray.length) {
            double d2 = Value.stringToNumber(nodeInfoArray[n].getValue());
            if (d2 > d) {
                d = d2;
                nodeInfo = nodeInfoArray[n];
            }
            ++n;
        }
        return new SingletonNodeSet(nodeInfo);
    }

    public static NodeSetValue highest(Context context, NodeSetValue nodeSetValue, Expression expression) throws SAXException {
        double d = Double.NEGATIVE_INFINITY;
        NodeInfo nodeInfo = null;
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        Context context2 = context.newContext();
        context2.setLast(nodeInfoArray.length);
        int n = 0;
        while (n < nodeInfoArray.length) {
            context2.setContextNode(nodeInfoArray[n]);
            context2.setPosition(n + 1);
            double d2 = expression.evaluateAsNumber(context2);
            if (d2 > d) {
                d = d2;
                nodeInfo = nodeInfoArray[n];
            }
            ++n;
        }
        return new SingletonNodeSet(nodeInfo);
    }

    public static NodeSetValue lowest(NodeSetValue nodeSetValue) throws SAXException {
        double d = Double.POSITIVE_INFINITY;
        NodeInfo nodeInfo = null;
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        int n = 0;
        while (n < nodeInfoArray.length) {
            double d2 = Value.stringToNumber(nodeInfoArray[n].getValue());
            if (d2 < d) {
                d = d2;
                nodeInfo = nodeInfoArray[n];
            }
            ++n;
        }
        return new SingletonNodeSet(nodeInfo);
    }

    public static NodeSetValue lowest(Context context, NodeSetValue nodeSetValue, Expression expression) throws SAXException {
        double d = Double.POSITIVE_INFINITY;
        NodeInfo nodeInfo = null;
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        Context context2 = context.newContext();
        context2.setLast(nodeInfoArray.length);
        int n = 0;
        while (n < nodeInfoArray.length) {
            context2.setContextNode(nodeInfoArray[n]);
            context2.setPosition(n + 1);
            double d2 = expression.evaluateAsNumber(context2);
            if (d2 < d) {
                d = d2;
                nodeInfo = nodeInfoArray[n];
            }
            ++n;
        }
        return new SingletonNodeSet(nodeInfo);
    }

    public static NodeSetValue distinct(NodeSetValue nodeSetValue) throws SAXException {
        Object object;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Vector<Object> vector = new Vector<Object>();
        NodeEnumeration nodeEnumeration = nodeSetValue.enumerate();
        while (nodeEnumeration.hasMoreElements()) {
            object = nodeEnumeration.nextElement();
            String string = object.getValue();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, object);
            vector.addElement(object);
        }
        object = new NodeSetExtent(vector);
        ((NodeSetValue)object).setSorted(nodeSetValue.isSorted());
        return object;
    }

    public static NodeSetValue distinct(Context context, NodeSetValue nodeSetValue, Expression expression) throws SAXException {
        Object object;
        Hashtable<Object, NodeInfo> hashtable = new Hashtable<Object, NodeInfo>();
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        Context context2 = context.newContext();
        context2.setLast(nodeInfoArray.length);
        int n = 0;
        while (n < nodeInfoArray.length) {
            context2.setContextNode(nodeInfoArray[n]);
            context2.setPosition(n + 1);
            object = expression.evaluateAsString(context2);
            if (hashtable.get(object) == null) {
                hashtable.put(object, nodeInfoArray[n]);
                vector.addElement(nodeInfoArray[n]);
            }
            ++n;
        }
        object = new NodeSetExtent(vector);
        ((NodeSetValue)object).setSorted(nodeSetValue.isSorted());
        return object;
    }

    public static NodeSetValue leading(Context context, NodeSetValue nodeSetValue, Expression expression) throws SAXException {
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        nodeSetValue.sort();
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        Context context2 = context.newContext();
        context2.setLast(nodeInfoArray.length);
        int n = 0;
        while (n < nodeInfoArray.length) {
            context2.setContextNode(nodeInfoArray[n]);
            context2.setPosition(n + 1);
            boolean bl = expression.evaluateAsBoolean(context2);
            if (!bl) break;
            vector.addElement(nodeInfoArray[n]);
            ++n;
        }
        NodeSetExtent nodeSetExtent = new NodeSetExtent(vector);
        ((NodeSetValue)nodeSetExtent).setSorted(true);
        return nodeSetExtent;
    }

    public static boolean exists(Context context, NodeSetValue nodeSetValue, Expression expression) throws SAXException {
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        Context context2 = context.newContext();
        context2.setLast(nodeInfoArray.length);
        int n = 0;
        while (n < nodeInfoArray.length) {
            context2.setContextNode(nodeInfoArray[n]);
            context2.setPosition(n + 1);
            boolean bl = expression.evaluateAsBoolean(context2);
            if (bl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean forAll(Context context, NodeSetValue nodeSetValue, Expression expression) throws SAXException {
        NodeInfo[] nodeInfoArray = nodeSetValue.getNodes();
        Context context2 = context.newContext();
        context2.setLast(nodeInfoArray.length);
        int n = 0;
        while (n < nodeInfoArray.length) {
            context2.setContextNode(nodeInfoArray[n]);
            context2.setPosition(n + 1);
            boolean bl = expression.evaluateAsBoolean(context2);
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static NodeSetValue range(Context context, double d, double d2) throws SAXException {
        int n = (int)Round.round(d);
        int n2 = (int)Round.round(d2);
        FragmentValue fragmentValue = new FragmentValue();
        Controller controller = context.getController();
        OutputDetails outputDetails = new OutputDetails();
        outputDetails.setMethod("saxon:fragment");
        outputDetails.setEmitter(fragmentValue.getEmitter());
        controller.setNewOutputDetails(outputDetails);
        Outputter outputter = controller.getOutputter();
        int n3 = n;
        while (n3 <= n2) {
            outputter.writeStartTag(rangeName);
            outputter.writeContent(n3 + "");
            outputter.writeEndTag(rangeName);
            ++n3;
        }
        controller.resetOutputDetails();
        return new NodeSetExtent(fragmentValue.getFirst().getAllChildNodes());
    }

    public static NodeSetValue tokenize(Context context, String string) throws SAXException {
        FragmentValue fragmentValue = new FragmentValue();
        Controller controller = context.getController();
        OutputDetails outputDetails = new OutputDetails();
        outputDetails.setMethod("saxon:fragment");
        outputDetails.setEmitter(fragmentValue.getEmitter());
        controller.setNewOutputDetails(outputDetails);
        Outputter outputter = controller.getOutputter();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            outputter.writeStartTag(tokenName);
            outputter.writeContent(stringTokenizer.nextToken());
            outputter.writeEndTag(tokenName);
        }
        controller.resetOutputDetails();
        return new NodeSetExtent(fragmentValue.getFirst().getAllChildNodes());
    }

    public static NodeSetValue tokenize(Context context, String string, String string2) throws SAXException {
        FragmentValue fragmentValue = new FragmentValue();
        Controller controller = context.getController();
        OutputDetails outputDetails = new OutputDetails();
        outputDetails.setMethod("saxon:fragment");
        outputDetails.setEmitter(fragmentValue.getEmitter());
        controller.setNewOutputDetails(outputDetails);
        Outputter outputter = controller.getOutputter();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            outputter.writeStartTag(tokenName);
            outputter.writeContent(stringTokenizer.nextToken());
            outputter.writeEndTag(tokenName);
        }
        controller.resetOutputDetails();
        return new NodeSetExtent(fragmentValue.getFirst().getAllChildNodes());
    }

    public static String path(Context context) throws SAXException {
        return context.getContextNode().getPath();
    }

    public static boolean isNull(Object object) throws SAXException {
        return object == null;
    }

    public static void setUserData(Context context, String string, Value value) throws SAXException {
        context.getController().setUserData(context.getContextNode(), string, value);
    }

    public static Value getUserData(Context context, String string) throws SAXException {
        Object object = context.getController().getUserData(context.getContextNode(), string);
        if (object == null) {
            return new StringValue("");
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        return new ObjectValue(object);
    }
}

