/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.SAXONFunction;
import java.util.Vector;
import org.xml.sax.SAXException;

public class StyleSheetFunctionCall
extends Function {
    private SAXONFunction function;
    private Controller boundController = null;
    private NodeInfo boundContextNode = null;
    private int boundContextPosition = -1;
    private int boundContextSize = -1;

    public void setFunction(SAXONFunction sAXONFunction) {
        this.function = sAXONFunction;
    }

    public Function newInstance() {
        StyleSheetFunctionCall styleSheetFunctionCall = new StyleSheetFunctionCall();
        styleSheetFunctionCall.setFunction(this.function);
        styleSheetFunctionCall.setStaticContext(this.getStaticContext());
        return styleSheetFunctionCall;
    }

    public String getName() {
        return this.function.getAttribute("name");
    }

    public int getIntrinsicDependencies() {
        int n = 0;
        if (this.boundController == null) {
            n |= 0x40;
        }
        if (this.boundContextNode == null) {
            n |= 8;
        }
        if (this.boundContextPosition == -1) {
            n |= 0x10;
        }
        if (this.boundContextSize == -1) {
            n |= 0x20;
        }
        return n;
    }

    protected Expression reduceIntrinsic(int n, Context context) throws SAXException {
        if ((n & 0x40) != 0) {
            this.boundController = context.getController();
        }
        if ((n & 8) != 0) {
            this.boundContextNode = context.getContextNode();
        }
        if ((n & 0x10) != 0) {
            this.boundContextPosition = context.getPosition();
        }
        if ((n & 0x20) != 0) {
            this.boundContextSize = context.getLast();
        }
        return this;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        if (this.boundController != null) {
            context.setController(this.boundController);
            context.setBindery(this.boundController.getBindery());
        }
        if (this.boundContextNode != null) {
            context.setCurrentNode(this.boundContextNode);
            context.setContextNode(this.boundContextNode);
        }
        if (this.boundContextPosition != -1) {
            context.setPosition(this.boundContextPosition);
        }
        if (this.boundContextSize != -1) {
            context.setLast(this.boundContextSize);
        }
        ParameterSet parameterSet = new ParameterSet();
        int n = 0;
        while (n < vector.size()) {
            String string = this.function.getNthParameter(n);
            if (string == null) {
                throw new SAXException("Too many arguments");
            }
            parameterSet.put(string, (Value)vector.elementAt(n));
            ++n;
        }
        return this.function.call(parameterSet, context);
    }
}

