/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.expr.Value;

public final class StringValue
extends Value {
    private String value;

    public StringValue(String string) {
        this.value = string == null ? "" : string;
    }

    public String asString() {
        return this.value;
    }

    public double asNumber() {
        return Value.stringToNumber(this.value);
    }

    public boolean asBoolean() {
        return this.value.length() > 0;
    }

    public int getType() {
        return 3;
    }

    public int getLength() {
        return StringValue.getLength(this.value);
    }

    public static int getLength(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c < '\ud800' || c > '\udbff') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static int[] expand(String string) {
        int[] nArray = new int[StringValue.getLength(string)];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            int n4 = string.charAt(n2);
            if (n4 >= 55296 && n4 <= 56319) {
                n3 = (n4 - 55296) * 1024 + (string.charAt(n2 + 1) - 56320) + 65536;
                ++n2;
            } else {
                n3 = n4;
            }
            nArray[n++] = n3;
            ++n2;
        }
        return nArray;
    }

    public boolean equals(StringValue stringValue) {
        return this.value.equals(stringValue.value);
    }

    public String toString() {
        return "\"" + this.asString() + "\"";
    }
}

