/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.NameTest;
import com.icl.saxon.axis.Axis;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FilterEnumerator;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import java.util.Vector;
import org.xml.sax.SAXException;

public final class Step {
    protected Axis axis;
    protected NameTest name;
    protected int nodeType;
    private Vector filters = new Vector();

    public Step(int n, int n2, NameTest nameTest) throws SAXException {
        this.axis = Axis.make(n, n2, nameTest);
        this.name = nameTest;
        this.nodeType = n2;
    }

    public Step(Axis axis, int n, NameTest nameTest) {
        this.axis = axis;
        this.name = nameTest;
        this.nodeType = n;
    }

    public Step addFilter(Expression expression) {
        this.filters.addElement(expression);
        return this;
    }

    public void setFilters(Vector vector) {
        this.filters = vector;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public NameTest getNodeName() {
        return this.name;
    }

    public Vector getFilters() {
        return this.filters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Step simplify() throws SAXException {
        if (this.nodeType != 0) {
            if (this.axis.getAxisNumber() == 3 != (this.nodeType == 2)) {
                return null;
            }
            if (this.axis.getAxisNumber() == 9 != (this.nodeType == 9)) {
                return null;
            }
        }
        int n = 0;
        while (n < this.filters.size()) {
            Expression expression = ((Expression)this.filters.elementAt(n)).simplify();
            if (expression instanceof Value && !(expression instanceof NumericValue)) {
                if (!((Value)expression).asBoolean()) return null;
                this.filters.removeElementAt(n);
                --n;
            } else {
                this.filters.setElementAt(expression, n);
            }
            ++n;
        }
        return this;
    }

    public NodeEnumeration enumerate(NodeInfo nodeInfo, Context context) throws SAXException {
        NodeEnumeration nodeEnumeration = this.axis.getEnumeration(nodeInfo);
        if (nodeEnumeration.hasMoreElements()) {
            int n = 0;
            while (n < this.filters.size()) {
                nodeEnumeration = new FilterEnumerator(nodeEnumeration, (Expression)this.filters.elementAt(n), context);
                ++n;
            }
        }
        return nodeEnumeration;
    }

    public String toString() {
        String string = this.axis.toString() + "::";
        switch (this.nodeType) {
            case 2: {
                string = string + "@" + this.name.toString();
                break;
            }
            case 1: {
                string = string + this.name.toString();
                break;
            }
            case 3: {
                string = string + "text()";
                break;
            }
            case 0: {
                string = string + "node()";
                break;
            }
            case 4: {
                string = string + "/";
                break;
            }
            default: {
                string = string + "???";
            }
        }
        int n = 0;
        while (n < this.filters.size()) {
            string = string + "[" + this.filters.elementAt(n).toString() + "]";
            ++n;
        }
        return string;
    }
}

