/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.AttributeReference;
import com.icl.saxon.expr.ContextNodeExpression;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.SingletonExpression;
import com.icl.saxon.expr.Step;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import java.util.Vector;
import org.xml.sax.SAXException;

public class PathExpression
extends NodeSetExpression {
    private Expression start;
    private Step step;

    public PathExpression(Expression expression, Step step) {
        this.start = expression;
        this.step = step;
    }

    public Expression simplify() throws SAXException {
        this.start = this.start.simplify();
        this.step = this.step.simplify();
        if (this.start instanceof EmptyNodeSet) {
            return this.start;
        }
        if (this.step == null) {
            return new EmptyNodeSet();
        }
        int n = this.step.getAxis().getAxisNumber();
        if (this.start instanceof ContextNodeExpression && n == 3 && this.step.getNodeName() instanceof Name && this.step.getFilters().size() == 0) {
            return new AttributeReference((Name)this.step.getNodeName());
        }
        if (n == 4 && this.step.getFilters().size() == 0 && this.start instanceof PathExpression && ((PathExpression)this.start).step.getAxis().getAxisNumber() == 6 && ((PathExpression)this.start).step.getFilters().size() == 0 && ((PathExpression)this.start).step.getNodeName() == null && ((PathExpression)this.start).step.getNodeType() == 0) {
            return new PathExpression(((PathExpression)this.start).start, new Step(5, this.step.getNodeType(), this.step.getNodeName()));
        }
        return this;
    }

    public int getDependencies() {
        int n = this.start.getDependencies();
        Vector vector = this.step.getFilters();
        int n2 = 0;
        while (n2 < vector.size()) {
            Expression expression = (Expression)vector.elementAt(n2);
            n |= expression.getDependencies() & 0x45;
            ++n2;
        }
        return n;
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if ((n & this.getDependencies()) != 0) {
            Expression expression;
            Expression expression2 = this.start.reduce(n, context);
            Step step = new Step(this.step.getAxis(), this.step.getNodeType(), this.step.getNodeName());
            Vector vector = this.step.getFilters();
            int n2 = 0;
            while (n2 < vector.size()) {
                expression = (Expression)vector.elementAt(n2);
                Expression expression3 = expression.reduce(n & 0x45, context);
                step.addFilter(expression3);
                ++n2;
            }
            expression = new PathExpression(expression2, step);
            expression.setStaticContext(this.getStaticContext());
            return expression.simplify();
        }
        return this;
    }

    public NodeEnumeration enumerate(Context context) throws SAXException {
        return new PathEnumeration(this.start, context);
    }

    public String toString() {
        String string = this.start.toString();
        if (string.equals("/")) {
            string = "";
        }
        return string + "/" + this.step.toString();
    }

    private class PathEnumeration
    implements NodeEnumeration {
        private Expression thisStart;
        private NodeEnumeration base = null;
        private NodeEnumeration thisStep = null;
        private NodeInfo next = null;
        private Context context;

        public PathEnumeration(Expression expression, Context context) throws SAXException {
            this.thisStart = expression;
            this.context = context == null ? new Context() : context.newContext();
            this.base = expression.enumerate(this.context);
            this.next = this.getNextNode();
        }

        public boolean hasMoreElements() throws SAXException {
            return this.next != null;
        }

        public NodeInfo nextElement() throws SAXException {
            NodeInfo nodeInfo = this.next;
            this.next = this.getNextNode();
            return nodeInfo;
        }

        /*
         * Unable to fully structure code
         */
        private NodeInfo getNextNode() throws SAXException {
            if (this.thisStep == null || !this.thisStep.hasMoreElements()) ** GOTO lbl7
            return this.thisStep.nextElement();
lbl-1000:
            // 1 sources

            {
                var1_1 = this.base.nextElement();
                this.thisStep = PathExpression.access$000(PathExpression.this).enumerate(var1_1, this.context);
                if (!this.thisStep.hasMoreElements()) continue;
                return this.thisStep.nextElement();
lbl7:
                // 2 sources

                ** while (this.base.hasMoreElements())
            }
lbl8:
            // 1 sources

            return null;
        }

        public boolean isSorted() throws SAXException {
            return this.base.isSorted() && this.base.isPeer() && PathExpression.this.step.getAxis().isWithinSubtree() || this.thisStart instanceof SingletonExpression && PathExpression.this.step.getAxis().isSorted();
        }

        public boolean isReverseSorted() throws SAXException {
            return this.thisStart instanceof SingletonExpression && PathExpression.this.step.getAxis().isReverseSorted();
        }

        public boolean isPeer() throws SAXException {
            return this.base.isPeer() && PathExpression.this.step.getAxis().isPeer();
        }
    }
}

