/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.NameTest;
import com.icl.saxon.axis.Axis;
import com.icl.saxon.expr.AnyNameTest;
import com.icl.saxon.expr.ArithmeticExpression;
import com.icl.saxon.expr.BooleanExpression;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.ContextNodeExpression;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FilterExpression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.FunctionProxy;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ParentNodeExpression;
import com.icl.saxon.expr.PathExpression;
import com.icl.saxon.expr.RelationalExpression;
import com.icl.saxon.expr.RootExpression;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.Step;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Tokenizer;
import com.icl.saxon.expr.UnionExpression;
import com.icl.saxon.expr.VariableReference;
import com.icl.saxon.functions.BooleanFn;
import com.icl.saxon.functions.Ceiling;
import com.icl.saxon.functions.Concat;
import com.icl.saxon.functions.Contains;
import com.icl.saxon.functions.Count;
import com.icl.saxon.functions.Current;
import com.icl.saxon.functions.Document;
import com.icl.saxon.functions.ElementAvailable;
import com.icl.saxon.functions.Floor;
import com.icl.saxon.functions.FormatNumber;
import com.icl.saxon.functions.FunctionAvailable;
import com.icl.saxon.functions.GenerateId;
import com.icl.saxon.functions.Id;
import com.icl.saxon.functions.Key;
import com.icl.saxon.functions.Lang;
import com.icl.saxon.functions.Last;
import com.icl.saxon.functions.LocalName;
import com.icl.saxon.functions.NameFn;
import com.icl.saxon.functions.NamespaceURI;
import com.icl.saxon.functions.NormalizeSpace;
import com.icl.saxon.functions.Not;
import com.icl.saxon.functions.NumberFn;
import com.icl.saxon.functions.Position;
import com.icl.saxon.functions.Round;
import com.icl.saxon.functions.StartsWith;
import com.icl.saxon.functions.StringFn;
import com.icl.saxon.functions.StringLength;
import com.icl.saxon.functions.Substring;
import com.icl.saxon.functions.SubstringAfter;
import com.icl.saxon.functions.SubstringBefore;
import com.icl.saxon.functions.Sum;
import com.icl.saxon.functions.SystemProperty;
import com.icl.saxon.functions.Translate;
import com.icl.saxon.functions.UnparsedEntityURI;
import com.icl.saxon.om.Name;
import com.icl.saxon.pattern.DocumentPattern;
import com.icl.saxon.pattern.IDPattern;
import com.icl.saxon.pattern.KeyPattern;
import com.icl.saxon.pattern.LocationPathPattern;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.pattern.UnionPattern;
import org.xml.sax.SAXException;

public final class ExpressionParser {
    private Tokenizer t;
    private StaticContext env;

    private void expect(int n) throws SAXException {
        if (this.t.currentToken != n) {
            this.grumble("expected \"" + Tokenizer.tokens[n] + "\"" + ", found \"" + Tokenizer.tokens[this.t.currentToken] + "\"");
        }
    }

    private void grumble(String string) throws SAXException {
        throw new SAXException("Error in expression " + this.t.pattern + ": " + string);
    }

    public Expression parse(String string, StaticContext staticContext) throws SAXException {
        this.env = staticContext;
        this.t = new Tokenizer();
        this.t.tokenize(string);
        Expression expression = this.parseExpression();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + Tokenizer.tokens[this.t.currentToken] + " beyond end of expression");
        }
        expression.setStaticContext(staticContext);
        return expression;
    }

    public Pattern parsePattern(String string, StaticContext staticContext) throws SAXException {
        this.env = staticContext;
        this.t = new Tokenizer();
        this.t.tokenize(string);
        Pattern pattern = this.parseUnionPattern();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + Tokenizer.tokens[this.t.currentToken] + " beyond end of pattern");
        }
        pattern.setStaticContext(staticContext);
        return pattern;
    }

    private Expression parseExpression() throws SAXException {
        Expression expression = this.parseAndExpression();
        while (this.t.currentToken == 18) {
            this.t.next();
            expression = new BooleanExpression(expression, 18, this.parseAndExpression());
        }
        expression.setStaticContext(this.env);
        return expression;
    }

    private Expression parseAndExpression() throws SAXException {
        Expression expression = this.parseEqualityExpression();
        while (this.t.currentToken == 19) {
            this.t.next();
            expression = new BooleanExpression(expression, 19, this.parseEqualityExpression());
        }
        expression.setStaticContext(this.env);
        return expression;
    }

    private Expression parseEqualityExpression() throws SAXException {
        Expression expression = this.parseRelationalExpression();
        while (this.t.currentToken == 11 || this.t.currentToken == 34) {
            int n = this.t.currentToken;
            this.t.next();
            expression = new RelationalExpression(expression, n, this.parseRelationalExpression());
        }
        expression.setStaticContext(this.env);
        return expression;
    }

    private Expression parseRelationalExpression() throws SAXException {
        Expression expression = this.parseAdditiveExpression();
        while (this.t.currentToken == 22 || this.t.currentToken == 21 || this.t.currentToken == 24 || this.t.currentToken == 23) {
            int n = this.t.currentToken;
            this.t.next();
            expression = new RelationalExpression(expression, n, this.parseAdditiveExpression());
        }
        expression.setStaticContext(this.env);
        return expression;
    }

    private Expression parseAdditiveExpression() throws SAXException {
        Expression expression = this.parseMultiplicativeExpression();
        while (this.t.currentToken == 25 || this.t.currentToken == 26) {
            int n = this.t.currentToken;
            this.t.next();
            expression = new ArithmeticExpression(expression, n, this.parseMultiplicativeExpression());
        }
        expression.setStaticContext(this.env);
        return expression;
    }

    private Expression parseMultiplicativeExpression() throws SAXException {
        Expression expression = this.parseUnaryExpression();
        while (this.t.currentToken == 27 || this.t.currentToken == 28 || this.t.currentToken == 29) {
            int n = this.t.currentToken;
            this.t.next();
            expression = new ArithmeticExpression(expression, n, this.parseUnaryExpression());
        }
        expression.setStaticContext(this.env);
        return expression;
    }

    private Expression parseUnaryExpression() throws SAXException {
        Expression expression;
        if (this.t.currentToken == 26) {
            this.t.next();
            expression = new ArithmeticExpression(new NumericValue(0.0), 99, this.parseUnaryExpression());
        } else {
            expression = this.parseUnionExpression();
        }
        expression.setStaticContext(this.env);
        return expression;
    }

    private Expression parseUnionExpression() throws SAXException {
        Expression expression = this.parsePathExpression();
        while (this.t.currentToken == 4) {
            this.t.next();
            expression = new UnionExpression(expression, this.parsePathExpression());
        }
        expression.setStaticContext(this.env);
        return expression;
    }

    private Expression parsePathExpression() throws SAXException {
        switch (this.t.currentToken) {
            case 5: {
                this.t.next();
                switch (this.t.currentToken) {
                    case 1: 
                    case 6: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 32: 
                    case 33: {
                        return this.parseRelativePath(new RootExpression());
                    }
                }
                return new RootExpression();
            }
            case 16: {
                return this.parsePathContinuation(new RootExpression());
            }
            case 12: {
                this.t.next();
                return this.parsePathContinuation(new ContextNodeExpression());
            }
            case 13: {
                this.t.next();
                return this.parsePathContinuation(new ParentNodeExpression());
            }
            case 1: 
            case 6: 
            case 14: 
            case 17: 
            case 32: 
            case 33: {
                return this.parseRelativePath(new ContextNodeExpression());
            }
        }
        Expression expression = this.parseFilterExpression();
        Expression expression2 = this.parsePathContinuation(expression);
        expression2.setStaticContext(this.env);
        return expression2;
    }

    private Expression parseFilterExpression() throws SAXException {
        Expression expression = this.parsePrimaryExpression();
        while (this.t.currentToken == 7) {
            this.t.next();
            Expression expression2 = this.parseExpression();
            this.expect(8);
            expression = new FilterExpression(expression, expression2);
            expression.setStaticContext(this.env);
            this.t.next();
        }
        return expression;
    }

    private Expression parsePrimaryExpression() throws SAXException {
        switch (this.t.currentToken) {
            case 31: {
                this.t.next();
                this.expect(1);
                String string = this.t.currentTokenValue;
                this.t.next();
                return new VariableReference(this.env.makeName(string, false), this.env);
            }
            case 9: {
                this.t.next();
                Expression expression = this.parseExpression();
                this.expect(10);
                this.t.next();
                return expression;
            }
            case 3: {
                StringValue stringValue = new StringValue(this.t.currentTokenValue);
                this.t.next();
                return stringValue;
            }
            case 20: {
                NumericValue numericValue = new NumericValue(this.t.currentTokenValue);
                this.t.next();
                return numericValue;
            }
            case 2: {
                return this.parseFunctionCall();
            }
        }
        this.grumble("Unexpected token " + Tokenizer.tokens[this.t.currentToken] + " in expression");
        return null;
    }

    private Expression parsePathContinuation(Expression expression) throws SAXException {
        switch (this.t.currentToken) {
            case 5: {
                this.t.next();
                return this.parseRelativePath(expression);
            }
            case 16: {
                PathExpression pathExpression = new PathExpression(expression, new Step(6, 0, (NameTest)new AnyNameTest()));
                pathExpression.setStaticContext(this.env);
                this.t.next();
                return this.parseRelativePath(pathExpression);
            }
        }
        return expression;
    }

    private Expression parseRelativePath(Expression expression) throws SAXException {
        Step step = this.parseStep();
        PathExpression pathExpression = new PathExpression(expression, step);
        pathExpression.setStaticContext(this.env);
        return this.parsePathContinuation(pathExpression);
    }

    private Step parseStep() throws SAXException {
        Step step = null;
        switch (this.t.currentToken) {
            case 12: {
                step = new Step(13, 0, (NameTest)new AnyNameTest());
                this.t.next();
                break;
            }
            case 13: {
                step = new Step(10, 0, (NameTest)new AnyNameTest());
                this.t.next();
                break;
            }
            case 1: {
                step = new Step(4, 1, (NameTest)this.env.makeName(this.t.currentTokenValue, false));
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 17: {
                step = new Step(4, 1, this.env.makePrefixTest(this.t.currentTokenValue));
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 14: {
                step = new Step(4, 1, (NameTest)new AnyNameTest());
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 6: {
                this.t.next();
                switch (this.t.currentToken) {
                    case 1: {
                        step = new Step(3, 2, (NameTest)this.env.makeName(this.t.currentTokenValue, false));
                        this.t.next();
                        break;
                    }
                    case 17: {
                        step = new Step(3, 2, this.env.makePrefixTest(this.t.currentTokenValue));
                        this.t.next();
                        break;
                    }
                    case 14: {
                        step = new Step(3, 2, (NameTest)new AnyNameTest());
                        this.t.next();
                        break;
                    }
                    case 32: {
                        String string = this.t.currentTokenValue;
                        this.t.next();
                        if (string == "text") {
                            step = new Step(3, 3, (NameTest)new AnyNameTest());
                        } else if (string == "node") {
                            step = new Step(3, 0, (NameTest)new AnyNameTest());
                        } else if (string == "comment") {
                            step = new Step(3, 8, (NameTest)new AnyNameTest());
                        } else if (string == "processing-instruction") {
                            if (this.t.currentToken == 3) {
                                step = new Step(3, 7, (NameTest)new Name(this.t.currentTokenValue));
                                this.t.next();
                            } else {
                                step = new Step(3, 7, (NameTest)new AnyNameTest());
                            }
                        }
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    default: {
                        this.grumble("@ must be followed by a NameTest or NodeTest");
                        break;
                    }
                }
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 32: {
                String string = this.t.currentTokenValue;
                this.t.next();
                if (string == "text") {
                    step = new Step(4, 3, (NameTest)new AnyNameTest());
                } else if (string == "node") {
                    step = new Step(4, 0, (NameTest)new AnyNameTest());
                } else if (string == "comment") {
                    step = new Step(4, 8, (NameTest)new AnyNameTest());
                } else if (string == "processing-instruction") {
                    if (this.t.currentToken == 3) {
                        step = new Step(4, 7, (NameTest)new Name(this.t.currentTokenValue));
                        this.t.next();
                    } else {
                        step = new Step(4, 7, (NameTest)new AnyNameTest());
                    }
                }
                this.expect(10);
                this.t.next();
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            case 33: {
                int n = Axis.lookup(this.t.currentTokenValue);
                int n2 = Axis.makeAxis(n).getPrincipalNodeType();
                this.t.next();
                switch (this.t.currentToken) {
                    case 1: {
                        step = new Step(n, n2, (NameTest)this.env.makeName(this.t.currentTokenValue, false));
                        this.t.next();
                        break;
                    }
                    case 17: {
                        step = new Step(n, n2, this.env.makePrefixTest(this.t.currentTokenValue));
                        this.t.next();
                        break;
                    }
                    case 14: {
                        step = new Step(n, n2, (NameTest)new AnyNameTest());
                        this.t.next();
                        break;
                    }
                    case 32: {
                        String string = this.t.currentTokenValue;
                        this.t.next();
                        if (string == "node") {
                            step = new Step(n, 0, (NameTest)new AnyNameTest());
                        } else if (string == "text") {
                            step = new Step(n, 3, (NameTest)new AnyNameTest());
                        } else if (string == "comment") {
                            step = new Step(n, 8, (NameTest)new AnyNameTest());
                        } else if (string == "processing-instruction") {
                            if (this.t.currentToken == 3) {
                                step = new Step(n, 7, (NameTest)new Name(this.t.currentTokenValue));
                                this.t.next();
                            } else {
                                step = new Step(n, 7, (NameTest)new AnyNameTest());
                            }
                        } else {
                            this.grumble("Unsupported node type");
                        }
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    default: {
                        this.grumble("Unexpected token [" + Tokenizer.tokens[this.t.currentToken] + "] after axis name");
                        break;
                    }
                }
                while (this.t.currentToken == 7) {
                    step = this.parseStepPredicate(step);
                }
                break;
            }
            default: {
                this.grumble("Unexpected token [" + Tokenizer.tokens[this.t.currentToken] + "] in path expression");
            }
        }
        return step;
    }

    private Step parseStepPredicate(Step step) throws SAXException {
        this.t.next();
        Expression expression = this.parseExpression();
        this.expect(8);
        this.t.next();
        return step.addFilter(expression);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Expression parseFunctionCall() throws SAXException {
        Expression expression;
        String string = this.t.currentTokenValue;
        Function function = null;
        int n = string.indexOf(":");
        if (n < 0) {
            expression = ExpressionParser.makeSystemFunction(string);
            if (expression == null) {
                this.grumble("Unknown system function: " + string);
            }
            if (!(expression instanceof Function)) {
                this.t.next();
                this.expect(10);
                this.t.next();
                return expression;
            }
            function = (Function)expression;
        } else {
            function = this.env.getStyleSheetFunction(this.env.makeName(this.t.currentTokenValue, false));
        }
        if (function == null) {
            function = new FunctionProxy();
        }
        function.setStaticContext(this.env);
        this.t.next();
        if (this.t.currentToken != 10) {
            expression = this.parseExpression();
            function.addArgument(expression);
            while (this.t.currentToken == 15) {
                this.t.next();
                expression = this.parseExpression();
                function.addArgument(expression);
            }
            this.expect(10);
        }
        this.t.next();
        if (function instanceof FunctionProxy) {
            ((FunctionProxy)function).setMethod(this.env.makeName(string, false));
        }
        return function;
    }

    public static Expression makeSystemFunction(String string) {
        if (string == "last") {
            return new Last();
        }
        if (string == "position") {
            return new Position();
        }
        if (string == "count") {
            return new Count();
        }
        if (string == "current") {
            return new Current();
        }
        if (string == "id") {
            return new Id();
        }
        if (string == "key") {
            return new Key();
        }
        if (string == "document") {
            return new Document();
        }
        if (string == "local-name") {
            return new LocalName();
        }
        if (string == "namespace-uri") {
            return new NamespaceURI();
        }
        if (string == "name") {
            return new NameFn();
        }
        if (string == "generate-id") {
            return new GenerateId();
        }
        if (string == "not") {
            return new Not();
        }
        if (string == "true") {
            return new BooleanValue(true);
        }
        if (string == "false") {
            return new BooleanValue(false);
        }
        if (string == "boolean") {
            return new BooleanFn();
        }
        if (string == "lang") {
            return new Lang();
        }
        if (string == "number") {
            return new NumberFn();
        }
        if (string == "floor") {
            return new Floor();
        }
        if (string == "ceiling") {
            return new Ceiling();
        }
        if (string == "round") {
            return new Round();
        }
        if (string == "sum") {
            return new Sum();
        }
        if (string == "string") {
            return new StringFn();
        }
        if (string == "starts-with") {
            return new StartsWith();
        }
        if (string == "string-length") {
            return new StringLength();
        }
        if (string == "substring") {
            return new Substring();
        }
        if (string == "contains") {
            return new Contains();
        }
        if (string == "substring-before") {
            return new SubstringBefore();
        }
        if (string == "substring-after") {
            return new SubstringAfter();
        }
        if (string == "normalize-space") {
            return new NormalizeSpace();
        }
        if (string == "translate") {
            return new Translate();
        }
        if (string == "concat") {
            return new Concat();
        }
        if (string == "format-number") {
            return new FormatNumber();
        }
        if (string == "system-property") {
            return new SystemProperty();
        }
        if (string == "function-available") {
            return new FunctionAvailable();
        }
        if (string == "element-available") {
            return new ElementAvailable();
        }
        if (string == "unparsed-entity-uri") {
            return new UnparsedEntityURI();
        }
        return null;
    }

    private Pattern parseUnionPattern() throws SAXException {
        Pattern pattern = this.parsePathPattern();
        while (this.t.currentToken == 4) {
            this.t.next();
            Pattern pattern2 = this.parsePathPattern();
            pattern = new UnionPattern(pattern, pattern2);
            pattern.setStaticContext(this.env);
        }
        return pattern;
    }

    private Pattern parsePathPattern() throws SAXException {
        LocationPathPattern locationPathPattern = new LocationPathPattern();
        locationPathPattern.setStaticContext(this.env);
        Pattern pattern = locationPathPattern;
        Pattern pattern2 = null;
        int n = -1;
        boolean bl = false;
        switch (this.t.currentToken) {
            case 5: {
                n = this.t.currentToken;
                this.t.next();
                pattern2 = new DocumentPattern();
                bl = true;
                break;
            }
            case 16: {
                n = this.t.currentToken;
                this.t.next();
                pattern2 = new DocumentPattern();
                bl = false;
                break;
            }
        }
        boolean bl2 = true;
        while (bl2) {
            switch (this.t.currentToken) {
                case 33: {
                    int n2 = Axis.lookup(this.t.currentTokenValue);
                    if (n2 == 4) {
                        this.t.next();
                        pattern = this.patternStep(n2, locationPathPattern, pattern2, n);
                        break;
                    }
                    if (n2 == 3) {
                        this.t.next();
                        pattern = this.patternStep(n2, locationPathPattern, pattern2, n);
                        break;
                    }
                    this.grumble("Axis in pattern must be child or attribute");
                    break;
                }
                case 1: 
                case 14: 
                case 17: 
                case 32: {
                    pattern = this.patternStep(4, locationPathPattern, pattern2, n);
                    break;
                }
                case 6: {
                    this.t.next();
                    pattern = this.patternStep(3, locationPathPattern, pattern2, n);
                    break;
                }
                case 2: {
                    if (pattern2 != null) {
                        this.grumble("Function may appear only at the start of a pattern");
                    }
                    if (this.t.currentTokenValue.equals("id")) {
                        this.t.next();
                        this.expect(3);
                        pattern = new IDPattern(this.t.currentTokenValue);
                        pattern.setStaticContext(this.env);
                        this.t.next();
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    if (this.t.currentTokenValue.equals("key")) {
                        this.t.next();
                        this.expect(3);
                        String string = this.t.currentTokenValue;
                        this.t.next();
                        this.expect(15);
                        this.t.next();
                        this.expect(3);
                        pattern = new KeyPattern(string, this.t.currentTokenValue);
                        pattern.setStaticContext(this.env);
                        this.t.next();
                        this.expect(10);
                        this.t.next();
                        break;
                    }
                    this.grumble("The only functions allowed in a pattern are id() and key()");
                    break;
                }
                default: {
                    if (bl) {
                        return pattern2;
                    }
                    this.grumble("Unxpected token in pattern, found " + Tokenizer.tokens[this.t.currentToken]);
                }
            }
            n = this.t.currentToken;
            bl = false;
            boolean bl3 = bl2 = n == 5 || n == 16;
            if (!bl2) continue;
            pattern2 = pattern;
            locationPathPattern = new LocationPathPattern();
            locationPathPattern.setStaticContext(this.env);
            if (n == 5) {
                locationPathPattern.parentPattern = pattern2;
            } else {
                locationPathPattern.ancestorPattern = pattern2;
            }
            this.t.next();
        }
        pattern.setStaticContext(this.env);
        return pattern;
    }

    private Pattern patternStep(int n, LocationPathPattern locationPathPattern, Pattern pattern, int n2) throws SAXException {
        if (n == 4) {
            if (this.t.currentToken == 14) {
                locationPathPattern.nodeType = 1;
                locationPathPattern.nameTest = new AnyNameTest();
            } else if (this.t.currentToken == 1) {
                locationPathPattern.nodeType = 1;
                locationPathPattern.nameTest = this.env.makeName(this.t.currentTokenValue, false);
            } else if (this.t.currentToken == 17) {
                locationPathPattern.nodeType = 1;
                locationPathPattern.nameTest = this.env.makePrefixTest(this.t.currentTokenValue);
            } else if (this.t.currentToken == 32) {
                String string = this.t.currentTokenValue;
                this.t.next();
                if (string == "text") {
                    locationPathPattern.nodeType = 3;
                } else if (string == "node") {
                    locationPathPattern.nodeType = 0;
                } else if (string == "comment") {
                    locationPathPattern.nodeType = 8;
                } else if (string == "processing-instruction") {
                    locationPathPattern.nodeType = 7;
                    if (this.t.currentToken == 3) {
                        locationPathPattern.nameTest = new Name(this.t.currentTokenValue);
                        this.t.next();
                    }
                }
                this.expect(10);
            } else {
                this.grumble("Unxpected token in pattern, found " + Tokenizer.tokens[this.t.currentToken]);
            }
            if (pattern != null) {
                if (n2 == 5) {
                    locationPathPattern.parentPattern = pattern;
                } else {
                    locationPathPattern.ancestorPattern = pattern;
                }
            }
            this.t.next();
            this.parseFilters(locationPathPattern);
            return locationPathPattern;
        }
        if (n == 3) {
            locationPathPattern.nodeType = 2;
            if (this.t.currentToken == 14) {
                locationPathPattern.nameTest = new AnyNameTest();
            } else if (this.t.currentToken == 1) {
                locationPathPattern.nameTest = this.env.makeName(this.t.currentTokenValue, false);
            } else if (this.t.currentToken == 17) {
                locationPathPattern.nameTest = this.env.makePrefixTest(this.t.currentTokenValue);
            } else if (this.t.currentToken == 32) {
                String string = this.t.currentTokenValue;
                this.t.next();
                if (string == "text") {
                    locationPathPattern.nodeType = 9999;
                } else if (string == "node") {
                    locationPathPattern.nodeType = 2;
                } else if (string == "comment") {
                    locationPathPattern.nodeType = 9999;
                } else if (string == "processing-instruction") {
                    locationPathPattern.nodeType = 9999;
                    if (this.t.currentToken == 3) {
                        this.t.next();
                    }
                }
                this.expect(10);
            } else {
                this.grumble("@ in pattern not followed by NameTest or NodeTest");
            }
            this.t.next();
            this.parseFilters(locationPathPattern);
            return locationPathPattern;
        }
        this.grumble("Axis in pattern must be child or attribute");
        return null;
    }

    private void parseFilters(LocationPathPattern locationPathPattern) throws SAXException {
        while (this.t.currentToken == 7) {
            this.t.next();
            Expression expression = this.parseExpression();
            this.expect(8);
            this.t.next();
            locationPathPattern.addFilter(expression);
            if (!expression.usesCurrent()) continue;
            this.grumble("The current() function may not be used in a pattern");
        }
    }
}

