/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.DOMDriver;
import com.icl.saxon.ExtendedInputSource;
import com.icl.saxon.Loader;
import com.icl.saxon.PIGrabber;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.ParserManager;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.StandardURIResolver;
import com.icl.saxon.Version;
import com.icl.saxon.expr.AnyNameTest;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.style.StyleNodeFactory;
import com.icl.saxon.trace.SimpleTraceListener;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.trax.Processor;
import com.icl.saxon.trax.ProcessorException;
import com.icl.saxon.trax.Templates;
import com.icl.saxon.trax.TemplatesBuilder;
import com.icl.saxon.trax.TransformException;
import com.icl.saxon.trax.URIResolver;
import com.icl.saxon.tree.Builder;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.Stripper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class StyleSheet
extends Processor {
    protected String sourceParserName = null;
    protected String styleParserName = null;
    protected XMLReader sourceParser = null;
    protected XMLReader styleParser = null;
    protected URIResolver sourceURIResolver = null;
    protected URIResolver styleURIResolver = null;
    protected Emitter messageEmitter = null;
    protected TraceListener traceListener = null;
    boolean showTime = false;
    boolean lineNumbering = false;
    int repeat = 1;
    int recoveryPolicy = 1;

    public static void main(String[] stringArray) throws Exception {
        new StyleSheet().doMain(stringArray, new StyleSheet(), " java com.icl.saxon.StyleSheet");
    }

    protected void doMain(String[] stringArray, StyleSheet styleSheet, String string) {
        block59: {
            String string2 = null;
            String string3 = null;
            File file = null;
            Object var7_7 = null;
            File file2 = null;
            boolean bl = false;
            ParameterSet parameterSet = new ParameterSet();
            OutputDetails outputDetails = new OutputDetails();
            String string4 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                Object object;
                Object object2;
                int n = 0;
                while (true) {
                    if (n >= stringArray.length) {
                        this.badUsage(string, "No source file name");
                    }
                    if (stringArray[n].charAt(0) != '-') break;
                    if (stringArray[n].equals("-a")) {
                        bl2 = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-l")) {
                        this.lineNumbering = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-u")) {
                        bl = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-t")) {
                        System.err.println(Version.getProductName());
                        System.err.println("Java version " + System.getProperty("java.version"));
                        Loader.setTracing(true);
                        this.showTime = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-3")) {
                        ++n;
                        this.repeat = 3;
                        continue;
                    }
                    if (stringArray[n].equals("-o")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No output file name");
                        }
                        string4 = stringArray[n++];
                        continue;
                    }
                    if (stringArray[n].equals("-x")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No source parser class");
                        }
                        this.sourceParserName = stringArray[n++];
                        this.sourceParser = ParserManager.makeParser(this.sourceParserName);
                        continue;
                    }
                    if (stringArray[n].equals("-y")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No style parser class");
                        }
                        this.styleParserName = stringArray[n++];
                        this.styleParser = ParserManager.makeParser(this.styleParserName);
                        continue;
                    }
                    if (stringArray[n].equals("-r")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No URIResolver class");
                        }
                        String string5 = stringArray[n++];
                        this.sourceURIResolver = StyleSheet.makeURIResolver(string5);
                        this.styleURIResolver = StyleSheet.makeURIResolver(string5);
                        continue;
                    }
                    if (stringArray[n].equals("-T")) {
                        ++n;
                        this.lineNumbering = true;
                        this.traceListener = new SimpleTraceListener();
                        continue;
                    }
                    if (stringArray[n].equals("-TL")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No TraceListener class");
                        }
                        this.lineNumbering = true;
                        this.traceListener = StyleSheet.makeTraceListener(stringArray[n++]);
                        continue;
                    }
                    if (stringArray[n].equals("-w0")) {
                        ++n;
                        this.recoveryPolicy = 0;
                        continue;
                    }
                    if (stringArray[n].equals("-w1")) {
                        ++n;
                        this.recoveryPolicy = 1;
                        continue;
                    }
                    if (stringArray[n].equals("-w2")) {
                        ++n;
                        this.recoveryPolicy = 2;
                        continue;
                    }
                    if (stringArray[n].equals("-m")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No message Emitter class");
                        }
                        this.messageEmitter = StyleSheet.makeMessageEmitter(stringArray[n++]);
                        continue;
                    }
                    this.badUsage(string, "Unknown option " + stringArray[n]);
                }
                if (stringArray.length < n + 1) {
                    this.badUsage(string, "No source file name");
                }
                string2 = stringArray[n++];
                if (!bl2) {
                    if (stringArray.length < n + 1) {
                        this.badUsage(string, "No stylesheet file name");
                    }
                    string3 = stringArray[n++];
                }
                int n2 = n;
                while (n2 < stringArray.length) {
                    object2 = stringArray[n2];
                    int n3 = ((String)object2).indexOf("=");
                    if (n3 < 1 || n3 >= ((String)object2).length() - 1) {
                        this.badUsage(string, "Bad param=value pair on command line");
                    }
                    parameterSet.put(((String)object2).substring(0, n3).intern(), new StringValue(((String)object2).substring(n3 + 1)));
                    ++n2;
                }
                if (this.sourceURIResolver == null) {
                    this.sourceURIResolver = new StandardURIResolver();
                    ((StandardURIResolver)this.sourceURIResolver).setParserClass(this.sourceParserName);
                }
                if (this.styleURIResolver == null) {
                    this.styleURIResolver = new StandardURIResolver();
                    ((StandardURIResolver)this.styleURIResolver).setParserClass(this.styleParserName);
                }
                object2 = null;
                if (bl || string2.startsWith("http:") || string2.startsWith("file:")) {
                    XMLReader xMLReader;
                    this.sourceURIResolver.setURI(null, string2);
                    object2 = this.sourceURIResolver.getInputSource();
                    if (object2 == null) {
                        StyleSheet.quit("URIResolver for source file must return a SAX InputSource");
                    }
                    if ((xMLReader = this.sourceURIResolver.getXMLReader()) != null) {
                        this.sourceParser = xMLReader;
                    }
                } else {
                    file = new File(string2);
                    if (!file.exists()) {
                        StyleSheet.quit("Source file " + file + " does not exist");
                    }
                    if (file.isDirectory()) {
                        bl3 = true;
                        if (string4 == null) {
                            StyleSheet.quit("To process a directory, -o must be specified");
                        } else if (string4.equals(string2)) {
                            StyleSheet.quit("Output directory must be different from input");
                        } else {
                            file2 = new File(string4);
                            if (!file2.isDirectory()) {
                                StyleSheet.quit("Input is a directory, but output is not");
                            }
                        }
                    } else {
                        object2 = new ExtendedInputSource();
                        ((ExtendedInputSource)object2).setFile(file);
                        ((ExtendedInputSource)object2).setEstimatedLength((int)file.length());
                    }
                }
                if (string4 != null && !bl3 && (file2 = new File(string4)).isDirectory()) {
                    StyleSheet.quit("Output is a directory, but input is not");
                }
                if (bl2) {
                    if (bl3) {
                        this.processDirectoryAssoc(file, file2, parameterSet);
                    } else {
                        this.processFileAssoc((InputSource)object2, null, file2, parameterSet);
                    }
                    break block59;
                }
                long l = new Date().getTime();
                ExtendedInputSource extendedInputSource = new ExtendedInputSource();
                if (bl || string3.startsWith("http:") || string3.startsWith("file:")) {
                    XMLReader xMLReader;
                    this.styleURIResolver.setURI(null, string3);
                    object = this.styleURIResolver.getInputSource();
                    if (extendedInputSource == null) {
                        StyleSheet.quit("URIResolver for stylesheet file must return a SAX InputSource");
                    }
                    if ((xMLReader = this.styleURIResolver.getXMLReader()) != null) {
                        this.styleParser = xMLReader;
                    }
                    extendedInputSource = object instanceof ExtendedInputSource ? (ExtendedInputSource)object : new ExtendedInputSource((InputSource)object);
                } else {
                    object = new File(string3);
                    if (!((File)object).exists()) {
                        StyleSheet.quit("Stylesheet file " + object + " does not exist");
                    }
                    extendedInputSource.setFile((File)object);
                    extendedInputSource.setEstimatedLength((int)((File)object).length());
                }
                object = new PreparedStyleSheet();
                ((PreparedStyleSheet)object).setURIResolver(this.styleURIResolver);
                try {
                    ((PreparedStyleSheet)object).prepare(extendedInputSource);
                }
                catch (SAXException sAXException) {
                    System.err.println("Failed to compile style sheet");
                    throw sAXException;
                }
                if (this.showTime) {
                    long l2 = new Date().getTime();
                    System.err.println("Preparation time: " + (l2 - l) + " milliseconds");
                    l = l2;
                }
                if (bl3) {
                    this.processDirectory(file, (PreparedStyleSheet)object, file2, parameterSet);
                } else {
                    this.processFile((InputSource)object2, (PreparedStyleSheet)object, file2, parameterSet);
                }
            }
            catch (SAXException sAXException) {
                System.err.println(sAXException.getMessage());
                System.exit(2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.exit(0);
    }

    protected static void quit(String string) {
        System.err.println(string);
        System.exit(2);
    }

    public void processDirectoryAssoc(File file, File file2, ParameterSet parameterSet) throws Exception {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            try {
                File file3 = new File(file, stringArray[n]);
                if (!file3.isDirectory()) {
                    String string = file3.getName();
                    ExtendedInputSource extendedInputSource = new ExtendedInputSource(file3);
                    this.processFileAssoc(extendedInputSource, string, file2, parameterSet);
                }
            }
            catch (SAXException sAXException) {
                System.err.println(sAXException.getMessage());
            }
            ++n;
        }
    }

    private File makeOutputFile(File file, String string, PreparedStyleSheet preparedStyleSheet) throws SAXException {
        String string2 = preparedStyleSheet.getMediaType();
        String string3 = ".xml";
        if (string2.equals("text/html")) {
            string3 = ".html";
        } else if (string2.equals("text/plain")) {
            string3 = ".txt";
        }
        String string4 = string;
        if (string.endsWith(".xml") || string.endsWith(".XML")) {
            string4 = string.substring(0, string.length() - 4);
        }
        return new File(file, string4 + string3);
    }

    public void processFileAssoc(InputSource inputSource, String string, File file, ParameterSet parameterSet) throws Exception {
        Object object;
        if (this.showTime) {
            System.err.println("Processing " + inputSource.getSystemId());
        }
        long l = new Date().getTime();
        DocumentImpl documentImpl = null;
        PreparedStyleSheet preparedStyleSheet = null;
        File file2 = file;
        Builder builder = new Builder();
        builder.setLineNumbering(this.lineNumbering);
        documentImpl = builder.build(inputSource);
        String[] stringArray = documentImpl.getAssociatedStylesheets(null, null);
        if (stringArray == null || stringArray.length == 0) {
            throw new SAXException("No xml-stylesheet processing instruction was found");
        }
        if (stringArray.length > 1) {
            throw new SAXException("More than one xml-stylesheet processing instruction was found");
        }
        String string2 = stringArray[0];
        if (string2.charAt(0) == '#') {
            object = string2.substring(1);
            preparedStyleSheet = documentImpl.getEmbeddedStylesheet((String)object);
            if (preparedStyleSheet == null) {
                throw new SAXException("No stylesheet with id=#" + (String)object + " was found");
            }
        } else {
            Object object2;
            try {
                object2 = new URL(new URL(documentImpl.getSystemId()), string2);
                object = ((URL)object2).toString();
            }
            catch (MalformedURLException malformedURLException) {
                throw new SAXException(malformedURLException);
            }
            object2 = new ExtendedInputSource();
            ((InputSource)object2).setSystemId((String)object);
            preparedStyleSheet = new PreparedStyleSheet();
            preparedStyleSheet.setXMLReader(this.styleParser);
            preparedStyleSheet.setURIResolver(this.styleURIResolver);
            preparedStyleSheet.prepare((InputSource)object2);
        }
        object = (Controller)preparedStyleSheet.newTransformer();
        if (file2 != null && file2.isDirectory()) {
            file2 = this.makeOutputFile(file2, string, preparedStyleSheet);
        }
        ((Controller)object).setXMLReader(this.sourceParser);
        ((Controller)object).setURIResolver(this.sourceURIResolver);
        ((Controller)object).setOutputDetails(this.makeDetails(preparedStyleSheet.getOutputDetails(), file2));
        ((Controller)object).setMessageEmitter(this.messageEmitter);
        ((Controller)object).setLineNumbering(this.lineNumbering);
        ((Controller)object).setRecoveryPolicy(this.recoveryPolicy);
        ((Controller)object).setParams(parameterSet);
        ((Controller)object).strip(documentImpl);
        if (this.traceListener != null) {
            ((Controller)object).addTraceListener(this.traceListener);
        }
        ((Controller)object).transformDocument(documentImpl);
        if (this.showTime) {
            long l2 = new Date().getTime();
            System.err.println("Execution time: " + (l2 - l) + " milliseconds");
            l = l2;
        }
    }

    public void processDirectory(File file, PreparedStyleSheet preparedStyleSheet, File file2, ParameterSet parameterSet) throws Exception {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            try {
                File file3 = new File(file, stringArray[n]);
                if (!file3.isDirectory()) {
                    String string = file3.getName();
                    File file4 = this.makeOutputFile(file2, string, preparedStyleSheet);
                    ExtendedInputSource extendedInputSource = new ExtendedInputSource(file3);
                    this.processFile(extendedInputSource, preparedStyleSheet, file4, parameterSet);
                }
            }
            catch (SAXException sAXException) {
                System.err.println(sAXException.getMessage());
            }
            ++n;
        }
    }

    public void processFile(InputSource inputSource, PreparedStyleSheet preparedStyleSheet, File file, ParameterSet parameterSet) throws Exception {
        int n = 0;
        while (n < this.repeat) {
            if (this.showTime) {
                System.err.println("Processing " + inputSource.getSystemId());
            }
            long l = new Date().getTime();
            Controller controller = (Controller)preparedStyleSheet.newTransformer();
            controller.setXMLReader(this.sourceParser);
            controller.setURIResolver(this.sourceURIResolver);
            controller.setOutputDetails(this.makeDetails(preparedStyleSheet.getOutputDetails(), file));
            controller.setMessageEmitter(this.messageEmitter);
            controller.setLineNumbering(this.lineNumbering);
            controller.setRecoveryPolicy(this.recoveryPolicy);
            if (this.traceListener != null) {
                controller.addTraceListener(this.traceListener);
            }
            controller.setParams(parameterSet);
            controller.transform(inputSource);
            if (this.showTime) {
                long l2 = new Date().getTime();
                System.err.println("Execution time: " + (l2 - l) + " milliseconds");
                l = l2;
            }
            ++n;
        }
    }

    private OutputDetails makeDetails(OutputDetails outputDetails, File file) throws SAXException {
        if (file != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                outputDetails.setOutputStream(fileOutputStream);
            }
            catch (IOException iOException) {
                System.err.println("Cannot write to file " + file);
                throw new SAXException(iOException);
            }
        }
        return outputDetails;
    }

    protected void badUsage(String string, String string2) {
        System.err.println(string2);
        System.err.println(Version.getProductName());
        System.err.println("Usage: " + string + " [options] source-doc style-doc {param=value}...");
        System.err.println("Options: ");
        System.err.println("  -a              Use xml-stylesheet PI, not style-doc argument ");
        System.err.println("  -o filename     Send output to named file or directory ");
        System.err.println("  -m classname    Use specified Emitter class for xsl:message output ");
        System.err.println("  -r classname    Use specified URIResolver class ");
        System.err.println("  -t              Display version and timing information ");
        System.err.println("  -T              Set standard TraceListener");
        System.err.println("  -TL classname   Set a specific TraceListener");
        System.err.println("  -u              Names are URLs not filenames ");
        System.err.println("  -x classname    Use specified SAX parser for source file ");
        System.err.println("  -y classname    Use specified SAX parser for stylesheet ");
        System.err.println("  -?              Display this message ");
        System.exit(2);
    }

    public static URIResolver makeURIResolver(String string) throws SAXException {
        Object object = Loader.getInstance(string);
        if (object instanceof URIResolver) {
            return (URIResolver)object;
        }
        throw new SAXException("Class " + string + " is not a URIResolver");
    }

    public static TraceListener makeTraceListener(String string) throws SAXException {
        Object object = Loader.getInstance(string);
        if (object instanceof TraceListener) {
            return (TraceListener)object;
        }
        throw new SAXException("Class " + string + " is not a TraceListener");
    }

    public static Emitter makeMessageEmitter(String string) throws SAXException {
        Object object = Loader.getInstance(string);
        if (object instanceof Emitter) {
            return (Emitter)object;
        }
        throw new SAXException("Class " + string + " is not an Emitter");
    }

    public Templates process(InputSource inputSource) throws ProcessorException {
        try {
            PreparedStyleSheet preparedStyleSheet = new PreparedStyleSheet();
            preparedStyleSheet.setXMLReader(this.styleParser);
            preparedStyleSheet.prepare(inputSource);
            return preparedStyleSheet;
        }
        catch (SAXException sAXException) {
            throw new ProcessorException(sAXException.getMessage(), sAXException);
        }
    }

    public Templates processFromNode(Node node) throws ProcessorException {
        try {
            DOMDriver dOMDriver = new DOMDriver();
            dOMDriver.setStartNode(node);
            this.styleParser = dOMDriver;
            InputSource inputSource = new InputSource();
            return this.process(inputSource);
        }
        catch (SAXException sAXException) {
            throw new ProcessorException(sAXException);
        }
    }

    public Templates processMultiple(InputSource[] inputSourceArray) throws ProcessorException {
        if (inputSourceArray.length == 1) {
            return this.process(inputSourceArray[0]);
        }
        if (inputSourceArray.length == 0) {
            throw new ProcessorException("No stylesheets were supplied", new SAXException("No stylesheets were supplied"));
        }
        try {
            Builder builder = new Builder();
            builder.setSystemId("http://icl.com/saxon");
            builder.setNodeFactory(new StyleNodeFactory());
            builder.setLineNumbering(true);
            builder.startDocument();
            builder.startPrefixMapping("xsl", "http://www.w3.org/1999/XSL/Transform");
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "version", "version", "CDATA", "1.0");
            builder.startElement("http://www.w3.org/1999/XSL/Transform", "stylesheet", "xsl:stylesheet", attributesImpl);
            int n = 0;
            while (n < inputSourceArray.length) {
                attributesImpl.clear();
                attributesImpl.addAttribute("", "href", "href", "CDATA", inputSourceArray[n].getSystemId());
                builder.startElement("http://www.w3.org/1999/XSL/Transform", "import", "xsl:import", attributesImpl);
                builder.endElement("http://www.w3.org/1999/XSL/Transform", "import", "xsl:import");
                ++n;
            }
            builder.endElement("http://www.w3.org/1999/XSL/Transform", "stylesheet", "xsl:stylesheet");
            builder.endPrefixMapping("xsl");
            builder.endDocument();
            PreparedStyleSheet preparedStyleSheet = new PreparedStyleSheet();
            preparedStyleSheet.setStyleSheetDocument(builder.getCurrentDocument());
            return preparedStyleSheet;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new ProcessorException("Failed to combine multiple stylesheets: " + sAXException.getMessage(), sAXException);
        }
    }

    public InputSource[] getAssociatedStylesheets(InputSource inputSource, String string, String string2, String string3) throws ProcessorException {
        PIGrabber pIGrabber;
        block8: {
            pIGrabber = new PIGrabber();
            pIGrabber.setCriteria(string, string2, string3);
            pIGrabber.setBaseURI(inputSource.getSystemId());
            XMLReader xMLReader = this.sourceParser;
            if (xMLReader == null) {
                xMLReader = this.styleParser;
            }
            if (xMLReader == null) {
                try {
                    xMLReader = ParserManager.makeParser();
                }
                catch (SAXException sAXException) {
                    throw new ProcessorException(sAXException);
                }
            }
            xMLReader.setContentHandler(pIGrabber);
            try {
                xMLReader.parse(inputSource);
            }
            catch (Exception exception) {
                if (exception instanceof SAXException && exception.getMessage().equals("#start#")) break block8;
                throw new ProcessorException("Failed while looking for xml-stylesheet PI", exception);
            }
        }
        try {
            return pIGrabber.getAssociatedStylesheets();
        }
        catch (SAXException sAXException) {
            throw new ProcessorException(sAXException.getMessage());
        }
    }

    public TemplatesBuilder getTemplatesBuilder() throws ProcessorException {
        return new StyleSheetBuilder();
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.styleParser = xMLReader;
    }

    public XMLReader getXMLReader() {
        return this.styleParser;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/trax/features/dom/input")) {
            return true;
        }
        if (string.equals("http://xml.org/trax/features/sax/input")) {
            return true;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/trax/features/dom/input")) {
            if (!bl) {
                throw new SAXNotSupportedException(string);
            }
        } else if (string.equals("http://xml.org/trax/features/sax/input")) {
            if (!bl) {
                throw new SAXNotSupportedException(string);
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
    }

    private class StyleSheetBuilder
    extends Builder
    implements TemplatesBuilder {
        public StyleSheetBuilder() {
            Stripper stripper = new Stripper();
            stripper.setPreserveSpace(new AnyNameTest(), false);
            stripper.setPreserveSpace(Name.reconstruct("xsl", "http://www.w3.org/1999/XSL/Transform", "text"), true);
            this.setStripper(stripper);
            this.setNodeFactory(new StyleNodeFactory());
            this.setDiscardCommentsAndPIs(true);
            this.setLineNumbering(true);
        }

        public Templates getTemplates() throws TransformException {
            try {
                PreparedStyleSheet preparedStyleSheet = new PreparedStyleSheet();
                preparedStyleSheet.setStyleSheetDocument(this.getCurrentDocument());
                return preparedStyleSheet;
            }
            catch (SAXException sAXException) {
                throw new TransformException(sAXException);
            }
        }

        public void setBaseID(String string) {
            this.setSystemId(string);
        }
    }
}

