/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Version;
import org.xml.sax.SAXException;

public class Loader {
    private static boolean tracing = false;

    public static synchronized void setTracing(boolean bl) {
        tracing = bl;
    }

    public static Class getClass(String string) throws SAXException {
        if (tracing) {
            System.err.println("Loading " + string);
        }
        if (Version.isPreJDK12()) {
            try {
                return Class.forName(string);
            }
            catch (Exception exception) {
                if (tracing) {
                    System.err.println("Failed to load " + string + ": " + exception.getMessage());
                }
                throw new SAXException("Failed to load " + string, exception);
            }
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (Exception exception) {
            if (tracing) {
                System.err.println("Failed to load " + string + ": " + exception.getMessage());
            }
            throw new SAXException("Failed to load " + string, exception);
        }
    }

    public static Object getInstance(String string) throws SAXException {
        try {
            return Loader.getClass(string).newInstance();
        }
        catch (Exception exception) {
            if (tracing) {
                System.err.println("Failed to instantiate " + string + ": " + exception.getMessage());
            }
            throw new SAXException("Failed to instantiate class " + string, exception);
        }
    }
}

