/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.KeyDefinition;
import com.icl.saxon.axis.AttributeEnumeration;
import com.icl.saxon.expr.AnyNameTest;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXException;

public class KeyManager {
    private Hashtable keyList = new Hashtable();
    private Hashtable documents = new Hashtable();
    private static Vector emptyVector = new Vector();

    public void setKeyDefinition(KeyDefinition keyDefinition) {
        String string = keyDefinition.getName();
        Vector<KeyDefinition> vector = (Vector<KeyDefinition>)this.keyList.get(string);
        if (vector == null) {
            vector = new Vector<KeyDefinition>();
            this.keyList.put(string, vector);
        }
        vector.addElement(keyDefinition);
    }

    public Vector getKeyDefinitions(String string) {
        return (Vector)this.keyList.get(string);
    }

    private synchronized Hashtable getIndex(String string, DocumentInfo documentInfo, Controller controller) throws SAXException {
        Object v;
        Vector vector = this.getKeyDefinitions(string);
        if (vector == null) {
            throw new SAXException("Key " + string + " has not been defined");
        }
        Hashtable<String, Object> hashtable = (Hashtable<String, Object>)this.documents.get(documentInfo);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
            this.documents.put(documentInfo, hashtable);
        }
        if ((v = hashtable.get(string)) != null) {
            if (v instanceof Hashtable) {
                return (Hashtable)v;
            }
            throw new SAXException("Circular definition of key " + string);
        }
        hashtable.put(string, "Under construction");
        Hashtable hashtable2 = new Hashtable();
        int n = 0;
        while (n < vector.size()) {
            this.constructIndex(documentInfo, hashtable2, (KeyDefinition)vector.elementAt(n), controller);
            ++n;
        }
        hashtable.put(string, hashtable2);
        return hashtable2;
    }

    private void constructIndex(DocumentInfo documentInfo, Hashtable hashtable, KeyDefinition keyDefinition, Controller controller) throws SAXException {
        DocumentInfo documentInfo2;
        Pattern pattern = keyDefinition.getMatch();
        Expression expression = keyDefinition.getUse();
        int n = pattern.getType();
        NodeInfo nodeInfo = documentInfo2 = documentInfo;
        Context context = controller.makeContext(documentInfo);
        while (nodeInfo != null) {
            if (n == 2 && nodeInfo instanceof ElementInfo) {
                AttributeEnumeration attributeEnumeration = new AttributeEnumeration(nodeInfo, 2, new AnyNameTest());
                while (attributeEnumeration.hasMoreElements()) {
                    this.processKeyNode(attributeEnumeration.nextElement(), pattern, expression, hashtable, context);
                }
            } else {
                this.processKeyNode(nodeInfo, pattern, expression, hashtable, context);
            }
            nodeInfo = nodeInfo.getNextInDocument(documentInfo2);
        }
    }

    private void processKeyNode(NodeInfo nodeInfo, Pattern pattern, Expression expression, Hashtable hashtable, Context context) throws SAXException {
        if (pattern.matches(nodeInfo, context)) {
            context.setContextNode(nodeInfo);
            context.setPosition(1);
            context.setLast(1);
            Value value = expression.evaluate(context);
            if (value instanceof NodeSetValue) {
                Vector vector = ((NodeSetValue)value).getVector();
                int n = 0;
                while (n < vector.size()) {
                    NodeInfo nodeInfo2 = (NodeInfo)vector.elementAt(n);
                    String string = nodeInfo2.getValue();
                    Vector<NodeInfo> vector2 = (Vector<NodeInfo>)hashtable.get(string);
                    if (vector2 == null) {
                        vector2 = new Vector<NodeInfo>();
                    }
                    if (vector2.size() == 0 || vector2.elementAt(vector2.size() - 1) != nodeInfo) {
                        vector2.addElement(nodeInfo);
                        hashtable.put(string, vector2);
                    }
                    ++n;
                }
            } else {
                String string = value.asString();
                Vector<NodeInfo> vector = (Vector<NodeInfo>)hashtable.get(string);
                if (vector == null) {
                    vector = new Vector<NodeInfo>();
                }
                vector.addElement(nodeInfo);
                hashtable.put(string, vector);
            }
        }
    }

    public Vector selectByKey(String string, DocumentInfo documentInfo, String string2, Controller controller) throws SAXException {
        Hashtable hashtable = this.getIndex(string, documentInfo, controller);
        Vector vector = (Vector)hashtable.get(string2);
        return vector == null ? emptyVector : vector;
    }
}

