/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ExtendedInputSource
extends InputSource {
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;
    private XMLReader xmlReader;
    private int estimatedLength = -1;

    public ExtendedInputSource() {
    }

    public ExtendedInputSource(String string) {
        super(string);
    }

    public ExtendedInputSource(Reader reader) {
        super(reader);
    }

    public ExtendedInputSource(InputStream inputStream) {
        super(inputStream);
    }

    public ExtendedInputSource(File file) {
        this.setFile(file);
    }

    public ExtendedInputSource(InputSource inputSource) {
        this.setSystemId(inputSource.getSystemId());
        this.setPublicId(inputSource.getPublicId());
        this.setByteStream(inputSource.getByteStream());
        this.setEncoding(inputSource.getEncoding());
        this.setCharacterStream(inputSource.getCharacterStream());
    }

    public void setFile(File file) {
        super.setSystemId(ExtendedInputSource.CreateURL(file));
    }

    public void setEstimatedLength(int n) {
        this.estimatedLength = n;
    }

    public int getEstimatedLength() {
        return this.estimatedLength;
    }

    private static String CreateURL(File file) {
        String string = file.getAbsolutePath();
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                String string2 = System.getProperty("file.separator");
                if (string2.length() == 1) {
                    char c = string2.charAt(0);
                    if (c != '/') {
                        string = string.replace(c, '/');
                    }
                    if (string.charAt(0) != '/') {
                        string = '/' + string;
                    }
                }
                string = "file://" + string;
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
        return uRL.toString();
    }
}

