/*
 * Copyright 1996, 1997, 1998, 1999 by Daniel B. Suthers,
 * Pleasanton Ca. 94588 USA
 * E-MAIL dbs@tanj.com
 *
 * You may freely copy, use, and distribute this software,
 * in whole or in part, subject to the following restrictions:
 *
 *  1)  You may not charge money for it.
 *  2)  You may not remove or alter this copyright notice.
 *  3)  You may not claim you wrote it.
 *  4)  If you make improvements (or other changes), you are requested
 *      to send them to me, so there's a focal point for distributing
 *      improved versions.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "x10.h"

#ifdef        SCO
#define _SVID3 /* required for correct termio handling */
#undef  _IBCS2 /* conflicts with SVID3  */
#endif

#include <time.h>
#include <unistd.h>

#ifdef LINUX
#include <asm/ioctls.h>
#include <linux/serial_reg.h>
#include <linux/serial.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <syslog.h>
#else
#    if (defined(POSIX) || defined(FREEBSD) )
#include <sys/termios.h>
#    else
#         ifdef SCO
#include <sys/termio.h>
#         else
#include <termio.h>
#         endif
#    endif
#include <sys/ioctl.h>
#endif

#ifdef OSF
#include <sys/ioctl.h>
#endif

extern int verbose;
extern int sptty;
extern int lockpid(), ttylock(), munlock();
extern int i_am_relay;


/* This process echoes all strings to the spool file as well as
 * sending them to the CM11A's tty port
 */
int xwrite( tty, buf, size)
int tty;
char *buf;
int size;
{
    char lbuf[160];
    unsigned int ri_stat;
    int max = 0;
    extern int lock_for_write();

    lbuf[1] = lbuf[2] = lbuf[0] = 0xff;
    lbuf[3] = size;
    write( sptty, lbuf , 4);
    write( sptty, buf, size); 


    ri_stat = 0;
    while ( (ri_stat != 6) && (max++ < 5000) )
	ioctl(tty, TIOCMGET, &ri_stat);
    if( max == 5000 )
    {
	if (verbose && (! i_am_relay) )
	    fprintf(stdout, "xwrite() ri_stat == 6!\n" );
	max = -1;
    }
    else
    {
	if (verbose && (! i_am_relay) )
	    fprintf(stdout, "xwrite() called, count=%d\n", size );

    max = write( tty, buf, size);
    }
    return(max);
} 

