(***************************************************)
(* The Harmony Project                             *)
(* harmony@lists.seas.upenn.edu                    *)
(*                                                 *)
(* name.mli - interface for names                  *)
(***************************************************)
(* $Id: name.mli 359 2005-06-13 21:10:19Z bcpierce $ *)

(** Names (which label edges in trees) *)

type t = string
(** A name is just a string *)

module Set : Set.S with type elt = t
  (** Sets of names *)

module Map : Mapplus.SMap with type key_t = t and type key_set = Set.t
  (** Finite maps with names as keys *)
  
module Hash : Hashtbl.S with type key = t
  (** Hashtables with names as keys *)
