#include        "ksc.h"

/* KSC5601 -> Unicode 2.0 mapping table, compressed for the 94*94 codeset. */
/* Generated based on  KSC5601.txt at 
   ftp://ftp.unicode.org/Public/MAPPINGS/EASTASIA/KSC  */
/* 
 * Unlike kuten-table, needed offset is 33 (0x21) instead of
 * 32 for 7-bit portion of each byte.  i.e., a Unicode
 * codepoint for KSC's codepoint (n, m) would be found at
 * index (n-33)*94+m-33.
 */
long tabksc5601[] = {
/* KSC 5601 -> Unicode mapping table; max codepoint = 0x7d7e */
       0x3000,0x3001,0x3002,0x00B7,0x2025,0x2026,0x00A8,
0x3003,0x00AD,0x2015,0x2225,0xFF3C,0x223C,0x2018,0x2019,
0x201C,0x201D,0x3014,0x3015,0x3008,0x3009,0x300A,0x300B,
0x300C,0x300D,0x300E,0x300F,0x3010,0x3011,0x00B1,0x00D7,
0x00F7,0x2260,0x2264,0x2265,0x221E,0x2234,0x00B0,0x2032,
0x2033,0x2103,0x212B,0xFFE0,0xFFE1,0xFFE5,0x2642,0x2640,
0x2220,0x22A5,0x2312,0x2202,0x2207,0x2261,0x2252,0x00A7,
0x203B,0x2606,0x2605,0x25CB,0x25CF,0x25CE,0x25C7,0x25C6,
0x25A1,0x25A0,0x25B3,0x25B2,0x25BD,0x25BC,0x2192,0x2190,
0x2191,0x2193,0x2194,0x3013,0x226A,0x226B,0x221A,0x223D,
0x221D,0x2235,0x222B,0x222C,0x2208,0x220B,0x2286,0x2287,
0x2282,0x2283,0x222A,0x2229,0x2227,0x2228,0xFFE2,
       0x21D2,0x21D4,0x2200,0x2203,0x00B4,0xFF5E,0x02C7,
0x02D8,0x02DD,0x02DA,0x02D9,0x00B8,0x02DB,0x00A1,0x00BF,
0x02D0,0x222E,0x2211,0x220F,0x00A4,0x2109,0x2030,0x25C1,
0x25C0,0x25B7,0x25B6,0x2664,0x2660,0x2661,0x2665,0x2667,
0x2663,0x2299,0x25C8,0x25A3,0x25D0,0x25D1,0x2592,0x25A4,
0x25A5,0x25A8,0x25A7,0x25A6,0x25A9,0x2668,0x260F,0x260E,
0x261C,0x261E,0x00B6,0x2020,0x2021,0x2195,0x2197,0x2199,
0x2196,0x2198,0x266D,0x2669,0x266A,0x266C,0x327F,0x321C,
0x2116,0x33C7,0x2122,0x33C2,0x33D8,0x2121,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       0xFF01,0xFF02,0xFF03,0xFF04,0xFF05,0xFF06,0xFF07,
0xFF08,0xFF09,0xFF0A,0xFF0B,0xFF0C,0xFF0D,0xFF0E,0xFF0F,
0xFF10,0xFF11,0xFF12,0xFF13,0xFF14,0xFF15,0xFF16,0xFF17,
0xFF18,0xFF19,0xFF1A,0xFF1B,0xFF1C,0xFF1D,0xFF1E,0xFF1F,
0xFF20,0xFF21,0xFF22,0xFF23,0xFF24,0xFF25,0xFF26,0xFF27,
0xFF28,0xFF29,0xFF2A,0xFF2B,0xFF2C,0xFF2D,0xFF2E,0xFF2F,
0xFF30,0xFF31,0xFF32,0xFF33,0xFF34,0xFF35,0xFF36,0xFF37,
0xFF38,0xFF39,0xFF3A,0xFF3B,0xFFE6,0xFF3D,0xFF3E,0xFF3F,
0xFF40,0xFF41,0xFF42,0xFF43,0xFF44,0xFF45,0xFF46,0xFF47,
0xFF48,0xFF49,0xFF4A,0xFF4B,0xFF4C,0xFF4D,0xFF4E,0xFF4F,
0xFF50,0xFF51,0xFF52,0xFF53,0xFF54,0xFF55,0xFF56,0xFF57,
0xFF58,0xFF59,0xFF5A,0xFF5B,0xFF5C,0xFF5D,0xFFE3,
       0x3131,0x3132,0x3133,0x3134,0x3135,0x3136,0x3137,
0x3138,0x3139,0x313A,0x313B,0x313C,0x313D,0x313E,0x313F,
0x3140,0x3141,0x3142,0x3143,0x3144,0x3145,0x3146,0x3147,
0x3148,0x3149,0x314A,0x314B,0x314C,0x314D,0x314E,0x314F,
0x3150,0x3151,0x3152,0x3153,0x3154,0x3155,0x3156,0x3157,
0x3158,0x3159,0x315A,0x315B,0x315C,0x315D,0x315E,0x315F,
0x3160,0x3161,0x3162,0x3163,0x3164,0x3165,0x3166,0x3167,
0x3168,0x3169,0x316A,0x316B,0x316C,0x316D,0x316E,0x316F,
0x3170,0x3171,0x3172,0x3173,0x3174,0x3175,0x3176,0x3177,
0x3178,0x3179,0x317A,0x317B,0x317C,0x317D,0x317E,0x317F,
0x3180,0x3181,0x3182,0x3183,0x3184,0x3185,0x3186,0x3187,
0x3188,0x3189,0x318A,0x318B,0x318C,0x318D,0x318E,
       0x2170,0x2171,0x2172,0x2173,0x2174,0x2175,0x2176,
0x2177,0x2178,0x2179,    -1,    -1,    -1,    -1,    -1,
0x2160,0x2161,0x2162,0x2163,0x2164,0x2165,0x2166,0x2167,
0x2168,0x2169,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,
0x0398,0x0399,0x039A,0x039B,0x039C,0x039D,0x039E,0x039F,
0x03A0,0x03A1,0x03A3,0x03A4,0x03A5,0x03A6,0x03A7,0x03A8,
0x03A9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,0x03B1,0x03B2,0x03B3,0x03B4,0x03B5,0x03B6,0x03B7,
0x03B8,0x03B9,0x03BA,0x03BB,0x03BC,0x03BD,0x03BE,0x03BF,
0x03C0,0x03C1,0x03C3,0x03C4,0x03C5,0x03C6,0x03C7,0x03C8,
0x03C9,    -1,    -1,    -1,    -1,    -1,    -1,
       0x2500,0x2502,0x250C,0x2510,0x2518,0x2514,0x251C,
0x252C,0x2524,0x2534,0x253C,0x2501,0x2503,0x250F,0x2513,
0x251B,0x2517,0x2523,0x2533,0x252B,0x253B,0x254B,0x2520,
0x252F,0x2528,0x2537,0x253F,0x251D,0x2530,0x2525,0x2538,
0x2542,0x2512,0x2511,0x251A,0x2519,0x2516,0x2515,0x250E,
0x250D,0x251E,0x251F,0x2521,0x2522,0x2526,0x2527,0x2529,
0x252A,0x252D,0x252E,0x2531,0x2532,0x2535,0x2536,0x2539,
0x253A,0x253D,0x253E,0x2540,0x2541,0x2543,0x2544,0x2545,
0x2546,0x2547,0x2548,0x2549,0x254A,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       0x3395,0x3396,0x3397,0x2113,0x3398,0x33C4,0x33A3,
0x33A4,0x33A5,0x33A6,0x3399,0x339A,0x339B,0x339C,0x339D,
0x339E,0x339F,0x33A0,0x33A1,0x33A2,0x33CA,0x338D,0x338E,
0x338F,0x33CF,0x3388,0x3389,0x33C8,0x33A7,0x33A8,0x33B0,
0x33B1,0x33B2,0x33B3,0x33B4,0x33B5,0x33B6,0x33B7,0x33B8,
0x33B9,0x3380,0x3381,0x3382,0x3383,0x3384,0x33BA,0x33BB,
0x33BC,0x33BD,0x33BE,0x33BF,0x3390,0x3391,0x3392,0x3393,
0x3394,0x2126,0x33C0,0x33C1,0x338A,0x338B,0x338C,0x33D6,
0x33C5,0x33AD,0x33AE,0x33AF,0x33DB,0x33A9,0x33AA,0x33AB,
0x33AC,0x33DD,0x33D0,0x33D3,0x33C3,0x33C9,0x33DC,0x33C6,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       0x00C6,0x00D0,0x00AA,0x0126,    -1,0x0132,    -1,
0x013F,0x0141,0x00D8,0x0152,0x00BA,0x00DE,0x0166,0x014A,
    -1,0x3260,0x3261,0x3262,0x3263,0x3264,0x3265,0x3266,
0x3267,0x3268,0x3269,0x326A,0x326B,0x326C,0x326D,0x326E,
0x326F,0x3270,0x3271,0x3272,0x3273,0x3274,0x3275,0x3276,
0x3277,0x3278,0x3279,0x327A,0x327B,0x24D0,0x24D1,0x24D2,
0x24D3,0x24D4,0x24D5,0x24D6,0x24D7,0x24D8,0x24D9,0x24DA,
0x24DB,0x24DC,0x24DD,0x24DE,0x24DF,0x24E0,0x24E1,0x24E2,
0x24E3,0x24E4,0x24E5,0x24E6,0x24E7,0x24E8,0x24E9,0x2460,
0x2461,0x2462,0x2463,0x2464,0x2465,0x2466,0x2467,0x2468,
0x2469,0x246A,0x246B,0x246C,0x246D,0x246E,0x00BD,0x2153,
0x2154,0x00BC,0x00BE,0x215B,0x215C,0x215D,0x215E,
       0x00E6,0x0111,0x00F0,0x0127,0x0131,0x0133,0x0138,
0x0140,0x0142,0x00F8,0x0153,0x00DF,0x00FE,0x0167,0x014B,
0x0149,0x3200,0x3201,0x3202,0x3203,0x3204,0x3205,0x3206,
0x3207,0x3208,0x3209,0x320A,0x320B,0x320C,0x320D,0x320E,
0x320F,0x3210,0x3211,0x3212,0x3213,0x3214,0x3215,0x3216,
0x3217,0x3218,0x3219,0x321A,0x321B,0x249C,0x249D,0x249E,
0x249F,0x24A0,0x24A1,0x24A2,0x24A3,0x24A4,0x24A5,0x24A6,
0x24A7,0x24A8,0x24A9,0x24AA,0x24AB,0x24AC,0x24AD,0x24AE,
0x24AF,0x24B0,0x24B1,0x24B2,0x24B3,0x24B4,0x24B5,0x2474,
0x2475,0x2476,0x2477,0x2478,0x2479,0x247A,0x247B,0x247C,
0x247D,0x247E,0x247F,0x2480,0x2481,0x2482,0x00B9,0x00B2,
0x00B3,0x2074,0x207F,0x2081,0x2082,0x2083,0x2084,
       0x3041,0x3042,0x3043,0x3044,0x3045,0x3046,0x3047,
0x3048,0x3049,0x304A,0x304B,0x304C,0x304D,0x304E,0x304F,
0x3050,0x3051,0x3052,0x3053,0x3054,0x3055,0x3056,0x3057,
0x3058,0x3059,0x305A,0x305B,0x305C,0x305D,0x305E,0x305F,
0x3060,0x3061,0x3062,0x3063,0x3064,0x3065,0x3066,0x3067,
0x3068,0x3069,0x306A,0x306B,0x306C,0x306D,0x306E,0x306F,
0x3070,0x3071,0x3072,0x3073,0x3074,0x3075,0x3076,0x3077,
0x3078,0x3079,0x307A,0x307B,0x307C,0x307D,0x307E,0x307F,
0x3080,0x3081,0x3082,0x3083,0x3084,0x3085,0x3086,0x3087,
0x3088,0x3089,0x308A,0x308B,0x308C,0x308D,0x308E,0x308F,
0x3090,0x3091,0x3092,0x3093,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       0x30A1,0x30A2,0x30A3,0x30A4,0x30A5,0x30A6,0x30A7,
0x30A8,0x30A9,0x30AA,0x30AB,0x30AC,0x30AD,0x30AE,0x30AF,
0x30B0,0x30B1,0x30B2,0x30B3,0x30B4,0x30B5,0x30B6,0x30B7,
0x30B8,0x30B9,0x30BA,0x30BB,0x30BC,0x30BD,0x30BE,0x30BF,
0x30C0,0x30C1,0x30C2,0x30C3,0x30C4,0x30C5,0x30C6,0x30C7,
0x30C8,0x30C9,0x30CA,0x30CB,0x30CC,0x30CD,0x30CE,0x30CF,
0x30D0,0x30D1,0x30D2,0x30D3,0x30D4,0x30D5,0x30D6,0x30D7,
0x30D8,0x30D9,0x30DA,0x30DB,0x30DC,0x30DD,0x30DE,0x30DF,
0x30E0,0x30E1,0x30E2,0x30E3,0x30E4,0x30E5,0x30E6,0x30E7,
0x30E8,0x30E9,0x30EA,0x30EB,0x30EC,0x30ED,0x30EE,0x30EF,
0x30F0,0x30F1,0x30F2,0x30F3,0x30F4,0x30F5,0x30F6,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,0x0401,
0x0416,0x0417,0x0418,0x0419,0x041A,0x041B,0x041C,0x041D,
0x041E,0x041F,0x0420,0x0421,0x0422,0x0423,0x0424,0x0425,
0x0426,0x0427,0x0428,0x0429,0x042A,0x042B,0x042C,0x042D,
0x042E,0x042F,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0451,
0x0436,0x0437,0x0438,0x0439,0x043A,0x043B,0x043C,0x043D,
0x043E,0x043F,0x0440,0x0441,0x0442,0x0443,0x0444,0x0445,
0x0446,0x0447,0x0448,0x0449,0x044A,0x044B,0x044C,0x044D,
0x044E,0x044F,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,
           -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,
           -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,
           -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       0xAC00,0xAC01,0xAC04,0xAC07,0xAC08,0xAC09,0xAC0A,
0xAC10,0xAC11,0xAC12,0xAC13,0xAC14,0xAC15,0xAC16,0xAC17,
0xAC19,0xAC1A,0xAC1B,0xAC1C,0xAC1D,0xAC20,0xAC24,0xAC2C,
0xAC2D,0xAC2F,0xAC30,0xAC31,0xAC38,0xAC39,0xAC3C,0xAC40,
0xAC4B,0xAC4D,0xAC54,0xAC58,0xAC5C,0xAC70,0xAC71,0xAC74,
0xAC77,0xAC78,0xAC7A,0xAC80,0xAC81,0xAC83,0xAC84,0xAC85,
0xAC86,0xAC89,0xAC8A,0xAC8B,0xAC8C,0xAC90,0xAC94,0xAC9C,
0xAC9D,0xAC9F,0xACA0,0xACA1,0xACA8,0xACA9,0xACAA,0xACAC,
0xACAF,0xACB0,0xACB8,0xACB9,0xACBB,0xACBC,0xACBD,0xACC1,
0xACC4,0xACC8,0xACCC,0xACD5,0xACD7,0xACE0,0xACE1,0xACE4,
0xACE7,0xACE8,0xACEA,0xACEC,0xACEF,0xACF0,0xACF1,0xACF3,
0xACF5,0xACF6,0xACFC,0xACFD,0xAD00,0xAD04,0xAD06,
       0xAD0C,0xAD0D,0xAD0F,0xAD11,0xAD18,0xAD1C,0xAD20,
0xAD29,0xAD2C,0xAD2D,0xAD34,0xAD35,0xAD38,0xAD3C,0xAD44,
0xAD45,0xAD47,0xAD49,0xAD50,0xAD54,0xAD58,0xAD61,0xAD63,
0xAD6C,0xAD6D,0xAD70,0xAD73,0xAD74,0xAD75,0xAD76,0xAD7B,
0xAD7C,0xAD7D,0xAD7F,0xAD81,0xAD82,0xAD88,0xAD89,0xAD8C,
0xAD90,0xAD9C,0xAD9D,0xADA4,0xADB7,0xADC0,0xADC1,0xADC4,
0xADC8,0xADD0,0xADD1,0xADD3,0xADDC,0xADE0,0xADE4,0xADF8,
0xADF9,0xADFC,0xADFF,0xAE00,0xAE01,0xAE08,0xAE09,0xAE0B,
0xAE0D,0xAE14,0xAE30,0xAE31,0xAE34,0xAE37,0xAE38,0xAE3A,
0xAE40,0xAE41,0xAE43,0xAE45,0xAE46,0xAE4A,0xAE4C,0xAE4D,
0xAE4E,0xAE50,0xAE54,0xAE56,0xAE5C,0xAE5D,0xAE5F,0xAE60,
0xAE61,0xAE65,0xAE68,0xAE69,0xAE6C,0xAE70,0xAE78,
       0xAE79,0xAE7B,0xAE7C,0xAE7D,0xAE84,0xAE85,0xAE8C,
0xAEBC,0xAEBD,0xAEBE,0xAEC0,0xAEC4,0xAECC,0xAECD,0xAECF,
0xAED0,0xAED1,0xAED8,0xAED9,0xAEDC,0xAEE8,0xAEEB,0xAEED,
0xAEF4,0xAEF8,0xAEFC,0xAF07,0xAF08,0xAF0D,0xAF10,0xAF2C,
0xAF2D,0xAF30,0xAF32,0xAF34,0xAF3C,0xAF3D,0xAF3F,0xAF41,
0xAF42,0xAF43,0xAF48,0xAF49,0xAF50,0xAF5C,0xAF5D,0xAF64,
0xAF65,0xAF79,0xAF80,0xAF84,0xAF88,0xAF90,0xAF91,0xAF95,
0xAF9C,0xAFB8,0xAFB9,0xAFBC,0xAFC0,0xAFC7,0xAFC8,0xAFC9,
0xAFCB,0xAFCD,0xAFCE,0xAFD4,0xAFDC,0xAFE8,0xAFE9,0xAFF0,
0xAFF1,0xAFF4,0xAFF8,0xB000,0xB001,0xB004,0xB00C,0xB010,
0xB014,0xB01C,0xB01D,0xB028,0xB044,0xB045,0xB048,0xB04A,
0xB04C,0xB04E,0xB053,0xB054,0xB055,0xB057,0xB059,
       0xB05D,0xB07C,0xB07D,0xB080,0xB084,0xB08C,0xB08D,
0xB08F,0xB091,0xB098,0xB099,0xB09A,0xB09C,0xB09F,0xB0A0,
0xB0A1,0xB0A2,0xB0A8,0xB0A9,0xB0AB,0xB0AC,0xB0AD,0xB0AE,
0xB0AF,0xB0B1,0xB0B3,0xB0B4,0xB0B5,0xB0B8,0xB0BC,0xB0C4,
0xB0C5,0xB0C7,0xB0C8,0xB0C9,0xB0D0,0xB0D1,0xB0D4,0xB0D8,
0xB0E0,0xB0E5,0xB108,0xB109,0xB10B,0xB10C,0xB110,0xB112,
0xB113,0xB118,0xB119,0xB11B,0xB11C,0xB11D,0xB123,0xB124,
0xB125,0xB128,0xB12C,0xB134,0xB135,0xB137,0xB138,0xB139,
0xB140,0xB141,0xB144,0xB148,0xB150,0xB151,0xB154,0xB155,
0xB158,0xB15C,0xB160,0xB178,0xB179,0xB17C,0xB180,0xB182,
0xB188,0xB189,0xB18B,0xB18D,0xB192,0xB193,0xB194,0xB198,
0xB19C,0xB1A8,0xB1CC,0xB1D0,0xB1D4,0xB1DC,0xB1DD,
       0xB1DF,0xB1E8,0xB1E9,0xB1EC,0xB1F0,0xB1F9,0xB1FB,
0xB1FD,0xB204,0xB205,0xB208,0xB20B,0xB20C,0xB214,0xB215,
0xB217,0xB219,0xB220,0xB234,0xB23C,0xB258,0xB25C,0xB260,
0xB268,0xB269,0xB274,0xB275,0xB27C,0xB284,0xB285,0xB289,
0xB290,0xB291,0xB294,0xB298,0xB299,0xB29A,0xB2A0,0xB2A1,
0xB2A3,0xB2A5,0xB2A6,0xB2AA,0xB2AC,0xB2B0,0xB2B4,0xB2C8,
0xB2C9,0xB2CC,0xB2D0,0xB2D2,0xB2D8,0xB2D9,0xB2DB,0xB2DD,
0xB2E2,0xB2E4,0xB2E5,0xB2E6,0xB2E8,0xB2EB,0xB2EC,0xB2ED,
0xB2EE,0xB2EF,0xB2F3,0xB2F4,0xB2F5,0xB2F7,0xB2F8,0xB2F9,
0xB2FA,0xB2FB,0xB2FF,0xB300,0xB301,0xB304,0xB308,0xB310,
0xB311,0xB313,0xB314,0xB315,0xB31C,0xB354,0xB355,0xB356,
0xB358,0xB35B,0xB35C,0xB35E,0xB35F,0xB364,0xB365,
       0xB367,0xB369,0xB36B,0xB36E,0xB370,0xB371,0xB374,
0xB378,0xB380,0xB381,0xB383,0xB384,0xB385,0xB38C,0xB390,
0xB394,0xB3A0,0xB3A1,0xB3A8,0xB3AC,0xB3C4,0xB3C5,0xB3C8,
0xB3CB,0xB3CC,0xB3CE,0xB3D0,0xB3D4,0xB3D5,0xB3D7,0xB3D9,
0xB3DB,0xB3DD,0xB3E0,0xB3E4,0xB3E8,0xB3FC,0xB410,0xB418,
0xB41C,0xB420,0xB428,0xB429,0xB42B,0xB434,0xB450,0xB451,
0xB454,0xB458,0xB460,0xB461,0xB463,0xB465,0xB46C,0xB480,
0xB488,0xB49D,0xB4A4,0xB4A8,0xB4AC,0xB4B5,0xB4B7,0xB4B9,
0xB4C0,0xB4C4,0xB4C8,0xB4D0,0xB4D5,0xB4DC,0xB4DD,0xB4E0,
0xB4E3,0xB4E4,0xB4E6,0xB4EC,0xB4ED,0xB4EF,0xB4F1,0xB4F8,
0xB514,0xB515,0xB518,0xB51B,0xB51C,0xB524,0xB525,0xB527,
0xB528,0xB529,0xB52A,0xB530,0xB531,0xB534,0xB538,
       0xB540,0xB541,0xB543,0xB544,0xB545,0xB54B,0xB54C,
0xB54D,0xB550,0xB554,0xB55C,0xB55D,0xB55F,0xB560,0xB561,
0xB5A0,0xB5A1,0xB5A4,0xB5A8,0xB5AA,0xB5AB,0xB5B0,0xB5B1,
0xB5B3,0xB5B4,0xB5B5,0xB5BB,0xB5BC,0xB5BD,0xB5C0,0xB5C4,
0xB5CC,0xB5CD,0xB5CF,0xB5D0,0xB5D1,0xB5D8,0xB5EC,0xB610,
0xB611,0xB614,0xB618,0xB625,0xB62C,0xB634,0xB648,0xB664,
0xB668,0xB69C,0xB69D,0xB6A0,0xB6A4,0xB6AB,0xB6AC,0xB6B1,
0xB6D4,0xB6F0,0xB6F4,0xB6F8,0xB700,0xB701,0xB705,0xB728,
0xB729,0xB72C,0xB72F,0xB730,0xB738,0xB739,0xB73B,0xB744,
0xB748,0xB74C,0xB754,0xB755,0xB760,0xB764,0xB768,0xB770,
0xB771,0xB773,0xB775,0xB77C,0xB77D,0xB780,0xB784,0xB78C,
0xB78D,0xB78F,0xB790,0xB791,0xB792,0xB796,0xB797,
       0xB798,0xB799,0xB79C,0xB7A0,0xB7A8,0xB7A9,0xB7AB,
0xB7AC,0xB7AD,0xB7B4,0xB7B5,0xB7B8,0xB7C7,0xB7C9,0xB7EC,
0xB7ED,0xB7F0,0xB7F4,0xB7FC,0xB7FD,0xB7FF,0xB800,0xB801,
0xB807,0xB808,0xB809,0xB80C,0xB810,0xB818,0xB819,0xB81B,
0xB81D,0xB824,0xB825,0xB828,0xB82C,0xB834,0xB835,0xB837,
0xB838,0xB839,0xB840,0xB844,0xB851,0xB853,0xB85C,0xB85D,
0xB860,0xB864,0xB86C,0xB86D,0xB86F,0xB871,0xB878,0xB87C,
0xB88D,0xB8A8,0xB8B0,0xB8B4,0xB8B8,0xB8C0,0xB8C1,0xB8C3,
0xB8C5,0xB8CC,0xB8D0,0xB8D4,0xB8DD,0xB8DF,0xB8E1,0xB8E8,
0xB8E9,0xB8EC,0xB8F0,0xB8F8,0xB8F9,0xB8FB,0xB8FD,0xB904,
0xB918,0xB920,0xB93C,0xB93D,0xB940,0xB944,0xB94C,0xB94F,
0xB951,0xB958,0xB959,0xB95C,0xB960,0xB968,0xB969,
       0xB96B,0xB96D,0xB974,0xB975,0xB978,0xB97C,0xB984,
0xB985,0xB987,0xB989,0xB98A,0xB98D,0xB98E,0xB9AC,0xB9AD,
0xB9B0,0xB9B4,0xB9BC,0xB9BD,0xB9BF,0xB9C1,0xB9C8,0xB9C9,
0xB9CC,0xB9CE,0xB9CF,0xB9D0,0xB9D1,0xB9D2,0xB9D8,0xB9D9,
0xB9DB,0xB9DD,0xB9DE,0xB9E1,0xB9E3,0xB9E4,0xB9E5,0xB9E8,
0xB9EC,0xB9F4,0xB9F5,0xB9F7,0xB9F8,0xB9F9,0xB9FA,0xBA00,
0xBA01,0xBA08,0xBA15,0xBA38,0xBA39,0xBA3C,0xBA40,0xBA42,
0xBA48,0xBA49,0xBA4B,0xBA4D,0xBA4E,0xBA53,0xBA54,0xBA55,
0xBA58,0xBA5C,0xBA64,0xBA65,0xBA67,0xBA68,0xBA69,0xBA70,
0xBA71,0xBA74,0xBA78,0xBA83,0xBA84,0xBA85,0xBA87,0xBA8C,
0xBAA8,0xBAA9,0xBAAB,0xBAAC,0xBAB0,0xBAB2,0xBAB8,0xBAB9,
0xBABB,0xBABD,0xBAC4,0xBAC8,0xBAD8,0xBAD9,0xBAFC,
       0xBB00,0xBB04,0xBB0D,0xBB0F,0xBB11,0xBB18,0xBB1C,
0xBB20,0xBB29,0xBB2B,0xBB34,0xBB35,0xBB36,0xBB38,0xBB3B,
0xBB3C,0xBB3D,0xBB3E,0xBB44,0xBB45,0xBB47,0xBB49,0xBB4D,
0xBB4F,0xBB50,0xBB54,0xBB58,0xBB61,0xBB63,0xBB6C,0xBB88,
0xBB8C,0xBB90,0xBBA4,0xBBA8,0xBBAC,0xBBB4,0xBBB7,0xBBC0,
0xBBC4,0xBBC8,0xBBD0,0xBBD3,0xBBF8,0xBBF9,0xBBFC,0xBBFF,
0xBC00,0xBC02,0xBC08,0xBC09,0xBC0B,0xBC0C,0xBC0D,0xBC0F,
0xBC11,0xBC14,0xBC15,0xBC16,0xBC17,0xBC18,0xBC1B,0xBC1C,
0xBC1D,0xBC1E,0xBC1F,0xBC24,0xBC25,0xBC27,0xBC29,0xBC2D,
0xBC30,0xBC31,0xBC34,0xBC38,0xBC40,0xBC41,0xBC43,0xBC44,
0xBC45,0xBC49,0xBC4C,0xBC4D,0xBC50,0xBC5D,0xBC84,0xBC85,
0xBC88,0xBC8B,0xBC8C,0xBC8E,0xBC94,0xBC95,0xBC97,
       0xBC99,0xBC9A,0xBCA0,0xBCA1,0xBCA4,0xBCA7,0xBCA8,
0xBCB0,0xBCB1,0xBCB3,0xBCB4,0xBCB5,0xBCBC,0xBCBD,0xBCC0,
0xBCC4,0xBCCD,0xBCCF,0xBCD0,0xBCD1,0xBCD5,0xBCD8,0xBCDC,
0xBCF4,0xBCF5,0xBCF6,0xBCF8,0xBCFC,0xBD04,0xBD05,0xBD07,
0xBD09,0xBD10,0xBD14,0xBD24,0xBD2C,0xBD40,0xBD48,0xBD49,
0xBD4C,0xBD50,0xBD58,0xBD59,0xBD64,0xBD68,0xBD80,0xBD81,
0xBD84,0xBD87,0xBD88,0xBD89,0xBD8A,0xBD90,0xBD91,0xBD93,
0xBD95,0xBD99,0xBD9A,0xBD9C,0xBDA4,0xBDB0,0xBDB8,0xBDD4,
0xBDD5,0xBDD8,0xBDDC,0xBDE9,0xBDF0,0xBDF4,0xBDF8,0xBE00,
0xBE03,0xBE05,0xBE0C,0xBE0D,0xBE10,0xBE14,0xBE1C,0xBE1D,
0xBE1F,0xBE44,0xBE45,0xBE48,0xBE4C,0xBE4E,0xBE54,0xBE55,
0xBE57,0xBE59,0xBE5A,0xBE5B,0xBE60,0xBE61,0xBE64,
       0xBE68,0xBE6A,0xBE70,0xBE71,0xBE73,0xBE74,0xBE75,
0xBE7B,0xBE7C,0xBE7D,0xBE80,0xBE84,0xBE8C,0xBE8D,0xBE8F,
0xBE90,0xBE91,0xBE98,0xBE99,0xBEA8,0xBED0,0xBED1,0xBED4,
0xBED7,0xBED8,0xBEE0,0xBEE3,0xBEE4,0xBEE5,0xBEEC,0xBF01,
0xBF08,0xBF09,0xBF18,0xBF19,0xBF1B,0xBF1C,0xBF1D,0xBF40,
0xBF41,0xBF44,0xBF48,0xBF50,0xBF51,0xBF55,0xBF94,0xBFB0,
0xBFC5,0xBFCC,0xBFCD,0xBFD0,0xBFD4,0xBFDC,0xBFDF,0xBFE1,
0xC03C,0xC051,0xC058,0xC05C,0xC060,0xC068,0xC069,0xC090,
0xC091,0xC094,0xC098,0xC0A0,0xC0A1,0xC0A3,0xC0A5,0xC0AC,
0xC0AD,0xC0AF,0xC0B0,0xC0B3,0xC0B4,0xC0B5,0xC0B6,0xC0BC,
0xC0BD,0xC0BF,0xC0C0,0xC0C1,0xC0C5,0xC0C8,0xC0C9,0xC0CC,
0xC0D0,0xC0D8,0xC0D9,0xC0DB,0xC0DC,0xC0DD,0xC0E4,
       0xC0E5,0xC0E8,0xC0EC,0xC0F4,0xC0F5,0xC0F7,0xC0F9,
0xC100,0xC104,0xC108,0xC110,0xC115,0xC11C,0xC11D,0xC11E,
0xC11F,0xC120,0xC123,0xC124,0xC126,0xC127,0xC12C,0xC12D,
0xC12F,0xC130,0xC131,0xC136,0xC138,0xC139,0xC13C,0xC140,
0xC148,0xC149,0xC14B,0xC14C,0xC14D,0xC154,0xC155,0xC158,
0xC15C,0xC164,0xC165,0xC167,0xC168,0xC169,0xC170,0xC174,
0xC178,0xC185,0xC18C,0xC18D,0xC18E,0xC190,0xC194,0xC196,
0xC19C,0xC19D,0xC19F,0xC1A1,0xC1A5,0xC1A8,0xC1A9,0xC1AC,
0xC1B0,0xC1BD,0xC1C4,0xC1C8,0xC1CC,0xC1D4,0xC1D7,0xC1D8,
0xC1E0,0xC1E4,0xC1E8,0xC1F0,0xC1F1,0xC1F3,0xC1FC,0xC1FD,
0xC200,0xC204,0xC20C,0xC20D,0xC20F,0xC211,0xC218,0xC219,
0xC21C,0xC21F,0xC220,0xC228,0xC229,0xC22B,0xC22D,
       0xC22F,0xC231,0xC232,0xC234,0xC248,0xC250,0xC251,
0xC254,0xC258,0xC260,0xC265,0xC26C,0xC26D,0xC270,0xC274,
0xC27C,0xC27D,0xC27F,0xC281,0xC288,0xC289,0xC290,0xC298,
0xC29B,0xC29D,0xC2A4,0xC2A5,0xC2A8,0xC2AC,0xC2AD,0xC2B4,
0xC2B5,0xC2B7,0xC2B9,0xC2DC,0xC2DD,0xC2E0,0xC2E3,0xC2E4,
0xC2EB,0xC2EC,0xC2ED,0xC2EF,0xC2F1,0xC2F6,0xC2F8,0xC2F9,
0xC2FB,0xC2FC,0xC300,0xC308,0xC309,0xC30C,0xC30D,0xC313,
0xC314,0xC315,0xC318,0xC31C,0xC324,0xC325,0xC328,0xC329,
0xC345,0xC368,0xC369,0xC36C,0xC370,0xC372,0xC378,0xC379,
0xC37C,0xC37D,0xC384,0xC388,0xC38C,0xC3C0,0xC3D8,0xC3D9,
0xC3DC,0xC3DF,0xC3E0,0xC3E2,0xC3E8,0xC3E9,0xC3ED,0xC3F4,
0xC3F5,0xC3F8,0xC408,0xC410,0xC424,0xC42C,0xC430,
       0xC434,0xC43C,0xC43D,0xC448,0xC464,0xC465,0xC468,
0xC46C,0xC474,0xC475,0xC479,0xC480,0xC494,0xC49C,0xC4B8,
0xC4BC,0xC4E9,0xC4F0,0xC4F1,0xC4F4,0xC4F8,0xC4FA,0xC4FF,
0xC500,0xC501,0xC50C,0xC510,0xC514,0xC51C,0xC528,0xC529,
0xC52C,0xC530,0xC538,0xC539,0xC53B,0xC53D,0xC544,0xC545,
0xC548,0xC549,0xC54A,0xC54C,0xC54D,0xC54E,0xC553,0xC554,
0xC555,0xC557,0xC558,0xC559,0xC55D,0xC55E,0xC560,0xC561,
0xC564,0xC568,0xC570,0xC571,0xC573,0xC574,0xC575,0xC57C,
0xC57D,0xC580,0xC584,0xC587,0xC58C,0xC58D,0xC58F,0xC591,
0xC595,0xC597,0xC598,0xC59C,0xC5A0,0xC5A9,0xC5B4,0xC5B5,
0xC5B8,0xC5B9,0xC5BB,0xC5BC,0xC5BD,0xC5BE,0xC5C4,0xC5C5,
0xC5C6,0xC5C7,0xC5C8,0xC5C9,0xC5CA,0xC5CC,0xC5CE,
       0xC5D0,0xC5D1,0xC5D4,0xC5D8,0xC5E0,0xC5E1,0xC5E3,
0xC5E5,0xC5EC,0xC5ED,0xC5EE,0xC5F0,0xC5F4,0xC5F6,0xC5F7,
0xC5FC,0xC5FD,0xC5FE,0xC5FF,0xC600,0xC601,0xC605,0xC606,
0xC607,0xC608,0xC60C,0xC610,0xC618,0xC619,0xC61B,0xC61C,
0xC624,0xC625,0xC628,0xC62C,0xC62D,0xC62E,0xC630,0xC633,
0xC634,0xC635,0xC637,0xC639,0xC63B,0xC640,0xC641,0xC644,
0xC648,0xC650,0xC651,0xC653,0xC654,0xC655,0xC65C,0xC65D,
0xC660,0xC66C,0xC66F,0xC671,0xC678,0xC679,0xC67C,0xC680,
0xC688,0xC689,0xC68B,0xC68D,0xC694,0xC695,0xC698,0xC69C,
0xC6A4,0xC6A5,0xC6A7,0xC6A9,0xC6B0,0xC6B1,0xC6B4,0xC6B8,
0xC6B9,0xC6BA,0xC6C0,0xC6C1,0xC6C3,0xC6C5,0xC6CC,0xC6CD,
0xC6D0,0xC6D4,0xC6DC,0xC6DD,0xC6E0,0xC6E1,0xC6E8,
       0xC6E9,0xC6EC,0xC6F0,0xC6F8,0xC6F9,0xC6FD,0xC704,
0xC705,0xC708,0xC70C,0xC714,0xC715,0xC717,0xC719,0xC720,
0xC721,0xC724,0xC728,0xC730,0xC731,0xC733,0xC735,0xC737,
0xC73C,0xC73D,0xC740,0xC744,0xC74A,0xC74C,0xC74D,0xC74F,
0xC751,0xC752,0xC753,0xC754,0xC755,0xC756,0xC757,0xC758,
0xC75C,0xC760,0xC768,0xC76B,0xC774,0xC775,0xC778,0xC77C,
0xC77D,0xC77E,0xC783,0xC784,0xC785,0xC787,0xC788,0xC789,
0xC78A,0xC78E,0xC790,0xC791,0xC794,0xC796,0xC797,0xC798,
0xC79A,0xC7A0,0xC7A1,0xC7A3,0xC7A4,0xC7A5,0xC7A6,0xC7AC,
0xC7AD,0xC7B0,0xC7B4,0xC7BC,0xC7BD,0xC7BF,0xC7C0,0xC7C1,
0xC7C8,0xC7C9,0xC7CC,0xC7CE,0xC7D0,0xC7D8,0xC7DD,0xC7E4,
0xC7E8,0xC7EC,0xC800,0xC801,0xC804,0xC808,0xC80A,
       0xC810,0xC811,0xC813,0xC815,0xC816,0xC81C,0xC81D,
0xC820,0xC824,0xC82C,0xC82D,0xC82F,0xC831,0xC838,0xC83C,
0xC840,0xC848,0xC849,0xC84C,0xC84D,0xC854,0xC870,0xC871,
0xC874,0xC878,0xC87A,0xC880,0xC881,0xC883,0xC885,0xC886,
0xC887,0xC88B,0xC88C,0xC88D,0xC894,0xC89D,0xC89F,0xC8A1,
0xC8A8,0xC8BC,0xC8BD,0xC8C4,0xC8C8,0xC8CC,0xC8D4,0xC8D5,
0xC8D7,0xC8D9,0xC8E0,0xC8E1,0xC8E4,0xC8F5,0xC8FC,0xC8FD,
0xC900,0xC904,0xC905,0xC906,0xC90C,0xC90D,0xC90F,0xC911,
0xC918,0xC92C,0xC934,0xC950,0xC951,0xC954,0xC958,0xC960,
0xC961,0xC963,0xC96C,0xC970,0xC974,0xC97C,0xC988,0xC989,
0xC98C,0xC990,0xC998,0xC999,0xC99B,0xC99D,0xC9C0,0xC9C1,
0xC9C4,0xC9C7,0xC9C8,0xC9CA,0xC9D0,0xC9D1,0xC9D3,
       0xC9D5,0xC9D6,0xC9D9,0xC9DA,0xC9DC,0xC9DD,0xC9E0,
0xC9E2,0xC9E4,0xC9E7,0xC9EC,0xC9ED,0xC9EF,0xC9F0,0xC9F1,
0xC9F8,0xC9F9,0xC9FC,0xCA00,0xCA08,0xCA09,0xCA0B,0xCA0C,
0xCA0D,0xCA14,0xCA18,0xCA29,0xCA4C,0xCA4D,0xCA50,0xCA54,
0xCA5C,0xCA5D,0xCA5F,0xCA60,0xCA61,0xCA68,0xCA7D,0xCA84,
0xCA98,0xCABC,0xCABD,0xCAC0,0xCAC4,0xCACC,0xCACD,0xCACF,
0xCAD1,0xCAD3,0xCAD8,0xCAD9,0xCAE0,0xCAEC,0xCAF4,0xCB08,
0xCB10,0xCB14,0xCB18,0xCB20,0xCB21,0xCB41,0xCB48,0xCB49,
0xCB4C,0xCB50,0xCB58,0xCB59,0xCB5D,0xCB64,0xCB78,0xCB79,
0xCB9C,0xCBB8,0xCBD4,0xCBE4,0xCBE7,0xCBE9,0xCC0C,0xCC0D,
0xCC10,0xCC14,0xCC1C,0xCC1D,0xCC21,0xCC22,0xCC27,0xCC28,
0xCC29,0xCC2C,0xCC2E,0xCC30,0xCC38,0xCC39,0xCC3B,
       0xCC3C,0xCC3D,0xCC3E,0xCC44,0xCC45,0xCC48,0xCC4C,
0xCC54,0xCC55,0xCC57,0xCC58,0xCC59,0xCC60,0xCC64,0xCC66,
0xCC68,0xCC70,0xCC75,0xCC98,0xCC99,0xCC9C,0xCCA0,0xCCA8,
0xCCA9,0xCCAB,0xCCAC,0xCCAD,0xCCB4,0xCCB5,0xCCB8,0xCCBC,
0xCCC4,0xCCC5,0xCCC7,0xCCC9,0xCCD0,0xCCD4,0xCCE4,0xCCEC,
0xCCF0,0xCD01,0xCD08,0xCD09,0xCD0C,0xCD10,0xCD18,0xCD19,
0xCD1B,0xCD1D,0xCD24,0xCD28,0xCD2C,0xCD39,0xCD5C,0xCD60,
0xCD64,0xCD6C,0xCD6D,0xCD6F,0xCD71,0xCD78,0xCD88,0xCD94,
0xCD95,0xCD98,0xCD9C,0xCDA4,0xCDA5,0xCDA7,0xCDA9,0xCDB0,
0xCDC4,0xCDCC,0xCDD0,0xCDE8,0xCDEC,0xCDF0,0xCDF8,0xCDF9,
0xCDFB,0xCDFD,0xCE04,0xCE08,0xCE0C,0xCE14,0xCE19,0xCE20,
0xCE21,0xCE24,0xCE28,0xCE30,0xCE31,0xCE33,0xCE35,
       0xCE58,0xCE59,0xCE5C,0xCE5F,0xCE60,0xCE61,0xCE68,
0xCE69,0xCE6B,0xCE6D,0xCE74,0xCE75,0xCE78,0xCE7C,0xCE84,
0xCE85,0xCE87,0xCE89,0xCE90,0xCE91,0xCE94,0xCE98,0xCEA0,
0xCEA1,0xCEA3,0xCEA4,0xCEA5,0xCEAC,0xCEAD,0xCEC1,0xCEE4,
0xCEE5,0xCEE8,0xCEEB,0xCEEC,0xCEF4,0xCEF5,0xCEF7,0xCEF8,
0xCEF9,0xCF00,0xCF01,0xCF04,0xCF08,0xCF10,0xCF11,0xCF13,
0xCF15,0xCF1C,0xCF20,0xCF24,0xCF2C,0xCF2D,0xCF2F,0xCF30,
0xCF31,0xCF38,0xCF54,0xCF55,0xCF58,0xCF5C,0xCF64,0xCF65,
0xCF67,0xCF69,0xCF70,0xCF71,0xCF74,0xCF78,0xCF80,0xCF85,
0xCF8C,0xCFA1,0xCFA8,0xCFB0,0xCFC4,0xCFE0,0xCFE1,0xCFE4,
0xCFE8,0xCFF0,0xCFF1,0xCFF3,0xCFF5,0xCFFC,0xD000,0xD004,
0xD011,0xD018,0xD02D,0xD034,0xD035,0xD038,0xD03C,
       0xD044,0xD045,0xD047,0xD049,0xD050,0xD054,0xD058,
0xD060,0xD06C,0xD06D,0xD070,0xD074,0xD07C,0xD07D,0xD081,
0xD0A4,0xD0A5,0xD0A8,0xD0AC,0xD0B4,0xD0B5,0xD0B7,0xD0B9,
0xD0C0,0xD0C1,0xD0C4,0xD0C8,0xD0C9,0xD0D0,0xD0D1,0xD0D3,
0xD0D4,0xD0D5,0xD0DC,0xD0DD,0xD0E0,0xD0E4,0xD0EC,0xD0ED,
0xD0EF,0xD0F0,0xD0F1,0xD0F8,0xD10D,0xD130,0xD131,0xD134,
0xD138,0xD13A,0xD140,0xD141,0xD143,0xD144,0xD145,0xD14C,
0xD14D,0xD150,0xD154,0xD15C,0xD15D,0xD15F,0xD161,0xD168,
0xD16C,0xD17C,0xD184,0xD188,0xD1A0,0xD1A1,0xD1A4,0xD1A8,
0xD1B0,0xD1B1,0xD1B3,0xD1B5,0xD1BA,0xD1BC,0xD1C0,0xD1D8,
0xD1F4,0xD1F8,0xD207,0xD209,0xD210,0xD22C,0xD22D,0xD230,
0xD234,0xD23C,0xD23D,0xD23F,0xD241,0xD248,0xD25C,
       0xD264,0xD280,0xD281,0xD284,0xD288,0xD290,0xD291,
0xD295,0xD29C,0xD2A0,0xD2A4,0xD2AC,0xD2B1,0xD2B8,0xD2B9,
0xD2BC,0xD2BF,0xD2C0,0xD2C2,0xD2C8,0xD2C9,0xD2CB,0xD2D4,
0xD2D8,0xD2DC,0xD2E4,0xD2E5,0xD2F0,0xD2F1,0xD2F4,0xD2F8,
0xD300,0xD301,0xD303,0xD305,0xD30C,0xD30D,0xD30E,0xD310,
0xD314,0xD316,0xD31C,0xD31D,0xD31F,0xD320,0xD321,0xD325,
0xD328,0xD329,0xD32C,0xD330,0xD338,0xD339,0xD33B,0xD33C,
0xD33D,0xD344,0xD345,0xD37C,0xD37D,0xD380,0xD384,0xD38C,
0xD38D,0xD38F,0xD390,0xD391,0xD398,0xD399,0xD39C,0xD3A0,
0xD3A8,0xD3A9,0xD3AB,0xD3AD,0xD3B4,0xD3B8,0xD3BC,0xD3C4,
0xD3C5,0xD3C8,0xD3C9,0xD3D0,0xD3D8,0xD3E1,0xD3E3,0xD3EC,
0xD3ED,0xD3F0,0xD3F4,0xD3FC,0xD3FD,0xD3FF,0xD401,
       0xD408,0xD41D,0xD440,0xD444,0xD45C,0xD460,0xD464,
0xD46D,0xD46F,0xD478,0xD479,0xD47C,0xD47F,0xD480,0xD482,
0xD488,0xD489,0xD48B,0xD48D,0xD494,0xD4A9,0xD4CC,0xD4D0,
0xD4D4,0xD4DC,0xD4DF,0xD4E8,0xD4EC,0xD4F0,0xD4F8,0xD4FB,
0xD4FD,0xD504,0xD508,0xD50C,0xD514,0xD515,0xD517,0xD53C,
0xD53D,0xD540,0xD544,0xD54C,0xD54D,0xD54F,0xD551,0xD558,
0xD559,0xD55C,0xD560,0xD565,0xD568,0xD569,0xD56B,0xD56D,
0xD574,0xD575,0xD578,0xD57C,0xD584,0xD585,0xD587,0xD588,
0xD589,0xD590,0xD5A5,0xD5C8,0xD5C9,0xD5CC,0xD5D0,0xD5D2,
0xD5D8,0xD5D9,0xD5DB,0xD5DD,0xD5E4,0xD5E5,0xD5E8,0xD5EC,
0xD5F4,0xD5F5,0xD5F7,0xD5F9,0xD600,0xD601,0xD604,0xD608,
0xD610,0xD611,0xD613,0xD614,0xD615,0xD61C,0xD620,
       0xD624,0xD62D,0xD638,0xD639,0xD63C,0xD640,0xD645,
0xD648,0xD649,0xD64B,0xD64D,0xD651,0xD654,0xD655,0xD658,
0xD65C,0xD667,0xD669,0xD670,0xD671,0xD674,0xD683,0xD685,
0xD68C,0xD68D,0xD690,0xD694,0xD69D,0xD69F,0xD6A1,0xD6A8,
0xD6AC,0xD6B0,0xD6B9,0xD6BB,0xD6C4,0xD6C5,0xD6C8,0xD6CC,
0xD6D1,0xD6D4,0xD6D7,0xD6D9,0xD6E0,0xD6E4,0xD6E8,0xD6F0,
0xD6F5,0xD6FC,0xD6FD,0xD700,0xD704,0xD711,0xD718,0xD719,
0xD71C,0xD720,0xD728,0xD729,0xD72B,0xD72D,0xD734,0xD735,
0xD738,0xD73C,0xD744,0xD747,0xD749,0xD750,0xD751,0xD754,
0xD756,0xD757,0xD758,0xD759,0xD760,0xD761,0xD763,0xD765,
0xD769,0xD76C,0xD770,0xD774,0xD77C,0xD77D,0xD781,0xD788,
0xD789,0xD78C,0xD790,0xD798,0xD799,0xD79B,0xD79D,
           -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       0x4F3D,0x4F73,0x5047,0x50F9,0x52A0,0x53EF,0x5475,
0x54E5,0x5609,0x5AC1,0x5BB6,0x6687,0x67B6,0x67B7,0x67EF,
0x6B4C,0x73C2,0x75C2,0x7A3C,0x82DB,0x8304,0x8857,0x8888,
0x8A36,0x8CC8,0x8DCF,0x8EFB,0x8FE6,0x99D5,0x523B,0x5374,
0x5404,0x606A,0x6164,0x6BBC,0x73CF,0x811A,0x89BA,0x89D2,
0x95A3,0x4F83,0x520A,0x58BE,0x5978,0x59E6,0x5E72,0x5E79,
0x61C7,0x63C0,0x6746,0x67EC,0x687F,0x6F97,0x764E,0x770B,
0x78F5,0x7A08,0x7AFF,0x7C21,0x809D,0x826E,0x8271,0x8AEB,
0x9593,0x4E6B,0x559D,0x66F7,0x6E34,0x78A3,0x7AED,0x845B,
0x8910,0x874E,0x97A8,0x52D8,0x574E,0x582A,0x5D4C,0x611F,
0x61BE,0x6221,0x6562,0x67D1,0x6A44,0x6E1B,0x7518,0x75B3,
0x76E3,0x77B0,0x7D3A,0x90AF,0x9451,0x9452,0x9F95,
       0x5323,0x5CAC,0x7532,0x80DB,0x9240,0x9598,0x525B,
0x5808,0x59DC,0x5CA1,0x5D17,0x5EB7,0x5F3A,0x5F4A,0x6177,
0x6C5F,0x757A,0x7586,0x7CE0,0x7D73,0x7DB1,0x7F8C,0x8154,
0x8221,0x8591,0x8941,0x8B1B,0x92FC,0x964D,0x9C47,0x4ECB,
0x4EF7,0x500B,0x51F1,0x584F,0x6137,0x613E,0x6168,0x6539,
0x69EA,0x6F11,0x75A5,0x7686,0x76D6,0x7B87,0x82A5,0x84CB,
0xF900,0x93A7,0x958B,0x5580,0x5BA2,0x5751,0xF901,0x7CB3,
0x7FB9,0x91B5,0x5028,0x53BB,0x5C45,0x5DE8,0x62D2,0x636E,
0x64DA,0x64E7,0x6E20,0x70AC,0x795B,0x8DDD,0x8E1E,0xF902,
0x907D,0x9245,0x92F8,0x4E7E,0x4EF6,0x5065,0x5DFE,0x5EFA,
0x6106,0x6957,0x8171,0x8654,0x8E47,0x9375,0x9A2B,0x4E5E,
0x5091,0x6770,0x6840,0x5109,0x528D,0x5292,0x6AA2,
       0x77BC,0x9210,0x9ED4,0x52AB,0x602F,0x8FF2,0x5048,
0x61A9,0x63ED,0x64CA,0x683C,0x6A84,0x6FC0,0x8188,0x89A1,
0x9694,0x5805,0x727D,0x72AC,0x7504,0x7D79,0x7E6D,0x80A9,
0x898B,0x8B74,0x9063,0x9D51,0x6289,0x6C7A,0x6F54,0x7D50,
0x7F3A,0x8A23,0x517C,0x614A,0x7B9D,0x8B19,0x9257,0x938C,
0x4EAC,0x4FD3,0x501E,0x50BE,0x5106,0x52C1,0x52CD,0x537F,
0x5770,0x5883,0x5E9A,0x5F91,0x6176,0x61AC,0x64CE,0x656C,
0x666F,0x66BB,0x66F4,0x6897,0x6D87,0x7085,0x70F1,0x749F,
0x74A5,0x74CA,0x75D9,0x786C,0x78EC,0x7ADF,0x7AF6,0x7D45,
0x7D93,0x8015,0x803F,0x811B,0x8396,0x8B66,0x8F15,0x9015,
0x93E1,0x9803,0x9838,0x9A5A,0x9BE8,0x4FC2,0x5553,0x583A,
0x5951,0x5B63,0x5C46,0x60B8,0x6212,0x6842,0x68B0,
       0x68E8,0x6EAA,0x754C,0x7678,0x78CE,0x7A3D,0x7CFB,
0x7E6B,0x7E7C,0x8A08,0x8AA1,0x8C3F,0x968E,0x9DC4,0x53E4,
0x53E9,0x544A,0x5471,0x56FA,0x59D1,0x5B64,0x5C3B,0x5EAB,
0x62F7,0x6537,0x6545,0x6572,0x66A0,0x67AF,0x69C1,0x6CBD,
0x75FC,0x7690,0x777E,0x7A3F,0x7F94,0x8003,0x80A1,0x818F,
0x82E6,0x82FD,0x83F0,0x85C1,0x8831,0x88B4,0x8AA5,0xF903,
0x8F9C,0x932E,0x96C7,0x9867,0x9AD8,0x9F13,0x54ED,0x659B,
0x66F2,0x688F,0x7A40,0x8C37,0x9D60,0x56F0,0x5764,0x5D11,
0x6606,0x68B1,0x68CD,0x6EFE,0x7428,0x889E,0x9BE4,0x6C68,
0xF904,0x9AA8,0x4F9B,0x516C,0x5171,0x529F,0x5B54,0x5DE5,
0x6050,0x606D,0x62F1,0x63A7,0x653B,0x73D9,0x7A7A,0x86A3,
0x8CA2,0x978F,0x4E32,0x5BE1,0x6208,0x679C,0x74DC,
       0x79D1,0x83D3,0x8A87,0x8AB2,0x8DE8,0x904E,0x934B,
0x9846,0x5ED3,0x69E8,0x85FF,0x90ED,0xF905,0x51A0,0x5B98,
0x5BEC,0x6163,0x68FA,0x6B3E,0x704C,0x742F,0x74D8,0x7BA1,
0x7F50,0x83C5,0x89C0,0x8CAB,0x95DC,0x9928,0x522E,0x605D,
0x62EC,0x9002,0x4F8A,0x5149,0x5321,0x58D9,0x5EE3,0x66E0,
0x6D38,0x709A,0x72C2,0x73D6,0x7B50,0x80F1,0x945B,0x5366,
0x639B,0x7F6B,0x4E56,0x5080,0x584A,0x58DE,0x602A,0x6127,
0x62D0,0x69D0,0x9B41,0x5B8F,0x7D18,0x80B1,0x8F5F,0x4EA4,
0x50D1,0x54AC,0x55AC,0x5B0C,0x5DA0,0x5DE7,0x652A,0x654E,
0x6821,0x6A4B,0x72E1,0x768E,0x77EF,0x7D5E,0x7FF9,0x81A0,
0x854E,0x86DF,0x8F03,0x8F4E,0x90CA,0x9903,0x9A55,0x9BAB,
0x4E18,0x4E45,0x4E5D,0x4EC7,0x4FF1,0x5177,0x52FE,
       0x5340,0x53E3,0x53E5,0x548E,0x5614,0x5775,0x57A2,
0x5BC7,0x5D87,0x5ED0,0x61FC,0x62D8,0x6551,0x67B8,0x67E9,
0x69CB,0x6B50,0x6BC6,0x6BEC,0x6C42,0x6E9D,0x7078,0x72D7,
0x7396,0x7403,0x77BF,0x77E9,0x7A76,0x7D7F,0x8009,0x81FC,
0x8205,0x820A,0x82DF,0x8862,0x8B33,0x8CFC,0x8EC0,0x9011,
0x90B1,0x9264,0x92B6,0x99D2,0x9A45,0x9CE9,0x9DD7,0x9F9C,
0x570B,0x5C40,0x83CA,0x97A0,0x97AB,0x9EB4,0x541B,0x7A98,
0x7FA4,0x88D9,0x8ECD,0x90E1,0x5800,0x5C48,0x6398,0x7A9F,
0x5BAE,0x5F13,0x7A79,0x7AAE,0x828E,0x8EAC,0x5026,0x5238,
0x52F8,0x5377,0x5708,0x62F3,0x6372,0x6B0A,0x6DC3,0x7737,
0x53A5,0x7357,0x8568,0x8E76,0x95D5,0x673A,0x6AC3,0x6F70,
0x8A6D,0x8ECC,0x994B,0xF906,0x6677,0x6B78,0x8CB4,
       0x9B3C,0xF907,0x53EB,0x572D,0x594E,0x63C6,0x69FB,
0x73EA,0x7845,0x7ABA,0x7AC5,0x7CFE,0x8475,0x898F,0x8D73,
0x9035,0x95A8,0x52FB,0x5747,0x7547,0x7B60,0x83CC,0x921E,
0xF908,0x6A58,0x514B,0x524B,0x5287,0x621F,0x68D8,0x6975,
0x9699,0x50C5,0x52A4,0x52E4,0x61C3,0x65A4,0x6839,0x69FF,
0x747E,0x7B4B,0x82B9,0x83EB,0x89B2,0x8B39,0x8FD1,0x9949,
0xF909,0x4ECA,0x5997,0x64D2,0x6611,0x6A8E,0x7434,0x7981,
0x79BD,0x82A9,0x887E,0x887F,0x895F,0xF90A,0x9326,0x4F0B,
0x53CA,0x6025,0x6271,0x6C72,0x7D1A,0x7D66,0x4E98,0x5162,
0x77DC,0x80AF,0x4F01,0x4F0E,0x5176,0x5180,0x55DC,0x5668,
0x573B,0x57FA,0x57FC,0x5914,0x5947,0x5993,0x5BC4,0x5C90,
0x5D0E,0x5DF1,0x5E7E,0x5FCC,0x6280,0x65D7,0x65E3,
       0x671E,0x671F,0x675E,0x68CB,0x68C4,0x6A5F,0x6B3A,
0x6C23,0x6C7D,0x6C82,0x6DC7,0x7398,0x7426,0x742A,0x7482,
0x74A3,0x7578,0x757F,0x7881,0x78EF,0x7941,0x7947,0x7948,
0x797A,0x7B95,0x7D00,0x7DBA,0x7F88,0x8006,0x802D,0x808C,
0x8A18,0x8B4F,0x8C48,0x8D77,0x9321,0x9324,0x98E2,0x9951,
0x9A0E,0x9A0F,0x9A65,0x9E92,0x7DCA,0x4F76,0x5409,0x62EE,
0x6854,0x91D1,0x55AB,0x513A,0xF90B,0xF90C,0x5A1C,0x61E6,
0xF90D,0x62CF,0x62FF,0xF90E,0xF90F,0xF910,0xF911,0xF912,
0xF913,0x90A3,0xF914,0xF915,0xF916,0xF917,0xF918,0x8AFE,
0xF919,0xF91A,0xF91B,0xF91C,0x6696,0xF91D,0x7156,0xF91E,
0xF91F,0x96E3,0xF920,0x634F,0x637A,0x5357,0xF921,0x678F,
0x6960,0x6E73,0xF922,0x7537,0xF923,0xF924,0xF925,
       0x7D0D,0xF926,0xF927,0x8872,0x56CA,0x5A18,0xF928,
0xF929,0xF92A,0xF92B,0xF92C,0x4E43,0xF92D,0x5167,0x5948,
0x67F0,0x8010,0xF92E,0x5973,0x5E74,0x649A,0x79CA,0x5FF5,
0x606C,0x62C8,0x637B,0x5BE7,0x5BD7,0x52AA,0xF92F,0x5974,
0x5F29,0x6012,0xF930,0xF931,0xF932,0x7459,0xF933,0xF934,
0xF935,0xF936,0xF937,0xF938,0x99D1,0xF939,0xF93A,0xF93B,
0xF93C,0xF93D,0xF93E,0xF93F,0xF940,0xF941,0xF942,0xF943,
0x6FC3,0xF944,0xF945,0x81BF,0x8FB2,0x60F1,0xF946,0xF947,
0x8166,0xF948,0xF949,0x5C3F,0xF94A,0xF94B,0xF94C,0xF94D,
0xF94E,0xF94F,0xF950,0xF951,0x5AE9,0x8A25,0x677B,0x7D10,
0xF952,0xF953,0xF954,0xF955,0xF956,0xF957,0x80FD,0xF958,
0xF959,0x5C3C,0x6CE5,0x533F,0x6EBA,0x591A,0x8336,
       0x4E39,0x4EB6,0x4F46,0x55AE,0x5718,0x58C7,0x5F56,
0x65B7,0x65E6,0x6A80,0x6BB5,0x6E4D,0x77ED,0x7AEF,0x7C1E,
0x7DDE,0x86CB,0x8892,0x9132,0x935B,0x64BB,0x6FBE,0x737A,
0x75B8,0x9054,0x5556,0x574D,0x61BA,0x64D4,0x66C7,0x6DE1,
0x6E5B,0x6F6D,0x6FB9,0x75F0,0x8043,0x81BD,0x8541,0x8983,
0x8AC7,0x8B5A,0x931F,0x6C93,0x7553,0x7B54,0x8E0F,0x905D,
0x5510,0x5802,0x5858,0x5E62,0x6207,0x649E,0x68E0,0x7576,
0x7CD6,0x87B3,0x9EE8,0x4EE3,0x5788,0x576E,0x5927,0x5C0D,
0x5CB1,0x5E36,0x5F85,0x6234,0x64E1,0x73B3,0x81FA,0x888B,
0x8CB8,0x968A,0x9EDB,0x5B85,0x5FB7,0x60B3,0x5012,0x5200,
0x5230,0x5716,0x5835,0x5857,0x5C0E,0x5C60,0x5CF6,0x5D8B,
0x5EA6,0x5F92,0x60BC,0x6311,0x6389,0x6417,0x6843,
       0x68F9,0x6AC2,0x6DD8,0x6E21,0x6ED4,0x6FE4,0x71FE,
0x76DC,0x7779,0x79B1,0x7A3B,0x8404,0x89A9,0x8CED,0x8DF3,
0x8E48,0x9003,0x9014,0x9053,0x90FD,0x934D,0x9676,0x97DC,
0x6BD2,0x7006,0x7258,0x72A2,0x7368,0x7763,0x79BF,0x7BE4,
0x7E9B,0x8B80,0x58A9,0x60C7,0x6566,0x65FD,0x66BE,0x6C8C,
0x711E,0x71C9,0x8C5A,0x9813,0x4E6D,0x7A81,0x4EDD,0x51AC,
0x51CD,0x52D5,0x540C,0x61A7,0x6771,0x6850,0x68DF,0x6D1E,
0x6F7C,0x75BC,0x77B3,0x7AE5,0x80F4,0x8463,0x9285,0x515C,
0x6597,0x675C,0x6793,0x75D8,0x7AC7,0x8373,0xF95A,0x8C46,
0x9017,0x982D,0x5C6F,0x81C0,0x829A,0x9041,0x906F,0x920D,
0x5F97,0x5D9D,0x6A59,0x71C8,0x767B,0x7B49,0x85E4,0x8B04,
0x9127,0x9A30,0x5587,0x61F6,0xF95B,0x7669,0x7F85,
       0x863F,0x87BA,0x88F8,0x908F,0xF95C,0x6D1B,0x70D9,
0x73DE,0x7D61,0x843D,0xF95D,0x916A,0x99F1,0xF95E,0x4E82,
0x5375,0x6B04,0x6B12,0x703E,0x721B,0x862D,0x9E1E,0x524C,
0x8FA3,0x5D50,0x64E5,0x652C,0x6B16,0x6FEB,0x7C43,0x7E9C,
0x85CD,0x8964,0x89BD,0x62C9,0x81D8,0x881F,0x5ECA,0x6717,
0x6D6A,0x72FC,0x7405,0x746F,0x8782,0x90DE,0x4F86,0x5D0D,
0x5FA0,0x840A,0x51B7,0x63A0,0x7565,0x4EAE,0x5006,0x5169,
0x51C9,0x6881,0x6A11,0x7CAE,0x7CB1,0x7CE7,0x826F,0x8AD2,
0x8F1B,0x91CF,0x4FB6,0x5137,0x52F5,0x5442,0x5EEC,0x616E,
0x623E,0x65C5,0x6ADA,0x6FFE,0x792A,0x85DC,0x8823,0x95AD,
0x9A62,0x9A6A,0x9E97,0x9ECE,0x529B,0x66C6,0x6B77,0x701D,
0x792B,0x8F62,0x9742,0x6190,0x6200,0x6523,0x6F23,
       0x7149,0x7489,0x7DF4,0x806F,0x84EE,0x8F26,0x9023,
0x934A,0x51BD,0x5217,0x52A3,0x6D0C,0x70C8,0x88C2,0x5EC9,
0x6582,0x6BAE,0x6FC2,0x7C3E,0x7375,0x4EE4,0x4F36,0x56F9,
0xF95F,0x5CBA,0x5DBA,0x601C,0x73B2,0x7B2D,0x7F9A,0x7FCE,
0x8046,0x901E,0x9234,0x96F6,0x9748,0x9818,0x9F61,0x4F8B,
0x6FA7,0x79AE,0x91B4,0x96B7,0x52DE,0xF960,0x6488,0x64C4,
0x6AD3,0x6F5E,0x7018,0x7210,0x76E7,0x8001,0x8606,0x865C,
0x8DEF,0x8F05,0x9732,0x9B6F,0x9DFA,0x9E75,0x788C,0x797F,
0x7DA0,0x83C9,0x9304,0x9E7F,0x9E93,0x8AD6,0x58DF,0x5F04,
0x6727,0x7027,0x74CF,0x7C60,0x807E,0x5121,0x7028,0x7262,
0x78CA,0x8CC2,0x8CDA,0x8CF4,0x96F7,0x4E86,0x50DA,0x5BEE,
0x5ED6,0x6599,0x71CE,0x7642,0x77AD,0x804A,0x84FC,
       0x907C,0x9B27,0x9F8D,0x58D8,0x5A41,0x5C62,0x6A13,
0x6DDA,0x6F0F,0x763B,0x7D2F,0x7E37,0x851E,0x8938,0x93E4,
0x964B,0x5289,0x65D2,0x67F3,0x69B4,0x6D41,0x6E9C,0x700F,
0x7409,0x7460,0x7559,0x7624,0x786B,0x8B2C,0x985E,0x516D,
0x622E,0x9678,0x4F96,0x502B,0x5D19,0x6DEA,0x7DB8,0x8F2A,
0x5F8B,0x6144,0x6817,0xF961,0x9686,0x52D2,0x808B,0x51DC,
0x51CC,0x695E,0x7A1C,0x7DBE,0x83F1,0x9675,0x4FDA,0x5229,
0x5398,0x540F,0x550E,0x5C65,0x60A7,0x674E,0x68A8,0x6D6C,
0x7281,0x72F8,0x7406,0x7483,0xF962,0x75E2,0x7C6C,0x7F79,
0x7FB8,0x8389,0x88CF,0x88E1,0x91CC,0x91D0,0x96E2,0x9BC9,
0x541D,0x6F7E,0x71D0,0x7498,0x85FA,0x8EAA,0x96A3,0x9C57,
0x9E9F,0x6797,0x6DCB,0x7433,0x81E8,0x9716,0x782C,
       0x7ACB,0x7B20,0x7C92,0x6469,0x746A,0x75F2,0x78BC,
0x78E8,0x99AC,0x9B54,0x9EBB,0x5BDE,0x5E55,0x6F20,0x819C,
0x83AB,0x9088,0x4E07,0x534D,0x5A29,0x5DD2,0x5F4E,0x6162,
0x633D,0x6669,0x66FC,0x6EFF,0x6F2B,0x7063,0x779E,0x842C,
0x8513,0x883B,0x8F13,0x9945,0x9C3B,0x551C,0x62B9,0x672B,
0x6CAB,0x8309,0x896A,0x977A,0x4EA1,0x5984,0x5FD8,0x5FD9,
0x671B,0x7DB2,0x7F54,0x8292,0x832B,0x83BD,0x8F1E,0x9099,
0x57CB,0x59B9,0x5A92,0x5BD0,0x6627,0x679A,0x6885,0x6BCF,
0x7164,0x7F75,0x8CB7,0x8CE3,0x9081,0x9B45,0x8108,0x8C8A,
0x964C,0x9A40,0x9EA5,0x5B5F,0x6C13,0x731B,0x76F2,0x76DF,
0x840C,0x51AA,0x8993,0x514D,0x5195,0x52C9,0x68C9,0x6C94,
0x7704,0x7720,0x7DBF,0x7DEC,0x9762,0x9EB5,0x6EC5,
       0x8511,0x51A5,0x540D,0x547D,0x660E,0x669D,0x6927,
0x6E9F,0x76BF,0x7791,0x8317,0x84C2,0x879F,0x9169,0x9298,
0x9CF4,0x8882,0x4FAE,0x5192,0x52DF,0x59C6,0x5E3D,0x6155,
0x6478,0x6479,0x66AE,0x67D0,0x6A21,0x6BCD,0x6BDB,0x725F,
0x7261,0x7441,0x7738,0x77DB,0x8017,0x82BC,0x8305,0x8B00,
0x8B28,0x8C8C,0x6728,0x6C90,0x7267,0x76EE,0x7766,0x7A46,
0x9DA9,0x6B7F,0x6C92,0x5922,0x6726,0x8499,0x536F,0x5893,
0x5999,0x5EDF,0x63CF,0x6634,0x6773,0x6E3A,0x732B,0x7AD7,
0x82D7,0x9328,0x52D9,0x5DEB,0x61AE,0x61CB,0x620A,0x62C7,
0x64AB,0x65E0,0x6959,0x6B66,0x6BCB,0x7121,0x73F7,0x755D,
0x7E46,0x821E,0x8302,0x856A,0x8AA3,0x8CBF,0x9727,0x9D61,
0x58A8,0x9ED8,0x5011,0x520E,0x543B,0x554F,0x6587,
       0x6C76,0x7D0A,0x7D0B,0x805E,0x868A,0x9580,0x96EF,
0x52FF,0x6C95,0x7269,0x5473,0x5A9A,0x5C3E,0x5D4B,0x5F4C,
0x5FAE,0x672A,0x68B6,0x6963,0x6E3C,0x6E44,0x7709,0x7C73,
0x7F8E,0x8587,0x8B0E,0x8FF7,0x9761,0x9EF4,0x5CB7,0x60B6,
0x610D,0x61AB,0x654F,0x65FB,0x65FC,0x6C11,0x6CEF,0x739F,
0x73C9,0x7DE1,0x9594,0x5BC6,0x871C,0x8B10,0x525D,0x535A,
0x62CD,0x640F,0x64B2,0x6734,0x6A38,0x6CCA,0x73C0,0x749E,
0x7B94,0x7C95,0x7E1B,0x818A,0x8236,0x8584,0x8FEB,0x96F9,
0x99C1,0x4F34,0x534A,0x53CD,0x53DB,0x62CC,0x642C,0x6500,
0x6591,0x69C3,0x6CEE,0x6F58,0x73ED,0x7554,0x7622,0x76E4,
0x76FC,0x78D0,0x78FB,0x792C,0x7D46,0x822C,0x87E0,0x8FD4,
0x9812,0x98EF,0x52C3,0x62D4,0x64A5,0x6E24,0x6F51,
       0x767C,0x8DCB,0x91B1,0x9262,0x9AEE,0x9B43,0x5023,
0x508D,0x574A,0x59A8,0x5C28,0x5E47,0x5F77,0x623F,0x653E,
0x65B9,0x65C1,0x6609,0x678B,0x699C,0x6EC2,0x78C5,0x7D21,
0x80AA,0x8180,0x822B,0x82B3,0x84A1,0x868C,0x8A2A,0x8B17,
0x90A6,0x9632,0x9F90,0x500D,0x4FF3,0xF963,0x57F9,0x5F98,
0x62DC,0x6392,0x676F,0x6E43,0x7119,0x76C3,0x80CC,0x80DA,
0x88F4,0x88F5,0x8919,0x8CE0,0x8F29,0x914D,0x966A,0x4F2F,
0x4F70,0x5E1B,0x67CF,0x6822,0x767D,0x767E,0x9B44,0x5E61,
0x6A0A,0x7169,0x71D4,0x756A,0xF964,0x7E41,0x8543,0x85E9,
0x98DC,0x4F10,0x7B4F,0x7F70,0x95A5,0x51E1,0x5E06,0x68B5,
0x6C3E,0x6C4E,0x6CDB,0x72AF,0x7BC4,0x8303,0x6CD5,0x743A,
0x50FB,0x5288,0x58C1,0x64D8,0x6A97,0x74A7,0x7656,
       0x78A7,0x8617,0x95E2,0x9739,0xF965,0x535E,0x5F01,
0x8B8A,0x8FA8,0x8FAF,0x908A,0x5225,0x77A5,0x9C49,0x9F08,
0x4E19,0x5002,0x5175,0x5C5B,0x5E77,0x661E,0x663A,0x67C4,
0x68C5,0x70B3,0x7501,0x75C5,0x79C9,0x7ADD,0x8F27,0x9920,
0x9A08,0x4FDD,0x5821,0x5831,0x5BF6,0x666E,0x6B65,0x6D11,
0x6E7A,0x6F7D,0x73E4,0x752B,0x83E9,0x88DC,0x8913,0x8B5C,
0x8F14,0x4F0F,0x50D5,0x5310,0x535C,0x5B93,0x5FA9,0x670D,
0x798F,0x8179,0x832F,0x8514,0x8907,0x8986,0x8F39,0x8F3B,
0x99A5,0x9C12,0x672C,0x4E76,0x4FF8,0x5949,0x5C01,0x5CEF,
0x5CF0,0x6367,0x68D2,0x70FD,0x71A2,0x742B,0x7E2B,0x84EC,
0x8702,0x9022,0x92D2,0x9CF3,0x4E0D,0x4ED8,0x4FEF,0x5085,
0x5256,0x526F,0x5426,0x5490,0x57E0,0x592B,0x5A66,
       0x5B5A,0x5B75,0x5BCC,0x5E9C,0xF966,0x6276,0x6577,
0x65A7,0x6D6E,0x6EA5,0x7236,0x7B26,0x7C3F,0x7F36,0x8150,
0x8151,0x819A,0x8240,0x8299,0x83A9,0x8A03,0x8CA0,0x8CE6,
0x8CFB,0x8D74,0x8DBA,0x90E8,0x91DC,0x961C,0x9644,0x99D9,
0x9CE7,0x5317,0x5206,0x5429,0x5674,0x58B3,0x5954,0x596E,
0x5FFF,0x61A4,0x626E,0x6610,0x6C7E,0x711A,0x76C6,0x7C89,
0x7CDE,0x7D1B,0x82AC,0x8CC1,0x96F0,0xF967,0x4F5B,0x5F17,
0x5F7F,0x62C2,0x5D29,0x670B,0x68DA,0x787C,0x7E43,0x9D6C,
0x4E15,0x5099,0x5315,0x532A,0x5351,0x5983,0x5A62,0x5E87,
0x60B2,0x618A,0x6249,0x6279,0x6590,0x6787,0x69A7,0x6BD4,
0x6BD6,0x6BD7,0x6BD8,0x6CB8,0xF968,0x7435,0x75FA,0x7812,
0x7891,0x79D5,0x79D8,0x7C83,0x7DCB,0x7FE1,0x80A5,
       0x813E,0x81C2,0x83F2,0x871A,0x88E8,0x8AB9,0x8B6C,
0x8CBB,0x9119,0x975E,0x98DB,0x9F3B,0x56AC,0x5B2A,0x5F6C,
0x658C,0x6AB3,0x6BAF,0x6D5C,0x6FF1,0x7015,0x725D,0x73AD,
0x8CA7,0x8CD3,0x983B,0x6191,0x6C37,0x8058,0x9A01,0x4E4D,
0x4E8B,0x4E9B,0x4ED5,0x4F3A,0x4F3C,0x4F7F,0x4FDF,0x50FF,
0x53F2,0x53F8,0x5506,0x55E3,0x56DB,0x58EB,0x5962,0x5A11,
0x5BEB,0x5BFA,0x5C04,0x5DF3,0x5E2B,0x5F99,0x601D,0x6368,
0x659C,0x65AF,0x67F6,0x67FB,0x68AD,0x6B7B,0x6C99,0x6CD7,
0x6E23,0x7009,0x7345,0x7802,0x793E,0x7940,0x7960,0x79C1,
0x7BE9,0x7D17,0x7D72,0x8086,0x820D,0x838E,0x84D1,0x86C7,
0x88DF,0x8A50,0x8A5E,0x8B1D,0x8CDC,0x8D66,0x8FAD,0x90AA,
0x98FC,0x99DF,0x9E9D,0x524A,0xF969,0x6714,0xF96A,
       0x5098,0x522A,0x5C71,0x6563,0x6C55,0x73CA,0x7523,
0x759D,0x7B97,0x849C,0x9178,0x9730,0x4E77,0x6492,0x6BBA,
0x715E,0x85A9,0x4E09,0xF96B,0x6749,0x68EE,0x6E17,0x829F,
0x8518,0x886B,0x63F7,0x6F81,0x9212,0x98AF,0x4E0A,0x50B7,
0x50CF,0x511F,0x5546,0x55AA,0x5617,0x5B40,0x5C19,0x5CE0,
0x5E38,0x5E8A,0x5EA0,0x5EC2,0x60F3,0x6851,0x6A61,0x6E58,
0x723D,0x7240,0x72C0,0x76F8,0x7965,0x7BB1,0x7FD4,0x88F3,
0x89F4,0x8A73,0x8C61,0x8CDE,0x971C,0x585E,0x74BD,0x8CFD,
0x55C7,0xF96C,0x7A61,0x7D22,0x8272,0x7272,0x751F,0x7525,
0xF96D,0x7B19,0x5885,0x58FB,0x5DBC,0x5E8F,0x5EB6,0x5F90,
0x6055,0x6292,0x637F,0x654D,0x6691,0x66D9,0x66F8,0x6816,
0x68F2,0x7280,0x745E,0x7B6E,0x7D6E,0x7DD6,0x7F72,
       0x80E5,0x8212,0x85AF,0x897F,0x8A93,0x901D,0x92E4,
0x9ECD,0x9F20,0x5915,0x596D,0x5E2D,0x60DC,0x6614,0x6673,
0x6790,0x6C50,0x6DC5,0x6F5F,0x77F3,0x78A9,0x84C6,0x91CB,
0x932B,0x4ED9,0x50CA,0x5148,0x5584,0x5B0B,0x5BA3,0x6247,
0x657E,0x65CB,0x6E32,0x717D,0x7401,0x7444,0x7487,0x74BF,
0x766C,0x79AA,0x7DDA,0x7E55,0x7FA8,0x817A,0x81B3,0x8239,
0x861A,0x87EC,0x8A75,0x8DE3,0x9078,0x9291,0x9425,0x994D,
0x9BAE,0x5368,0x5C51,0x6954,0x6CC4,0x6D29,0x6E2B,0x820C,
0x859B,0x893B,0x8A2D,0x8AAA,0x96EA,0x9F67,0x5261,0x66B9,
0x6BB2,0x7E96,0x87FE,0x8D0D,0x9583,0x965D,0x651D,0x6D89,
0x71EE,0xF96E,0x57CE,0x59D3,0x5BAC,0x6027,0x60FA,0x6210,
0x661F,0x665F,0x7329,0x73F9,0x76DB,0x7701,0x7B6C,
       0x8056,0x8072,0x8165,0x8AA0,0x9192,0x4E16,0x52E2,
0x6B72,0x6D17,0x7A05,0x7B39,0x7D30,0xF96F,0x8CB0,0x53EC,
0x562F,0x5851,0x5BB5,0x5C0F,0x5C11,0x5DE2,0x6240,0x6383,
0x6414,0x662D,0x68B3,0x6CBC,0x6D88,0x6EAF,0x701F,0x70A4,
0x71D2,0x7526,0x758F,0x758E,0x7619,0x7B11,0x7BE0,0x7C2B,
0x7D20,0x7D39,0x852C,0x856D,0x8607,0x8A34,0x900D,0x9061,
0x90B5,0x92B7,0x97F6,0x9A37,0x4FD7,0x5C6C,0x675F,0x6D91,
0x7C9F,0x7E8C,0x8B16,0x8D16,0x901F,0x5B6B,0x5DFD,0x640D,
0x84C0,0x905C,0x98E1,0x7387,0x5B8B,0x609A,0x677E,0x6DDE,
0x8A1F,0x8AA6,0x9001,0x980C,0x5237,0xF970,0x7051,0x788E,
0x9396,0x8870,0x91D7,0x4FEE,0x53D7,0x55FD,0x56DA,0x5782,
0x58FD,0x5AC2,0x5B88,0x5CAB,0x5CC0,0x5E25,0x6101,
       0x620D,0x624B,0x6388,0x641C,0x6536,0x6578,0x6A39,
0x6B8A,0x6C34,0x6D19,0x6F31,0x71E7,0x72E9,0x7378,0x7407,
0x74B2,0x7626,0x7761,0x79C0,0x7A57,0x7AEA,0x7CB9,0x7D8F,
0x7DAC,0x7E61,0x7F9E,0x8129,0x8331,0x8490,0x84DA,0x85EA,
0x8896,0x8AB0,0x8B90,0x8F38,0x9042,0x9083,0x916C,0x9296,
0x92B9,0x968B,0x96A7,0x96A8,0x96D6,0x9700,0x9808,0x9996,
0x9AD3,0x9B1A,0x53D4,0x587E,0x5919,0x5B70,0x5BBF,0x6DD1,
0x6F5A,0x719F,0x7421,0x74B9,0x8085,0x83FD,0x5DE1,0x5F87,
0x5FAA,0x6042,0x65EC,0x6812,0x696F,0x6A53,0x6B89,0x6D35,
0x6DF3,0x73E3,0x76FE,0x77AC,0x7B4D,0x7D14,0x8123,0x821C,
0x8340,0x84F4,0x8563,0x8A62,0x8AC4,0x9187,0x931E,0x9806,
0x99B4,0x620C,0x8853,0x8FF0,0x9265,0x5D07,0x5D27,
       0x5D69,0x745F,0x819D,0x8768,0x6FD5,0x62FE,0x7FD2,
0x8936,0x8972,0x4E1E,0x4E58,0x50E7,0x52DD,0x5347,0x627F,
0x6607,0x7E69,0x8805,0x965E,0x4F8D,0x5319,0x5636,0x59CB,
0x5AA4,0x5C38,0x5C4E,0x5C4D,0x5E02,0x5F11,0x6043,0x65BD,
0x662F,0x6642,0x67BE,0x67F4,0x731C,0x77E2,0x793A,0x7FC5,
0x8494,0x84CD,0x8996,0x8A66,0x8A69,0x8AE1,0x8C55,0x8C7A,
0x57F4,0x5BD4,0x5F0F,0x606F,0x62ED,0x690D,0x6B96,0x6E5C,
0x7184,0x7BD2,0x8755,0x8B58,0x8EFE,0x98DF,0x98FE,0x4F38,
0x4F81,0x4FE1,0x547B,0x5A20,0x5BB8,0x613C,0x65B0,0x6668,
0x71FC,0x7533,0x795E,0x7D33,0x814E,0x81E3,0x8398,0x85AA,
0x85CE,0x8703,0x8A0A,0x8EAB,0x8F9B,0xF971,0x8FC5,0x5931,
0x5BA4,0x5BE6,0x6089,0x5BE9,0x5C0B,0x5FC3,0x6C81,
       0xF972,0x6DF1,0x700B,0x751A,0x82AF,0x8AF6,0x4EC0,
0x5341,0xF973,0x96D9,0x6C0F,0x4E9E,0x4FC4,0x5152,0x555E,
0x5A25,0x5CE8,0x6211,0x7259,0x82BD,0x83AA,0x86FE,0x8859,
0x8A1D,0x963F,0x96C5,0x9913,0x9D09,0x9D5D,0x580A,0x5CB3,
0x5DBD,0x5E44,0x60E1,0x6115,0x63E1,0x6A02,0x6E25,0x9102,
0x9354,0x984E,0x9C10,0x9F77,0x5B89,0x5CB8,0x6309,0x664F,
0x6848,0x773C,0x96C1,0x978D,0x9854,0x9B9F,0x65A1,0x8B01,
0x8ECB,0x95BC,0x5535,0x5CA9,0x5DD6,0x5EB5,0x6697,0x764C,
0x83F4,0x95C7,0x58D3,0x62BC,0x72CE,0x9D28,0x4EF0,0x592E,
0x600F,0x663B,0x6B83,0x79E7,0x9D26,0x5393,0x54C0,0x57C3,
0x5D16,0x611B,0x66D6,0x6DAF,0x788D,0x827E,0x9698,0x9744,
0x5384,0x627C,0x6396,0x6DB2,0x7E0A,0x814B,0x984D,
       0x6AFB,0x7F4C,0x9DAF,0x9E1A,0x4E5F,0x503B,0x51B6,
0x591C,0x60F9,0x63F6,0x6930,0x723A,0x8036,0xF974,0x91CE,
0x5F31,0xF975,0xF976,0x7D04,0x82E5,0x846F,0x84BB,0x85E5,
0x8E8D,0xF977,0x4F6F,0xF978,0xF979,0x58E4,0x5B43,0x6059,
0x63DA,0x6518,0x656D,0x6698,0xF97A,0x694A,0x6A23,0x6D0B,
0x7001,0x716C,0x75D2,0x760D,0x79B3,0x7A70,0xF97B,0x7F8A,
0xF97C,0x8944,0xF97D,0x8B93,0x91C0,0x967D,0xF97E,0x990A,
0x5704,0x5FA1,0x65BC,0x6F01,0x7600,0x79A6,0x8A9E,0x99AD,
0x9B5A,0x9F6C,0x5104,0x61B6,0x6291,0x6A8D,0x81C6,0x5043,
0x5830,0x5F66,0x7109,0x8A00,0x8AFA,0x5B7C,0x8616,0x4FFA,
0x513C,0x56B4,0x5944,0x63A9,0x6DF9,0x5DAA,0x696D,0x5186,
0x4E88,0x4F59,0xF97F,0xF980,0xF981,0x5982,0xF982,
       0xF983,0x6B5F,0x6C5D,0xF984,0x74B5,0x7916,0xF985,
0x8207,0x8245,0x8339,0x8F3F,0x8F5D,0xF986,0x9918,0xF987,
0xF988,0xF989,0x4EA6,0xF98A,0x57DF,0x5F79,0x6613,0xF98B,
0xF98C,0x75AB,0x7E79,0x8B6F,0xF98D,0x9006,0x9A5B,0x56A5,
0x5827,0x59F8,0x5A1F,0x5BB4,0xF98E,0x5EF6,0xF98F,0xF990,
0x6350,0x633B,0xF991,0x693D,0x6C87,0x6CBF,0x6D8E,0x6D93,
0x6DF5,0x6F14,0xF992,0x70DF,0x7136,0x7159,0xF993,0x71C3,
0x71D5,0xF994,0x784F,0x786F,0xF995,0x7B75,0x7DE3,0xF996,
0x7E2F,0xF997,0x884D,0x8EDF,0xF998,0xF999,0xF99A,0x925B,
0xF99B,0x9CF6,0xF99C,0xF99D,0xF99E,0x6085,0x6D85,0xF99F,
0x71B1,0xF9A0,0xF9A1,0x95B1,0x53AD,0xF9A2,0xF9A3,0xF9A4,
0x67D3,0xF9A5,0x708E,0x7130,0x7430,0x8276,0x82D2,
       0xF9A6,0x95BB,0x9AE5,0x9E7D,0x66C4,0xF9A7,0x71C1,
0x8449,0xF9A8,0xF9A9,0x584B,0xF9AA,0xF9AB,0x5DB8,0x5F71,
0xF9AC,0x6620,0x668E,0x6979,0x69AE,0x6C38,0x6CF3,0x6E36,
0x6F41,0x6FDA,0x701B,0x702F,0x7150,0x71DF,0x7370,0xF9AD,
0x745B,0xF9AE,0x74D4,0x76C8,0x7A4E,0x7E93,0xF9AF,0xF9B0,
0x82F1,0x8A60,0x8FCE,0xF9B1,0x9348,0xF9B2,0x9719,0xF9B3,
0xF9B4,0x4E42,0x502A,0xF9B5,0x5208,0x53E1,0x66F3,0x6C6D,
0x6FCA,0x730A,0x777F,0x7A62,0x82AE,0x85DD,0x8602,0xF9B6,
0x88D4,0x8A63,0x8B7D,0x8C6B,0xF9B7,0x92B3,0xF9B8,0x9713,
0x9810,0x4E94,0x4F0D,0x4FC9,0x50B2,0x5348,0x543E,0x5433,
0x55DA,0x5862,0x58BA,0x5967,0x5A1B,0x5BE4,0x609F,0xF9B9,
0x61CA,0x6556,0x65FF,0x6664,0x68A7,0x6C5A,0x6FB3,
       0x70CF,0x71AC,0x7352,0x7B7D,0x8708,0x8AA4,0x9C32,
0x9F07,0x5C4B,0x6C83,0x7344,0x7389,0x923A,0x6EAB,0x7465,
0x761F,0x7A69,0x7E15,0x860A,0x5140,0x58C5,0x64C1,0x74EE,
0x7515,0x7670,0x7FC1,0x9095,0x96CD,0x9954,0x6E26,0x74E6,
0x7AA9,0x7AAA,0x81E5,0x86D9,0x8778,0x8A1B,0x5A49,0x5B8C,
0x5B9B,0x68A1,0x6900,0x6D63,0x73A9,0x7413,0x742C,0x7897,
0x7DE9,0x7FEB,0x8118,0x8155,0x839E,0x8C4C,0x962E,0x9811,
0x66F0,0x5F80,0x65FA,0x6789,0x6C6A,0x738B,0x502D,0x5A03,
0x6B6A,0x77EE,0x5916,0x5D6C,0x5DCD,0x7325,0x754F,0xF9BA,
0xF9BB,0x50E5,0x51F9,0x582F,0x592D,0x5996,0x59DA,0x5BE5,
0xF9BC,0xF9BD,0x5DA2,0x62D7,0x6416,0x6493,0x64FE,0xF9BE,
0x66DC,0xF9BF,0x6A48,0xF9C0,0x71FF,0x7464,0xF9C1,
       0x7A88,0x7AAF,0x7E47,0x7E5E,0x8000,0x8170,0xF9C2,
0x87EF,0x8981,0x8B20,0x9059,0xF9C3,0x9080,0x9952,0x617E,
0x6B32,0x6D74,0x7E1F,0x8925,0x8FB1,0x4FD1,0x50AD,0x5197,
0x52C7,0x57C7,0x5889,0x5BB9,0x5EB8,0x6142,0x6995,0x6D8C,
0x6E67,0x6EB6,0x7194,0x7462,0x7528,0x752C,0x8073,0x8338,
0x84C9,0x8E0A,0x9394,0x93DE,0xF9C4,0x4E8E,0x4F51,0x5076,
0x512A,0x53C8,0x53CB,0x53F3,0x5B87,0x5BD3,0x5C24,0x611A,
0x6182,0x65F4,0x725B,0x7397,0x7440,0x76C2,0x7950,0x7991,
0x79B9,0x7D06,0x7FBD,0x828B,0x85D5,0x865E,0x8FC2,0x9047,
0x90F5,0x91EA,0x9685,0x96E8,0x96E9,0x52D6,0x5F67,0x65ED,
0x6631,0x682F,0x715C,0x7A36,0x90C1,0x980A,0x4E91,0xF9C5,
0x6A52,0x6B9E,0x6F90,0x7189,0x8018,0x82B8,0x8553,
       0x904B,0x9695,0x96F2,0x97FB,0x851A,0x9B31,0x4E90,
0x718A,0x96C4,0x5143,0x539F,0x54E1,0x5713,0x5712,0x57A3,
0x5A9B,0x5AC4,0x5BC3,0x6028,0x613F,0x63F4,0x6C85,0x6D39,
0x6E72,0x6E90,0x7230,0x733F,0x7457,0x82D1,0x8881,0x8F45,
0x9060,0xF9C6,0x9662,0x9858,0x9D1B,0x6708,0x8D8A,0x925E,
0x4F4D,0x5049,0x50DE,0x5371,0x570D,0x59D4,0x5A01,0x5C09,
0x6170,0x6690,0x6E2D,0x7232,0x744B,0x7DEF,0x80C3,0x840E,
0x8466,0x853F,0x875F,0x885B,0x8918,0x8B02,0x9055,0x97CB,
0x9B4F,0x4E73,0x4F91,0x5112,0x516A,0xF9C7,0x552F,0x55A9,
0x5B7A,0x5BA5,0x5E7C,0x5E7D,0x5EBE,0x60A0,0x60DF,0x6108,
0x6109,0x63C4,0x6538,0x6709,0xF9C8,0x67D4,0x67DA,0xF9C9,
0x6961,0x6962,0x6CB9,0x6D27,0xF9CA,0x6E38,0xF9CB,
       0x6FE1,0x7336,0x7337,0xF9CC,0x745C,0x7531,0xF9CD,
0x7652,0xF9CE,0xF9CF,0x7DAD,0x81FE,0x8438,0x88D5,0x8A98,
0x8ADB,0x8AED,0x8E30,0x8E42,0x904A,0x903E,0x907A,0x9149,
0x91C9,0x936E,0xF9D0,0xF9D1,0x5809,0xF9D2,0x6BD3,0x8089,
0x80B2,0xF9D3,0xF9D4,0x5141,0x596B,0x5C39,0xF9D5,0xF9D6,
0x6F64,0x73A7,0x80E4,0x8D07,0xF9D7,0x9217,0x958F,0xF9D8,
0xF9D9,0xF9DA,0xF9DB,0x807F,0x620E,0x701C,0x7D68,0x878D,
0xF9DC,0x57A0,0x6069,0x6147,0x6BB7,0x8ABE,0x9280,0x96B1,
0x4E59,0x541F,0x6DEB,0x852D,0x9670,0x97F3,0x98EE,0x63D6,
0x6CE3,0x9091,0x51DD,0x61C9,0x81BA,0x9DF9,0x4F9D,0x501A,
0x5100,0x5B9C,0x610F,0x61FF,0x64EC,0x6905,0x6BC5,0x7591,
0x77E3,0x7FA9,0x8264,0x858F,0x87FB,0x8863,0x8ABC,
       0x8B70,0x91AB,0x4E8C,0x4EE5,0x4F0A,0xF9DD,0xF9DE,
0x5937,0x59E8,0xF9DF,0x5DF2,0x5F1B,0x5F5B,0x6021,0xF9E0,
0xF9E1,0xF9E2,0xF9E3,0x723E,0x73E5,0xF9E4,0x7570,0x75CD,
0xF9E5,0x79FB,0xF9E6,0x800C,0x8033,0x8084,0x82E1,0x8351,
0xF9E7,0xF9E8,0x8CBD,0x8CB3,0x9087,0xF9E9,0xF9EA,0x98F4,
0x990C,0xF9EB,0xF9EC,0x7037,0x76CA,0x7FCA,0x7FCC,0x7FFC,
0x8B1A,0x4EBA,0x4EC1,0x5203,0x5370,0xF9ED,0x54BD,0x56E0,
0x59FB,0x5BC5,0x5F15,0x5FCD,0x6E6E,0xF9EE,0xF9EF,0x7D6A,
0x8335,0xF9F0,0x8693,0x8A8D,0xF9F1,0x976D,0x9777,0xF9F2,
0xF9F3,0x4E00,0x4F5A,0x4F7E,0x58F9,0x65E5,0x6EA2,0x9038,
0x93B0,0x99B9,0x4EFB,0x58EC,0x598A,0x59D9,0x6041,0xF9F4,
0xF9F5,0x7A14,0xF9F6,0x834F,0x8CC3,0x5165,0x5344,
       0xF9F7,0xF9F8,0xF9F9,0x4ECD,0x5269,0x5B55,0x82BF,
0x4ED4,0x523A,0x54A8,0x59C9,0x59FF,0x5B50,0x5B57,0x5B5C,
0x6063,0x6148,0x6ECB,0x7099,0x716E,0x7386,0x74F7,0x75B5,
0x78C1,0x7D2B,0x8005,0x81EA,0x8328,0x8517,0x85C9,0x8AEE,
0x8CC7,0x96CC,0x4F5C,0x52FA,0x56BC,0x65AB,0x6628,0x707C,
0x70B8,0x7235,0x7DBD,0x828D,0x914C,0x96C0,0x9D72,0x5B71,
0x68E7,0x6B98,0x6F7A,0x76DE,0x5C91,0x66AB,0x6F5B,0x7BB4,
0x7C2A,0x8836,0x96DC,0x4E08,0x4ED7,0x5320,0x5834,0x58BB,
0x58EF,0x596C,0x5C07,0x5E33,0x5E84,0x5F35,0x638C,0x66B2,
0x6756,0x6A1F,0x6AA3,0x6B0C,0x6F3F,0x7246,0xF9FA,0x7350,
0x748B,0x7AE0,0x7CA7,0x8178,0x81DF,0x81E7,0x838A,0x846C,
0x8523,0x8594,0x85CF,0x88DD,0x8D13,0x91AC,0x9577,
       0x969C,0x518D,0x54C9,0x5728,0x5BB0,0x624D,0x6750,
0x683D,0x6893,0x6E3D,0x6ED3,0x707D,0x7E21,0x88C1,0x8CA1,
0x8F09,0x9F4B,0x9F4E,0x722D,0x7B8F,0x8ACD,0x931A,0x4F47,
0x4F4E,0x5132,0x5480,0x59D0,0x5E95,0x62B5,0x6775,0x696E,
0x6A17,0x6CAE,0x6E1A,0x72D9,0x732A,0x75BD,0x7BB8,0x7D35,
0x82E7,0x83F9,0x8457,0x85F7,0x8A5B,0x8CAF,0x8E87,0x9019,
0x90B8,0x96CE,0x9F5F,0x52E3,0x540A,0x5AE1,0x5BC2,0x6458,
0x6575,0x6EF4,0x72C4,0xF9FB,0x7684,0x7A4D,0x7B1B,0x7C4D,
0x7E3E,0x7FDF,0x837B,0x8B2B,0x8CCA,0x8D64,0x8DE1,0x8E5F,
0x8FEA,0x8FF9,0x9069,0x93D1,0x4F43,0x4F7A,0x50B3,0x5168,
0x5178,0x524D,0x526A,0x5861,0x587C,0x5960,0x5C08,0x5C55,
0x5EDB,0x609B,0x6230,0x6813,0x6BBF,0x6C08,0x6FB1,
       0x714E,0x7420,0x7530,0x7538,0x7551,0x7672,0x7B4C,
0x7B8B,0x7BAD,0x7BC6,0x7E8F,0x8A6E,0x8F3E,0x8F49,0x923F,
0x9293,0x9322,0x942B,0x96FB,0x985A,0x986B,0x991E,0x5207,
0x622A,0x6298,0x6D59,0x7664,0x7ACA,0x7BC0,0x7D76,0x5360,
0x5CBE,0x5E97,0x6F38,0x70B9,0x7C98,0x9711,0x9B8E,0x9EDE,
0x63A5,0x647A,0x8776,0x4E01,0x4E95,0x4EAD,0x505C,0x5075,
0x5448,0x59C3,0x5B9A,0x5E40,0x5EAD,0x5EF7,0x5F81,0x60C5,
0x633A,0x653F,0x6574,0x65CC,0x6676,0x6678,0x67FE,0x6968,
0x6A89,0x6B63,0x6C40,0x6DC0,0x6DE8,0x6E1F,0x6E5E,0x701E,
0x70A1,0x738E,0x73FD,0x753A,0x775B,0x7887,0x798E,0x7A0B,
0x7A7D,0x7CBE,0x7D8E,0x8247,0x8A02,0x8AEA,0x8C9E,0x912D,
0x914A,0x91D8,0x9266,0x92CC,0x9320,0x9706,0x9756,
       0x975C,0x9802,0x9F0E,0x5236,0x5291,0x557C,0x5824,
0x5E1D,0x5F1F,0x608C,0x63D0,0x68AF,0x6FDF,0x796D,0x7B2C,
0x81CD,0x85BA,0x88FD,0x8AF8,0x8E44,0x918D,0x9664,0x969B,
0x973D,0x984C,0x9F4A,0x4FCE,0x5146,0x51CB,0x52A9,0x5632,
0x5F14,0x5F6B,0x63AA,0x64CD,0x65E9,0x6641,0x66FA,0x66F9,
0x671D,0x689D,0x68D7,0x69FD,0x6F15,0x6F6E,0x7167,0x71E5,
0x722A,0x74AA,0x773A,0x7956,0x795A,0x79DF,0x7A20,0x7A95,
0x7C97,0x7CDF,0x7D44,0x7E70,0x8087,0x85FB,0x86A4,0x8A54,
0x8ABF,0x8D99,0x8E81,0x9020,0x906D,0x91E3,0x963B,0x96D5,
0x9CE5,0x65CF,0x7C07,0x8DB3,0x93C3,0x5B58,0x5C0A,0x5352,
0x62D9,0x731D,0x5027,0x5B97,0x5F9E,0x60B0,0x616B,0x68D5,
0x6DD9,0x742E,0x7A2E,0x7D42,0x7D9C,0x7E31,0x816B,
       0x8E2A,0x8E35,0x937E,0x9418,0x4F50,0x5750,0x5DE6,
0x5EA7,0x632B,0x7F6A,0x4E3B,0x4F4F,0x4F8F,0x505A,0x59DD,
0x80C4,0x546A,0x5468,0x55FE,0x594F,0x5B99,0x5DDE,0x5EDA,
0x665D,0x6731,0x67F1,0x682A,0x6CE8,0x6D32,0x6E4A,0x6F8D,
0x70B7,0x73E0,0x7587,0x7C4C,0x7D02,0x7D2C,0x7DA2,0x821F,
0x86DB,0x8A3B,0x8A85,0x8D70,0x8E8A,0x8F33,0x9031,0x914E,
0x9152,0x9444,0x99D0,0x7AF9,0x7CA5,0x4FCA,0x5101,0x51C6,
0x57C8,0x5BEF,0x5CFB,0x6659,0x6A3D,0x6D5A,0x6E96,0x6FEC,
0x710C,0x756F,0x7AE3,0x8822,0x9021,0x9075,0x96CB,0x99FF,
0x8301,0x4E2D,0x4EF2,0x8846,0x91CD,0x537D,0x6ADB,0x696B,
0x6C41,0x847A,0x589E,0x618E,0x66FE,0x62EF,0x70DD,0x7511,
0x75C7,0x7E52,0x84B8,0x8B49,0x8D08,0x4E4B,0x53EA,
       0x54AB,0x5730,0x5740,0x5FD7,0x6301,0x6307,0x646F,
0x652F,0x65E8,0x667A,0x679D,0x67B3,0x6B62,0x6C60,0x6C9A,
0x6F2C,0x77E5,0x7825,0x7949,0x7957,0x7D19,0x80A2,0x8102,
0x81F3,0x829D,0x82B7,0x8718,0x8A8C,0xF9FC,0x8D04,0x8DBE,
0x9072,0x76F4,0x7A19,0x7A37,0x7E54,0x8077,0x5507,0x55D4,
0x5875,0x632F,0x6422,0x6649,0x664B,0x686D,0x699B,0x6B84,
0x6D25,0x6EB1,0x73CD,0x7468,0x74A1,0x755B,0x75B9,0x76E1,
0x771E,0x778B,0x79E6,0x7E09,0x7E1D,0x81FB,0x852F,0x8897,
0x8A3A,0x8CD1,0x8EEB,0x8FB0,0x9032,0x93AD,0x9663,0x9673,
0x9707,0x4F84,0x53F1,0x59EA,0x5AC9,0x5E19,0x684E,0x74C6,
0x75BE,0x79E9,0x7A92,0x81A3,0x86ED,0x8CEA,0x8DCC,0x8FED,
0x659F,0x6715,0xF9FD,0x57F7,0x6F57,0x7DDD,0x8F2F,
       0x93F6,0x96C6,0x5FB5,0x61F2,0x6F84,0x4E14,0x4F98,
0x501F,0x53C9,0x55DF,0x5D6F,0x5DEE,0x6B21,0x6B64,0x78CB,
0x7B9A,0xF9FE,0x8E49,0x8ECA,0x906E,0x6349,0x643E,0x7740,
0x7A84,0x932F,0x947F,0x9F6A,0x64B0,0x6FAF,0x71E6,0x74A8,
0x74DA,0x7AC4,0x7C12,0x7E82,0x7CB2,0x7E98,0x8B9A,0x8D0A,
0x947D,0x9910,0x994C,0x5239,0x5BDF,0x64E6,0x672D,0x7D2E,
0x50ED,0x53C3,0x5879,0x6158,0x6159,0x61FA,0x65AC,0x7AD9,
0x8B92,0x8B96,0x5009,0x5021,0x5275,0x5531,0x5A3C,0x5EE0,
0x5F70,0x6134,0x655E,0x660C,0x6636,0x66A2,0x69CD,0x6EC4,
0x6F32,0x7316,0x7621,0x7A93,0x8139,0x8259,0x83D6,0x84BC,
0x50B5,0x57F0,0x5BC0,0x5BE8,0x5F69,0x63A1,0x7826,0x7DB5,
0x83DC,0x8521,0x91C7,0x91F5,0x518A,0x67F5,0x7B56,
       0x8CAC,0x51C4,0x59BB,0x60BD,0x8655,0x501C,0xF9FF,
0x5254,0x5C3A,0x617D,0x621A,0x62D3,0x64F2,0x65A5,0x6ECC,
0x7620,0x810A,0x8E60,0x965F,0x96BB,0x4EDF,0x5343,0x5598,
0x5929,0x5DDD,0x64C5,0x6CC9,0x6DFA,0x7394,0x7A7F,0x821B,
0x85A6,0x8CE4,0x8E10,0x9077,0x91E7,0x95E1,0x9621,0x97C6,
0x51F8,0x54F2,0x5586,0x5FB9,0x64A4,0x6F88,0x7DB4,0x8F1F,
0x8F4D,0x9435,0x50C9,0x5C16,0x6CBE,0x6DFB,0x751B,0x77BB,
0x7C3D,0x7C64,0x8A79,0x8AC2,0x581E,0x59BE,0x5E16,0x6377,
0x7252,0x758A,0x776B,0x8ADC,0x8CBC,0x8F12,0x5EF3,0x6674,
0x6DF8,0x807D,0x83C1,0x8ACB,0x9751,0x9BD6,0xFA00,0x5243,
0x66FF,0x6D95,0x6EEF,0x7DE0,0x8AE6,0x902E,0x905E,0x9AD4,
0x521D,0x527F,0x54E8,0x6194,0x6284,0x62DB,0x68A2,
       0x6912,0x695A,0x6A35,0x7092,0x7126,0x785D,0x7901,
0x790E,0x79D2,0x7A0D,0x8096,0x8278,0x82D5,0x8349,0x8549,
0x8C82,0x8D85,0x9162,0x918B,0x91AE,0x4FC3,0x56D1,0x71ED,
0x77D7,0x8700,0x89F8,0x5BF8,0x5FD6,0x6751,0x90A8,0x53E2,
0x585A,0x5BF5,0x60A4,0x6181,0x6460,0x7E3D,0x8070,0x8525,
0x9283,0x64AE,0x50AC,0x5D14,0x6700,0x589C,0x62BD,0x63A8,
0x690E,0x6978,0x6A1E,0x6E6B,0x76BA,0x79CB,0x82BB,0x8429,
0x8ACF,0x8DA8,0x8FFD,0x9112,0x914B,0x919C,0x9310,0x9318,
0x939A,0x96DB,0x9A36,0x9C0D,0x4E11,0x755C,0x795D,0x7AFA,
0x7B51,0x7BC9,0x7E2E,0x84C4,0x8E59,0x8E74,0x8EF8,0x9010,
0x6625,0x693F,0x7443,0x51FA,0x672E,0x9EDC,0x5145,0x5FE0,
0x6C96,0x87F2,0x885D,0x8877,0x60B4,0x81B5,0x8403,
       0x8D05,0x53D6,0x5439,0x5634,0x5A36,0x5C31,0x708A,
0x7FE0,0x805A,0x8106,0x81ED,0x8DA3,0x9189,0x9A5F,0x9DF2,
0x5074,0x4EC4,0x53A0,0x60FB,0x6E2C,0x5C64,0x4F88,0x5024,
0x55E4,0x5CD9,0x5E5F,0x6065,0x6894,0x6CBB,0x6DC4,0x71BE,
0x75D4,0x75F4,0x7661,0x7A1A,0x7A49,0x7DC7,0x7DFB,0x7F6E,
0x81F4,0x86A9,0x8F1C,0x96C9,0x99B3,0x9F52,0x5247,0x52C5,
0x98ED,0x89AA,0x4E03,0x67D2,0x6F06,0x4FB5,0x5BE2,0x6795,
0x6C88,0x6D78,0x741B,0x7827,0x91DD,0x937C,0x87C4,0x79E4,
0x7A31,0x5FEB,0x4ED6,0x54A4,0x553E,0x58AE,0x59A5,0x60F0,
0x6253,0x62D6,0x6736,0x6955,0x8235,0x9640,0x99B1,0x99DD,
0x502C,0x5353,0x5544,0x577C,0xFA01,0x6258,0xFA02,0x64E2,
0x666B,0x67DD,0x6FC1,0x6FEF,0x7422,0x7438,0x8A17,
       0x9438,0x5451,0x5606,0x5766,0x5F48,0x619A,0x6B4E,
0x7058,0x70AD,0x7DBB,0x8A95,0x596A,0x812B,0x63A2,0x7708,
0x803D,0x8CAA,0x5854,0x642D,0x69BB,0x5B95,0x5E11,0x6E6F,
0xFA03,0x8569,0x514C,0x53F0,0x592A,0x6020,0x614B,0x6B86,
0x6C70,0x6CF0,0x7B1E,0x80CE,0x82D4,0x8DC6,0x90B0,0x98B1,
0xFA04,0x64C7,0x6FA4,0x6491,0x6504,0x514E,0x5410,0x571F,
0x8A0E,0x615F,0x6876,0xFA05,0x75DB,0x7B52,0x7D71,0x901A,
0x5806,0x69CC,0x817F,0x892A,0x9000,0x9839,0x5078,0x5957,
0x59AC,0x6295,0x900F,0x9B2A,0x615D,0x7279,0x95D6,0x5761,
0x5A46,0x5DF4,0x628A,0x64AD,0x64FA,0x6777,0x6CE2,0x6D3E,
0x722C,0x7436,0x7834,0x7F77,0x82AD,0x8DDB,0x9817,0x5224,
0x5742,0x677F,0x7248,0x74E3,0x8CA9,0x8FA6,0x9211,
       0x962A,0x516B,0x53ED,0x634C,0x4F69,0x5504,0x6096,
0x6557,0x6C9B,0x6D7F,0x724C,0x72FD,0x7A17,0x8987,0x8C9D,
0x5F6D,0x6F8E,0x70F9,0x81A8,0x610E,0x4FBF,0x504F,0x6241,
0x7247,0x7BC7,0x7DE8,0x7FE9,0x904D,0x97AD,0x9A19,0x8CB6,
0x576A,0x5E73,0x67B0,0x840D,0x8A55,0x5420,0x5B16,0x5E63,
0x5EE2,0x5F0A,0x6583,0x80BA,0x853D,0x9589,0x965B,0x4F48,
0x5305,0x530D,0x530F,0x5486,0x54FA,0x5703,0x5E03,0x6016,
0x629B,0x62B1,0x6355,0xFA06,0x6CE1,0x6D66,0x75B1,0x7832,
0x80DE,0x812F,0x82DE,0x8461,0x84B2,0x888D,0x8912,0x900B,
0x92EA,0x98FD,0x9B91,0x5E45,0x66B4,0x66DD,0x7011,0x7206,
0xFA07,0x4FF5,0x527D,0x5F6A,0x6153,0x6753,0x6A19,0x6F02,
0x74E2,0x7968,0x8868,0x8C79,0x98C7,0x98C4,0x9A43,
       0x54C1,0x7A1F,0x6953,0x8AF7,0x8C4A,0x98A8,0x99AE,
0x5F7C,0x62AB,0x75B2,0x76AE,0x88AB,0x907F,0x9642,0x5339,
0x5F3C,0x5FC5,0x6CCC,0x73CC,0x7562,0x758B,0x7B46,0x82FE,
0x999D,0x4E4F,0x903C,0x4E0B,0x4F55,0x53A6,0x590F,0x5EC8,
0x6630,0x6CB3,0x7455,0x8377,0x8766,0x8CC0,0x9050,0x971E,
0x9C15,0x58D1,0x5B78,0x8650,0x8B14,0x9DB4,0x5BD2,0x6068,
0x608D,0x65F1,0x6C57,0x6F22,0x6FA3,0x701A,0x7F55,0x7FF0,
0x9591,0x9592,0x9650,0x97D3,0x5272,0x8F44,0x51FD,0x542B,
0x54B8,0x5563,0x558A,0x6ABB,0x6DB5,0x7DD8,0x8266,0x929C,
0x9677,0x9E79,0x5408,0x54C8,0x76D2,0x86E4,0x95A4,0x95D4,
0x965C,0x4EA2,0x4F09,0x59EE,0x5AE6,0x5DF7,0x6052,0x6297,
0x676D,0x6841,0x6C86,0x6E2F,0x7F38,0x809B,0x822A,
       0xFA08,0xFA09,0x9805,0x4EA5,0x5055,0x54B3,0x5793,
0x595A,0x5B69,0x5BB3,0x61C8,0x6977,0x6D77,0x7023,0x87F9,
0x89E3,0x8A72,0x8AE7,0x9082,0x99ED,0x9AB8,0x52BE,0x6838,
0x5016,0x5E78,0x674F,0x8347,0x884C,0x4EAB,0x5411,0x56AE,
0x73E6,0x9115,0x97FF,0x9909,0x9957,0x9999,0x5653,0x589F,
0x865B,0x8A31,0x61B2,0x6AF6,0x737B,0x8ED2,0x6B47,0x96AA,
0x9A57,0x5955,0x7200,0x8D6B,0x9769,0x4FD4,0x5CF4,0x5F26,
0x61F8,0x665B,0x6CEB,0x70AB,0x7384,0x73B9,0x73FE,0x7729,
0x774D,0x7D43,0x7D62,0x7E23,0x8237,0x8852,0xFA0A,0x8CE2,
0x9249,0x986F,0x5B51,0x7A74,0x8840,0x9801,0x5ACC,0x4FE0,
0x5354,0x593E,0x5CFD,0x633E,0x6D79,0x72F9,0x8105,0x8107,
0x83A2,0x92CF,0x9830,0x4EA8,0x5144,0x5211,0x578B,
       0x5F62,0x6CC2,0x6ECE,0x7005,0x7050,0x70AF,0x7192,
0x73E9,0x7469,0x834A,0x87A2,0x8861,0x9008,0x90A2,0x93A3,
0x99A8,0x516E,0x5F57,0x60E0,0x6167,0x66B3,0x8559,0x8E4A,
0x91AF,0x978B,0x4E4E,0x4E92,0x547C,0x58D5,0x58FA,0x597D,
0x5CB5,0x5F27,0x6236,0x6248,0x660A,0x6667,0x6BEB,0x6D69,
0x6DCF,0x6E56,0x6EF8,0x6F94,0x6FE0,0x6FE9,0x705D,0x72D0,
0x7425,0x745A,0x74E0,0x7693,0x795C,0x7CCA,0x7E1E,0x80E1,
0x82A6,0x846B,0x84BF,0x864E,0x865F,0x8774,0x8B77,0x8C6A,
0x93AC,0x9800,0x9865,0x60D1,0x6216,0x9177,0x5A5A,0x660F,
0x6DF7,0x6E3E,0x743F,0x9B42,0x5FFD,0x60DA,0x7B0F,0x54C4,
0x5F18,0x6C5E,0x6CD3,0x6D2A,0x70D8,0x7D05,0x8679,0x8A0C,
0x9D3B,0x5316,0x548C,0x5B05,0x6A3A,0x706B,0x7575,
       0x798D,0x79BE,0x82B1,0x83EF,0x8A71,0x8B41,0x8CA8,
0x9774,0xFA0B,0x64F4,0x652B,0x78BA,0x78BB,0x7A6B,0x4E38,
0x559A,0x5950,0x5BA6,0x5E7B,0x60A3,0x63DB,0x6B61,0x6665,
0x6853,0x6E19,0x7165,0x74B0,0x7D08,0x9084,0x9A69,0x9C25,
0x6D3B,0x6ED1,0x733E,0x8C41,0x95CA,0x51F0,0x5E4C,0x5FA8,
0x604D,0x60F6,0x6130,0x614C,0x6643,0x6644,0x69A5,0x6CC1,
0x6E5F,0x6EC9,0x6F62,0x714C,0x749C,0x7687,0x7BC1,0x7C27,
0x8352,0x8757,0x9051,0x968D,0x9EC3,0x532F,0x56DE,0x5EFB,
0x5F8A,0x6062,0x6094,0x61F7,0x6666,0x6703,0x6A9C,0x6DEE,
0x6FAE,0x7070,0x736A,0x7E6A,0x81BE,0x8334,0x86D4,0x8AA8,
0x8CC4,0x5283,0x7372,0x5B96,0x6A6B,0x9404,0x54EE,0x5686,
0x5B5D,0x6548,0x6585,0x66C9,0x689F,0x6D8D,0x6DC6,
       0x723B,0x80B4,0x9175,0x9A4D,0x4FAF,0x5019,0x539A,
0x540E,0x543C,0x5589,0x55C5,0x5E3F,0x5F8C,0x673D,0x7166,
0x73DD,0x9005,0x52DB,0x52F3,0x5864,0x58CE,0x7104,0x718F,
0x71FB,0x85B0,0x8A13,0x6688,0x85A8,0x55A7,0x6684,0x714A,
0x8431,0x5349,0x5599,0x6BC1,0x5F59,0x5FBD,0x63EE,0x6689,
0x7147,0x8AF1,0x8F1D,0x9EBE,0x4F11,0x643A,0x70CB,0x7566,
0x8667,0x6064,0x8B4E,0x9DF8,0x5147,0x51F6,0x5308,0x6D36,
0x80F8,0x9ED1,0x6615,0x6B23,0x7098,0x75D5,0x5403,0x5C79,
0x7D07,0x8A16,0x6B20,0x6B3D,0x6B46,0x5438,0x6070,0x6D3D,
0x7FD5,0x8208,0x50D6,0x51DE,0x559C,0x566B,0x56CD,0x59EC,
0x5B09,0x5E0C,0x6199,0x6198,0x6231,0x665E,0x66E6,0x7199,
0x71B9,0x71BA,0x72A7,0x79A7,0x7A00,0x7FB2,0x8A70,
0/*  End of table; # of entries=8741(0x2225)+1 */

};
int ksc5601max=sizeof(tabksc5601)/sizeof(tabksc5601[0])-1;
        /* # of entries in the table. */
