dnl AC_C_ATTRIBUTE_PACKED
dnl set ATTRIBUTE_PACKED if this is supported
AC_DEFUN([AC_C_ATTRIBUTE_PACKED],
    [AC_CACHE_CHECK([__attribute__ ((packed)) support],
	[ac_cv_c_attribute_packed],
	[AC_TRY_COMPILE([],
		[static struct { int a; } __attribute__ ((packed)) c = {0};],
		[ac_cv_c_attribute_packed=yes],
		[ac_cv_c_attribute_packed=no])
	])
     if test x"$ac_cv_c_attribute_packed" = x"yes"; then
	ATTRIBUTE_PACKED="__attribute__ ((packed))"
     fi])


dnl The following AC macros are from mpeg2dec.
dnl Written by Michel Lespinasse <walken@zoy.org>

dnl AC_C_ATTRIBUTE_ALIGNED
dnl define ATTRIBUTE_ALIGNED_MAX to the maximum alignment if this is supported
AC_DEFUN([AC_C_ATTRIBUTE_ALIGNED],
    [AC_CACHE_CHECK([__attribute__ ((aligned ())) support],
	[ac_cv_c_attribute_aligned],
	[ac_cv_c_attribute_aligned=0
	for ac_cv_c_attr_align_try in 2 4 8 16 32 64; do
	    AC_TRY_COMPILE([],
		[static char c __attribute__ ((aligned($ac_cv_c_attr_align_try))) = 0; return c;],
		[ac_cv_c_attribute_aligned=$ac_cv_c_attr_align_try])
	done])
    if test x"$ac_cv_c_attribute_aligned" != x"0"; then
	AC_DEFINE_UNQUOTED([ATTRIBUTE_ALIGNED_MAX],
	    [$ac_cv_c_attribute_aligned],[maximum supported data alignment])
    fi])

dnl AC_TRY_CFLAGS (CFLAGS, [ACTION-IF-WORKS], [ACTION-IF-FAILS])
dnl check if $CC supports a given set of cflags
AC_DEFUN([AC_TRY_CFLAGS],
    [AC_MSG_CHECKING([if $CC supports $1 flags])
    SAVE_CFLAGS="$CFLAGS"
    CFLAGS="$1"
    AC_TRY_COMPILE([],[],[ac_cv_try_cflags_ok=yes],[ac_cv_try_cflags_ok=no])
    CFLAGS="$SAVE_CFLAGS"
    AC_MSG_RESULT([$ac_cv_try_cflags_ok])
    if test x"$ac_cv_try_cflags_ok" = x"yes"; then
	ifelse([$2],[],[:],[$2])
    else
	ifelse([$3],[],[:],[$3])
    fi])
