/*
 *  GTetrinet
 *  Copyright (C) 1999, 2000, 2001, 2002, 2003  Ka-shu Wong (kswong@zip.com.au)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
# include "../config.h"
#endif

#include <gtk/gtk.h>
#include <gnome.h>
#include <string.h>
#include <stdio.h>

#include "client.h"
#include "tetrinet.h"
#include "winlist.h"
#include "misc.h"

static GtkWidget *winlist;
static GdkPixbuf *team_icon, *alone_icon;

GtkWidget *winlist_page_new (void)
{
    GtkWidget *align, *scroll;
    GtkCellRenderer *renderer = gtk_cell_renderer_text_new ();
    GtkCellRenderer *pixbuf_renderer = gtk_cell_renderer_pixbuf_new ();
    GtkListStore *winlist_store = gtk_list_store_new (3, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING);
    GdkPixbuf *pixbuf;

    /* Load the icons and scale them */
    pixbuf = gdk_pixbuf_new_from_file (GTETPIXMAPSDIR "/team.png",  NULL);
    team_icon = gdk_pixbuf_scale_simple (pixbuf, 24, 24, GDK_INTERP_BILINEAR);
    gdk_pixbuf_unref (pixbuf);
    
    pixbuf = gdk_pixbuf_new_from_file (GTETPIXMAPSDIR "/alone.png", NULL);
    alone_icon = gdk_pixbuf_scale_simple (pixbuf, 24, 24, GDK_INTERP_BILINEAR);
    gdk_pixbuf_unref (pixbuf);

    winlist = gtk_tree_view_new_with_model (GTK_TREE_MODEL (winlist_store));

    /* "T" stands for "Team" here */
    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (winlist), -1, _("T"), pixbuf_renderer,
                                                 "pixbuf", 0, NULL);
    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (winlist), -1, _("Name"), renderer,
                                                 "text", 1, NULL);
    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (winlist), -1, _("Score"), renderer,
                                                 "text", 2, NULL);

    gtk_widget_set_size_request (winlist, 360, 0);
    
    scroll = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_container_add (GTK_CONTAINER (scroll), winlist);
    align = gtk_alignment_new (0.5, 0.5, 0.0, 0.8);
    gtk_container_add (GTK_CONTAINER(align), scroll);
    gtk_container_set_border_width (GTK_CONTAINER(align), 2);
    gtk_widget_show_all (align);
    
    return align;
}

void winlist_clear (void)
{
    GtkListStore *winlist_model = GTK_LIST_STORE (gtk_tree_view_get_model (GTK_TREE_VIEW (winlist)));
  
    gtk_list_store_clear (winlist_model);
}

void winlist_additem (int team, char *name, int score)
{
    GtkListStore *winlist_model = GTK_LIST_STORE (gtk_tree_view_get_model (GTK_TREE_VIEW (winlist)));
    GtkTreeIter iter;
    char buf[16], *item[2];
    GdkPixbuf *pixbuf;

    if (team) pixbuf = team_icon;
    else pixbuf = alone_icon;
    item[0] = nocolor (name);
    g_snprintf (buf, sizeof(buf), "%d", score);
    item[1] = buf;

    gtk_list_store_append (winlist_model, &iter);
    gtk_list_store_set (winlist_model, &iter,
                        0, pixbuf,
                        1, item[0],
                        2, item[1],
                        -1);
}

void winlist_focus (void)
{
  gtk_widget_grab_focus (winlist);
}
