/***********************************************************************

Copyright (c) 2001,2002 Fritz Ganter <ganter@ganter.at>

Website: www.gpsdrive.de

Disclaimer: Please do not use for navigation.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*********************************************************************/


/*
 * Track support module: display, disk loading/saving.
 */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#include "gpsdrive.h"
#include "track.h"


extern gint maploaded;
extern gint trackflag;
extern gint importactive;
extern glong tracknr, tracklimit, trackcoordlimit;
extern glong trackcoordnr;
extern trackcoordstruct *trackcoord;
extern gint zoom;
extern trackstruct *track;
extern trackstruct *trackshadow;

extern void calcxy (gdouble *posx, gdouble *posy, gdouble lon, gdouble lat,
		    gint zoom);


/*  if zoom, xoff, yoff or map are changed */
void
rebuildtracklist (void)
{
  gdouble posxdest, posydest;
  gint i, so;

  if (!maploaded)
    return;

  if (!trackflag)
    return;
  if (importactive)
    return;

  tracknr = 0;
  for (i = 0; i < trackcoordnr; i++)
    {
      calcxy (&posxdest, &posydest, (trackcoord + i)->longi,
	      (trackcoord + i)->lat, zoom);

      if ((tracknr & 1) == 0)
	{
	  if ((trackcoord + i)->longi < 1000.0)
	    {
	      (track + tracknr)->x = posxdest;
	      (track + tracknr)->y = posydest;
	      (trackshadow + tracknr)->x = posxdest + SHADOWOFFSET;
	      (trackshadow + tracknr)->y = posydest + SHADOWOFFSET;
	      tracknr++;
	    }
	}
      else
	{
	  if ((trackcoord + i)->longi < 1000.0)
	    {
	      if ((posxdest > -50) && (posxdest < (SCREEN_X + 50))
		  && (posydest > -50) && (posydest < (SCREEN_Y + 50)))
		{
		  if ((posxdest != (track + tracknr - 1)->x)
		      || (posydest != (track + tracknr - 1)->y))
		    {
/*  		so=(int)(((trackcoord + i)->alt))>>5; */
		      so = SHADOWOFFSET;

		      (track + tracknr)->x = (track + tracknr + 1)->x =
			posxdest;
		      (track + tracknr)->y = (track + tracknr + 1)->y =
			posydest;
		      (trackshadow + tracknr)->x =
			(trackshadow + tracknr + 1)->x = posxdest + so;
		      (trackshadow + tracknr)->y =
			(trackshadow + tracknr + 1)->y = posydest + so;
		      tracknr += 2;
		    }
		}
	    }
	  else
	    tracknr = tracknr & ((glong) - 2);
	}

    }

}


/* draw track on image */
void
drawtracks (void)
{
  gint t;

/*    if (!maploaded) */
/*      return; */
  if (!trackflag)
    return;
  if (importactive)
    return;
  t = tracknr >> 1;
  if (t < 1)
    return;


  gdk_gc_set_line_attributes (kontext, 4, 0, 0, 0);
  if (shadow)
    {
      gdk_gc_set_foreground (kontext, &darkgrey);
      gdk_gc_set_function (kontext, GDK_AND);
      gdk_draw_segments (drawable, kontext, (GdkSegment *) trackshadow, t);
      gdk_gc_set_function (kontext, GDK_COPY);
    }
  gdk_gc_set_foreground (kontext, &green);
  gdk_draw_segments (drawable, kontext, (GdkSegment *) track, t);

  return;

}


/* stores the track into a file, if argument testname is true, no saving is 
   done, only savetrackfn is set */
void
savetrackfile (gint testname)
{
  struct stat sbuf;
  gchar buff[1024];
  gint e, i;
  gchar mappath[400], lat[30], alt[30], longi[30];
  FILE *st;

  if (testname)
    {
      i = 0;
      do
	{
	  sprintf (buff, "%strack%04d.sav", homedir, i++);
	  e = stat (buff, &sbuf);
	}
      while (e == 0);
      strcpy (savetrackfn, g_basename (buff));
      return;
    }

/* save in new file */
  strcpy (mappath, homedir);
  strcat (mappath, savetrackfn);
  st = fopen (mappath, "w");
  if (st == NULL)
    {
      perror (mappath);
      return;
    }

  for (i = 0; i < trackcoordnr; i++)
    {
      sprintf (lat, "%10.6f", (trackcoord + i)->lat);
      g_strdelimit (lat, ",", '.');
      sprintf (longi, "%10.6f", (trackcoord + i)->longi);
      g_strdelimit (longi, ",", '.');
      sprintf (alt, "%10.0f", (trackcoord + i)->alt);

      fprintf (st, "%s %s %s %s\n", lat, longi, alt,
	       (trackcoord + i)->postime);
    }
  fclose (st);

/* append to existing backup file */
  strcpy (mappath, homedir);
  strcat (mappath, "track-ALL.sav");
  st = fopen (mappath, "a");
  if (st == NULL)
    {
      perror (mappath);
      return;
    }

  for (i = 0; i < trackcoordnr; i++)
    {
      sprintf (lat, "%10.6f", (trackcoord + i)->lat);
      g_strdelimit (lat, ",", '.');
      sprintf (longi, "%10.6f", (trackcoord + i)->longi);
      g_strdelimit (longi, ",", '.');
      sprintf (alt, "%10.0f", (trackcoord + i)->alt);

      fprintf (st, "%s %s %s %s\n", lat, longi, alt,
	       (trackcoord + i)->postime);
    }
  fclose (st);

}


gint
gettrackfile (GtkWidget *widget, gpointer datum)
{
  gchar *fn, buf[520], lat[30], longi[30], alt[30], str[30];
  FILE *st;
  gint i;

  fn = gtk_file_selection_get_filename (datum);
  st = fopen (fn, "r");
  if (st == NULL)
    {
      perror (fn);
      return TRUE;
    }
  g_free (trackcoord);
  g_free (track);
  g_free (trackshadow);
  track = g_new (trackstruct, 100000);
  trackshadow = g_new (trackstruct, 100000);
  tracknr = 0;
  tracklimit = 100000;
  trackcoord = g_new (trackcoordstruct, 100000);
  trackcoordnr = 0;
  trackcoordlimit = 100000;
  i = 0;
  while (fgets (buf, 512, st))
    {
      sscanf (buf, "%s %s %s %[^\n]", lat, longi, alt, str);
      strcpy ((trackcoord + i)->postime, str);
      (trackcoord + i)->lat = g_strtod (lat, NULL);
      (trackcoord + i)->longi = g_strtod (longi, NULL);
      (trackcoord + i)->alt = g_strtod (alt, NULL);
      i++;
      trackcoordnr++;

      if ((trackcoordnr * 2) > (trackcoordlimit - 1000))
	{
	  trackcoord =
	    g_renew (trackcoordstruct, trackcoord, trackcoordlimit + 100000);
	  trackcoordlimit += 100000;
	  track = g_renew (trackstruct, track, tracklimit + 100000);
	  trackshadow =
	    g_renew (trackstruct, trackshadow, tracklimit + 100000);
	  tracklimit += 100000;
	}


    }
  (trackcoord + i)->lat = 1001.0;
  (trackcoord + i)->longi = 1001.0;

  trackcoordnr++;

  rebuildtracklist ();
  fclose (st);
  gtk_widget_destroy (datum);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (trackbt), TRUE);

  return TRUE;
}
