/*

Copyright (c) 2001,2002 Fritz Ganter <ganter@ganter.at>

Website: www.gpsdrive.de

Disclaimer: Please do not use for navigation. 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    *********************************************************************


$Log: splash.c,v $
Revision 1.50  2002/11/25 01:15:17  ganter
...

Revision 1.49  2002/11/24 23:36:18  ganter
added icon

Revision 1.48  2002/11/02 12:38:55  ganter
changed website to www.gpsdrive.de

Revision 1.47  2002/10/27 10:51:30  ganter
1.28pre8

Revision 1.46  2002/10/24 08:44:09  ganter
...

Revision 1.45  2002/10/16 14:16:13  ganter
working on SQL gui

Revision 1.44  2002/10/15 07:44:11  ganter
...

Revision 1.43  2002/10/14 08:38:59  ganter
v1.29pre3
added SQL support

Revision 1.42  2002/09/24 08:51:55  ganter
updated translations
changed gpsdrive.spec

Revision 1.41  2002/09/23 07:51:35  ganter
splited help text in more strings
v1.28pre2

Revision 1.40  2002/07/30 21:33:53  ganter
added "J" key to switch to next waypoint

Revision 1.39  2002/06/29 00:23:18  ganter
added ACPI support for battery meter

Revision 1.38  2002/06/23 17:09:35  ganter
v1.23pre9
now PDA mode looks good.

Revision 1.37  2002/06/02 20:54:10  ganter
added navigation.c and copyrights

Revision 1.36  2002/05/23 09:07:37  ganter
v1.23pre1
added new BSD battery stuff

Revision 1.35  2002/05/20 20:40:23  ganter
v1.22

Revision 1.34  2002/05/20 10:02:48  ganter
v1.22pre7

Revision 1.33  2002/05/12 23:14:53  ganter
new 1.21
changed B to N key.

Revision 1.32  2002/05/12 20:54:08  ganter
v1.21

Revision 1.31  2002/05/11 15:45:31  ganter
v1.21pre1
degree,minutes,seconds should work now

Revision 1.30  2002/05/02 01:34:11  ganter
added speech output of waypoint description

Revision 1.29  2002/04/29 02:52:18  ganter
v1.20pre1
added display of sat position

Revision 1.28  2002/04/28 11:53:43  ganter
v1.19pre2
button to delete waypoint
fixed miles distance on startup in miles mode
new sat level display colors

Revision 1.27  2002/04/14 15:25:56  ganter
v1.17pre3
added simulaton follow switch in setup menu

Revision 1.26  2002/04/13 17:30:35  ganter
v1.17pre2

Revision 1.25  2002/04/06 17:08:56  ganter
v1.16pre8
cleanup of gpsd files

Revision 1.24  2002/04/02 19:46:15  ganter
v1.16pre4
you can type in coordinates in the "Add waypoint" window (x-key)
Autosave of configuration
update spanish translation (translater had holiday)

Revision 1.23  2002/04/01 22:32:04  ganter
added garmin and serialdevice in setup

Revision 1.22  2002/03/31 18:11:07  ganter
v1.15-pre5
you can select your "way*.txt" file in setup menu
The DEFAUL entry in way.txt is now obsolet
The "setdefaultpos" entry in gpsdricerc in now obsolet

Revision 1.21  2002/03/30 20:07:33  ganter
2nd pre 1.15

Revision 1.20  2002/03/30 10:37:43  ganter
pre 1.15

Revision 1.19  2002/03/24 17:45:26  ganter
v1.14 some cosmetic changes

Revision 1.18  2002/03/22 00:36:40  ganter
bugfix for late gpsd start
remembering last position if setdefaultpos = 0 in gpsdriverc

Revision 1.17  2002/03/21 21:49:08  ganter
added question if gpsd should be started.
Thanks to daZwerg(gEb-Dude) for suggestion.

Revision 1.16  2002/03/16 20:21:07  ganter
fixed segfault if no gpsdriverc exists. New v1.11

Revision 1.15  2002/03/16 19:17:59  ganter
v1.11

Revision 1.14  2002/02/26 15:34:17  ganter
added x key for set waypoint on actual position

Revision 1.13  2002/02/24 22:26:41  ganter
new v1.9, added shortcuts

Revision 1.12  2002/02/24 16:40:37  ganter
v1.9

Revision 1.11  2002/02/18 01:50:39  ganter
changed help text

Revision 1.10  2001/10/14 10:41:59  ganter
v0.32 correct path for prefix other than /usr/local

Revision 1.9  2001/10/13 23:04:56  ganter
corrected paths for locale and pixmap, ./configure --prefix= works now as
expected

Revision 1.8  2001/09/30 18:45:27  ganter
v0.29
added choice of map type

Revision 1.7  2001/09/30 15:54:32  ganter
added minimap, removed gpsdrivelogo

Revision 1.6  2001/09/28 15:43:56  ganter
v0.28 changed layout, some bugfixes

Revision 1.5  2001/08/29 19:05:20  ganter
trying splashfile also in current dir

Revision 1.4  2001/08/29 13:59:56  ganter
removed large xpm file, load png instead

Revision 1.3  2001/08/26 15:49:09  ganter
indent

Revision 1.2  2001/08/26 15:47:19  ganter
works fine

Revision 1.1  2001/08/26 15:03:15  ganter
added splash.c

*/
#include "gtk/gtk.h"
#include "gdk-pixbuf/gdk-pixbuf.h"
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/*  Defines for gettext I18n */
# include <libintl.h>
# define _(String) gettext(String)
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif


extern GtkWidget *hauptfenster;
GtkWidget *splash_window;
extern gchar homedir[500], mapdir[500];
extern gint wpflag, trackflag, muteflag, displaymap_top, displaymap_map;
extern gint scaleprefered, milesflag, nauticflag, metricflag, sqlflag;
extern gint debug, scalewanted, savetrack, defaultserver;
extern gchar serialdev[80];
extern gdouble current_long, current_lat, old_long, old_lat, groundspeed;
extern gint setdefaultpos, shadow, testgarmin, needtosave, usedgps, simfollow;
extern gchar activewpfile[200];
extern gint bestmap_cb (GtkWidget *widget, guint datum);
extern gdouble milesconv;
extern gint satposmode, printoutsats, minsecmode, nightmode, slowcpu;
/* extern gint flymode, vfr,disdevwarn; */
gint flymode = FALSE, vfr = 1, disdevwarn = TRUE;
extern gint pdamode;
extern gint real_screen_x, real_screen_y, real_psize, real_smallmenu,
  int_padding, lastnotebook;
#define MAXDBNAME 30
extern char dbhost[MAXDBNAME], dbuser[MAXDBNAME], dbpass[MAXDBNAME];
extern char dbtable[MAXDBNAME], dbname[MAXDBNAME];
extern char dbwherestring[5000];
extern char dbtypelist[100][40];
extern double dbdistance;
extern int dbusedist;


#define KM2MILES 0.62137119
#define KM2NAUTIC  0.54
#define PADDING int_padding

void splash (void);

gint
splashaway_cb (GtkWidget *widget, gpointer datum)
{
  gtk_widget_destroy (splash_window);
  return (FALSE);
}

void
splash (void)
{
  gchar xpmfile[400];
  GdkPixbuf *image;
  GdkPixmap *ip_pixmap;
  GdkBitmap *ip_bitmap;
  GtkWidget *pixm;

/*  I don't know where the right place for pixmaps is */
  sprintf (xpmfile, "%s/%s", DATADIR, "gpsdrivesplash.png");

/* Splash Window */
  splash_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (splash_window), "gpsdrive");
  gtk_window_set_position (GTK_WINDOW (splash_window), GTK_WIN_POS_CENTER);

  gtk_widget_realize (splash_window);
  gdk_window_set_decorations (GTK_WIDGET (splash_window)->window, 0);

  gtk_widget_realize (splash_window);
  image = gdk_pixbuf_new_from_file (xpmfile);
  if (image == NULL)
    {
/*  	ok, file is not where it should, trying current directory */
      image = gdk_pixbuf_new_from_file ("gpsdrivesplash.png");
    }

/*  file couldn't be loaded */
  if (image == NULL)
    {
      g_print ("\nunable to open splash picture\n");
      return;
    }
  gdk_pixbuf_render_pixmap_and_mask (image, &ip_pixmap, &ip_bitmap, 128);
  pixm = gtk_pixmap_new (ip_pixmap, ip_bitmap);
  gdk_pixbuf_unref (image);
  gdk_pixmap_unref (ip_pixmap);
  if (ip_bitmap)
    {
      gdk_bitmap_unref (ip_bitmap);
    }


  gtk_container_add (GTK_CONTAINER (splash_window), pixm);

  gtk_widget_show (pixm);
  gtk_widget_show (splash_window);
  while (gtk_events_pending ())
    gtk_main_iteration ();

  gtk_timeout_add (3000, (GtkFunction) splashaway_cb, NULL);

}


gint
help_cb (GtkWidget *widget, guint datum)
{

  GtkWidget *popup;
  GtkWidget *knopf2;
  GtkWidget *text;
  GtkWidget *scrollbar;
  GtkWidget *hbox;
  gchar *t1 = _("GpsDrive Help\n\n");
  gchar *t2 = _("GPSDRIVE (c) 2001,2002 Fritz Ganter <ganter@ganter.at>\n\n");
  gchar *t3 = "-------------------------------------------------\n";
  gchar *t4 = _("Website: www.kraftvoll.at/software\n");
  gchar *t5 = _("Disclaimer: Please do not use for navigation. \n\n");
  gchar *t6 = "*************************************************\n\n";
  gchar *t7 = _("See the manpage for program details\n\n");
  gchar *t8 = _("Mouse control (clicking on the map):\n");
  gchar *t9 = "===================================\n";
  gchar *t10 =
    _
    ("Left mouse button         : Set position (usefull in simulation mode)\n");
  gchar *t11 =
    _("Right mouse button        : Set target directly on the map\n");
  gchar *t12 = _("Middle mouse button       : Display position again\n");
  gchar *t13 = _("Shift left mouse button   : smaller map\n");
  gchar *t14 = _("Shift right mouse button  : larger map\n");
  gchar *t15 =
    _
    ("Control left mouse button : Set a waypoint (mouse position) on the map\n");
  gchar *t16 =
    _
    ("Control right mouse button: Set a waypoint at current position on the map\n\n");
  gchar *t17 = _("Short cuts:\n");
  gchar *t18 = "===================================\n";
  gchar *t19 = _("+    : Zoom in\n");
  gchar *t20 = _("-    : Zoom out\n");
  gchar *t21 = _("s    : larger map\n");
  gchar *t22 = _("a    : smaller map\n");
  gchar *t23 = _("t    : select target\n");
  gchar *t24 = _("d    : download map\n");
  gchar *t25 = _("i    : import map\n");
  gchar *t26 = _("l    : load track\n");
  gchar *t27 = _("h    : show help\n");
  gchar *t28 = _("q    : quit program\n");
  gchar *t29 = _("b    : toggle auto best map\n");
  gchar *t30 = _("w    : toggle show waypoints\n");
  gchar *t31 = _("o    : toggle show tracks\n");
  gchar *t32 = _("u    : enter setup menu\n");
  gchar *t33 = _("n    : in nightmode: toogles night display on/off\n");
  gchar *t34 = _("j    : switch to next waypoint in route mode\n");
  gchar *t35 = _("p    : switch to position mode\n");
  gchar *t36 = _("x    : add waypoint at current position\n\n");
  gchar *t37 = _("Suggestions welcome!\n\n");
  gchar *t38 = _("Have a lot of fun!\n\n");
  gchar *meintext =
    g_strconcat (t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14,
		 t15, t16, t17, t18, t19, t20, t21, t22, t23, t24, t25, t26,
		 t27, t28, t29, t30, t31, t32, t33, t34, t35, t36, t37, t38,
		 NULL);


  popup = gtk_dialog_new ();

  gtk_window_set_title (GTK_WINDOW (popup), _("GpsDrive Help"));
  if (pdamode)
    gtk_window_set_default_size (GTK_WINDOW (popup), real_screen_x,
				 real_screen_y);
  else
    gtk_window_set_default_size (GTK_WINDOW (popup), 550, 450);

  knopf2 = gtk_button_new_with_label (_("   Ok   "));
  gtk_signal_connect_object (GTK_OBJECT (knopf2), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (popup));
  gtk_container_set_border_width (GTK_CONTAINER (popup), 5 * PADDING);
  GTK_WIDGET_SET_FLAGS (knopf2, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (popup), knopf2);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (popup)->action_area), knopf2,
		      FALSE, FALSE, 20 * PADDING);

  text = gtk_text_new (NULL, NULL);
  gtk_text_set_line_wrap (GTK_TEXT (text), TRUE);
  gtk_text_set_word_wrap (GTK_TEXT (text), TRUE);
  scrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
  gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, meintext, -1);
  hbox = gtk_hbox_new (FALSE, 3 * PADDING);
  gtk_box_pack_start (GTK_BOX (hbox), text, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), scrollbar, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (popup)->vbox), hbox, TRUE,
		      TRUE, 10 * PADDING);
  gtk_window_set_position (GTK_WINDOW (popup), GTK_WIN_POS_CENTER);
  gtk_widget_show_all (popup);


  return TRUE;

}

/*  write the configurationfile ~/.gpsdrive/gpsdriverc */
void
writeconfig ()
{
  FILE *fp;
  gchar fname[220], str[40];

  strcpy (fname, homedir);
  strcat (fname, "gpsdriverc");
  fp = fopen (fname, "w");
  if (fp == NULL)
    {
      perror (_("Error saving config file ~/.gpsdrive/gpsdriverc"));
      return;
    }

  fprintf (fp, "showwaypoints = ");
  if (wpflag)
    fprintf (fp, "1\n");
  else
    fprintf (fp, "0\n");

  fprintf (fp, "showtrack = ");
  if (trackflag)
    fprintf (fp, "1\n");
  else
    fprintf (fp, "0\n");

  fprintf (fp, "mutespeechoutput = ");
  if (muteflag)
    fprintf (fp, "1\n");
  else
    fprintf (fp, "0\n");

  fprintf (fp, "showtopomaps = ");
  if (displaymap_top)
    fprintf (fp, "1\n");
  else
    fprintf (fp, "0\n");

  fprintf (fp, "showstreetmaps = ");
  if (displaymap_map)
    fprintf (fp, "1\n");
  else
    fprintf (fp, "0\n");

  fprintf (fp, "autobestmap = ");
  if (!scaleprefered)
    fprintf (fp, "1\n");
  else
    fprintf (fp, "0\n");

  fprintf (fp, "units = ");
  if (milesflag)
    fprintf (fp, "miles\n");
  else
    {
      if (metricflag)
	fprintf (fp, "metric\n");
      else
	fprintf (fp, "nautic\n");
    }

  fprintf (fp, "savetrack = ");
  if (savetrack)
    fprintf (fp, "1\n");
  else
    fprintf (fp, "0\n");

  fprintf (fp, "scalewanted = %d\n", scalewanted);

  fprintf (fp, "serialdevice = %s\n", serialdev);

  sprintf (str, "%.6f", current_long);
  g_strdelimit (str, ",", '.');
  fprintf (fp, "lastlong = %s\n", str);

  sprintf (str, "%.6f", current_lat);
  g_strdelimit (str, ",", '.');
  fprintf (fp, "lastlat = %s\n", str);

  fprintf (fp, "shadow = ");
  if (shadow)
    fprintf (fp, "1\n");
  else
    fprintf (fp, "0\n");

  fprintf (fp, "defaultserver = ");
  if (defaultserver == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");

  fprintf (fp, "testgarminmode = ");
  if (testgarmin == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");

  fprintf (fp, "waypointfile = ");
  fprintf (fp, "%s\n", activewpfile);

  fprintf (fp, "usedgps = ");
  if (usedgps == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");

  fprintf (fp, "mapdir = ");
  fprintf (fp, "%s\n", mapdir);

  fprintf (fp, "simfollow = ");
  if (simfollow == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");

  fprintf (fp, "satposmode = ");
  if (satposmode == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");

  fprintf (fp, "printoutsats = ");
  if (printoutsats == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");

  fprintf (fp, "minsecmode = ");
  if (minsecmode == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");

  fprintf (fp, "nightmode = ");
  fprintf (fp, "%d\n", nightmode);

  fprintf (fp, "slowcpu = ");
  if (slowcpu == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");

  fprintf (fp, "flymode = ");
  if (flymode == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");

  fprintf (fp, "vfr = ");
  fprintf (fp, "%d\n", vfr);

  fprintf (fp, "disdevwarn = ");
  if (disdevwarn == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");

  fprintf (fp, "sqlflag = ");
  if (sqlflag == 0)
    fprintf (fp, "0\n");
  else
    fprintf (fp, "1\n");
  fprintf (fp, "lastnotebook = ");
  fprintf (fp, "%d\n", lastnotebook);

  fprintf (fp, "dbhostname = %s\n", dbhost);
  fprintf (fp, "dbuser = %s\n", dbuser);
  fprintf (fp, "dbpass = %s\n", dbpass);
  fprintf (fp, "dbtable = %s\n", dbtable);
  fprintf (fp, "dbdistance = %.1f\n", dbdistance);
  fprintf (fp, "dbusedist = %d\n", dbusedist);
  fprintf (fp, "dbwherestring = %s\n", dbwherestring);


  fclose (fp);
  needtosave = FALSE;
}

/*  read the configurationfile ~/.gpsdrive/gpsdriverc */
void
readconfig ()
{
  FILE *fp;
  gchar fname[220], par1[40], par2[1000];
  gint e;

  strcpy (fname, homedir);
  strcat (fname, "gpsdriverc");
  fp = fopen (fname, "r");
  if (fp == NULL)
    return;

  while ((e = fscanf (fp, "%s = %[^\n]", par1, par2)) > 0)
    {
      if (debug)
	g_print ("\nGelesen: %s %s", par1, par2);

      if ((strstr (par1, "showwaypoints")) != NULL)
	wpflag = atoi (par2);

      if ((strstr (par1, "showtrack")) != NULL)
	trackflag = atoi (par2);

      if ((strstr (par1, "mutespeechoutput")) != NULL)
	muteflag = atoi (par2);

      if ((strstr (par1, "showtopomaps")) != NULL)
	displaymap_top = atoi (par2);

      if ((strstr (par1, "showstreetmaps")) != NULL)
	displaymap_map = atoi (par2);

/*  To set the right sensitive flags bestmap_cb is called later*/
      if ((strstr (par1, "autobestmap")) != NULL)
	scaleprefered = !(atoi (par2));


      if ((strstr (par1, "units")) != NULL)
	{
	  milesflag = metricflag = nauticflag = FALSE;
	  if ((strstr (par2, "miles")) != NULL)
	    {
	      milesflag = TRUE;
	      milesconv = KM2MILES;
	    }
	  else
	    {
	      if ((strstr (par2, "metric")) != NULL)
		{
		  metricflag = TRUE;
		  milesconv = 1.0;
		}
	      else if ((strstr (par2, "nautic")) != NULL)
		{
		  nauticflag = TRUE;
		  milesconv = KM2NAUTIC;
		}
	    }
	}

      if ((strstr (par1, "savetrack")) != NULL)
	savetrack = atoi (par2);

      if ((strstr (par1, "scalewanted")) != NULL)
	scalewanted = atoi (par2);

      if ((strstr (par1, "serialdevice")) != NULL)
	strcpy (serialdev, par2);

      if ((strstr (par1, "lastlong")) != NULL)
	current_long = g_strtod (par2, NULL);

      if ((strstr (par1, "lastlat")) != NULL)
	current_lat = g_strtod (par2, NULL);

/*        if ((strstr (par1, "setdefaultpos")) != NULL) */
/*  	setdefaultpos = atoi (par2); */

      if ((strstr (par1, "shadow")) != NULL)
	shadow = atoi (par2);

      if ((strstr (par1, "defaultserver")) != NULL)
	defaultserver = atoi (par2);

      if ((strstr (par1, "waypointfile")) != NULL)
	strcpy (activewpfile, par2);

      if ((strstr (par1, "testgarminmode")) != NULL)
	testgarmin = atoi (par2);

      if ((strstr (par1, "usedgps")) != NULL)
	usedgps = atoi (par2);

      if ((strstr (par1, "mapdir")) != NULL)
	strcpy (mapdir, par2);

      if ((strstr (par1, "simfollow")) != NULL)
	simfollow = atoi (par2);

      if ((strstr (par1, "satposmode")) != NULL)
	satposmode = atoi (par2);

      if ((strstr (par1, "printoutsats")) != NULL)
	printoutsats = atoi (par2);

      if ((strstr (par1, "minsecmode")) != NULL)
	minsecmode = atoi (par2);

      if ((strstr (par1, "nightmode")) != NULL)
	nightmode = atoi (par2);

      if ((strstr (par1, "slowcpu")) != NULL)
	slowcpu = atoi (par2);

      if ((strstr (par1, "flymode")) != NULL)
	flymode = atoi (par2);

      if ((strstr (par1, "vfr")) != NULL)
	vfr = atoi (par2);

      if ((strstr (par1, "disdevwarn")) != NULL)
	disdevwarn = atoi (par2);

      if ((strstr (par1, "sqlflag")) != NULL)
	sqlflag = atoi (par2);

      if ((strstr (par1, "lastnotebook")) != NULL)
	lastnotebook = atoi (par2);

      if ((strstr (par1, "dbhost")) != NULL)
	strcpy (dbhost, par2);

      if ((strstr (par1, "dbuser")) != NULL)
	strcpy (dbuser, par2);

      if ((strstr (par1, "dbpass")) != NULL)
	strcpy (dbpass, par2);

      if ((strstr (par1, "dbtable")) != NULL)
	strcpy (dbtable, par2);

      if ((strstr (par1, "dbname")) != NULL)
	strcpy (dbname, par2);

      if ((strstr (par1, "dbdistance")) != NULL)
	dbdistance = g_strtod (par2, NULL);

      if ((strstr (par1, "dbusedist")) != NULL)
	dbusedist = atoi (par2);

      if ((strstr (par1, "dbwherestring")) != NULL)
	{
	  if (e == 2)
	    strcpy (dbwherestring, par2);
	}

    }
}
