/*

Copyright (c) 2001,2002 Fritz Ganter <ganter@ganter.at>

Website: www.gpsdrive.de

Disclaimer: Please do not use for navigation. 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    *********************************************************************


$Log: speech_out.c,v $
Revision 1.21  2002/11/02 12:38:55  ganter
changed website to www.gpsdrive.de

Revision 1.20  2002/07/30 20:49:55  ganter
1.26pre3
added support for festival lite (flite)
changed http request to HTTP1.1 and added correct servername

Revision 1.19  2002/06/23 17:09:35  ganter
v1.23pre9
now PDA mode looks good.

Revision 1.18  2002/06/02 20:54:10  ganter
added navigation.c and copyrights

Revision 1.17  2002/05/11 15:45:31  ganter
v1.21pre1
degree,minutes,seconds should work now

Revision 1.16  2002/05/04 10:48:24  ganter
v1.20pre2

Revision 1.15  2002/05/04 09:17:37  ganter
added new intl subdir

Revision 1.14  2002/05/02 01:34:11  ganter
added speech output of waypoint description

Revision 1.13  2002/04/14 23:06:26  ganter
v1.17

Revision 1.12  2001/11/01 20:17:59  ganter
v1.0 added spanish voice output

Revision 1.11  2001/09/30 18:45:27  ganter
v0.29
added choice of map type

Revision 1.10  2001/09/30 12:09:43  ganter
added help menu

Revision 1.9  2001/09/28 15:43:56  ganter
v0.28 changed layout, some bugfixes

Revision 1.8  2001/09/25 23:49:44  ganter
v 0.27

Revision 1.7  2001/09/23 22:31:14  ganter
v0.26

Revision 1.6  2001/09/18 05:33:06  ganter
..

Revision 1.5  2001/09/17 00:29:38  ganter
added speech output of bearing

Revision 1.4  2001/09/16 21:36:05  ganter
speech output is working

Revision 1.3  2001/09/16 19:12:35  ganter
...

*/


/*  There must be the software "festival" running in server mode */
/*  http://www.speech.cs.cmu.edu/festival */


/*  Include Dateien */
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <sys/mman.h>
#include <math.h>
#include <sys/time.h>
#include "gtk/gtk.h"
#include "gdk-pixbuf/gdk-pixbuf.h"
#include <locale.h>
#include <time.h>

/*  Defines for gettext I18n */
# include <libintl.h>
# define _(String) gettext(String)
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif

extern gint statusid, debug, havespeechout, posmode, muteflag;
gint speechsock;
gchar *displaytext = NULL;
extern enum
{ english, german, spanish }
voicelang;
extern GdkFont *textfont, *smalltextfont, *bigtextfont;
extern GdkColor white, red, mygray, blue;
extern GdkDrawable *drawable;
#define SCREEN_Y real_screen_y
extern gint real_screen_y;
gint do_display_dsc = FALSE, textcount;
extern gint useflite;

void saytargettext (gchar *filename, gchar *target);
void display_dsc (void);
gint speech_out_speek_raw (char *text);

#define SPEECHOUTSERVER "127.0.0.1"


gint
speech_out_init ()
{
  struct sockaddr_in server;
  struct hostent *server_data;

/*  open socket to port 1314 */
  if ((speechsock = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
      return (FALSE);
    }
  server.sin_family = AF_INET;
/*  We retrieve the IP address of the server from its name: */
  if ((server_data = gethostbyname (SPEECHOUTSERVER)) == NULL)
    {
      return (FALSE);
    }
  memcpy (&server.sin_addr, server_data->h_addr, server_data->h_length);
  server.sin_port = htons (1314);
/*  We initiate the connection  */
  if (connect (speechsock, (struct sockaddr *) &server, sizeof server) < 0)
    {
      return (FALSE);
    }


  return TRUE;
}


gint
speech_out_speek (char *text)
{
  gint e;
  gchar out[2000];
  gint file;

  if (!havespeechout)
    return 0;
  if (posmode)
    return 0;

  if (debug)
    g_print (text);
  if (!useflite)
    {
      sprintf (out, "(SayText \"%s\")\n", text);
      e = write (speechsock, out, strlen (out));
    }
  else
    {
      file = creat ("/tmp/gpsdrivetext.out", 0666);
      if (file == -1)
	return 0;
      strcat (text, ".\n");
      e = write (file, text, strlen (text));
      close (file);
      sprintf (out, "flite -f /tmp/gpsdrivetext.out&");
      system (out);
    }
  return e;
}

gint
speech_out_speek_raw (char *text)
{
  gint e;

  if (!havespeechout)
    return 0;
  if (posmode)
    return 0;

  if (debug)
    g_print (text);

  e = write (speechsock, text, strlen (text));

  return e;
}

/*  if second parameter is TRUE, then also greeting is spoken */
gint
speech_saytime_cb (GtkWidget *widget, guint datum)
{
  time_t t;
  struct tm *ts;
  gchar buf[200];

  if (muteflag)
    return TRUE;

  time (&t);
  ts = localtime (&t);

  if (havespeechout)
    switch (voicelang)
      {
      case english:
	if (datum == 1)
	  {
	    if ((ts->tm_hour >= 0) && (ts->tm_hour < 12))
	      sprintf (buf, "Good Morning,");
	    if ((ts->tm_hour >= 12) && (ts->tm_hour < 18))
	      sprintf (buf, "Good afternoon,");
	    if (ts->tm_hour >= 18)
	      sprintf (buf, "Good evening,");
	    speech_out_speek (buf);
	  }
	sprintf (buf,
		 "it is %d o clock and %d minutes.", ts->tm_hour, ts->tm_min);
	speech_out_speek (buf);
	break;
      case spanish:
	if (datum == 1)
	  {
	    if ((ts->tm_hour >= 0) && (ts->tm_hour < 12))
	      sprintf (buf, "buenos das.");
	    if ((ts->tm_hour >= 12) && (ts->tm_hour < 18))
	      sprintf (buf, "buenos tardes.");
	    if (ts->tm_hour >= 18)
	      sprintf (buf, "buenas noches");
	    speech_out_speek (buf);
	  }
	if (ts->tm_hour == 1)
	  sprintf (buf, "es la una y %d minutos.", ts->tm_min);
	else
	  sprintf (buf,
		   "son las %d horas y %d minutos.", ts->tm_hour, ts->tm_min);
	speech_out_speek (buf);
	break;
      case german:
	if (datum == 1)
	  {
	    if ((ts->tm_hour >= 0) && (ts->tm_hour < 12))
	      sprintf (buf, "Guten Morgen.");
	    if ((ts->tm_hour >= 12) && (ts->tm_hour < 18))
	      sprintf (buf, "Guten Tag.");
	    if (ts->tm_hour >= 18)
	      sprintf (buf, "Guten Abend.");
	    speech_out_speek (buf);
	  }
	if (ts->tm_hour == 1)
	  sprintf (buf, "es ist ein Uhr %d", ts->tm_min);
	else
	  sprintf (buf, "es ist %d Uhr %d", ts->tm_hour, ts->tm_min);
	speech_out_speek (buf);

      }

  return TRUE;

}

void
saytargettext (gchar *filename, gchar *tg)
{
  gchar file[500];
  gint fd, e;
  gchar *start, *end;
  struct stat buf;
  gchar *data, *b, *tg2, target[100];

/* build .dsc filename */
  strcpy (file, filename);
  file[strlen (file) - 3] = 0;
  strcat (file, "dsc");
/* get size */
  e = stat (file, &buf);
  if (e != 0)
    return;

  fd = open (file, O_RDONLY);
/* map +2000 bytes to get 0 at the end */
  data = mmap (0, buf.st_size + 2000, PROT_READ, MAP_SHARED, fd, 0);
  strcpy (target, "$");
  tg2 = g_strdelimit (tg, " ", '_');
  strcat (target, tg2);
  start = strstr (data, target);
  if (start != NULL)
    {
      start = strstr (start, "\n");
      end = strstr (start, "$");
      if (end == NULL)
	end = start + strlen (start);
      b = calloc (end - start + 50, 1);
      if (displaytext != NULL)
	free (displaytext);
      displaytext = calloc (end - start + 50, 1);
      strncpy (displaytext, start, end - start);
      displaytext[end - start + 1] = 0;
      strcpy (b, displaytext);
      displaytext = g_strdelimit (displaytext, "\n", ' ');
      do_display_dsc = TRUE;
      textcount = 0;
      speech_out_speek (b);
      free (b);
    }
  munmap (data, buf.st_size + 2000);
}

void
display_dsc (void)
{
  GdkGC *kontext;
  gint k, l2, len;
  gchar *text;
  if (!do_display_dsc)
    return;
  if ((textcount >= strlen (displaytext)))
    {
      do_display_dsc = FALSE;
      free (displaytext);
      displaytext = NULL;
      return;
    }
  if (textcount > 10)
    text = displaytext + textcount;
  else
    text = displaytext;
  kontext = gdk_gc_new (drawable);
  len = strlen (text);
/*   if (len>10) */
/*       len=10; */

  k = gdk_text_width (bigtextfont, text, len);
  l2 = gdk_text_height (bigtextfont, text, len);

  gdk_gc_set_function (kontext, GDK_OR);

  gdk_gc_set_foreground (kontext, &mygray);

  gdk_draw_rectangle (drawable, kontext, 1, 10,
		      SCREEN_Y - 32 - l2, k + 20, l2 + 4);
  gdk_gc_set_function (kontext, GDK_COPY);
  gdk_gc_set_foreground (kontext, &blue);
  gdk_draw_text (drawable, bigtextfont, kontext,
		 11, SCREEN_Y - 30, text, len);
  textcount++;
}
