/*

Copyright (c) 2001,2002 Fritz Ganter <ganter@ganter.at>

Website: www.gpsdrive.de

Disclaimer: Please do not use for navigation. 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    *********************************************************************


$Log: settings.c,v $
Revision 1.30  2002/11/14 00:05:55  ganter
added README.kismet
v 1.30pre5

Revision 1.29  2002/11/12 20:37:15  ganter
v30pre4
added more icons, fix for kismet w/o mysql

Revision 1.28  2002/11/02 12:38:55  ganter
changed website to www.gpsdrive.de

Revision 1.27  2002/10/30 09:46:47  ganter
added tooltips in settings.c

Revision 1.26  2002/10/30 09:32:49  ganter
v1.29pre9
hopefully removed all gtk-warnings

Revision 1.25  2002/10/27 10:51:30  ganter
1.28pre8

Revision 1.24  2002/10/24 08:44:09  ganter
...

Revision 1.23  2002/10/17 15:55:45  ganter
wp2sql added

Revision 1.22  2002/10/16 14:16:13  ganter
working on SQL gui

Revision 1.21  2002/10/15 07:44:11  ganter
...

Revision 1.20  2002/10/14 08:38:59  ganter
v1.29pre3
added SQL support

Revision 1.19  2002/08/29 15:20:51  ganter
timezone in settings/geoinfo works, but window must be refreshed

Revision 1.18  2002/07/30 20:49:55  ganter
1.26pre3
added support for festival lite (flite)
changed http request to HTTP1.1 and added correct servername

Revision 1.17  2002/07/17 12:24:08  ganter
added gpspoint2gspdrive
changed specfile, thanks to Silke Reimer

Revision 1.16  2002/07/02 12:12:55  ganter
v1.24

Revision 1.15  2002/07/01 00:45:00  ganter
added trip info (in settings menu)
ACPI fixes (close battery fd)

Revision 1.14  2002/06/23 17:09:35  ganter
v1.23pre9
now PDA mode looks good.

Revision 1.13  2002/06/16 21:35:23  ganter
got settings smaller

Revision 1.12  2002/06/16 17:50:35  ganter
working on PDA screen

Revision 1.11  2002/06/12 10:58:49  ganter
v1.23pre7

Revision 1.10  2002/06/02 20:54:10  ganter
added navigation.c and copyrights

Revision 1.9  2002/05/23 09:07:37  ganter
v1.23pre1
added new BSD battery stuff

Revision 1.8  2002/05/20 22:41:02  ganter
removed race condition in setutc()
new 1.22

Revision 1.7  2002/05/20 20:40:23  ganter
v1.22

Revision 1.6  2002/05/20 10:02:48  ganter
v1.22pre7

Revision 1.5  2002/05/18 20:58:54  ganter
finished geo infos
v1.22pre5

Revision 1.4  2002/05/18 09:09:40  ganter
added slovak translations
fixed segfault
v1.22pre3

Revision 1.3  2002/05/17 23:22:25  ganter
added sunrise,sunset in settings menu

Revision 1.2  2002/05/17 20:05:23  ganter
changed settings menu to notebook widget

Revision 1.1  2002/05/15 19:05:31  ganter
created settings.c

*/

/*  Include Dateien */
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <sys/mman.h>
#include <math.h>
#include <sys/time.h>
#include "gtk/gtk.h"
#include "gdk-pixbuf/gdk-pixbuf.h"
#include <locale.h>
#include <time.h>
#include <dirent.h>

/*  Defines for gettext I18n */
# include <libintl.h>
# define _(String) gettext(String)
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif

#define PADDING int_padding

gchar homedir[500], mapdir[500];
static gchar const rcsid[] =
  "$Id: settings.c,v 1.30 2002/11/14 00:05:55 ganter Exp $";

extern gint statusid, debug, havespeechout, posmode, muteflag, sqlflag;
typedef struct
{
  gchar n[200];
}
namesstruct;
extern namesstruct *names;
extern GtkWidget *addwaypointwindow, *setupfn[30];
extern gchar activewpfile[200], gpsdservername[200], setpositionname[80];
extern gint shadow, createroute, routemode;
extern gint needreloadmapconfig, simfollow;
extern GtkWidget *serialbt, *mapdirbt, *addwaypoint1, *addwaypoint2,
  *frame_speed, *frame_sats;
extern gint minsecmode, nightmode, isnight, disableisnight;
extern gint nighttimer;
extern gint newsatslevel, testgarmin, needtosave;
extern gint wpsize, satfix, usedgps;
extern gchar serialdev[80];
extern GtkWidget *distlabel, *speedlabel, *altilabel, *miles, *startgpsbt;
extern gint gcount, milesflag, downloadwindowactive;
extern gint metricflag, nauticflag;
extern gint defaultserver, disableapm;
extern GtkWidget *mainwindow, *status, *pixmapwidget, *gotowindow;
extern GtkWidget *routewindow, *setupentry[50], *setupentrylabel[50];
extern gdouble current_long, current_lat, old_long, old_lat, groundspeed;
static gdouble hour, sunrise, sunset, suntransit;
static gdouble duskastro, dawnastro, dusknaut, dawnnaut, duskciv, dawnciv;
extern gchar utctime[20];
static GtkWidget *utclabel;
static gint utctimer;
extern gint slowcpu;
extern gint real_screen_x, real_screen_y, real_psize, real_smallmenu;
extern gint int_padding;
extern gdouble tripodometer, tripavspeed, triptime, tripmaxspeed, triptmp;
extern gint tripavspeedcount;
extern gint lastnotebook;
extern GtkWidget *settingsnotebook;
GtkWidget *ge12;
static gchar *slist[] =
  { "GMT-12", "GMT-11", "GMT-10", "GMT-9", "GMT-8", "GMT-7", "GMT-6", "GMT-5",
  "GMT-4", "GMT-3", "GMT-2", "GMT-1", "GMT+0", "GMT+1", "GMT+2", "GMT+3",
  "GMT+4", "GMT+5",
  "GMT+6", "GMT+7", "GMT+8", "GMT+9", "GMT+10", "GMT+11", "GMT+12"
};
gint zone;
#define MAXDBNAME 30
extern char dbhost[MAXDBNAME], dbuser[MAXDBNAME], dbpass[MAXDBNAME];
extern char dbtable[MAXDBNAME], dbname[MAXDBNAME];
extern char dbwherestring[5000];
extern char dbtypelist[100][40];
extern int dbtypelistcount;
extern double dbdistance;
extern int dbusedist;
GtkWidget *sqlfn[100];
gint sqlselects[100], sqlandmode = TRUE;
static int sqldontquery = FALSE;
int sqlplace;

/* Prototypes */
extern gint error_popup (gpointer datum);
extern gint wpfileselect_cb (GtkWidget *widget, guint datum);
extern gint shadow_cb (GtkWidget *widget, guint datum);
extern gint simfollow_cb (GtkWidget *widget, guint datum);
extern gint mapdir_cb (GtkWidget *widget, guint datum);
extern gint night_cb (GtkWidget *widget, guint datum);
extern gint testgarmin_cb (GtkWidget *widget, guint datum);
extern gint serialdev_cb (GtkWidget *widget, guint datum);
extern gint usedgps_cb (GtkWidget *widget, guint datum);
extern gint miles_cb (GtkWidget *widget, guint datum);
extern gint shadow_cb (GtkWidget *widget, guint datum);
extern gint slowcpu_cb (GtkWidget *widget, guint datum);
extern gint defaultserver_cb (GtkWidget *widget, guint datum);
extern gint minsec_cb (GtkWidget *widget, guint datum);
extern gint mod_setupcounter;

void testifnight (void);
void daylights (void);
gint setutc (GtkWidget *widget, guint datum);
gint removesetutc (GtkWidget *widget, guint datum);
void sqlsetup (void);
int getsqldata ();
gint callsqlupdateonce_cb (GtkWidget *widget, guint datum);
int getsqltypelist ();


void
mainsetup (void)
{
  GtkWidget *mainbox, *ftable, *label1, *gpstable, *misctable;
  GtkWidget *metric, *nautic, *garminbt, *dgpsbt, *minsecbt;
  GtkWidget *table, *table2, *bigtable, *shadowbt, *s1, *s2, *nighttable;
  GtkWidget *label2, *f1, *f2, *f3, *f4, *f5, *simfollowbt;
  GtkWidget *night1, *night2, *night3, *vbox, *slowcpubt;
  GtkTooltips *tooltips;
  GtkWidget *v2, *v3, *v4, *h1;
  gchar path2[400];
  DIR *d;
  struct dirent *dat;
  gint dircount = 0, i;

  strcpy (path2, homedir);
  names = g_new (namesstruct, 102);

  d = opendir (path2);
  if (d != NULL)
    {
      do
	{
	  dat = readdir (d);
	  if (dat != NULL)
	    {
	      if ((strncmp (dat->d_name, "way", 3)) == 0)
		if ((strncmp
		     ((dat->d_name + (strlen (dat->d_name) - 4)), ".txt",
		      4)) == 0)
		  {
		    strcpy ((names + dircount)->n, dat->d_name);
		    dircount++;
		    if (dircount >= 100)
		      {
			error_popup (_
				     ("Don't use more than\n100 waypoint(way*.txt) files!"));
			g_free (names);
		      }
		  }
	    }
	}
      while (dat != NULL);
    }

  table2 = gtk_table_new (1 + (dircount - 1) / 2, 2, TRUE);
  setupentry[1] = ftable = gtk_frame_new (_("Waypoint files to use"));
  gtk_container_set_border_width (GTK_CONTAINER (ftable), 5 * PADDING);
  setupentrylabel[1] = gtk_label_new (_("Waypoints"));
  vbox = gtk_vbox_new (FALSE, 2 * PADDING);

  gtk_container_add (GTK_CONTAINER (ftable), vbox);
  gtk_box_pack_start (GTK_BOX (vbox), table2, FALSE, FALSE, 10 * PADDING);

  for (i = 0; i < dircount; i++)
    {
      if (i == 0)
	setupfn[i] = gtk_radio_button_new_with_label (NULL, (names + i)->n);
      else
	setupfn[i] = gtk_radio_button_new_with_label (gtk_radio_button_group
						      (GTK_RADIO_BUTTON
						       (setupfn[0])),
						      (names + i)->n);
      gtk_signal_connect (GTK_OBJECT (setupfn[i]), "clicked",
			  GTK_SIGNAL_FUNC (wpfileselect_cb), (gpointer) i);
      gtk_table_attach_defaults (GTK_TABLE (table2), setupfn[i], i % 2,
				 i % 2 + 1, i / 2, i / 2 + 1);
      if (!(strcmp (activewpfile, (names + i)->n)))
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (setupfn[i]), TRUE);

    }
  setupentrylabel[0] = gtk_label_new (_("Settings"));
  tooltips = gtk_tooltips_new ();
  setupentry[0] = mainbox = gtk_vbox_new (FALSE, 2 * PADDING);
  gtk_container_set_border_width (GTK_CONTAINER (mainbox), 5 * PADDING);

  bigtable = gtk_table_new (2, 1, FALSE);

  table = gtk_table_new (3, 2, FALSE);


  gtk_box_pack_start (GTK_BOX (mainbox), bigtable, TRUE, TRUE, 3 * PADDING);
/* misc area */
  f1 = gtk_frame_new (_("Misc settings"));
  gtk_table_attach_defaults (GTK_TABLE (table), f1, 0, 1, 0, 1);

  shadowbt = gtk_check_button_new_with_label (_("Show Shadows"));
  if (shadow)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (shadowbt), TRUE);

  gtk_signal_connect (GTK_OBJECT (shadowbt),
		      "clicked", GTK_SIGNAL_FUNC (shadow_cb), (gpointer) 1);

  simfollowbt =
    gtk_check_button_new_with_label (_("Simulation: Follow target"));
  if (simfollow)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (simfollowbt), TRUE);

  gtk_signal_connect (GTK_OBJECT (simfollowbt),
		      "clicked", GTK_SIGNAL_FUNC (simfollow_cb),
		      (gpointer) 1);

  slowcpubt = gtk_check_button_new_with_label (_("Slow CPU"));
  if (slowcpu)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (slowcpubt), TRUE);

  gtk_signal_connect (GTK_OBJECT (slowcpubt),
		      "clicked", GTK_SIGNAL_FUNC (slowcpu_cb), (gpointer) 1);


  misctable = gtk_table_new (3, 2, TRUE);
  gtk_container_add (GTK_CONTAINER (f1), misctable);

  mapdirbt = gtk_entry_new_with_max_length (490);
  gtk_widget_set_usize (mapdirbt, 20, 18);

  gtk_entry_set_text (GTK_ENTRY (mapdirbt), mapdir);
  label2 = gtk_label_new (_("Maps directory"));

  gtk_signal_connect (GTK_OBJECT (mapdirbt),
		      "changed", GTK_SIGNAL_FUNC (mapdir_cb), (gpointer) 1);


  night1 = gtk_radio_button_new_with_label (NULL, _("Automatic"));
  gtk_signal_connect (GTK_OBJECT (night1),
		      "clicked", GTK_SIGNAL_FUNC (night_cb), (gpointer) 2);

  night2 =
    gtk_radio_button_new_with_label (gtk_radio_button_group
				     (GTK_RADIO_BUTTON (night1)), _("On"));
  gtk_signal_connect (GTK_OBJECT (night2), "clicked",
		      GTK_SIGNAL_FUNC (night_cb), (gpointer) 1);
  night3 =
    gtk_radio_button_new_with_label (gtk_radio_button_group
				     (GTK_RADIO_BUTTON (night1)), _("Off"));
  gtk_signal_connect (GTK_OBJECT (night3), "clicked",
		      GTK_SIGNAL_FUNC (night_cb), (gpointer) 0);
  if (nightmode == 0)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (night3), TRUE);
  if (nightmode == 1)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (night2), TRUE);
  if (nightmode == 2)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (night1), TRUE);

  gtk_table_attach_defaults (GTK_TABLE (misctable), shadowbt, 0, 2, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (misctable), simfollowbt, 0, 2, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (misctable), slowcpubt, 0, 2, 2, 3);

/*   gtk_table_attach_defaults (GTK_TABLE (misctable), label2, 0, 2, 3, 4); */
/*   gtk_table_attach_defaults (GTK_TABLE (misctable), mapdirbt, 0, 2, 4, 5); */


/* GPS settings area */
  f4 = gtk_frame_new (_("GPS settings"));

  v4 = gtk_vbox_new (FALSE, 2 * PADDING);
  gtk_container_add (GTK_CONTAINER (f4), v4);

  gpstable = gtk_table_new (4, 1, FALSE);

  gtk_table_attach_defaults (GTK_TABLE (table), f4, 1, 2, 1, 2);
  gtk_box_pack_start (GTK_BOX (v4), gpstable, FALSE, FALSE, 1 * PADDING);
/*   gtk_container_add (GTK_CONTAINER (f4), gpstable); */


  garminbt = gtk_check_button_new_with_label (_("Test for GARMIN"));
  if (testgarmin)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (garminbt), TRUE);

  gtk_signal_connect (GTK_OBJECT (garminbt),
		      "clicked", GTK_SIGNAL_FUNC (testgarmin_cb),
		      (gpointer) 1);

  gtk_table_attach_defaults (GTK_TABLE (gpstable), garminbt, 0, 1, 0, 1);


  dgpsbt = gtk_check_button_new_with_label (_("Use DGPS-IP"));
  if (usedgps)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (dgpsbt), TRUE);

  gtk_signal_connect (GTK_OBJECT (dgpsbt),
		      "clicked", GTK_SIGNAL_FUNC (usedgps_cb), (gpointer) 1);

  gtk_table_attach_defaults (GTK_TABLE (gpstable), dgpsbt, 0, 1, 1, 2);


  serialbt = gtk_entry_new_with_max_length (20);
  gtk_widget_set_usize (serialbt, 20, 18);

  gtk_entry_set_text (GTK_ENTRY (serialbt), serialdev);
  label1 = gtk_label_new (_("Interface"));
/*   gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (serialbt), TRUE); */

  gtk_signal_connect (GTK_OBJECT (serialbt),
		      "changed", GTK_SIGNAL_FUNC (serialdev_cb),
		      (gpointer) 1);
  gtk_table_attach_defaults (GTK_TABLE (gpstable), label1, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (gpstable), serialbt, 0, 1, 3, 4);

/*  units area */
  f2 = gtk_frame_new (_("Units"));
  v2 = gtk_vbox_new (FALSE, 2 * PADDING);
  gtk_table_attach_defaults (GTK_TABLE (table), f2, 0, 1, 1, 2);
  gtk_container_add (GTK_CONTAINER (f2), v2);

  miles = gtk_radio_button_new_with_label (NULL, _("Miles"));
  gtk_signal_connect (GTK_OBJECT (miles),
		      "clicked", GTK_SIGNAL_FUNC (miles_cb), (gpointer) 1);
  metric =
    gtk_radio_button_new_with_label (gtk_radio_button_group
				     (GTK_RADIO_BUTTON (miles)), _("Metric"));
  gtk_signal_connect (GTK_OBJECT (metric), "clicked",
		      GTK_SIGNAL_FUNC (miles_cb), (gpointer) 2);
  nautic =
    gtk_radio_button_new_with_label (gtk_radio_button_group
				     (GTK_RADIO_BUTTON (miles)), _("Nautic"));
  gtk_signal_connect (GTK_OBJECT (nautic), "clicked",
		      GTK_SIGNAL_FUNC (miles_cb), (gpointer) 3);
  if (milesflag)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (miles), TRUE);
  if (metricflag)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (metric), TRUE);
  if (nauticflag)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (nautic), TRUE);

  minsecbt = gtk_check_button_new_with_label (_("Decimal position"));
  if (!minsecmode)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (minsecbt), TRUE);

  gtk_signal_connect (GTK_OBJECT (minsecbt),
		      "clicked", GTK_SIGNAL_FUNC (minsec_cb), (gpointer) 0);


  gtk_box_pack_start (GTK_BOX (v2), miles, TRUE, FALSE, 2 * PADDING);
  gtk_box_pack_start (GTK_BOX (v2), metric, TRUE, FALSE, 2 * PADDING);
  gtk_box_pack_start (GTK_BOX (v2), nautic, TRUE, FALSE, 2 * PADDING);
  gtk_box_pack_start (GTK_BOX (v2), minsecbt, TRUE, FALSE, 2 * PADDING);

/*  default download server */
  f3 = gtk_frame_new (_("Default map server"));
  h1 = gtk_hbox_new (FALSE, 2 * PADDING);
  v3 = gtk_vbox_new (FALSE, 2 * PADDING);
  gtk_table_attach_defaults (GTK_TABLE (table), f3, 1, 2, 0, 1);
  gtk_container_add (GTK_CONTAINER (f3), v3);
  gtk_box_pack_start (GTK_BOX (v3), h1, TRUE, FALSE, 2 * PADDING);

  s1 = gtk_radio_button_new_with_label (NULL, "Mapblast");
  gtk_signal_connect (GTK_OBJECT (s1),
		      "clicked", GTK_SIGNAL_FUNC (defaultserver_cb),
		      (gpointer) 1);
  s2 =
    gtk_radio_button_new_with_label (gtk_radio_button_group
				     (GTK_RADIO_BUTTON (s1)), "Expedia");
  gtk_signal_connect (GTK_OBJECT (s2), "clicked",
		      GTK_SIGNAL_FUNC (defaultserver_cb), (gpointer) 2);

  if (defaultserver == 0)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (s1), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (s2), TRUE);

  gtk_box_pack_start (GTK_BOX (h1), s1, TRUE, FALSE, 2 * PADDING);
  gtk_box_pack_start (GTK_BOX (h1), s2, TRUE, FALSE, 2 * PADDING);

/* Night light mode */
  f5 = gtk_frame_new (_("Night light mode"));
  nighttable = gtk_table_new (1, 3, TRUE);
  gtk_container_add (GTK_CONTAINER (f5), nighttable);
/*   gtk_box_pack_start (GTK_BOX (h1), f5, TRUE, FALSE, 2 * PADDING);  */
  gtk_box_pack_start (GTK_BOX (v3), label2, TRUE, FALSE, 2 * PADDING);
  gtk_box_pack_start (GTK_BOX (v3), mapdirbt, TRUE, FALSE, 2 * PADDING);

  gtk_table_attach_defaults (GTK_TABLE (nighttable), night1, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (nighttable), night2, 1, 2, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (nighttable), night3, 2, 3, 0, 1);

  gtk_table_attach_defaults (GTK_TABLE (table), f5, 0, 2, 2, 3);

  gtk_table_attach_defaults (GTK_TABLE (bigtable), table, 0, 1, 0, 1);

  gtk_table_set_row_spacings (GTK_TABLE (bigtable), 5 * PADDING);
  gtk_table_set_col_spacings (GTK_TABLE (bigtable), 5 * PADDING);
  gtk_table_set_row_spacings (GTK_TABLE (table), 5 * PADDING);
  gtk_table_set_col_spacings (GTK_TABLE (table), 5 * PADDING);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 5 * PADDING);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 5 * PADDING);


  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), miles,
			_("Switch units to statute miles"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), nautic,
			_("Switch units to nautical miles"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), metric,
			_("Switch units to metric system (Kilometers)"),
			NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), minsecbt,
			_
			("If selected display latitude and longitude in decimal degrees, otherwise in degree, minutes and seconds notation"),
			NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), s1,
			_("Set Mapblast as default download server"), NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), s2,
			_("Set Expedia as default download server"), NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), shadowbt,
			_("Switches shadows on map on or off"), NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), slowcpubt,
			_
			("Select, if your CPU is very slow ( < PII MMX/233MHz). This reduces the framerate to 1 frame/second."),
			NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), simfollowbt,
			_
			("If activated, pointer moves to target in simulation mode"),
			NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), mapdirbt,
			_
			("Path to your map files. In the specified directory also the index file map_koord.txt must be present."),
			NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), garminbt,
			_
			("If selected, gpsdrive try to use GARMIN mode if possible. Unselect if you only have a NMEA device."),
			NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), dgpsbt,
			_
			("If selected, gpsdrive try to use differential GPS over IP. You must have an internet connection and a DGPS capable GPS receiver. Works only in NMEA mode!"),
			NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), serialbt,
			_
			("Specify the serial interface where the GPS is connected"),
			NULL);

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), night1,
			_
			("Switches automagically to night mode if it is dark outside. Press 'N' key to turn off nightmode."),
			NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), night2,
			_
			("Switches night mode on. Press 'N' key to turn off nightmode."),
			NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), night3,
			_("Switches night mode off"), NULL);



  gtk_widget_show_all (mainbox);
/*    g_free (names); */

}

void
testifnight (void)
{
  daylights ();
  isnight = FALSE;
  if (hour > sunset)
    isnight = TRUE;
  if (hour < sunrise)
    isnight = TRUE;

  if (debug)
    {
      if (isnight)
	g_print ("\nIt is night");
      else
	g_print ("\nIt is day");
    }
}


void
daylights (void)
{
  gint Rank, D, TZ;
  gdouble MA, C, RR, ET, L, Dec, Ho, lat, lon;
  time_t now = time (NULL);
  struct tm *st = localtime (&now);

  lat = M_PI * current_lat / 180.0;
  lon = M_PI * current_long / 180.0;
  Rank = st->tm_yday + 1;
  D = st->tm_mday;
  MA = 357 + 0.9856 * Rank;
  C = 1.914 * sin (M_PI * MA / 180.0) + 0.02 * sin (2 * M_PI * MA / 180.0);
  L = 280.0 + C + 0.9856 * Rank;
  RR =
    -2.466 * sin (2.0 * M_PI * L / 180.0) +
    0.053 * sin (4 * M_PI * L / 180.0);
  ET = (C + RR) * 4;
  Dec = asin (0.3978 * sin (M_PI * L / 180.0));
  Ho = acos (((-0.01454 - sin (Dec) * sin (lat)) / (cos (Dec) * cos (lat))));
  Ho = 180.0 * Ho / M_PI;
  Ho = Ho / 15;

  TZ = zone;

  sunrise = 12.0 - Ho + ET / 60.0 - current_long / 15 + TZ;
  suntransit = 12 + ET / 60.0 - current_long / 15 + TZ;
  sunset = 12.0 + Ho + ET / 60.0 - current_long / 15 + TZ;

  if (sunrise < 0)
    sunrise += 24;
  if (suntransit < 0)
    suntransit += 24;
  if (sunset < 0)
    sunset += 24;

  if (sunrise > 24)
    sunrise -= 24;
  if (suntransit > 24)
    suntransit -= 24;
  if (sunset > 24)
    sunset -= 24;


  Ho = acos (((-0.309 - sin (Dec) * sin (lat)) / (cos (Dec) * cos (lat))));
  Ho = 180.0 * Ho / M_PI;
  Ho = Ho / 15;
  dawnastro = 12.0 - Ho + ET / 60.0 - current_long / 15 + TZ;
  duskastro = 12.0 + Ho + ET / 60.0 - current_long / 15 + TZ;

  Ho = acos (((-0.208 - sin (Dec) * sin (lat)) / (cos (Dec) * cos (lat))));
  Ho = 180.0 * Ho / M_PI;
  Ho = Ho / 15;
  dawnnaut = 12.0 - Ho + ET / 60.0 - current_long / 15 + TZ;
  dusknaut = 12.0 + Ho + ET / 60.0 - current_long / 15 + TZ;

  Ho = acos (((-0.105 - sin (Dec) * sin (lat)) / (cos (Dec) * cos (lat))));
  Ho = 180.0 * Ho / M_PI;
  Ho = Ho / 15;
  dawnciv = 12.0 - Ho + ET / 60.0 - current_long / 15 + TZ;
  duskciv = 12.0 + Ho + ET / 60.0 - current_long / 15 + TZ;

  if (dawnastro < 0)
    dawnastro += 24;
  if (dawnnaut < 0)
    dawnnaut += 24;
  if (dawnciv < 0)
    dawnciv += 24;
  if (duskastro < 0)
    duskastro += 24;
  if (dusknaut < 0)
    dusknaut += 24;
  if (duskciv < 0)
    duskciv += 24;

  if (dawnastro > 24)
    dawnastro -= 24;
  if (dawnnaut > 24)
    dawnnaut -= 24;
  if (dawnciv > 24)
    dawnciv -= 24;
  if (duskastro > 24)
    duskastro -= 24;
  if (dusknaut > 24)
    dusknaut -= 24;
  if (duskciv > 24)
    duskciv -= 24;


  hour = st->tm_hour;
  hour = hour + st->tm_min / 60.0;
  if (debug)
    {
      g_print ("\nhour: %d:%02d, sunrise: %d:%02d ",
	       (int) hour, (int) ((hour - (int) hour) * 60), (int) sunrise,
	       (int) ((sunrise - (int) sunrise) * 60));
      g_print ("\nhour: %d:%02d, transit: %d:%02d ",
	       (int) hour, (int) ((hour - (int) hour) * 60), (int) suntransit,
	       (int) ((suntransit - (int) suntransit) * 60));
      g_print ("\nhour: %d:%02d, sunset: %d:%02d ",
	       (int) hour, (int) ((hour - (int) hour) * 60), (int) sunset,
	       (int) ((sunset - (int) sunset) * 60));
    }

/* Formulas for dawn and dusk are almost the same than sunrise and sunset. In the */
/* formula for Cos Ho -0.01454 must be replaced by: */
/* astronomical: -0.309 */
/* nautical: -0.208 */
/* civil: -0.105 */
}

gint
infosettz (GtkWidget *widget, guint datum)
{
  gchar *sc;

  sc = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (ge12)->entry));
  sscanf (sc, "GMT%d", &zone);
  if (debug)
    g_print ("\nTimezone: %d", zone);
  return TRUE;
}


void
infos (void)
{
  GtkWidget *mainbox, *frame, *l1, *l2, *l5, *e1, *e2;
  GtkWidget *e3, *e4, *e5, *l6, *l8, *l9, *l10, *l11, *l12;
  GtkWidget *e6, *e7, *e8, *e9, *e10, *e11;
  GtkWidget *table;
  gchar text[80];
  GList *list = NULL;
  gint i;

  for (i = 0; i < 25; i++)
    list = g_list_append (list, slist[i]);

  setupentry[2] = frame = gtk_frame_new (_("Geo information"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5 * PADDING);
  setupentrylabel[2] = gtk_label_new (_("Geo info"));

  testifnight ();

  mainbox = gtk_vbox_new (FALSE, 15 * PADDING);
  gtk_container_add (GTK_CONTAINER (frame), mainbox);

  table = gtk_table_new (10, 3, FALSE);
  gtk_box_pack_start (GTK_BOX (mainbox), table, FALSE, FALSE, 10 * PADDING);


  l11 = gtk_label_new (_("Sunrise"));
  gtk_table_attach_defaults (GTK_TABLE (table), l11, 1, 2, 0, 1);
  l9 = gtk_label_new (_("Sunset"));
  gtk_table_attach_defaults (GTK_TABLE (table), l9, 2, 3, 0, 1);

  l1 = gtk_label_new (_("Standard"));
  gtk_table_attach_defaults (GTK_TABLE (table), l1, 0, 1, 1, 2);
  l2 = gtk_label_new (_("Transit"));
  gtk_table_attach_defaults (GTK_TABLE (table), l2, 0, 1, 6, 7);
  l5 = gtk_label_new (_("UTC (GPS)"));
  gtk_table_attach_defaults (GTK_TABLE (table), l5, 0, 1, 7, 8);
  l6 = gtk_label_new (_("Astro."));
  gtk_table_attach_defaults (GTK_TABLE (table), l6, 0, 1, 2, 3);
  l8 = gtk_label_new (_("Naut."));
  gtk_table_attach_defaults (GTK_TABLE (table), l8, 0, 1, 3, 4);
  l10 = gtk_label_new (_("Civil"));
  gtk_table_attach_defaults (GTK_TABLE (table), l10, 0, 1, 4, 5);
  l12 = gtk_label_new (_("Timezone"));
  gtk_table_attach_defaults (GTK_TABLE (table), l12, 0, 1, 9, 10);

  e1 = gtk_entry_new ();
  if (sunrise > 24.0)
    strcpy (text, _("n/a"));
  else
    sprintf (text, "%02d:%02d", (int) sunrise,
	     (int) ((sunrise - (int) sunrise) * 60));
  gtk_entry_set_text (GTK_ENTRY (e1), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e1, 1, 2, 1, 2);

  e2 = gtk_entry_new ();
  if (sunset > 24.0)
    strcpy (text, _("n/a"));
  else
    sprintf (text, "%02d:%02d", (int) sunset,
	     (int) ((sunset - (int) sunset) * 60));
  gtk_entry_set_text (GTK_ENTRY (e2), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e2, 2, 3, 1, 2);

  e3 = gtk_entry_new ();
  if (suntransit > 24.0)
    strcpy (text, _("n/a"));
  else
    sprintf (text, "%02d:%02d:%02d", (int) suntransit,
	     (int) ((suntransit - (int) suntransit) * 60),
	     (int) ((suntransit * 60 - (int) (suntransit * 60)) * 60));
  gtk_entry_set_text (GTK_ENTRY (e3), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e3, 1, 2, 6, 7);

  e4 = gtk_entry_new ();
  if (isnight)
    sprintf (text, "%s", _("Night"));
  else
    sprintf (text, "%s", _("Day"));
  gtk_entry_set_text (GTK_ENTRY (e4), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e4, 2, 3, 7, 8);

  utclabel = e5 = gtk_entry_new ();


  sprintf (text, "%s", utctime);
  gtk_entry_set_text (GTK_ENTRY (e5), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e5, 1, 2, 7, 8);

  e6 = gtk_entry_new ();
  if (dawnastro > 24.0)
    strcpy (text, _("n/a"));
  else
    sprintf (text, "%02d:%02d:%02d", (int) dawnastro,
	     (int) ((dawnastro - (int) dawnastro) * 60),
	     (int) ((dawnastro * 60 - (int) (dawnastro * 60)) * 60));

  gtk_entry_set_text (GTK_ENTRY (e6), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e6, 1, 2, 2, 3);
  e7 = gtk_entry_new ();
  if (dawnnaut > 24.0)
    strcpy (text, _("n/a"));
  else
    sprintf (text, "%02d:%02d:%02d", (int) dawnnaut,
	     (int) ((dawnnaut - (int) dawnnaut) * 60),
	     (int) ((dawnnaut * 60 - (int) (dawnnaut * 60)) * 60));
  gtk_entry_set_text (GTK_ENTRY (e7), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e7, 1, 2, 3, 4);
  e8 = gtk_entry_new ();
  if (dawnciv > 24.0)
    strcpy (text, _("n/a"));
  else
    sprintf (text, "%02d:%02d:%02d", (int) dawnciv,
	     (int) ((dawnciv - (int) dawnciv) * 60),
	     (int) ((dawnciv * 60 - (int) (dawnciv * 60)) * 60));

  gtk_entry_set_text (GTK_ENTRY (e8), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e8, 1, 2, 4, 5);

  e9 = gtk_entry_new ();
  if (duskastro > 24.0)
    strcpy (text, _("n/a"));
  else
    sprintf (text, "%02d:%02d:%02d", (int) duskastro,
	     (int) ((duskastro - (int) duskastro) * 60),
	     (int) ((duskastro * 60 - (int) (duskastro * 60)) * 60));
  gtk_entry_set_text (GTK_ENTRY (e9), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e9, 2, 3, 2, 3);
  e10 = gtk_entry_new ();
  if (dusknaut > 24.0)
    strcpy (text, _("n/a"));
  else
    sprintf (text, "%02d:%02d:%02d", (int) dusknaut,
	     (int) ((dusknaut - (int) dusknaut) * 60),
	     (int) ((dusknaut * 60 - (int) (dusknaut * 60)) * 60));

  gtk_entry_set_text (GTK_ENTRY (e10), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e10, 2, 3, 3, 4);
  e11 = gtk_entry_new ();
  if (duskciv > 24.0)
    strcpy (text, _("n/a"));
  else
    sprintf (text, "%02d:%02d:%02d", (int) duskciv,
	     (int) ((duskciv - (int) duskciv) * 60),
	     (int) ((duskciv * 60 - (int) (duskciv * 60)) * 60));

  gtk_entry_set_text (GTK_ENTRY (e11), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e11, 2, 3, 4, 5);

  ge12 = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO (ge12), (GList *) list);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (ge12)->entry), slist[zone + 12]);
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (ge12)->entry), "changed",
		      GTK_SIGNAL_FUNC (infosettz), (gpointer) 0);

  gtk_table_attach_defaults (GTK_TABLE (table), ge12, 1, 2, 9, 10);

  gtk_entry_set_editable (GTK_ENTRY (e1), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e2), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e3), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e4), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e5), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e6), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e7), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e8), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e9), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e10), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e11), FALSE);
  gtk_widget_set_usize (e1, 15, 18);
  gtk_widget_set_usize (e2, 15, 18);
  gtk_widget_set_usize (e3, 15, 18);
  gtk_widget_set_usize (e4, 15, 18);
  gtk_widget_set_usize (e5, 15, 18);
  gtk_widget_set_usize (e6, 15, 18);
  gtk_widget_set_usize (e7, 15, 18);
  gtk_widget_set_usize (e8, 15, 18);
  gtk_widget_set_usize (e9, 15, 18);
  gtk_widget_set_usize (e10, 15, 18);
  gtk_widget_set_usize (e11, 15, 18);
  gtk_widget_set_usize (ge12, 15, 18);
  gtk_table_set_row_spacings (GTK_TABLE (table), 5 * PADDING);
  gtk_table_set_col_spacings (GTK_TABLE (table), 5 * PADDING);
  utctimer = gtk_timeout_add (300, (GtkFunction) setutc, 0);

  gtk_widget_show_all (frame);
}


void
trip (void)
{
  GtkWidget *mainbox, *frame, *l1, *l2, *l5, *e1;
  GtkWidget *e3, *e5, *l6, *l9;
  GtkWidget *e7;
  GtkWidget *table;
  gchar text[80], s1[80];
  gdouble f;

  setupentry[3] = frame = gtk_frame_new (_("Trip information"));
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5 * PADDING);
  setupentrylabel[3] = gtk_label_new (_("Trip info"));


  mainbox = gtk_vbox_new (FALSE, 15 * PADDING);
  gtk_container_add (GTK_CONTAINER (frame), mainbox);

  table = gtk_table_new (5, 2, FALSE);
  gtk_box_pack_start (GTK_BOX (mainbox), table, FALSE, FALSE, 10 * PADDING);

  if (milesflag)
    sprintf (s1, "%s [%s]", _("Unit:"), _("miles"));
  else if (nauticflag)
    sprintf (s1, "%s [%s]", _("Unit:"), _("nautic miles/knots"));
  else
    sprintf (s1, "%s [%s]", _("Unit:"), _("kilometers"));

  l9 = gtk_label_new (s1);
  gtk_table_attach_defaults (GTK_TABLE (table), l9, 1, 2, 0, 1);

  l1 = gtk_label_new (_("Odometer"));
  gtk_table_attach_defaults (GTK_TABLE (table), l1, 0, 1, 1, 2);
  l2 = gtk_label_new (_("Total time"));
  gtk_table_attach_defaults (GTK_TABLE (table), l2, 0, 1, 2, 3);
  l5 = gtk_label_new (_("Av. speed"));
  gtk_table_attach_defaults (GTK_TABLE (table), l5, 0, 1, 3, 4);
  l6 = gtk_label_new (_("Max. speed"));
  gtk_table_attach_defaults (GTK_TABLE (table), l6, 0, 1, 4, 5);

  e1 = gtk_entry_new ();
  sprintf (text, "%.3f", tripodometer);
  gtk_entry_set_text (GTK_ENTRY (e1), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e1, 1, 2, 1, 2);


  e3 = gtk_entry_new ();
  f = (time (NULL) - triptime) / 3600.0;
  sprintf (text, "%02d:%02d:%02d", (int) f,
	   (int) ((f - (int) f) * 60),
	   (int) ((f * 60 - (int) (f * 60)) * 60));
  gtk_entry_set_text (GTK_ENTRY (e3), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e3, 1, 2, 2, 3);

  e5 = gtk_entry_new ();
  sprintf (text, "%.1f", tripavspeed / tripavspeedcount);

  gtk_entry_set_text (GTK_ENTRY (e5), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e5, 1, 2, 3, 4);

  e7 = gtk_entry_new ();
  sprintf (text, "%.1f", tripmaxspeed);
  gtk_entry_set_text (GTK_ENTRY (e7), text);
  gtk_table_attach_defaults (GTK_TABLE (table), e7, 1, 2, 4, 5);

  gtk_entry_set_editable (GTK_ENTRY (e1), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e3), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e5), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (e7), FALSE);
  gtk_widget_set_usize (e1, 15, 18);
  gtk_widget_set_usize (e3, 15, 18);
  gtk_widget_set_usize (e5, 15, 18);
  gtk_widget_set_usize (e7, 15, 18);
  gtk_table_set_row_spacings (GTK_TABLE (table), 5 * PADDING);
  gtk_table_set_col_spacings (GTK_TABLE (table), 5 * PADDING);
  gtk_widget_show_all (frame);
}

gint
dbdistance_cb (GtkWidget *widget, guint datum)
{
  gchar *s;

  s = g_strstrip (gtk_entry_get_text (GTK_ENTRY (widget)));
  dbdistance = g_strtod (s, 0);
  needtosave = TRUE;
  gtk_timeout_add (2000, (GtkFunction) callsqlupdateonce_cb, 0);
  return TRUE;
}

gint
callsqlupdateonce_cb (GtkWidget *widget, guint datum)
{
  getsqldata ();
  return FALSE;
}

gint
dbusedist_cb (GtkWidget *widget, guint datum)
{
  dbusedist = !dbusedist;
  needtosave = TRUE;
  getsqldata ();
  return TRUE;
}

gint
dbbuildquery_cb (GtkWidget *widget, guint datum)
{
  gint i, sel;
  gchar s[50];
  gint flag = 0;

  if (datum != 999999)
    {
/*   printf ("\n%d andmode: %d\n", datum,sqlandmode); */
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
	sqlselects[datum] = TRUE;
      else
	sqlselects[datum] = FALSE;
    }

  strcpy (dbwherestring, "WHERE ");
  for (i = 0; i < dbtypelistcount; i++)
    {
      sel = sqlselects[i];
      if (sel)
	{
	  flag = TRUE;
	  if (sqlandmode)
	    {
	      sprintf (s, "type  = '%s' OR  ", dbtypelist[i]);
	      strcat (dbwherestring, s);
	    }
	  else
	    {
	      sprintf (s, "type != '%s' AND ", dbtypelist[i]);
	      strcat (dbwherestring, s);
	    }
	}
    }
  dbwherestring[strlen (dbwherestring) - 4] = 0;
  if (!flag)
    strcpy (dbwherestring, "");
  if (debug)
    printf ("\n%s\n", dbwherestring);
  if (!sqldontquery)
    getsqldata ();
  needtosave = TRUE;
  return TRUE;
}

gint
sqlselectmode_cb (GtkWidget *widget, guint datum)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    sqlandmode = TRUE;
  else
    sqlandmode = FALSE;
  dbbuildquery_cb (NULL, 999999);
  return TRUE;
}

void
sqlsetup (void)
{
  GtkWidget *mainbox, *frame, *l[100], *scroll;
  GtkWidget *table, *table2, *t0, *t1, *t2;
  GtkWidget *d1, *d2, *d3, *d4;
  gchar text[30], temp[80], wheretemp[5000];
  gint i;
  GtkTooltips *tooltips;

  setupentry[sqlplace] = frame = gtk_frame_new (_("SQL selection criterias"));
  setupentrylabel[sqlplace] = gtk_label_new (_("SQL"));

  gtk_container_set_border_width (GTK_CONTAINER (frame), 5 * PADDING);

  strcpy (wheretemp, dbwherestring);

  getsqltypelist ();

  for (i = 0; i < dbtypelistcount; i++)
    sqlselects[i] = 0;

  tooltips = gtk_tooltips_new ();

  mainbox = gtk_vbox_new (FALSE, 15 * PADDING);
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy ((GtkScrolledWindow *) scroll,
				  GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

  table = gtk_table_new (4, 2, FALSE);
  table2 = gtk_table_new (dbtypelistcount, 2, FALSE);

  gtk_container_add (GTK_CONTAINER (frame), mainbox);

  gtk_box_pack_start (GTK_BOX (mainbox), table, FALSE, TRUE, 3 * PADDING);


  d1 = gtk_label_new (_("Dist. limit[km] "));
  d2 = gtk_entry_new ();
  sprintf (text, "%0.1f", dbdistance);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), d2,
			_
			("If enabled, show waypoints only within this distance"),
			NULL);

  gtk_entry_set_text (GTK_ENTRY (d2), text);
  gtk_widget_set_usize (d2, 15, 18);
  gtk_signal_connect (GTK_OBJECT (d2),
		      "changed", GTK_SIGNAL_FUNC (dbdistance_cb), d2);

  d3 = gtk_label_new (_("Enable?"));
  d4 = gtk_check_button_new ();
  if (dbusedist)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (d4), TRUE);
  gtk_signal_connect (GTK_OBJECT (d4),
		      "clicked", GTK_SIGNAL_FUNC (dbusedist_cb), d4);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), d4,
			_("Enable/disable distance selection"), NULL);

  gtk_table_attach_defaults (GTK_TABLE (table), d1, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (table), d2, 1, 2, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (table), d3, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (table), d4, 1, 2, 1, 2);

  sqldontquery = TRUE;

  t0 = gtk_label_new (_("Selection mode"));

  t1 = gtk_radio_button_new_with_label (NULL, _("include"));
  t2 =
    gtk_radio_button_new_with_label (gtk_radio_button_group
				     (GTK_RADIO_BUTTON (t1)), _("exclude"));

  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), t1,
			_
			("Show only waypoints where the type field contains one of the selected words"),
			NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), t2,
			_
			("Show only waypoints where the type field doesn't contain any the selected words"),
			NULL);

  gtk_signal_connect (GTK_OBJECT (t1),
		      "clicked", GTK_SIGNAL_FUNC (sqlselectmode_cb),
		      (gpointer) 1);

  if ((strstr (wheretemp, " != ")) != NULL)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (t2), TRUE);

  gtk_table_attach_defaults (GTK_TABLE (table), t0, 0, 2, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (table), t1, 0, 1, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (table), t2, 1, 2, 3, 4);

  gtk_scrolled_window_add_with_viewport ((GtkScrolledWindow *) scroll,
					 table2);

  gtk_box_pack_start (GTK_BOX (mainbox), scroll, TRUE, TRUE, 3 * PADDING);

  for (i = 0; i < dbtypelistcount; i++)
    {
      l[i] = gtk_entry_new ();
      gtk_entry_set_text (GTK_ENTRY (l[i]), dbtypelist[i]);
      gtk_entry_set_editable (GTK_ENTRY (l[i]), FALSE);
      gtk_widget_set_usize (l[i], 15, 18);
      gtk_table_attach_defaults (GTK_TABLE (table2), l[i], 0, 1, i, i + 1);


      sqlfn[i] = gtk_check_button_new ();
      gtk_signal_connect (GTK_OBJECT (sqlfn[i]),
			  "clicked", GTK_SIGNAL_FUNC (dbbuildquery_cb),
			  (gpointer) i);
      sprintf (temp, "= '%s'", dbtypelist[i]);
      if ((strstr (wheretemp, temp)) != NULL)
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sqlfn[i]), TRUE);

      gtk_table_attach_defaults (GTK_TABLE (table2), sqlfn[i], 1, 2, i,
				 i + 1);

    }
  sqldontquery = FALSE;
  getsqldata ();
  gtk_table_set_row_spacings (GTK_TABLE (table), 2 * PADDING);
  gtk_table_set_col_spacings (GTK_TABLE (table), 2 * PADDING);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 2 * PADDING);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 2 * PADDING);
  gtk_widget_show_all (frame);
}




gint
setutc (GtkWidget *widget, guint datum)
{
  gchar text[20];
  sprintf (text, "%s", utctime);
/*   g_print("\nwidget da: %d", GTK_IS_WIDGET(utclabel));  */
  if (GTK_IS_WIDGET (utclabel))
    gtk_entry_set_text (GTK_ENTRY (utclabel), text);

  return TRUE;
}

gint
removesetutc (GtkWidget *widget, guint datum)
{
/*   g_print ("\n\nremove timer!\n\a\n"); */
  lastnotebook =
    gtk_notebook_get_current_page (GTK_NOTEBOOK (settingsnotebook));
  gtk_timeout_remove (utctimer);
  return TRUE;
}
