/****************************************************************

Copyright (c) 2001,2002 Fritz Ganter <ganter@ganter.at>

Website: www.gpsdrive.de

Disclaimer: Please do not use for navigation. 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    *********************************************************************

$Log: gpskismet.c,v $
Revision 1.11  2002/12/08 03:18:26  ganter
shortly before 1.31

Revision 1.10  2002/11/27 00:02:27  ganter
1.31pre2

Revision 1.9  2002/11/14 00:05:55  ganter
added README.kismet
v 1.30pre5

Revision 1.8  2002/11/12 20:37:15  ganter
v30pre4
added more icons, fix for kismet w/o mysql

Revision 1.7  2002/11/06 05:29:15  ganter
fixed most warnings

Revision 1.6  2002/11/06 01:44:15  ganter
v1.30pre2

Revision 1.5  2002/11/05 17:04:04  ganter
...

Revision 1.4  2002/11/05 02:29:59  ganter
bugfixes for kismet mode

Revision 1.3  2002/11/05 00:02:42  ganter
...

Revision 1.2  2002/11/05 00:00:14  ganter
gpskismet seems to work

Revision 1.1  2002/11/04 18:01:53  ganter
added gpskismet.c


reads info from kismet server and insert waypoints into database

*****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <sys/time.h>
#include <gpsdrive.h>
#include "config.h"

#ifdef USEMYSQL
#include "mysql.h"

#define MAXDBNAME 30
extern char dbhost[MAXDBNAME], dbuser[MAXDBNAME], dbpass[MAXDBNAME];
extern char dbtable[MAXDBNAME], dbname[MAXDBNAME];
extern char dbwherestring[5000];
extern char dbtypelist[100][40];
extern double dbdistance;
extern int dbtypelistcount;
extern int usesql;
extern int debug, dbusedist;
extern gchar homedir[500], mapdir[500];
extern gdouble calcdist (gdouble longi, gdouble lati);
extern gdouble calcdist2 (gdouble longi, gdouble lati);

extern MYSQL mysql;
MYSQL_RES *res;
MYSQL_ROW row;

static char macaddr[30], name[80], tbuf[500], lastmacaddr[30];
static int nettype, channel, wep;

/*  Defines for gettext I18n */
# include <libintl.h>
# define _(String) gettext(String)
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif

/* variables */
extern gdouble current_long, current_lat, old_long, old_lat, groundspeed;
extern gdouble zero_long, zero_lat, target_long, target_lat, dist;
int kismetsock, havekismet;
static char kbuffer[20010];
static int bc = 0;
fd_set kismetreadmask;
struct timeval kismettimeout;
static char lat[30], lon[30];
enum
{ english, german, spanish }
voicelang;

#define KISMETSERVERNAME "localhost"
/* Prototypes */
void exiterr (int exitcode);
int getsqldata ();
extern gint speech_out_speek (char *text);
int readkismet (void);
int initkismet (void);


int
readkismet (void)
{
  signed char c;
  char q[1200], buf[300], tname[80];
  int e, r, have, i, j;

  e = 0;
  FD_ZERO (&kismetreadmask);
  FD_SET (kismetsock, &kismetreadmask);
  kismettimeout.tv_sec = 0;
  kismettimeout.tv_usec = 10000;

  do
    {
      if (select (FD_SETSIZE, &kismetreadmask, NULL, NULL, &kismettimeout) <
	  0)
	{
	  perror ("select() call");
	}

      if ((have = FD_ISSET (kismetsock, &kismetreadmask)))
	{
	  while ((e = read (kismetsock, &c, 1)) > 0)
	    {
	      if (c != '\n')
		*(kbuffer + bc++) = c;
	      else
		{
		  c = -1;
		  strcat (kbuffer, "\n");
/* 	g_print("\nfinished: %d",bc); */
		  break;
		}
	      if (bc > 20000)
		{
		  bc = 0;
		  g_print ("kbuffer overflow!\n");
		}

	    }
	}


      if (c == -1)
	{
/* have read a line */
	  bc = c = 0;
	  if ((strstr (kbuffer, "*NETWORK:")) == kbuffer)
	    {
	      if (debug)
		g_print ("\nkbuffer:%s\n", kbuffer);
	      e =
		sscanf (kbuffer,
			"%s %s %d \001%255[^\001]\001 %d"
			" %d  %s %s %[^\n]", tbuf, macaddr, &nettype,
			name, &channel, &wep, lat, lon, tbuf);

	    }
	  if (e == 8)
	    {
	      if (debug)
		g_print
		  ("\ne: %d mac: %s nettype: %d name: %s channel: %d wep: %d "
		   "lat: %s lon: %s\n", e, macaddr, nettype, name, channel,
		   wep, lat, lon);

/* insert waypoint only if we had not just inserted it */
	      if ((strcmp (lastmacaddr, macaddr)) != 0)
		{
		  strcpy (lastmacaddr, macaddr);
		  sprintf (q,
			   "select type from %s where macaddr='%s'",
			   dbtable, macaddr);
		  if (debug)
		    g_print ("\nquery: %s\n", q);
		  if (mysql_query (&mysql, q))
		    exiterr (3);
		  if (!(res = mysql_store_result (&mysql)))
		    exiterr (4);
		  r = 0;
		  while ((row = mysql_fetch_row (res)))
		    {
		      r++;
		    }
		  mysql_free_result (res);
		  if (debug)
		    g_print ("\nnum fields: %d", r);
		  if (r == 0)
		    {
		      if ((strcmp (name, "<no ssid>")) == 0)
			strcpy (name, "no_ssid");
		      g_strdelimit (name, " ", '_');
/* escape ' */
		      j = 0;
		      for (i = 0; i <= strlen (name); i++)
			{
			  if (name[i] != '\'')
			    tname[j++] = name[i];
			  else
			    {
			      tname[j++] = '\\';
			      tname[j++] = '\'';
			    }
			}

		      sprintf (q,
			       "INSERT INTO %s (name,macaddr,nettype,lat,lon,type,wep)"
			       " VALUES ('%s','%s','%d','%s','%s','%s','%d')",
			       dbtable, tname, macaddr, nettype, lat, lon,
			       (wep) ? "WLAN-WEP" : "WLAN", wep);
		      if (debug)
			printf ("\nquery: %s\n", q);
		      if (mysql_query (&mysql, q))
			exiterr (3);
		      r = mysql_affected_rows (&mysql);
		      g_strdelimit (name, "_", ' ');
		      switch (voicelang)
			{
			case english:
			  sprintf (buf, "Found new %s access point: %s",
				   (wep) ? "crypted" : "open", name);
			  break;
			case spanish:
			  sprintf (buf, "Found new %s access point: %s",
				   (wep) ? "closed" : "open", name);
			  break;
			case german:
			  sprintf (buf,
				   "Es wurde ein neuer  %s exses point gefunden: %s",
				   (wep) ? "verschlsselter" : "offener",
				   name);
			  break;
			}
		      speech_out_speek (buf);
		      /* if (debug) */
		      printf (_("rows inserted: %d\n"), r);
		      getsqldata ();
		    }
		}
	    }

	  memset (kbuffer, 0, 20000);
	  strcpy (kbuffer, "");
	}

    }
  while (have != 0);

  return TRUE;
}

int
initkismet (void)
{
  struct sockaddr_in server;
  struct hostent *server_data;
  char buf[180];

  strcpy (lastmacaddr, "");
/*  open socket to port */
  if ((kismetsock = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror (_("can't open socket for port "));
      return -1;
    }
  server.sin_family = AF_INET;
/*  We retrieve the IP address of the server from its name: */
  if ((server_data = gethostbyname (KISMETSERVERNAME)) == NULL)
    {
      fprintf (stderr, "%s: unknown host", KISMETSERVERNAME);
      return -1;
    }
  memcpy (&server.sin_addr, server_data->h_addr, server_data->h_length);
  server.sin_port = htons (2501);
/*  We initiate the connection  */
  if (connect (kismetsock, (struct sockaddr *) &server, sizeof server) < 0)
    {
      return -1;
    }
  else
    {
      havekismet = TRUE;
      strcpy (buf,
	      "!0 ENABLE NETWORK bssid,type,ssid,channel,wep,minlat,minlon\n");
      write (kismetsock, buf, strlen (buf));
    }

  return TRUE;
}


#else
int havekismet = FALSE;

int
initkismet (void)
{
  return FALSE;
}

int
readkismet (void)
{
  return FALSE;
}

#endif
