/***********************************************************************

Copyright (c) 2001,2002 Fritz Ganter <ganter@ganter.at>

Website: www.gpsdrive.de

Disclaimer: Please do not use for navigation.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    *********************************************************************

***********************************************************************/

#ifndef GPSDRIVE_GPSDRIVE_H
#define GPSDRIVE_GPSDRIVE_H


#include <gdk/gdktypes.h>
#include "gtk/gtk.h"


/*  adapt this section for the size of your screen */

/*  width of the map on screen, default is 640 */
#define SCREEN_X real_screen_x
/*  height of the map on screen, default is 512 */
#define SCREEN_Y real_screen_y
#define FONTBIG "-monotype-arial-bold-r-normal-*-*-360-*-*-p-*-iso8859-1"
#define FONTSMALL2 "-monotype-arial-bold-r-normal-*-*-240-*-*-p-*-iso8859-1"
#define FONTSMALL "-adobe-helvetica-bold-r-normal-*-*-240-*-*-p-*-iso8859-1"
#define FONTTINY "-monotype-arial-bold-r-normal-*-*-160-*-*-p-*-iso8859-1"
#define FONTTINY2 "-adobe-helvetica-bold-r-normal-*-*-160-*-*-p-*-iso8859-1"
#define TEXTFONT "-monotype-arial-bold-r-normal-*-*-160-*-*-p-*-iso8859-1"
#define TEXTFONT2 "-adobe-helvetica-bold-r-normal-*-*-140-*-*-p-*-iso8859-1"
#define SMALLTEXTFONT "-monotype-arial-bold-r-normal-*-*-120-*-*-p-*-iso8859-1"
#define SMALLTEXTFONT2 "-adobe-helvetica-bold-r-normal-*-*-120-*-*-p-*-iso8859-1"
#define SMALLTEXTFONT3 "-monotype-arial-*-r-normal-*-*-100-*-*-p-*-iso8859-1"
#define SMALLTEXTFONT4 "-adobe-helvetica-*-r-normal-*-*-100-*-*-p-*-iso8859-1"

#define FONT1 FONTBIG
#define FONT2 FONTSMALL
#define FONT3 "-monotype-arial-bold-r-normal-*-*-280-*-*-p-*-iso8859-1"
#define FONT4 "-adobe-helvetica-bold-r-normal-*-*-280-*-*-p-*-iso8859-1"

/*  set this to 0 for normal use, 1 for small screens */
#define SMALLMENU real_smallmenu
/*** Mod by Arms */
#define PADDING int_padding
/*** Mod by Arms */
#define XMINUS 60
/*** Mod by Arms (move) */
#define YMINUS 67


/*  size of the bearing pointer, default is 50 */
#define PSIZE real_psize

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

#define MAXBIG 50000

/*  How oft do we redraw the screen (in milliseconds) */
#define REDRAWTIMER 300
/*  How often do we ask for positioning data */
#define TIMER 500

#define MAXSHOWNWP 100

/*  timer for watching waypoints (Radar) */
#define WATCHWPTIMER 2000

/*  If speech output is used, the intervall of spoken messages in milliseconds */
#define SPEECHOUTINTERVAL 10000

/*  defines offset and color of the shadows */
#define SHADOWOFFSET 7
#define SHADOWGREY 0xD000

#define ROUTEREACH (0.02+10*groundspeed/(3600*milesconv))
/* #define ROUTEREACH 0.05 */
#define ROUTEREACHFACT 10

#define SERVERNAME gpsdservername

#define SERVERPORT 2222
#define SERVERPORT2 2947

#define WANTSHADOWNO

#define MAPSCALE 20000
/* Mapscale / pixelfact is meter / pixel */
#define PIXELFACT 2817.947378
#define KM2MILES 0.62137119
#define KM2NAUTIC  0.54


#define LOCALTESTXXX
#ifdef LOCALTEST
#define WEBSERVER "wuffi.ganter.at"
#else
#define WEBSERVER "www.mapblast.com"
#endif
#define WEBSERVER2 "msrvmaps.mappoint.net"

#define FESTIVAL_ENGLISH_INIT "(voice_ked_diphone)\n"
#define FESTIVAL_GERMAN_INIT "(voice_german_de3_os)\n"
#define FESTIVAL_SPANISH_INIT "(voice_el_diphone)\n"

#define EXPEDIAFACT 1378.6

/*
 * Declarations.
 */
extern gchar homedir[];
extern gchar savetrackfn[];

extern gint real_screen_x;
extern gint real_screen_y;
extern gint shadow;

extern GdkGC *kontext;
extern GdkColor darkgrey;
extern GdkColor green;
extern GdkDrawable *drawable;
extern GtkWidget *trackbt;


#endif /* GPSDRIVE_GPSDRIVE_H */
