/***********************************************************************

Copyright (c) 2001,2002 Fritz Ganter <ganter@ganter.at>

Website: www.gpsdrive.de

Disclaimer: Please do not use for navigation. 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    *********************************************************************

$Log: gpsdrive.c,v $
Revision 1.325  2002/12/08 03:18:26  ganter
shortly before 1.31

Revision 1.324  2002/12/08 01:38:26  ganter
perhaps fix for systems without glib-locale installed.
added "y" key to create waypoint at current mouse position.

Revision 1.323  2002/12/07 21:38:46  ganter
delete wp now also works in sqlmode

Revision 1.322  2002/11/29 15:33:45  ganter
v1.31pre3

Revision 1.321  2002/11/27 00:02:27  ganter
1.31pre2

Revision 1.320  2002/11/25 21:56:23  ganter
added icons

Revision 1.319  2002/11/25 20:30:22  ganter
added airport icon

Revision 1.318  2002/11/24 23:36:17  ganter
added icon

Revision 1.317  2002/11/24 17:10:46  ganter
radar R- works again

Revision 1.316  2002/11/24 16:56:29  ganter
speedtrap works now with sql

Revision 1.315  2002/11/24 16:01:32  ganter
added speedtrap icon, thanks to Sven Fichtner

Revision 1.314  2002/11/19 14:49:39  ganter
...

Revision 1.313  2002/11/16 20:23:44  ganter
bugfixes for 1.30

Revision 1.312  2002/11/14 00:05:55  ganter
added README.kismet
v 1.30pre5

Revision 1.311  2002/11/13 18:20:41  ganter
fixed buffer overflow in gpssql.c

Revision 1.310  2002/11/13 17:31:57  ganter
added display of number of waypoints

Revision 1.309  2002/11/12 20:37:15  ganter
v30pre4
added more icons, fix for kismet w/o mysql

Revision 1.308  2002/11/08 23:35:19  ganter
v1.30pre3

Revision 1.307  2002/11/08 22:08:10  ganter
...

Revision 1.306  2002/11/06 05:29:14  ganter
fixed most warnings

Revision 1.305  2002/11/06 01:44:15  ganter
v1.30pre2

Revision 1.304  2002/11/05 17:04:04  ganter
...

Revision 1.303  2002/11/05 00:00:14  ganter
gpskismet seems to work

Revision 1.302  2002/11/02 12:38:55  ganter
changed website to www.gpsdrive.de

Revision 1.301  2002/10/30 09:32:49  ganter
v1.29pre9
hopefully removed all gtk-warnings

Revision 1.300  2002/10/29 16:42:03  ganter
improved configure.in (sql can be disabled)
v1.29pre9

Revision 1.299  2002/10/27 10:51:29  ganter
1.28pre8

Revision 1.298  2002/10/24 08:44:09  ganter
...

Revision 1.297  2002/10/16 14:16:13  ganter
working on SQL gui

Revision 1.296  2002/10/15 07:44:11  ganter
...

Revision 1.295  2002/10/14 08:38:59  ganter
v1.29pre3
added SQL support

Revision 1.294  2002/09/24 08:51:55  ganter
updated translations
changed gpsdrive.spec

Revision 1.293  2002/09/18 13:42:52  ganter
mapblast url changed again
v1.28pre1

Revision 1.292  2002/09/17 20:57:58  ganter
added copyright and README for gpsd
v1.27

Revision 1.291  2002/09/12 10:05:21  ganter
fixed Timeout if getting only GGA data

Revision 1.290  2002/09/10 12:55:25  ganter
v1.27pre1
set battery status update to 5 seconds
added portuguese translation

Revision 1.289  2002/09/01 18:30:06  ganter
fixed segfault on no apm computers

Revision 1.288  2002/08/31 13:10:52  ganter
v1.26 release

Mapblast server works again (they changed the URL).
Bugfix for -a option.
Added -i option to ignore NMEA checksum (for broken GPS receivers).
Added "j" key to switch to next waypoint on route mode.
Added support for festival lite (flite) speech output.

Revision 1.287  2002/08/29 15:20:51  ganter
timezone in settings/geoinfo works, but window must be refreshed

Revision 1.286  2002/08/29 13:11:05  ganter
1.26pre65
Mapblast works again.
Download between 0E and 1W works now in non-degree display mode.
Current speed speech output only when driving faster than 20km/h

Revision 1.285  2002/08/29 11:17:40  ganter
will change mapblast URL

Revision 1.284  2002/08/05 19:16:27  ganter
fixed bug in mapdownload (triggered thru change to HTTP1.1)

Revision 1.283  2002/08/04 12:24:57  ganter
Current speed speech output only when driving faster than 20km/h

Revision 1.282  2002/07/30 21:33:53  ganter
added "J" key to switch to next waypoint

Revision 1.281  2002/07/30 21:01:30  ganter
added patches from Marco Molteni for separate track.c

Revision 1.280  2002/07/30 20:49:54  ganter
1.26pre3
added support for festival lite (flite)
changed http request to HTTP1.1 and added correct servername

Revision 1.279  2002/07/17 12:31:54  ganter
v1.25

Revision 1.278  2002/07/14 18:22:19  ganter
v1.25pre1

Revision 1.277  2002/07/14 14:23:34  ganter
testnewmap works now again, but w/o new algorithmus

Revision 1.276  2002/07/13 23:40:17  ganter
changed testnewmap algorithmus

Revision 1.275  2002/07/13 13:31:41  ganter
in download menu the download area is now marked

Revision 1.274  2002/07/02 12:12:55  ganter
v1.24

Revision 1.273  2002/07/01 00:45:00  ganter
added trip info (in settings menu)
ACPI fixes (close battery fd)

Revision 1.272  2002/06/30 11:32:28  ganter
fix convertRMC
new arrows

Revision 1.271  2002/06/30 09:38:17  ganter
make fields in convertXXX larger, earthmate seems to send larger GPGSV
v1.24pre1

Revision 1.270  2002/06/29 21:47:38  ganter
v1.23

Revision 1.269  2002/06/29 00:28:21  ganter
v1.23pre10

Revision 1.268  2002/06/29 00:23:18  ganter
added ACPI support for battery meter

Revision 1.267  2002/06/23 17:09:35  ganter
v1.23pre9
now PDA mode looks good.

Revision 1.266  2002/06/23 08:57:50  ganter
changed menu look for -x

Revision 1.265  2002/06/16 21:35:08  ganter
got settings smaller

Revision 1.264  2002/06/16 17:50:34  ganter
working on PDA screen

Revision 1.263  2002/06/12 10:58:49  ganter
v1.23pre7

Revision 1.262  2002/06/10 18:04:22  ganter
added compass

Revision 1.261  2002/06/02 20:54:09  ganter
added navigation.c and copyrights

Revision 1.260  2002/06/02 18:46:30  ganter
v1.23pre6
did lot of bug fixing for small displays.

Revision 1.259  2002/06/01 15:42:31  ganter
fixed bug for little screens
added new wpget from Miguel Angelo Rozsas <miguel@rozsas.xx.nom.br>

Revision 1.258  2002/06/01 15:24:42  ganter
working on bugfix for small screens

Revision 1.257  2002/05/30 19:10:55  ganter
v1.23pre4
use GPGGA if no GPRMC is available

Revision 1.256  2002/05/29 20:41:41  ganter
added swedish translation

Revision 1.255  2002/05/29 19:21:01  ganter
added gpsfetchmap.pl and geocache2way

Revision 1.254  2002/05/23 09:07:37  ganter
v1.23pre1
added new BSD battery stuff

Revision 1.253  2002/05/20 22:41:02  ganter
removed race condition in setutc()
new 1.22

Revision 1.252  2002/05/20 20:40:23  ganter
v1.22

Revision 1.251  2002/05/20 10:02:48  ganter
v1.22pre7

Revision 1.250  2002/05/19 19:25:16  ganter
fly and nautic loading works

Revision 1.249  2002/05/18 20:58:53  ganter
finished geo infos
v1.22pre5

Revision 1.248  2002/05/17 23:22:25  ganter
added sunrise,sunset in settings menu

Revision 1.247  2002/05/17 20:05:23  ganter
changed settings menu to notebook widget

Revision 1.246  2002/05/15 19:05:31  ganter
created settings.c

Revision 1.245  2002/05/13 10:01:47  ganter
fixed bug in downloadsetparm if not decimal notation
new v1.21

Revision 1.244  2002/05/12 23:14:53  ganter
new 1.21
changed B to N key.

Revision 1.243  2002/05/12 20:54:08  ganter
v1.21

Revision 1.242  2002/05/12 19:52:39  ganter
added nightmode. See settings menu.

Revision 1.241  2002/05/11 15:45:31  ganter
v1.21pre1
degree,minutes,seconds should work now

Revision 1.240  2002/05/10 00:20:14  ganter
display of lat/long is switchable between decimal and degree,minutes
and seconds display
added display of radar warning as scrolling text
distance to recognize arriving of the destination is now speed
depending
added check of the checksum of the NMEA sentences to avoid crashes if
invalid NMEA sentences are received

Revision 1.239  2002/05/04 09:17:36  ganter
added new intl subdir

Revision 1.238  2002/05/02 01:34:11  ganter
added speech output of waypoint description

Revision 1.237  2002/05/02 00:31:21  ganter
speech output: say reached target also if not in route mode

Revision 1.236  2002/05/01 21:44:38  ganter
added README.FreeBSD

Revision 1.235  2002/04/29 02:52:18  ganter
v1.20pre1
added display of sat position

Revision 1.234  2002/04/28 22:21:13  ganter
new 1.19 ;-)

Revision 1.233  2002/04/28 21:54:20  ganter
v1.19

Revision 1.232  2002/04/28 11:53:43  ganter
v1.19pre2
button to delete waypoint
fixed miles distance on startup in miles mode
new sat level display colors

Revision 1.231  2002/04/21 13:29:30  ganter
fixed bug in downloadsetparms (longitude comparision)

Revision 1.230  2002/04/21 13:15:02  ganter
Now getting good maps for USA from expedia server works: I changed in
the URL EUR0809 to USA0409 if longitude is west of 30W. If anyone
have found a system for this EUR0809,USA0409 strings in the URL,
please inform me.

Revision 1.229  2002/04/21 00:27:22  ganter
v1.18pre3
much more precise calculation of distance (uses WGS84 elipsoid)

Revision 1.228  2002/04/18 22:50:37  ganter
added turkish translation
added display number of satellites
v1.18pre2

Revision 1.227  2002/04/16 21:08:50  ganter
...

Revision 1.226  2002/04/14 23:06:26  ganter
v1.17

Revision 1.225  2002/04/14 15:25:56  ganter
v1.17pre3
added simulaton follow switch in setup menu

Revision 1.224  2002/04/13 18:08:30  ganter
added comment

Revision 1.223  2002/04/13 17:49:44  ganter
...

Revision 1.222  2002/04/13 17:30:35  ganter
v1.17pre2

Revision 1.221  2002/04/12 14:10:19  ganter
removed way.txt checking and popup, if there are wrong entries, the
entries are ignored, not the whole file.

Revision 1.220  2002/04/10 21:32:55  ganter
sometimes wrong coordinates in download map window, fixed.

Revision 1.219  2002/04/07 19:55:54  ganter
bugfix in gpsdrive.c and gpsfetchmap

Revision 1.218  2002/04/07 17:15:31  ganter
v1.16

Revision 1.217  2002/04/07 12:23:41  ganter
v1.16pre9

Revision 1.216  2002/04/07 00:47:42  ganter
added fly.c
added more GPS-receivers

Revision 1.215  2002/04/06 19:14:42  ganter
I found a better documentation for GARMIN receivers. So I removed DOP
and added EPE (estimated position error). Sorry, if you have no
GARMIN. The used NMEA sentence is $PGRME.

Revision 1.214  2002/04/06 17:12:11  ganter
changed #elif to #else

Revision 1.213  2002/04/06 17:08:56  ganter
v1.16pre8
cleanup of gpsd files

Revision 1.212  2002/04/06 13:14:04  ganter
removed feature to set posmode on with left mouseclick in the map
window. It has to switched on with the toogle button in the menu.

Revision 1.211  2002/04/06 00:36:01  ganter
changing filelist

Revision 1.210  2002/04/05 23:20:51  ganter
added DGPS displaying
added DOP (DILUTION OF PRECISION):
A measure of the GPS receiver-satellite geometry. A low DOP value
indicates better relative geometry and correspondingly higher
accuracy.

Revision 1.209  2002/04/05 19:05:48  ganter
changed to Remco Treffkorn's gpsd

Revision 1.208  2002/04/04 22:34:07  ganter
v1.16pre7
added altitude in stored tracks
added zoom factor display on map

Revision 1.207  2002/04/03 10:20:31  ganter
added altitude display

Revision 1.206  2002/04/03 08:57:25  ganter
trying to get out altitude

Revision 1.205  2002/04/02 19:46:15  ganter
v1.16pre4
you can type in coordinates in the "Add waypoint" window (x-key)
Autosave of configuration
update spanish translation (translater had holiday)

Revision 1.204  2002/04/01 22:39:04  ganter
v1.16pre3

Revision 1.203  2002/04/01 22:32:04  ganter
added garmin and serialdevice in setup

Revision 1.202  2002/04/01 14:38:13  ganter
really upload new 1.15 and v1.16-pre2
added penguin
fixed gpsd detection
variable testgarmin inserted, set it to FALSE if you have problems with your
NMEA receiver detection.
don't forget to call "gpsdrive -t /dev/ttySx" the first time, where x is
your port number (0=COM1:)

Revision 1.201  2002/04/01 14:13:38  ganter
v1.16-pre2
serialdev fix was not good enough

Revision 1.200  2002/04/01 12:55:45  ganter
I decided to create a new 1.15 from 1.16-pre1 because if the serialdev bug.

Revision 1.199  2002/04/01 12:43:12  ganter
v1.16-pre1 bugfix for serialdev if no gpsdriverc exists yet

Revision 1.198  2002/04/01 02:35:13  ganter
added -b parameter for NMEA server
added -c parameter to set position in simulation mode to waypoint name

Revision 1.197  2002/03/31 20:42:55  ganter
v1.15 Summary:
You can select your "way*.txt" file in setup menu.
	   The DEFAUL entry in way.txt is now obsolet.
	   The "setdefaultpos" entry in gpsdricerc in now obsolet.
	   Added battery meter, shows battery capacity and battery/plugged mode
	   (only shown on notebooks).
	   Removed command line parameter: -w.
	   Added command line parameter: -a , use it if gpsdrive
	   crashes (happens on broken apm BIOSes).
	   Removed popup to start GPSD, its now a button.
	   Added new unit "nautical miles".
	   Moved buttons to setup menu, setup menu with new options.

Revision 1.196  2002/03/31 18:11:06  ganter
v1.15-pre5
you can select your "way*.txt" file in setup menu
The DEFAUL entry in way.txt is now obsolet
The "setdefaultpos" entry in gpsdricerc in now obsolet

Revision 1.195  2002/03/31 16:41:25  ganter
The "DEFAULT" waypoint is now obsolet. All references to it will now
be removed.

Revision 1.194  2002/03/31 14:30:23  ganter
working on chooseable waypoint files

Revision 1.193  2002/03/30 20:07:33  ganter
2nd pre 1.15

Revision 1.192  2002/03/30 10:37:43  ganter
pre 1.15

Revision 1.191  2002/03/30 00:42:58  ganter
created setup menu

Revision 1.190  2002/03/29 23:09:06  ganter
added battery meter, shows battery capacity and battery/plugged mode

Revision 1.189  2002/03/24 17:45:26  ganter
v1.14 some cosmetic changes

Revision 1.188  2002/03/23 18:38:38  ganter
v1.13

Revision 1.187  2002/03/23 18:34:02  ganter
added better background for waypoint text, wp text has now a bold font

Revision 1.186  2002/03/22 00:36:40  ganter
bugfix for late gpsd start
remembering last position if setdefaultpos = 0 in gpsdriverc

Revision 1.185  2002/03/21 21:49:08  ganter
added question if gpsd should be started.
Thanks to daZwerg(gEb-Dude) for suggestion.

Revision 1.184  2002/03/17 23:14:06  ganter
v1.12

Revision 1.183  2002/03/17 19:13:15  ganter
added route
v1.12 preview

Revision 1.182  2002/03/16 20:21:07  ganter
fixed segfault if no gpsdriverc exists. New v1.11

Revision 1.181  2002/03/16 19:17:59  ganter
v1.11

Revision 1.180  2002/03/16 19:15:10  ganter
added gpsdriverc file to save and restore settings
added shadow to all drawn elements on map
removed -m flag for setting miles because it is saved in gpsdriverc

Revision 1.179  2002/03/14 23:54:16  ganter
added speech output of target set
use HTTP_PROXY or http_proxy for enviroment variable to set proxy server

Revision 1.178  2002/03/10 18:50:52  ganter
minimap is now clickable for switch to position mode
parameter -1 for 1 button mouse, i.e. touchpads
viewable satellites with 0db Signal are shown als short red bar

Revision 1.177  2002/03/03 15:31:52  ganter
posmode is switched off after 10 seconds automatically

Revision 1.176  2002/02/27 12:00:13  ganter
download default is now expedia server

Revision 1.175  2002/02/26 15:34:17  ganter
added x key for set waypoint on actual position

Revision 1.174  2002/02/25 01:45:38  ganter
bugfix for loading tracks. now date/time is also loaded

Revision 1.173  2002/02/24 22:26:41  ganter
new v1.9, added shortcuts

Revision 1.172  2002/02/24 20:15:05  ganter
prevent to call target window more than once

Revision 1.171  2002/02/24 19:38:44  ganter
Real, real v1.9, fixed division by zero handling

Revision 1.170  2002/02/24 19:16:27  ganter
Real v1.9, added  -ffast-math because of better DIVZERO handling in code

Revision 1.169  2002/02/24 16:46:04  ganter
v1.9

Revision 1.168  2002/02/24 15:58:24  ganter
the "select waypoint" window is now auto-updated and shows every 5
seconds the true distance to the waypoints.

Revision 1.167  2002/02/23 23:47:55  ganter
added set waypoint at current position by CTRL-right mouse click

Revision 1.166  2002/02/18 01:37:18  ganter
added set waypoint by CTRL-left mouse click and storing into way.txt

Revision 1.165  2002/02/17 23:35:29  ganter
perhaps bugfix for black maps
added reread of way.txt if file is changed

Revision 1.164  2002/01/11 16:38:14  ganter
Changed URL for map webservers. A lot of thanks to Oliver Kuehlert <Oliver.Kuehlert@mpi-hd.mpg.de>!

Revision 1.163  2001/12/12 23:06:48  ganter
added changes from Richard Scheffenegger <rscheff@chello.at>

Revision 1.162  2001/12/02 21:41:44  ganter
fixed bug in setlocale

Revision 1.161  2001/12/02 17:40:37  ganter
friends mode bugfix. Enhanced -x option

Revision 1.160  2001/11/16 20:12:19  ganter
v1.5

Revision 1.159  2001/11/16 18:00:54  ganter
tcpserver/client works

Revision 1.158  2001/11/13 18:37:46  ganter
v1.4 enhanced friends functions

Revision 1.157  2001/11/12 19:55:47  ganter
v1.3

Revision 1.156  2001/11/12 19:11:53  ganter
friends server and client starting to work

Revision 1.155  2001/11/11 17:25:34  ganter
added friendsd

Revision 1.154  2001/11/04 19:38:32  ganter
autodetects setting for voice output, cosmetic changes

Revision 1.153  2001/11/03 23:27:00  ganter
moved manpages to man directory

Revision 1.152  2001/11/03 19:22:07  ganter
next public v1.1, made testnewmap more accurate

Revision 1.151  2001/11/03 19:10:05  ganter
new layout, some buttons are now checkboxes

Revision 1.150  2001/11/03 12:52:12  ganter
v1.1, added best map button and next more/less detailed map button

Revision 1.149  2001/11/02 00:42:32  ganter
real v1.0, changed manpage

Revision 1.148  2001/11/02 00:10:02  ganter
v1.0 for public

Revision 1.147  2001/11/01 20:17:58  ganter
v1.0 added spanish voice output

Revision 1.146  2001/11/01 11:36:39  ganter
added festival init for german and english. See manpage

Revision 1.145  2001/10/29 15:26:20  ganter
added -o

Revision 1.144  2001/10/29 12:43:23  ganter
added -o option to output NMEA sentences. Written by Dan Egnor <egnor@ofb.net>

Revision 1.143  2001/10/28 17:17:38  ganter
v0.35

Revision 1.142  2001/10/28 15:54:56  ganter
v0.35 added load and store track

Revision 1.141  2001/10/27 16:05:03  ganter
autodetected screen size

Revision 1.140  2001/10/26 17:58:09  ganter
added auto detecting screen size

Revision 1.139  2001/10/22 23:37:23  ganter
v 0.34 added proxy server

Revision 1.138  2001/10/21 18:12:51  ganter
v0.33

Revision 1.137  2001/10/21 16:44:10  ganter
bugfix in position calculation for big maps.
pre 0.33

Revision 1.136  2001/10/21 14:38:09  ganter
found buffer overflow in get_position_data_cb only in NMEA mode, result was wrong text translations.

Revision 1.135  2001/10/21 03:06:30  ganter
new position calculation looks good, but in progress...

Revision 1.134  2001/10/19 23:30:11  ganter
track parts are not drawn if no GPS Fix is avail. Should work...

Revision 1.133  2001/10/16 14:11:40  ganter
added po files

Revision 1.132  2001/10/14 14:35:38  ganter
really V0.32 expedia server works now

Revision 1.131  2001/10/14 13:09:11  ganter
working on expedia scaling

Revision 1.130  2001/10/14 11:26:04  ganter
Program now creates a ~/.gpsdrive directory if it was not found. Also
it creates a map_koord.txt in it.

Revision 1.129  2001/10/14 10:41:59  ganter
v0.32 correct path for prefix other than /usr/local

Revision 1.128  2001/10/13 23:04:56  ganter
corrected paths for locale and pixmap, ./configure --prefix= works now as
expected

Revision 1.127  2001/10/13 15:33:18  ganter
test

Revision 1.126  2001/10/09 13:14:02  ganter
v0.31

Revision 1.125  2001/10/08 23:36:17  ganter
added download from expedia.com, but it don't work yet.
Reason: Server don't send CONTENT-LENGTH

Revision 1.124  2001/10/08 12:14:05  ganter
radar detection stopped working, runs now again

Revision 1.123  2001/10/08 02:24:39  ganter
fixed bug in testconfig_cb

Revision 1.122  2001/10/07 20:06:08  ganter
detects wrong names in map_koord.txt

Revision 1.121  2001/10/07 16:30:09  ganter
v0.30

Revision 1.120  2001/10/07 15:19:55  ganter
removed some debugging lines

Revision 1.119  2001/10/07 15:17:29  ganter
import seems to work

Revision 1.118  2001/10/07 00:59:13  ganter
map import nearly finished

Revision 1.117  2001/10/04 19:26:59  ganter
added rectangle on minimap
working on map import

Revision 1.116  2001/09/30 18:45:27  ganter
v0.29
added choice of map type

Revision 1.115  2001/09/30 15:54:32  ganter
added minimap, removed gpsdrivelogo

Revision 1.114  2001/09/30 12:08:11  ganter
added parameter -x to use a seperate window for the menu
some changes in speech output
added help button

Revision 1.113  2001/09/28 15:43:56  ganter
v0.28 changed layout, some bugfixes

Revision 1.112  2001/09/27 16:52:29  ganter
....

Revision 1.111  2001/09/25 23:49:43  ganter
v 0.27

Revision 1.110  2001/09/25 23:32:59  ganter
some bugfixes for tracking

Revision 1.109  2001/09/25 20:58:13  ganter
tracking is working

Revision 1.108  2001/09/25 17:00:32  ganter
fallback font strings corrected

Revision 1.107  2001/09/24 19:42:20  ganter
removed -s -g -f command line options. GpsDrive tries first port 2222,
then port 2947 and if not found the GARMIN mode. If this is also not
found it switches to simulation mode.

Revision 1.106  2001/09/24 19:00:46  ganter
added support for gpsd by  Remco Treffkorn using port 2947

Revision 1.105  2001/09/23 22:31:13  ganter
v0.26

Revision 1.104  2001/09/23 22:04:03  ganter
Added -t and -l command line switches, see gpsdrive -h
Added german speech texts.
Bugfix in radar detection. Only the nearest Radar gives speech output.
Cosmetic changes for markers.
#define MAXSHOWNWP 100 for max. shown waypoints. Tested with list of
30000 waypoints. If gpsdrive hangs, reduce number of waypoints in
file.
Better fallbacks for fonts. I prefer an arial truetype font. Helvetica
is used if no arial font is found.

Revision 1.103  2001/09/23 15:06:32  ganter
....

Revision 1.102  2001/09/23 00:58:59  ganter
....

Revision 1.101  2001/09/22 23:35:00  ganter
Added program icon. Added check for way.txt format errors.

Revision 1.100  2001/09/22 16:22:47  ganter
solved this intl compile problem

Revision 1.99  2001/09/21 23:16:20  ganter
v0.25

Revision 1.98  2001/09/21 23:11:07  ganter
added error message for not existent DEFAULT waypoint
added popup error window

Revision 1.97  2001/09/21 21:32:20  ganter
In the way.txt waypoint file the waypoint
named "DEFAULT" is the start position of the program,
important if you start it in simulation mode.
So not everybody in the world need to start at my
house in Austria! ;-)
Bugfix if at start no map is found.

Revision 1.96  2001/09/21 10:47:06  ganter
V0.24: bugfix for displays which have not 16 bit colordepth

Revision 1.95  2001/09/20 15:07:44  ganter
added Radar warning. If you store the radars as waypoints named R-XXXX where
XXXX can be a incremented number. You hear radar warning as voice message and
a red/black blinking Bearing pointer.

Revision 1.94  2001/09/18 23:02:03  ganter
v0.22

Revision 1.93  2001/09/18 22:56:10  ganter
If you click with the left mouse button on the map you are in "Display
mode" where a rectangle is the cursor and no position is shown. If you
zoom or select another map scale, this is done for the position of the
rectangle-cursor in the same manner as it would be your actual
position.

The middle mouse button switches back to normal mode. The same if you
select a target with the right mouse button.  Shift-left-mouse-button
and shift-right-mouse-button changes the map scale.

Revision 1.92  2001/09/18 21:44:42  ganter
testnewmap is not o.k.

Revision 1.91  2001/09/18 13:40:13  ganter
v0.21 using double buffering to avoid flicker.

Revision 1.90  2001/09/18 05:33:06  ganter
...

Revision 1.89  2001/09/17 19:03:54  ganter
changed speech text

Revision 1.88  2001/09/17 00:29:38  ganter
added speech output of bearing

Revision 1.87  2001/09/16 21:36:05  ganter
speech output is working

Revision 1.86  2001/09/16 19:12:35  ganter
....

Revision 1.84  2001/09/16 18:42:32  ganter
now we work on speech output

Revision 1.83  2001/09/09 17:31:36  ganter
v0.18 added defines to make it possible to define smaller screen sizes
this is the way to porting for iPaq

Revision 1.82  2001/09/09 15:30:39  ganter
numbers changed to SCREEN_X and SCREEN_Y, but doesn't work yet

Revision 1.81  2001/09/09 14:54:44  ganter
beginning rewrite source to set screenwidth and height as define

Revision 1.80  2001/09/09 08:07:11  ganter
v0.17

Revision 1.79  2001/09/08 18:49:11  ganter
added + sign as marker for the selected target

Revision 1.78  2001/09/08 13:20:58  ganter
added tooltips

Revision 1.77  2001/09/06 22:00:53  ganter
added: click with right mouse button on map sets the target waypoint

Revision 1.76  2001/09/06 12:19:43  ganter
changed strings

Revision 1.75  2001/09/06 08:51:57  ganter
changed label order, now really v0.15

Revision 1.74  2001/09/06 08:46:35  ganter
some string changes, really v0.15

Revision 1.73  2001/09/06 00:16:02  ganter
display_status

Revision 1.72  2001/09/06 00:05:50  ganter
new fields layout

Revision 1.71  2001/09/05 22:03:26  ganter
scaler works

Revision 1.70  2001/09/05 19:33:06  ganter
created scaler for map scale selection

Revision 1.69  2001/09/04 22:15:59  ganter
....

Revision 1.68  2001/09/04 21:30:48  ganter
added time to destination. I didn't calculate with bearing.

Revision 1.67  2001/09/04 19:55:40  ganter
moved progress bar into the download window
download window is only removed after download
added delete_event handler for download_cb

Revision 1.66  2001/09/04 12:43:15  ganter
added progress bar for download status

Revision 1.65  2001/09/04 01:20:23  ganter
restore cursor on end of download

Revision 1.64  2001/09/04 00:39:57  ganter
added cool cursor for map position selection

Revision 1.63  2001/09/03 23:51:11  ganter
....

Revision 1.62  2001/09/03 23:48:16  ganter
translations

Revision 1.61  2001/09/03 23:32:34  ganter
public v0.13

Revision 1.60  2001/09/03 23:04:53  ganter
map is now clickable for selection of the download position.
yardstick is fixed for m/yards display.

Revision 1.59  2001/09/03 15:42:56  ganter
missing translation

Revision 1.58  2001/09/03 15:36:39  ganter
added scale marker on map

Revision 1.57  2001/09/03 01:20:32  ganter
added scale line, it's not perfect yet

Revision 1.56  2001/09/02 18:48:11  ganter
near to v0.12

Revision 1.55  2001/09/02 17:09:32  ganter
download of gif doesn't work correctly sometimes

Revision 1.54  2001/09/02 14:39:15  ganter
....

Revision 1.53  2001/09/01 18:15:57  ganter
download in a non-blocking timeout routine

Revision 1.52  2001/09/01 15:50:43  ganter
working on downloading maps from internet

Revision 1.51  2001/08/31 19:53:48  ganter
rearranged calls of draw_marker.
fixed little bug in zoom-out, works now like expected.

Revision 1.50  2001/08/31 09:56:11  ganter
fixed bug if you are West or South. Thanks to Jason Aras.

Revision 1.49  2001/08/31 01:29:43  ganter
version 0.10

Revision 1.48  2001/08/30 01:24:43  ganter
better simulator

Revision 1.47  2001/08/30 00:08:01  ganter
more beautifully indent. Thanks to timecop@japan.co.jp

Revision 1.46  2001/08/29 23:13:44  ganter
version 0.9

Revision 1.45  2001/08/29 21:58:13  ganter
code cleanup, translated to english

Revision 1.44  2001/08/29 19:07:08  ganter
main() code rewritten for better readability because japanese people
complained about bad style coding.
Also translate all variable and messages to english.

Revision 1.43  2001/08/29 14:00:42  ganter
changed variable names to english

Revision 1.42  2001/08/27 21:40:46  ganter
get groundspeed to zero if no movement

Revision 1.41  2001/08/27 13:24:37  ganter
bugfix: . or , should be set depending on  LC_NUMERIC

Revision 1.40  2001/08/27 02:57:18  ganter
Version 0.7

Revision 1.39  2001/08/27 01:03:24  ganter
Version 0.7 added experimental -f flag for direct use of GARMIN format
no gpsd must be started!

Revision 1.38  2001/08/26 23:40:10  ganter
added garble sources to included in gpsdrive

Revision 1.37  2001/08/26 19:33:45  ganter
indent

Revision 1.36  2001/08/26 19:31:53  ganter
"distance to" frame label shows target name

Revision 1.35  2001/08/26 17:46:57  ganter
changed usage, still v0.6

Revision 1.34  2001/08/26 17:38:12  ganter
Version 0.6

Revision 1.33  2001/08/26 17:24:09  ganter
added big zoom field, set refresh rate to 500ms

Revision 1.32  2001/08/26 15:49:40  ganter
indent

Revision 1.31  2001/08/26 15:47:45  ganter
added splash(), coooool!

Revision 1.30  2001/08/25 13:39:33  ganter
*** empty log message ***

Revision 1.29  2001/08/25 12:53:09  ganter
pre v0.5

Revision 1.28  2001/08/25 08:56:53  ganter
added frames for fields

Revision 1.27  2001/08/24 21:34:43  ganter
simulator mode: pointer moves to selected destination

Revision 1.26  2001/08/24 16:56:17  ganter
working on satellites

Revision 1.25  2001/08/24 09:58:57  ganter
course pointer is something ugly

Revision 1.24  2001/08/24 00:25:29  ganter
corrected angel values, 0 is on top (north) and angel is counting clockwise

Revision 1.23  2001/08/23 00:08:11  ganter
added pointer to destination

Revision 1.22  2001/08/22 09:31:37  ganter
changes to way.txt handling

Revision 1.21  2001/08/22 08:45:58  ganter
version 0.4 for public

Revision 1.20  2001/08/22 00:10:19  ganter
distance measurment adjusted

Revision 1.19  2001/08/21 23:19:00  ganter
destination selection added

Revision 1.18  2001/08/20 15:35:45  ganter
little bug in zoom out found, xoff and yoff was not updated.

Revision 1.17  2001/08/19 16:17:08  ganter
Version 0.3 ready for public

Revision 1.16  2001/08/19 15:17:31  ganter
some cleanups

Revision 1.15  2001/08/19 14:26:19  ganter
fixed offset=0 when new map loaded.

Revision 1.14  2001/08/19 13:55:01  ganter
found this little bug (x instead of y in line 469).
Am I too old for programming?

Revision 1.13  2001/08/19 11:58:44  ganter
there is only a big bug in the y direction.

Revision 1.12  2001/08/19 00:34:01  ganter
working hard on zooming...

Revision 1.11  2001/08/18 20:28:02  ganter
working on zooming

Revision 1.10  2001/08/18 15:35:03  ganter
added command line options

Revision 1.9  2001/08/18 03:58:12  ganter
map switching works (theroretical, I need a testdrive, now at 6.00am localtime)

Revision 1.8  2001/08/18 00:08:12  ganter
"big" image is working, simulated_pos() simulates moving of map.

Revision 1.7  2001/08/16 23:17:42  ganter
displaying position on map is working and tested through test drive ;-)

Revision 1.6  2001/08/16 20:03:49  ganter
should work

Revision 1.5  2001/08/15 22:39:45  ganter
new version

Revision 1.4  2001/08/15 12:06:03  ganter
data conversion for statusline works

Revision 1.3  2001/08/15 00:45:24  ganter
get GPS data and display in statusbar is working

Revision 1.2  2001/08/14 18:53:37  ganter
first version running

Revision 1.1.1.1  2001/08/14 13:52:20  ganter
gpsdrive started

***********************************************************************/

/*  Include Dateien */
#include "../config.h"
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <termios.h>
#include <unistd.h>
#include <math.h>
#include <ctype.h>
#include <sys/time.h>
#include "gtk/gtk.h"
#include "gdk-pixbuf/gdk-pixbuf.h"
#include <locale.h>
#include "gpsdrive.h"
#include "stop.h"
#include "gpsico.h"
#include <dirent.h>
#include "battery.h"
#include "track.h"
#include "icons.h"

#ifndef NOPLUGINS
#include "gmodule.h"
#endif

/*  Defines for gettext I18n */
# include <libintl.h>
# define _(String) gettext(String)
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/

/*  global variables */
gint statusid, timeoutcount;
GtkWidget *mainwindow, *status, *pixmapwidget, *gotowindow, *routewindow;
extern GtkWidget *splash_window;
gint sock, dlsock, bigp, bigpGSV, bigpGGA, bigpRME, lastpRME, lastp, lastpGSV,
  lastpGGA, debug;
FILE *nmeaout = NULL;
gchar *buffer, *big;
fd_set readmask, friendsreadmask;
struct timeval timeout, friendstimeout;
gchar targetname[40];
gdouble current_long, current_lat, old_long, old_lat, groundspeed;
gdouble zero_long, zero_lat, target_long, target_lat, dist;
gdouble long_diff = 0, lat_diff = 0;
GdkGC *kontext;
GdkColor red = { 0, 0xFF00, 0x00, 0x00 };
GdkColor black = { 0, 0x00, 0x00, 0x00 };
GdkColor white = { 0, 0xFFFF, 0xFFFF, 0xFFFF };
GdkColor blue = { 0, 0x00, 0x00, 0xff00 };
GdkColor nightcolor = { 0, 0x0000, 0xa000, 0x0000 };
//GdkColor nightcolor = { 0, 0xa000, 0x0000, 0x0000 };
GdkColor lcd = { 0, 0x8b00, 0x9500, 0x8b00 };
GdkColor lcd2 = { 0, 0x7300, 0x7d00, 0x6a00 };
GdkColor yellow = { 0, 0xff00, 0xff00, 0x00 };
GdkColor green = { 0, 0x0000, 0xb000, 0x0000 };
GdkColor green2 = { 0, 0x0000, 0xff00, 0x0000 };
GdkColor mygray = { 0, 0xd500, 0xd600, 0xd500 };
GdkColor textback = { 0, 0xa500, 0xa600, 0xa500 };
GdkColor darkgrey = { 0, SHADOWGREY, SHADOWGREY, SHADOWGREY };
GtkWidget *drawing_area, *drawing_bearing, *drawing_sats, *drawing_miniimage;
GtkWidget *drawing_battery;
GtkWidget *distlabel, *speedlabel, *altilabel, *miles, *startgpsbt;
GdkDrawable *drawable, *drawable_bearing, *drawable_sats;
gint havepos, haveposcount, blink, gblink, xoff, yoff, crosstoogle = 0;
gdouble pixelfact, posx, posy, angle_to_destination, direction, bearing;
GdkPixbuf *image, *friendsimage, *tempimage, *friendspixbuf, *miniimage =
  NULL;
typedef struct
{
  gchar filename[200];
  gdouble lat;
  gdouble longitude;
  glong scale;
}
mapsstruct;
mapsstruct *maps = NULL;

/* action=1: radar (speedtrap) */

typedef struct
{
  gchar name[40];
  gdouble lat;
  gdouble longitude;
  gdouble dist;
  gchar typ[40];
  gint wlan;
  gint action;
  gint sqlnr;
}
wpstruct;
wpstruct *wayp, *routelist;


typedef struct
{
  gchar name[40];
  gdouble lat;
  gdouble longitude;
}
friendsstruct;
friendsstruct *friends;



gchar *dlpstart;
gchar oldfilename[200];
GString *tempmapfile;
gint nrmaps = 0, dldiff;
gdouble earthr;
/*Earth radius calibrated with GARMIN III */
/*  gdouble R = 6383254.445; */


#define R earthr


/*  if we get data from gpsd in NMEA format haveNMEA is TRUE */
/*  haveGARMIN is TRUE if we get data from program garble in GARMIN we get only long and lat */
gint haveNMEA, haveGARMIN;

gint maploaded, simmode, zoom, iszoomed;
gchar homedir[500], mapdir[500];
static gchar const rcsid[] =
  "$Id: gpsdrive.c,v 1.325 2002/12/08 03:18:26 ganter Exp $";
gint thisline, thisrouteline = 0, routeitems = 0, routepointer = 0;
gint maxwp, maxfriends = 0;
GtkStyle *style = NULL;
GtkRcStyle *mainstyle;
gint satlist[40][4], satlistdisp[40][4], satbit = 0;
GtkWidget *mylist, *myroutelist, *destframe;
gchar mapfilename[200];
gdouble gbreit, glang, milesconv, olddist = 99999.0;
GTimer *timer, *disttimer;
gint gcount, milesflag, downloadwindowactive;
gint metricflag, nauticflag;
struct lconv *mylocale;
gchar *dlbuff, downloadfilename[512], localedecimal;
gint scaleprefered = 1, scalewanted = 100000;
gint dlcount, downloadactive, importactive, downloadfilelen;
glong mapscale;
GtkWidget *dltext1, *dltext2, *dltext3, *dltext4, *wptext1, *wptext2;
gdouble wplat, wplon;
GtkWidget *dltext5, *dltext6, *dltext7, *myprogress;
GtkWidget *scaler, *downloadwindow;
gchar writebuff[1000];
gchar newmaplat[100], newmaplongi[100], newmapsc[100], oldangle[100];
GdkFont *textfont, *smalltextfont, *bigtextfont, *bigtextfont2,
  *verysmalltextfont;
GdkCursor *cursor;
gchar *slist[] = { "1000", "1500", "2000", "3000", "5000", "7500",
  "10000", "15000", "20000", "30000", "50000", "75000",
  "100000", "150000", "200000", "300000", "500000", "750000",
  "1000000", "1500000", "2000000", "3000000", "5000000", "7500000",
  "10000000", "15000000", "20000000", "30000000", "50000000", "75000000"
};
gint nlist[] = { 1000, 1500, 2000, 3000, 5000, 7500,
  10000, 15000, 20000, 30000, 50000, 75000,
  100000, 150000, 200000, 300000, 500000, 750000,
  1000000, 1500000, 2000000, 3000000, 5000000, 7500000,
  10000000, 15000000, 20000000, 30000000, 50000000, 75000000
};
GtkWidget *l1, *l2, *l3, *l4, *l5, *l6, *l7, *l8, *mutebt, *sqlbt;
GtkWidget *trackbt, *wpbt;
GtkWidget *bestmapbt, *maptogglebt, *topotogglebt, *savetrackbt;
GtkWidget *importbt, *loadtrackbt, *radio1, *radio2, *scalerlbt, *scalerrbt;
GtkWidget *setupbt;
gint savetrack = 0, havespeechout, hours, minutes, speechcount = 0;
gint muteflag = 0, sqlflag = 0, trackflag = 0, wpflag = TRUE;
gint displaymap_top = TRUE, displaymap_map = TRUE;
gint posmode = 0;
gdouble posmode_x, posmode_y;
GtkObject *adj;
gchar lastradar[40], lastradar2[40], nmeamodeandport[50], importfilename[80];
gint foundradar, messageshown = FALSE;
gdouble radarbearing;
gint errortextmode = TRUE;
enum
{ english, german, spanish }
voicelang;
gchar serialdev[80];
trackstruct *track, *trackshadow;
glong tracknr;
trackcoordstruct *trackcoord;
glong trackcoordnr, tracklimit, trackcoordlimit;
gint extrawinmenu = FALSE, expedia = TRUE;
typedef struct
{
  gdouble lon;
  gdouble lat;
  gint x;
  gint y;
}
impstruct;
impstruct imports[3];
gdouble Ra[201];
gint haveproxy, proxyport;
gchar proxy[256], hostname[256], savetrackfn[256];

/*** Mod by Arms */
gint real_screen_x, real_screen_y, real_psize, real_smallmenu, int_padding;
gint SCREEN_X_2, SCREEN_Y_2;
extern gint havefriends;
extern gint friendssock;
extern gchar friendsserver[];
gchar *friendsbuffer, friendsname[200];
gchar *friendsbuffstart, *friendsbuffend;
gchar friendstxt[1000][200], friendslat[1000][20], friendslon[1000][20];
gchar friendstim[1000][20], friendsspeed[1000][20], friendsdir[1000][20];
time_t waytxtstamp = 0;
gint showallmaps = TRUE;
guint selwptimeout;
gint dontsetwp = FALSE;
gint setwpactive = FALSE;
gint onemousebutton = FALSE;
gint shadow = TRUE, createroute = FALSE, routemode = FALSE;
gdouble routenearest = 9999999999;
GtkWidget *askwindow;
gint simpos_timeout = 0;
gint setdefaultpos = TRUE;
GtkWidget *create_route_button, *create_route2_button, *select_route_button;
gint markwaypoint = FALSE;
GtkWidget *addwaypointwindow, *setupfn[30];
gint oldbat = 125, oldloading = FALSE;
gint bat, loading, havebattery;	/* Battery level and loading flag */
gint defaultserver = 0, disableapm = FALSE;
typedef struct
{
  gchar n[200];
}
namesstruct;
namesstruct *names;
gchar activewpfile[200], gpsdservername[200], setpositionname[80];
gint newsatslevel = TRUE, testgarmin = TRUE, needtosave = FALSE;
GtkWidget *serialbt, *mapdirbt, *addwaypoint1, *addwaypoint2, *frame_speed,
  *frame_sats;
gdouble altitude = 0.0, precision = (-1.0);
gint oldsatfix = 0, oldsatsanz = -1, havealtitude = FALSE;
gint wpsize = 1000, satfix = 0, usedgps = FALSE;
gchar tok[1000], dgpsserver[80], dgpsport[10];
GtkWidget *posbt, *cover;
gint needreloadmapconfig = FALSE, simfollow = TRUE;
GdkPixbuf *batimage = NULL;
GdkPixbuf *satsimage = NULL;
gint numsats = 0;
gint drawgrid = TRUE, numgrids = 4, scroll = TRUE, deleteline = 0;
gint satposmode = FALSE;
gint saytarget = FALSE, printoutsats = FALSE;
extern gchar *displaytext;
extern gint do_display_dsc, textcount;
gint minsecmode = TRUE, nightmode = FALSE, isnight = FALSE, disableisnight;
gint nighttimer;
GtkWidget *setupentry[50], *setupentrylabel[50];
void (*setupfunction[50]) ();
gchar utctime[20];
gint mod_setupcounter = 3;
gint slowcpu = FALSE, redrawtimeout;
gint haveRMCsentence = FALSE;
gdouble NMEAsecs = 0.0;
gint NMEAoldsecs = 0;
gint borderlimit;
gint zoomscale = TRUE;
gint pdamode = FALSE;
gint exposecounter = 0, drawmarkercounter = 0, exposed = FALSE;
gint useplugins = FALSE;
gdouble tripodometer, tripavspeed, triptime, tripmaxspeed, triptmp;
gint tripavspeedcount = 0;
gdouble trip_long, trip_lat;
gint lastnotebook = 0;
GtkWidget *settingsnotebook;
gint useflite = FALSE, forcenextroutepoint = FALSE;
extern gint zone;
gint ignorechecksum = FALSE;

/* Give more debug informations */
gint mydebug = FALSE;
#define MAXDBNAME 30
char dbhost[MAXDBNAME], dbuser[MAXDBNAME], dbpass[MAXDBNAME];
char dbtable[MAXDBNAME], dbname[MAXDBNAME];
char dbtypelist[100][40];
int dbtypelistcount;
char dbwherestring[5000];
double dbdistance;
gint usesql = FALSE, dbusedist = FALSE;
extern gint sqlselects[100], sqlplace, kismetsock, havekismet;
GdkPixbuf *openwlanpixbuf, *closedwlanpixbuf, *iconpixbuf[50];

/*  Prototypes */
int initkismet (void);
int readkismet (void);
int getsqltypelist (void);
int deletesqldata (int index);
int insertsqldata (double lat, double lon, char *name, char *typ);
int sqlinit (void);
void sqlend (void);
int getsqldata ();
void loadmap (char *filename);
gint zoom_cb (GtkWidget *widget, guint datum);
void splash (void);
int garblemain (int argc, char **argv);
void display_status (char *message);
gint drawmarker (GtkWidget *widget, guint *datum);
gint downloadslave_cb (GtkWidget *widget, guint datum);
gint downloadstart_cb (GtkWidget *widget, guint datum);
gint downloadsetparm (GtkWidget *widget, guint datum);
void savemapconfig ();
gint loadmapconfig ();
void loadwaypoints ();
void savewaypoints ();
extern gint speech_out_speek (char *text);
extern gint speech_out_init ();
gdouble calcdist (gdouble longi, gdouble lati);
gdouble calcdist2 (gdouble longi, gdouble lati);
gint speech_saytime_cb (GtkWidget *widget, guint datum);
gint help_cb (GtkWidget *widget, guint datum);
gint sel_target_cb (GtkWidget *widget, guint datum);
gint import1_cb (GtkWidget *widget, guint datum);
void openfriendsport (void);
gint friendsagent_cb (GtkWidget *widget, guint *datum);
gint addwaypoint_cb (GtkWidget *widget, gpointer datum);
void writeconfig ();
void readconfig ();
gint create_route_cb (GtkWidget *widget, guint datum);
void insertroutepoints ();
void setroutetarget ();
gint initgps ();
gint miles_cb (GtkWidget *widget, guint datum);
gint shadow_cb (GtkWidget *widget, guint datum);
gint defaultserver_cb (GtkWidget *widget, guint datum);
gint expose_sats_cb (GtkWidget *widget, guint *datum);
gint testgarmin_cb (GtkWidget *widget, guint datum);
gint serialdev_cb (GtkWidget *widget, guint datum);
gint usedgps_cb (GtkWidget *widget, guint datum);
gint mapdir_cb (GtkWidget *widget, guint datum);
gint simfollow_cb (GtkWidget *widget, guint datum);
extern void saytargettext (gchar *filename, gchar *target);
extern void display_dsc (void);
void decimaltomin (gchar *text, gint islat);
gint minsec_cb (GtkWidget *widget, guint datum);
void checkinput (gchar *text);
void mintodecimal (gchar *text);
gint night_cb (GtkWidget *widget, guint datum);
extern void mainsetup (void);
extern void testifnight (void);
extern void infos (void);
extern gint removesetutc (GtkWidget *widget, guint datum);
extern gint nav_doit (GtkWidget *widget, guint *datum);
gint expose_cb (GtkWidget *widget, guint *datum);
gint expose_compass (GtkWidget *widget, guint *datum);
gint dotripmeter (GtkWidget *widget, guint datum);
void trip (void);
gint expose_mini_cb (GtkWidget *widget, guint *datum);
gint speech_out_speek_raw (char *text);
void sqlsetup (void);



/*  quit the program */
gint
quit_program (GtkWidget *widget, gpointer datum)
{
  gtk_main_quit ();
  g_mem_profile ();
  writeconfig ();
  if (savetrack)
    savetrackfile (FALSE);
  sqlend ();
  g_print (_("\n\nThank you for using GpsDrive!\n\n"));
  return (TRUE);
}

gint
error_popup (gpointer datum)
{
  GtkWidget *popup;
  GtkWidget *knopf2;
  GtkWidget *knopf3;
  GdkPixmap *fritzpixmap;
  GdkBitmap *mask;
  GtkWidget *pixmapwidget;

  if (errortextmode)
    {
      g_print ("\nError: %s\n", (char *) datum);
      return (FALSE);
    }
  popup = gtk_dialog_new ();
  fritzpixmap =
    gdk_pixmap_create_from_xpm_d (mainwindow->window, &mask, NULL, stop);

  pixmapwidget = gtk_pixmap_new (fritzpixmap, mask);


  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (popup)->vbox), pixmapwidget,
		      FALSE, FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (popup), 5);

  gtk_window_set_title (GTK_WINDOW (popup), _("  Message  "));
  knopf2 = gtk_button_new_with_label (_("Ok"));
  GTK_WIDGET_SET_FLAGS (knopf2, GTK_HAS_FOCUS);

  gtk_signal_connect_object (GTK_OBJECT (knopf2), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (popup));


  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (popup)->action_area), knopf2, TRUE,
		      TRUE, 20);
  knopf3 = gtk_label_new (datum);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (popup)->vbox), knopf3, FALSE,
		      FALSE, 10);


  gtk_window_set_position (GTK_WINDOW (popup), GTK_WIN_POS_CENTER);
  gtk_widget_show (pixmapwidget);
  gtk_widget_show (knopf2);
  gtk_widget_show (knopf3);
  gtk_widget_show (popup);

  return (FALSE);

}


void
startgpsd (guint datum)
{
  gchar s[200];

  if (usedgps)
    sprintf (s, "gpsd -p %s -c -d %s -r %s", serialdev, dgpsserver, dgpsport);
  else
    sprintf (s, "gpsd -p %s", serialdev);
  system (s);
  gtk_widget_set_sensitive (startgpsbt, FALSE);
  strcpy (gpsdservername, "127.0.0.1");
  gtk_timeout_add (1000, (GtkFunction) initgps, 0);
  expose_sats_cb (NULL, 0);
}

#ifdef NOGARMIN
int
garblemain (int argc, char **argv)
{
  g_print (_("\nno garmin support compiled in\n"));
  return -2;
}
#endif

gint
askusernmea ()
{
  GtkWidget *knopf2;
  GtkWidget *knopf3;
  GtkWidget *knopf4;
  GtkWidget *popup;
  GdkPixmap *ip_pixmap;
  GdkBitmap *ip_bitmap;
  GtkWidget *pixm;
  GdkPixbuf *pix;

  askwindow = popup = gtk_dialog_new ();
  gtk_window_set_modal (GTK_WINDOW (popup), TRUE);
  pix = gdk_pixbuf_new_from_xpm_data ((const char **) stop);
  gdk_pixbuf_render_pixmap_and_mask (pix, &ip_pixmap, &ip_bitmap, 128);
  pixm = gtk_pixmap_new (ip_pixmap, ip_bitmap);
  gdk_pixbuf_unref (pix);
  gdk_pixmap_unref (ip_pixmap);
  if (ip_bitmap)
    {
      gdk_bitmap_unref (ip_bitmap);
    }


  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (popup)->vbox), pixm,
		      FALSE, FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (popup), 5);

  gtk_window_set_title (GTK_WINDOW (popup), _("  Message  "));
  knopf2 = gtk_button_new_with_label (_("Yes, please start gpsd"));

  gtk_signal_connect (GTK_OBJECT (knopf2), "clicked",
		      GTK_SIGNAL_FUNC (startgpsd), 0);
  knopf4 = gtk_button_new_with_label (_("No, start simulation"));


  gtk_signal_connect_object (GTK_OBJECT (knopf4), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (popup));
  GTK_WIDGET_SET_FLAGS (knopf2, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (knopf4, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (popup), knopf4);
  GTK_WIDGET_SET_FLAGS (knopf4, GTK_HAS_FOCUS);


  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (popup)->action_area), knopf2, TRUE,
		      TRUE, 20);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (popup)->action_area), knopf4, TRUE,
		      TRUE, 20);
  knopf3 =
    gtk_label_new (_
		   ("Neither gpsd nor GARMIN device detected!\n"
		    "Should I start gpsd (NMEA mode) for you?"));

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (popup)->vbox), knopf3, FALSE,
		      FALSE, 10);


  gtk_window_set_position (GTK_WINDOW (popup), GTK_WIN_POS_CENTER);
  gtk_widget_show_all (popup);

  return (FALSE);

}


gdouble
calcR (gdouble lat)
{
  gdouble a = 6378.137, r, sc, x, y, z;
  gdouble e2 = 0.081082 * 0.081082;
/*
the radius of curvature of an ellipsoidal Earth in the plane of the 
meridian is given by 

 R' = a * (1 - e^2) / (1 - e^2 * (sin(lat))^2)^(3/2) 

 where a is the equatorial radius, 
b is the polar radius, and 
e is the eccentricity of the ellipsoid = sqrt(1 - b^2/a^2) 

a = 6378 km (3963 mi) Equatorial radius (surface to center distance) 
b = 6356.752 km (3950 mi) Polar radius (surface to center distance) 
e = 0.081082 Eccentricity 
*/

  lat = lat * M_PI / 180.0;
  sc = sin (lat);
  x = a * (1.0 - e2);
  z = 1.0 - e2 * sc * sc;
  y = pow (z, 1.5);
  r = x / y;

  r = r * 1000.0;
/*      g_print("\nR=%f",r); */
  return r;
}

void
calcxy (gdouble *posx, gdouble *posy, gdouble lon, gdouble lat, gint zoom)
{
  gdouble dif;

  *posx =
    (Ra[(int) (100 + lat)] * M_PI / 180.0) * cos (M_PI * lat / 180.0) * (lon -
									 zero_long);
  *posx = SCREEN_X_2 + *posx * zoom / pixelfact;
  *posx = *posx - xoff;

  *posy = (Ra[(int) (100 + lat)] * M_PI / 180.0) * (lat - zero_lat);
  dif =
    Ra[(int) (100 + lat)] * (1 - (cos ((M_PI * (lon - zero_long)) / 180.0)));
  *posy = *posy + dif / 1.85;
  *posy = SCREEN_Y_2 - *posy * zoom / pixelfact;
  *posy = *posy - yoff;
}

void
calcxymini (gdouble *posx, gdouble *posy, gdouble lon, gdouble lat, gint zoom)
{
  gdouble dif;

  *posx =
    (Ra[(int) (100 + lat)] * M_PI / 180.0) * cos (M_PI * lat / 180.0) * (lon -
									 zero_long);
  *posx = 64 + *posx * zoom / (10 * pixelfact);
  *posx = *posx;

  *posy = (Ra[(int) (100 + lat)] * M_PI / 180.0) * (lat - zero_lat);
  dif =
    Ra[(int) (100 + lat)] * (1 - (cos ((M_PI * (lon - zero_long)) / 180.0)));
  *posy = *posy + dif / 1.85;
  *posy = 51 - *posy * zoom / (10 * pixelfact);
  *posy = *posy;
}

gint
checksum (gchar *text)
{
  gchar t[120], t2[10];
  gint i = 1, checksum = 0, j, orig;

  if (ignorechecksum)
    return TRUE;

  strncpy (t, text, 100);
  t[100] = 0;
  j = strlen (t) - 3;
  while (('\0' != t[i]) && (i < j))
    checksum = checksum ^ t[i++];
  strcpy (t2, (t + j + 1));
  sscanf (t2, "%X", &orig);
  if (debug)
    g_print ("\n%s\norigchecksum: %X,my:%X", t, orig, checksum);

  if (orig == checksum)
    {
      strcpy (tok, t);
      return TRUE;
    }
  else
    {
      g_print
	("\n*** NMEA checksum error!\nNMEA: %s\n is: %X, should be: %X\n", t,
	 orig, checksum);
      return FALSE;
    }
}

void
convertRMC (char *f)
{
  gchar field[50][100], b[100];
  gint i, j = 0, start = 0;
  gint longdegree, latdegree;
  gchar langri, breitri;

  memset (b, 0, 100);

/*  if simulation mode we display status and return */
  if (simmode && maploaded && !posmode)
    {
      display_status (_("Simulation mode"));
      return;
    }

/*  get fields delimited with ',' */
  for (i = 0; i < strlen (f); i++)
    {
      if (f[i] == ',')
	{
	  strcpy (field[j], (f + start));
	  field[j][i - start] = 0;
	  start = i + 1;
	  j++;
	}
    }
  if ((j != 11) && (j != 12))
    {
      g_print ("\nGPRMC: wrong number of fields (%d)", j);
      return;
    }

  haveRMCsentence = TRUE;


  if (debug)
    {
      g_print ("\nRMC Fields:\n");
      for (i = 0; i < j; i++)
	g_print ("\n%d:%s", i, field[i]);
    }
  sprintf (b, "%c%c:%c%c.%c%c ", field[1][0], field[1][1], field[1][2],
	   field[1][3], field[1][4], field[1][5]);
  strcpy (f, b);
  strcpy (utctime, b);
  strcat (f, _("UTC "));
  if (field[2][0] != 'A')
    {
      havepos = FALSE;
      haveposcount = 0;
      return;
    }
  else
    {
      havepos = TRUE;
      haveposcount++;
      if (haveposcount == 3)
	rebuildtracklist ();
    }
/*  Latitude North / South */
  b[0] = field[3][0];
  b[1] = field[3][1];
  b[2] = 0;
  latdegree = atoi (b);


  b[0] = field[3][2];
  b[1] = field[3][3];
  b[2] = localedecimal;
  b[3] = field[3][5];
  b[4] = field[3][6];
  b[5] = field[3][7];
  b[6] = 0;
  if (!posmode)
    {
      current_lat = latdegree + atof (b) / 60.0;
      if (field[4][0] == 'S')
	current_lat = current_lat * -1;

      breitri = field[4][0];
      sprintf (b, " %8.5f%c", current_lat, breitri);
    }
  strcat (f, b);

/*  Longitude East / West */
  b[0] = field[5][0];
  b[1] = field[5][1];
  b[2] = field[5][2];
  b[3] = 0;
  longdegree = atoi (b);

  b[0] = field[5][3];
  b[1] = field[5][4];
  b[2] = localedecimal;
  b[3] = field[5][6];
  b[4] = field[5][7];
  b[5] = field[5][8];
  b[6] = 0;
  if (!posmode)
    {
      current_long = longdegree + atof (b) / 60.0;
      if (field[6][0] == 'W')
	current_long = current_long * -1;

      langri = field[6][0];
      sprintf (b, " %8.5f%c", current_long, langri);
    }
  strcat (f, b);

/*  speed */
  b[0] = field[7][0];
  b[1] = field[7][1];
  b[2] = field[7][2];
  b[3] = localedecimal;
  b[4] = field[7][4];
  b[5] = 0;
  groundspeed = atof (b) * 1.852 * milesconv;
  sprintf (b, " %s: %s", _("Map"), mapfilename);
  strcat (f, b);
/*    g_print("Field %s\n",field[8]); */
  b[0] = field[8][0];
  b[1] = field[8][1];
  b[2] = field[8][2];
  b[3] = localedecimal;
  b[4] = field[8][4];
  b[5] = 0;
/*  direction is the course we are driving */
  direction = atof (b);
  direction = direction * M_PI / 180;
}

/*  show satellites signal level */
gint
convertGSV (char *f)
{
  gchar field[50][100], b[500];
  gint i, l, i2, j = 0, start = 0, n, db, anz, az, el;

  memset (b, 0, 100);
  l = strlen (f);
  for (i = 0; i < l; i++)
    {
      if ((f[i] == ',') || (f[i] == '*'))
	{
	  strcpy (field[j], (f + start));
	  field[j][i - start] = 0;
	  start = i + 1;
	  j++;
	}
    }
  if (debug)
    {
      g_print ("\nGSV Fields:\n");
      for (i = 0; i < j; i++)
	g_print ("%d:%s$", i, field[i]);
    }
  if (j > 40)
    {
      g_print ("\nGPGSV: wrong number of fields (%d)", j);
      return FALSE;
    }

  if (field[2][0] == '1')
    satbit = satbit | 1;
  if (field[2][0] == '2')
    satbit = satbit | 2;
  if (field[2][0] == '3')
    satbit = satbit | 4;

  anz = atoi (field[3]);
  b[0] = field[1][0];
  b[1] = 0;
  i2 = atof (b);
  if (mydebug)
    g_print ("\nbits should be:%d  is: %d", i2, satbit);
  sprintf (b, "\nSatellites: %d ", anz);
  if (anz != oldsatsanz)
    newsatslevel = TRUE;
  oldsatsanz = anz;
  strcpy (f, b);
  for (i = 4; i < j; i += 4)
    {
      n = atoi (field[i]);
      db = atoi (field[i + 3]);
      el = atoi (field[i + 1]);
      az = atoi (field[i + 2]);

/*        sprintf (b, "% 2d:% 2ddb", n, db); */
/*        strcat (f, b); */
      satlist[n][0] = n;
      satlist[n][1] = db;
      satlist[n][2] = el;
      satlist[n][3] = az;
    }

  if (((pow (2, i2)) - 1) == satbit)
    {

      for (i = 0; i < 40; i++)
	if (satlist[i][0] != 0)
	  {
	    sprintf (b, "% 2d: % 2ddb   ", satlist[i][0], satlist[i][1]);
	    strcat (f, b);
	  }
      strcat (f, "***\n");
      if (mydebug)
	g_print (f);
      satbit = 0;
      memcpy (satlistdisp, satlist, sizeof (satlist));
      memset (satlist, 0, sizeof (satlist));
      newsatslevel = TRUE;
      return TRUE;
    }
  return FALSE;
}


/*  show altitude */
void
convertGGA (char *f)
{
  gchar field[50][100], b[500];
  gint i, l, j = 0, start = 0;
  gint longdegree, latdegree;
  gchar langri, breitri;

  memset (b, 0, 100);
  l = strlen (f);
  for (i = 0; i < l; i++)
    {
      if ((f[i] == ',') || (f[i] == '*'))
	{
	  strcpy (field[j], (f + start));
	  field[j][i - start] = 0;
	  start = i + 1;
	  j++;
	}
    }
  if (debug)
    {
      g_print ("\nGGA Fields:\n");
      for (i = 0; i < j; i++)
	g_print ("%d:%s$", i, field[i]);
    }

  if (j != 15)
    {
      g_print ("\nGPGGA: wrong number of fields (%d)", j);
      return;
    }

/*   the receiver sends no GPRMC, so we get the data from here */
  if (!haveRMCsentence)
    {
      gint mysecs;

      if (debug)
	g_print ("\nno RMC data, using GGA data");
      sprintf (b, "%c%c", field[1][4], field[1][5]);
      sscanf (b, "%d", &mysecs);
      if (mysecs != NMEAoldsecs)
	{
	  NMEAsecs = mysecs - NMEAoldsecs;
	  if (NMEAsecs < 0)
	    NMEAsecs += 60;
	  NMEAoldsecs = mysecs;
	}
/*       g_print ("\nnmeasecs: %.2f mysecs: %d, nmeaoldsecs: %d", NMEAsecs, */
/* 	       mysecs, NMEAoldsecs); */
      sprintf (b, "%c%c:%c%c.%c%c ", field[1][0], field[1][1], field[1][2],
	       field[1][3], field[1][4], field[1][5]);
      strcpy (f, b);
      strcpy (utctime, b);
      strcat (f, _("UTC "));

      if (field[6][0] == '0')
	{
	  havepos = FALSE;
	  haveposcount = 0;
	  return;
	}
      else
	{
	  havepos = TRUE;
	  haveposcount++;
	  if (haveposcount == 3)
	    rebuildtracklist ();
	}

/*  Latitude North / South */
      b[0] = field[2][0];
      b[1] = field[2][1];
      b[2] = 0;
      latdegree = atoi (b);


      b[0] = field[2][2];
      b[1] = field[2][3];
      b[2] = localedecimal;
      b[3] = field[2][5];
      b[4] = field[2][6];
      b[5] = field[2][7];
      b[6] = 0;
      if (!posmode)
	{
	  current_lat = latdegree + atof (b) / 60.0;
	  if (field[3][0] == 'S')
	    current_lat = current_lat * -1;

	  breitri = field[3][0];
	  sprintf (b, " %8.5f%c", current_lat, breitri);
	}
      strcat (f, b);

/*  Longitude East / West */
      b[0] = field[4][0];
      b[1] = field[4][1];
      b[2] = field[4][2];
      b[3] = 0;
      longdegree = atoi (b);

      b[0] = field[4][3];
      b[1] = field[4][4];
      b[2] = localedecimal;
      b[3] = field[4][6];
      b[4] = field[4][7];
      b[5] = field[4][8];
      b[6] = 0;

      if (!posmode)
	{
	  current_long = longdegree + atof (b) / 60.0;
	  if (field[5][0] == 'W')
	    current_long = current_long * -1;

	  langri = field[5][0];
	  sprintf (b, " %8.5f%c", current_long, langri);
	}
      strcat (f, b);

    }
  if (debug)
    g_print ("\nGGA pos: %f %f\n", current_lat, current_long);

  if (havepos)
    {
      havealtitude = TRUE;
      altitude = g_strtod (field[9], 0);
      satfix = g_strtod (field[6], 0);
      numsats = g_strtod (field[7], 0);
      if (debug)
	{
	  g_print ("\nAltitude: %.1f, Fix: %d", altitude, satfix);
	}
    }
}


/*  show estimated position error $PGRME */
void
convertRME (char *f)
{
  gchar field[50][100], b[500];
  gint i, l, j = 0, start = 0;

  memset (b, 0, 100);
  l = strlen (f);
  for (i = 0; i < l; i++)
    {
      if ((f[i] == ',') || (f[i] == '*'))
	{
	  strcpy (field[j], (f + start));
	  field[j][i - start] = 0;
	  start = i + 1;
	  j++;
	}
    }
  if (debug)
    {
      g_print ("\nRME Fields:\n");
      for (i = 0; i < j; i++)
	g_print ("%d:%s$", i, field[i]);
    }
  if (havepos)
    {

      precision = g_strtod (field[1], 0);
      if (debug)
	{
	  g_print ("\nRME precision: %.1f", precision);
	}
    }
}



void
display_status (char *message)
{
  gchar tok[200];

  if (downloadactive == TRUE)
    return;
  if (importactive == TRUE)
    return;

  sprintf (tok, "%s", message);
  gtk_statusbar_pop (GTK_STATUSBAR (status), statusid);
  gtk_statusbar_push (GTK_STATUSBAR (status), statusid, tok);
}

gint
speech_out_cb (GtkWidget *widget, guint *datum)
{
  gchar buf[500], s2[100];
  gint angle;

  if (strcmp (oldangle, "XXX"))
    {
      if (muteflag)
	return TRUE;
      if (foundradar)
	return TRUE;
      if (importactive)
	return TRUE;
    }

  speechcount++;
  angle = bearing * 180.0 / M_PI;

  if (!simmode && !havepos)
    {
      switch (voicelang)
	{
	case english:
	  sprintf (buf, "Not enough satellites in view");
	  break;
	case spanish:
	  sprintf (buf, "El GPS Fix no est disponible");
	  break;
	case german:
	  sprintf (buf, "Zuwenig Satelliten in Sicht");
	}
      if (speechcount == 1)
	speech_out_speek (buf);
      return TRUE;
    }


  switch (voicelang)
    {
    case english:
      if ((angle >= 338) || (angle < 22))
	strcpy (s2, "in front of you");
      if ((angle >= 22) && (angle < 68))
	strcpy (s2, "ahead of you to the right");
      if ((angle >= 68) && (angle < 112))
	strcpy (s2, "to your right");
      if ((angle >= 112) && (angle < 158))
	strcpy (s2, "behind you to the right");
      if ((angle >= 158) && (angle < 202))
	strcpy (s2, "behind you");
      if ((angle >= 202) && (angle < 248))
	strcpy (s2, "behind you to the left");
      if ((angle >= 248) && (angle < 292))
	strcpy (s2, "to your left");
      if ((angle >= 292) && (angle < 338))
	strcpy (s2, "ahead of you to the left");
      break;
    case spanish:
      if ((angle >= 338) || (angle < 22))
	strcpy (s2, "delante de usted");
      if ((angle >= 22) && (angle < 68))
	strcpy (s2, "delante de usted a la derecha");
      if ((angle >= 68) && (angle < 112))
	strcpy (s2, "a la derecha");
      if ((angle >= 112) && (angle < 158))
	strcpy (s2, "de tras de usted a la derecha");
      if ((angle >= 158) && (angle < 202))
	strcpy (s2, "de tras de usted");
      if ((angle >= 202) && (angle < 248))
	strcpy (s2, "de tras de usted a la izquierda");
      if ((angle >= 248) && (angle < 292))
	strcpy (s2, "a la izquierda");
      if ((angle >= 292) && (angle < 338))
	strcpy (s2, "delante de usted a la izquierda");
      break;
    case german:
      if ((angle >= 338) || (angle < 22))
	strcpy (s2, "vor ihnen");

      if ((angle >= 22) && (angle < 68))
	strcpy (s2, "rechts vor ihnen");
      if ((angle >= 68) && (angle < 112))
	strcpy (s2, "rechts");
      if ((angle >= 112) && (angle < 158))
	strcpy (s2, "rechts hinter ihnen");
      if ((angle >= 158) && (angle < 202))
	strcpy (s2, "hinter ihnen");
      if ((angle >= 202) && (angle < 248))
	strcpy (s2, "links hinter ihnen");
      if ((angle >= 248) && (angle < 292))
	strcpy (s2, "links");
      if ((angle >= 292) && (angle < 338))
	strcpy (s2, "links vor ihnen");
    }
  if ((speechcount == 1) || (strcmp (s2, oldangle)))
    {
      switch (voicelang)
	{
	case english:
	  sprintf (buf, "Destination is %s", s2);
	  break;
	case spanish:
	  sprintf (buf, "Su destinacin est %s", s2);
	  break;
	case german:
	  sprintf (buf, "Das Ziel ist %s", s2);
	}
      speech_out_speek (buf);
      strcpy (oldangle, s2);
    }
  if (speechcount == 3 && groundspeed >= 20)
    {
      switch (voicelang)
	{
	case english:
	  if (milesflag)
	    sprintf (buf,
		     "The current speed is %d miles per hour",
		     (int) (groundspeed));
	  else
	    sprintf (buf,
		     "The current speed is %d kilometers per hour",
		     (int) groundspeed);
	  break;
	case spanish:
	  if (milesflag)
	    sprintf (buf,
		     "La velocidad actual es %d milla por hora",
		     (int) (groundspeed));
	  else
	    sprintf (buf,
		     "La velocidad actual es %d kilometros por hora",
		     (int) groundspeed);
	  break;
	case german:
	  if (milesflag)
	    sprintf (buf,
		     "Die momentane Geschwindigkeit ist %d Meilen pro Stunde",
		     (int) (groundspeed));
	  else
	    sprintf (buf,
		     "Die momentane Geschwindigkeit ist %d kmh",
		     (int) groundspeed);
	}
      speech_out_speek (buf);
    }

  if (speechcount > 10)
    speechcount = 0;


  if ((speechcount == 2) || ((dist < 1.2) && (speechcount == 7)))
    {
      if (milesflag)
	{
	  switch (voicelang)
	    {
	    case english:
	      if (dist <= 1.2)
		sprintf (s2, "%.0f yards", dist * 1760.0);
	      else
		sprintf (s2, "%.0f miles", dist);
	      break;
	    case spanish:
	      if (dist <= 1.2)
		sprintf (s2, "%.0f yards", dist * 1760.0);
	      else
		sprintf (s2, "%.0f millas", dist);
	      break;
	    case german:
	      if (dist <= 1.2)
		sprintf (s2, "%.0f yard", dist * 1760.0);
	      else
		sprintf (s2, "%.0f Meilen", dist);
	    }
	}
      else
	{
	  switch (voicelang)
	    {
	    case english:
	      if (dist <= 1.2)
		sprintf (s2, "%.0f meters", dist * 1000.0);
	      else
		sprintf (s2, "%.0f kilometers", dist);
	      break;
	    case spanish:
	      if (dist <= 1.2)
		sprintf (s2, "%.0f metros", dist * 1000.0);
	      else
		sprintf (s2, "%.0f kilometros", dist);
	      break;
	    case german:
	      if (dist <= 1.2)
		sprintf (s2, "%.0f meter", dist * 1000.0);
	      else if ((int) dist == 1)
		sprintf (s2, "ein kilometer");
	      else
		sprintf (s2, "%d kilometer", (int) dist);
	    }
	}

      switch (voicelang)
	{
	case english:
	  sprintf (buf, "Distance to %s is %s", targetname, s2);
	  break;
	case spanish:
	  sprintf (buf, "La distancia a la %s es %s", targetname, s2);
	  break;
	case german:
	  sprintf (buf, "Die Entfernung bis %s ist %s", targetname, s2);
	}
      speech_out_speek (buf);
    }

  return TRUE;
}

gint
get_position_data_cb (GtkWidget *widget, guint *datum)
{
  gint e, j, i, found, foundGSV, foundGGA, foundRME;
  gdouble secs, tx, ty, lastdirection;
  typedef struct
  {
    gchar *a1;
    gchar *a2;
    gchar *a3;
  }
  argument;
  argument *argumente;

  if (importactive)
    return TRUE;

  argumente = NULL;
  if ((haveGARMIN) || (!haveRMCsentence))
    {
      if (haveGARMIN)
	{
	  argumente = g_new (argument, 1);
	  argumente->a1 = "-p";
	  argumente->a2 = "-p";
	  argumente->a3 = 0;

	  e = garblemain (1, (char **) argumente);
	  if (e == -2)
	    {
	      havepos = FALSE;
	      display_status (_("Not enough satellites in view!"));
	      haveposcount = 0;
	      return TRUE;
	    }
	  else
	    {
	      havepos = TRUE;
	      haveposcount++;
	    }
	  if (!posmode)
	    {
	      current_long = glang;
	      current_lat = gbreit;
	    }

	}
      if (haveGARMIN)
	secs = g_timer_elapsed (timer, 0);
      else
	secs = NMEAsecs;

      if (secs >= 1.0)
	{
	  tx =
	    (2 * R * M_PI / 360) * cos (M_PI * current_lat / 180.0) *
	    (current_long - old_long);
	  ty = (2 * R * M_PI / 360) * (current_lat - old_lat);
#define MINMOVE 4.0
	  if (((fabs (tx)) > MINMOVE) || (((fabs (ty)) > MINMOVE)))
	    {
	      if (haveGARMIN)
		{
		  g_timer_stop (timer);
		  g_timer_start (timer);
		}

	      lastdirection = direction;
	      if (ty == 0)
		direction = 0.0;
	      else
		direction = atan (tx / ty);
	      if (!finite (direction))
		direction = lastdirection;
	      if (ty < 0)
		direction = M_PI + direction;
	      if (direction >= (2 * M_PI))
		direction -= 2 * M_PI;
	      if (direction < 0)
		direction += 2 * M_PI;

	      groundspeed = milesconv * sqrt (tx * tx + ty * ty) * 3.6 / secs;
	      old_lat = current_lat;
	      old_long = current_long;
	    }
	  else if (secs > 4.0)
	    groundspeed = 0.0;

	  if (groundspeed > 2000)
	    groundspeed = 0;
	  if (groundspeed < 3.6)
	    groundspeed = 0;

	  if (mydebug)
	    g_print ("\nTime: %f", secs);
	}
/*  display status line */
      if (posmode)
	display_status (_("Press middle mouse button for navigation"));
      else
	{
	  if (haveGARMIN)
	    display_status (_("GARMIN Mode"));
	}

      if (haveGARMIN)
	{
	  g_free (argumente);
/*  return if in GARMIN mode */
	  return TRUE;
	}
    }

/*    only if we have neither NMEA nor GARMIN, means no measured position */
  if (!haveNMEA)
    {
/*  display status line */
      if (!simmode)
	display_status (_("No GPS used"));
      else if (maploaded && !posmode)
	display_status (_("Simulation mode"));
      else if (posmode)
	display_status (_("Press middle mouse button for sim mode"));

      return TRUE;
    }

/*  this is the NMEA reading part. data comes from port 2222 served by gpsd */
  FD_ZERO (&readmask);
  FD_SET (sock, &readmask);
  timeout.tv_sec = 0;
  timeout.tv_usec = 100000;
  if (select (FD_SETSIZE, &readmask, NULL, NULL, &timeout) < 0)
    {
      perror ("select() call");
    }
  if (FD_ISSET (sock, &readmask))
    {
      if ((e = read (sock, buffer, 2000)) < 0)
	perror ("read from gpsd connection");
      buffer[e] = 0;
      if ((bigp + e) < MAXBIG)
	{
	  if (mydebug)
	    g_print ("\n!!bigp:%d, e: %d!!", bigp, e);
	  strcat (big, buffer);
	  if (mydebug)
	    g_print (", strlen big:%d", strlen (big));
	  bigp += e;
	  bigpRME = bigpGSV = bigpGGA = bigp;

	  for (i = bigp; i > lastp; i--)
	    {
	      if (big[i] == '$')
		{
/*  collect string for position data $GPRMC */
		  if ((big[i + 1] == 'G') && (big[i + 2] == 'P')
		      && (big[i + 3] == 'R') && (big[i + 4] == 'M')
		      && (big[i + 5] == 'C'))
		    {
		      found = 0;
		      if (debug)
			g_print ("\n found #RMC#");
		      for (j = i; j <= bigp; j++)
			if (big[j] == 13)
			  {
			    found = j;
			    break;
			  }
		      if (found != 0)
			{
			  strncpy (tok, (big + i), found - i);
			  tok[found - i] = 0;
			  lastp = found;
			  timeoutcount = 0;
/*  we have the $GPRMC string completed, now parse it */
			  if (checksum (tok) == TRUE)
			    convertRMC (tok);
/*  display the position and map in the statusline */
			  if (havepos)
			    {
			      if (posmode)
				display_status (_
						("Press middle mouse button for navigation"));
			      else
				display_status (nmeamodeandport);
			    }
			  else
			    display_status (_
					    ("Not enough satellites in view!"));
			  if (mydebug)
			    g_print ("\n********\n%s\n*********\n", tok);
			}
		    }

		}
	    }

/*  collect string for satellite data $GPGSV */

	  for (i = bigpGSV; i > lastpGSV; i--)
	    {
	      if (big[i] == '$')
		{

		  if ((big[i + 1] == 'G') && (big[i + 2] == 'P')
		      && (big[i + 3] == 'G') && (big[i + 4] == 'S')
		      && (big[i + 5] == 'V'))
		    {
		      foundGSV = 0;
		      if (debug)
			g_print ("\n found #GSV#, bigpGSV: %d", bigpGSV);
		      for (j = i; j <= bigpGSV; j++)
			if (big[j] == 13)
			  {
			    foundGSV = j;
			    break;
			  }
		      if (foundGSV != 0)
			{
			  gint lenstr;
			  lenstr = foundGSV - i;
			  if ((lenstr) > 200)
			    {
			      g_print
				("\nError in line %d, foundGSV=%d,i=%d, diff=%d\n",
				 __LINE__, foundGSV, i, lenstr);
			      lenstr = 200;
			    }
			  if (i > foundGSV)
			    {
			      g_print
				("\nError in line %d, foundGSV=%d,i=%d, diff=%d\n",
				 __LINE__, foundGSV, i, lenstr);
			      lenstr = 0;
			    }
			  if (lenstr < 0)
			    {
			      g_print
				("\nError in line %d, foundGSV=%d,i=%d, lenstr=%d\n",
				 __LINE__, foundGSV, i, lenstr);
			      lenstr = 0;
			    }
			  if (lenstr != 0)
			    {
			      strncpy (tok, (big + i), lenstr);
			      tok[lenstr] = 0;

			      if (checksum (tok) == TRUE)
				{
				  if ((convertGSV (tok)) == TRUE)
				    lastpGSV = foundGSV;
				}
			      if (mydebug)
				g_print ("\n********\n%s\n*********\n", tok);
			    }
			}
		    }
		}
	    }


/*  collect string for altitude from  $GPGGA if available*/

	  for (i = bigpGGA; i > lastpGGA; i--)
	    {
	      if (big[i] == '$')
		{

		  if ((big[i + 1] == 'G') && (big[i + 2] == 'P')
		      && (big[i + 3] == 'G') && (big[i + 4] == 'G')
		      && (big[i + 5] == 'A'))
		    {
		      foundGGA = 0;
		      if (debug)
			g_print ("\n found #GGA#");
		      timeoutcount = 0;

		      for (j = i; j <= bigpGGA; j++)
			if (big[j] == 13)
			  {
			    foundGGA = j;
			    break;
			  }
		      if (foundGGA != 0)
			{
			  gint lenstr;
			  lenstr = foundGGA - i;
			  if ((lenstr) > 200)
			    {
			      g_print
				("\nError in line %d, foundGGA=%d,i=%d, diff=%d\n",
				 __LINE__, foundGGA, i, lenstr);
			      lenstr = 200;
			    }
			  if (i > foundGGA)
			    {
			      g_print
				("\nError in line %d, foundGGA=%d,i=%d, diff=%d\n",
				 __LINE__, foundGGA, i, lenstr);
			      lenstr = 0;
			    }
			  if (lenstr != 0)
			    {
			      strncpy (tok, (big + i), lenstr);
			      tok[lenstr] = 0;
			      lastpGGA = foundGGA;

			      if (checksum (tok) == TRUE)
				convertGGA (tok);
			      if (mydebug)
				g_print ("\n********\n%s\n*********\n", tok);
			      if (havepos)
				{
				  if (posmode)
				    display_status (_
						    ("Press middle mouse button for navigation"));
				  else
				    display_status (nmeamodeandport);
				}
			      else
				display_status (_
						("Not enough satellites in view!"));
			      if (mydebug)
				g_print ("\n********\n%s\n*********\n", tok);

			    }
			}
		    }
		}
	    }

/*  collect string for precision from  $PGRME if available*/

	  for (i = bigpRME; i > lastpRME; i--)
	    {
	      if (big[i] == '$')
		{

		  if ((big[i + 1] == 'P') && (big[i + 2] == 'G')
		      && (big[i + 3] == 'R') && (big[i + 4] == 'M')
		      && (big[i + 5] == 'E'))
		    {
		      foundRME = 0;
		      if (debug)
			g_print ("\n found #RME#");
		      for (j = i; j <= bigpRME; j++)
			if (big[j] == 13)
			  {
			    foundRME = j;
			    break;
			  }
		      if (foundRME != 0)
			{
			  gint lenstr;
			  lenstr = foundRME - i;
			  if ((lenstr) > 200)
			    {
			      g_print
				("\nError in line %d, foundRME=%d,i=%d, diff=%d\n",
				 __LINE__, foundRME, i, lenstr);
			      lenstr = 200;
			    }
			  if (i > foundRME)
			    {
			      g_print
				("\nError in line %d, foundRME=%d,i=%d, diff=%d\n",
				 __LINE__, foundRME, i, lenstr);
			      lenstr = 0;
			    }
			  if (lenstr != 0)
			    {
			      strncpy (tok, (big + i), lenstr);
			      tok[lenstr] = 0;
			      lastpRME = foundRME;

			      if (checksum (tok) == TRUE)
				convertRME (tok);
			      if (mydebug)
				g_print ("\n********\n%s\n*********\n", tok);
			    }
			}
		    }
		}
	    }



	  if (mydebug)
	    g_print ("\nsize:%d lastp: %d \n%s", e, lastp, buffer);

	}
      else
	{
	  lastp = lastpGGA = lastpGSV = lastpRME = 0;
	  bigp = e;
	  strcpy (big, buffer);
	}

    }
  else
    {
      timeoutcount++;
      if (debug)
	g_print ("*** %d. timeout getting data from GPS-Receiver! ",
		 timeoutcount);
      if ((timeoutcount * 80) > TIMER)
	{
	  gtk_statusbar_pop (GTK_STATUSBAR (status), statusid);
	  gtk_statusbar_push (GTK_STATUSBAR (status), statusid,
			      _("Timeout getting data from GPS-Receiver!"));
	  havepos = FALSE;
	  haveposcount = 0;
	  memset (satlist, 0, sizeof (satlist));
	  memset (satlistdisp, 0, sizeof (satlist));


	}

    }
  return (TRUE);
}


/*  test if we need to load another map */
void
testnewmap ()
{
  glong best = 1000000000;
  gdouble posx, posy;
  glong bestmap = 9999999;
  gdouble pixelfactloc, bestscale = 1000000000, fact;
  gint i, skip;
  gchar str[100], buf[200], mappath[500];
  gdouble dif;
/*   gdouble centeredx, centeredy, centereddist, bestcentereddist = 10000000.0; */

  if (importactive)
    return;

  if (posmode)
    {
      current_long = posmode_x;
      current_lat = posmode_y;
    }
  else
    {
      gdouble d;
/*  test for new route point */
      if (strcmp (targetname, "     "))
	{
	  if (routemode)
	    d =
	      calcdist ((routelist + routepointer)->longitude,
			(routelist + routepointer)->lat);
	  else
	    d = calcdist (target_long, target_lat);

	  if (d < routenearest)
	    {
	      routenearest = d;
	    }
/* 	  g_print */
/* 	    ("\nroutepointer: %d d: %.1f routenearest: %.1f routereach: %0.3f", */
/* 	     routepointer, d, routenearest, ROUTEREACH); */
	  if ((d <= ROUTEREACH) || (d > (ROUTEREACHFACT * routenearest))
	      || forcenextroutepoint)
	    {
	      forcenextroutepoint = FALSE;
	      if ((routepointer != (routeitems - 1)) && (routemode))
		{
		  routenearest = 9999999999;
		  routepointer++;
/* let's say the waypoint description */
		  strcpy (mappath, homedir);
		  strcat (mappath, activewpfile);
		  saytargettext (mappath, targetname);

		  setroutetarget (NULL, -1);
		}
	      else
		{
/*  route endpoint reached */
		  if (saytarget)
		    {
		      sprintf (str, "%s %s", _("Distance to "), targetname);
		      gtk_frame_set_label (GTK_FRAME (destframe), str);
		      createroute = FALSE;
		      routemode = FALSE;
		      saytarget = FALSE;
		      routepointer = routeitems = 0;
		      switch (voicelang)
			{
			case english:
			  sprintf (buf,
				   "You reached the target %s", targetname);
			  break;
			case spanish:
			  sprintf (buf, "usted ha llegado a %s", targetname);
			  break;
			case german:
			  sprintf (buf,
				   "Sie haben das Ziel %s erreicht",
				   targetname);
			}
		      speech_out_speek (buf);
/* let's say the waypoint description */
		      strcpy (mappath, homedir);
		      strcat (mappath, activewpfile);
		      saytargettext (mappath, targetname);
		    }
		}
	    }
	}
    }
  for (i = 0; i < nrmaps; i++)
    {
      skip = TRUE;
      if (displaymap_map)
	if (!(strncmp ((maps + i)->filename, "map_", 4)))
	  skip = FALSE;
      if (displaymap_top)
	if (!(strncmp ((maps + i)->filename, "top_", 4)))
	  skip = FALSE;

      if (skip)
	continue;

/*        calcxy (&posx, &posy, (maps + i)->longitude, (maps + i)->lat,1); */
/*  Longitude */
      posx =
	(Ra[(int) (100 + (maps + i)->lat)] * M_PI / 180) * cos (M_PI *
								(maps +
								 i)->lat /
								180.0) *
	(current_long - (maps + i)->longitude);
/*  latitude */
      posy =
	(Ra[(int) (100 + (maps + i)->lat)] * M_PI / 180) * (current_lat -
							    (maps + i)->lat);
      dif =
	Ra[(int) (100 + (maps + i)->lat)] * (1 -
					     (cos
					      ((M_PI *
						(current_long -
						 (maps +
						  i)->longitude)) / 180.0)));
      posy = posy + dif / 2.0;

      pixelfactloc = (maps + i)->scale / PIXELFACT;
      posx = posx / pixelfactloc;
      posy = posy / pixelfactloc;

      if ((posx > -(640 - borderlimit)) && (posx < (640 - borderlimit)))
	{
	  if (((posy - borderlimit) > -512) && ((posy + borderlimit) < 512))
	    {
/* 	      centeredx = abs ((SCREEN_X / 2) - posx); */
/* 	      centeredy = abs ((SCREEN_Y / 2) - posy); */
/* 	      if (centeredx > 1.25 * centeredy) */
/* 		centereddist = centeredx; */
/* 	      else */
/* 		centereddist = centeredy; */

/* 	      centereddist *= (maps + i)->scale; */

	      if (scaleprefered)
		{
		  if (scalewanted > (maps + i)->scale)
		    fact = (gdouble) scalewanted / (maps + i)->scale;
		  else
		    fact = (maps + i)->scale / (gdouble) scalewanted;

		  if (fact < bestscale)
		    {
		      bestscale = fact;
		      bestmap = i;
/* 			  bestcentereddist = centereddist; */
		    }
		}
	      else		/* autobestmap */
		{
		  if ((maps + i)->scale < best)
		    {
		      bestmap = i;
		      best = (maps + i)->scale;
		    }
		}
	    }			/*  End of if posy> ... */
	}

    }
  if (bestmap != 9999999)
    {
      strcpy (mapfilename, (maps + bestmap)->filename);
      if ((strcmp (oldfilename, mapfilename)) != 0)
	{
	  strcpy (oldfilename, mapfilename);
	  if (debug)
	    g_print ("\nNew map: %s\n", mapfilename);
	  pixelfact = (maps + bestmap)->scale / PIXELFACT;
	  zero_long = (maps + bestmap)->longitude;
	  zero_lat = (maps + bestmap)->lat;
	  mapscale = (maps + bestmap)->scale;
	  xoff = yoff = 0;
	  loadmap (mapfilename);
	}
    }
  else
    {
      maploaded = FALSE;
      iszoomed = FALSE;
      strcpy (mapfilename, "--------");
      strcpy (oldfilename, mapfilename);
    }
}

/*  set the target in routemode */
void
setroutetarget (GtkWidget *widget, guint datum)
{
  gchar buf[1000], buf2[1000], str[200], *tn;

  if (datum != -1)
    routepointer = datum;

  routenearest = 9999999;
  strcpy (targetname, (routelist + routepointer)->name);
  target_lat = (routelist + routepointer)->lat;
  target_long = (routelist + routepointer)->longitude;
  sprintf (str, "%s %s[%d/%d]", _("Distance to "), targetname,
	   routepointer + 1, routeitems);
  gtk_frame_set_label (GTK_FRAME (destframe), str);
  tn = g_strdelimit (targetname, "_", ' ');
  strcpy (buf2, "");
  if (tn[0] == '*')
    {
      strcpy (buf2, "das mobile Ziel ");
      strcat (buf2, (tn + 1));
    }
  else
    strcat (buf2, tn);

  switch (voicelang)
    {
    case english:
      sprintf (buf, "New target is %s", buf2);
      break;
    case spanish:
      sprintf (buf, "Destinacin definida: %s", buf2);
      break;
    case german:
      sprintf (buf, "Neues Ziel ist %s ", buf2);
    }
  speech_out_speek (buf);
  speechcount = 0;
  strcpy (oldangle, "XXX");
  saytarget = TRUE;
}


gint
posmodeoff_cb (GtkWidget *widget, guint *datum)
{
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (posbt), FALSE);
  return FALSE;
}

gint
lightoff (GtkWidget *widget, guint *datum)
{
  disableisnight = FALSE;
  return FALSE;
}

gint
lighton (void)
{
  disableisnight = TRUE;
/*   nighttimer = gtk_timeout_add (30000, (GtkFunction) lightoff, 0); */

  return TRUE;
}

/* map_koord.txt is in mappath! */
gint
testconfig_cb (GtkWidget *widget, guint *datum)
{
  gint i;

  for (i = 0; i < nrmaps; i++)
    {
      if ((strncmp ((maps + i)->filename, "map_", 4)))
	if ((strncmp ((maps + i)->filename, "top_", 4)))
	  {
	    GString *error;
	    error = g_string_new (NULL);
	    g_string_sprintf (error, "\n%s%d\n%s", _("Error in line "), i + 1,
			      _
			      ("I have found filenames in map_koord.txt which are\n"
			       "not map_* or top_* files. Please rename them and change the entries in\n"
			       "map_koord.txt.  Use map_* for street maps and top_* for topographical\n"
			       "maps.  Otherwise, the maps will not be displayed!"));
	    error_popup ((gpointer *) error->str);
	    g_string_free (error, TRUE);
	    messageshown = TRUE;
	    return FALSE;
	  }
    }

  if (havefriends)
    friendsagent_cb (NULL, 0);
  trip_lat = current_lat;
  trip_long = current_long;
  triptime = time (NULL);
  gtk_timeout_add (5000, (GtkFunction) dotripmeter, NULL);

  return FALSE;
}

gint
watchwp_cb (GtkWidget *widget, guint *datum)
{
  gint angle, i, radarnear;
  gdouble d;
  gchar buf[400], lname[200], l2name[200];
  gdouble ldist = 9999.0, l2dist = 9999.0;
  gdouble tx, ty, lastbearing;

/*  calculate new earth radius */
  earthr = calcR (current_lat);

  if (importactive)
    return TRUE;

  foundradar = FALSE;
  radarnear = FALSE;


  for (i = 0; i < maxwp; i++)
    {
/*  test for radar */
      if (((wayp + i)->action) == 1)
	{
	  d = calcdist2 ((wayp + i)->longitude, (wayp + i)->lat);
	  if (d < 0.6)
	    {
	      lastbearing = radarbearing;
	      tx = -current_long + (wayp + i)->longitude;
	      ty = -current_lat + (wayp + i)->lat;
	      radarbearing = atan (tx / ty);
	      if (!finite (radarbearing))
		radarbearing = lastbearing;

	      if (ty < 0)
		radarbearing = M_PI + radarbearing;
	      radarbearing -= direction;
	      if (radarbearing >= (2 * M_PI))
		radarbearing -= 2 * M_PI;
	      if (radarbearing < 0)
		radarbearing += 2 * M_PI;
	      if (radarbearing < 0)
		radarbearing += 2 * M_PI;
	      angle = radarbearing * 180.0 / M_PI;

	      if ((angle < 40) || (angle > 320))
		{
		  foundradar = TRUE;
		  if (d < ldist)
		    {
		      ldist = d;
		      strcpy (lname, (wayp + i)->name);
		    }
		  if (d < 0.2)
		    {
		      foundradar = TRUE;
		      radarnear = TRUE;
		      if (d < l2dist)
			{
			  l2dist = d;
			  strcpy (l2name, (wayp + i)->name);
			}
		    }
		}

	    }

	}
    }
  if (!foundradar)
    {
      strcpy (lastradar, "----");
      strcpy (lastradar2, "----");
    }
  else
    {
      if ((strcmp (lname, lastradar)) != 0)
	{
	  strcpy (lastradar, lname);
	  switch (voicelang)
	    {
	    case english:
	      sprintf (buf,
		       "Danger, Danger, Radar in %d meters, Your speed is %d",
		       (int) (ldist * 1000.0), (int) groundspeed);
	      break;
	    case spanish:
	      sprintf (buf,
		       "Atencin Atencin, control de  velocidad en %d metros, Su velocidad es %d",
		       (int) (ldist * 1000.0), (int) groundspeed);
	      break;
	    case german:
	      sprintf (buf,
		       "Achtung, Achtung, Radar in %d metern, Ihre Geschwindigkeit ist %d",
		       (int) (ldist * 1000.0), (int) groundspeed);
	    }
	  if (displaytext != NULL)
	    free (displaytext);
	  displaytext = strdup (buf + 10);
	  displaytext = g_strdelimit (displaytext, "\n", ' ');
	  displaytext = g_strdelimit (displaytext, "\")", ' ');

	  do_display_dsc = TRUE;
	  textcount = 0;

	  speech_out_speek (buf);
	}

      if (radarnear)
	if ((strcmp (l2name, lastradar2)) != 0)
	  {
	    strcpy (lastradar2, l2name);
	    switch (voicelang)
	      {
	      case english:
		sprintf (buf,
			 "Information, Radar in %d meters",
			 (int) (ldist * 1000.0));
		break;
	      case spanish:
		sprintf (buf,
			 "Informacin, control de  velocidad en %d metros",
			 (int) (ldist * 1000.0));
		break;
	      case german:
		sprintf (buf,
			 "Information, Radar in %d meter",
			 (int) (ldist * 1000.0));
	      }
	    speech_out_speek (buf);
	  }

    }

  return TRUE;
}

void
checkinput (gchar *text)
{
  if ((strstr (text, "")) != NULL)
    mintodecimal (text);
}

void
decimaltomin (gchar *text, gint islat)
{
  gint grad, min, minus = FALSE;
  gdouble dec, rest, minf, sec;
  dec = g_strtod (text, NULL);
  if (dec < 0)
    {
      minus = TRUE;
      dec *= -1.0;
    }
  grad = dec;
  rest = dec - grad;

  minf = (60.0 * rest);
  min = minf;
  rest = minf - min;
  sec = 60.0 * rest;
  if (islat)
    sprintf (text, "%d%.2d'%05.2f''%c", grad, min, sec, (minus) ? 'S' : 'N');
  else
    sprintf (text, "%d%.2d'%05.2f''%c", grad, min, sec, (minus) ? 'W' : 'E');
}

void
mintodecimal (gchar *text)
{
  gint grad, min, minus = FALSE;
  gdouble dec, sec;
  gchar s2;
  gfloat s1;

  sscanf (text, "%d%d'%f''%c", &grad, &min, &s1, &s2);
  if (s2 == 'W')
    minus = TRUE;
  if (s2 == 'S')
    minus = TRUE;

/*   g_strdelimit (s1, ",", '.'); */
/*   sscanf(s1,"%f",&sec); */
  sec = s1;
  dec = grad + min / 60.0 + sec / 3600.0;
  if (minus)
    dec *= -1.0;
  sprintf (text, "%.6f", dec);
/*   g_print ("%s\n", text); */
}

/*  display upper status line */
void
display_status2 ()
{
  gchar s2[100], buf[200], mf[50];
  gint h, m;
  gdouble secs, v;
  if (downloadactive == TRUE)
    return;
  if (importactive == TRUE)
    return;
  secs = g_timer_elapsed (disttimer, 0);
  h = hours;
  m = minutes;
  if (secs >= 300.0)
    {
      g_timer_stop (disttimer);
      g_timer_start (disttimer);
      v = 3600.0 * (olddist - dist) / secs;
      h = dist / v;
      m = 60 * (dist / v - h);
      if (mydebug)
	g_print ("\nsecs: %.0fs,v:%.0f,h:%d,m:%d", secs, v, h, m);
      if ((m < 0) || (h > 99))
	{
	  h = 99;
	  m = 99;
	}
      olddist = dist;
      hours = h;
      minutes = m;
      if (!muteflag)
	if (hours < 99)
	  {
	    switch (voicelang)
	      {
	      case english:
		if (hours > 0)
		  sprintf (buf,
			   "Arrival in approximatly %d hours and %d minutes",
			   hours, minutes);
		else
		  sprintf (buf,
			   "Arrival in approximatly %d minutes", minutes);
		break;
	      case spanish:
		if (hours > 0)
		  sprintf (buf,
			   "Llegada en %d horas y %d minutos",
			   hours, minutes);
		else
		  sprintf (buf, "Llegada en %d minutos", minutes);
		break;
	      case german:
		if (hours > 0)
		  {
		    if (hours == 1)
		      sprintf (buf,
			       "Ankunft in circa einer Stunde und %d minuten",
			       minutes);
		    else
		      sprintf (buf,
			       "Ankunft in circa %d Stunden und %d minuten",
			       hours, minutes);
		  }
		else
		  sprintf (buf, "Ankunft in zirca %d minuten", minutes);
		speech_out_speek (buf);
	      }
	  }

    }
  sprintf (s2, "%8.5f", current_lat);
  if (minsecmode)
    decimaltomin (s2, 1);
  else
    {
      if (current_lat >= 0)
	strcat (s2, "N");
      else
	strcat (s2, "S");
    }

  gtk_label_set_text (GTK_LABEL (l1), s2);

  sprintf (s2, "%8.5f", current_long);

  if (minsecmode)
    decimaltomin (s2, 0);
  else
    {
      if (current_long >= 0)
	strcat (s2, "E");
      else
	strcat (s2, "W");
    }
  gtk_label_set_text (GTK_LABEL (l2), s2);
  strncpy (mf, mapfilename, 18);
  mf[17] = 0;
  gtk_label_set_text (GTK_LABEL (l3), mf);
  sprintf (s2, "1:%ld", mapscale);
  gtk_label_set_text (GTK_LABEL (l4), s2);
  sprintf (s2, "%3.0f", direction * 180.0 / M_PI);
  gtk_label_set_text (GTK_LABEL (l5), s2);
  sprintf (s2, "%3.0f", bearing * 180.0 / M_PI);
  gtk_label_set_text (GTK_LABEL (l6), s2);
  sprintf (s2, "%2d:%02dh", h, m);
  gtk_label_set_text (GTK_LABEL (l7), s2);
  if (scaleprefered)
    sprintf (s2, "1:%d", scalewanted);
  else
    sprintf (s2, _("Auto"));
  gtk_label_set_text (GTK_LABEL (l8), s2);
  if (debug)
    {
      if (havepos)
	g_print ("\n***Position: %f %f***\n", current_lat, current_long);
      else
	g_print ("\n***no valid Position:\n");
    }
}

/* draw the marker on the map */
gint
drawmarker_cb (GtkWidget *widget, guint *datum)
{

  if (importactive)
    return TRUE;


/*  we test if we have to load a new map because we are outside 
the currently loaded map */
  testnewmap ();
/*   g_print("\ndrawmarker_cb %d",drawmarkercounter++); */
  exposed = FALSE;
/* The position calculation is made in expose_cb() */
  gtk_widget_draw (drawing_area, NULL);	/* this  calls expose handler */
  if (!exposed)
    expose_cb (NULL, 0);
  expose_compass (NULL, 0);
  return TRUE;
}

/* Friends agent */
gint
friendsagent_cb (GtkWidget *widget, guint *datum)
{

/*  send position to friendsserver */
  if (havefriends)
    {
      time_t t;
      struct tm *ts;
      gchar buf3[40], buf[200], la[20], lo[20];

      time (&t);
      ts = gmtime (&t);
      strftime (buf3, sizeof (buf3), "%H:%M(%a)", ts);
      sprintf (la, "%10.6f", current_lat);
      sprintf (lo, "%10.6f", current_long);
      g_strdelimit (la, ",", '.');
      g_strdelimit (lo, ",", '.');

      sprintf (buf, "POS: %s %s %s %s %.0f %.0f\n",
	       friendsname, la, lo, buf3, groundspeed / milesconv,
	       180.0 * direction / M_PI);
      write (friendssock, buf, strlen (buf));
    }

  return TRUE;
}



/* Master agent */
gint
masteragent_cb (GtkWidget *widget, guint *datum)
{
  gchar mappath[400];
  gint f;
  struct stat buf;

/*   if (havebattery) */
/*     expose_display_battery (); */

  if (needtosave)
    writeconfig ();
  if (needreloadmapconfig)
    loadmapconfig ();

  testifnight ();

/* Check for changed way.txt and reload if changed */
  strcpy (mappath, homedir);

  if (!sqlflag)
    strcat (mappath, activewpfile);
  else
    strcat (mappath, "way-SQLRESULT.txt");

  f = stat (mappath, &buf);
  if (buf.st_mtime != waytxtstamp)
    {
      loadwaypoints ();
      iszoomed = FALSE;
      if (!sqlflag)
	g_print ("\n%s reloaded\n", activewpfile);
      else
	g_print ("\n%s reloaded\n", "way-SQLRESULT.txt");
    }
  if (tracknr > (tracklimit - 1000))
    {
      g_print ("tracklimit: %ld", tracklimit);
      track = g_renew (trackstruct, track, tracklimit + 100000);
      trackshadow = g_renew (trackstruct, trackshadow, tracklimit + 100000);
      tracklimit += 100000;
    }
  if (trackcoordnr > (trackcoordlimit - 1000))
    {
      trackcoord =
	g_renew (trackcoordstruct, trackcoord, trackcoordlimit + 100000);
      trackcoordlimit += 100000;
    }



  return TRUE;
}

/* draw track on image */
gint
storetrack_cb (GtkWidget *widget, guint *datum)
{
  gint i, so;
  gchar buf3[35];
  time_t t;
  struct tm *ts;

/*    if (posmode) */
/*      return TRUE; */
  if (posmode)
    i = 1;
  else
    i = 2;

/*    g_print ("\nHavepos: %d", havepos); */
  if ((!simmode && !havepos) || posmode /*  ||((!simmode &&haveposcount<3)) */ )	/* we have no valid position */
    {
      (trackcoord + trackcoordnr)->longi = 1001.0;
      (trackcoord + trackcoordnr)->lat = 1001.0;
      (trackcoord + trackcoordnr)->alt = 1001.0;
    }
  else
    {
      (trackcoord + trackcoordnr)->longi = current_long;
      (trackcoord + trackcoordnr)->lat = current_lat;
      (trackcoord + trackcoordnr)->alt = altitude;
    }


/*  The double storage seems to be silly, but I have to use  */
/*  gdk_draw_segments instead of gdk_draw_lines.   */
/*  gkd_draw_lines is dog slow because of a gdk-bug. */

  if ((tracknr & 1) == 0)
    {
      if ((trackcoord + trackcoordnr)->longi < 1000.0)
	{
	  (track + tracknr)->x = posx;
	  (track + tracknr)->y = posy;
	  (trackshadow + tracknr)->x = posx + SHADOWOFFSET;
	  (trackshadow + tracknr)->y = posy + SHADOWOFFSET;
	  tracknr++;
	}
    }
  else
    {
      if ((trackcoord + trackcoordnr)->longi < 1000.0)
	{
	  if ((posx != (track + tracknr - 1)->x)
	      || (posy != (track + tracknr - 1)->y))
	    {
/*  		so=(int)(((trackcoord + trackcoordnr)->alt))>>5; */
	      so = SHADOWOFFSET;
	      (track + tracknr)->x = (track + tracknr + 1)->x = posx;
	      (track + tracknr)->y = (track + tracknr + 1)->y = posy;
	      (trackshadow + tracknr)->x = (trackshadow + tracknr + 1)->x =
		posx + so;
	      (trackshadow + tracknr)->y = (trackshadow + tracknr + 1)->y =
		posy + so;
	      tracknr += 2;
	    }
	}
      else
	tracknr = tracknr & ((glong) - 2);
    }
  time (&t);
  ts = localtime (&t);
  strncpy (buf3, asctime (ts), 32);
  buf3[strlen (buf3) - 1] = '\0';	/* get rid of \n */
  strcpy ((trackcoord + trackcoordnr)->postime, buf3);
  trackcoordnr++;

  return TRUE;
}

void
drawwlan (gint posxdest, gint posydest, gint wlan)
{
  /*  wlan=0: no wlan, 1:open wlan, 2:WEP crypted wlan */

  if (wlan == 0)
    return;

  if ((posxdest >= 0) && (posxdest < SCREEN_X))
    {

      if ((posydest >= 0) && (posydest < SCREEN_Y))
	{
	  if (wlan == 1)
	    gdk_pixbuf_render_to_drawable_alpha (openwlanpixbuf, drawable,
						 /*  kontext, */ 0, 0,
						 posxdest - 14,
						 posydest - 12, 24, 24,
						 GDK_PIXBUF_ALPHA_BILEVEL,
						 127, GDK_RGB_DITHER_NONE,
						 0, 0);
	  else
	    gdk_pixbuf_render_to_drawable_alpha (closedwlanpixbuf, drawable,
						 /*  kontext, */ 0, 0,
						 posxdest - 14,
						 posydest - 12, 24, 24,
						 GDK_PIXBUF_ALPHA_BILEVEL,
						 127, GDK_RGB_DITHER_NONE,
						 0, 0);
	}
    }
}

int
drawicon (gint posxdest, gint posydest, char *ic)
{
  int symbol = 0;
  gchar icon[80];


  strcpy (icon, ic);
  if (!sqlflag)
    g_strup (icon);

  if ((strcmp (icon, "REST")) == 0)
    symbol = 1;
  else if ((strcmp (icon, "MCDONALDS")) == 0)
    symbol = 2;
  else if ((strcmp (icon, "HOTEL")) == 0)
    symbol = 3;
  else if ((strcmp (icon, "BURGERKING")) == 0)
    symbol = 4;
  else if ((strcmp (icon, "SHOP")) == 0)
    symbol = 5;
  else if ((strcmp (icon, "MONU")) == 0)
    symbol = 6;
  else if ((strcmp (icon, "NIGHTCLUB")) == 0)
    symbol = 7;
  else if ((strcmp (icon, "SPEEDTRAP")) == 0)
    symbol = 8;
  else if ((strcmp (icon, "AIRPORT")) == 0)
    symbol = 9;
  else if ((strcmp (icon, "GOLF")) == 0)
    symbol = 10;
  else if ((strcmp (icon, "GASSTATION")) == 0)
    symbol = 11;
  else if ((strcmp (icon, "CAFE")) == 0)
    symbol = 12;

  if (symbol == 0)
    return 0;

  if ((posxdest >= 0) && (posxdest < SCREEN_X))
    {

      if ((posydest >= 0) && (posydest < SCREEN_Y))
	{
	  gdk_pixbuf_render_to_drawable_alpha (iconpixbuf[symbol - 1],
					       drawable, 0, 0,
					       posxdest - 12,
					       posydest - 12, 24, 24,
					       GDK_PIXBUF_ALPHA_BILEVEL,
					       127, GDK_RGB_DITHER_NONE,
					       0, 0);
	}
    }
  return symbol;
}

void
drawfriends (void)
{
  gint e, i, k;
  gdouble posxdest, posydest, clong, clat, direction;
  gchar buffer[2010], dtype[20], *data, **nstr;


  FD_ZERO (&friendsreadmask);
  FD_SET (friendssock, &friendsreadmask);
  friendstimeout.tv_sec = 0;
  friendstimeout.tv_usec = 10000;
  if (select (FD_SETSIZE, &friendsreadmask, NULL, NULL, &friendstimeout) < 0)
    {
      perror ("select() call");
    }
  if (FD_ISSET (friendssock, &friendsreadmask))
    {
      if ((e = read (friendssock, buffer, 2000)) < 0)
	perror ("read from friendsd connection");
      buffer[e] = 0;
      strcat (friendsbuffer, buffer);
      friendsbuffstart = strstr (friendsbuffer, "$START:$");
      friendsbuffend = strstr (friendsbuffer, "$END:$");
      if ((friendsbuffstart != NULL) && (friendsbuffend != NULL))
	{
	  /*  we found a complete data block */
	  *friendsbuffend = 0;
	  data = friendsbuffstart + 9;
	  if (debug)
	    g_print ("\nFriendsd data block is:\n%s\n", data);
	  nstr = g_strsplit (data, "\n", 0);
	  i = 0;
	  while (nstr[i] != NULL)
	    {
	      strcpy (friendsspeed[i], "");
	      if ((strstr (buffer, "POS:")) != NULL)
		e = sscanf (nstr[i], "%s %s %s %s %s %s %s",
			    dtype, friendstxt[i], friendslat[i],
			    friendslon[i], friendstim[i], friendsspeed[i],
			    friendsdir[i]);
	      strcat (friendsspeed[i], "km/h");
	      i++;
	    }
	  friendsbuffer[0] = 0;
	  g_strfreev (nstr);
	  maxfriends = i;
	}
    }


  for (i = 0; i < maxfriends; i++)
    {
      clong = g_strtod (friendslon[i], NULL);
      clat = g_strtod (friendslat[i], NULL);

      calcxy (&posxdest, &posydest, clong, clat, zoom);

      if ((posxdest >= 0) && (posxdest < SCREEN_X))
	{

	  if ((posydest >= 0) && (posydest < SCREEN_Y))
	    {

	      gdk_pixbuf_render_to_drawable_alpha (friendspixbuf, drawable,
						   /*  kontext, */ 0, 0,
						   posxdest - 18,
						   posydest - 18, 37, 37,
						   GDK_PIXBUF_ALPHA_BILEVEL,
						   127, GDK_RGB_DITHER_NONE,
						   0, 0);
	      gdk_gc_set_line_attributes (kontext, 4, 0, 0, 0);
/*  draw pointer to direction */

	      gdk_gc_set_foreground (kontext, &yellow);
	      direction = strtod (friendsdir[i], NULL) * M_PI / 180.0;
	      gdk_draw_line (drawable, kontext,
			     posxdest + 4 * sin (direction),
			     posydest - 4 * cos (direction),
			     posxdest + 20 * sin (direction),
			     posydest - 20 * cos (direction));
	      gdk_gc_set_line_attributes (kontext, 2, 0, 0, 0);
	      gdk_draw_arc (drawable, kontext, 0, posxdest + 2 - 7,
			    posydest + 2 - 7, 10, 10, 0, 360 * 64);


/*  draw + sign at destination */
/*  	      gdk_gc_set_foreground (kontext, &red); */
/*  	      gdk_draw_line (drawable, kontext, posxdest + 1, */
/*  			     posydest + 1 - 5, posxdest + 1, */
/*  			     posydest + 1 + 5); */
/*  	      gdk_draw_line (drawable, kontext, posxdest + 1 + 5, */
/*  			     posydest + 1, posxdest + 1 - 5, posydest + 1); */

/*  Draw name */
	      k =
		gdk_text_width (smalltextfont, friendstxt[i],
				strlen (friendstxt[i]));
	      gdk_gc_set_foreground (kontext, &white);
	      gdk_draw_rectangle (drawable, kontext, 1, posxdest + 18,
				  posydest - 6, k + 1, 14);
	      gdk_gc_set_foreground (kontext, &blue);
	      gdk_draw_text (drawable, smalltextfont, kontext,
			     posxdest + 18, posydest + 6,
			     friendstxt[i], strlen (friendstxt[i]));
/*  Draw time */
	      k =
		gdk_text_width (smalltextfont, friendstim[i],
				strlen (friendstim[i]));
	      gdk_gc_set_foreground (kontext, &white);
	      gdk_draw_rectangle (drawable, kontext, 1, posxdest + 18,
				  posydest + 8, k + 1, 14);
	      gdk_gc_set_foreground (kontext, &blue);
	      gdk_draw_text (drawable, smalltextfont, kontext,
			     posxdest + 18, posydest + 20,
			     friendstim[i], strlen (friendstim[i]));
/*  Draw speed */
	      k =
		gdk_text_width (smalltextfont, friendsspeed[i],
				strlen (friendsspeed[i]));
	      gdk_gc_set_foreground (kontext, &white);
	      gdk_draw_rectangle (drawable, kontext, 1, posxdest + 18,
				  posydest + 22, k + 1, 14);
	      gdk_gc_set_foreground (kontext, &blue);
	      gdk_draw_text (drawable, smalltextfont, kontext,
			     posxdest + 18, posydest + 34,
			     friendsspeed[i], strlen (friendsspeed[i]));

	    }
	}
    }



}


gint
expose_sats_cb (GtkWidget *widget, guint *datum)
{
  gint k, i, yabs, h, j, l, l2;
  GdkGC *mykontext;
  gchar t[10], t1[20], buf[300], txt[10];

#define SATX 5
/*  draw satellite level (field strength) only in NMEA modus*/


  if (haveNMEA)
    {

      gdk_gc_set_foreground (kontext, &lcd);
      gdk_draw_rectangle (drawable_sats, kontext, 1, 3, 0, PSIZE + 2,
			  PSIZE + 5);
      gdk_gc_set_line_attributes (kontext, 1, 0, 0, 0);
      gdk_gc_set_foreground (kontext, &black);
      gdk_draw_rectangle (drawable_sats, kontext, 0, 3, 0, PSIZE + 2,
			  PSIZE + 5);

      gdk_gc_set_foreground (kontext, &lcd);

/*       if (satposmode) */
/* 	gdk_gc_set_foreground (kontext, &lcd); */
/*       else */
/* 	gdk_gc_set_foreground (kontext, &lcd); */
/*       gdk_draw_rectangle (drawable_sats, kontext, 1, 3 + SATX, 0, PSIZE - 6, */
/* 			  PSIZE + 2); */
      if (!satposmode)
	{
	  gdk_gc_set_foreground (kontext, &lcd2);
	  gdk_gc_set_line_attributes (kontext, 5, 0, 0, 0);
	  k = 0;
	  for (i = 0; i < 16; i++)
	    {
	      if (i > 5)
		yabs = PSIZE;
	      else
		yabs = PSIZE / 2;
	      h = PSIZE / 2 - 2;
	      gdk_draw_line (drawable_sats, kontext, 7 + 7 * k + SATX, yabs,
			     7 + 7 * k + SATX, yabs - h);
	      k++;
	      if (k > 5)
		k = 0;
	    }
	}
      if (satfix == 1)		/* normal Fix */
	gdk_gc_set_foreground (kontext, &black);
      else
	{
	  if (satfix == 0)	/* no Fix */
	    gdk_gc_set_foreground (kontext, &textback);
	  else			/* Differntial Fix */
	    gdk_gc_set_foreground (kontext, &green);
	}
      j = k = 0;
#define DEG2RAD M_PI/180.0
      if (satposmode)
	{
	  gdk_gc_set_line_attributes (kontext, 1, 0, 0, 0);
	  gdk_gc_set_foreground (kontext, &lcd2);
	  gdk_draw_arc (drawable_sats, kontext, 0, 4,
			4, PSIZE, PSIZE, 105 * 64, 330 * 64);
	  gdk_draw_arc (drawable_sats, kontext, 0, 5 + PSIZE / 4,
			4 + PSIZE / 4, PSIZE / 2, PSIZE / 2, 0, 360 * 64);
	  gdk_gc_set_foreground (kontext, &darkgrey);

	  gdk_draw_text (drawable_sats, verysmalltextfont, kontext,
			 2 + (PSIZE) / 2, 9, "N", 1);
	  gdk_gc_set_foreground (kontext, &lcd2);

	}

      for (i = 0; i < 40; i++)
	if (satlistdisp[i][0] != 0)
	  {
	    if ((satlistdisp[i][1] > 30) && (printoutsats))
	      g_print ("%d %d\n", satlistdisp[i][3], satlistdisp[i][2]);
	    if (satposmode)
	      {
		gint x, y;
		gdouble el, az;
		el = (90.0 - satlistdisp[i][2]);
		az = satlistdisp[i][3] * DEG2RAD;

		x = (PSIZE / 2) + sin (az) * (el / 90.0) * (PSIZE / 2);
		y = (PSIZE / 2) - cos (az) * (el / 90.0) * (PSIZE / 2);
		l = (satlistdisp[i][1] / 6);
		if (l > 7)
		  l = 7;
		switch (l & 7)
		  {
		  case 0:
		  case 1:
		    gdk_gc_set_foreground (kontext, &textback);
		    break;
		  case 2:
		  case 3:
		    gdk_gc_set_foreground (kontext, &red);
		    break;
		  case 4:
		  case 5:
		  case 6:
		    gdk_gc_set_foreground (kontext, &yellow);
		    break;
		  case 7:
		    gdk_gc_set_foreground (kontext, &green2);
		    break;
		  }
		gdk_draw_arc (drawable_sats, kontext, 1, 2 + x,
			      2 + y, 5, 5, 0, 360 * 64);

	      }
	    else
	      {
		if (j > 5)
		  yabs = PSIZE;
		else
		  yabs = PSIZE / 2 - 1;
		h = satlistdisp[i][1] - 30;
		if (h < 0)
		  h = 1;
		if (h > 19)
		  h = 19;
		gdk_draw_line (drawable_sats, kontext, 7 + 7 * k + SATX, yabs,
			       7 + 7 * k + SATX,
			       yabs - (PSIZE / 2) * h / (PSIZE / 2 - 5));
		k++;
		if (k > 5)
		  k = 0;
		j++;
	      }
	  }
      newsatslevel = FALSE;
      if (!satposmode)
	{
	  sprintf (txt, "%d", numsats);
	  l = gdk_text_width (bigtextfont, txt, strlen (txt));
	  l2 = gdk_text_height (bigtextfont, txt, strlen (txt));
	  gdk_gc_set_foreground (kontext, &green);
	  gdk_gc_set_function (kontext, GDK_OR);
	  gdk_draw_text (drawable_sats, bigtextfont, kontext,
			 5 + (PSIZE) / 2 - l / 2,
			 1 + (PSIZE + l2) / 2, txt, strlen (txt));
	  gdk_gc_set_function (kontext, GDK_COPY);
	}
      if (precision > 0.0)
	{
	  if (milesflag || nauticflag)
	    sprintf (t1, "%.0fft", precision * 3.2808399);
	  else
	    sprintf (t1, "%.0fm", precision);
	  if (satfix == 0)
	    sprintf (t, "n/a");
	  else
	    sprintf (t, "%s%s", (satfix == 2) ? "DGPS " : "EPE ", t1);
	  gtk_frame_set_label (GTK_FRAME (frame_sats), t);
	}
      strcpy (buf, "");
      if (debug)
	g_print ("\nSatfix: %d", satfix);
      if (satfix != oldsatfix)
	{
	  if (satfix == 2)
	    {
	      switch (voicelang)
		{
		case english:
		  sprintf (buf, "Differential GPS signal found");
		  break;
		case spanish:
		  sprintf (buf, "Destinacin definida: ");
		  break;
		case german:
		  sprintf (buf,
			   "Ein differenzielles GPS Signal wurde gefunden");
		}
	    }
	  else if ((satfix == 1) && (oldsatfix == 2))
	    {
	      switch (voicelang)
		{
		case english:
		  sprintf (buf, "No differential GPS signal detected");
		  break;
		case spanish:
		  sprintf (buf, "No differential GPS signal detected ");
		  break;
		case german:
		  sprintf (buf, "Kein differenzielles GPS Signal vorhanden");
		}
	    }

	  if (satfix == 0)
	    {
	      switch (voicelang)
		{
		case english:
		  sprintf (buf, "No sufficent GPS signal");
		  break;
		case spanish:
		  sprintf (buf, "No sufficent GPS signal detected ");
		  break;
		case german:
		  sprintf (buf, "Kein ausreichendes GPS Signal vorhanden");
		}
	    }
	  if (satfix == 1)
	    {
	      switch (voicelang)
		{
		case english:
		  sprintf (buf, "GPS signal good");
		  break;
		case spanish:
		  sprintf (buf, "GPS signal bueno ");
		  break;
		case german:
		  sprintf (buf, "Gutes GPS Signal vorhanden");
		}
	    }




	  oldsatfix = satfix;
	  speech_out_speek (buf);
	}
    }
  else
    {
      mykontext = gdk_gc_new (drawable_sats);
      satsimage = gdk_pixbuf_new_from_xpm_data ((const char **) pinguin_xpm);

      gdk_gc_set_function (mykontext, GDK_AND);
      gdk_pixbuf_render_to_drawable_alpha (satsimage, drawable_sats, 0, 0,
					   3 + SATX, 0, 42, 50,
					   GDK_PIXBUF_ALPHA_BILEVEL, 255,
					   GDK_RGB_DITHER_NONE, 0, 0);
      gdk_gc_set_function (mykontext, GDK_COPY);

      gdk_pixbuf_unref (satsimage);
    }

  return TRUE;

}

void
drawdownloadrectangle (gint big)
{
/*   draw downloadrectangle */
  if (downloadwindowactive)
    {
      gdouble x, y, la, lo;
      gchar longi[100], lat[100], sc[20];
      gint scale, xo, yo;

      strcpy (lat, newmaplat);
      g_strdelimit (lat, ",", '.');
      la = g_strtod (lat, NULL);

      strcpy (longi, newmaplongi);
      g_strdelimit (longi, ",", '.');
      lo = g_strtod (longi, NULL);

      strcpy (sc, newmapsc);
      g_strdelimit (sc, ",", '.');
      scale = g_strtod (sc, NULL);

      gdk_gc_set_foreground (kontext, &yellow);
      gdk_gc_set_function (kontext, GDK_AND);
      gdk_gc_set_line_attributes (kontext, 2, 0, 0, 0);
      if (big)
	{
	  calcxy (&x, &y, lo, la, zoom);
	  xo = 1280.0 * zoom * scale / mapscale;
	  yo = 1024.0 * zoom * scale / mapscale;
	  gdk_draw_rectangle (drawable, kontext, 1, x - xo / 2, y - yo / 2,
			      xo, yo);
	}
      else
	{
	  calcxymini (&x, &y, lo, la, 1);
	  xo = 128.0 * scale / mapscale;
	  yo = 102.0 * scale / mapscale;
	  gdk_draw_rectangle (drawing_miniimage->window, kontext, 1,
			      x - xo / 2, y - yo / 2, xo, yo);
	}

      gdk_gc_set_function (kontext, GDK_COPY);
    }

}

/* draw the marker on the map */
gint
drawmarker (GtkWidget *widget, guint *datum)
{
  gdouble posxdest, posydest, posxmarker, posymarker;
  gchar s2[100], txt[200];
  gdouble w;
  gint16 poly[16], k, i, shownwp = 0;

  gblink = !gblink;
/*    g_print("\nsimmode: %d, nmea %d garmin %d",simmode,haveNMEA,haveGARMIN); */

  if (importactive)
    return TRUE;

  if (drawgrid)
    {

    }
  drawtracks ();
  if (wpflag)
    {
/*  draw waypoints */
      for (i = 0; i < maxwp; i++)
	{
	  calcxy (&posxdest, &posydest, (wayp + i)->longitude,
		  (wayp + i)->lat, zoom);

	  if ((posxdest >= 0) && (posxdest < SCREEN_X)
	      && (shownwp < MAXSHOWNWP))
	    {
	      gdk_gc_set_line_attributes (kontext, 2, 0, 0, 0);

	      if ((posydest >= 0) && (posydest < SCREEN_Y))
		{
		  shownwp++;
		  strcpy (txt, (wayp + i)->name);
		  if ((wayp + i)->wlan > 0)
		    drawwlan (posxdest, posydest, (wayp + i)->wlan);
		  else
		    if ((drawicon (posxdest, posydest, (wayp + i)->typ)) == 0)
		    {
		      if (shadow)
			{
/*  draw shadow of + sign */
			  gdk_gc_set_foreground (kontext, &darkgrey);
			  gdk_gc_set_function (kontext, GDK_AND);
			  gdk_draw_line (drawable, kontext,
					 posxdest + 1 + SHADOWOFFSET,
					 posydest + 1 - 5 + SHADOWOFFSET,
					 posxdest + 1 + SHADOWOFFSET,
					 posydest + 1 + 5 + SHADOWOFFSET);
			  gdk_draw_line (drawable, kontext,
					 posxdest + 1 + 5 + SHADOWOFFSET,
					 posydest + 1 + SHADOWOFFSET,
					 posxdest + 1 - 5 + SHADOWOFFSET,
					 posydest + 1 + SHADOWOFFSET);
			  gdk_gc_set_function (kontext, GDK_COPY);
			}

/*  draw + sign at destination */
		      gdk_gc_set_foreground (kontext, &red);
		      gdk_draw_line (drawable, kontext, posxdest + 1,
				     posydest + 1 - 5, posxdest + 1,
				     posydest + 1 + 5);
		      gdk_draw_line (drawable, kontext, posxdest + 1 + 5,
				     posydest + 1, posxdest + 1 - 5,
				     posydest + 1);
		    }

		  k = gdk_text_width (smalltextfont, txt, strlen (txt));
		  if (shadow)
		    {
/*  draw shadow of text */
		      gdk_gc_set_foreground (kontext, &darkgrey);
		      gdk_gc_set_function (kontext, GDK_AND);
		      gdk_draw_text (drawable, smalltextfont, kontext,
				     posxdest + 13 + SHADOWOFFSET,
				     posydest + 6 + SHADOWOFFSET, txt,
				     strlen (txt));
		      gdk_gc_set_function (kontext, GDK_COPY);
		    }

		  gdk_gc_set_function (kontext, GDK_AND);

		  gdk_gc_set_foreground (kontext, &textback);
		  gdk_draw_rectangle (drawable, kontext, 1, posxdest + 13,
				      posydest - 6, k + 1, 16);
		  gdk_gc_set_function (kontext, GDK_COPY);
		  gdk_gc_set_foreground (kontext, &black);
		  gdk_gc_set_line_attributes (kontext, 1, 0, 0, 0);
		  gdk_draw_rectangle (drawable, kontext, 0, posxdest + 12,
				      posydest - 7, k + 2, 16);

		  gdk_gc_set_foreground (kontext, &yellow);
		  gdk_draw_text (drawable, smalltextfont, kontext,
				 posxdest + 13, posydest + 6, txt,
				 strlen (txt));
		}
	    }
	}
    }

  if (havefriends)
    drawfriends ();

  if (havekismet)
    readkismet ();

/*  draw scale */
  if (zoomscale)
    {
      gint pixels;
      gint m, l;
      gchar txt[100];
      pixels = 141 / milesconv;
      m = mapscale / (20 * zoom);
      if (m < 1000)
	{
	  if (!nauticflag)
	    sprintf (txt, "%d%s", m, (milesflag) ? "yrds" : "m");
	  else
	    sprintf (txt, "%.3f%s", m / 1000.0,
		     (milesflag) ? "mi" : ((metricflag) ? "km" : "nmi"));

	  if (!metricflag)
	    pixels = pixels * milesconv * 0.9144;
	}
      else
	sprintf (txt, "%.1f%s", m / 1000.0,
		 (milesflag) ? "mi" : ((metricflag) ? "km" : "nmi"));
      l =
	(SCREEN_X - 20) - pixels + (pixels -
				    gdk_text_width (smalltextfont, txt,
						    strlen (txt))) / 2;
/*       if (debug) */
/* 	g_print ("%d\n", m); */

      gdk_gc_set_function (kontext, GDK_OR);
      gdk_gc_set_foreground (kontext, &textback);
      gdk_draw_rectangle (drawable, kontext, 1, (SCREEN_X - 20) - pixels - 5,
			  SCREEN_Y - 35, pixels + 10, 30);
      gdk_gc_set_function (kontext, GDK_COPY);

      gdk_gc_set_foreground (kontext, &black);
      gdk_draw_text (drawable, smalltextfont, kontext, l, SCREEN_Y - 20, txt,
		     strlen (txt));
      gdk_gc_set_line_attributes (kontext, 2, 0, 0, 0);
      gdk_draw_line (drawable, kontext, (SCREEN_X - 20) - pixels,
		     SCREEN_Y - 20 + 5, (SCREEN_X - 20), SCREEN_Y - 20 + 5);
      gdk_draw_line (drawable, kontext, (SCREEN_X - 20) - pixels,
		     SCREEN_Y - 20, (SCREEN_X - 20) - pixels,
		     SCREEN_Y - 20 + 10);
      gdk_draw_line (drawable, kontext, (SCREEN_X - 20),
		     SCREEN_Y - 20, (SCREEN_X - 20), SCREEN_Y - 20 + 10);

/*  draw zoom factor */
      sprintf (txt, "%dx", zoom);
      l = (SCREEN_X - 15) - gdk_text_width (textfont, txt, strlen (txt)) / 2;


      gdk_gc_set_function (kontext, GDK_OR);

      gdk_gc_set_foreground (kontext, &mygray);
      gdk_draw_rectangle (drawable, kontext, 1, (SCREEN_X - 30), 0, 30, 30);
      gdk_gc_set_function (kontext, GDK_COPY);

      gdk_gc_set_foreground (kontext, &blue);

      gdk_draw_text (drawable, textfont, kontext, l, 22, txt, strlen (txt));


      if (savetrack)
	{
	  k =
	    gdk_text_width (smalltextfont, savetrackfn, strlen (savetrackfn));
	  gdk_gc_set_foreground (kontext, &white);
	  gdk_draw_rectangle (drawable, kontext, 1, 10,
			      SCREEN_Y - 21, k + 3, 14);
	  gdk_gc_set_foreground (kontext, &red);
	  gdk_draw_text (drawable, smalltextfont, kontext,
			 11, SCREEN_Y - 10, savetrackfn,
			 strlen (savetrackfn));

/*      gdk_draw_text (drawable, textfont, kontext, 10, */
/*  		   SCREEN_Y - 10, savetrackfn, strlen (savetrackfn)); */
	}
    }

  if (posmode)
    {
      blink = TRUE;
    }
#define PFSIZE 55
#define PFSIZE2 45

  if (havepos || blink)
    {
      if (posmode)
	{
	  gdk_gc_set_foreground (kontext, &blue);
	  gdk_gc_set_line_attributes (kontext, 4, 0, 0, 0);
	  gdk_draw_rectangle (drawable, kontext, 0, posx - 10,
			      posy - 10, 20, 20);
	}
      else
	{
	  if (shadow)
	    {
/*  draw shadow of  position marker */
	      gdk_gc_set_foreground (kontext, &darkgrey);
	      gdk_gc_set_line_attributes (kontext, 3, 0, 0, 0);
	      gdk_gc_set_function (kontext, GDK_AND);
	      gdk_draw_arc (drawable, kontext, 0, posx - 7 + SHADOWOFFSET,
			    posy - 7 + SHADOWOFFSET, 14, 14, 0, 360 * 64);
/*  draw pointer to destination */
	      gdk_gc_set_line_attributes (kontext, 4, 0, 0, 0);
/* 	      gdk_draw_line (drawable, kontext, */
/* 			     posx + 4 * sin (angle_to_destination) + */
/* 			     SHADOWOFFSET, */
/* 			     posy - 4 * cos (angle_to_destination) + */
/* 			     SHADOWOFFSET, */
/* 			     posx + 20 * sin (angle_to_destination) + */
/* 			     SHADOWOFFSET, */
/* 			     posy - 20 * cos (angle_to_destination) + */
/* 			     SHADOWOFFSET); */
	      w = angle_to_destination + M_PI;
	      poly[0] =
		posx + SHADOWOFFSET + (PFSIZE) / 2.3 * (cos (w + M_PI_2));
	      poly[1] =
		posy + SHADOWOFFSET + (PFSIZE) / 2.3 * (sin (w + M_PI_2));
	      poly[2] = posx + SHADOWOFFSET + (PFSIZE) / 9 * (cos (w + M_PI));
	      poly[3] = posy + SHADOWOFFSET + (PFSIZE) / 9 * (sin (w + M_PI));
	      poly[4] =
		posx + SHADOWOFFSET + PFSIZE / 10 * (cos (w + M_PI_2));
	      poly[5] =
		posy + SHADOWOFFSET + PFSIZE / 10 * (sin (w + M_PI_2));
	      poly[6] = posx + SHADOWOFFSET - (PFSIZE) / 9 * (cos (w + M_PI));
	      poly[7] = posy + SHADOWOFFSET - (PFSIZE) / 9 * (sin (w + M_PI));
	      poly[8] = poly[0];
	      poly[9] = poly[1];
	      gdk_draw_polygon (drawable, kontext, 1, (GdkPoint *) poly, 5);

/*  draw pointer to direction */
/* 	      gdk_draw_line (drawable, kontext, */
/* 			     posx + 4 * sin (direction) + SHADOWOFFSET, */
/* 			     posy - 4 * cos (direction) + SHADOWOFFSET, */
/* 			     posx + 20 * sin (direction) + SHADOWOFFSET, */
/* 			     posy - 20 * cos (direction) + SHADOWOFFSET); */
	      gdk_gc_set_line_attributes (kontext, 2, 0, 0, 0);
	      gdk_draw_arc (drawable, kontext, 0, posx + 2 - 7 + SHADOWOFFSET,
			    posy + 2 - 7 + SHADOWOFFSET, 10, 10, 0, 360 * 64);

	      w = direction + M_PI;
	      poly[0] =
		posx + SHADOWOFFSET + (PFSIZE2) / 2.3 * (cos (w + M_PI_2));
	      poly[1] =
		posy + SHADOWOFFSET + (PFSIZE2) / 2.3 * (sin (w + M_PI_2));
	      poly[2] =
		posx + SHADOWOFFSET + (PFSIZE2) / 9 * (cos (w + M_PI));
	      poly[3] =
		posy + SHADOWOFFSET + (PFSIZE2) / 9 * (sin (w + M_PI));
	      poly[4] =
		posx + SHADOWOFFSET + PFSIZE2 / 10 * (cos (w + M_PI_2));
	      poly[5] =
		posy + SHADOWOFFSET + PFSIZE2 / 10 * (sin (w + M_PI_2));
	      poly[6] =
		posx + SHADOWOFFSET - (PFSIZE2) / 9 * (cos (w + M_PI));
	      poly[7] =
		posy + SHADOWOFFSET - (PFSIZE2) / 9 * (sin (w + M_PI));
	      poly[8] = poly[0];
	      poly[9] = poly[1];
	      gdk_draw_polygon (drawable, kontext, 0, (GdkPoint *) poly, 5);
	      gdk_gc_set_function (kontext, GDK_COPY);
	    }
/*  draw real position marker */

	  gdk_gc_set_foreground (kontext, &black);
	  gdk_gc_set_line_attributes (kontext, 3, 0, 0, 0);
	  gdk_draw_arc (drawable, kontext, 0, posx - 7, posy - 7, 14,
			14, 0, 360 * 64);
/*  draw pointer to destination */

	  w = angle_to_destination + M_PI;

	  poly[0] = posx + (PFSIZE) / 2.3 * (cos (w + M_PI_2));
	  poly[1] = posy + (PFSIZE) / 2.3 * (sin (w + M_PI_2));
	  poly[2] = posx + (PFSIZE) / 9 * (cos (w + M_PI));
	  poly[3] = posy + (PFSIZE) / 9 * (sin (w + M_PI));
	  poly[4] = posx + PFSIZE / 10 * (cos (w + M_PI_2));
	  poly[5] = posy + PFSIZE / 10 * (sin (w + M_PI_2));
	  poly[6] = posx - (PFSIZE) / 9 * (cos (w + M_PI));
	  poly[7] = posy - (PFSIZE) / 9 * (sin (w + M_PI));
	  poly[8] = poly[0];
	  poly[9] = poly[1];
	  gdk_draw_polygon (drawable, kontext, 1, (GdkPoint *) poly, 5);

/*  draw pointer to direction */
	  gdk_gc_set_foreground (kontext, &red);
	  gdk_draw_arc (drawable, kontext, 0, posx + 2 - 7,
			posy + 2 - 7, 10, 10, 0, 360 * 64);
	  w = direction + M_PI;
	  poly[0] = posx + (PFSIZE2) / 2.3 * (cos (w + M_PI_2));
	  poly[1] = posy + (PFSIZE2) / 2.3 * (sin (w + M_PI_2));
	  poly[2] = posx + (PFSIZE2) / 9 * (cos (w + M_PI));
	  poly[3] = posy + (PFSIZE2) / 9 * (sin (w + M_PI));
	  poly[4] = posx + PFSIZE2 / 10 * (cos (w + M_PI_2));
	  poly[5] = posy + PFSIZE2 / 10 * (sin (w + M_PI_2));
	  poly[6] = posx - (PFSIZE2) / 9 * (cos (w + M_PI));
	  poly[7] = posy - (PFSIZE2) / 9 * (sin (w + M_PI));
	  poly[8] = poly[0];
	  poly[9] = poly[1];
	  gdk_draw_polygon (drawable, kontext, 0, (GdkPoint *) poly, 5);
	}
      if (markwaypoint)
	{
	  calcxy (&posxmarker, &posymarker, wplon, wplat, zoom);

	  gdk_gc_set_foreground (kontext, &green);
	  gdk_gc_set_line_attributes (kontext, 5, 0, 0, 0);
	  gdk_draw_arc (drawable, kontext, 0, posxmarker - 10,
			posymarker - 10, 20, 20, 0, 360 * 64);
	}
/*  If we are in position mode we set direction to zero to see where is the  */
/*  target  */
      if (posmode)
	direction = 0;

      bearing = angle_to_destination - direction;
      if (bearing < 0)
	bearing += 2 * M_PI;
      if (bearing > (2 * M_PI))
	bearing -= 2 * M_PI;
      display_status2 ();

    }


/*  now draw marker for destination point */

  calcxy (&posxdest, &posydest, target_long, target_lat, zoom);

  gdk_gc_set_line_attributes (kontext, 4, 0, 0, 0);
  if (shadow)
    {
/*  draw + sign at destination */
      gdk_gc_set_foreground (kontext, &darkgrey);
      gdk_gc_set_function (kontext, GDK_AND);
      gdk_draw_line (drawable, kontext, posxdest + 1 + SHADOWOFFSET,
		     posydest + 1 - 10 + SHADOWOFFSET,
		     posxdest + 1 + SHADOWOFFSET,
		     posydest + 1 - 2 + SHADOWOFFSET);
      gdk_draw_line (drawable, kontext, posxdest + 1 + SHADOWOFFSET,
		     posydest + 1 + 2 + SHADOWOFFSET,
		     posxdest + 1 + SHADOWOFFSET,
		     posydest + 1 + 10 + SHADOWOFFSET);
      gdk_draw_line (drawable, kontext, posxdest + 1 + 10 + SHADOWOFFSET,
		     posydest + 1 + SHADOWOFFSET,
		     posxdest + 1 + 2 + SHADOWOFFSET,
		     posydest + 1 + SHADOWOFFSET);
      gdk_draw_line (drawable, kontext, posxdest + 1 - 2 + SHADOWOFFSET,
		     posydest + 1 + SHADOWOFFSET,
		     posxdest + 1 - 10 + SHADOWOFFSET,
		     posydest + 1 + SHADOWOFFSET);
      gdk_gc_set_function (kontext, GDK_COPY);
    }

  if (crosstoogle)
    gdk_gc_set_foreground (kontext, &blue);
  else
    gdk_gc_set_foreground (kontext, &red);
  crosstoogle = !crosstoogle;
/*  draw + sign at destination */
  gdk_draw_line (drawable, kontext, posxdest + 1,
		 posydest + 1 - 10, posxdest + 1, posydest + 1 - 2);
  gdk_draw_line (drawable, kontext, posxdest + 1,
		 posydest + 1 + 2, posxdest + 1, posydest + 1 + 10);
  gdk_draw_line (drawable, kontext, posxdest + 1 + 10,
		 posydest + 1, posxdest + 1 + 2, posydest + 1);
  gdk_draw_line (drawable, kontext, posxdest + 1 - 2,
		 posydest + 1, posxdest + 1 - 10, posydest + 1);


/* display messages on map */
  display_dsc ();
/*  if distance is less then 1 km show meters */
  if (milesflag)
    {
      if (dist <= 1.0)
	sprintf (s2, "%4.0fyrds", dist * 1760.0);
      else
	sprintf (s2, "%8.2fmi", dist);
    }
  if (metricflag)
    {
      if (dist <= 1.0)
	sprintf (s2, "%4.0fm", dist * 1000.0);
      else
	sprintf (s2, "%8.2fkm", dist);
    }
  if (nauticflag)
    {
      if (dist <= 1.0)
	sprintf (s2, "%8.3fnmi", dist);
      else
	sprintf (s2, "%8.2fnmi", dist);
    }
/*    display distance, speed and zoom */
  gtk_label_set_text (GTK_LABEL (distlabel), s2);
  if (milesflag)
    sprintf (s2, "%3.1f", groundspeed);
  if (metricflag)
    sprintf (s2, "%3.1f", groundspeed);
  if (nauticflag)
    sprintf (s2, "%3.1f", groundspeed);
  gtk_label_set_text (GTK_LABEL (speedlabel), s2);

  if (havealtitude)
    {
      if (milesflag || nauticflag)
	sprintf (s2, "%.0fft", altitude * 3.2808399);
      else
	sprintf (s2, "%.0fm", altitude);
      gtk_label_set_text (GTK_LABEL (altilabel), s2);
    }
  if (simmode)
    blink = TRUE;
  else
    {
      if (!havepos)
	blink = !blink;
    }

  if (newsatslevel)
    expose_sats_cb (NULL, 0);

  if (downloadwindowactive)
    {
      drawdownloadrectangle (1);
      expose_mini_cb (NULL, 0);
    }

/* force to say new direction */
  if (!strcmp (oldangle, "XXX"))
    speech_out_cb (NULL, 0);

  return (TRUE);
}



gdouble
calcdist2 (gdouble longi, gdouble lati)
{
  double a, a1, a2, c, d, dlon, dlat, sa, radiant = M_PI / 180;
  dlon = radiant * (current_long - longi);
  dlat = radiant * (current_lat - lati);
  a1 = sin (dlat / 2);
  a2 = sin (dlon / 2);
  a =
    (a1 * a1) + cos (lati * radiant) * cos (current_lat * radiant) * a2 * a2;
  sa = sqrt (a);
  if (sa <= 1.0)
    c = 2 * asin (sa);
  else
    c = 2 * asin (1.0);
  d = (Ra[(int) (100 + current_lat)] + Ra[(int) (100 + lati)]) * c / 2.0;
  return milesconv * d / 1000.0;
}

/*  same as calcdist2, but much more precise */
gdouble
calcdist (gdouble longi, gdouble lati)
{
  gdouble a = 6378137.0;
  gdouble f = 1.0 / 298.25722210088;
  gdouble glat1, glat2, glon1, glon2;
  gdouble radiant = M_PI / 180;
  gdouble r, tu1, tu2, cu1, su1, cu2, s, baz, faz, x, sx, cx, sy, cy, y;
  gdouble sa, c2a, cz, e, c, d;
  gdouble eps = 0.5e-13;

  if (slowcpu)
    {
      r = calcdist2 (longi, lati);
      return r;
    }

  glat1 = radiant * current_lat;
  glat2 = radiant * lati;
  glon1 = radiant * current_long;
  glon2 = radiant * longi;

  r = 1.0 - f;
  tu1 = r * sin (glat1) / cos (glat1);
  tu2 = r * sin (glat2) / cos (glat2);
  cu1 = 1.0 / sqrt (tu1 * tu1 + 1.0);
  su1 = cu1 * tu1;

  cu2 = 1.0 / sqrt (tu2 * tu2 + 1.0);
  s = cu1 * cu2;
  baz = s * tu2;
  faz = baz * tu1;
  x = glon2 - glon1;

  do
    {
      sx = sin (x);
      cx = cos (x);
      tu1 = cu2 * sx;
      tu2 = baz - su1 * cu2 * cx;
      sy = sqrt (tu1 * tu1 + tu2 * tu2);

      cy = s * cx + faz;
      y = atan2 (sy, cy);
      sa = s * sx / sy;
      c2a = -sa * sa + 1.0;
      cz = faz + faz;

      if (c2a > 0)
	cz = -cz / c2a + cy;
      e = cz * cz * 2.0 - 1.0;
      c = ((-3.0 * c2a + 4.0) * f + 4.0) * c2a * f / 16.0;
      d = x;

      x = ((e * cy * c + cz) * sy * c + y) * sa;
      x = (1.0 - c) * x * f + glon2 - glon1;
    }
  while (fabs (d - x) > eps);

  faz = atan2 (tu1, tu2);
  baz = atan2 (cu1 * sx, baz * cx - su1 * cu2) + M_PI;
  x = sqrt ((1.0 / r / r - 1.0) * c2a + 1.0) + 1.0;
  x = (x - 2.0) / x;
  c = 1.0 - x;
  c = (x * x / 4.0 + 1.0) / c;
  d = (0.375 * x * x - 1.0) * x;
  x = e * cy;
  s = 1.0 - e - e;
  s =
    ((((sy * sy * 4.0 - 3.0) * s * cz * d / 6.0 - x) * d / 4.0 +
      cz) * sy * d + y) * c * a * r;

  return milesconv * s / 1000.0;
}

/* Copy Image from loaded map */
gint
expose_mini_cb (GtkWidget *widget, guint *datum)
{
/*  draw the minimap */
  if (!miniimage)
    return TRUE;

/*   g_print ("\nin expose_mini_cb"); */
  if (SMALLMENU == 0)
    {
      gdk_pixbuf_render_to_drawable (miniimage, drawing_miniimage->window,
				     kontext, 0, 0, 0, 0, 128, 103,
				     GDK_RGB_DITHER_NONE, 0, 0);
/*       if ((nightmode == 1) || ((nightmode == 2) && (isnight&& !disableisnight)) */
/* 	{ */
/* 	  gdk_gc_set_function (kontext, GDK_AND); */
/* 	  gdk_gc_set_foreground (kontext, &nightcolor); */
/* 	  gdk_draw_rectangle (drawing_miniimage->window, kontext, 1, 0, 0, 128, */
/* 			      103); */
/* 	  gdk_gc_set_function (kontext, GDK_COPY); */
/* 	} */
      gdk_gc_set_foreground (kontext, &red);
      gdk_gc_set_line_attributes (kontext, 1, 0, 0, 0);

      gdk_draw_rectangle (drawing_miniimage->window, kontext, 0,
			  (64 - (SCREEN_X_2 / 10) / zoom) +
			  xoff / (zoom * 10),
			  (50 - (SCREEN_Y_2 / 10) / zoom) +
			  yoff / (zoom * 10), SCREEN_X / (zoom * 10),
			  SCREEN_Y / (zoom * 10));
      drawdownloadrectangle (0);
    }
  return TRUE;
}

gint
expose_compass (GtkWidget *widget, guint *datum)
{
  GdkGC *compasskontext;
  gint l, l2, j;
  gint line_count;
  gchar txt2[10];
  gchar txt[200];
  gdouble w, kurz;
  gint16 poly[16];

/*   This string means North,East,South,West -- translate the letters */
  strcpy (txt2, _("NESW"));

  drawable_bearing = drawing_bearing->window;
  compasskontext = gdk_gc_new (drawable_bearing);

/*  draw bearing arrow */
  gdk_gc_set_line_attributes (kontext, 1, 0, 0, 0);
  gdk_gc_set_foreground (kontext, &lcd);
  gdk_draw_rectangle (drawable_bearing, kontext, 1, 0, 0, PSIZE, PSIZE);
  gdk_gc_set_foreground (kontext, &black);
  gdk_draw_rectangle (drawable_bearing, kontext, 0, 0, 0, PSIZE, PSIZE);


  if (foundradar)
    {
      gdk_gc_set_foreground (kontext, &red);
      gdk_gc_set_line_attributes (kontext, 1, 0, 0, 0);
      w = radarbearing + M_PI;
      if (w < 0)
	w += 2 * M_PI;
      if (w > (2 * M_PI))
	w -= 2 * M_PI;
/*  	  g_print ("\nRadarbearing: %g w: %g", radarbearing, w); */
#define KURZW 1.2
      kurz = cos (KURZW);
      poly[0] = PSIZE / 2 + PSIZE / 2.5 * cos (w);	/* x */
      poly[1] = PSIZE / 2 + PSIZE / 2.5 * sin (w);	/* y */
      poly[2] = PSIZE / 2 + PSIZE / 2 * cos (w + M_PI_2);
      poly[3] = PSIZE / 2 + PSIZE / 2 * sin (w + M_PI_2);
      poly[4] = PSIZE / 2 + PSIZE / 2.5 * cos (w + M_PI);
      poly[5] = PSIZE / 2 + PSIZE / 2.5 * sin (w + M_PI);
      poly[6] = PSIZE / 2 + PSIZE / 2 * kurz * cos (w + M_PI);
      poly[7] = PSIZE / 2 + PSIZE / 2 * kurz * sin (w + M_PI);
      poly[8] = PSIZE / 2 + PSIZE / 2 * cos (w + M_PI + KURZW);
      poly[9] = PSIZE / 2 + PSIZE / 2 * sin (w + M_PI + KURZW);
      poly[10] = PSIZE / 2 + PSIZE / 2 * cos (w + 2 * M_PI - KURZW);
      poly[11] = PSIZE / 2 + PSIZE / 2 * sin (w + 2 * M_PI - KURZW);
      poly[12] = PSIZE / 2 + PSIZE / 2 * kurz * cos (w);
      poly[13] = PSIZE / 2 + PSIZE / 2 * kurz * sin (w);
      poly[14] = poly[0];
      poly[15] = poly[1];
      gdk_draw_polygon (drawable_bearing, kontext, 1, (GdkPoint *) poly, 8);
    }

  gdk_gc_set_foreground (kontext, &black);

/* compass */
//      /* added by zwerg (Daniel Wernle)
  w = -direction + M_PI;
  strcpy (txt, "N");
  j = 0;

  for (line_count = 0; line_count < 12; line_count++)
    {
      gdk_gc_set_foreground (compasskontext, &red);

      if (!(line_count % 3))
	{
	  gdk_gc_set_line_attributes (compasskontext, 2, 0, 0, 0);

	  txt[0] = txt2[j++];
	  l = gdk_text_width (verysmalltextfont, txt, 1);
	  l2 = gdk_text_height (verysmalltextfont, txt, 1);

	  gdk_gc_set_foreground (compasskontext, &darkgrey);

	  gdk_draw_text (drawable_bearing, verysmalltextfont,
			 compasskontext,
			 (PSIZE / 2.0 +
			  (PSIZE) / 3.5 * (cos (w + M_PI_2))) - l / 2,
			 (PSIZE / 2.0 +
			  (PSIZE) / 3.5 * (sin (w + M_PI_2))) + l2 / 2,
			 txt, 1);

	  gdk_gc_set_foreground (compasskontext, &red);

	}
      else
	{
	  gdk_gc_set_foreground (compasskontext, &black);
	  gdk_gc_set_line_attributes (compasskontext, 1, 0, 0, 0);
	}

      gdk_draw_line (drawable_bearing, compasskontext,
		     PSIZE / 2.0 + (PSIZE) / 2.75 * (cos (w + M_PI_2)),
		     PSIZE / 2.0 + (PSIZE) / 2.75 * (sin (w + M_PI_2)),
		     PSIZE / 2.0 + (PSIZE) / 2.0 * (cos (w + M_PI_2)),
		     PSIZE / 2.0 + (PSIZE) / 2.0 * (sin (w + M_PI_2)));

      w = w + M_PI / 6.0;

    }

  w = bearing + M_PI;

#define TRIANGLEFACTOR 0.75
  gdk_gc_set_foreground (compasskontext, &black);

  gdk_gc_set_line_attributes (compasskontext, 1, 0, 0, 0);
  gdk_draw_arc (drawable_bearing, compasskontext, 0, 0, 0, PSIZE, PSIZE,
		0, 360 * 64);

  poly[0] = PSIZE / 2 + (PSIZE) / 2.3 * (cos (w + M_PI_2));
  poly[1] = PSIZE / 2 + (PSIZE) / 2.3 * (sin (w + M_PI_2));
  poly[2] = PSIZE / 2 + (PSIZE) / 9 * (cos (w + M_PI));
  poly[3] = PSIZE / 2 + (PSIZE) / 9 * (sin (w + M_PI));
  poly[4] = PSIZE / 2 + PSIZE / 10 * (cos (w + M_PI_2));
  poly[5] = PSIZE / 2 + PSIZE / 10 * (sin (w + M_PI_2));
  poly[6] = PSIZE / 2 - (PSIZE) / 9 * (cos (w + M_PI));
  poly[7] = PSIZE / 2 - (PSIZE) / 9 * (sin (w + M_PI));
  poly[8] = poly[0];
  poly[9] = poly[1];

  gdk_gc_set_foreground (compasskontext, &black);
  gdk_gc_set_line_attributes (compasskontext, 2, 0, 0, 0);

  gdk_draw_polygon (drawable_bearing, compasskontext, 1,
		    (GdkPoint *) poly, 5);

  gdk_gc_set_foreground (kontext, &black);


// */ von Zwerg eingefgt ende


  return TRUE;

}

/* Copy Image from loaded map */
gint
expose_cb (GtkWidget *widget, guint *datum)
{
  gint x, y, i, oldxoff, oldyoff, xoffmax, yoffmax, ok, okcount;
  gdouble tx, ty, lastangle;
  gchar name[40];

/*   g_print("\nexpose_cb %d",exposecounter++); */

  if (exposed && pdamode)
    return TRUE;

  errortextmode = FALSE;
  if (!importactive)
    {
/*  We don't need to draw anything if there is no map yet */
      if (!maploaded)
	{
	  display_status (_("No map available for this position!"));
/*        return TRUE; */
	}

      if (posmode)
	{
	  current_long = posmode_x;
	  current_lat = posmode_y;
	}


/*  get pos for current position */
      calcxy (&posx, &posy, current_long, current_lat, zoom);
/*  do this because calcxy already substracted xoff and yoff */
      posx = posx + xoff;
      posy = posy + yoff;
/*  Calculate Angle to destination */
      tx =
	(2 * R * M_PI / 360) * cos (M_PI * current_lat / 180.0) *
	(target_long - current_long);
      ty = (2 * R * M_PI / 360) * (target_lat - current_lat);
      lastangle = angle_to_destination;
      angle_to_destination = atan (tx / ty);
/*        g_print ("\ntx: %f, ty:%f angle_to_dest: %f", tx, ty, */
/*  	       angle_to_destination); */
      if (!finite (angle_to_destination))
	angle_to_destination = lastangle;
      else
	{
/*  correct the value to be < 2*PI */
	  if (ty < 0)
	    angle_to_destination = M_PI + angle_to_destination;
	  if (angle_to_destination >= (2 * M_PI))
	    angle_to_destination -= 2 * M_PI;
	  if (angle_to_destination < 0)
	    angle_to_destination += 2 * M_PI;
	}
      if (mydebug)
	g_print ("\nAngle_To_Destination: %.0f",
		 angle_to_destination * 180 / M_PI);

      if (havefriends && targetname[0] == '*')
	for (i = 0; i < maxfriends; i++)
	  {
	    strcpy (name, "*");
	    strcat (name, friendstxt[i]);
	    if ((strcmp (targetname, name)) == 0)
	      {
		target_lat = g_strtod (friendslat[i], NULL);
		target_long = g_strtod (friendslon[i], NULL);
	      }
	  }

/*  Calculate distance to destination */
      dist = calcdist (target_long, target_lat);
/*  correct the shift of the map */
      oldxoff = xoff;
      oldyoff = yoff;
/*  now we test if the marker fits into the map and set the shift of the 
little SCREEN_XxSCREEN_Y region in relation to the real 1280x1024 map */
      okcount = 0;
      do
	{
	  ok = TRUE;
	  okcount++;
	  x = posx - xoff;
	  y = posy - yoff;

	  if (x < borderlimit)
	    xoff -= 2 * borderlimit;
	  if (x > (SCREEN_X - borderlimit))
	    xoff += 2 * borderlimit;
	  if (y < borderlimit)
	    yoff -= 2 * borderlimit;
	  if (y > (SCREEN_Y - borderlimit))
	    yoff += 2 * borderlimit;

	  if (x < borderlimit)
	    ok = FALSE;
	  if (x > (SCREEN_X - borderlimit))
	    ok = FALSE;
	  if (y < borderlimit)
	    ok = FALSE;
	  if (y > (SCREEN_Y - borderlimit))
	    ok = FALSE;
	  if (okcount > 20000)
	    {
	      g_print ("\nloop detected, please report!\n");
	      ok = TRUE;
	    }
	}
      while (!ok);

      xoffmax = (640 * zoom) - SCREEN_X_2;
      yoffmax = (512 * zoom) - SCREEN_Y_2;
      if (xoff > xoffmax)
	xoff = xoffmax;
      if (xoff < -xoffmax)
	xoff = -xoffmax;
      if (yoff > yoffmax)
	yoff = yoffmax;
      if (yoff < -yoffmax)
	yoff = -yoffmax;

/*       if ((xoff - 640) / zoom < -1280) */
/* 	xoff = -1280 * zoom + 640; */
/*       if ((xoff + 640) / zoom > 1280) */
/* 	xoff = 1280 * zoom - 640; */

/*       if ((yoff - 512) / zoom < -1024) */
/* 	yoff = -1024 * zoom + 512; */
/*       if ((yoff + 512) / zoom > 1024) */
/* 	yoff = 1024 * zoom - 512; */

/*  we only need to create a new region if the shift is not changed */
      if ((oldxoff != xoff) || (oldyoff != yoff))
	iszoomed = FALSE;

      if (mydebug)
	g_print ("\nx: %d  xoff: %d oldxoff: %d Zoom: %d xoffmax: %d\n", x,
		 xoff, oldxoff, zoom, xoffmax);
      if (mydebug)
	g_print ("\ny: %d  yoff: %d oldyoff: %d Zoom: %d yoffmax: %d\n", y,
		 yoff, oldyoff, zoom, yoffmax);
      posx = posx - xoff;
      posy = posy - yoff;
    }

/*       if (scroll) */
/*       { */
/* 	  xoff=posx+640; */
/* 	  posx=320; */
/* 	  yoff=posy+512; */
/* 	  posx=256; */
/*       } */


/*  zoom from to 1280x1024 map to the SCREEN_XxSCREEN_Y region */
  if (!iszoomed)
    {
      rebuildtracklist ();

      if (tempimage != NULL)
	gdk_pixbuf_unref (tempimage);

      tempimage = gdk_pixbuf_new (GDK_COLORSPACE_RGB, 0, 8, 1280, 1024);
      if (maploaded)
	gdk_pixbuf_scale (image, tempimage, 0, 0, 1280, 1024,
			  640 - xoff - 640 * zoom,
			  512 - yoff - 512 * zoom, zoom, zoom,
			  GDK_INTERP_BILINEAR);
      if (debug)
	g_print ("\nmap zoomed!\n");
      iszoomed = TRUE;
      expose_mini_cb (NULL, 0);

    }
/*  draw the image */
  gdk_pixbuf_render_to_drawable (tempimage, drawable, kontext,
				 640 - SCREEN_X_2,
				 512 - SCREEN_Y_2, 0, 0,
				 SCREEN_X, SCREEN_Y,
				 GDK_RGB_DITHER_NONE, 0, 0);


  if ((!disableisnight) && (!downloadwindowactive))
    if ((nightmode == 1) || ((nightmode == 2) && isnight))
      {
	gdk_gc_set_function (kontext, GDK_AND);
	gdk_gc_set_foreground (kontext, &nightcolor);
	gdk_draw_rectangle (drawable, kontext, 1, 0, 0, SCREEN_X, SCREEN_Y);
	gdk_gc_set_function (kontext, GDK_COPY);
      }

  drawmarker (0, 0);
  gdk_draw_pixmap (drawing_area->window, kontext, drawable, 0,
		   0, 0, 0, SCREEN_X, SCREEN_Y);
  exposed = TRUE;
  return TRUE;
}

/*  This is called in simulation mode, it moves the position to the  */
/*  selected destination */
gint
simulated_pos (GtkWidget *widget, guint *datum)
{
  gdouble ACCELMAX, ACCEL;
  gdouble secs, tx, ty, lastdirection;


  if (!simfollow)
    return TRUE;

  ACCELMAX = 0.00002 + dist / 30000.0;
  ACCEL = ACCELMAX / 20.0;
  long_diff += ACCEL * sin (angle_to_destination);
  lat_diff += ACCEL * cos (angle_to_destination);
  if (long_diff > ACCELMAX)
    long_diff = ACCELMAX;
  if (long_diff < -ACCELMAX)
    long_diff = -ACCELMAX;
  if (lat_diff > ACCELMAX)
    lat_diff = ACCELMAX;
  if (lat_diff < -ACCELMAX)
    lat_diff = -ACCELMAX;


  current_lat += lat_diff;
  current_long += long_diff;
  secs = g_timer_elapsed (timer, 0);
  if (secs >= 1.0)
    {
      g_timer_stop (timer);
      g_timer_start (timer);
      tx =
	(2 * R * M_PI / 360) * cos (M_PI * current_lat / 180.0) *
	(current_long - old_long);
      ty = (2 * R * M_PI / 360) * (current_lat - old_lat);
#define MINSPEED 1.0
      if (((fabs (tx)) > MINSPEED) || (((fabs (ty)) > MINSPEED)))
	{
	  lastdirection = direction;
	  if (ty == 0)
	    direction = 0.0;
	  else
	    direction = atan (tx / ty);
	  if (!finite (direction))
	    direction = lastdirection;

	  if (ty < 0)
	    direction = M_PI + direction;
	  if (direction >= (2 * M_PI))
	    direction -= 2 * M_PI;
	  if (direction < 0)
	    direction += 2 * M_PI;
	  groundspeed = milesconv * sqrt (tx * tx + ty * ty) * 3.6 / secs;
	}
      else
	groundspeed = 0.0;
      if (groundspeed > 999)
	groundspeed = 999;
      old_lat = current_lat;
      old_long = current_long;
      if (mydebug)
	g_print ("\nTime: %f", secs);
    }

  return TRUE;
}


/*  open serial port or pty master or file for NMEA output */
FILE *
opennmea (const char *name)
{
  struct termios tios;
  FILE *const out = fopen (name, "w");
  if (out == NULL)
    {
      perror (_("can't open NMEA output file"));
      exit (1);
    }

  if (tcgetattr (fileno (out), &tios))
    return out;			/* not a terminal, oh well */

  tios.c_iflag = 0;
  tios.c_oflag = 0;
  tios.c_cflag = CS8 | CLOCAL;
  tios.c_lflag = 0;
  tios.c_cc[VMIN] = 1;
  tios.c_cc[VTIME] = 0;
  cfsetospeed (&tios, B4800);
  tcsetattr (fileno (out), TCSAFLUSH, &tios);
  return out;
}

void
write_nmea_line (const char *line)
{
  int checksum = 0;
  fprintf (nmeaout, "$%s*", line);
  while ('\0' != *line)
    checksum = checksum ^ *line++;
  fprintf (nmeaout, "%02X\r\n", checksum);
  fflush (nmeaout);
}

void
gen_nmea_coord (char *out)
{
  gdouble lat = fabs (current_lat), lon = fabs (current_long);
  sprintf (out, ",%02d%07.5f,%c,%03d%07.5f,%c",
	   (int) floor (lat), 60 * (lat - floor (lat)),
	   (current_lat < 0 ? 'S' : 'N'),
	   (int) floor (lon), 60 * (lon - floor (lon)),
	   (current_long < 0 ? 'W' : 'E'));
}

gint
write_nmea_cb (GtkWidget *widget, guint *datum)
{
  char buffer[80];
  time_t now = time (NULL);
  struct tm *st = gmtime (&now);

  strftime (buffer, sizeof (buffer), "GPGGA,%H%M%S.000", st);
  gen_nmea_coord (buffer + strlen (buffer));
  strcpy (buffer + strlen (buffer), ",1,00,0.0,,M,,,,0000");
  write_nmea_line (buffer);

  strcpy (buffer, "GPGLL");
  gen_nmea_coord (buffer + strlen (buffer));
  strftime (buffer + strlen (buffer), 80, ",%H%M%S.000,A", st);
  write_nmea_line (buffer);

  strftime (buffer, sizeof (buffer), "GPRMC,%H%M%S.000,A", st);
  gen_nmea_coord (buffer + strlen (buffer));
  sprintf (buffer + strlen (buffer), ",%.2f,%.2f",
	   groundspeed / milesconv / 1.852, direction * 180.0 / M_PI);
  strftime (buffer + strlen (buffer), 80, ",%d%m%y,,", st);
  write_nmea_line (buffer);

  sprintf (buffer, "GPVTG,%.2f,T,,M,%.2f,N,%.2f,K",
	   direction * 180.0 / M_PI,
	   groundspeed / milesconv / 1.852, groundspeed / milesconv);
  write_nmea_line (buffer);

  return TRUE;
}


/*  We load the map */
void
loadmap (char *filename)
{
  gchar mappath[600];

  if (maploaded)
    gdk_pixbuf_unref (image);
  strcpy (mappath, mapdir);
  strcat (mappath, filename);
  image = gdk_pixbuf_new_from_file (mappath);
/*   g_print ("\nloaded map: %s", mappath); */
  if (image == NULL)
    {
      GString *error;
      error = g_string_new (NULL);
      g_string_sprintf (error, "\n%s\n%s\n",
			_(" Mapfile could not be loaded:"), mappath);
      error_popup ((gpointer *) error->str);
      g_string_free (error, TRUE);
      maploaded = FALSE;
    }
  else
    {
      expose_cb (NULL, NULL);
      iszoomed = FALSE;
/*        zoom = 1; */
      xoff = yoff = 0;
      rebuildtracklist ();
      maploaded = TRUE;
/*  draw minimap */
      if (miniimage)
	gdk_pixbuf_unref (miniimage);
      miniimage = gdk_pixbuf_new (GDK_COLORSPACE_RGB, 0, 8, 128, 103);
      gdk_pixbuf_scale (image, miniimage, 0, 0, 128, 103,
			0, 0, 0.1, 0.10, GDK_INTERP_TILES);
      expose_mini_cb (NULL, 0);

    }

}


void
loadfriendsicon (void)
{
  gchar mappath[400];

  sprintf (mappath, "%s/%s", DATADIR, "friendsicon.png");
  friendsimage = gdk_pixbuf_new_from_file (mappath);
  if (friendsimage == NULL)
    {
      friendsimage = gdk_pixbuf_new_from_file ("friendsicon.png");
    }
  if (friendsimage == NULL)
    {
      GString *error;
      error = g_string_new (NULL);
      g_string_sprintf (error, "\n%s\n%s\n",
			_(" Friendsicon could not be loaded:"), mappath);
      error_popup ((gpointer *) error->str);
      g_string_free (error, TRUE);
    }
  else
    {
      g_print ("\n%s\n", _("Friendsicon loaded"));
    }
  friendspixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, 1, 8, 37, 37);
  gdk_pixbuf_scale (friendsimage, friendspixbuf, 0, 0, 37, 37,
		    0, 0, 1, 1, GDK_INTERP_BILINEAR);

}

gint
zoom_cb (GtkWidget *widget, guint datum)
{

  if (iszoomed == FALSE)	/* needed to be sure the old zoom is made */
    return TRUE;
  iszoomed = FALSE;
  if (datum == 1)
    {
      if (zoom >= 16)
	{
	  iszoomed = TRUE;
	  return TRUE;
	}
      zoom *= 2;
      xoff *= 2;
      yoff *= 2;
    }
  else
    {
      if (zoom <= 1)
	{
	  zoom = 1;
	  iszoomed = TRUE;
	}
      else
	{
	  zoom /= 2;
	  xoff /= 2;
	  yoff /= 2;
	}
    }
  if (importactive)
    {
      expose_cb (NULL, 0);
      expose_mini_cb (NULL, 0);
    }
  return TRUE;
}


gint
scalerbt_cb (GtkWidget *widget, guint datum)
{
  gint val, oldval, old2val;
  gchar oldfilename[200];

  strcpy (oldfilename, mapfilename);
  val = (GTK_ADJUSTMENT (adj)->value);
  old2val = val;

  do
    {
      oldval = val;
      if (datum == 1)
	{
	  gtk_adjustment_set_value (GTK_ADJUSTMENT (adj), val + 1);
	}
      else
	{
	  gtk_adjustment_set_value (GTK_ADJUSTMENT (adj), val - 1);
	}
      val = (GTK_ADJUSTMENT (adj)->value);

      testnewmap ();
    }
  while (((strcmp (oldfilename, mapfilename)) == 0) && (val != oldval));

  if ((strcmp (oldfilename, mapfilename)) == 0)
    val = old2val;
  gtk_adjustment_set_value (GTK_ADJUSTMENT (adj), val);
  expose_cb (NULL, 0);
  expose_mini_cb (NULL, 0);

  needtosave = TRUE;

  return TRUE;
}


/*  destroy sel_target window */
gint
sel_targetweg_cb (GtkWidget *widget, guint datum)
{
  gtk_timeout_remove (selwptimeout);
  gtk_widget_destroy (GTK_WIDGET (gotowindow));
  setwpactive = FALSE;

  return FALSE;
}

/*  cancel sel_route window */
gint
sel_routecancel_cb (GtkWidget *widget, guint datum)
{
  gchar str[200];

  gtk_widget_destroy (GTK_WIDGET (routewindow));
  sprintf (str, "%s %s", _("Distance to "), targetname);
  gtk_frame_set_label (GTK_FRAME (destframe), str);
  createroute = FALSE;
  routemode = FALSE;
  routepointer = routeitems = 0;
  gtk_widget_set_sensitive (create_route_button, TRUE);
  return FALSE;
}

/*  destroy sel_route window but continue routing*/
gint
sel_routeclose_cb (GtkWidget *widget, guint datum)
{
  gtk_widget_destroy (GTK_WIDGET (routewindow));
  gtk_widget_set_sensitive (create_route_button, TRUE);
  return FALSE;
}

gint
do_route_cb (GtkWidget *widget, guint datum)
{

  gtk_widget_destroy (GTK_WIDGET (routewindow));
  gtk_widget_set_sensitive (create_route_button, TRUE);
  createroute = FALSE;
  routemode = TRUE;
  setroutetarget (NULL, -1);
  return FALSE;
}

gint
dlstatusaway_cb (GtkWidget *widget, guint datum)
{
  downloadwindowactive = downloadactive = FALSE;
  return FALSE;
}

gint
importaway_cb (GtkWidget *widget, guint datum)
{
  importactive = FALSE;
  gtk_widget_destroy (widget);
  strcpy (oldfilename, "XXXXXXXXXXXXXXXXXX");
  return FALSE;
}

/*  cancel button pressed or widget destroy in download_cb */
gint
downloadaway_cb (GtkWidget *widget, guint datum)
{
  downloadwindowactive = downloadactive = FALSE;
  gtk_widget_destroy (widget);
  expose_mini_cb (NULL, 0);
/*    gdk_window_set_cursor (drawing_area->window, 0); */
/*    gdk_cursor_destroy (cursor); */
  return FALSE;
}


gint
testnewwp_cb (GtkWidget *widget, guint datum)
{
  gint e;
  e = kill (datum, 0);
  if (e != 0)
    {
      loadwaypoints ();
      return FALSE;
    }
  return TRUE;
}

gint
dlscale_cb (GtkWidget *widget, guint datum)
{
  gchar *sc, t[100], t2[10];
  gdouble f;

  sc = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (dltext3)->entry));
  f = g_strtod (sc, NULL);

  strcpy (t2, "km");

  if (milesflag)
    strcpy (t2, "mi");
  if (nauticflag)
    strcpy (t2, "nmi");

  sprintf (t, "%.3f x %.3f %s", milesconv * 1.280 * f / PIXELFACT,
	   milesconv * 1.024 * f / PIXELFACT, t2);
  gtk_entry_set_text (GTK_ENTRY (cover), t);
  return TRUE;
}


gint
download_cb (GtkWidget *widget, guint datum)
{
  GtkWidget *mainbox;
  GtkWidget *knopf2, *knopf, *knopf3, *knopf4, *knopf5, *knopf6, *knopf7;
  GtkWidget *table, *knopf8;
  gchar buff[300], mappath[500];
  GList *list = NULL;
  GSList *gr;
  gint i, e;
  struct stat buf;
  gchar scalewanted_str[100];

  for (i = 0; i < 30; i++)
    list = g_list_append (list, slist[i]);
  downloadwindow = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (downloadwindow),
			_("Select coordinates and scale"));
  gtk_container_set_border_width (GTK_CONTAINER (downloadwindow), 5);
  mainbox = gtk_vbox_new (TRUE, 2);
  knopf = gtk_button_new_with_label (_("Download map"));
  gtk_signal_connect (GTK_OBJECT (knopf), "clicked",
		      GTK_SIGNAL_FUNC (downloadsetparm), (gpointer) 1);
  knopf2 = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect_object (GTK_OBJECT (knopf2), "clicked",
			     GTK_SIGNAL_FUNC
			     (downloadaway_cb), GTK_OBJECT (downloadwindow));
  gtk_signal_connect_object (GTK_OBJECT (downloadwindow), "delete_event",
			     GTK_SIGNAL_FUNC (downloadaway_cb),
			     GTK_OBJECT (downloadwindow));
  cover = gtk_entry_new ();
  gtk_editable_set_editable (GTK_EDITABLE (cover), FALSE);
  gtk_signal_connect (GTK_OBJECT (cover), "changed",
		      GTK_SIGNAL_FUNC (downloadsetparm), (gpointer) 0);
  gtk_box_pack_start (GTK_BOX
		      (GTK_DIALOG (downloadwindow)->
		       action_area), knopf, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX
		      (GTK_DIALOG (downloadwindow)->
		       action_area), knopf2, TRUE, TRUE, 2);
  GTK_WIDGET_SET_FLAGS (knopf, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (knopf2, GTK_CAN_DEFAULT);
  table = gtk_table_new (8, 2, FALSE);
  gtk_box_pack_start (GTK_BOX
		      (GTK_DIALOG (downloadwindow)->vbox),
		      table, TRUE, TRUE, 2);
  knopf3 = gtk_label_new (_("Latitude"));
  gtk_table_attach_defaults (GTK_TABLE (table), knopf3, 0, 1, 0, 1);
  knopf4 = gtk_label_new (_("Longitude"));
  gtk_table_attach_defaults (GTK_TABLE (table), knopf4, 0, 1, 1, 2);
  knopf8 = gtk_label_new (_("Map covers"));
  gtk_table_attach_defaults (GTK_TABLE (table), knopf8, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (table), cover, 1, 2, 2, 3);

  knopf5 = gtk_label_new (_("Scale"));
  gtk_table_attach_defaults (GTK_TABLE (table), knopf5, 0, 1, 3, 4);
  knopf6 = gtk_label_new (_("Map file name"));
  gtk_table_attach_defaults (GTK_TABLE (table), knopf6, 0, 1, 4, 5);
  dltext1 = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (dltext1), "changed",
		      GTK_SIGNAL_FUNC (downloadsetparm), (gpointer) 0);

  gtk_table_attach_defaults (GTK_TABLE (table), dltext1, 1, 2, 0, 1);
  sprintf (buff, "%.5f", current_lat);
  if (minsecmode)
    decimaltomin (buff, 1);

  gtk_entry_set_text (GTK_ENTRY (dltext1), buff);
  dltext2 = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (dltext2), "changed",
		      GTK_SIGNAL_FUNC (downloadsetparm), (gpointer) 0);
  gtk_table_attach_defaults (GTK_TABLE (table), dltext2, 1, 2, 1, 2);
  sprintf (buff, "%.5f", current_long);
  if (minsecmode)
    decimaltomin (buff, 0);
  gtk_entry_set_text (GTK_ENTRY (dltext2), buff);
  dltext3 = gtk_combo_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), dltext3, 1, 2, 3, 4);
  gtk_combo_set_popdown_strings (GTK_COMBO (dltext3), (GList *) list);
  sprintf (scalewanted_str, "%d", scalewanted);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (dltext3)->entry),
		      scalewanted_str);
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (dltext3)->entry), "changed",
		      GTK_SIGNAL_FUNC (downloadsetparm), (gpointer) 0);

  dltext4 = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), dltext4, 1, 2, 4, 5);
  gtk_signal_connect (GTK_OBJECT (GTK_COMBO (dltext3)->entry), "changed",
		      GTK_SIGNAL_FUNC (dlscale_cb), 0);
  gtk_signal_connect (GTK_OBJECT (dltext4), "changed",
		      GTK_SIGNAL_FUNC (dlscale_cb), 0);

  radio1 = gtk_radio_button_new_with_label (NULL, "Mapblast server");
  gtk_table_attach_defaults (GTK_TABLE (table), radio1, 0, 1, 5, 6);
  gr = gtk_radio_button_group (GTK_RADIO_BUTTON (radio1));
  radio2 = gtk_radio_button_new_with_label (gr, "Expedia server");
  gtk_table_attach_defaults (GTK_TABLE (table), radio2, 1, 2, 5, 6);
  switch (defaultserver)
    {
    case 0:
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio1), TRUE);
      break;
    case 1:
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio2), TRUE);
      break;
    }
  if (!haveproxy)
    sprintf (buff, "%s", _("You can also select the position\n"
			   "with a mouse click on the map."));
  else
    sprintf (buff, "%s\n\n%s    %s %d", _("You can also select the position\n"
					  "with a mouse click on the map."),
	     _("Using Proxy and port:"), proxy, proxyport);
  knopf7 = gtk_label_new (buff);
  gtk_table_attach_defaults (GTK_TABLE (table), knopf7, 0, 2, 6, 7);
  myprogress = gtk_progress_bar_new ();
  style = gtk_style_copy (gtk_widget_get_style (myprogress));
  style->bg[GTK_STATE_PRELIGHT] = blue;
  style->fg[GTK_STATE_PRELIGHT] = white;
  gtk_widget_set_style (myprogress, style);
  gtk_progress_set_format_string (GTK_PROGRESS (myprogress), "%p%%");
  gtk_progress_set_show_text (GTK_PROGRESS (myprogress), TRUE);
  gtk_progress_bar_update (GTK_PROGRESS_BAR (myprogress), 0.0);
  gtk_table_attach_defaults (GTK_TABLE (table), myprogress, 0, 2, 7, 8);
  gtk_label_set_justify (GTK_LABEL (knopf6), GTK_JUSTIFY_RIGHT);
  gtk_label_set_justify (GTK_LABEL (knopf3), GTK_JUSTIFY_RIGHT);
  gtk_label_set_justify (GTK_LABEL (knopf4), GTK_JUSTIFY_RIGHT);
  gtk_label_set_justify (GTK_LABEL (knopf5), GTK_JUSTIFY_RIGHT);
  gtk_label_set_justify (GTK_LABEL (knopf6), GTK_JUSTIFY_RIGHT);
  i = 0;
  do
    {
      if (mapdir[strlen (mapdir) - 1] != '/')
	strcat (mapdir, "/");

      strcpy (mappath, mapdir);

      sprintf (downloadfilename, "%smap_file%04d.gif", mappath, i++);
      e = stat (downloadfilename, &buf);
    }
  while (e == 0);
  sprintf (buff, "map_file%04d.gif", i - 1);
  gtk_entry_set_text (GTK_ENTRY (dltext4), buff);
  gtk_window_set_default (GTK_WINDOW (downloadwindow), knopf);
  gtk_window_set_transient_for (GTK_WINDOW (downloadwindow),
				GTK_WINDOW (mainwindow));
  gtk_window_set_position (GTK_WINDOW (downloadwindow), GTK_WIN_POS_CENTER);
  gtk_widget_show_all (downloadwindow);
  downloadwindowactive = TRUE;
  downloadsetparm (NULL, 0);

/*    cursor = gdk_cursor_new (GDK_CROSS); */
/*    gdk_window_set_cursor (drawing_area->window, cursor); */
  return TRUE;
}

gint
downloadsetparm (GtkWidget *widget, guint datum)
{
  gchar *s, longi[100], lat[100], hostname[100], *sc;
  gdouble f, nlongi;
  gint ns;

  if (!downloadwindowactive)
    return TRUE;

  if (GTK_TOGGLE_BUTTON (radio2)->active)
    expedia = TRUE;
  else
    expedia = FALSE;

  s = gtk_entry_get_text (GTK_ENTRY (dltext1));
  strcpy (lat, s);
  checkinput (lat);
  strcpy (newmaplat, lat);
  g_strdelimit (lat, ",", '.');
  s = gtk_entry_get_text (GTK_ENTRY (dltext2));
  strcpy (longi, s);
  checkinput (longi);
  nlongi = g_strtod (longi, NULL);

  strcpy (newmaplongi, longi);
  g_strdelimit (longi, ",", '.');
  sc = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (dltext3)->entry));

  strcpy (newmapsc, sc);

/*   g_print ("\nnewmaplat: %s, newmaplongi: %s newmapsc: %s", newmaplat, */
/* 	   newmaplongi, newmapsc); */

  if (datum == 0)
    return TRUE;
  sprintf (hostname, "%s", (expedia) ? WEBSERVER2 : WEBSERVER);

  if (expedia)
    {
      f = g_strtod (sc, NULL);
      ns = f / EXPEDIAFACT;
      sprintf (sc, "%d", ns);
      sprintf (newmapsc, "%d", (int) (ns * EXPEDIAFACT));
    }

/*   new URL (08/28/2002) */
/* http://www.mapblast.com/myblastd/MakeMap.d?&CT=48.0:12.2:100000&IC=&W=1280&H=1024&FAM=myblast&LB= */


  if (!expedia)
    sprintf (writebuff,
	     "GET http://%s/myblastd/MakeMap.d?&CT=%s%%3A%s%%3A%s&IC=&W=1280&H=1024&LB= HTTP/1.0\r\nUser-Agent: Wget/1.6\r\nHost: %s\r\nAccept: */*\r\nConnection: Keep-Alive\r\n\r\n",
	     WEBSERVER, lat, longi, sc, hostname);
  else
    {
      if (nlongi > (-30))
	sprintf (writebuff,
		 "GET http://%s/isapi/MSMap.dll?ID=3XNsF.&C=%s,%s&L=EUR0809&CV=1&A=%s&S=1280,1024&O=0.000000,0.000000&MS=0&P=|5748| HTTP/1.1\r\nUser-Agent: Wget/1.6\r\nHost: %s\r\nAccept: */*\r\nConnection: Keep-Alive\r\n\r\n",
		 WEBSERVER2, lat, longi, sc, hostname);
      else
	sprintf (writebuff,
		 "GET http://%s/isapi/MSMap.dll?ID=3XNsF.&C=%s,%s&L=USA0409&CV=1&A=%s&S=1280,1024&O=0.000000,0.000000&MS=0&P=|5748| HTTP/1.1\r\nUser-Agent: Wget/1.6\r\nHost: %s\r\nAccept: */*\r\n\r\n",
		 WEBSERVER2, lat, longi, sc, hostname);
    }
  if (debug)
    g_print ("\nDownload URL: %s\n", writebuff);
  downloadstart_cb (widget, 0);
  return TRUE;
}



gint
downloadstart_cb (GtkWidget *widget, guint datum)
{
  struct sockaddr_in server;
  struct hostent *server_data;
  gchar str[100], sn[1000];


  downloadfilelen = 0;
  downloadactive = TRUE;
  sprintf (str, _("Connecting to %s"), (expedia) ? WEBSERVER2 : WEBSERVER);
  gtk_statusbar_pop (GTK_STATUSBAR (status), statusid);
  gtk_statusbar_push (GTK_STATUSBAR (status), statusid, str);
  while (gtk_events_pending ())
    gtk_main_iteration ();
/*  open socket to port80 */
  if ((dlsock = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror (_("can't open socket for port 80"));
      sprintf (str, _("Connecting to %s FAILED!"),
	       (expedia) ? WEBSERVER2 : WEBSERVER);
      gtk_statusbar_pop (GTK_STATUSBAR (status), statusid);
      gtk_statusbar_push (GTK_STATUSBAR (status), statusid, str);
      gtk_widget_destroy (downloadwindow);
      gtk_timeout_add (6000, (GtkFunction) dlstatusaway_cb, widget);
      return (FALSE);
    }

  server.sin_family = AF_INET;
/*  We retrieve the IP address of the server from its name: */
  if (haveproxy)
    strcpy (sn, proxy);
  else
    strcpy (sn, (expedia) ? WEBSERVER2 : WEBSERVER);

  if ((server_data = gethostbyname (sn)) == NULL)
    {
      perror (_("Can't resolve webserver address"));
      sprintf (str, _("Connecting to %s FAILED!"),
	       (expedia) ? WEBSERVER2 : WEBSERVER);
      gtk_statusbar_pop (GTK_STATUSBAR (status), statusid);
      gtk_statusbar_push (GTK_STATUSBAR (status), statusid, str);
      gtk_widget_destroy (downloadwindow);
      gtk_timeout_add (3000, (GtkFunction) dlstatusaway_cb, widget);
      return (FALSE);
    }
  memcpy (&server.sin_addr, server_data->h_addr, server_data->h_length);
  server.sin_port = htons (proxyport);
/*  We initiate the connection  */
  if (connect (dlsock, (struct sockaddr *) &server, sizeof server) < 0)
    {
      perror (_("unable to connect to Website"));
      sprintf (str, _("Connecting to %s FAILED!"),
	       (expedia) ? WEBSERVER2 : WEBSERVER);
      gtk_statusbar_pop (GTK_STATUSBAR (status), statusid);
      gtk_statusbar_push (GTK_STATUSBAR (status), statusid, str);
      gtk_widget_destroy (downloadwindow);
      gtk_timeout_add (3000, (GtkFunction) dlstatusaway_cb, widget);
      return (FALSE);
    }

#define LOCALTESTSTRINGXXX
#ifdef LOCALTESTSTRING
  sprintf (writebuff,
	   "GET /apollo17.gif HTTP/1.0\nUser-Agent: Wget/1.6\nHost: wuffi.grazforyou.at\nAccept:*/*\n\n");
#endif
  write (dlsock, writebuff, strlen (writebuff));
  dlbuff = g_new0 (gchar, 8192);
  dlpstart = NULL;
  dldiff = dlcount = 0;
  sprintf (str, _("Now connected to %s"), (expedia) ? WEBSERVER2 : WEBSERVER);
  gtk_statusbar_pop (GTK_STATUSBAR (status), statusid);
  gtk_statusbar_push (GTK_STATUSBAR (status), statusid, str);
  gtk_timeout_add (100, (GtkFunction) downloadslave_cb, widget);
  return TRUE;
}

gint
downloadslave_cb (GtkWidget *widget, guint datum)
{
  gchar tmpbuff[9000], str[100], *p;
  gint e, fd;
  gchar nn[] = "\r\n\r\n";
  gdouble f;
  gchar *s;

  if (!downloadwindowactive)
    return FALSE;
  FD_ZERO (&readmask);
  FD_SET (dlsock, &readmask);
  timeout.tv_sec = 0;
  timeout.tv_usec = 100000;
  if (select (FD_SETSIZE, &readmask, NULL, NULL, &timeout) < 0)
    {
      perror ("select() call");
    }

  if (FD_ISSET (dlsock, &readmask))
    {

      memset (tmpbuff, 0, 8192);
      if ((e = read (dlsock, tmpbuff, 8000)) < 0)
	perror (_("read from Webserver"));
      if (debug)
	g_print ("\nLoaded %d Bytes\n", e);
      if (e > 0)
	{
/*  in dlbuff we have all download data */
	  memcpy ((dlbuff + dlcount), tmpbuff, e);
/*  in dlcount we have the number of download bytes */
	  dlcount += e;
/* now we try to get the filelength and begin of the gif image data */
	  if (dlpstart == NULL)
	    {
/*  CONTENT-LENGTH string should hopefully be in the first 4kB */
	      memcpy (tmpbuff, dlbuff, 4096);
/*  We make of this a null terminated string */
	      tmpbuff[4096] = 0;
	      g_strup (tmpbuff);
	      p = strstr (tmpbuff, "CONTENT-LENGTH:");
	      if (p != NULL)
		{
		  sscanf (p, "%s %d", str, &downloadfilelen);
/*  now we look for 2 cr/lf which is the end of the header */
		  dlpstart = strstr (tmpbuff, nn);
		  dldiff = dlpstart - tmpbuff + 4;
/* 		  g_print ("\ncontent-length: %d", downloadfilelen); */
		}
	      else if (dlcount > 1000)
		{
/*  Seems there is no CONTENT-LENGTH field in expedia.com*/
		  dlpstart = strstr (tmpbuff, nn);
		  dldiff = dlpstart - tmpbuff + 4;
		  downloadfilelen = 200000;
/* 		  g_print ("\ncontent-length: %d", downloadfilelen); */
		}
	    }
/*  Now we have the length and begin of the gif image data */
	  if ((downloadfilelen != 0) && (dlpstart != NULL))
	    {
	      dlbuff = g_renew (gchar, dlbuff, dlcount + 8192);
	      f = (dlcount - dldiff) / (gdouble) downloadfilelen;
	      if (f > 1.0)
		f = 1.0;
	      gtk_progress_bar_update (GTK_PROGRESS_BAR (myprogress), f);
	      sprintf (str, _("Downloaded %d kBytes"),
		       (dlcount - dldiff) / 1024);
	      gtk_statusbar_pop (GTK_STATUSBAR (status), statusid);
	      gtk_statusbar_push (GTK_STATUSBAR (status), statusid, str);
	      while (gtk_events_pending ())
		gtk_main_iteration ();
	    }

	}
      if ((e == 0) || ((downloadfilelen + dldiff) == dlcount))
	{
	  if (downloadfilelen == 0)
	    sprintf (str, _("Download FAILED!"));
	  else
	    sprintf (str, _("Download finished, got %dkB"), dlcount / 1024);
	  gtk_statusbar_pop (GTK_STATUSBAR (status), statusid);
	  gtk_statusbar_push (GTK_STATUSBAR (status), statusid, str);
	  close (dlsock);
	  if (downloadfilelen != 0)
	    {
	      s = gtk_entry_get_text (GTK_ENTRY (dltext4));
	      if (mapdir[strlen (mapdir) - 1] != '/')
		strcat (mapdir, "/");

	      strcpy (downloadfilename, mapdir);

	      strcat (downloadfilename, s);
	      fd = open (downloadfilename, O_RDWR | O_TRUNC | O_CREAT, 0644);
	      if (fd < 1)
		{
		  perror (downloadfilename);
		  gtk_timeout_add (3000, (GtkFunction) dlstatusaway_cb,
				   widget);
		  return FALSE;
		}
	      write (fd, dlbuff + dldiff, dlcount - dldiff);
	      close (fd);
/* 	      g_free (maps); */
	      loadmapconfig ();
	      maps = g_renew (mapsstruct, maps, (nrmaps + 2));
	      strcpy ((maps + nrmaps)->filename,
		      g_basename (downloadfilename));
	      (maps + nrmaps)->lat = g_strtod (newmaplat, NULL);
	      (maps + nrmaps)->longitude = g_strtod (newmaplongi, NULL);
	      (maps + nrmaps)->scale = strtol (newmapsc, NULL, 0);
	      nrmaps++;
	      savemapconfig ();
	    }
	  downloadwindowactive = FALSE;
	  gtk_widget_destroy (downloadwindow);
	  gtk_timeout_add (3000, (GtkFunction) dlstatusaway_cb, widget);
	  return FALSE;
	}
    }
  else
    return TRUE;
  return TRUE;
}

gint
import2_cb (GtkWidget *widget, gpointer datum)
{
  gchar *s;

  s = gtk_entry_get_text (GTK_ENTRY (dltext1));
  checkinput (s);
  imports[0].lat = g_strtod (s, NULL);
  s = gtk_entry_get_text (GTK_ENTRY (dltext2));
  checkinput (s);
  imports[0].lon = g_strtod (s, NULL);
  s = gtk_entry_get_text (GTK_ENTRY (dltext5));
  imports[0].x = strtol (s, NULL, 0);
  s = gtk_entry_get_text (GTK_ENTRY (dltext6));
  imports[0].y = strtol (s, NULL, 0);

  gtk_widget_destroy (widget);
  import1_cb (NULL, 2);
  return TRUE;
}

gint
import3_cb (GtkWidget *widget, gpointer datum)
{
  gchar *s;
  gdouble tx, ty, scale, latmax, latmin, latcenter, longmax, longmin;
  gdouble longcenter;
  gdouble px, py;

  s = gtk_entry_get_text (GTK_ENTRY (dltext1));
  checkinput (s);
  imports[1].lat = g_strtod (s, NULL);
  s = gtk_entry_get_text (GTK_ENTRY (dltext2));
  checkinput (s);
  imports[1].lon = g_strtod (s, NULL);
  s = gtk_entry_get_text (GTK_ENTRY (dltext5));
  imports[1].x = strtol (s, NULL, 0);
  s = gtk_entry_get_text (GTK_ENTRY (dltext6));
  imports[1].y = strtol (s, NULL, 0);
  gtk_widget_destroy (widget);

/*  Calc coordinates and scale */

  tx =
    (2 * R * M_PI / 360) * cos (M_PI * imports[0].lat / 180.0) *
    (imports[0].lon - imports[1].lon);
  ty = (2 * R * M_PI / 360) * (imports[0].lat - imports[1].lat);
/*  ty is meter */
  px = abs (imports[0].x - imports[1].x);
  py = abs (imports[0].y - imports[1].y);
  if (px > py)
    scale = fabs (tx) * PIXELFACT / px;
  else
    scale = fabs (ty) * PIXELFACT / py;
  px = imports[0].x - imports[1].x;
  py = imports[0].y - imports[1].y;
  py = -py;

  latmin =
    imports[0].lat - (imports[0].lat - imports[1].lat) * (1024 -
							  imports[0].y) / py;
  latmax = latmin + (imports[0].lat - imports[1].lat) * 1024.0 / py;
  latcenter = (latmax + latmin) / 2.0;

  longmin =
    imports[0].lon - imports[0].x * (imports[0].lon - imports[1].lon) / px;

  longmax = longmin + 1280.0 * (imports[0].lon - imports[1].lon) / px;
  longcenter = (longmax + longmin) / 2.0;

  if (debug)
    g_print
      ("\nImport: scale: %g, latmitte: %g, latmin: %g, "
       "latmax: %g\n longmin: %g, longmax: %g, longmitte: %g\n",
       scale, latcenter, latmin, latmax, longmin, longmax, longcenter);

  if (strlen (importfilename) > 4)
    {
      maps = g_renew (mapsstruct, maps, (nrmaps + 2));
      strcpy ((maps + nrmaps)->filename, importfilename);
      (maps + nrmaps)->lat = latcenter;
      (maps + nrmaps)->longitude = longcenter;
      (maps + nrmaps)->scale = scale;
      nrmaps++;
      savemapconfig ();
    }

  importactive = FALSE;
  strcpy (oldfilename, "XXXAFHSGFAERGXXXXXX");
  return TRUE;
}


gint
nimmfile (GtkWidget *widget, gpointer datum)
{
  gchar *buf;

  buf = gtk_file_selection_get_filename (datum);
  gtk_entry_set_text (GTK_ENTRY (dltext7), g_basename (buf));
  strcpy (importfilename, g_basename (buf));

  gtk_widget_destroy (datum);
  loadmap (g_basename (buf));
  return (TRUE);
}

gint
importfb_cb (GtkWidget *widget, guint datum)
{
  GtkWidget *fdialog;
  gchar buf[1000];
  fdialog = gtk_file_selection_new (_("Select a map file"));
  gtk_window_set_modal (GTK_WINDOW (fdialog), TRUE);

  gtk_signal_connect (GTK_OBJECT
		      (GTK_FILE_SELECTION (fdialog)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (nimmfile),
		      GTK_OBJECT (fdialog));
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION (fdialog)->
			      cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (fdialog));


  strcpy (buf, homedir);
  strcat (buf, "");
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), buf);
  gtk_widget_show (fdialog);
  xoff = 0;
  yoff = 0;
  zoom = 1;
  iszoomed = FALSE;

  return TRUE;
}


gint
importshift_cb (GtkWidget *widget, guint datum)
{
  switch (datum)
    {
    case 1:
      yoff -= SCREEN_Y_2;
      break;
    case 4:
      yoff += SCREEN_Y_2;
      break;
    case 2:
      xoff -= SCREEN_X_2;
      break;
    case 3:
      xoff += SCREEN_X_2;
      break;
    }
  iszoomed = FALSE;
  expose_cb (NULL, 0);
  expose_mini_cb (NULL, 0);

  return TRUE;
}


gint
import1_cb (GtkWidget *widget, guint datum)
{
  GtkWidget *mainbox, *window;
  GtkWidget *knopf2, *knopf, *knopf3, *knopf4, *knopf6;
  GtkWidget *table, *knopf9, *knopf10, *knopf11, *s1, *s2, *s3, *s4;
  GtkWidget *s5, *s6;
  gchar buff[300];
  GtkWidget *text;
  GtkWidget *scrollbar;
  GtkWidget *hbox;
  gchar *thetext1 = _("How to calibrate your own maps?\n\n"
		      "First, the map file must be copied into the ~/.gpsdrive"
		      " directory as .gif, .jpg or .png file "
		      "and must have the size 1280x1024. The file names must be "
		      "map_* for street maps or top_* for topographical maps!"
		      "\nLoad the file, select coordinates\n"
		      "from waypoint list or type them in.\n"
		      "Then click on the accept button.");
  gchar *thetext2 =
    _("Now do the same for your second point and click on the "
      "finish button. The map can be used now.");

  window = gtk_dialog_new ();
  if (datum == 1)
    gtk_window_set_title (GTK_WINDOW (window), _("Import Assistant. Step 1"));
  else
    gtk_window_set_title (GTK_WINDOW (window), _("Import Assistant. Step 2"));

  gtk_container_set_border_width (GTK_CONTAINER (window), 5);
  mainbox = gtk_vbox_new (TRUE, 2);
  if (datum == 1)
    knopf = gtk_button_new_with_label (_("Accept first point"));
  else
    knopf = gtk_button_new_with_label (_("Finish"));
  if (datum == 1)
    gtk_signal_connect_object (GTK_OBJECT (knopf), "clicked",
			       GTK_SIGNAL_FUNC (import2_cb),
			       GTK_OBJECT (window));
  else
    {
      gtk_signal_connect_object (GTK_OBJECT (knopf), "clicked",
				 GTK_SIGNAL_FUNC (import3_cb),
				 GTK_OBJECT (window));
    }

  knopf2 = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect_object (GTK_OBJECT (knopf2), "clicked",
			     GTK_SIGNAL_FUNC
			     (importaway_cb), GTK_OBJECT (window));
  gtk_signal_connect_object (GTK_OBJECT (window),
			     "delete_event",
			     GTK_SIGNAL_FUNC
			     (importaway_cb), GTK_OBJECT (window));

  s1 = gtk_button_new_with_label (_("Go up"));
  gtk_signal_connect (GTK_OBJECT (s1), "clicked",
		      GTK_SIGNAL_FUNC (importshift_cb), (gpointer) 1);
  s2 = gtk_button_new_with_label (_("Go left"));
  gtk_signal_connect (GTK_OBJECT (s2), "clicked",
		      GTK_SIGNAL_FUNC (importshift_cb), (gpointer) 2);
  s3 = gtk_button_new_with_label (_("Go right"));
  gtk_signal_connect (GTK_OBJECT (s3), "clicked",
		      GTK_SIGNAL_FUNC (importshift_cb), (gpointer) 3);
  s4 = gtk_button_new_with_label (_("Go down"));
  gtk_signal_connect (GTK_OBJECT (s4), "clicked",
		      GTK_SIGNAL_FUNC (importshift_cb), (gpointer) 4);
  s5 = gtk_button_new_with_label (_("Zoom in"));
  gtk_signal_connect (GTK_OBJECT (s5), "clicked",
		      GTK_SIGNAL_FUNC (zoom_cb), (gpointer) 1);
  s6 = gtk_button_new_with_label (_("Zoom out"));
  gtk_signal_connect (GTK_OBJECT (s6), "clicked",
		      GTK_SIGNAL_FUNC (zoom_cb), (gpointer) 2);

  gtk_box_pack_start (GTK_BOX
		      (GTK_DIALOG (window)->
		       action_area), knopf, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX
		      (GTK_DIALOG (window)->
		       action_area), knopf2, TRUE, TRUE, 2);
  GTK_WIDGET_SET_FLAGS (knopf, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (knopf2, GTK_CAN_DEFAULT);
  table = gtk_table_new (6, 4, TRUE);
  gtk_box_pack_start (GTK_BOX
		      (GTK_DIALOG (window)->vbox), table, TRUE, TRUE, 2);
  knopf3 = gtk_label_new (_("Latitude"));
  gtk_table_attach_defaults (GTK_TABLE (table), knopf3, 0, 1, 0, 1);
  knopf4 = gtk_label_new (_("Longitude"));
  gtk_table_attach_defaults (GTK_TABLE (table), knopf4, 0, 1, 1, 2);
  knopf9 = gtk_label_new (_("Screen X"));
  gtk_table_attach_defaults (GTK_TABLE (table), knopf9, 2, 3, 0, 1);
  knopf10 = gtk_label_new (_("Screen Y"));
  gtk_table_attach_defaults (GTK_TABLE (table), knopf10, 2, 3, 1, 2);
  knopf6 = gtk_button_new_with_label (_("Browse waypoint"));
  gtk_signal_connect (GTK_OBJECT (knopf6), "clicked",
		      GTK_SIGNAL_FUNC (sel_target_cb), (gpointer) 1);

  gtk_table_attach_defaults (GTK_TABLE (table), knopf6, 0, 1, 2, 3);
  dltext1 = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), dltext1, 1, 2, 0, 1);
  sprintf (buff, "%.5f", current_lat);
  if (minsecmode)
    decimaltomin (buff, 1);
  gtk_entry_set_text (GTK_ENTRY (dltext1), buff);
  dltext2 = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), dltext2, 1, 2, 1, 2);
  sprintf (buff, "%.5f", current_long);
  if (minsecmode)
    decimaltomin (buff, 0);
  gtk_entry_set_text (GTK_ENTRY (dltext2), buff);

  dltext5 = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), dltext5, 3, 4, 0, 1);

  dltext6 = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), dltext6, 3, 4, 1, 2);

  dltext4 = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), dltext4, 1, 2, 2, 3);
  dltext7 = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), dltext7, 3, 4, 2, 3);

  if (datum == 1)
    {
      knopf11 = gtk_button_new_with_label (_("Browse filename"));
      gtk_signal_connect_object (GTK_OBJECT (knopf11), "clicked",
				 GTK_SIGNAL_FUNC (importfb_cb), 0);
      gtk_table_attach_defaults (GTK_TABLE (table), knopf11, 2, 3, 2, 3);
    }
  else
    gtk_entry_set_text (GTK_ENTRY (dltext7), importfilename);


  gtk_entry_set_editable (GTK_ENTRY (dltext7), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (dltext4), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (dltext5), FALSE);
  gtk_entry_set_editable (GTK_ENTRY (dltext6), FALSE);
  text = gtk_text_new (NULL, NULL);
  gtk_widget_set_usize (text, 100, 80);
  gtk_text_set_line_wrap (GTK_TEXT (text), TRUE);
  gtk_text_set_word_wrap (GTK_TEXT (text), TRUE);
  scrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);
  if (datum == 1)
    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, thetext1, -1);
  else
    gtk_text_insert (GTK_TEXT (text), NULL, NULL, NULL, thetext2, -1);

  hbox = gtk_hbox_new (FALSE, 3);
  gtk_box_pack_start (GTK_BOX (hbox), text, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), scrollbar, FALSE, FALSE, 0);

  gtk_table_attach_defaults (GTK_TABLE (table), hbox, 2, 4, 3, 6);
  gtk_table_attach_defaults (GTK_TABLE (table), s1, 0, 1, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (table), s5, 1, 2, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (table), s2, 0, 1, 4, 5);
  gtk_table_attach_defaults (GTK_TABLE (table), s3, 1, 2, 4, 5);
  gtk_table_attach_defaults (GTK_TABLE (table), s4, 0, 1, 5, 6);
  gtk_table_attach_defaults (GTK_TABLE (table), s6, 1, 2, 5, 6);
  gtk_table_set_row_spacings (GTK_TABLE (table), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table), 3);
/*    gtk_label_set_justify (GTK_LABEL (knopf6), GTK_JUSTIFY_RIGHT); */
/*    gtk_label_set_justify (GTK_LABEL (knopf3), GTK_JUSTIFY_RIGHT); */
/*    gtk_label_set_justify (GTK_LABEL (knopf4), GTK_JUSTIFY_RIGHT); */
/*    gtk_label_set_justify (GTK_LABEL (knopf6), GTK_JUSTIFY_RIGHT); */
  gtk_window_set_default (GTK_WINDOW (window), knopf);
  gtk_window_set_transient_for (GTK_WINDOW (window), GTK_WINDOW (mainwindow));
  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  gtk_widget_show_all (window);
  importactive = TRUE;

  return TRUE;
}

gint
setup2_cb (GtkWidget *widget, guint datum)
{
  gtk_widget_destroy (GTK_WIDGET (datum));
  return TRUE;
}

gint
wpfileselect_cb (GtkWidget *widget, guint datum)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (setupfn[datum])))
    if ((strcmp (activewpfile, (names + datum)->n)))
      {
	strcpy (activewpfile, (names + datum)->n);
	if (debug)
	  g_print ("\nactivewpfile: %s", activewpfile);
	loadwaypoints ();
	iszoomed = FALSE;
      }
  needtosave = TRUE;
  return TRUE;
}


gint
setup_cb (GtkWidget *widget, guint datum)
{
  GtkWidget *notebook, *vbox, *window, *cancel;
  gint i;

  mainsetup ();
  infos ();
  trip ();

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), _("GpsDrive Control"));
  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  cancel = gtk_button_new_with_label (_("Close"));
  GTK_WIDGET_SET_FLAGS (cancel, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (window), cancel);
/*   GTK_WIDGET_SET_FLAGS (cancel, GTK_HAS_FOCUS); */


  gtk_signal_connect ((GTK_OBJECT (window)), "delete_event",
		      GTK_SIGNAL_FUNC (removesetutc), 0);

  gtk_signal_connect_object ((GTK_OBJECT (window)), "delete_event",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (window));
  gtk_signal_connect ((GTK_OBJECT (cancel)), "clicked",
		      GTK_SIGNAL_FUNC (removesetutc), 0);

  gtk_signal_connect_object ((GTK_OBJECT (cancel)), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (window));

  gtk_container_border_width (GTK_CONTAINER (window), 2 * PADDING);
  vbox = gtk_vbox_new (FALSE, 2 * PADDING);
/*     table = gtk_table_new(2,1,TRUE); */
  gtk_container_add (GTK_CONTAINER (window), vbox);
  /* Create a new notebook, place the position of the tabs */
  settingsnotebook = notebook = gtk_notebook_new ();
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
/*     gtk_table_attach_defaults(GTK_TABLE(table), notebook, 0,1,0,1); */
  gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 2 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), cancel, FALSE, FALSE, 2 * PADDING);

  gtk_widget_show (notebook);
/*   g_print("\nmod_setupcounter: %d",mod_setupcounter); */
  for (i = 0; i <= mod_setupcounter; i++)
    {
      if (i > 3)
	setupfunction[i] ();

      gtk_widget_show_all (setupentry[i]);
      gtk_notebook_append_page (GTK_NOTEBOOK (notebook), setupentry[i],
				setupentrylabel[i]);
    }
  gtk_notebook_set_page (GTK_NOTEBOOK (notebook), lastnotebook);
  gtk_widget_show_all (window);

  return TRUE;
}



/*  switching between kilometers and miles */
gint
miles_cb (GtkWidget *widget, guint datum)
{
  gchar s1[80];
/*      1=miles, 2=metric, 3=nautic */
  switch (datum)
    {
    case 1:
      milesconv = KM2MILES;
      milesflag = TRUE;
      nauticflag = FALSE;
      metricflag = FALSE;
      break;
    case 2:
      milesconv = 1.0;
      milesflag = FALSE;
      nauticflag = FALSE;
      metricflag = TRUE;
      break;
    case 3:
      milesconv = KM2NAUTIC;
      milesflag = FALSE;
      nauticflag = TRUE;
      metricflag = FALSE;
      break;

    }
  needtosave = TRUE;
  if (pdamode)
    {
      if (milesflag)
	sprintf (s1, "[%s]", _("mi/h"));
      else if (nauticflag)
	sprintf (s1, "[%s]", _("knots"));
      else
	sprintf (s1, "[%s]", _("km/h"));
    }
  else
    {
      if (milesflag)
	sprintf (s1, "%s [%s]", _("Speed"), _("mi/h"));
      else if (nauticflag)
	sprintf (s1, "%s [%s]", _("Speed"), _("knots"));
      else
	sprintf (s1, "%s [%s]", _("Speed"), _("km/h"));
    }

  gtk_frame_set_label (GTK_FRAME (frame_speed), s1);
  return TRUE;
}

/*  switching nightmode */
gint
night_cb (GtkWidget *widget, guint datum)
{

  switch (datum)
    {
    case 0:
      nightmode = 0;
      break;
    case 1:
      nightmode = 1;
      break;
    case 2:
      nightmode = 2;
      break;

    }
  needtosave = TRUE;
  return TRUE;
}



gint
defaultserver_cb (GtkWidget *widget, guint datum)
{
/*      1=miles, 2=metric, 3=nautic */
  switch (datum)
    {
    case 1:
      defaultserver = 0;
      break;
    case 2:
      defaultserver = 1;
      break;
    }
  needtosave = TRUE;
  return TRUE;
}


/*  switching shadow on/off */
gint
shadow_cb (GtkWidget *widget, guint datum)
{
  shadow = !shadow;
  needtosave = TRUE;
  return TRUE;
}

/*  switching slow cpu on/off */
gint
slowcpu_cb (GtkWidget *widget, guint datum)
{
  slowcpu = !slowcpu;

  gtk_timeout_remove (redrawtimeout);
  if (slowcpu)
    redrawtimeout = gtk_timeout_add (1000, (GtkFunction) drawmarker_cb, NULL);
  else
    redrawtimeout =
      gtk_timeout_add (REDRAWTIMER, (GtkFunction) drawmarker_cb, NULL);

  needtosave = TRUE;
  return TRUE;
}

/*  switching decimal or degree, minutes, seconds mode */
gint
minsec_cb (GtkWidget *widget, guint datum)
{
  minsecmode = !minsecmode;
  needtosave = TRUE;
  return TRUE;
}

/*  switching sat level/sat position display */
gint
satpos_cb (GtkWidget *widget, guint datum)
{
  satposmode = !satposmode;
  needtosave = TRUE;
  expose_sats_cb (NULL, 0);
  return TRUE;
}

/*  switching simfollow on/off */
gint
simfollow_cb (GtkWidget *widget, guint datum)
{
  simfollow = !simfollow;
  needtosave = TRUE;
  return TRUE;
}

/*  switching testgarmin on/off */
gint
testgarmin_cb (GtkWidget *widget, guint datum)
{
  testgarmin = !testgarmin;
  needtosave = TRUE;
  return TRUE;
}

/*  should I use DGPS-IP? */
gint
usedgps_cb (GtkWidget *widget, guint datum)
{
  usedgps = !usedgps;
  needtosave = TRUE;
  return TRUE;
}


gint
serialdev_cb (GtkWidget *widget, guint datum)
{
  gchar *s;

  s = g_strstrip (gtk_entry_get_text (GTK_ENTRY (serialbt)));
  strcpy (serialdev, s);
  needtosave = TRUE;
  return TRUE;
}


gint
mapdir_cb (GtkWidget *widget, guint datum)
{
  gchar *s;

  s = g_strstrip (gtk_entry_get_text (GTK_ENTRY (mapdirbt)));
  strcpy (mapdir, s);
  needtosave = TRUE;
  needreloadmapconfig = TRUE;
  gtk_timeout_add (2000, (GtkFunction) loadmapconfig, 0);
  return TRUE;
}

gint
maptoggle_cb (GtkWidget *widget, guint datum)
{
  displaymap_map = !displaymap_map;
  if (displaymap_map)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (maptogglebt), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (maptogglebt), FALSE);
  needtosave = TRUE;
  return TRUE;
}

gint
dotripmeter (GtkWidget *widget, guint datum)
{
  gdouble d;

  d = calcdist (trip_long, trip_lat);
  trip_long = current_long;
  trip_lat = current_lat;
  tripodometer += d;
  if (groundspeed > tripmaxspeed)
    tripmaxspeed = groundspeed;
  tripavspeedcount++;
  tripavspeed += groundspeed;
  return TRUE;
}

gint
bestmap_cb (GtkWidget *widget, guint datum)
{
  if (datum == 1)
    scaleprefered = !scaleprefered;
  if (!scaleprefered)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bestmapbt), TRUE);
      gtk_widget_set_sensitive (scalerrbt, FALSE);
      gtk_widget_set_sensitive (scalerlbt, FALSE);
      gtk_widget_set_sensitive (scaler, FALSE);
    }
  else
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bestmapbt), FALSE);
      gtk_widget_set_sensitive (scalerrbt, TRUE);
      gtk_widget_set_sensitive (scalerlbt, TRUE);
      gtk_widget_set_sensitive (scaler, TRUE);
    }
  needtosave = TRUE;
  return TRUE;
}

gint
savetrack_cb (GtkWidget *widget, guint datum)
{
  savetrack = !savetrack;
  if (savetrack)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (savetrackbt), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (savetrackbt), FALSE);
  needtosave = TRUE;
  return TRUE;
}

gint
topotoggle_cb (GtkWidget *widget, guint datum)
{
  displaymap_top = !displaymap_top;
  if (displaymap_top)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (topotogglebt), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (topotogglebt), FALSE);
  needtosave = TRUE;
  return TRUE;
}


gint
mute_cb (GtkWidget *widget, guint datum)
{
  muteflag = !muteflag;
  if (muteflag)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mutebt), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mutebt), FALSE);
  needtosave = TRUE;
  return TRUE;
}

gint
sql_cb (GtkWidget *widget, guint datum)
{
  sqlflag = !sqlflag;
  if (sqlflag)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sqlbt), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sqlbt), FALSE);
  needtosave = TRUE;
  loadwaypoints ();
  return TRUE;
}

gint
track_cb (GtkWidget *widget, guint datum)
{
  trackflag = !trackflag;
  if (trackflag)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (trackbt), TRUE);
      rebuildtracklist ();
    }
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (trackbt), FALSE);
  needtosave = TRUE;
  return TRUE;
}

gint
wp_cb (GtkWidget *widget, guint datum)
{
  wpflag = !wpflag;
  if (wpflag)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (wpbt), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (wpbt), FALSE);
  needtosave = TRUE;
  return TRUE;
}

gint
pos_cb (GtkWidget *widget, guint datum)
{
  posmode = !posmode;
  if (posmode)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (posbt), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (posbt), FALSE);
  posmode_x = current_long;
  posmode_y = current_lat;

  return TRUE;
}

/*  if a waypoint is selected set the target_* variables */
gint
setwp_cb (GtkWidget *widget, guint datum)
{
  gchar b[100], str[200], buf[1000], buf2[1000];
  gchar *p, *tn;
  p = b;

  deleteline = datum;
  if (dontsetwp)
    return TRUE;

  gtk_clist_get_text (GTK_CLIST (mylist), datum, 0, &p);
  if (createroute)
    {
/*        g_print ("\nroute: %s", p); */
      thisrouteline = atol (p) - 1;
      insertroutepoints ();
      return TRUE;
    }
  thisline = atol (p);
/*    g_print ("%d\n", thisline); */
  gtk_clist_get_text (GTK_CLIST (mylist), datum, 1, &p);
  strcpy (targetname, p);
  sprintf (str, "%s %s", _("Distance to "), targetname);
  gtk_frame_set_label (GTK_FRAME (destframe), str);
  gtk_clist_get_text (GTK_CLIST (mylist), datum, 2, &p);
  checkinput (p);
  target_lat = atof (p);
  gtk_clist_get_text (GTK_CLIST (mylist), datum, 3, &p);
  checkinput (p);
  target_long = atof (p);
/*    gtk_timeout_add (5000, (GtkFunction) sel_targetweg_cb, widget); */
  g_timer_stop (disttimer);
  g_timer_start (disttimer);
  olddist = dist;
/*   posmode = FALSE; */
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (posbt), FALSE);

  tn = g_strdelimit (targetname, "_", ' ');
  strcpy (buf2, "");
  if (tn[0] == '*')
    {
      strcpy (buf2, "das mobile Ziel ");
      strcat (buf2, (tn + 1));
    }
  else
    strcat (buf2, tn);

  switch (voicelang)
    {
    case english:
      sprintf (buf, "New target is %s", buf2);
      break;
    case spanish:
      sprintf (buf, "Destinacin definida: %s", buf2);
      break;
    case german:
      sprintf (buf, "Neues Ziel ist %s", buf2);
    }
  speech_out_speek (buf);
  saytarget = TRUE;
  routenearest = 9999999;

  return TRUE;
}


gint
delwp_cb (GtkWidget *widget, guint datum)
{
  gint i, j;
  gchar *p;

  i = deleteline;
  if (debug)
    g_print ("\nremove line %d", i);
  gtk_clist_get_text (GTK_CLIST (mylist), i, 0, &p);
  j = atol (p) - 1;
  gtk_clist_remove (GTK_CLIST (mylist), i);
  if (debug)
    g_print ("\nremove entry %d", j);

  deletesqldata ((wayp + j)->sqlnr);
  for (i = j; i < (maxwp - 1); i++)
    *(wayp + i) = *(wayp + i + 1);
  maxwp--;
  savewaypoints ();
  gtk_clist_get_text (GTK_CLIST (mylist), deleteline, 0, &p);
  thisline = atol (p);

  return TRUE;
}


/*  set reference point for map calibration */
gint
setrefpoint_cb (GtkWidget *widget, guint datum)
{
  gchar b[100];
  gchar *p;
  p = b;
  gtk_clist_get_text (GTK_CLIST (mylist), datum, 1, &p);
  gtk_entry_set_text (GTK_ENTRY (dltext4), p);
  gtk_clist_get_text (GTK_CLIST (mylist), datum, 2, &p);
  gtk_entry_set_text (GTK_ENTRY (dltext1), p);

  gtk_clist_get_text (GTK_CLIST (mylist), datum, 3, &p);
  gtk_entry_set_text (GTK_ENTRY (dltext2), p);

  return TRUE;
}



gint
scaler_cb (GtkAdjustment * adj, gdouble *datum)
{
  gchar s2[100];
  scalewanted = nlist[(gint) rint (adj->value)];
  sprintf (s2, "1:%d", scalewanted);
  gtk_label_set_text (GTK_LABEL (l8), s2);
  if (debug)
    g_print ("\nScaler: %d", scalewanted);
  needtosave = TRUE;

  return TRUE;
}

/*  Let user select a destination from the waypoint list */

gint
key_cb (GtkWidget *widget, GdkEventKey * event)
{
  gdouble lat, lon, px, py, dif;
  gint x, y;
  GdkModifierType state;

/*    g_print ("\nevent:%x key:%c\n",event->keyval,event->keyval); */
  if ((toupper (event->keyval)) == 'X')
    {
      wplat = current_lat;
      wplon = current_long;
      addwaypoint_cb (NULL, NULL);
    }

// xxxxxxxxxxxxxxxxxxxxxxxxxxx

  if ((toupper (event->keyval)) == 'Y')
    {

      gdk_window_get_pointer (drawing_area->window, &x, &y, &state);


      px = (SCREEN_X_2 - x - xoff) * pixelfact / zoom;
      py = (-SCREEN_Y_2 + y + yoff) * pixelfact / zoom;
      lat = zero_lat - py / (Ra[(int) (100 + current_lat)] * M_PI / 180.0);
      lat = zero_lat - py / (Ra[(int) (100 + lat)] * M_PI / 180.0);
      lon =
	zero_long -
	px / ((Ra[(int) (100 + lat)] * M_PI / 180.0) *
	      cos (M_PI * lat / 180.0));

      dif = lat * (1 - (cos ((M_PI * fabs (lon - zero_long)) / 180.0)));
      lat = lat - dif / 1.5;
      lon =
	zero_long -
	px / ((Ra[(int) (100 + lat)] * M_PI / 180.0) *
	      cos (M_PI * lat / 180.0));

/*  Add mouse position as waypoint */
      wplat = lat;
      wplon = lon;
      addwaypoint_cb (NULL, 0);


    }
// xxxxxxxxxxxxxxxxxxxxxxxxxx

  if (((toupper (event->keyval)) == 'J') && routemode)
    {
      forcenextroutepoint = TRUE;
    }

  if ((toupper (event->keyval)) == 'N')
    {
      if (nightmode != 0)
	{
/*  light on for 30 seconds  */
	  if (disableisnight == TRUE)
	    {
/* 	      gtk_timeout_remove (nighttimer); */
	      disableisnight = FALSE;
	    }
	  else
	    lighton ();
	}
    }

  return TRUE;
}

gint
mapclick_cb (GtkWidget *widget, GdkEventMotion * event)
{
  gint x, y, px, py;
  gdouble dif, lon, lat, vali;
  GdkModifierType state;
  gchar s[200];

  if (event->is_hint)
    gdk_window_get_pointer (event->window, &x, &y, &state);
  else
    {
      x = event->x;
      y = event->y;
      state = event->state;
    }
  if (state == 0)
    return 0;

  px = (SCREEN_X_2 - x - xoff) * pixelfact / zoom;
  py = (-SCREEN_Y_2 + y + yoff) * pixelfact / zoom;
  lat = zero_lat - py / (Ra[(int) (100 + current_lat)] * M_PI / 180.0);
  lat = zero_lat - py / (Ra[(int) (100 + lat)] * M_PI / 180.0);
  lon =
    zero_long -
    px / ((Ra[(int) (100 + lat)] * M_PI / 180.0) * cos (M_PI * lat / 180.0));

  dif = lat * (1 - (cos ((M_PI * fabs (lon - zero_long)) / 180.0)));
  lat = lat - dif / 1.5;
  lon =
    zero_long -
    px / ((Ra[(int) (100 + lat)] * M_PI / 180.0) * cos (M_PI * lat / 180.0));

  if (downloadwindowactive || importactive)
    {
      if (downloadwindowactive)
	{
	  sprintf (s, "%.5f", lat);
	  if (minsecmode)
	    decimaltomin (s, 1);
	  gtk_entry_set_text (GTK_ENTRY (dltext1), s);
	  sprintf (s, "%.5f", lon);
	  if (minsecmode)
	    decimaltomin (s, 0);
	  gtk_entry_set_text (GTK_ENTRY (dltext2), s);
	  downloadsetparm (NULL, 0);
	}
      else
	{
	  sprintf (s, "%d", x + SCREEN_X_2 + xoff);
	  gtk_entry_set_text (GTK_ENTRY (dltext5), s);
	  sprintf (s, "%d", y + SCREEN_Y_2 + yoff);
	  gtk_entry_set_text (GTK_ENTRY (dltext6), s);

	}
    }
  else
    {
/*        g_print ("\nstate: %x x:%d y:%d", state, x, y); */
      vali = (GTK_ADJUSTMENT (adj)->value);
/*  Left mouse button + shift key */
      if ((state & (GDK_BUTTON1_MASK | GDK_SHIFT_MASK)) ==
	  (GDK_BUTTON1_MASK | GDK_SHIFT_MASK))
	{
	  scalerbt_cb (NULL, 2);
	  return TRUE;
	}
/*  Add mouse position as waypoint */
/*  Left mouse button + control key */
      if ((state & (GDK_BUTTON1_MASK | GDK_CONTROL_MASK)) ==
	  (GDK_BUTTON1_MASK | GDK_CONTROL_MASK))
	{
	  wplat = lat;
	  wplon = lon;
	  addwaypoint_cb (NULL, 0);
	  return TRUE;
	}
/*  Add current position as waypoint */
/*  Right mouse button + control key */
      if ((state & (GDK_BUTTON3_MASK | GDK_CONTROL_MASK)) ==
	  (GDK_BUTTON3_MASK | GDK_CONTROL_MASK))
	{
	  wplat = current_lat;
	  wplon = current_long;

	  addwaypoint_cb (NULL, 0);
	  return TRUE;
	}
/*  Right mouse button + shift key */
      if ((state & (GDK_BUTTON3_MASK | GDK_SHIFT_MASK)) ==
	  (GDK_BUTTON3_MASK | GDK_SHIFT_MASK))
	{
	  scalerbt_cb (NULL, 1);
	  return TRUE;
	}

/*  Left mouse button */
      if ((state & GDK_BUTTON1_MASK) == GDK_BUTTON1_MASK)
	{
	  if (posmode)
	    {
	      posmode_x = lon;
	      posmode_y = lat;
	      rebuildtracklist ();
	      if (onemousebutton)
		gtk_timeout_add (10000, (GtkFunction) posmodeoff_cb, 0);
	    }
	}
/*  Middle mouse button */
      if ((state & GDK_BUTTON2_MASK) == GDK_BUTTON2_MASK)
	{
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (posbt), FALSE);

	  rebuildtracklist ();
	}
/*  Right mouse button */
      if ((state & GDK_BUTTON3_MASK) == GDK_BUTTON3_MASK)
	{
/* set  as target */
/* only if RIGHT mouse button clicked */
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (posbt), FALSE);
	  rebuildtracklist ();
	  strcpy (targetname, _("SELECTED"));
	  sprintf (s, "%s %s", _("Distance to "), targetname);
	  gtk_frame_set_label (GTK_FRAME (destframe), s);
	  target_lat = lat;
	  target_long = lon;
	  g_timer_stop (disttimer);
	  g_timer_start (disttimer);
	  olddist = dist;
	}
    }

/*    g_print ("\nx: %d, y: %d", x, y); */
  return TRUE;
}


gint
minimapclick_cb (GtkWidget *widget, GdkEventMotion * event)
{
  gint x, y, px, py;
  gdouble dif, lon, lat;
  GdkModifierType state;

  if (event->is_hint)
    gdk_window_get_pointer (event->window, &x, &y, &state);
  else
    {
      x = event->x;
      y = event->y;
      state = event->state;
    }
  if (state == 0)
    return 0;
#define MINISCREEN_X_2 64
#define MINISCREEN_Y_2 51
  px = (MINISCREEN_X_2 - x) * 10 * pixelfact;
  py = (-MINISCREEN_Y_2 + y) * 10 * pixelfact;
  lat = zero_lat - py / (Ra[(int) (100 + current_lat)] * M_PI / 180.0);
  lat = zero_lat - py / (Ra[(int) (100 + lat)] * M_PI / 180.0);
  lon =
    zero_long -
    px / ((Ra[(int) (100 + lat)] * M_PI / 180.0) * cos (M_PI * lat / 180.0));

  dif = lat * (1 - (cos ((M_PI * fabs (lon - zero_long)) / 180.0)));
  lat = lat - dif / 1.5;
  lon =
    zero_long -
    px / ((Ra[(int) (100 + lat)] * M_PI / 180.0) * cos (M_PI * lat / 180.0));


/*        g_print ("\nstate: %x x:%d y:%d", state, x, y); */

/*  Left mouse button */
  if ((state & GDK_BUTTON1_MASK) == GDK_BUTTON1_MASK)
    {
      if (posmode)
	{
	  posmode_x = lon;
	  posmode_y = lat;
	  rebuildtracklist ();
	  if (onemousebutton)
	    gtk_timeout_add (10000, (GtkFunction) posmodeoff_cb, 0);
	}
    }
/*  Middle mouse button */
  if ((state & GDK_BUTTON2_MASK) == GDK_BUTTON2_MASK)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (posbt), FALSE);
      rebuildtracklist ();
    }

/*    g_print ("\nx: %d, y: %d", x, y); */
  return TRUE;
}


gint
addwaypointchange_cb (GtkWidget *widget, guint datum)
{
  gchar *s;
  gdouble lo, la;

  s = g_strstrip (gtk_entry_get_text (GTK_ENTRY (addwaypoint1)));
  checkinput (s);
  lo = g_strtod (s, NULL);
  if ((lo > -181) && (lo < 181))
    wplon = lo;
  s = g_strstrip (gtk_entry_get_text (GTK_ENTRY (addwaypoint2)));
  checkinput (s);
  la = g_strtod (s, NULL);
  if ((la > -181) && (la < 181))
    wplat = la;

  return TRUE;
}

gint
addwaypoint (GtkWidget *widget, guint datum)
{
  gint i;
  gchar *s, *s2;

  s = gtk_entry_get_text (GTK_ENTRY (wptext1));
  s2 = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (wptext2)->entry));
  if (sqlflag)
    {
      insertsqldata (wplat, wplon, s, s2);
      getsqltypelist ();
      getsqldata ();
    }
  else
    {
      i = maxwp;
      (wayp + i)->lat = wplat;
      (wayp + i)->longitude = wplon;
      g_strdelimit (s, " ", '_');
/*  limit waypoint name to 20 chars */
      strcpy ((wayp + i)->name, s);
      (wayp + i)->name[20] = 0;
      strcpy ((wayp + i)->typ, s2);
      (wayp + i)->wlan = 0;

      maxwp++;
      if (maxwp >= wpsize)
	{
	  wpsize += 1000;
	  wayp = g_renew (wpstruct, wayp, wpsize);
	}
      savewaypoints ();
    }
  gtk_widget_destroy (GTK_WIDGET (datum));
  markwaypoint = FALSE;
  return TRUE;
}

/*  destroy sel_target window */
gint
addwaypointdestroy_cb (GtkWidget *widget, guint datum)
{

  gtk_widget_destroy (GTK_WIDGET (addwaypointwindow));
  markwaypoint = FALSE;

  return FALSE;
}

gint
addwaypoint_cb (GtkWidget *widget, gpointer datum)
{
  GtkWidget *window, *l1, *l2, *t1, *t2, *hbox3, *hbox4, *hbox5;
  GtkWidget *vbox, *hbox, *hbox2, *button, *button2, *label, *label2;
  gchar buff[40];
  GList *list = NULL;
  gint i;

  if (sqlflag)
    {
      getsqltypelist ();
      for (i = 0; i < dbtypelistcount; i++)
	list = g_list_append (list, dbtypelist[i]);
    }

  addwaypointwindow = window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gotowindow = window;
  markwaypoint = TRUE;

  gtk_window_set_modal (GTK_WINDOW (window), TRUE);
  gtk_window_set_title (GTK_WINDOW (window), _("Add waypoint name"));


  button = gtk_button_new_with_label (_("OK"));
  button2 = gtk_button_new_with_label (_("Cancel"));
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (addwaypoint), GTK_OBJECT (window));
  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
		      GTK_SIGNAL_FUNC (addwaypointdestroy_cb), 0);
  gtk_signal_connect (GTK_OBJECT (window),
		      "delete_event",
		      GTK_SIGNAL_FUNC (addwaypointdestroy_cb), 0);

  vbox = gtk_vbox_new (TRUE, 2);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  hbox = gtk_hbox_new (TRUE, 2);
  hbox2 = gtk_hbox_new (TRUE, 2);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (hbox), button2, TRUE, TRUE, 2);

  addwaypoint1 = t1 = gtk_entry_new_with_max_length (20);
  sprintf (buff, "%.5f", wplon);
  if (minsecmode)
    decimaltomin (buff, 0);
  gtk_entry_set_text (GTK_ENTRY (t1), buff);
  l1 = gtk_label_new (_("Longitude"));
  addwaypoint2 = t2 = gtk_entry_new_with_max_length (20);
  sprintf (buff, "%.5f", wplat);
  if (minsecmode)
    decimaltomin (buff, 1);
  gtk_entry_set_text (GTK_ENTRY (t2), buff);
  l2 = gtk_label_new (_("Latitude"));

  gtk_signal_connect (GTK_OBJECT (t1),
		      "changed", GTK_SIGNAL_FUNC (addwaypointchange_cb),
		      (gpointer) 1);
  gtk_signal_connect (GTK_OBJECT (t2),
		      "changed", GTK_SIGNAL_FUNC (addwaypointchange_cb),
		      (gpointer) 2);

  hbox3 = gtk_hbox_new (TRUE, 2);
  hbox4 = gtk_hbox_new (TRUE, 2);
  hbox5 = gtk_hbox_new (TRUE, 2);

  gtk_box_pack_start (GTK_BOX (hbox3), l2, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (hbox3), t2, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (hbox4), l1, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (hbox4), t1, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox3, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox4, TRUE, TRUE, 2);


  wptext1 = gtk_entry_new ();
  label = gtk_label_new (_(" Waypoint name: "));
  gtk_window_set_default (GTK_WINDOW (window), button);
  gtk_window_set_focus (GTK_WINDOW (window), wptext1);

  gtk_box_pack_start (GTK_BOX (hbox2), label, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (hbox2), wptext1, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox2, TRUE, TRUE, 2);


/*   wptext2 = gtk_entry_new (); */
  wptext2 = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO (wptext2), (GList *) list);

  label2 = gtk_label_new (_(" Waypoint type: "));

  gtk_box_pack_start (GTK_BOX (hbox5), label2, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (hbox5), wptext2, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox5, TRUE, TRUE, 2);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 2);


  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  gtk_widget_show_all (window);
  return TRUE;
}


void
insertwaypoints ()
{
  gint i, j;
  gchar *text[5], text0[20], text1[20], text2[20], text3[20], name[40];
  gdouble la, lo, dist;

/*  insert waypoint into the clist */

  for (i = 0; i < maxwp; i++)
    {
      (wayp + i)->dist = calcdist ((wayp + i)->longitude, (wayp + i)->lat);
      text[1] = (wayp + i)->name;
      sprintf (text0, "%d", i + 1);
      sprintf (text1, "%8.5f", (wayp + i)->lat);
      if (minsecmode)
	decimaltomin (text1, 1);
      sprintf (text2, "%8.5f", (wayp + i)->longitude);
      if (minsecmode)
	decimaltomin (text2, 0);
      sprintf (text3, "%9.3f", (wayp + i)->dist);
      text[0] = text0;
      text[2] = text1;
      text[3] = text2;
      text[4] = text3;
      j = gtk_clist_append (GTK_CLIST (mylist), (gchar **) text);
      gtk_clist_set_foreground (GTK_CLIST (mylist), j, &black);
    }

  for (i = 0; i < maxfriends; i++)
    {
      strcpy (name, "*");
      strcat (name, friendstxt[i]);
      text[1] = name;
      sprintf (text0, "%d", i + maxwp + 1);
      la = g_strtod (friendslat[i], NULL);
      lo = g_strtod (friendslon[i], NULL);
      sprintf (text1, "%8.5f", la);
      sprintf (text2, "%8.5f", lo);
      text[0] = text0;
      text[2] = text1;
      text[3] = text2;
      dist = calcdist (lo, la);
      sprintf (text3, "%9.3f", dist);
      text[4] = text3;
      j = gtk_clist_append (GTK_CLIST (mylist), (gchar **) text);
      gtk_clist_set_foreground (GTK_CLIST (mylist), j, &red);
    }

/*  we want te columns sorted by distance from current position */
  gtk_clist_set_sort_column (GTK_CLIST (mylist), (gint) 4);
  gtk_clist_sort (GTK_CLIST (mylist));
}

void
insertroutepoints ()
{
  gint i, j;
  gchar *text[5], text0[20], text1[20], text2[20], text3[20];

  i = thisrouteline;
  (wayp + i)->dist = calcdist ((wayp + i)->longitude, (wayp + i)->lat);
  text[1] = (wayp + i)->name;
  sprintf (text0, "%d", i + 1);
  sprintf (text1, "%8.5f", (wayp + i)->lat);
  if (minsecmode)
    decimaltomin (text1, 1);
  sprintf (text2, "%8.5f", (wayp + i)->longitude);
  if (minsecmode)
    decimaltomin (text2, 0);
  sprintf (text3, "%9.3f", (wayp + i)->dist);
  text[0] = text0;
  text[2] = text1;
  text[3] = text2;
  text[4] = text3;
  j = gtk_clist_append (GTK_CLIST (myroutelist), (gchar **) text);
  gtk_clist_set_foreground (GTK_CLIST (myroutelist), j, &black);
  strcpy ((routelist + routeitems)->name, (wayp + i)->name);
  (routelist + routeitems)->lat = (wayp + i)->lat;
  (routelist + routeitems)->longitude = (wayp + i)->longitude;
  routeitems++;
  gtk_widget_set_sensitive (select_route_button, TRUE);

}

void
insertallroutepoints ()
{
  gint i, j;
  gchar *text[5], text0[20], text1[20], text2[20], text3[20];

  for (i = 0; i < maxwp; i++)
    {
      (wayp + i)->dist = calcdist ((wayp + i)->longitude, (wayp + i)->lat);
      text[1] = (wayp + i)->name;
      sprintf (text0, "%d", i + 1);
      sprintf (text1, "%8.5f", (wayp + i)->lat);
      if (minsecmode)
	decimaltomin (text1, 1);
      sprintf (text2, "%8.5f", (wayp + i)->longitude);
      if (minsecmode)
	decimaltomin (text2, 0);
      sprintf (text3, "%9.3f", (wayp + i)->dist);
      text[0] = text0;
      text[2] = text1;
      text[3] = text2;
      text[4] = text3;
      j = gtk_clist_append (GTK_CLIST (myroutelist), (gchar **) text);
      gtk_clist_set_foreground (GTK_CLIST (myroutelist), j, &black);
      strcpy ((routelist + routeitems)->name, (wayp + i)->name);
      (routelist + routeitems)->lat = (wayp + i)->lat;
      (routelist + routeitems)->longitude = (wayp + i)->longitude;
      routeitems++;
    }
  gtk_widget_set_sensitive (select_route_button, TRUE);

}

gint
reinsertwp_cb (GtkWidget *widget, guint datum)
{
  gint i, j, k, val;
  gchar *p;
  GtkAdjustment *ad;

/*  update routine for select target window */
  k = 0;
  ad = gtk_clist_get_vadjustment (GTK_CLIST (mylist));
  val = (GTK_ADJUSTMENT (ad)->value);

  gtk_clist_freeze (GTK_CLIST (mylist));
  gtk_clist_clear (GTK_CLIST (mylist));
  insertwaypoints ();
  for (i = 0; i < maxwp; i++)
    {
      gtk_clist_get_text (GTK_CLIST (mylist), i, 0, &p);
      j = atol (p);
      if (thisline == j)
	{
	  k = i;
	  break;
	}
    }
  gtk_adjustment_set_value (GTK_ADJUSTMENT (ad), val);
  dontsetwp = TRUE;
  gtk_clist_select_row (GTK_CLIST (mylist), k, 0);
  dontsetwp = FALSE;
  gtk_clist_thaw (GTK_CLIST (mylist));
  return TRUE;
}

gint
click_clist (GtkWidget *widget, GdkEventButton * event, gpointer data)
{

  g_print ("\nclist: %d, data: %d", event->button, thisline);
  if ((event->button == 3))
    {

      return TRUE;
    }

  return FALSE;

}

gint
sel_target_cb (GtkWidget *widget, guint datum)
{
  GtkWidget *window;
  gchar *tabeltitel1[] = { "#",
    _("Waypoint"), _("Latitude"), _("Longitude"), _("Distance"),
    NULL
  };
  GtkWidget *scrwindow, *vbox, *button, *hbox, *deletebt;
  GtkTooltips *tooltips;

  if (setwpactive)
    return TRUE;

  setwpactive = TRUE;
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
/*    gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, TRUE); */
  gotowindow = window;
  if (datum == 1)
    {
      gtk_window_set_modal (GTK_WINDOW (window), TRUE);
      gtk_window_set_title (GTK_WINDOW (window), _("Select reference point"));
    }
  else
    gtk_window_set_title (GTK_WINDOW (window),
			  _("Please select your destination"));
  if (pdamode)
    gtk_window_set_default_size (GTK_WINDOW (window), real_screen_x,
				 real_screen_y);
  else
    gtk_window_set_default_size (GTK_WINDOW (window), 370, 360);

  mylist = gtk_clist_new_with_titles (5, tabeltitel1);
  if (datum == 1)
    gtk_signal_connect (GTK_OBJECT (GTK_CLIST (mylist)),
			"select-row",
			GTK_SIGNAL_FUNC (setrefpoint_cb),
			GTK_OBJECT (mylist));
  else
    {
      gtk_signal_connect (GTK_OBJECT (GTK_CLIST (mylist)),
			  "select-row",
			  GTK_SIGNAL_FUNC (setwp_cb), GTK_OBJECT (mylist));
/*       gtk_signal_connect (GTK_OBJECT (mylist), "button-release-event", */
/* 			  GTK_SIGNAL_FUNC (click_clist), NULL); */
    }

  if (datum != 1)
    {
      if (routemode)
	create_route_button = gtk_button_new_with_label (_("Edit route"));
      else
	create_route_button = gtk_button_new_with_label (_("Create route"));
      GTK_WIDGET_SET_FLAGS (create_route_button, GTK_CAN_DEFAULT);
      gtk_signal_connect (GTK_OBJECT (create_route_button), "clicked",
			  GTK_SIGNAL_FUNC (create_route_cb), 0);
    }

  deletebt = gtk_button_new_with_label (_("Delete WP"));
  GTK_WIDGET_SET_FLAGS (deletebt, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (deletebt), "clicked",
		      GTK_SIGNAL_FUNC (delwp_cb), 0);

  button = gtk_button_new_with_label (_("Close"));
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_window_set_default (GTK_WINDOW (window), button);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			     GTK_SIGNAL_FUNC
			     (sel_targetweg_cb), GTK_OBJECT (window));
  gtk_signal_connect_object (GTK_OBJECT (window),
			     "delete_event",
			     GTK_SIGNAL_FUNC
			     (sel_targetweg_cb), GTK_OBJECT (window));

  insertwaypoints ();
  gtk_clist_set_column_justification (GTK_CLIST (mylist), 4,
				      GTK_JUSTIFY_RIGHT);
  gtk_clist_set_column_justification (GTK_CLIST (mylist), 0,
				      GTK_JUSTIFY_RIGHT);
  gtk_clist_set_column_auto_resize (GTK_CLIST (mylist), 0, TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (mylist), 1, TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (mylist), 2, TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (mylist), 3, TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (mylist), 4, TRUE);

  scrwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (scrwindow), mylist);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
				  (scrwindow),
				  (GtkPolicyType)
				  GTK_POLICY_AUTOMATIC,
				  (GtkPolicyType) GTK_POLICY_AUTOMATIC);
  vbox = gtk_vbox_new (FALSE, 2 * PADDING);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_box_pack_start (GTK_BOX (vbox), scrwindow, TRUE, TRUE, 2 * PADDING);
  hbox = gtk_hbox_new (TRUE, 2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 2 * PADDING);
  if (datum != 1)
    {
      gtk_box_pack_start (GTK_BOX (hbox), create_route_button, TRUE, TRUE,
			  2 * PADDING);
      gtk_box_pack_start (GTK_BOX (hbox), deletebt, TRUE, TRUE, 2 * PADDING);
    }
  if (pdamode)
    gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 2 * PADDING);
  else
    gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 2 * PADDING);
/*    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER); */
  selwptimeout = gtk_timeout_add (5000, (GtkFunction) reinsertwp_cb, 0);
  tooltips = gtk_tooltips_new ();
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), create_route_button,
			_
			("Create a route using some waypoints from this list"),
			NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), deletebt,
			_
			("Delete the selected waypoint from the waypoint list"),
			NULL);

  gtk_widget_show_all (window);
  return TRUE;
}


gint
create_route_cb (GtkWidget *widget, guint datum)
{
  GtkWidget *window;
  gchar *tabeltitel1[] = { "#",
    _("Waypoint"), _("Latitude"), _("Longitude"), _("Distance"),
    NULL
  };
  GtkWidget *scrwindow, *vbox, *button, *button3, *hbox, *hbox2, *l1;
  gint i, j;
  gchar *text[5], text0[20], text1[20], text2[20], text3[20];
  GtkTooltips *tooltips;

  createroute = TRUE;
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  routewindow = window;
/*    gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, TRUE); */

  gtk_window_set_title (GTK_WINDOW (window), _("Define route"));
  gtk_window_set_default_size (GTK_WINDOW (window), 320, 320);
  myroutelist = gtk_clist_new_with_titles (5, tabeltitel1);
  gtk_signal_connect (GTK_OBJECT (GTK_CLIST (myroutelist)),
		      "select-row",
		      GTK_SIGNAL_FUNC (setroutetarget),
		      GTK_OBJECT (myroutelist));

  select_route_button = gtk_button_new_with_label (_("Start route"));
  gtk_widget_set_sensitive (select_route_button, FALSE);

  GTK_WIDGET_SET_FLAGS (select_route_button, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (select_route_button), "clicked",
		      GTK_SIGNAL_FUNC (do_route_cb), 0);
  gtk_window_set_default (GTK_WINDOW (window), select_route_button);

  create_route2_button =
    gtk_button_new_with_label (_("Take all WP as route"));
  GTK_WIDGET_SET_FLAGS (create_route2_button, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (create_route2_button), "clicked",
		      GTK_SIGNAL_FUNC (insertallroutepoints), 0);

  button = gtk_button_new_with_label (_("Abort route"));
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
			     GTK_SIGNAL_FUNC
			     (sel_routecancel_cb), GTK_OBJECT (window));
  gtk_signal_connect_object (GTK_OBJECT (window),
			     "delete_event",
			     GTK_SIGNAL_FUNC
			     (sel_routeclose_cb), GTK_OBJECT (window));

  button3 = gtk_button_new_with_label (_("Close"));
  GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);
  gtk_signal_connect_object (GTK_OBJECT (button3), "clicked",
			     GTK_SIGNAL_FUNC
			     (sel_routeclose_cb), GTK_OBJECT (window));


  gtk_clist_set_column_justification (GTK_CLIST (myroutelist), 4,
				      GTK_JUSTIFY_RIGHT);
  gtk_clist_set_column_justification (GTK_CLIST (myroutelist), 0,
				      GTK_JUSTIFY_RIGHT);
  gtk_clist_set_column_auto_resize (GTK_CLIST (myroutelist), 0, TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (myroutelist), 1, TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (myroutelist), 2, TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (myroutelist), 3, TRUE);
  gtk_clist_set_column_auto_resize (GTK_CLIST (myroutelist), 4, TRUE);

  scrwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (scrwindow), myroutelist);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
				  (scrwindow),
				  (GtkPolicyType)
				  GTK_POLICY_AUTOMATIC,
				  (GtkPolicyType) GTK_POLICY_AUTOMATIC);
  vbox = gtk_vbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_box_pack_start (GTK_BOX (vbox), scrwindow, TRUE, TRUE, 2);
  hbox = gtk_hbox_new (TRUE, 2);
  hbox2 = gtk_hbox_new (TRUE, 2);
  if (!routemode)
    l1 = gtk_label_new (_("Click on waypoints list\nto add waypoints"));
  else
    l1 = gtk_label_new (_("Click on list item\nto select next waypoint"));
  gtk_box_pack_start (GTK_BOX (vbox), l1, FALSE, FALSE, 2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 2);
  gtk_box_pack_start (GTK_BOX (hbox), select_route_button, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (hbox), create_route2_button, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 2);
  gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, FALSE, 2);
  gtk_box_pack_start (GTK_BOX (hbox2), button3, FALSE, FALSE, 2);
  gtk_widget_set_sensitive (create_route_button, FALSE);

  if (routemode)
    {
      gtk_widget_set_sensitive (select_route_button, FALSE);
      gtk_clist_clear (GTK_CLIST (myroutelist));
      for (i = 0; i < routeitems; i++)
	{
	  (routelist + i)->dist =
	    calcdist ((routelist + i)->longitude, (routelist + i)->lat);
	  text[1] = (routelist + i)->name;
	  sprintf (text0, "%d", i + 1);
	  sprintf (text1, "%8.5f", (routelist + i)->lat);
	  sprintf (text2, "%8.5f", (routelist + i)->longitude);
	  sprintf (text3, "%9.3f", (routelist + i)->dist);
	  text[0] = text0;
	  text[2] = text1;
	  text[3] = text2;
	  text[4] = text3;
	  j = gtk_clist_append (GTK_CLIST (myroutelist), (gchar **) text);
	  gtk_clist_set_foreground (GTK_CLIST (myroutelist), j, &black);
	}
    }
  else
    routeitems = 0;
  tooltips = gtk_tooltips_new ();
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), create_route2_button,
			_
			("Create a route from all waypoints. Sorted with order in file, not distance."),
			NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), select_route_button,
			_
			("Click here to start your journey. GpsDrive guides you through the waypoints in this list."),
			NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), button,
			_("Abort your journey"), NULL);

  gtk_widget_show_all (window);

  return TRUE;
}



void
usage ()
{

/*** Mod by Arms */
  g_print ("%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
	   "\nCopyright (c) 2001,2002 Fritz Ganter <ganter@ganter.at>"
	   "\n              Website: http://www.gpsdrive.de\n\n",
	   _("-v    show version\n"),
	   _("-h    print this help\n"),
	   _("-d    turn on debug info\n"),
	   _("-D    turn on lot of debug info\n"),
	   _("-e    use Festival-Lite (flite) for speech output\n"),
	   _("-t    set serial device for GPS i.e. /dev/ttyS1\n"),
	   _("-o    serial device, pty master, or file for NMEA *output*\n"),
	   _("-f X  Select friends server, X is i.e. linux.quant-x.at\n"),
	   _
	   ("-n X  Select display name on friends server, X is i.e. Fritz\n"),
	   _("-l X  Select language of the voice,\n"
	     "      X may be english, spanish or german\n"),
	   _("-s X  set height of the screen, if autodetection\n"
	     "      don't satisfy you, X is i.e. 768,600,480,200\n"),
/*** Mod by Arms */
	   _("-r X  set width of the screen, only with -s\n"),
	   _
	   ("-1    have only 1 button mouse, for example using touchscreen\n"),
	   _("-a    don't display battery status (i.e. broken APM)\n"),
	   _
	   ("-b X  Servername for NMEA server (if gpsd runs on another host)\n"),
	   _
	   ("-c X  set start position in simulation mode to waypoint name X\n"),
	   _("-x    create separate window for menu\n"),
	   _("-p    set settings for PDA (iPAQ, Yopy...)\n"),
	   _
	   ("-i    ignore NMEA checksum (risky, only for broken GPS receivers\n"),
	   _("-q    disable SQL support\n"),
	   _("-z    don't display zoom factor and scale\n\n"));

}

/*  load the definitions of the map files */

gint
loadmapconfig ()
{
  gchar mappath[400];
  FILE *st;
  gint i;
  gchar buf[512], s1[40], s2[40], s3[40], filename[100];
  gint p, e;

  if (mapdir[strlen (mapdir) - 1] != '/')
    strcat (mapdir, "/");

  strcpy (mappath, mapdir);
  strcat (mappath, "map_koord.txt");
  st = fopen (mappath, "r");
  if (st == NULL)
    {
      mkdir (homedir, 0777);
      st = fopen (mappath, "w+");
      if (st == NULL)
	{
	  perror (mappath);
	  return FALSE;
	}
      st = freopen (mappath, "r", st);
      if (st == NULL)
	{
	  perror (mappath);
	  return FALSE;
	}

    }
  if (nrmaps > 0)
    g_free (maps);

  maps = g_new (mapsstruct, 1);
  i = nrmaps = 0;
  while ((p = fgets (buf, 512, st) != 0))
    {
      e = sscanf (buf, "%s %s %s %s", filename, s1, s2, s3);
      if (e == 4)
	{
	  g_strdelimit (s1, ",", '.');
	  g_strdelimit (s2, ",", '.');
	  g_strdelimit (s3, ",", '.');
	  strcpy ((maps + i)->filename, filename);
	  (maps + i)->lat = g_strtod (s1, NULL);
	  (maps + i)->longitude = g_strtod (s2, NULL);
	  (maps + i)->scale = strtol (s3, NULL, 0);
	  i++;
	  nrmaps = i;
	  maps = g_renew (mapsstruct, maps, (i + 2));
	}
    }
  fclose (st);
  needreloadmapconfig = FALSE;
  return FALSE;
}

/*  write the definitions of the map files */
/* Attention! program  writes decimal point as set in locale
   i.eg 4.678 is in Germany 4,678 !!! */
void
savemapconfig ()
{
  gchar mappath[400];
  FILE *st;
  gint i;

  if (mapdir[strlen (mapdir) - 1] != '/')
    strcat (mapdir, "/");

  strcpy (mappath, mapdir);
  strcat (mappath, "map_koord.txt");
  st = fopen (mappath, "w");
  if (st == NULL)
    {
      perror (mappath);
      exit (2);
    }

  for (i = 0; i < nrmaps; i++)
    {
      fprintf (st, "%s %.5f %.5f %ld\n", (maps + i)->filename,
	       (maps + i)->lat, (maps + i)->longitude, (maps + i)->scale);
    }

  fclose (st);
}


/* Load track file and displays it */
gint
loadtrack_cb (GtkWidget *widget, gpointer datum)
{
  GtkWidget *fdialog;
  gchar buf[1000];
  fdialog = gtk_file_selection_new (_("Select a track file"));
  gtk_window_set_modal (GTK_WINDOW (fdialog), TRUE);

  gtk_signal_connect (GTK_OBJECT
		      (GTK_FILE_SELECTION (fdialog)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (gettrackfile),
		      GTK_OBJECT (fdialog));
  gtk_signal_connect_object (GTK_OBJECT
			     (GTK_FILE_SELECTION (fdialog)->
			      cancel_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (fdialog));


  strcpy (buf, homedir);
  strcat (buf, "track*.sav");
  gtk_file_selection_complete (GTK_FILE_SELECTION (fdialog), buf);
  gtk_widget_show (fdialog);

  return TRUE;
}


/*  load the waypoint from way.txt, if success we display the sel target window */
void
savewaypoints ()
{
  gchar mappath[400], la[20], lo[20];
  FILE *st;
  gint i, e;


  strcpy (mappath, homedir);
  strcat (mappath, activewpfile);

  st = fopen (mappath, "w+");
  if (st == NULL)
    {
      perror (mappath);
    }
  else
    {
      for (i = 0; i < maxwp; i++)
	{
	  sprintf (la, "%10.6f", (wayp + i)->lat);
	  sprintf (lo, "%10.6f", (wayp + i)->longitude);
	  g_strdelimit (la, ",", '.');
	  g_strdelimit (lo, ",", '.');

	  e =
	    fprintf (st, "%-22s %10s %11s %s\n", (wayp + i)->name, la, lo,
		     (wayp + i)->typ);
	}
      fclose (st);
    }

}


/*  load the waypoint from way.txt, if success we display the sel target window */
void
loadwaypoints ()
{
  gchar mappath[400], s[40];
  FILE *st;
  gint i, e, p, wlan, action, sqlnr;
  gchar buf[512], slat[80], slong[80], typ[40];
  struct stat buf2;

  if (waytxtstamp == 0)
    wayp = g_new (wpstruct, wpsize);

  strcpy (mappath, homedir);
  if (!sqlflag)
    strcat (mappath, activewpfile);
  else
    strcat (mappath, "way-SQLRESULT.txt");

  maxwp = 0;
  sqlnr = -1;
  st = fopen (mappath, "r");
  if (st == NULL)
    {
      perror (mappath);
    }
  else
    {
      if (debug)
	g_print ("\nsqlflag: %d, load waypoint file %s\n", sqlflag, mappath);

      i = 0;
      while ((p = fgets (buf, 512, st) != 0))
	{
	  e =
	    sscanf (buf, "%s %s %s %s %d %d %d\n", (wayp + i)->name, slat,
		    slong, typ, &wlan, &action, &sqlnr);
	  (wayp + i)->lat = g_strtod (slat, NULL);
	  (wayp + i)->longitude = g_strtod (slong, NULL);
/*  limit waypoint name to 20 chars */
	  (wayp + i)->name[20] = 0;
	  strcpy ((wayp + i)->typ, "");
	  (wayp + i)->wlan = 0;
	  (wayp + i)->action = 0;
	  (wayp + i)->sqlnr = -1;

	  if (e >= 3)
	    {
	      (wayp + i)->dist = 0;

	      if (e >= 4)
		strcpy ((wayp + i)->typ, typ);

	      if (e >= 5)
		(wayp + i)->wlan = wlan;
	      if (e >= 6)
		(wayp + i)->action = action;
	      if (e >= 7)
		(wayp + i)->sqlnr = sqlnr;


	      if (!sqlflag)
		{
		  if ((strncmp ((wayp + i)->name, "R-", 2)) == 0)
		    (wayp + i)->action = 1;
		}

	      i++;
	      maxwp = i;
	      if (!sqlflag)
		{
		  sprintf (s, "%s %d", _("Show WP"), maxwp);
		  if (GTK_IS_BUTTON (GTK_BUTTON (wpbt)))
		    gtk_label_set_text (GTK_LABEL (GTK_BUTTON (wpbt)->child),
					s);
		  else
		    g_print ("kein button!\n");
		}
	      if (maxwp >= wpsize)
		{
		  wpsize += 1000;
		  wayp = g_renew (wpstruct, wayp, wpsize);
		}

	    }
	}
      fclose (st);
/* Check for changed way.txt file */
      stat (mappath, &buf2);
      waytxtstamp = buf2.st_mtime;

    }

}


gint
initgps ()
{
  struct sockaddr_in server;
  struct hostent *server_data;

/*  We test for gpsd serving */
  {
/*  open socket to port */
    if ((sock = socket (AF_INET, SOCK_STREAM, 0)) < 0)
      {
	perror (_("can't open socket for port "));
	exit (1);
      }
    server.sin_family = AF_INET;
/*  We retrieve the IP address of the server from its name: */
    if ((server_data = gethostbyname (SERVERNAME)) == NULL)
      {
	fprintf (stderr, "%s: unknown host", SERVERNAME);
	exit (1);
      }
    memcpy (&server.sin_addr, server_data->h_addr, server_data->h_length);
    server.sin_port = htons (SERVERPORT2);

/*  We initiate the connection  */
    if (connect (sock, (struct sockaddr *) &server, sizeof server) < 0)
      {
	server.sin_port = htons (SERVERPORT);	/* We try second port */
/*  We initiate the connection  */
	if (connect (sock, (struct sockaddr *) &server, sizeof server) < 0)
	  {
	    haveNMEA = FALSE;
	    simmode = TRUE;
	  }
	else
	  {
	    haveNMEA = TRUE;
	    simmode = FALSE;
	    strcpy (nmeamodeandport, _("NMEA Mode, Port 2222"));
	    strcat (nmeamodeandport, "/");
	    strcat (nmeamodeandport, gpsdservername);
	  }
      }
    else
      {
	strcpy (nmeamodeandport, _("NMEA Mode, Port 2947"));
	strcat (nmeamodeandport, "/");
	strcat (nmeamodeandport, gpsdservername);
	write (sock, "R\n", 2);
	haveNMEA = TRUE;
	simmode = FALSE;
      }


  }

  haveGARMIN = FALSE;

#ifdef NOGARMIN
  g_print (_("\nno garmin support compiled in\n"));
  testgarmin = FALSE;
#else
  if (!testgarmin)
    g_print (_("\nGarmin protocol detection disabled!\n"));
#endif

  if ((!haveNMEA) && (testgarmin))
    {
      typedef struct
      {
	gchar *a1;
	gchar *a2;
	gchar *a3;
      }
      argument;
      argument *argumente;
      gint e;

      argumente = g_new (argument, 1);
      argumente->a1 = "-p";
      argumente->a2 = "-p";
      argumente->a3 = 0;

      e = garblemain (1, (char **) argumente);

      if (e == -2)
	{
	  e = garblemain (1, (char **) argumente);
	  if (e == -2)
	    {
	      haveGARMIN = FALSE;
	      simmode = TRUE;
	    }
	  else
	    {
	      haveGARMIN = TRUE;
	      simmode = FALSE;
	    }
	}
      else
	{
	  haveGARMIN = TRUE;
	  simmode = FALSE;
	}
      g_free (argumente);

      if (haveGARMIN)		/* test it again */
	{
	  argumente = g_new (argument, 1);
	  argumente->a1 = "-p";
	  argumente->a2 = "-p";
	  argumente->a3 = 0;

	  e = garblemain (1, (char **) argumente);
	  if (e == -1)
	    {
	      haveGARMIN = FALSE;
	      simmode = TRUE;
	    }
	}
      if (haveGARMIN)
	g_print
	  ("\nAutomatic Garmin detection found GARMIN-mode receiver \n");
      else
	g_print ("\nno GARMIN-mode receiver found\n");

    }
  if (haveGARMIN || haveNMEA)
    {
      simmode = FALSE;
      if (simpos_timeout != 0)
	gtk_timeout_remove (simpos_timeout);
    }
  return FALSE;			/* to remove timer */
}


/*  on a USR1 signal, re-start the GPS connection  */

void
usr1handler (int sig)
{
  g_print ("\ngot SIGUSR1\n");
  initgps ();
}


/*  Main program */
int
main (int argc, char *argv[])
{
  GtkWidget *vbig, *vbig1, *vbox, *vbox2, *vbox3, *vbox4, *hbig, *hbox2,
    *downloadbt, *hbox2a, *hbox2b;
  GtkWidget *quit, *zoomin, *helpbt, *hbox3, *vboxlow, *hboxlow;
  GtkWidget *menuwin = NULL, *menuwin2 = NULL;
  GtkWidget *zoomout, *sel_target;
  GtkWidget *frame_bearing, *frame_target, *frame_altitude, *frame_maptype,
    *frame_toogles, *lab1, *fbat;
  GString *maintitle;
  GdkColormap *cmap;
/*   GdkColor farbe;   */
  GdkRectangle rectangle = {
    0, 0, SCREEN_X, SCREEN_Y
  };
  gchar *hd;
  gchar buf[500];
  GdkFont *myfont;
/*** Mod by Arms */
  gint i, h, w;
  GtkWidget *table1, *lf1, *lf2, *lf3, *lf4, *lf5, *lf6, *lf7, *lf8;
  GtkTooltips *tooltips;
  GdkPixmap *icon;
  GdkBitmap *mask;
  gchar s1[100], s2[100], *p, *localestring, **lstr, lstr2[200];
  /*** Mod by Arms */
  GtkRequisition requ, *reqptr;
  GtkAccelGroup *accgroup;
  GtkWidget *mainnotebook;
  GModule *mod1;
  void (*modulefunction) ();
  gchar *modpath;
  time_t now = time (NULL);
  struct tm *st = localtime (&now);



  zone = st->tm_gmtoff / 3600;
/*  initialize variables */
/*  Sankt Veit/Glan */
  current_lat = zero_lat = 46.767065;
  current_long = zero_long = 14.359352;
/*    zero_lat and zero_long are overwritten by gpsdriverc,  */

  strcpy (dgpsserver, "dgps.wsrcc.com");
  strcpy (dgpsport, "2104");
  strcpy (gpsdservername, "127.0.0.1");
  direction = angle_to_destination = 0;
  strcpy (targetname, "     ");
  strcpy (utctime, "n/a");
  strcpy (oldangle, "none");
  pixelfact = MAPSCALE / PIXELFACT;
  strcpy (oldfilename, "");
  tempimage = image = NULL;
  simmode = maploaded = FALSE;
  haveNMEA = FALSE;
  havepos = gblink = blink = FALSE;
  haveposcount = haveGARMIN = debug = 0;
  zoom = 1;
  milesflag = iszoomed = FALSE;
  sel_target = NULL;
  tripodometer = tripavspeed = triptime = tripmaxspeed = triptmp = 0.0;

  signal (SIGUSR1, usr1handler);
  timer = g_timer_new ();
  disttimer = g_timer_new ();
  g_timer_start (timer);
  g_timer_start (disttimer);
  memset (satlist, 0, sizeof (satlist));
  memset (satlistdisp, 0, sizeof (satlist));
  buffer = g_new (char, 2010);
  big = g_new (char, MAXBIG + 10);
  friendsbuffer = g_new (char, 200000);
  friendsbuffer[0] = 0;
  friendsbuffstart = friendsbuffend = NULL;


  timeoutcount = lastp = bigp = bigpRME = bigpGSV = bigpGGA = 0;
  lastp = lastpGGA = lastpGSV = lastpRME = 0;
  downloadfilelen = gcount = xoff = yoff = 0;
  hours = minutes = 99;
  milesconv = 1.0;
  downloadwindowactive = downloadactive = importactive = FALSE;
  strcpy (lastradar, "");
  strcpy (lastradar2, "");
  strcpy (activewpfile, "way.txt");
  strcpy (dbhost, "localhost");
  strcpy (dbuser, "gast");
  strcpy (dbpass, "gast");
  strcpy (dbname, "geoinfo");
  strcpy (dbtable, "waypoints");
  dbdistance = 2000.0;
  dbusedist = TRUE;

  voicelang = english;
  track = g_new0 (trackstruct, 100000);
  trackshadow = g_new0 (trackstruct, 100000);
  tracknr = 0;
  trackcoord = g_new0 (trackcoordstruct, 100000);
  trackcoordnr = 0;
  tracklimit = trackcoordlimit = 100000;
  routelist = g_new0 (wpstruct, 100);


  openwlanpixbuf = gdk_pixbuf_new_from_xpm_data ((const char **) open_xpm);
  closedwlanpixbuf =
    gdk_pixbuf_new_from_xpm_data ((const char **) closed_xpm);

  iconpixbuf[0] = gdk_pixbuf_new_from_xpm_data ((const char **) rest_xpm);
  iconpixbuf[1] =
    gdk_pixbuf_new_from_xpm_data ((const char **) mcdonalds_xpm);
  iconpixbuf[2] = gdk_pixbuf_new_from_xpm_data ((const char **) hotel_xpm);
  iconpixbuf[3] =
    gdk_pixbuf_new_from_xpm_data ((const char **) burgerking_xpm);
  iconpixbuf[4] = gdk_pixbuf_new_from_xpm_data ((const char **) shop_xpm);
  iconpixbuf[5] = gdk_pixbuf_new_from_xpm_data ((const char **) monu_xpm);
  iconpixbuf[6] = gdk_pixbuf_new_from_xpm_data ((const char **) girls_xpm);
  iconpixbuf[7] =
    gdk_pixbuf_new_from_xpm_data ((const char **) speedtrap_xpm);
  iconpixbuf[8] = gdk_pixbuf_new_from_xpm_data ((const char **) airport_xpm);
  iconpixbuf[9] = gdk_pixbuf_new_from_xpm_data ((const char **) golf_xpm);
  iconpixbuf[10] = gdk_pixbuf_new_from_xpm_data ((const char **) fuel_xpm);
  iconpixbuf[11] = gdk_pixbuf_new_from_xpm_data ((const char **) cafe_xpm);

  earthr = calcR (current_lat);
/*    homedir is the directory where the maps and other  */
/*  files are stored (~/.gpsdrive) */
  hd = g_get_home_dir ();
  strcpy (homedir, hd);
  strcat (homedir, "/.gpsdrive/");
  strcpy (mapdir, homedir);
/*  all default values must be set BEFORE readconfig! */
  strcpy (setpositionname, "");
  strcpy (serialdev, "/dev/ttyS3");

  readconfig ();

/*  load waypoints before locale is set! */
/*  Attention! In this file the decimal point is always a '.' !! */

/*  setting defaults if setting is not yet in configuraton file */
  if ((milesflag + metricflag + nauticflag) == 0)
    metricflag = TRUE;

  target_long = current_long + 0.00001;
  target_lat = current_lat + 0.00001;

/*  I18l */

/*  Detect the language for voice output */
  localestring = setlocale (LC_ALL, "");
  if (localestring == NULL)
    localestring = setlocale (LC_MESSAGES, "");
  if (localestring != NULL)
    {
      lstr = g_strsplit (localestring, ";", 50);
      strcpy (lstr2, "");
      for (i = 0; i < 50; i++)
	if (lstr[i] != NULL)
	  {
	    if ((strstr (lstr[i], "LC_MESSAGES")) != NULL)
	      {
		strcpy (lstr2, lstr[i]);
		break;
	      }
	  }
	else
	  {
	    strcpy (lstr2, lstr[i - 1]);
	    break;
	  }
    }
  if ((strstr (lstr2, "de_")) != NULL)
    voicelang = german;
  else if ((strstr (lstr2, "es_")) != NULL)
    voicelang = spanish;
  else
    voicelang = english;

/*  load mapfile configurations */
/*  Attention! In this file the decimal point is that what locale says, 
i.e. '.' in english, ',' in german!! */
  loadmapconfig ();
  p = bindtextdomain (PACKAGE, LOCALEDIR);
  p = textdomain (PACKAGE);
  p = textdomain (NULL);
/*    needed for right decimal delimiter ('.' or ',') */
  mylocale = NULL;
  localedecimal = '.';
  mylocale = localeconv ();
  if (mylocale != NULL)
    localedecimal = (char) mylocale->decimal_point[0];

/*    Setting locale for correct Umlauts */
  gtk_set_locale ();
/*  initialization for GTK+ */
  gtk_init (&argc, &argv);
/* Needed 4 hours to find out that this is IMPORTANT!!!! */
  gdk_rgb_init ();


/*  Build array for earth radii */
  for (i = -100; i <= 100; i++)
    Ra[i + 100] = calcR (i);

  h = gdk_screen_height ();
  w = gdk_screen_width ();
/*** Mod by Arms (move) */
  real_screen_x = 640;
  real_screen_y = 512;

/*    g_print ("\nHhe: %d\n", h); */
  strcpy (friendsserver, "127.0.0.1");
  strcpy (friendsname, _("Unknown"));

#ifdef USEMYSQL
  usesql = TRUE;
#endif

  /* parse cmd args */
  do
    {
/*** Mod by Arms */
      i = getopt (argc, argv, "ab:c:zx1qivdDephn:f:l:t:s:o:r:?");
      switch (i)
	{
	case 'a':
	  disableapm = TRUE;
	  break;
	case 'q':
	  usesql = FALSE;
	  break;
	case 'd':
	  debug = TRUE;
	  break;
	case 'D':
	  mydebug = TRUE;
	  break;
	case 'e':
	  useflite = TRUE;
	  break;
	case 'i':
	  ignorechecksum = TRUE;
	  g_print ("\nWARNING: NMEA checksum test switched off!\n\n");
	  break;
	case 'x':
	  extrawinmenu = TRUE;
	  break;
	case 'p':
	  pdamode = TRUE;
	  break;
	case '1':
	  onemousebutton = TRUE;
	  break;
	case 'v':
	  printf ("\ngpsdrive (c) 2001,2002 Fritz Ganter <ganter@ganter.at>\n"
		  "\nVersion %s\n%s\n\n", VERSION, rcsid);
	  exit (0);
	  break;
	case 't':
	  strcpy (serialdev, optarg);
	  break;
	case 'b':
	  strcpy (gpsdservername, optarg);
	  break;
	case 'c':
	  strcpy (setpositionname, optarg);
	  break;
	case 'f':
	  strcpy (friendsserver, optarg);
	  break;
	case 'n':
	  strcpy (friendsname, optarg);
	  break;
	case 's':
	  h = strtol (optarg, NULL, 0);
	  break;
	case 'l':
	  if (!strcmp (optarg, "english"))
	    voicelang = english;
	  else if (!strcmp (optarg, "german"))
	    voicelang = german;
	  else if (!strcmp (optarg, "spanish"))
	    voicelang = spanish;
	  else
	    {
	      usage ();
	      g_print (_
		       ("\nYou can only choose between english, spanish and german\n\n"));
	      exit (0);
	    }
	  break;
	case 'o':
	  nmeaout = opennmea (optarg);
	  break;
	case 'h':
	  usage ();
	  exit (0);
	  break;
	case '?':
	  usage ();
	  exit (0);
	  break;
/*** Mod by Arms */
	case 'r':
	  w = strtol (optarg, NULL, 0);
	  break;
	case 'z':
	  zoomscale = FALSE;
	  break;
	}
    }
  while (i != -1);


  gethostname (hostname, 256);
  proxyport = 80;
  haveproxy = FALSE;

  p = g_getenv ("HTTP_PROXY");
  if (p == NULL)
    p = g_getenv ("http_proxy");

  if (debug)
    printf ("\ngpsdrive (c) 2001,2002 Fritz Ganter <ganter@ganter.at>\n"
	    "\nVersion %s\n%s\n\n", VERSION, rcsid);

  if (p)
    {
      g_strdelimit (p, ":/", ' ');

      i = sscanf (p, "%s %s %d", s1, s2, &proxyport);
      if (i == 3)
	{
	  haveproxy = TRUE;
	  strcpy (proxy, s2);
	  if (debug)
	    g_print (_("\nUsing proxy: %s on port %d"), proxy, proxyport);
	}
      else
	{
	  g_print (_("\nInvalid enviroment variable HTTP_PROXY, "
		     "must be in format: http://proxy.provider.de:3128"));
	}
    }

  if (debug)
    g_print ("\nGpsDrive version %s\n%s\n", VERSION, rcsid);

/*  show splash screen */
  splash ();

/* init sql support */
  if (usesql)
    usesql = sqlinit ();

  if (!usesql)
    sqlflag = FALSE;

/* loadwaypoints moved down */


/* Create toplevel window */

  PSIZE = 50;
  SMALLMENU = 0;
/*** Mod by Arms */
  PADDING = 1;
  if (h >= 768)			/* 1024x768 */
    {
      real_screen_x = 640;
      real_screen_y = 512;
    }
  else if (h >= 600)		/* 800x600 */
    {
      real_screen_x = 650;
      real_screen_y = 455;
      PADDING = 0;

    }
  else if (h >= 480)		/* 640x480 */
    {
/*** Mod by Arms */
      if (w == 0)
	real_screen_x = 630;
      else
	real_screen_x = w - XMINUS;
      real_screen_y = h - YMINUS;
    }
  else if (h < 480)
    {
/*** Mod by Arms */
      if (w == 0)
	real_screen_x = 220;
      else
	real_screen_x = w - XMINUS;
      real_screen_y = h - YMINUS;
      PSIZE = 25;
      SMALLMENU = 1;
/*** Mod by Arms */
      PADDING = 0;
    }

  if ((extrawinmenu) && (w != 0))
    {
      real_screen_x += XMINUS - 10;
      real_screen_y += YMINUS - 30;
    }

/*   g_print ("\nx: %d, y:%d", h, w); */
  if (((w == 240) && (h == 320)) || ((h == 240) && (w == 320)))
    {
      pdamode = TRUE;
/*       SMALLMENU = 1; */
      real_screen_x = w - 8;
      real_screen_y = h - 70;
    }
  if (pdamode)
    {
      extrawinmenu = TRUE;
      PADDING = 0;
      g_print ("\nPDA mode\n");
    }

  if (real_screen_x < real_screen_y)
    borderlimit = real_screen_x / 5;
  else
    borderlimit = real_screen_y / 5;

  if (borderlimit < 30)
    borderlimit = 30;

  SCREEN_X_2 = SCREEN_X / 2;
  SCREEN_Y_2 = SCREEN_Y / 2;
  PSIZE = 50;
  posx = SCREEN_X_2;
  posy = SCREEN_Y_2;


#ifndef NOPLUGINS
  useplugins = TRUE;
#endif
  if (pdamode)
    useplugins = FALSE;

  if (usesql)
    {
      mod_setupcounter++;
      setupfunction[mod_setupcounter] = &(sqlsetup);
      sqlplace = mod_setupcounter;
    }

  if (useplugins)
    {
/*  fly module */
      modpath = g_module_build_path (LIBDIR, "libfly.so");
      mod1 = g_module_open (".libs/libfly.so", 0);
      if (mod1 == NULL)
	mod1 = g_module_open (modpath, 0);
      if (mod1 != NULL)
	{
	  gint *modulever;
	  mod_setupcounter++;

	  i =
	    g_module_symbol (mod1, "moduleversion", (gpointer *) &modulever);
	  g_print (" (Version %d)", *modulever);
	  i =
	    g_module_symbol (mod1, "modulesetup",
			     (gpointer *) &modulefunction);
	  setupfunction[mod_setupcounter] = modulefunction;
	}

/*  nautic module */
      modpath = g_module_build_path (LIBDIR, "libnautic.so");
      mod1 = g_module_open (".libs/libnautic.so", 0);
      if (mod1 == NULL)
	mod1 = g_module_open (modpath, 0);
      if (mod1 != NULL)
	{
	  gint *modulever;
	  mod_setupcounter++;
	  i =
	    g_module_symbol (mod1, "moduleversion", (gpointer *) &modulever);
	  g_print (" (Version %d)", *modulever);
	  i =
	    g_module_symbol (mod1, "modulesetup",
			     (gpointer *) &modulefunction);
	  setupfunction[mod_setupcounter] = modulefunction;
	}
    }

/*   gdk_color_parse ("red", &farbe); */
/*   mainstyle = gtk_rc_style_new (); */
/*   mainstyle->text[GTK_STATE_NORMAL] = farbe;   */
/*   mainstyle->bg[GTK_STATE_NORMAL] = farbe;   */
/*   mainstyle->color_flags[GTK_STATE_NORMAL] |= GTK_RC_FG;  */

  mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_transient_for (GTK_WINDOW (splash_window),
				GTK_WINDOW (mainwindow));

/* gtk_widget_modify_style (mainwindow, mainstyle); */

  maintitle = g_string_new (NULL);
  g_string_sprintf (maintitle,
		    "%s v%s   2001,2002 Fritz Ganter", "GpsDrive", VERSION);
  gtk_window_set_title (GTK_WINDOW (mainwindow), maintitle->str);
  gtk_container_set_border_width (GTK_CONTAINER (mainwindow), 0);
  gtk_window_set_position (GTK_WINDOW (mainwindow), GTK_WIN_POS_CENTER);
  gtk_signal_connect (GTK_OBJECT (mainwindow), "delete_event",
		      GTK_SIGNAL_FUNC (quit_program), NULL);

  gtk_signal_connect (GTK_OBJECT (mainwindow), "key_press_event",
		      GTK_SIGNAL_FUNC (key_cb), NULL);

  status = gtk_statusbar_new ();
  statusid = gtk_statusbar_get_context_id (GTK_STATUSBAR (status), "main");
  gtk_statusbar_push (GTK_STATUSBAR (status), statusid,
		      _("(c)2001,2002 F.Ganter"));
  if (!useflite)
    havespeechout = speech_out_init ();
  else
    havespeechout = TRUE;

  if (havespeechout)
    gtk_statusbar_push (GTK_STATUSBAR (status), statusid,
			_("Using speech output"));
  if (!useflite)
    switch (voicelang)
      {
      case english:
	speech_out_speek_raw (FESTIVAL_ENGLISH_INIT);
	break;
      case spanish:
	speech_out_speek_raw (FESTIVAL_SPANISH_INIT);
	break;
      case german:
	speech_out_speek_raw (FESTIVAL_GERMAN_INIT);
	break;
      }

/*** Mod by Arms */
  vbig = gtk_vbox_new (FALSE, 2 * PADDING);
/*** Mod by Arms */
  hbig = gtk_hbox_new (FALSE, 2 * PADDING);


/*  download map button */
  downloadbt = gtk_button_new_with_label (_("Download map"));
  gtk_signal_connect (GTK_OBJECT (downloadbt),
		      "clicked", GTK_SIGNAL_FUNC (download_cb), (gpointer) 1);
/*  Quit button */
  quit = gtk_button_new_with_label (_("Quit"));
  gtk_signal_connect (GTK_OBJECT (quit),
		      "clicked", GTK_SIGNAL_FUNC (quit_program), 0);
/*    GTK_WIDGET_SET_FLAGS (quit, GTK_CAN_DEFAULT); */

  if (havespeechout)
    {
      mutebt = gtk_check_button_new_with_label (_("Mute"));
      if (muteflag)
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mutebt), TRUE);

      gtk_signal_connect (GTK_OBJECT (mutebt),
			  "clicked", GTK_SIGNAL_FUNC (mute_cb), (gpointer) 1);
    }
  if (usesql)
    {
      sqlbt = gtk_check_button_new_with_label (_("Use SQL"));
      if (sqlflag)
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sqlbt), TRUE);

      gtk_signal_connect (GTK_OBJECT (sqlbt),
			  "clicked", GTK_SIGNAL_FUNC (sql_cb), (gpointer) 1);
    }


  wpbt = gtk_check_button_new_with_label (_("Show WP"));
  if (wpflag)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (wpbt), TRUE);
  gtk_signal_connect (GTK_OBJECT (wpbt),
		      "clicked", GTK_SIGNAL_FUNC (wp_cb), (gpointer) 1);


  if (sqlflag)
    {
      getsqltypelist ();
      getsqldata ();
    }
  else
    loadwaypoints ();

  for (i = 0; i < maxwp; i++)
    {
      if (strlen (setpositionname) > 0)
	if (!(strcasecmp ((wayp + i)->name, setpositionname)))
	  {
	    current_lat = (wayp + i)->lat;
	    current_long = (wayp + i)->longitude;
	    target_long = current_long + 0.00001;
	    target_lat = current_lat + 0.00001;
	  }
    }

  posbt = gtk_check_button_new_with_label (_("Pos. mode"));

  gtk_signal_connect (GTK_OBJECT (posbt),
		      "clicked", GTK_SIGNAL_FUNC (pos_cb), (gpointer) 1);

  trackbt = gtk_check_button_new_with_label (_("Show Track"));
  if (trackflag)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (trackbt), TRUE);
  gtk_signal_connect (GTK_OBJECT (trackbt),
		      "clicked", GTK_SIGNAL_FUNC (track_cb), (gpointer) 1);

  importbt = gtk_button_new_with_label (_("Import"));
  gtk_signal_connect (GTK_OBJECT (importbt),
		      "clicked", GTK_SIGNAL_FUNC (import1_cb), (gpointer) 1);
/*    GTK_WIDGET_SET_FLAGS (importbt, GTK_CAN_DEFAULT); */

  loadtrackbt = gtk_button_new_with_label (_("Load track"));
  gtk_signal_connect (GTK_OBJECT (loadtrackbt),
		      "clicked", GTK_SIGNAL_FUNC (loadtrack_cb),
		      (gpointer) 1);
/*    GTK_WIDGET_SET_FLAGS (loadtrackbt, GTK_CAN_DEFAULT); */

  helpbt = gtk_button_new_with_label (_("Help"));
  gtk_signal_connect (GTK_OBJECT (helpbt),
		      "clicked", GTK_SIGNAL_FUNC (help_cb), (gpointer) 1);
/*    GTK_WIDGET_SET_FLAGS (helpbt, GTK_CAN_DEFAULT); */

  setupbt = gtk_button_new_with_label (_("Setup"));
  gtk_signal_connect (GTK_OBJECT (setupbt),
		      "clicked", GTK_SIGNAL_FUNC (setup_cb), (gpointer) 0);

  startgpsbt = gtk_button_new_with_label (_("Start GPSD"));
  gtk_signal_connect (GTK_OBJECT (startgpsbt),
		      "clicked", GTK_SIGNAL_FUNC (startgpsd), (gpointer) 0);

  bestmapbt = gtk_check_button_new_with_label (_("Auto best map"));
  if (!scaleprefered)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bestmapbt), TRUE);
  gtk_signal_connect (GTK_OBJECT (bestmapbt),
		      "clicked", GTK_SIGNAL_FUNC (bestmap_cb), (gpointer) 1);


  savetrackfile (TRUE);
  sprintf (s1, "%s", _("Save track"));
  savetrackbt = gtk_check_button_new_with_label (s1);
  if (savetrack)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (savetrackbt), TRUE);
  gtk_signal_connect (GTK_OBJECT (savetrackbt),
		      "clicked", GTK_SIGNAL_FUNC (savetrack_cb),
		      (gpointer) 1);

  sprintf (s1, "%s", savetrackfn);
  lab1 = gtk_label_new (s1);

  frame_maptype = gtk_frame_new (_("Shown map type"));
/*** Mod by Arms */
  vbox3 = gtk_vbox_new (TRUE, 1 * PADDING);
  gtk_container_add (GTK_CONTAINER (frame_maptype), vbox3);

  frame_toogles = gtk_frame_new (NULL);
/*** Mod by Arms */
  vbox4 = gtk_vbox_new (TRUE, 1 * PADDING);
  gtk_container_add (GTK_CONTAINER (frame_toogles), vbox4);


  maptogglebt = gtk_check_button_new_with_label (_("Street map"));
  if (displaymap_map)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (maptogglebt), TRUE);

  gtk_signal_connect (GTK_OBJECT (maptogglebt),
		      "clicked", GTK_SIGNAL_FUNC (maptoggle_cb),
		      (gpointer) 1);
  topotogglebt = gtk_check_button_new_with_label (_("Topo map"));
  if (displaymap_top)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (topotogglebt), TRUE);

  gtk_signal_connect (GTK_OBJECT (topotogglebt),
		      "clicked", GTK_SIGNAL_FUNC (topotoggle_cb),
		      (gpointer) 1);
/*** Mod by Arms */
  gtk_box_pack_start (GTK_BOX (vbox3), maptogglebt, FALSE, FALSE,
		      0 * PADDING);
/*** Mod by Arms */
  gtk_box_pack_start (GTK_BOX (vbox3), topotogglebt, FALSE, FALSE,
		      0 * PADDING);



/*  Zoom in button */
  zoomin = gtk_button_new_with_label (_("Zoom in"));
  gtk_signal_connect (GTK_OBJECT (zoomin),
		      "clicked", GTK_SIGNAL_FUNC (zoom_cb), (gpointer) 1);
/*    GTK_WIDGET_SET_FLAGS (zoomin, GTK_CAN_DEFAULT); */
/*  Zoom out button */
  zoomout = gtk_button_new_with_label (_("Zoom out"));
  gtk_signal_connect (GTK_OBJECT (zoomout),
		      "clicked", GTK_SIGNAL_FUNC (zoom_cb), (gpointer) 2);
/*    GTK_WIDGET_SET_FLAGS (zoomout, GTK_CAN_DEFAULT); */


  scalerrbt = gtk_button_new_with_label (">>");
  gtk_signal_connect (GTK_OBJECT (scalerrbt),
		      "clicked", GTK_SIGNAL_FUNC (scalerbt_cb), (gpointer) 1);
/*    GTK_WIDGET_SET_FLAGS (scalerrbt, GTK_CAN_DEFAULT); */
  scalerlbt = gtk_button_new_with_label ("<<");
  gtk_signal_connect (GTK_OBJECT (scalerlbt),
		      "clicked", GTK_SIGNAL_FUNC (scalerbt_cb), (gpointer) 2);
/*    GTK_WIDGET_SET_FLAGS (scalerlbt, GTK_CAN_DEFAULT); */

/*  Select target button */
/*    if (maxwp > 0) */
  {
    sel_target = gtk_button_new_with_label (_("Select target"));
    gtk_signal_connect (GTK_OBJECT (sel_target),
			"clicked",
			GTK_SIGNAL_FUNC (sel_target_cb), (gpointer) 2);
/*        GTK_WIDGET_SET_FLAGS (sel_target, GTK_CAN_DEFAULT); */
  }

/*  key accelerators (short cuts)*/
  accgroup = gtk_accel_group_new ();
  gtk_accel_group_attach (accgroup, GTK_OBJECT (mainwindow));

/*  Zoom in */
  gtk_widget_add_accelerator (GTK_WIDGET (zoomin), "clicked", accgroup, '+',
			      0, GTK_ACCEL_VISIBLE);

/*  zoom out */
  gtk_widget_add_accelerator (GTK_WIDGET (zoomout), "clicked", accgroup, '-',
			      0, GTK_ACCEL_VISIBLE);

/*  Larger map */
  gtk_widget_add_accelerator (GTK_WIDGET (scalerrbt), "clicked", accgroup,
			      'S', 0, GTK_ACCEL_VISIBLE);

/* Smaller map */
  gtk_widget_add_accelerator (GTK_WIDGET (scalerlbt), "clicked", accgroup,
			      'A', 0, GTK_ACCEL_VISIBLE);

/*  Select target */
  gtk_widget_add_accelerator (GTK_WIDGET (sel_target), "clicked", accgroup,
			      'T', 0, GTK_ACCEL_VISIBLE);

/*  Download map */
  gtk_widget_add_accelerator (GTK_WIDGET (downloadbt), "clicked", accgroup,
			      'D', 0, GTK_ACCEL_VISIBLE);

/*  Import map */
  gtk_widget_add_accelerator (GTK_WIDGET (importbt), "clicked", accgroup, 'I',
			      0, GTK_ACCEL_VISIBLE);

/*  Load Track */
  gtk_widget_add_accelerator (GTK_WIDGET (loadtrackbt), "clicked", accgroup,
			      'L', 0, GTK_ACCEL_VISIBLE);

/*  Show Help */
  gtk_widget_add_accelerator (GTK_WIDGET (helpbt), "clicked", accgroup, 'H',
			      0, GTK_ACCEL_VISIBLE);

/*  Start gpsd */
  gtk_widget_add_accelerator (GTK_WIDGET (helpbt), "clicked", accgroup, 'G',
			      0, GTK_ACCEL_VISIBLE);

/*  Setup */
  gtk_widget_add_accelerator (GTK_WIDGET (setupbt), "clicked", accgroup, 'U',
			      0, GTK_ACCEL_VISIBLE);

/*  Quit button */
  gtk_widget_add_accelerator (GTK_WIDGET (quit), "clicked", accgroup, 'Q', 0,
			      GTK_ACCEL_VISIBLE);


/*  toggle best map */
  gtk_widget_add_accelerator (GTK_WIDGET (bestmapbt), "clicked", accgroup,
			      'B', 0, GTK_ACCEL_VISIBLE);

/*  toggle show waypoints */
  gtk_widget_add_accelerator (GTK_WIDGET (wpbt), "clicked", accgroup, 'W', 0,
			      GTK_ACCEL_VISIBLE);

/*  toggle pos mode*/
  gtk_widget_add_accelerator (GTK_WIDGET (posbt), "clicked", accgroup, 'P', 0,
			      GTK_ACCEL_VISIBLE);

/*  toggle show tracks  */
  gtk_widget_add_accelerator (GTK_WIDGET (trackbt), "clicked", accgroup, 'O',
			      0, GTK_ACCEL_VISIBLE);



/*    gtk_window_set_default (GTK_WINDOW (mainwindow), zoomin); */
/*    if we want NMEA mode, gpsd must be running and we connect to port 2222 */
/*    An alternate gpsd server may be on 2947, we try it also */

  initgps ();

  if (haveGARMIN || haveNMEA)
    {
      gtk_widget_set_sensitive (startgpsbt, FALSE);
    }


  openfriendsport ();
  if (usesql)
    initkismet ();
  if (havekismet)
    {
      g_print (_("\nkismet server found\n"));
      switch (voicelang)
	{
	case english:
	  sprintf (buf, "Found kismet. Happy wardriving");
	  break;
	case spanish:
	  sprintf (buf, "Found kismet. Happy wardriving");
	  break;
	case german:
	  sprintf (buf, "Kismet gefunden. Viel Spass beim wordreifing");
	}
      speech_out_speek (buf);
    }

  if (havefriends)
    {
      loadfriendsicon ();
/*  limit to 1000 friends at the moment */
      friends = g_new (friendsstruct, 1000);
    }
/*  Area for map */
  drawing_area = gtk_drawing_area_new ();
  gtk_drawing_area_size (GTK_DRAWING_AREA (drawing_area), SCREEN_X, SCREEN_Y);
/*** Mod by Arms */
  gtk_box_pack_start (GTK_BOX (vbig), drawing_area, TRUE, TRUE, 2 * PADDING);
  gtk_widget_add_events (GTK_WIDGET (drawing_area), GDK_BUTTON_PRESS_MASK);
  gtk_signal_connect_object (GTK_OBJECT (drawing_area),
			     "button-press-event",
			     GTK_SIGNAL_FUNC (mapclick_cb),
			     GTK_OBJECT (drawing_area));
/* Area for navigation pointer */
  drawing_bearing = gtk_drawing_area_new ();
  gtk_drawing_area_size (GTK_DRAWING_AREA (drawing_bearing), PSIZE + 2,
			 PSIZE + 2);
  gtk_signal_connect (GTK_OBJECT (drawing_bearing),
		      "expose_event", GTK_SIGNAL_FUNC (expose_compass), NULL);
/* Area for mini map */
/*** Mod by Arms */
/* With small displays, this isn't really necessary! */
  if (SMALLMENU == 0)
    {
      drawing_miniimage = gtk_drawing_area_new ();
      gtk_drawing_area_size (GTK_DRAWING_AREA (drawing_miniimage), 128, 103);
      gtk_signal_connect (GTK_OBJECT (drawing_miniimage),
			  "expose_event", GTK_SIGNAL_FUNC (expose_mini_cb),
			  NULL);
      gtk_widget_add_events (GTK_WIDGET (drawing_miniimage),
			     GDK_BUTTON_PRESS_MASK);
      gtk_signal_connect_object (GTK_OBJECT (drawing_miniimage),
				 "button-press-event",
				 GTK_SIGNAL_FUNC (minimapclick_cb),
				 GTK_OBJECT (drawing_miniimage));
    }
/*** Mod by Arms */
  hbox2 = gtk_hbox_new (FALSE, 1 * PADDING);
  hbox2a = gtk_hbox_new (FALSE, 1 * PADDING);
  hbox2b = gtk_vbox_new (FALSE, 1 * PADDING);
/*** Mod by Arms */
  hbox3 = gtk_hbox_new (FALSE, 1 * PADDING);
  frame_bearing = gtk_frame_new (_("Bearing"));
  gtk_container_add (GTK_CONTAINER (frame_bearing), drawing_bearing);
/*** Mod by Arms */
  gtk_box_pack_start (GTK_BOX (hbox2), frame_bearing, FALSE, FALSE,
		      1 * PADDING);
/* Area for field strength, we have data only in NMEA mode */
  drawing_sats = gtk_drawing_area_new ();
  gtk_drawing_area_size (GTK_DRAWING_AREA (drawing_sats), PSIZE + 10, PSIZE);
  gtk_signal_connect (GTK_OBJECT (drawing_sats),
		      "expose_event", GTK_SIGNAL_FUNC (expose_sats_cb), NULL);
  gtk_widget_add_events (GTK_WIDGET (drawing_sats), GDK_BUTTON_PRESS_MASK);
  gtk_signal_connect (GTK_OBJECT (drawing_sats),
		      "button-press-event",
		      GTK_SIGNAL_FUNC (satpos_cb), NULL);
  frame_sats = gtk_frame_new (_("Sat level"));
  gtk_container_add (GTK_CONTAINER (frame_sats), drawing_sats);

/*** Mod by Arms */
  gtk_box_pack_start (GTK_BOX (hbox2), frame_sats, FALSE, FALSE, 1 * PADDING);

  havebattery = battery_get_values ();

  if (havebattery)
    {
      drawing_battery = gtk_drawing_area_new ();
      gtk_drawing_area_size (GTK_DRAWING_AREA (drawing_battery), 27, 52);
      fbat = gtk_frame_new (_("Bat."));
      gtk_container_add (GTK_CONTAINER (fbat), drawing_battery);
      gtk_box_pack_start (GTK_BOX (hbox2), fbat, FALSE, FALSE, 1 * PADDING);
    }
/*   if (havebattery) */
/*     expose_display_battery (); */

  if (pdamode)
    gtk_box_pack_start (GTK_BOX (hbox2), hbox2b, TRUE, TRUE, 1 * PADDING);

/*  displays distance to destination */
  distlabel = gtk_label_new (_("---"));
  gtk_label_set_justify (GTK_LABEL (distlabel), GTK_JUSTIFY_RIGHT);
/*  displays speed over ground */
  speedlabel = gtk_label_new (_("---"));
  gtk_label_set_justify (GTK_LABEL (speedlabel), GTK_JUSTIFY_RIGHT);
/*  displays zoom factor of map */
  altilabel = gtk_label_new (_("n/a"));
  gtk_label_set_justify (GTK_LABEL (altilabel), GTK_JUSTIFY_RIGHT);

/*    We load a large font for above labels, if we can't get the first */
/*  we try the next */
  if (pdamode)
    {
      myfont = gdk_font_load (FONTTINY);
      if (myfont == NULL)
	myfont = gdk_font_load (FONTTINY2);

      style = gtk_style_copy (gtk_widget_get_style (distlabel));
      if (myfont != NULL)
	style->font = myfont;
      style->fg[0] = blue;
      style->bg[0] = lcd;
      gtk_widget_push_style (style);
      textfont = gdk_font_load (TEXTFONT);
      if (textfont == NULL)
	textfont = gdk_font_load (TEXTFONT2);
      smalltextfont = gdk_font_load (SMALLTEXTFONT);
      if (smalltextfont == NULL)
	smalltextfont = gdk_font_load (SMALLTEXTFONT2);

      bigtextfont = gdk_font_load (FONT2);
      if (bigtextfont == NULL)
	bigtextfont = gdk_font_load (FONTTINY);
      if (bigtextfont == NULL)
	bigtextfont = gdk_font_load (FONTTINY2);
      if (bigtextfont == NULL)
	{
	  g_print ("\nfont problem, please report!\n");
	  exit (1);
	}

      bigtextfont2 = gdk_font_load (FONT2);
      if (bigtextfont2 == NULL)
	bigtextfont2 = gdk_font_load (FONTTINY);
      if (bigtextfont2 == NULL)
	bigtextfont2 = gdk_font_load (FONTTINY2);
      if (bigtextfont2 == NULL)
	{
	  g_print ("\nfont problem, please report!\n");
	  exit (1);
	}
    }
  else
    {
      if (PSIZE >= 50)
	myfont = gdk_font_load (FONT1);
      else
	myfont = gdk_font_load (FONTTINY);

      if (myfont == NULL)
	myfont = gdk_font_load (FONT2);
      style = gtk_style_copy (gtk_widget_get_style (distlabel));
      if (myfont != NULL)
	style->font = myfont;
      style->fg[0] = blue;
      style->bg[0] = lcd;
      gtk_widget_push_style (style);
      textfont = gdk_font_load (TEXTFONT);
      if (textfont == NULL)
	textfont = gdk_font_load (TEXTFONT2);
      smalltextfont = gdk_font_load (SMALLTEXTFONT);
      if (smalltextfont == NULL)
	smalltextfont = gdk_font_load (SMALLTEXTFONT2);
      bigtextfont = gdk_font_load (FONT1);
      if (bigtextfont == NULL)
	bigtextfont = gdk_font_load (FONT2);
      if (bigtextfont == NULL)
	bigtextfont = gdk_font_load (FONTTINY);
      if (bigtextfont == NULL)
	bigtextfont = gdk_font_load (FONTTINY2);
      if (bigtextfont == NULL)
	{
	  g_print ("\nfont problem, please report!\n");
	  exit (1);
	}

      bigtextfont2 = gdk_font_load (FONT3);
      if (bigtextfont2 == NULL)
	bigtextfont2 = gdk_font_load (FONT4);
      if (bigtextfont2 == NULL)
	bigtextfont2 = gdk_font_load (FONT1);
      if (bigtextfont2 == NULL)
	bigtextfont2 = gdk_font_load (FONT2);
      if (bigtextfont2 == NULL)
	bigtextfont2 = gdk_font_load (FONTTINY);
      if (bigtextfont2 == NULL)
	bigtextfont2 = gdk_font_load (FONTTINY2);
      if (bigtextfont2 == NULL)
	{
	  g_print ("\nfont problem, please report!\n");
	  exit (1);
	}

    }
  verysmalltextfont = gdk_font_load (SMALLTEXTFONT3);
  if (verysmalltextfont == NULL)
    verysmalltextfont = gdk_font_load (SMALLTEXTFONT4);

  gtk_widget_set_style (GTK_WIDGET (distlabel), style);
  gtk_widget_set_style (GTK_WIDGET (speedlabel), style);
  gtk_widget_set_style (GTK_WIDGET (altilabel), style);
  gtk_widget_pop_style ();

  style = gtk_style_copy (gtk_widget_get_style (lab1));
  style->fg[0] = red;
  gtk_widget_set_style (GTK_WIDGET (lab1), style);
  gtk_widget_pop_style ();


/*  create frames for labels */
  frame_target = gtk_frame_new (_("Distance to target"));
  destframe = frame_target;
  gtk_container_add (GTK_CONTAINER (frame_target), distlabel);
/*** Mod by Arms */
  if (!pdamode)
    gtk_box_pack_start (GTK_BOX (hbox2), frame_target, TRUE, TRUE,
			2 * PADDING);
  else
    gtk_box_pack_start (GTK_BOX (hbox2a), frame_target, TRUE, TRUE,
			2 * PADDING);
  if (pdamode)
    {
      if (milesflag)
	sprintf (s1, "[%s]", _("mi/h"));
      else if (nauticflag)
	sprintf (s1, "[%s]", _("knots"));
      else
	sprintf (s1, "[%s]", _("km/h"));
    }
  else
    {
      if (milesflag)
	sprintf (s1, "%s [%s]", _("Speed"), _("mi/h"));
      else if (nauticflag)
	sprintf (s1, "%s [%s]", _("Speed"), _("knots"));
      else
	sprintf (s1, "%s [%s]", _("Speed"), _("km/h"));
    }
  frame_speed = gtk_frame_new (s1);
  gtk_container_add (GTK_CONTAINER (frame_speed), speedlabel);
/*** Mod by Arms */
  if (!pdamode)
    gtk_box_pack_start (GTK_BOX (hbox2), frame_speed, TRUE, TRUE,
			1 * PADDING);

  frame_altitude = gtk_frame_new (_("Altitude"));
  gtk_container_add (GTK_CONTAINER (frame_altitude), altilabel);
/*** Mod by Arms */
  if (!pdamode)
    gtk_box_pack_start (GTK_BOX (hbox2), frame_altitude, FALSE, TRUE,
			1 * PADDING);

#ifdef WANTSHADOW
  gtk_frame_set_shadow_type (GTK_FRAME (frame_bearing), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (frame_target), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (frame_speed), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (frame_altitude), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (frame_sats), GTK_SHADOW_IN);
#endif
/*    gtk_box_pack_start (GTK_BOX (vbig), hbox2, TRUE, TRUE, 2); */
/*** Lots of Mods by Arms */
  vbox = gtk_vbox_new (TRUE, 3 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), zoomin, FALSE, FALSE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), zoomout, FALSE, FALSE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), hbox3, FALSE, FALSE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (hbox3), scalerlbt, TRUE, TRUE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (hbox3), scalerrbt, TRUE, TRUE, 1 * PADDING);
/*  only if we have read in waypoints we have the select target button */
/*    if (maxwp > 0) */
  gtk_box_pack_start (GTK_BOX (vbox), sel_target, FALSE, FALSE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), downloadbt, FALSE, FALSE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), importbt, FALSE, FALSE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), loadtrackbt, FALSE, FALSE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), helpbt, FALSE, FALSE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), startgpsbt, FALSE, FALSE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), setupbt, FALSE, FALSE, 1 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox), quit, FALSE, FALSE, 1 * PADDING);
  hboxlow = vbox2 = NULL;
  if (!extrawinmenu)
    {
      vbox2 = gtk_vbox_new (FALSE, 0 * PADDING);
      gtk_box_pack_start (GTK_BOX (vbox2), vbox, TRUE, TRUE, 1 * PADDING);
      gtk_box_pack_start (GTK_BOX (vbox2), frame_toogles, TRUE, TRUE,
			  1 * PADDING);
      gtk_box_pack_start (GTK_BOX (vbox2), frame_maptype, TRUE, TRUE,
			  1 * PADDING);
      if (SMALLMENU == 0)
	gtk_box_pack_start (GTK_BOX (vbox2), GTK_WIDGET (drawing_miniimage),
			    TRUE, FALSE, 0 * PADDING);
    }
  else
    {
      vboxlow = gtk_vbox_new (FALSE, 0 * PADDING);
      hboxlow = gtk_hbox_new (FALSE, 0 * PADDING);
      gtk_box_pack_start (GTK_BOX (vboxlow), frame_toogles, TRUE, TRUE,
			  1 * PADDING);
      gtk_box_pack_start (GTK_BOX (vboxlow), frame_maptype, TRUE, TRUE,
			  1 * PADDING);
      if (SMALLMENU == 0)
	gtk_box_pack_start (GTK_BOX (vboxlow), GTK_WIDGET (drawing_miniimage),
			    TRUE, FALSE, 0 * PADDING);
      gtk_box_pack_start (GTK_BOX (hboxlow), vbox, TRUE, TRUE, 1 * PADDING);
      gtk_box_pack_start (GTK_BOX (hboxlow), vboxlow, TRUE, TRUE,
			  1 * PADDING);

    }


  if (havespeechout)
    gtk_box_pack_start (GTK_BOX (vbox4), mutebt, FALSE, FALSE, 0 * PADDING);
  if (usesql)
    gtk_box_pack_start (GTK_BOX (vbox4), sqlbt, FALSE, FALSE, 0 * PADDING);
/*    if (maxwp > 0) */
  gtk_box_pack_start (GTK_BOX (vbox4), wpbt, FALSE, FALSE, 0 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox4), posbt, FALSE, FALSE, 0 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox4), trackbt, FALSE, FALSE, 0 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox4), bestmapbt, FALSE, FALSE, 0 * PADDING);
  gtk_box_pack_start (GTK_BOX (vbox4), savetrackbt, FALSE, FALSE,
		      0 * PADDING);

  adj = gtk_adjustment_new (12, 0, 29, 1, 4, 0.034);
  scaler = gtk_hscale_new (GTK_ADJUSTMENT (adj));
  gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		      GTK_SIGNAL_FUNC (scaler_cb), NULL);
  gtk_scale_set_draw_value (GTK_SCALE (scaler), FALSE);

  if (pdamode)
    table1 = gtk_table_new (5, 3, FALSE);
  else
    {
      if (SMALLMENU)
	table1 = gtk_table_new (4, 3, FALSE);
      else
	table1 = gtk_table_new (8, 2, FALSE);
    }
  lf1 = gtk_frame_new (_("Latitude"));
  lf2 = gtk_frame_new (_("Longitude"));
  lf3 = gtk_frame_new (_("Map file"));
  lf4 = gtk_frame_new (_("Map scale"));
  lf5 = gtk_frame_new (_("Heading"));
  lf6 = gtk_frame_new (_("Bearing"));
  lf7 = gtk_frame_new (_("Time at Dest."));
  lf8 = gtk_frame_new (_("Pref. scale"));
#ifdef WANTSHADOW
  gtk_frame_set_shadow_type (GTK_FRAME (lf1), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (lf2), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (lf3), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (lf4), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (lf5), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (lf6), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (lf7), GTK_SHADOW_IN);
  gtk_frame_set_shadow_type (GTK_FRAME (lf8), GTK_SHADOW_IN);
#endif
  l1 = gtk_label_new (_("---"));
  gtk_container_add (GTK_CONTAINER (lf1), l1);
  l2 = gtk_label_new (_("---"));
  gtk_container_add (GTK_CONTAINER (lf2), l2);
  l3 = gtk_label_new (_("---"));
  gtk_container_add (GTK_CONTAINER (lf3), l3);
  l4 = gtk_label_new (_("---"));
  gtk_container_add (GTK_CONTAINER (lf4), l4);
  l5 = gtk_label_new (_("---"));
  gtk_container_add (GTK_CONTAINER (lf5), l5);
  l6 = gtk_label_new (_("---"));
  gtk_container_add (GTK_CONTAINER (lf6), l6);
  l7 = gtk_label_new (_("---"));
  gtk_container_add (GTK_CONTAINER (lf7), l7);
  l8 = gtk_label_new (_("---"));
  gtk_container_add (GTK_CONTAINER (lf8), l8);

  if (pdamode)
    {
      gtk_table_attach_defaults (GTK_TABLE (table1), lf6, 0, 1, 0, 1);
      gtk_table_attach_defaults (GTK_TABLE (table1), lf5, 1, 2, 0, 1);
      gtk_table_attach_defaults (GTK_TABLE (table1), lf4, 2, 3, 0, 1);

      gtk_table_attach_defaults (GTK_TABLE (table1), lf1, 0, 1, 1, 2);
      gtk_table_attach_defaults (GTK_TABLE (table1), lf2, 1, 2, 1, 2);
      gtk_table_attach_defaults (GTK_TABLE (table1), lf8, 2, 3, 1, 2);

      gtk_table_attach_defaults (GTK_TABLE (table1), lf7, 0, 1, 2, 3);
      gtk_table_attach_defaults (GTK_TABLE (table1), lf3, 1, 3, 2, 3);
      gtk_table_attach_defaults (GTK_TABLE (table1), scaler, 0, 3, 3, 4);
      gtk_table_attach_defaults (GTK_TABLE (table1), status, 0, 3, 4, 5);
    }
  else
    {
      if (SMALLMENU)
	{
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf6, 0, 1, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf5, 1, 2, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf1, 2, 3, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf2, 3, 4, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf7, 0, 1, 1, 2);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf3, 1, 2, 1, 2);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf4, 2, 3, 1, 2);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf8, 3, 4, 1, 2);
	  gtk_table_attach_defaults (GTK_TABLE (table1), status, 0, 4, 3, 4);
	  gtk_table_attach_defaults (GTK_TABLE (table1), scaler, 0, 4, 2, 3);
	}
      else
	{
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf6, 0, 1, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf5, 1, 2, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf1, 2, 3, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf2, 3, 4, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf7, 4, 5, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf3, 5, 6, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf4, 6, 7, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), lf8, 7, 8, 0, 1);
	  gtk_table_attach_defaults (GTK_TABLE (table1), status, 0, 4, 1, 2);
	  gtk_table_attach_defaults (GTK_TABLE (table1), scaler, 4, 8, 1, 2);
	}
    }
/*    gtk_box_pack_start (GTK_BOX (vbig), table1, FALSE, FALSE, 1); */
/*  all position calculations are made in the expose callback */
/*   if (!pdamode) */
  gtk_signal_connect (GTK_OBJECT (drawing_area),
		      "expose_event", GTK_SIGNAL_FUNC (expose_cb), NULL);
  if (havebattery)
    gtk_signal_connect (GTK_OBJECT (drawing_battery),
			"expose_event",
			GTK_SIGNAL_FUNC (expose_display_battery), NULL);
  if (!pdamode)
    {
      if (extrawinmenu)
	{
	  menuwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
/*       gdk_window_lower((GdkWindow *)menuwin); */

	  gtk_window_set_title (GTK_WINDOW (menuwin), _("Menu"));
/*** Mod by Arms */
	  gtk_container_set_border_width (GTK_CONTAINER (menuwin),
					  2 * PADDING);
	  gtk_container_add (GTK_CONTAINER (menuwin), hboxlow);
	  gtk_signal_connect (GTK_OBJECT (menuwin), "delete_event",
			      GTK_SIGNAL_FUNC (quit_program), NULL);
	  menuwin2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
/*       gdk_window_lower((GdkWindow *)menuwin2); */
	  gtk_window_set_title (GTK_WINDOW (menuwin2), _("Status"));
/*** Mod by Arms */
	  gtk_container_set_border_width (GTK_CONTAINER (menuwin2),
					  2 * PADDING);
	  vbig1 = gtk_vbox_new (FALSE, 2);
	  gtk_container_add (GTK_CONTAINER (menuwin2), vbig1);
/*** Mod by Arms */
	  gtk_box_pack_start (GTK_BOX (vbig1), hbox2, TRUE, TRUE,
			      2 * PADDING);
	  if (pdamode)
	    gtk_box_pack_start (GTK_BOX (vbig1), hbox2a, TRUE, TRUE,
				2 * PADDING);
/*** Mod by Arms */
	  gtk_box_pack_start (GTK_BOX (vbig1), table1, TRUE, TRUE,
			      2 * PADDING);
	  gtk_signal_connect (GTK_OBJECT (menuwin2), "delete_event",
			      GTK_SIGNAL_FUNC (quit_program), NULL);
	}
      else
	{
/*** Mod by Arms */
	  gtk_box_pack_start (GTK_BOX (hbig), vbox2, TRUE, TRUE, 1 * PADDING);
/*** Mod by Arms */
	  gtk_box_pack_start (GTK_BOX (vbig), hbox2, TRUE, TRUE, 2 * PADDING);
/*** Mod by Arms */
	  gtk_box_pack_start (GTK_BOX (vbig), table1, FALSE, FALSE,
			      1 * PADDING);
	}
    }

/*   if pdamode is set, we use gtk-notebook add arrange the elements */
/*   in pdamode, extrawinmenu is also set! */
  mainnotebook = NULL;
  if (pdamode)
    {
      GtkWidget *l1, *l2, *l3;
      l1 = gtk_label_new (_("Map"));
      l2 = gtk_label_new (_("Menu"));
      l3 = gtk_label_new (_("Status"));
      menuwin = gtk_frame_new (_("Menu window"));
      menuwin2 = gtk_frame_new (_("Status window"));

      gtk_container_set_border_width (GTK_CONTAINER (menuwin), 2 * PADDING);
      gtk_container_add (GTK_CONTAINER (menuwin), hboxlow);

      gtk_container_set_border_width (GTK_CONTAINER (menuwin2), 2 * PADDING);
      vbig1 = gtk_vbox_new (FALSE, 2);
      gtk_container_add (GTK_CONTAINER (menuwin2), vbig1);
      gtk_box_pack_start (GTK_BOX (vbig1), hbox2, TRUE, TRUE, 2 * PADDING);
      gtk_box_pack_start (GTK_BOX (vbig1), hbox2a, TRUE, TRUE, 2 * PADDING);
      gtk_box_pack_start (GTK_BOX (hbox2b), frame_speed, TRUE, TRUE,
			  1 * PADDING);
      gtk_box_pack_start (GTK_BOX (hbox2b), frame_altitude, TRUE, TRUE,
			  1 * PADDING);
      gtk_box_pack_start (GTK_BOX (vbig1), table1, TRUE, TRUE, 2 * PADDING);

      mainnotebook = gtk_notebook_new ();
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (mainnotebook), GTK_POS_TOP);
      gtk_box_pack_start (GTK_BOX (hbig), vbig, TRUE, TRUE, 1 * PADDING);
      gtk_container_add (GTK_CONTAINER (mainwindow), mainnotebook);
      gtk_widget_show_all (menuwin);
      gtk_widget_show_all (menuwin2);
      gtk_widget_show_all (hbig);
      gtk_widget_show_all (vbig);
      gtk_notebook_append_page (GTK_NOTEBOOK (mainnotebook), hbig, l1);
      gtk_notebook_append_page (GTK_NOTEBOOK (mainnotebook), menuwin, l2);
      gtk_notebook_append_page (GTK_NOTEBOOK (mainnotebook), menuwin2, l3);
      gtk_notebook_set_page (GTK_NOTEBOOK (mainnotebook), 0);
      gtk_widget_show_all (mainnotebook);
    }
  else
    {
      gtk_box_pack_start (GTK_BOX (hbig), vbig, TRUE, TRUE, 1 * PADDING);
      gtk_container_add (GTK_CONTAINER (mainwindow), hbig);
    }

/*** Mod by Arms */
/* This one should position the windows in the corners, */
/* so that gpsdrive can be run w/o a xwm (stand-alone mode) */
/* With a xwm, you should be able to reposition the */
/* windows afterwards... */
  if (extrawinmenu && SMALLMENU && !pdamode)
    {
      reqptr = &requ;
      gtk_widget_size_request (GTK_WIDGET (menuwin2), reqptr);
      gtk_widget_set_uposition (GTK_WIDGET (menuwin2), gdk_screen_width () - requ.width, gdk_screen_height () - requ.height);	/* rechts unten */
      gtk_widget_size_request (GTK_WIDGET (mainwindow), reqptr);
      gtk_widget_set_uposition (GTK_WIDGET (mainwindow), gdk_screen_width () - requ.width, 0);	/* rechts oben */
      gtk_widget_size_request (GTK_WIDGET (menuwin), reqptr);
      gtk_widget_set_uposition (GTK_WIDGET (menuwin), 0, 0);	/* links oben */
    }

/*  Now show all Widgets */
  if (extrawinmenu)
    {
      gtk_widget_show_all (menuwin);
      gtk_widget_show_all (menuwin2);

    }
  gtk_widget_show_all (mainwindow);
  icon =
    gdk_pixmap_create_from_xpm_d (mainwindow->window, &mask,
				  NULL, gpsico_xpm);
  gdk_window_set_icon (mainwindow->window, NULL, icon, mask);
/*  now we know the drawables */
  if (pdamode)
    gtk_notebook_set_page (GTK_NOTEBOOK (mainnotebook), 0);

  drawable = gdk_pixmap_new (mainwindow->window, SCREEN_X, SCREEN_Y, -1);
/*    drawable = drawing_area->window; */
  if (pdamode)
    gtk_notebook_set_page (GTK_NOTEBOOK (mainnotebook), 2);

  drawable_sats = drawing_sats->window;
  drawable_bearing = drawing_bearing->window;
/*   if (!pdamode) */
  kontext = gdk_gc_new (mainwindow->window);
/*   else */
/*     kontext = gdk_gc_new (mainnotebook->window); */

  gdk_gc_set_clip_origin (kontext, 0, 0);
  rectangle.width = SCREEN_X;
  rectangle.height = SCREEN_Y;

  gdk_gc_set_clip_rectangle (kontext, &rectangle);
  cmap = gdk_colormap_get_system ();
  gdk_color_alloc (cmap, &red);
  gdk_color_alloc (cmap, &black);
  gdk_color_alloc (cmap, &blue);
  gdk_color_alloc (cmap, &nightcolor);
  gdk_color_alloc (cmap, &lcd);
  gdk_color_alloc (cmap, &lcd2);
  gdk_color_alloc (cmap, &green);
  gdk_color_alloc (cmap, &green2);
  gdk_color_alloc (cmap, &white);
  gdk_color_alloc (cmap, &mygray);
  gdk_color_alloc (cmap, &yellow);
  gdk_color_alloc (cmap, &darkgrey);
  gdk_color_alloc (cmap, &textback);

  if (pdamode)
    gtk_notebook_set_page (GTK_NOTEBOOK (mainnotebook), 1);
  if (SMALLMENU == 0)
    gdk_window_set_cursor (drawing_miniimage->window, cursor);

  cursor = gdk_cursor_new (GDK_CROSS);
  if (pdamode)
    gtk_notebook_set_page (GTK_NOTEBOOK (mainnotebook), 0);
  gdk_window_set_cursor (drawing_area->window, cursor);

/*  Tooltips */
  tooltips = gtk_tooltips_new ();
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), downloadbt,
			_("Download map from Internet"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), quit,
			_("Leave the program"), NULL);
  if (havespeechout)
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), mutebt,
			  _("Disable output of speech"), NULL);
  if (usesql)
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), sqlbt,
			  _("Use SQL server for waypoints"), NULL);
/*    if (maxwp > 0) */
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), wpbt,
			_("Show waypoints on the map"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), posbt,
			_
			("Turn position mode on. You can move on the map with the left mouse button click. Clicking near the border switches to the proximate map."),
			NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), trackbt,
			_("Show tracking on the map"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), importbt,
			_("Let you import and calibrate your own map"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), helpbt,
			_("Opens the help window"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), startgpsbt,
			_("Starts GPSD for NMEA mode"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), setupbt,
			_("Settings for GpsDrive"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), zoomin,
			_("Zoom into the current map"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), zoomout,
			_("Zooms out off the current map"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), scalerlbt,
			_("Select the next more detailed map"), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), scalerrbt,
			_("Select the next less detailed map"), NULL);
/*    if (maxwp > 0) */
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips),
			sel_target,
			_
			("Select here a destination from the waypoint list"),
			NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), scaler,
			_("Select the map scale of avail. maps."), NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), loadtrackbt,
			_("Load and display a previous stored track file"),
			NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), bestmapbt,
			_("Always select the most detailed map available"),
			NULL);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tooltips), savetrackbt,
			_("Save the track to given filename at program exit"),
			NULL);
/*    gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips),,_(""),NULL); */
  gtk_tooltips_set_delay (GTK_TOOLTIPS (tooltips), 1000);
  strcpy (mapfilename, "***");
/*  set the timers */
  gtk_timeout_add (TIMER, (GtkFunction) get_position_data_cb, NULL);
  gtk_timeout_add (WATCHWPTIMER, (GtkFunction) watchwp_cb, NULL);

  if (slowcpu)
    redrawtimeout = gtk_timeout_add (1000, (GtkFunction) drawmarker_cb, NULL);
  else
    redrawtimeout =
      gtk_timeout_add (REDRAWTIMER, (GtkFunction) drawmarker_cb, NULL);

/*  if we started in simulator mode we have a little move roboter */

  if (simmode)
    simpos_timeout = gtk_timeout_add (300, (GtkFunction) simulated_pos, 0);
  if (nmeaout)
    gtk_timeout_add (1000, (GtkFunction) write_nmea_cb, NULL);
  gtk_timeout_add (3000, (GtkFunction) testconfig_cb, 0);
  gtk_timeout_add (600000, (GtkFunction) speech_saytime_cb, 0);
  gtk_timeout_add (1000, (GtkFunction) storetrack_cb, 0);
  gtk_timeout_add (10000, (GtkFunction) masteragent_cb, 0);
  gtk_timeout_add (15000, (GtkFunction) getsqldata, 0);
/*   gtk_timeout_add (2000, (GtkFunction) nav_doit, NULL); */
  if (havebattery)
    gtk_timeout_add (5000, (GtkFunction) expose_display_battery, NULL);
  if (havefriends)
    {
      gtk_timeout_add (15000, (GtkFunction) friendsagent_cb, 0);
    }
  if (havespeechout)
    {
      speech_saytime_cb (NULL, 1);
      gtk_timeout_add (SPEECHOUTINTERVAL, (GtkFunction) speech_out_cb, 0);
    }
/*  To set the right sensitive flags */
  bestmap_cb (NULL, 0);
  needtosave = FALSE;
/*  Mainloop */
  gtk_main ();

  return 0;
}
