// -*- mode: c++; c-basic-offset: 8; -*-
// $Id: garmin_types.h,v 1.2 2002/04/18 22:50:37 ganter Exp $
// garmin_types.h
// Douglas S. J. De Couto
// May 26, 1998

// Copyright (C) 1998 Douglas S. J. De Couto
// <decouto@lcs.mit.edu>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef _gartype
#define _gartype

#include <string>
#include <ctime>

namespace garmin {

#if macintosh
#include <MacTypes.h>

typedef UInt8 uint8; // garmin char
typedef SInt8 sint8;

typedef UInt16 uint16; // garmin int
typedef SInt16 sint16;

typedef UInt32 uint32; // garmin long
typedef SInt32 sint32;

typedef Float32 float32; // garmin float
typedef Float64 double64; // garmin double

#endif
//#if linux // yeah at least this will work on my i386
//#include <linux/types.h>

typedef unsigned char uint8; // garmin char
typedef char sint8;

typedef unsigned short uint16; // garmin int
typedef short sint16;

typedef unsigned long uint32; // garmin long
typedef long sint32;

typedef float float32; // garmin float
typedef double double64; // garmin double

//#endif

// position in semicircles; 2^31 semicircles == 180 degrees.
// north, east are positive; south, west negative.
struct semicircle_type {
	sint32 lat;
	sint32 lon;
};

// position in radians, sign conventions as above.
struct radian_type {
	double64 lat; 
	double64 lon;
};

// for convenience
struct degree_type {
	double64 lat;
	double64 lon;
};
   
struct product_data_type {
	sint16 product_id;
	sint16 software_version;
	std::string product_description;
};

// each product has its own specific, more extensive waypoint type.  
// this type is the lowest common denominator of those types, except 
// for the D105 and D160 waypoint types.
struct basic_waypt_type {
	std::string id;
	semicircle_type pos;
	std::string comment;
};

struct track_point_type {
	semicircle_type pos;
	std::time_t time;
	bool new_track;
};

struct proximity_waypt_type {
	basic_waypt_type waypt;
	float32 dist; // meters
};

} // namespace


#endif // _gartype
