/***********************************************************************

Copyright (c) 2001 Fritz Ganter <ganter@ganter.at>

Website: www.kraftvoll.at

Disclaimer: Please do not use for navigation. 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    *********************************************************************

$Log: friendsd.c,v $
Revision 1.5  2002/06/30 11:32:28  ganter
fix convertRMC
new arrows

Revision 1.4  2001/11/13 18:37:46  ganter
v1.4 enhanced friends functions

Revision 1.3  2001/11/12 19:55:47  ganter
v1.3

Revision 1.2  2001/11/12 19:11:53  ganter
friends server and client starting to work

Revision 1.1  2001/11/11 17:25:34  ganter
added friendsd

*/


/*  Include Dateien */
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <math.h>
#include <sys/time.h>
#include <locale.h>
#include <time.h>
#include <errno.h>
#include <ctype.h>

/*  Defines for gettext I18n */
# include <libintl.h>
# define _(String) gettext(String)
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif

/* The socket file descriptor for our "listening" socket */
int sock;

/* Socket file descriptors we want to wake
				   up for, using select() */
fd_set socks;
/* Highest #'d file descriptor, needed for select() */
int highsock;


#define FRIENDSSERVER "localhost"
#define FRIENDSSERVERPORT 50123
#define MAXINCOMING 100

/* Array of connected sockets so we know who
				   we are talking to */
int connectlist[MAXINCOMING];

char vehicle[1000][512];
int vehiclenum = 0;

/* This is just like the read() system call, accept that it will make
   sure that all your data goes through the socket. */
int
sock_read (int sockfd, char *buf, size_t count)
{
  size_t bytes_read = 0;
  int this_read;

  while (bytes_read < count)
    {
      do
	this_read = read (sockfd, buf, count - bytes_read);
      while ((this_read < 0) && (errno == EINTR));
      if (this_read < 0)
	return this_read;
      else if (this_read == 0)
	return bytes_read;
      bytes_read += this_read;
      buf += this_read;
    }
  return count;
}

/* This is just like the write() system call, accept that it will
   make sure that all data is transmitted. */
int
sock_write (int sockfd, char *buf, size_t count)
{
  size_t bytes_sent = 0;
  int this_write;

  while (bytes_sent < count)
    {
      do
	this_write = write (sockfd, buf, count - bytes_sent);
      while ((this_write < 0) && (errno == EINTR));
      if (this_write <= 0)
	return this_write;
      bytes_sent += this_write;
      buf += this_write;
    }
  return count;
}


/* This function reads from a socket, until it recieves a linefeed
   character.  It fills the buffer "str" up to the maximum size "count".

   This function will return -1 if the socket is closed during the read
   operation.

   Note that if a single line exceeds the length of count, the extra data
   will be read and discarded!  You have been warned. */
int
sock_gets (int sockfd, char *str, size_t count)
{
  int bytes_read;
  int total_count = 0;
  char *current_position;
  char last_read = 0;

  current_position = str;
  while (last_read != 10)
    {
      bytes_read = read (sockfd, &last_read, 1);
      if (bytes_read <= 0)
	{
	  /* The other side may have closed unexpectedly */
	  return -1;		/* Is this effective on other platforms than linux? */
	}
      if ((total_count < count) && (last_read != 10))
	{
	  current_position[0] = last_read;
	  current_position++;
	  total_count++;
	}
    }
  if (count > 0)
    current_position[0] = 0;
  return total_count;
}

/* This function writes a character string out to a socket.  It will 
   return -1 if the connection is closed while it is trying to write. */
int
sock_puts (int sockfd, char *str)
{
  return sock_write (sockfd, str, strlen (str));
}

/* This ignores the SIGPIPE signal.  This is usually a good idea, since
   the default behaviour is to terminate the application.  SIGPIPE is
   sent when you try to write to an unconnected socket.  You should
   check your return codes to make sure you catch this error! */
void
ignore_pipe (void)
{
  struct sigaction sig;

  sig.sa_handler = SIG_IGN;
  sig.sa_flags = 0;
  sigemptyset (&sig.sa_mask);
  sigaction (SIGPIPE, &sig, NULL);
}

void
setnonblocking (int sock)
{
  int opts;

  opts = fcntl (sock, F_GETFL);
  if (opts < 0)
    {
      perror ("fcntl(F_GETFL)");
      exit (EXIT_FAILURE);
    }
  opts = (opts | O_NONBLOCK);
  if (fcntl (sock, F_SETFL, opts) < 0)
    {
      perror ("fcntl(F_SETFL)");
      exit (EXIT_FAILURE);
    }
  return;
}

void
build_select_list ()
{
  int listnum;
  FD_ZERO (&socks);


  FD_SET (sock, &socks);


  for (listnum = 0; listnum < MAXINCOMING; listnum++)
    {
      if (connectlist[listnum] != 0)
	{
	  FD_SET (connectlist[listnum], &socks);
	  if (connectlist[listnum] > highsock)
	    highsock = connectlist[listnum];
	}
    }
}

void
handle_new_connection ()
{
  int listnum;			/* Current item in connectlist for for loops */
  int connection;		/* Socket file descriptor for incoming connections */

  /* We have a new connection coming in!  We'll
     try to find a spot for it in connectlist. */
  connection = accept (sock, NULL, NULL);
  if (connection < 0)
    {
      perror ("accept");
      exit (EXIT_FAILURE);
    }
  setnonblocking (connection);
  for (listnum = 0; (listnum < MAXINCOMING) && (connection != -1); listnum++)
    if (connectlist[listnum] == 0)
      {
	printf ("\nConnection accepted:   FD=%d; Slot=%d\n",
		connection, listnum);
	connectlist[listnum] = connection;
	connection = -1;
      }
  if (connection != -1)
    {
      /* No room left in the queue! */
      printf ("\nNo room left for new client.\n");
      sock_puts (connection, "Sorry, this server is too busy.  "
		 "Try again later !r\n ");
      close (connection);
    }
}

void
deal_with_data (int listnum)
{
  char buffer[2010];		/* Buffer for socket reads */
  char name[2010], dummy[2010];
  int i, e, found = 0;

  printf ("\nListnum %d\n", listnum);
  if (sock_gets (connectlist[listnum], buffer, 2000) < 0)
    {
      /* Connection closed, close this end
         and free up entry in connectlist */
      printf ("\nConnection lost: FD=%d;  Slot=%d\n",
	      connectlist[listnum], listnum);
      close (connectlist[listnum]);
      connectlist[listnum] = 0;
    }
  else
    {

/*        in buffer we now have a vehicle */
      e = sscanf (buffer, "%s %s %s %s %s", dummy, name, dummy, dummy, dummy);

      for (i = 0; i < vehiclenum; i++)
	if ((strstr (vehicle[i], name)) != NULL)
	  {
	    if ((strstr (buffer, "POS:")) != NULL)
	      {
		strcpy (vehicle[i], buffer);
		found = 1;
	      }
	  }
      if (!found)
	if ((strstr (buffer, "POS:")) != NULL)
	  strcpy (vehicle[vehiclenum++], buffer);

      sock_puts (connectlist[listnum], "$START:$\n");
      for (i = 0; i < vehiclenum; i++)
	{
	  sock_puts (connectlist[listnum], vehicle[i]);
	  sock_puts (connectlist[listnum], "\n");
	}
      sock_puts (connectlist[listnum], "$END:$\n");
/*        printf ("responded: %s\n", buffer); */
    }
}


void
read_socks ()
{
  int listnum;
  if (FD_ISSET (sock, &socks))
    handle_new_connection ();

  for (listnum = 0; listnum < MAXINCOMING; listnum++)
    {
      if (FD_ISSET (connectlist[listnum], &socks))
	deal_with_data (listnum);
    }
}


int
main (int argc, char *argv[])
{
  struct sockaddr_in server_address;
  struct timeval timeout;
  int reuse_addr = 1;
  int readsocks;		/* Number of sockets ready for reading */

  ignore_pipe ();
/* Obtain a file descriptor for our "listening" socket */
  if ((sock = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror (_("can't open socket for friendsd server "));
      exit (1);
    }

  /* So that we can re-bind to it without TIME_WAIT problems */
  setsockopt (sock, SOL_SOCKET, SO_REUSEADDR, &reuse_addr,
	      sizeof (reuse_addr));

  /* Set socket to non-blocking with our setnonblocking routine */
  setnonblocking (sock);
  memset ((char *) &server_address, 0, sizeof (server_address));

  server_address.sin_family = AF_INET;
  server_address.sin_addr.s_addr = htonl (INADDR_ANY);
  server_address.sin_port = htons (FRIENDSSERVERPORT);


  if (bind (sock, (struct sockaddr *) &server_address,
	    sizeof server_address) < 0)
    {
      perror ("bind() call ");
      close (sock);
      exit (1);
    }
  else
    {
      printf ("\n%s %s %s \n", _("friendsd server version"),
	      FRIENDSSERVERVERSION, _(" started"));
    }
  /* Set up queue for incoming connections. */
  listen (sock, MAXINCOMING);

  /* Since we start with only one socket, the listening socket,
     it is the highest socket so far. */
  highsock = sock;
  memset ((char *) &connectlist, 0, sizeof (connectlist));

  while (1)
    {				/* Main server loop - forever */
      build_select_list ();
      timeout.tv_sec = 0;
      timeout.tv_usec = 200000;
      readsocks = select (highsock + 1, &socks, (fd_set *) 0,
			  (fd_set *) 0, &timeout);
      if (readsocks < 0)
	{
	  perror ("select");
	  exit (EXIT_FAILURE);
	}
      if (readsocks == 0)
	{
	  /* Nothing ready to read, just show that
	     we're alive */
/*  	  printf ("."); */
/*  	  fflush (stdout); */
	}
      else
	read_socks ();
    }				/* while(1) */


  return 0;
}
