/*
$Log: friends.c,v $
Revision 1.3  2001/11/12 19:11:53  ganter
friends server and client starting to work

Revision 1.2  2001/11/11 17:25:34  ganter
added friendsd

Revision 1.1  2001/11/11 11:01:43  ganter
added friends.c

*/


/*  Include Dateien */
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <math.h>
#include <sys/time.h>
#include "gtk/gtk.h"
#include "gdk-pixbuf/gdk-pixbuf.h"
#include <locale.h>
#include <time.h>

/*  Defines for gettext I18n */
# include <libintl.h>
# define _(String) gettext(String)
# ifdef gettext_noop
#  define N_(String) gettext_noop(String)
# else
#  define N_(String) (String)
# endif




extern gint statusid, debug, havespeechout, posmode, muteflag;
gint speechsock;
extern enum
{ english, german, spanish }
voicelang;

gint havefriends;
gchar friendsserver[200];
extern gchar nmeamodeandport[];


#define FRIENDSSERVERPORT 50123
gint friendssock;

/* This ignores the SIGPIPE signal.  This is usually a good idea, since
   the default behaviour is to terminate the application.  SIGPIPE is
   sent when you try to write to an unconnected socket.  You should
   check your return codes to make sure you catch this error! */
void ignore_pipe(void)
{
  struct sigaction sig;

  sig.sa_handler = SIG_IGN;
  sig.sa_flags = 0;
  sigemptyset(&sig.sa_mask);
  sigaction(SIGPIPE,&sig,NULL);
}

void
openfriendsport (void)
{
  struct sockaddr_in server;
  struct hostent *server_data;
  ignore_pipe();

/*  open socket to port */
  if ((friendssock = socket (AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror (_("can't open socket for friendsserver "));
      exit (1);
    }
  server.sin_family = AF_INET;
/*  We retrieve the IP address of the server from its name: */
  if ((server_data = gethostbyname (friendsserver)) == NULL)
    {
      fprintf (stderr, "%s: unknown host", friendsserver);
      exit (1);
    }
  memcpy (&server.sin_addr, server_data->h_addr, server_data->h_length);
  server.sin_port = htons (FRIENDSSERVERPORT);

/*  We initiate the connection  */
  if (connect (friendssock, (struct sockaddr *) &server, sizeof server) < 0)
    {
    }
  else
    {
      strcpy (nmeamodeandport, _("Friendsserver found"));
      havefriends = TRUE;
      g_print ("\n%s\n", nmeamodeandport);
    }


}
