(* COMPILE-CMD: emil4.cmp *)

program EPRealConstants (Output);

uses GPC;

var
  R, S: volatile Real;
  OK:   Boolean value True;

procedure Bomb (I: Integer);
begin
  WriteLn ('Failed ', I : 2, ': ', R, ', ', S);
  OK := False
end;

begin
  S := 0;
  R := MinReal;
  if IsNotANumber (R)   then Bomb (1);
  if IsInfinity (R)     then Bomb (2);
  if R <= 0             then Bomb (3);
  S := R * (1 + EpsReal);
  if S <= R             then Bomb (41);
  R := R / 2;
  S := R * (1 + EpsReal);
(*
  if S > R              then Bomb (42);
*)

  R := MaxReal;
  if IsNotANumber (R)   then Bomb (5);
  if IsInfinity (R)     then Bomb (6);
  if R <= 0             then Bomb (7);
  {$ifdef HAVE_INF}  { see emil4.cmp }
  R := R + R;
  if not (IsInfinity (R) or (R <= MaxReal))
  { `not IsInfinity (R)' alone probably can't work on non-IEEE hardware }
                        then Bomb (8);
  {$endif}

  R := EpsReal;
  if IsNotANumber (R)   then Bomb (9);
  if IsInfinity (R)     then Bomb (10);
  if R <= 0             then Bomb (11);
  R := R + 1;
  if R <= 1             then Bomb (12);
  R := EpsReal / 2 + 1;
  if R <> 1             then Bomb (13);

  if OK then WriteLn ('OK')
end.
