/* ----------------------------------------------------------------------
 * General purpose template file
 * Copyright (C) 2000 January Weiner III
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 ---------------------------------------------------------------------- */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>
#include <zlib.h>

#include "genpak.h"
#include "gp_getopt.h"

#define VERSION "0.1"
#define PROGNAME "gp_gps2fst"

char *progname ;

typedef struct {
	int back ;
	gzFile *in ;
	FILE *out ; } opt_s ;

/*
 *
 */
sekw * gp_read_gps_sequence(gzFile *in) ;

int main(int argc, char *argv[])
{
	extern int optind ;
	extern char *optarg ;
	int width = 70 ; /* width with which the sequence gets formatted */
	int stdin_fd ;
	char bufor[BUFSIZ] ;
	opt_s options ;
	sekw *inseq, *outseq ;

	int c;
	char message[100] ;
	int errflg = 0 ;

	progname = argv[0] ;
	options.back = FALSE ;

	while ((c = gp_getopt(argc, argv, "rHqdvh")) != EOF)
		switch(c) {
		case 'r':
			options.back = TRUE ;
			gp_warn("translating from gps to fasta") ;
			break ;
		case 'H':
			html = TRUE ;
			break ;
		case 'q':
			quiet = TRUE ;
			break ;
		case 'v':
			fprintf(stderr,"%s version %s\n",progname,VERSION) ;
			exit(0) ;
			break ;
		case 'd':
			debug = TRUE ;
			gp_warn("Running in debug mode") ;
			break ;
		case 'h':
			Help() ;
			break ;
		default:
			errflg++ ;
			break;
		}


	if(errflg) gp_error("Type '%s -h' for help",progname) ;

/* open the file pointer to read the sequences 
 * from: standard input or a file provided? */
//	if(optind >= argc) options.in = stdin ;
//	else options.in = gp_file_open(argv[optind],"r") ;

	stdin_fd = fileno(stdin) ;
	gp_warn("ok") ;

	if(optind >= argc) {
		gp_warn("reading from stdin") ;
		options.in = gzdopen(stdin_fd,"r") ;
	} else {
		gp_warn("reading from file %s",argv[optind]) ;
		options.out = gzopen(argv[optind],"wb") ;
	}

	if(gzgets(options.in,bufor,BUFSIZ) == NULL) 
		gp_warn("error") ;
	else
		gp_warn("read %s",bufor) ;

	exit(1) ;

	//options.in = gzopen(argv[optind],"r") ;

/* opening the file pointer to write the output: 
 * standard output or file provided? */
	optind++ ;

	if(optind >= argc) options.out = stdout ;
	else options.out = gp_file_open(argv[optind],"wb") ;

	gp_read_gps_sequence(options.in) ;

	
	if(html) gp_warn_print_all(options.out) ;
	fclose(options.out) ;
	gzclose(options.in) ;
	return EXIT_SUCCESS ;
}



sekw * gp_read_gps_sequence(gzFile *in) {
	sekw *res ;
	int ln ;
	long ls ;

	res = malloc(sizeof(*res)) ;
	gzread(in,&ln,sizeof(ln)) ;
	gzread(in,res->name,sizeof(*res->name)*ln) ;
	gzread(in,&ls,sizeof(ls)) ;
	res->sequ = malloc(sizeof(*res->sequ) * ls + 1) ;
	gzread(in,res->sequ,sizeof(char)*ls) ;
	if(debug) gp_warn("read sequence %s",res->name) ;
	warn("name %s",res->name) ;
	warn("seq %s",res->sequ) ;

	return res ;
}


int gp_write_gps_sequence(sekw *s, FILE *out) {
	int l ;
	long ll ;
	size_t st ;

	l = strlen(s->name) + 1 ;
	warn("l is %i",l) ;
	st = fwrite(&l,sizeof(int),1,out) ;
	fwrite(s->name,sizeof(char),l,out) ;
	ll = s->leng + 1 ;
	st = fwrite(&ll,sizeof(ll),1,out) ;
	st = fwrite(s->sequ,sizeof(*s->sequ),ll,out) ;
	return EXIT_SUCCESS ;
}

/* Standard mesage */

void Help()
{
printf("\n");
printf("%s, v. %s- no description yet",PROGNAME,VERSION);
printf("\n");
printf("  Usage:\n");
printf("     %s [options] [ input file ] [ output file ]\n",progname);
printf("\n");
printf("  Options:\n");
printf("     -v       : print version information & exit\n");
printf("     -h       : print this help screen & exit\n");
printf("     -q       : quiet, suppress error messages\n\n");
exit(0);
}


			
