/* This program was written by Alexander Siegel in September of 1989   */
/* at Cornell University.  It may may copied freely for private use or */
/* public dispersion provided that this comment is not removed.  This  */
/* program, any portion of this program, or any derivative of this     */
/* program may not be sold or traded for financial gain.               */
 
/* Modified by Josh Siegel to work with NeWS/X11 */
 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <sys/time.h>
#include <signal.h>
#include <golddig.h>
 
#define EVMASK KeyPressMask | ExposureMask | ButtonPressMask |\
               FocusChangeMask | StructureNotifyMask

/* Pre-initialize some variables */
int lives = STARTLIVES;
int newlevel = 0;
int angelleft = 0;

static int gamestop = 0;

/* Plug into original block type definitions in shared.c */
extern struct symbs_s symbs[];
extern int numholes;        /* Total number of holes */
 
/* This routine is called whenever the player dies. */
void died(whydie)
char *whydie;       /* Textual description of reason for death */
{
  register int i;
#ifndef VMS
  static struct itimerval cycletime; /* Structure used when setting up timer */
#endif
 
#ifdef VMS
  signal(SIGALRM,SIG_IGN);
#else
  /* Build cycletime structure used in setitimer */
  cycletime.it_interval.tv_sec = 100;
  cycletime.it_interval.tv_usec = 0;
  cycletime.it_value = cycletime.it_interval;
  /* Make timer not fire for 100 seconds.  This is necessary because */
  /* sleep needs SIG_DFL to be set on the timer, but I don't want the */
  /* timer to go off before sleep is called. */
  setitimer(ITIMER_REAL,&cycletime,(struct itimerval *) NULL);
  signal(SIGALRM,SIG_DFL);
#endif

  if(inscr != NULL)             /* Close input script file */
    fclose(inscr);
  /* Clean up output script */
  if(outscr != NULL) {
    /* Write output count multiplier */
    if(outcount > 1) {
      for(i=1;i <= outcount;i *= 26)
        continue;
      for(i /= 26;i > 0;i /= 26) {
        if(putc(((char) (outcount / i)) + 'a',outscr) == EOF) {
          perror("output script");
          exit(3);
        }
        outcount -= (outcount / i) * i;
      }
    }
    /* Write final output order */
    if(outorder != UNMOVE)
      if(putc(((char) outorder) + '0',outscr) == EOF) {
        perror("output script");
        exit(3);
      }
    putc('\n',outscr);          /* Append a final new line */
    fclose(outscr);             /* Close output script file */
  }
  XSync(disp,False);            /* Synchronize with display */
  if(strcmp(whydie,"was abandoned"))
    sleep(2);                   /* Pause for 2 seconds to let player */
                                /* see situation */
  xend();                       /* Terminate X windows */
  /* Add score to high score list */
  add_score(whydie);
  exit(0);
}
 
/* Handle a key stroke by the user. */
void handle_key(keyhit)
KeySym keyhit;     /* Key symbol for key stroke provided by X windows */
{
  /* Now that a key is hit, really begin the level */
  if(newlevel) {
    drawmove_badguys();
    newlevel = 0;
  }
  /* Do action depending on which key was hit */
  switch(keyhit) {
  /* If it is a 'h', '?', or '/', print out a list of commands */
  case XK_H:    case XK_h:    case XK_question:   case XK_slash:
    puts("Control the player using keyboard keys or the mouse.");
    puts("<space>,R11 - stop");
    puts("a,j,left arrow - move left");
    puts("d,l,right arrow - move right");
    puts("w,i,up arrow - move up");
    puts("s,k,down arrow - move down");
    puts("z,<,q,u,R13 - make hole left");
    puts("x,>,e,o,R15 - make hole right");
    puts("r,y,R7 - put down any held item");
    puts("1-9 - change the game speed");
    puts("\n^S,^Z - pause the game");
    puts("^Q,^Y - reactivate the game");
    puts("^C - kill the game");
    puts("^R - redraw the screen");
    puts("^K - kill yourself (go into angel mode)");
    break;
  /* A space bar changes the command to STAND */
  case XK_space:    case XK_R11:
    curorder = STAND; break;
  /* A 'z', ',', '<', 'q', or 'u' digs holes to the left */
  case XK_Z:    case XK_comma:  case XK_less:   case XK_Q: case XK_U:
  case XK_R13:  case XK_z:      case XK_q:      case XK_u:
    curorder = DIGLEFT; break;
  /* A 'x', '.', '>', 'e', or 'o' digs holes to the right */
  case XK_X:    case XK_period: case XK_greater: case XK_E: case XK_O:
  case XK_R15:  case XK_x:      case XK_e: case XK_o:
    curorder = DIGRIGHT; break;
  /* A 'j' or 'a' changes the command to LEFT */
  case XK_J:    case XK_A:  case XK_Left:   case XK_j:  case XK_a:
    curorder = LEFT; break;
  /* A 'i' or 'w' changes the command to UP */
  case XK_I:    case XK_W:  case XK_Up:     case XK_i:  case XK_w:
    curorder = UP; break;
  /* A 'k' or 's' changes the command to DOWN */
  case XK_K:    case XK_S:  case XK_Down:   case XK_k:  case XK_s:
    curorder = DOWN; break;
  /* A 'l' or 'd' changes the command to RIGHT */
  case XK_L:    case XK_D:  case XK_Right:  case XK_l:  case XK_d:
    curorder = RIGHT; break;
  /* A 'r' or 'y' drops whatever is being held */
  case XK_R:    case XK_Y:  case XK_R7:     case XK_r:  case XK_y:
    curorder = PUTDOWN; break;
  }
}
 
/* Initialize a level from the current level file */
void init_level()
{
  register int x,y,pos;
  
  /* Allow level sizes to be changes by new level */
  xsize = ysize = -1;
  /* Load the level data itself from the data file. */
  load_level();
  numholes = 0;
 
  /* Initialize player information */
  player.xpos = player.ypos = player.xstart = player.ystart = goldleft = 0;
  player.dir = STAND;
  player.hold = SPACE;
  curorder = STAND;
  pos = 0;
  lives++;  /* add one life for current level */
  for(x=0;x<xsize;++x)
    for(y=0;y<ysize;++y) {
      /* Count the total number of treasures */
      if(fast_lookup[level[pos]].code & TREASURE)
        goldleft ++;
      /* Look for player blocks and remove them.  The last one */
      /* encountered sets the player position. */
      if(level[pos] == PLAYER) {
        player.xpos = player.xstart = x << 1;
        player.ypos = player.ystart = y << 1;
        level[pos] = SPACE;
      }
      pos ++;
    }
  printf("Collect %d gold dubloons.\n",goldleft);
 
  /* Initialize bad guy information and other things. */
  start_badguy();
  regen_allow();
  regen_tree();
  /* Freeze action until a key is pressed */
  newlevel = 1;
}
 
/* Function which is called whenever the timer signal goes off */
void ticker(sig)
int sig;
{
#ifdef VMS
#define REARMSIG
#endif
#ifdef hpux
#define REARMSIG
#endif
#ifdef REARMSIG
  signal(SIGALRM,ticker);     /* Re-arm the signal */
#endif
  /* Ignore any signal which is not an alarm. */
  if(sig != SIGALRM)
    return;
  
  /* increment the tick counter if time is advancing */
  if(! (fast_lookup[player.hold].code & TIMESTOP))
    curtick ++;
 
  /* age all the holes */
  change_holes();
 
  /* move the player and all the bad guys. */
  moveall();
}
 
/* main procedure for game */
int main(argc,argv)
int argc;
char **argv;
{
  int keycount,i;
  static XEvent xev;
  KeySym keyhit;
  char buf[50];
  int usec;           /* Microseconds to wait per timer interval */
#ifndef VMS
  static struct itimerval cycletime; /* Structure used when setting up timer */
#endif

  printf("type h for help.\n");
 
  /* set up level and world description defaults */
  worldname = DEFWORLD;
  levelnum = 1;
  score = 0;
  speed = 5;
  inscr = outscr = NULL;
  geom = NULL;
  /* scan the command line for executing parameters and flags */
  for(i=1;i<argc;++i) {
    if(argv[i][0] == '-') {
      /* look for the level number */
      if(argv[i][1] == 'l') {
        if(argv[i][2] == '\0' && i+1 < argc) {
          sscanf(argv[i+1],"%d",&levelnum);
          i++;
        }
        else
          sscanf(argv[i]+2,"%d",&levelnum);
      }
      /* look for the level number */
      else if(argv[i][1] == 's') {
        if(argv[i][2] == '\0' && i+1 < argc) {
          sscanf(argv[i+1],"%d",&speed);
          i++;
        }
        else
          sscanf(argv[i]+2,"%d",&speed);
      }
      /* look for input script file */
      else if(argv[i][1] == 'i') {
        if(argv[i][2] == '\0' && i+1 < argc) {
          inscr = fopen(argv[i+1],"r");
          i++;
        }
        else
          inscr = fopen(argv[i]+2,"r");
        if(inscr == NULL) {
          perror("input script file");
          exit(2);
        }
        printf("Input script started.\n");
        inorder = UNMOVE;
        incount = 0;
      }
      /* look for output script file */
      else if(argv[i][1] == 'o') {
        if(argv[i][2] == '\0' && i+1 < argc) {
          outscr = fopen(argv[i+1],"w");
          i++;
        }
        else
          outscr = fopen(argv[i]+2,"w");
        if(outscr == NULL) {
          perror("output script file");
          exit(2);
        }
        outorder = UNMOVE;
        outcount = 0;
      }
      /* Look for geometry description */
      else if (argv[i][1] == 'g') {
        geom = argv[i + 1];
        i++;
      }
      else {
        printf("usage: golddig [-l <level>] [-s <speed 1-9>] [-i <input script>] [-o <output script>] [<world name>]\n");
        exit(1);
      }
    }
    /* if it doesn't start with a -, it must be the name of the world */
    else {
      worldname = argv[i];
      break;
    }
  }
  /* remember what the starting level was */
  levelstart = levelnum;
 
  /* start up x windows and all graphics cursors for drawing level */
  xstart(EVMASK, argc, argv);
  /* reassemble the graphics cursors to prepare for actual play */
  for(i=0;symbs[i].symb != '\0';++i)
    fast_lookup[symbs[i].symb].gc  =
      fast_lookup[symbs[i].inplay].gc;
 
  /* name the game window */
  XStoreName(disp,wind,"Gold Digger 3.0");
  XSetIconName(disp,wind,"GD 3.0");
  /* do the rest of the level initialization */
  init_level();
 
  curtick = 0;        /* Initialize tick count to 0 */

  /* Turn off default timer signal handler */
  signal(SIGALRM,SIG_IGN);
  /* initialize timer structure according to speed */
  if(speed <= 0)
    speed = 1;
  if(speed <= 5)
    usec = (5-speed) * 50000 + 125000;
  else
    usec = 625000 /speed;
#ifdef VMS
  /* start the system timer.  the timer signal catcher will be set */
  /* after the first x event is received. */
  setitimer(usec);
#else
  /* Build cycletime structure used in setitimer */
  cycletime.it_interval.tv_sec = 0;
  cycletime.it_interval.tv_usec = usec;
  cycletime.it_value = cycletime.it_interval;
  /* start the system timer.  the timer signal catcher will be set */
  /* after the first x event is received. */
  setitimer(ITIMER_REAL,&cycletime,(struct itimerval *) NULL);
#endif
 
  /* main event loop */
  while(1) {
    /* get the next x window event */
    XWindowEvent(disp,wind,EVMASK,&xev);
    /* suppress the timer to prevent race conditions */
    signal(SIGALRM,SIG_IGN);
    /* If the window is exposed or the level is complete redraw the */
    /* entire level. */
    if(xev.type == Expose && xev.xexpose.count == 0)
      /* Redraw the level */
      redrawall();
    else if(xev.type == KeyPress) {
      keycount = XLookupString((XKeyEvent *) &xev, buf, 50, &keyhit,
			       (XComposeStatus *) NULL);
      /* Check for special control command */
      if(xev.xkey.state & ControlMask)
        switch(keyhit)  {
        /* ^S and ^Z freeze the game in place */
        case XK_S: case XK_Z: case XK_s: case XK_z:
          gamestop = 1;
          break;
        /* ^Q and ^Y reactivate the game */
        case XK_Q: case XK_Y: case XK_q: case XK_y:
          gamestop = 0;
          break;
        /* ^C, ^U, and ^/ kill the game */
        case XK_C: case XK_U: case XK_c: case XK_u: case XK_backslash:
          goto game_over;
        /* ^R redraws the level */
        case XK_R: case XK_r:
          redrawall();
          break;
        /* ^K commits suicide */
        case XK_K: case XK_k:
          if (lives--) {
            angelleft = ANGELTIME;
            draw_score();
          }
          else
            died("committed suicide");
        }
      /* Pressing a number changes the game speed */
      else if(keyhit >= XK_1 && keyhit <= XK_9) {
        speed = (int) (keyhit - XK_0);
        /* Compute new cycle delay */
        if(speed <= 5)
          usec = (5-speed) * 50000 + 125000;
        else
          usec = 625000 / speed;
#ifdef VMS
        /* Reset the timer cycle time */
        setitimer(usec);
#else
        cycletime.it_value = cycletime.it_interval;
        cycletime.it_interval.tv_usec = usec;
        /* Reset the timer cycle time */
        setitimer(ITIMER_REAL,&cycletime,(struct itimerval *) NULL);
#endif
        /* Redraw score line with new speed */
        draw_score();
      }
      /* If it was a normal key stroke, hand it off to the handle_key */
      /* procedure */
      else
        handle_key(keyhit);
    }
    /*
     * dce@sony.com - Iconify causes automatic pause.  Deiconify
     * causes state to stay paused until a keypress happens.
     */
    else if(xev.type == UnmapNotify)
      newlevel = 1;

    /* flush out pending x windows commands */
    XFlush(disp);
    /* reenable the alarm signal if game should be active */
    if((! gamestop) && (! newlevel))
      signal(SIGALRM,ticker);
  }
 
  /* go to died procedure */
 game_over:
  died("was abandoned");
  /* NOTREACHED */
  return(0);
}
