/*-----------------------------------------------------------------------------
  Module header file for: vr module
-----------------------------------------------------------------------------*/

#ifndef vrddr_H
#define vrddr_H

#ifndef UTIL_H
#include "util.h"
#endif

#ifndef vr_TYPEDEF_H
#include "vrtypedef.h"
#endif

#ifndef dbddr_H
#include "dbddr.h"
#endif

/*-----------------------------------------------------------------------------
    Typedefs, constants, and enums here.
-----------------------------------------------------------------------------*/
typedef struct _vrNetlist *vrNetlist;
typedef struct _vrIdec *vrIdec;
typedef struct _vrParam *vrParam;
typedef struct _vrConn *vrConn;
typedef struct _vrDefparam *vrDefparam;
typedef struct _vrPath *vrPath;

/*----------------------------------------------------------------------------
  Netlist methods.
----------------------------------------------------------------------------*/
#define vrNetlistNull ((vrNetlist)(NULL))
extern vrNetlist vrNetlistAlloc(dbNetlist super);
#define _vrNetlistNextFree(Netlist) (*(vrNetlist *)(void *)(Netlist))
extern void vrNetlistFree(vrNetlist Netlist);
extern void vrNetlistDestroy(vrNetlist Netlist);
#define vrNetlistSub(baseClass) (dbNetlistNull==(baseClass)?vrNetlistNull:(vrNetlist)((long)dbNetlistGetfirstExtension(baseClass) - _utOffset(struct _vrNetlist, _extension)))
#define vrNetlistSuper(Netlist) ((Netlist)->_super)
#define vrNetlistExtended(Netlist) (dbNetlistGetfirstExtension(Netlist) != utExtensionNull &&\
dbNetlistGetfirstExtension(Netlist)->functionTable->className == \
 vrNetlistClassName)
#define vrNetlistGetfirstIdec(Netlist) ((Netlist)->firstIdec)
#define vrNetlistSetfirstIdec(Netlist, _Idec) ((Netlist)->firstIdec = (_Idec))
extern void vrNetlistInsertIdec(vrNetlist Netlist, vrIdec _Idec);
extern void vrNetlistRemoveIdec(vrNetlist Netlist, vrIdec _Idec);
#define vrForeachNetlistIdec(Netlist, _Idec) \
    for(_Idec = vrNetlistGetfirstIdec(Netlist); _Idec != vrIdecNull; \
        _Idec = vrIdecGetnextNetlistIdec(_Idec))
#define vrEndForeachNetlistIdec
#define vrSafeForeachNetlistIdec(Netlist, _Idec) {\
    vrIdec _nextIdec;\
    for(_Idec = vrNetlistGetfirstIdec(Netlist); _Idec != vrIdecNull; \
        _Idec = _nextIdec) {\
        _nextIdec = vrIdecGetnextNetlistIdec(_Idec);
#define vrEndSafeForeachNetlistIdec }}
#define vrNetlistGetlastIdec(Netlist) ((Netlist)->lastIdec)
#define vrNetlistSetlastIdec(Netlist, _Idec) ((Netlist)->lastIdec = (_Idec))
extern void vrNetlistAppendIdec(vrNetlist Netlist, vrIdec _Idec);
#define vrNetlistGetfirstDefparam(Netlist) ((Netlist)->firstDefparam)
#define vrNetlistSetfirstDefparam(Netlist, _Defparam) ((Netlist)->firstDefparam = (_Defparam))
extern void vrNetlistInsertDefparam(vrNetlist Netlist, vrDefparam _Defparam);
extern void vrNetlistRemoveDefparam(vrNetlist Netlist, vrDefparam _Defparam);
#define vrForeachNetlistDefparam(Netlist, _Defparam) \
    for(_Defparam = vrNetlistGetfirstDefparam(Netlist); _Defparam != vrDefparamNull; \
        _Defparam = vrDefparamGetnextNetlistDefparam(_Defparam))
#define vrEndForeachNetlistDefparam
#define vrSafeForeachNetlistDefparam(Netlist, _Defparam) {\
    vrDefparam _nextDefparam;\
    for(_Defparam = vrNetlistGetfirstDefparam(Netlist); _Defparam != vrDefparamNull; \
        _Defparam = _nextDefparam) {\
        _nextDefparam = vrDefparamGetnextNetlistDefparam(_Defparam);
#define vrEndSafeForeachNetlistDefparam }}

/*----------------------------------------------------------------------------
  Idec methods.
----------------------------------------------------------------------------*/
#define vrIdecNull ((vrIdec)(NULL))
extern vrIdec _vrIdecAlloc(void);
#define _vrIdecNextFree(Idec) (*(vrIdec *)(void *)(Idec))
#define vrIdecAlloc() (_vrFirstFreeIdec == vrIdecNull? _vrIdecAlloc() : (\
    _vrTempIdec = _vrFirstFreeIdec,\
    _vrFirstFreeIdec = _vrIdecNextFree(_vrFirstFreeIdec),\
    memset((void *)_vrTempIdec, 0, sizeof(struct _vrIdec)),\
    _vrTempIdec))
#define vrIdecFree(Idec) (_vrIdecNextFree(Idec) = _vrFirstFreeIdec, _vrFirstFreeIdec = (Idec))
#define vrIdecGetDestructorHook() (vrIdecDestructorHook)
#define vrIdecSetDestructorHook(func) (vrIdecDestructorHook = (func))
extern void vrIdecDestroy(vrIdec Idec);
#define vrIdecGetLineNum(Idec) ((Idec)->LineNum)
#define vrIdecSetLineNum(_Idec, value) ((_Idec)->LineNum = (value))
#define vrIdecGetInternalNetlistSym(Idec) ((Idec)->InternalNetlistSym)
#define vrIdecSetInternalNetlistSym(_Idec, value) ((_Idec)->InternalNetlistSym = (value))
#define vrIdecGetSym(Idec) ((Idec)->Sym)
#define vrIdecSetSym(_Idec, value) ((_Idec)->Sym = (value))
#define vrIdecGetfirstParam(Idec) ((Idec)->firstParam)
#define vrIdecSetfirstParam(Idec, _Param) ((Idec)->firstParam = (_Param))
extern void vrIdecInsertParam(vrIdec Idec, vrParam _Param);
extern void vrIdecRemoveParam(vrIdec Idec, vrParam _Param);
#define vrForeachIdecParam(Idec, _Param) \
    for(_Param = vrIdecGetfirstParam(Idec); _Param != vrParamNull; \
        _Param = vrParamGetnextIdecParam(_Param))
#define vrEndForeachIdecParam
#define vrSafeForeachIdecParam(Idec, _Param) {\
    vrParam _nextParam;\
    for(_Param = vrIdecGetfirstParam(Idec); _Param != vrParamNull; \
        _Param = _nextParam) {\
        _nextParam = vrParamGetnextIdecParam(_Param);
#define vrEndSafeForeachIdecParam }}
#define vrIdecGetlastParam(Idec) ((Idec)->lastParam)
#define vrIdecSetlastParam(Idec, _Param) ((Idec)->lastParam = (_Param))
extern void vrIdecAppendParam(vrIdec Idec, vrParam _Param);
#define vrIdecGetNetlist(_Idec) ((_Idec)->Netlist)
#define vrIdecSetNetlist(_Idec, value) ((_Idec)->Netlist = (value))
#define vrIdecGetnextNetlistIdec(Idec) ((Idec)->nextNetlistIdec)
#define vrIdecSetnextNetlistIdec(Idec, nextIdec) ((Idec)->nextNetlistIdec = (nextIdec))

/*----------------------------------------------------------------------------
  Param methods.
----------------------------------------------------------------------------*/
#define vrParamNull ((vrParam)(NULL))
extern vrParam _vrParamAlloc(void);
#define _vrParamNextFree(Param) (*(vrParam *)(void *)(Param))
#define vrParamAlloc() (_vrFirstFreeParam == vrParamNull? _vrParamAlloc() : (\
    _vrTempParam = _vrFirstFreeParam,\
    _vrFirstFreeParam = _vrParamNextFree(_vrFirstFreeParam),\
    memset((void *)_vrTempParam, 0, sizeof(struct _vrParam)),\
    _vrTempParam))
#define vrParamFree(Param) (_vrParamNextFree(Param) = _vrFirstFreeParam, _vrFirstFreeParam = (Param))
#define vrParamGetDestructorHook() (vrParamDestructorHook)
#define vrParamSetDestructorHook(func) (vrParamDestructorHook = (func))
extern void vrParamDestroy(vrParam Param);
#define vrParamGetSym(Param) ((Param)->Sym)
#define vrParamSetSym(_Param, value) ((_Param)->Sym = (value))
#define vrParamGetfirstConn(Param) ((Param)->firstConn)
#define vrParamSetfirstConn(Param, _Conn) ((Param)->firstConn = (_Conn))
extern void vrParamInsertConn(vrParam Param, vrConn _Conn);
extern void vrParamRemoveConn(vrParam Param, vrConn _Conn);
#define vrForeachParamConn(Param, _Conn) \
    for(_Conn = vrParamGetfirstConn(Param); _Conn != vrConnNull; \
        _Conn = vrConnGetnextParamConn(_Conn))
#define vrEndForeachParamConn
#define vrSafeForeachParamConn(Param, _Conn) {\
    vrConn _nextConn;\
    for(_Conn = vrParamGetfirstConn(Param); _Conn != vrConnNull; \
        _Conn = _nextConn) {\
        _nextConn = vrConnGetnextParamConn(_Conn);
#define vrEndSafeForeachParamConn }}
#define vrParamGetlastConn(Param) ((Param)->lastConn)
#define vrParamSetlastConn(Param, _Conn) ((Param)->lastConn = (_Conn))
extern void vrParamAppendConn(vrParam Param, vrConn _Conn);
#define vrParamGetIdec(_Param) ((_Param)->Idec)
#define vrParamSetIdec(_Param, value) ((_Param)->Idec = (value))
#define vrParamGetnextIdecParam(Param) ((Param)->nextIdecParam)
#define vrParamSetnextIdecParam(Param, nextParam) ((Param)->nextIdecParam = (nextParam))

/*----------------------------------------------------------------------------
  Conn methods.
----------------------------------------------------------------------------*/
#define vrConnNull ((vrConn)(NULL))
extern vrConn _vrConnAlloc(void);
#define _vrConnNextFree(Conn) (*(vrConn *)(void *)(Conn))
#define vrConnAlloc() (_vrFirstFreeConn == vrConnNull? _vrConnAlloc() : (\
    _vrTempConn = _vrFirstFreeConn,\
    _vrFirstFreeConn = _vrConnNextFree(_vrFirstFreeConn),\
    memset((void *)_vrTempConn, 0, sizeof(struct _vrConn)),\
    _vrTempConn))
#define vrConnFree(Conn) (_vrConnNextFree(Conn) = _vrFirstFreeConn, _vrFirstFreeConn = (Conn))
#define vrConnGetDestructorHook() (vrConnDestructorHook)
#define vrConnSetDestructorHook(func) (vrConnDestructorHook = (func))
extern void vrConnDestroy(vrConn Conn);
#define vrConnGetBus(Conn) ((Conn)->Bus)
#define vrConnSetBus(_Conn, value) ((_Conn)->Bus = (value))
#define vrConnGetNet(Conn) ((Conn)->Net)
#define vrConnSetNet(_Conn, value) ((_Conn)->Net = (value))
#define vrConnGetLength(Conn) ((Conn)->Length)
#define vrConnSetLength(_Conn, value) ((_Conn)->Length = (value))
#define vrConnGetMask(Conn) ((Conn)->Mask)
#define vrConnSetMask(_Conn, value) ((_Conn)->Mask = (value))
#define vrConnConst(Conn) ((Conn)->Const)
#define vrConnSetConst(_Conn, value) ((_Conn)->Const = (value))
#define vrConnGetRight(Conn) ((Conn)->Right)
#define vrConnSetRight(_Conn, value) ((_Conn)->Right = (value))
#define vrConnGetLeft(Conn) ((Conn)->Left)
#define vrConnSetLeft(_Conn, value) ((_Conn)->Left = (value))
#define vrConnRange(Conn) ((Conn)->Range)
#define vrConnSetRange(_Conn, value) ((_Conn)->Range = (value))
#define vrConnGetParam(_Conn) ((_Conn)->Param)
#define vrConnSetParam(_Conn, value) ((_Conn)->Param = (value))
#define vrConnGetnextParamConn(Conn) ((Conn)->nextParamConn)
#define vrConnSetnextParamConn(Conn, nextConn) ((Conn)->nextParamConn = (nextConn))

/*----------------------------------------------------------------------------
  Defparam methods.
----------------------------------------------------------------------------*/
#define vrDefparamNull ((vrDefparam)(NULL))
extern vrDefparam _vrDefparamAlloc(void);
#define _vrDefparamNextFree(Defparam) (*(vrDefparam *)(void *)(Defparam))
#define vrDefparamAlloc() (_vrFirstFreeDefparam == vrDefparamNull? _vrDefparamAlloc() : (\
    _vrTempDefparam = _vrFirstFreeDefparam,\
    _vrFirstFreeDefparam = _vrDefparamNextFree(_vrFirstFreeDefparam),\
    memset((void *)_vrTempDefparam, 0, sizeof(struct _vrDefparam)),\
    _vrTempDefparam))
#define vrDefparamFree(Defparam) (_vrDefparamNextFree(Defparam) = _vrFirstFreeDefparam, _vrFirstFreeDefparam = (Defparam))
#define vrDefparamGetDestructorHook() (vrDefparamDestructorHook)
#define vrDefparamSetDestructorHook(func) (vrDefparamDestructorHook = (func))
extern void vrDefparamDestroy(vrDefparam Defparam);
#define vrDefparamGetSym(Defparam) ((Defparam)->Sym)
#define vrDefparamSetSym(_Defparam, value) ((_Defparam)->Sym = (value))
#define vrDefparamGetValue(Defparam) ((Defparam)->Value)
#define vrDefparamSetValue(_Defparam, value) ((_Defparam)->Value = (value))
#define vrDefparamGetfirstPath(Defparam) ((Defparam)->firstPath)
#define vrDefparamSetfirstPath(Defparam, _Path) ((Defparam)->firstPath = (_Path))
extern void vrDefparamInsertPath(vrDefparam Defparam, vrPath _Path);
extern void vrDefparamRemovePath(vrDefparam Defparam, vrPath _Path);
#define vrForeachDefparamPath(Defparam, _Path) \
    for(_Path = vrDefparamGetfirstPath(Defparam); _Path != vrPathNull; \
        _Path = vrPathGetnextDefparamPath(_Path))
#define vrEndForeachDefparamPath
#define vrSafeForeachDefparamPath(Defparam, _Path) {\
    vrPath _nextPath;\
    for(_Path = vrDefparamGetfirstPath(Defparam); _Path != vrPathNull; \
        _Path = _nextPath) {\
        _nextPath = vrPathGetnextDefparamPath(_Path);
#define vrEndSafeForeachDefparamPath }}
#define vrDefparamGetlastPath(Defparam) ((Defparam)->lastPath)
#define vrDefparamSetlastPath(Defparam, _Path) ((Defparam)->lastPath = (_Path))
extern void vrDefparamAppendPath(vrDefparam Defparam, vrPath _Path);
#define vrDefparamGetNetlist(_Defparam) ((_Defparam)->Netlist)
#define vrDefparamSetNetlist(_Defparam, value) ((_Defparam)->Netlist = (value))
#define vrDefparamGetnextNetlistDefparam(Defparam) ((Defparam)->nextNetlistDefparam)
#define vrDefparamSetnextNetlistDefparam(Defparam, nextDefparam) ((Defparam)->nextNetlistDefparam = (nextDefparam))

/*----------------------------------------------------------------------------
  Path methods.
----------------------------------------------------------------------------*/
#define vrPathNull ((vrPath)(NULL))
extern vrPath _vrPathAlloc(void);
#define _vrPathNextFree(Path) (*(vrPath *)(void *)(Path))
#define vrPathAlloc() (_vrFirstFreePath == vrPathNull? _vrPathAlloc() : (\
    _vrTempPath = _vrFirstFreePath,\
    _vrFirstFreePath = _vrPathNextFree(_vrFirstFreePath),\
    memset((void *)_vrTempPath, 0, sizeof(struct _vrPath)),\
    _vrTempPath))
#define vrPathFree(Path) (_vrPathNextFree(Path) = _vrFirstFreePath, _vrFirstFreePath = (Path))
#define vrPathGetDestructorHook() (vrPathDestructorHook)
#define vrPathSetDestructorHook(func) (vrPathDestructorHook = (func))
extern void vrPathDestroy(vrPath Path);
#define vrPathGetSym(Path) ((Path)->Sym)
#define vrPathSetSym(_Path, value) ((_Path)->Sym = (value))
#define vrPathGetDefparam(_Path) ((_Path)->Defparam)
#define vrPathSetDefparam(_Path, value) ((_Path)->Defparam = (value))
#define vrPathGetnextDefparamPath(Path) ((Path)->nextDefparamPath)
#define vrPathSetnextDefparamPath(Path, nextPath) ((Path)->nextDefparamPath = (nextPath))

/*----------------------------------------------------------------------------
  Package level routines.
----------------------------------------------------------------------------*/
extern void vrDDRStart(void);
extern void vrDDRStop(void);

/*----------------------------------------------------------------------------
  Structure definitions.
----------------------------------------------------------------------------*/
struct _vrNetlist {
    struct _utExtension _extension;
    dbNetlist _super;
    vrIdec firstIdec;
    vrIdec lastIdec;
    vrDefparam firstDefparam;
};

struct _vrIdec {
    U32 LineNum;
    utSym InternalNetlistSym;
    utSym Sym;
    vrParam firstParam;
    vrParam lastParam;
    vrNetlist Netlist;
    vrIdec nextNetlistIdec;
};

struct _vrParam {
    utSym Sym;
    vrConn firstConn;
    vrConn lastConn;
    vrIdec Idec;
    vrParam nextIdecParam;
};

struct _vrConn {
    dbBus Bus;
    dbNet Net;
    U32 Length;
    U32 Mask;
    U32 Right;
    U32 Left;
    vrParam Param;
    vrConn nextParamConn;
    bool Const:2;
    bool Range:2;
};

struct _vrDefparam {
    utSym Sym;
    utSym Value;
    vrPath firstPath;
    vrPath lastPath;
    vrNetlist Netlist;
    vrDefparam nextNetlistDefparam;
};

struct _vrPath {
    utSym Sym;
    vrDefparam Defparam;
    vrPath nextDefparamPath;
};

extern struct _utFunctionTable vrNetlistFunctionTable;
extern utSym vrNetlistClassName;
extern vrNetlist _vrFirstFreeNetlist, _vrTempNetlist;
extern void (*vrIdecDestructorHook)(vrIdec);
extern vrIdec _vrFirstFreeIdec, _vrTempIdec;
extern void (*vrParamDestructorHook)(vrParam);
extern vrParam _vrFirstFreeParam, _vrTempParam;
extern void (*vrConnDestructorHook)(vrConn);
extern vrConn _vrFirstFreeConn, _vrTempConn;
extern void (*vrDefparamDestructorHook)(vrDefparam);
extern vrDefparam _vrFirstFreeDefparam, _vrTempDefparam;
extern void (*vrPathDestructorHook)(vrPath);
extern vrPath _vrFirstFreePath, _vrTempPath;

#endif
