/*
 * Copyright (C) 2003 ViASIC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */

/*============================================================================
   Module : Datadraw
   Purpose: Includes UNIX dependent functions.
============================================================================*/

#include <setjmp.h>
#ifndef __USE_XOPEN
#define __USE_XOPEN /* So stdlib.h will include putenv */
#endif
#include <stdlib.h>
#include <string.h>
#ifndef __USE_BSD
#define __USE_BSD /* So unistd.h will include readlink */
#endif
#include <unistd.h>
#include <glob.h>
#include <ctype.h>
#include <sys/stat.h>
#include <dirent.h>
#include <errno.h>
#include "util.h"
#include <sys/ioctl.h>
#include <time.h>

jmp_buf utJmpBuf[UT_MAX_SETJMP_DEPTH];

/*--------------------------------------------------------------------------------------------------
  Decrement the setjmp stack, and longjmp.
--------------------------------------------------------------------------------------------------*/
void utLongjmp (void)
{
   utSetjmpDepth--;
   if (utSetjmpDepth < 0 || utSetjmpDepth > UT_MAX_SETJMP_DEPTH) {
      utExit("utLongjmp: No utSetjmp for utLongjmp");
   } else {
      longjmp(utJmpBuf[utSetjmpDepth], 1);
   }
}

/*--------------------------------------------------------------------------------------------------
  Take the relative path, and return the full path.
--------------------------------------------------------------------------------------------------*/
char *utFullPath(
    char *relativePath)
{ 
    char *fileName = utGlob(relativePath);
    char *dirName = utGetcwd();

    if(*relativePath == UTDIRSEP) {
        return utCopyString(relativePath);
    }
    if(fileName == NULL) {
        return utSprintf("%s%c%s", dirName, UTDIRSEP, relativePath);
    }
    while(!strncmp(fileName, ".." szUTDIRSEP, 3)) {
        fileName = fileName + 3;
        dirName = utDirName(dirName);
        if(dirName == NULL) {
            return utSprintf("%s%c%s", dirName, UTDIRSEP, relativePath);
        }
    }
    return utSprintf("%s%c%s", dirName, UTDIRSEP, fileName);
}

/*--------------------------------------------------------------------------------------------------
  Default Error notification routine in absence of user-speified.
--------------------------------------------------------------------------------------------------*/
void UTEXPORT ErrorNotify (
   char *string)
{
   printf("%s\n", string);
}

/*--------------------------------------------------------------------------------------------------
  Allocate a block of memory. Don't fill with 0's.
--------------------------------------------------------------------------------------------------*/
void * UTEXPORT mtCalloc (
   U32 numBlocks,
   U16 size)
{
   return calloc(numBlocks, size);
}

/*--------------------------------------------------------------------------------------------------
  Allocate a block of memory. Don't fill with 0's.
--------------------------------------------------------------------------------------------------*/
void * UTEXPORT mtMalloc (
   U32 numBlocks,
   U16 size)
{
   return malloc(numBlocks*size);
}

/*--------------------------------------------------------------------------------------------------
  Reallocate and expand memory.
--------------------------------------------------------------------------------------------------*/
void * UTEXPORT mtRealloc (
   void *mem,
   U32 numBlocks,
   U16 size)
{
   return realloc((char *)mem, (size_t)(numBlocks * size));
}

/*--------------------------------------------------------------------------------------------------
  Free a block of memory.  Return TRUE if sucess.
--------------------------------------------------------------------------------------------------*/
bool UTEXPORT mtFree (
   void *p)
{
   free((char *)p);
   return true;
}


/*--------------------------------------------------------------------------------------------------
   FUNCTION: utGetProfileString
   PURPOSE : Function to read a string from a .ini file
--------------------------------------------------------------------------------------------------*/
bool utGetProfileString(char *szToolName, char *szKeyName,
   char *szDefault, char *szBuffer, S16 nSize)
{
   strcpy(szBuffer, szDefault);
   return true;
}

/*--------------------------------------------------------------------------------------------------
   FUNCTION: utGetProfileString
   PURPOSE : Function to write a string to win.ini file
--------------------------------------------------------------------------------------------------*/
bool utWriteProfileString(char *szSection, char *szKeyName,
   char *szValue)
{
   return true;
}

/*--------------------------------------------------------------------------------------------------
   FUNCTION: utGetPrivateProfileInt
   PURPOSE : Function to read a Int from a .ini file
--------------------------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------------------------
S32 utGetPrivateProfileInt(char *szToolName,
   char *szKeyName, S32 nDefault, char *szIniFileName)
{
   char szDefault[20], szBuffer[20];

   sprintf(szDefault, "%d", nDefault);
   utGetPrivateProfileString(szToolName, szKeyName, szDefault, szBuffer,
                             20, szIniFileName);
   return (S32)atoi(szBuffer);
}
*/

/*--------------------------------------------------------------------------------------------------
   FUNCTION: utGetPrivateProfileString
   PURPOSE : Function to read a string from a .ini file
--------------------------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------------------------
void utGetPrivateProfileString (
   char *szToolName,
   char *szKeyName, 
   char *szDefault, 
   char *szBuffer,
   S16 nSize, 
   char *szIniFileName )
{
   char *buf;
   char *restype;
   XrmValue val;
   char *ptr;

   if (!utStricmp(szIniFileName, "win.ini")) {
      buf = utSprintf("%s_%s", szToolName, szKeyName);
      while ((ptr = strchr(buf, '-')) != NULL) {
         *ptr = '_';
      }
      ptr = getenv(buf);
      if (!ptr || !utStricmp(ptr, "")) {
         utStrcpy(szBuffer, szDefault);
      } else {
         utStrcpy(szBuffer, ptr);
      }
      return;
   }
   utStrlwr(szToolName);
   utStrlwr(szKeyName);

   strncpy(buf, szToolName, UTSTRLEN);
   strncat(buf, ".",        UTSTRLEN - strlen(buf));
   strncat(buf, szKeyName,  UTSTRLEN - strlen(buf));

   if (XrmGetResource(utXDatabase, buf, buf, &restype, &val)) {
      strncpy(szBuffer, val.addr, (int) val.size);
      szBuffer[(int) val.size] = '\0';
   } else {
      strcpy(szBuffer, szDefault);
   }
}
*/

/*--------------------------------------------------------------------------------------------------
   FUNCTION: utWritePrivateProfileString
   PURPOSE : Function to write a string to a .ini file
--------------------------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------------------------
void utWritePrivateProfileString(char *szToolName,
   char *szKeyName, char *szSetStr, char *szIniFileName)
{
   char szBuff[UTSTRLEN];
   XrmValue val;
   XrmDatabase utXDatabaseLocal;
   XrmDatabase utXDatabaseString;

   utStrlwr(szToolName);
   utStrlwr(szKeyName);

   strncpy(szBuff, szToolName, UTSTRLEN);
   strncat(szBuff, ".",        UTSTRLEN - strlen(szBuff));
   strncat(szBuff, szKeyName,  UTSTRLEN - strlen(szBuff));

   utXDatabaseString = XrmGetStringDatabase("");
   XrmPutStringResource(&utXDatabaseString, szBuff, szSetStr);

   utXDatabaseLocal = XrmGetFileDatabase(szIniFileName);

   XrmMergeDatabases(utXDatabaseString, &utXDatabaseLocal);

   XrmPutFileDatabase(utXDatabaseLocal, szIniFileName);

   XrmDestroyDatabase(utXDatabase);
   utXDatabase = utXDatabaseLocal;
}
*/

/*--------------------------------------------------------------------------------------------------
  Launches an application. Simple interface - no params except
             command line & wkgDir. Command line can include args. Wkg dir
             can be NULL.
--------------------------------------------------------------------------------------------------*/
bool UTEXPORT utLaunchApp (
   char* cmdLine,
   char* wkgDir)
{
   return (bool) system(cmdLine);
}

/*--------------------------------------------------------------------------------------------------
  Terminate. Unix optionally writes a core file for debug, NT just exits.
--------------------------------------------------------------------------------------------------*/
void utAbnormalProgramTermination(void)
{
    if (utEnableCoreFile) {
        abort();
    } else {
        exit(-1);
    }
}

/*--------------------------------------------------------------------------------------------------
  Match the string to a file and return the matched file name.
--------------------------------------------------------------------------------------------------*/
char *utGlob(
    char *fileName)
{
    glob_t globbuf;
    char *buffer = NULL;

    globbuf.gl_offs = 0;
    glob(fileName, 0, NULL, &globbuf);
    if(globbuf.gl_pathc >= 1) {
        buffer = utCopyString(*globbuf.gl_pathv);
    }
    globfree(&globbuf);
    return buffer;
}

/*--------------------------------------------------------------------------------------------------
  Find the current working directory name.
--------------------------------------------------------------------------------------------------*/
char *utGetcwd(void)
{
    char buffer[UTSTRLEN];

    getcwd(buffer, UTSTRLEN);
    return utCopyString(buffer);
}

/*--------------------------------------------------------------------------------------------------
  Determine the access to a file
--------------------------------------------------------------------------------------------------*/
bool utAccess(
    char *name,
    char *mode)
{
    if(mode == NULL) {
        return access(name, 0) == 0;
    }
    if(!strcmp(mode, "r")) {
        return access(name, R_OK) == 0;
    }
    if(!strcmp(mode, "w")) {
        return access(name, W_OK) == 0;
    }
    if(!strcmp(mode, "x")) {
        return access(name, X_OK) == 0;
    }
    utExit("Unknown mode passed to utAccess");
    return false; /* Dummy return */
}

/*--------------------------------------------------------------------------------------------------
  Return the path name which an executable resides.
--------------------------------------------------------------------------------------------------*/
char *utExecPath(
    char *program)
{
    char *buf;
    char *execpath = utMakeString(UTSTRLEN);
    int numChars;

    buf = utSprintf("/proc/%d/exe", getpid());
    memset(execpath, 0, UTSTRLEN);
    numChars = readlink(buf, execpath, UTSTRLEN - 1);
    execpath[numChars] = '\0';
    return execpath;
}

/*--------------------------------------------------------------------------------------------------
  Set the environment variable.
--------------------------------------------------------------------------------------------------*/
void utSetEnvironmentVariable(
    char *name,
    char *value)
{
    putenv(utSprintf("%s=%s", name, value));
}

/*--------------------------------------------------------------------------------------------------
  Get the environment variable.  Return NULL if it is not set.
--------------------------------------------------------------------------------------------------*/
char *utGetEnvironmentVariable(
    char *name)
{
    return getenv(name);
}

