/*-----------------------------------------------------------------------------
  Module header file for: sch module
-----------------------------------------------------------------------------*/

#ifndef schddr_H
#define schddr_H

#ifndef UTIL_H
#include "util.h"
#endif

#ifndef sch_TYPEDEF_H
#include "schtypedef.h"
#endif

/*-----------------------------------------------------------------------------
    Typedefs, constants, and enums here.
-----------------------------------------------------------------------------*/
typedef struct _schNet *schNet;
typedef struct _schComp *schComp;
typedef struct _schMpin *schMpin;
typedef struct _schSchem *schSchem;
typedef struct _schRoot *schRoot;
typedef struct _schSymbol *schSymbol;
typedef struct _schPin *schPin;
typedef struct _schWire *schWire;
typedef struct _schAttr *schAttr;
typedef struct _schConn *schConn;
typedef struct _schGraphic *schGraphic;
typedef struct _schLine *schLine;
typedef struct _schRect *schRect;
typedef struct _schCircle *schCircle;
typedef struct _schArc *schArc;
typedef struct _schSignal *schSignal;
typedef struct _schBus *schBus;
typedef struct _schCol *schCol;

/* ObjectType enumerated type */
typedef enum {
    SCH_TEXT,  /* 0 */
    SCH_COMPLEX,  /* 1 */
    SCH_PIN,  /* 2 */
    SCH_BUS,  /* 3 */
    SCH_NET   /* 4 */
} schObjectType;

/*----------------------------------------------------------------------------
  Net methods.
----------------------------------------------------------------------------*/
#define schNetNull ((schNet)(NULL))
extern schNet _schNetAlloc(void);
#define _schNetNextFree(Net) (*(schNet *)(void *)(Net))
#define schNetAlloc() (_schFirstFreeNet == schNetNull? _schNetAlloc() : (\
    _schTempNet = _schFirstFreeNet,\
    _schFirstFreeNet = _schNetNextFree(_schFirstFreeNet),\
    memset((void *)_schTempNet, 0, sizeof(struct _schNet)),\
    _schTempNet))
#define schNetFree(Net) (_schNetNextFree(Net) = _schFirstFreeNet, _schFirstFreeNet = (Net))
#define schNetGetDestructorHook() (schNetDestructorHook)
#define schNetSetDestructorHook(func) (schNetDestructorHook = (func))
extern void schNetDestroy(schNet Net);
#define schNetNameGenerated(Net) ((Net)->NameGenerated)
#define schNetSetNameGenerated(_Net, value) ((_Net)->NameGenerated = (value))
#define schNetBus(Net) ((Net)->Bus)
#define schNetSetBus(_Net, value) ((_Net)->Bus = (value))
#define schNetGetfirstWire(Net) ((Net)->firstWire)
#define schNetSetfirstWire(Net, _Wire) ((Net)->firstWire = (_Wire))
extern void schNetInsertWire(schNet Net, schWire _Wire);
extern void schNetRemoveWire(schNet Net, schWire _Wire);
#define schForeachNetWire(Net, _Wire) \
    for(_Wire = schNetGetfirstWire(Net); _Wire != schWireNull; \
        _Wire = schWireGetnextNetWire(_Wire))
#define schEndForeachNetWire
#define schSafeForeachNetWire(Net, _Wire) {\
    schWire _nextWire;\
    for(_Wire = schNetGetfirstWire(Net); _Wire != schWireNull; \
        _Wire = _nextWire) {\
        _nextWire = schWireGetnextNetWire(_Wire);
#define schEndSafeForeachNetWire }}
#define schNetGetfirstPin(Net) ((Net)->firstPin)
#define schNetSetfirstPin(Net, _Pin) ((Net)->firstPin = (_Pin))
extern void schNetInsertPin(schNet Net, schPin _Pin);
extern void schNetRemovePin(schNet Net, schPin _Pin);
#define schForeachNetPin(Net, _Pin) \
    for(_Pin = schNetGetfirstPin(Net); _Pin != schPinNull; \
        _Pin = schPinGetnextNetPin(_Pin))
#define schEndForeachNetPin
#define schSafeForeachNetPin(Net, _Pin) {\
    schPin _nextPin;\
    for(_Pin = schNetGetfirstPin(Net); _Pin != schPinNull; \
        _Pin = _nextPin) {\
        _nextPin = schPinGetnextNetPin(_Pin);
#define schEndSafeForeachNetPin }}
#define schNetGetlastPin(Net) ((Net)->lastPin)
#define schNetSetlastPin(Net, _Pin) ((Net)->lastPin = (_Pin))
extern void schNetAppendPin(schNet Net, schPin _Pin);
#define schNetGetfirstSignal(Net) ((Net)->firstSignal)
#define schNetSetfirstSignal(Net, _Signal) ((Net)->firstSignal = (_Signal))
extern void schNetInsertSignal(schNet Net, schSignal _Signal);
extern void schNetRemoveSignal(schNet Net, schSignal _Signal);
#define schForeachNetSignal(Net, _Signal) \
    for(_Signal = schNetGetfirstSignal(Net); _Signal != schSignalNull; \
        _Signal = schSignalGetnextNetSignal(_Signal))
#define schEndForeachNetSignal
#define schSafeForeachNetSignal(Net, _Signal) {\
    schSignal _nextSignal;\
    for(_Signal = schNetGetfirstSignal(Net); _Signal != schSignalNull; \
        _Signal = _nextSignal) {\
        _nextSignal = schSignalGetnextNetSignal(_Signal);
#define schEndSafeForeachNetSignal }}
#define schNetGetlastSignal(Net) ((Net)->lastSignal)
#define schNetSetlastSignal(Net, _Signal) ((Net)->lastSignal = (_Signal))
extern void schNetAppendSignal(schNet Net, schSignal _Signal);
#define schNetGetAttr(_Net) ((_Net)->Attr)
#define schNetSetAttr(_Net, value) ((_Net)->Attr = (value))
#define schNetGetSchem(_Net) ((_Net)->Schem)
#define schNetSetSchem(_Net, value) ((_Net)->Schem = (value))
#define schNetGetSym(Net) ((Net)->h.Sym)
#define schNetSetSym(Net, _sym) ((Net)->h.Sym = (_sym))
#define schNetGetnextSchemNet(Net) ((schNet)((Net)->h.nEntry))

/*----------------------------------------------------------------------------
  Comp methods.
----------------------------------------------------------------------------*/
#define schCompNull ((schComp)(NULL))
extern schComp _schCompAlloc(void);
#define _schCompNextFree(Comp) (*(schComp *)(void *)(Comp))
#define schCompAlloc() (_schFirstFreeComp == schCompNull? _schCompAlloc() : (\
    _schTempComp = _schFirstFreeComp,\
    _schFirstFreeComp = _schCompNextFree(_schFirstFreeComp),\
    memset((void *)_schTempComp, 0, sizeof(struct _schComp)),\
    _schTempComp))
#define schCompFree(Comp) (_schCompNextFree(Comp) = _schFirstFreeComp, _schFirstFreeComp = (Comp))
#define schCompGetDestructorHook() (schCompDestructorHook)
#define schCompSetDestructorHook(func) (schCompDestructorHook = (func))
extern void schCompDestroy(schComp Comp);
#define schCompGetRight(Comp) ((Comp)->Right)
#define schCompSetRight(_Comp, value) ((_Comp)->Right = (value))
#define schCompGetLeft(Comp) ((Comp)->Left)
#define schCompSetLeft(_Comp, value) ((_Comp)->Left = (value))
#define schCompArray(Comp) ((Comp)->Array)
#define schCompSetArray(_Comp, value) ((_Comp)->Array = (value))
#define schCompGetInst(Comp) ((Comp)->Inst)
#define schCompSetInst(_Comp, value) ((_Comp)->Inst = (value))
#define schCompGetSymbolName(Comp) ((Comp)->SymbolName)
#define schCompSetSymbolName(_Comp, value) ((_Comp)->SymbolName = (value))
#define schCompMirror(Comp) ((Comp)->Mirror)
#define schCompSetMirror(_Comp, value) ((_Comp)->Mirror = (value))
#define schCompGetAngle(Comp) ((Comp)->Angle)
#define schCompSetAngle(_Comp, value) ((_Comp)->Angle = (value))
#define schCompSelectable(Comp) ((Comp)->Selectable)
#define schCompSetSelectable(_Comp, value) ((_Comp)->Selectable = (value))
#define schCompGetY(Comp) ((Comp)->Y)
#define schCompSetY(_Comp, value) ((_Comp)->Y = (value))
#define schCompGetX(Comp) ((Comp)->X)
#define schCompSetX(_Comp, value) ((_Comp)->X = (value))
#define schCompGetfirstPin(Comp) ((Comp)->firstPin)
#define schCompSetfirstPin(Comp, _Pin) ((Comp)->firstPin = (_Pin))
extern void schCompInsertPin(schComp Comp, schPin _Pin);
extern void schCompRemovePin(schComp Comp, schPin _Pin);
#define schForeachCompPin(Comp, _Pin) \
    for(_Pin = schCompGetfirstPin(Comp); _Pin != schPinNull; \
        _Pin = schPinGetnextCompPin(_Pin))
#define schEndForeachCompPin
#define schSafeForeachCompPin(Comp, _Pin) {\
    schPin _nextPin;\
    for(_Pin = schCompGetfirstPin(Comp); _Pin != schPinNull; \
        _Pin = _nextPin) {\
        _nextPin = schPinGetnextCompPin(_Pin);
#define schEndSafeForeachCompPin }}
#define schCompGetlastPin(Comp) ((Comp)->lastPin)
#define schCompSetlastPin(Comp, _Pin) ((Comp)->lastPin = (_Pin))
extern void schCompAppendPin(schComp Comp, schPin _Pin);
#define schCompGetAttr(_Comp) ((_Comp)->Attr)
#define schCompSetAttr(_Comp, value) ((_Comp)->Attr = (value))
#define schCompGetSchem(_Comp) ((_Comp)->Schem)
#define schCompSetSchem(_Comp, value) ((_Comp)->Schem = (value))
#define schCompGetSym(Comp) ((Comp)->h.Sym)
#define schCompSetSym(Comp, _sym) ((Comp)->h.Sym = (_sym))
#define schCompGetnextSchemComp(Comp) ((schComp)((Comp)->h.nEntry))
#define schCompGetSymbol(_Comp) ((_Comp)->Symbol)
#define schCompSetSymbol(_Comp, value) ((_Comp)->Symbol = (value))
#define schCompGetnextSymbolComp(Comp) ((Comp)->nextSymbolComp)
#define schCompSetnextSymbolComp(Comp, nextComp) ((Comp)->nextSymbolComp = (nextComp))
#define schCompGetprevSymbolComp(Comp) ((Comp)->prevSymbolComp)
#define schCompSetprevSymbolComp(Comp, prevComp) ((Comp)->prevSymbolComp = (prevComp))
#define schCompGetMpin(_Comp) ((_Comp)->Mpin)
#define schCompSetMpin(_Comp, value) ((_Comp)->Mpin = (value))
#define schCompGetCol(_Comp) ((_Comp)->Col)
#define schCompSetCol(_Comp, value) ((_Comp)->Col = (value))
#define schCompGetColIndex(Comp) ((Comp)->ColIndex)
#define schCompSetColIndex(Comp, value) ((Comp)->ColIndex = (value))

/*----------------------------------------------------------------------------
  Mpin methods.
----------------------------------------------------------------------------*/
#define schMpinNull ((schMpin)(NULL))
extern schMpin _schMpinAlloc(void);
#define _schMpinNextFree(Mpin) (*(schMpin *)(void *)(Mpin))
#define schMpinAlloc() (_schFirstFreeMpin == schMpinNull? _schMpinAlloc() : (\
    _schTempMpin = _schFirstFreeMpin,\
    _schFirstFreeMpin = _schMpinNextFree(_schFirstFreeMpin),\
    memset((void *)_schTempMpin, 0, sizeof(struct _schMpin)),\
    _schTempMpin))
#define schMpinFree(Mpin) (_schMpinNextFree(Mpin) = _schFirstFreeMpin, _schFirstFreeMpin = (Mpin))
#define schMpinGetDestructorHook() (schMpinDestructorHook)
#define schMpinSetDestructorHook(func) (schMpinDestructorHook = (func))
extern void schMpinDestroy(schMpin Mpin);
#define schMpinGetMbus(Mpin) ((Mpin)->Mbus)
#define schMpinSetMbus(_Mpin, value) ((_Mpin)->Mbus = (value))
#define schMpinGetMport(Mpin) ((Mpin)->Mport)
#define schMpinSetMport(_Mpin, value) ((_Mpin)->Mport = (value))
#define schMpinGetRight(Mpin) ((Mpin)->Right)
#define schMpinSetRight(_Mpin, value) ((_Mpin)->Right = (value))
#define schMpinGetLeft(Mpin) ((Mpin)->Left)
#define schMpinSetLeft(_Mpin, value) ((_Mpin)->Left = (value))
#define schMpinBus(Mpin) ((Mpin)->Bus)
#define schMpinSetBus(_Mpin, value) ((_Mpin)->Bus = (value))
#define schMpinGetY2(Mpin) ((Mpin)->Y2)
#define schMpinSetY2(_Mpin, value) ((_Mpin)->Y2 = (value))
#define schMpinGetX2(Mpin) ((Mpin)->X2)
#define schMpinSetX2(_Mpin, value) ((_Mpin)->X2 = (value))
#define schMpinGetSequence(Mpin) ((Mpin)->Sequence)
#define schMpinSetSequence(_Mpin, value) ((_Mpin)->Sequence = (value))
#define schMpinGetY(Mpin) ((Mpin)->Y)
#define schMpinSetY(_Mpin, value) ((_Mpin)->Y = (value))
#define schMpinGetX(Mpin) ((Mpin)->X)
#define schMpinSetX(_Mpin, value) ((_Mpin)->X = (value))
#define schMpinGetType(Mpin) ((Mpin)->Type)
#define schMpinSetType(_Mpin, value) ((_Mpin)->Type = (value))
#define schMpinGetFlagComp(_Mpin) ((_Mpin)->FlagComp)
#define schMpinSetFlagComp(_Mpin, value) ((_Mpin)->FlagComp = (value))
#define schMpinGetAttr(_Mpin) ((_Mpin)->Attr)
#define schMpinSetAttr(_Mpin, value) ((_Mpin)->Attr = (value))
#define schMpinGetSymbol(_Mpin) ((_Mpin)->Symbol)
#define schMpinSetSymbol(_Mpin, value) ((_Mpin)->Symbol = (value))
#define schMpinGetSym(Mpin) ((Mpin)->h.Sym)
#define schMpinSetSym(Mpin, _sym) ((Mpin)->h.Sym = (_sym))
#define schMpinGetnextSymbolMpin(Mpin) ((schMpin)((Mpin)->h.nEntry))

/*----------------------------------------------------------------------------
  Schem methods.
----------------------------------------------------------------------------*/
#define schSchemNull ((schSchem)(NULL))
extern schSchem schSchemAlloc(void);
#define _schSchemNextFree(Schem) (*(schSchem *)(void *)(Schem))
extern void schSchemFree(schSchem Schem);
#define schSchemGetDestructorHook() (schSchemDestructorHook)
#define schSchemSetDestructorHook(func) (schSchemDestructorHook = (func))
extern void schSchemDestroy(schSchem Schem);
#define schSchemGetPath(Schem) ((Schem)->Path)
#define schSchemSetPath(_Schem, value) ((_Schem)->Path = (value))
#define schSchemWritten(Schem) ((Schem)->Written)
#define schSchemSetWritten(_Schem, value) ((_Schem)->Written = (value))
extern void schSchemInsertComp(schSchem Schem, schComp _Comp);
extern void schSchemRemoveComp(schSchem Schem, schComp _Comp);
extern void schSchemAppendComp(schSchem Schem, schComp _Comp);
#define schSchemFindComp(Schem, name) (schComp)utqEntryHtblSym(&(Schem)->Comps, name)
#define schSchemGetnumComps(Schem) ((Schem)->Comps.count)
#define schSchemGetComps(Schem) (&(Schem)->Comps)
#define schSchemGetfirstComp(Schem) ((schComp)(utfHtblEntry(schSchemGetComps(Schem))))
#define schSchemGetlastComp(Schem) ((schComp)(utlHtblEntry(schSchemGetComps(Schem))))
#define schForeachSchemComp(Schem, _Comp) for(_Comp = schSchemGetfirstComp(Schem); \
_Comp != schCompNull; _Comp = schCompGetnextSchemComp(_Comp))
#define schEndForeachSchemComp
#define schSafeForeachSchemComp(Schem, _Comp) {\
    schComp _nextComp;\
    for(_Comp = schSchemGetfirstComp(Schem); \
        _Comp != schCompNull; _Comp = _nextComp) {\
        _nextComp = schCompGetnextSchemComp(_Comp);
#define schEndSafeForeachSchemComp }}
extern void schSchemInsertNet(schSchem Schem, schNet _Net);
extern void schSchemRemoveNet(schSchem Schem, schNet _Net);
extern void schSchemAppendNet(schSchem Schem, schNet _Net);
#define schSchemFindNet(Schem, name) (schNet)utqEntryHtblSym(&(Schem)->Nets, name)
#define schSchemGetnumNets(Schem) ((Schem)->Nets.count)
#define schSchemGetNets(Schem) (&(Schem)->Nets)
#define schSchemGetfirstNet(Schem) ((schNet)(utfHtblEntry(schSchemGetNets(Schem))))
#define schSchemGetlastNet(Schem) ((schNet)(utlHtblEntry(schSchemGetNets(Schem))))
#define schForeachSchemNet(Schem, _Net) for(_Net = schSchemGetfirstNet(Schem); \
_Net != schNetNull; _Net = schNetGetnextSchemNet(_Net))
#define schEndForeachSchemNet
#define schSafeForeachSchemNet(Schem, _Net) {\
    schNet _nextNet;\
    for(_Net = schSchemGetfirstNet(Schem); \
        _Net != schNetNull; _Net = _nextNet) {\
        _nextNet = schNetGetnextSchemNet(_Net);
#define schEndSafeForeachSchemNet }}
#define schSchemGetfirstWire(Schem) ((Schem)->firstWire)
#define schSchemSetfirstWire(Schem, _Wire) ((Schem)->firstWire = (_Wire))
extern void schSchemInsertWire(schSchem Schem, schWire _Wire);
extern void schSchemRemoveWire(schSchem Schem, schWire _Wire);
#define schForeachSchemWire(Schem, _Wire) \
    for(_Wire = schSchemGetfirstWire(Schem); _Wire != schWireNull; \
        _Wire = schWireGetnextSchemWire(_Wire))
#define schEndForeachSchemWire
#define schSafeForeachSchemWire(Schem, _Wire) {\
    schWire _nextWire;\
    for(_Wire = schSchemGetfirstWire(Schem); _Wire != schWireNull; \
        _Wire = _nextWire) {\
        _nextWire = schWireGetnextSchemWire(_Wire);
#define schEndSafeForeachSchemWire }}
#define schSchemGetlastWire(Schem) ((Schem)->lastWire)
#define schSchemSetlastWire(Schem, _Wire) ((Schem)->lastWire = (_Wire))
extern void schSchemAppendWire(schSchem Schem, schWire _Wire);
extern void schSchemInsertBus(schSchem Schem, schBus _Bus);
extern void schSchemRemoveBus(schSchem Schem, schBus _Bus);
extern void schSchemAppendBus(schSchem Schem, schBus _Bus);
#define schSchemFindBus(Schem, name) (schBus)utqEntryHtblSym(&(Schem)->Buss, name)
#define schSchemGetnumBuss(Schem) ((Schem)->Buss.count)
#define schSchemGetBuss(Schem) (&(Schem)->Buss)
#define schSchemGetfirstBus(Schem) ((schBus)(utfHtblEntry(schSchemGetBuss(Schem))))
#define schSchemGetlastBus(Schem) ((schBus)(utlHtblEntry(schSchemGetBuss(Schem))))
#define schForeachSchemBus(Schem, _Bus) for(_Bus = schSchemGetfirstBus(Schem); \
_Bus != schBusNull; _Bus = schBusGetnextSchemBus(_Bus))
#define schEndForeachSchemBus
#define schSafeForeachSchemBus(Schem, _Bus) {\
    schBus _nextBus;\
    for(_Bus = schSchemGetfirstBus(Schem); \
        _Bus != schBusNull; _Bus = _nextBus) {\
        _nextBus = schBusGetnextSchemBus(_Bus);
#define schEndSafeForeachSchemBus }}
#define schSchemGetAttr(_Schem) ((_Schem)->Attr)
#define schSchemSetAttr(_Schem, value) ((_Schem)->Attr = (value))
#define schSchemGetiCol(Schem, x) ((Schem)->Cols[x])
#define schSchemSetiCol(Schem, x, _Col) ((Schem)->Cols[x] = (_Col))
#define schSchemGetnumCols(Schem) ((Schem)->numCols)
#define schSchemSetusedCols(Schem, numCols) ((Schem)->usedCols = (numCols))
#define schSchemGetusedCols(Schem) ((Schem)->usedCols)
#define schSchemGetCols(Schem) ((Schem)->Cols)
#define schSchemAllocCols(Schem, num) ((Schem)->usedCols = (num), \
(Schem)->numCols = (num), (Schem)->Cols = mtNewA(schCol, (num)))
#define schSchemReallocCols(Schem, num) ((Schem)->numCols = (num), (Schem)->Cols = mtResizeArray((Schem)->Cols, (num)*sizeof(schCol)))
#define schSchemFreeCols(Schem) (mtDelete((Schem)->Cols), (Schem)->Cols = NULL, \
    (Schem)->numCols = 0, (Schem)->usedCols = 0)
extern void schSchemInsertCol(schSchem Schem, schCol _Col);
extern void schSchemRemoveCol(schSchem Schem, schCol _Col);
#define schForeachSchemCol(Schem, _Col) { \
    U32 _xCol; \
    for(_xCol = 0; _xCol < schSchemGetusedCols(Schem); \
        _xCol++) { \
        _Col = schSchemGetiCol(Schem, _xCol);
#define schEndForeachSchemCol }}
#define schSafeForeachSchemCol(Schem, _Col) { \
    U32 _xCol; \
    for(_xCol = 0; _xCol < schSchemGetusedCols(Schem); \
        schSchemGetiCol(Schem, _xCol) == _Col &&_xCol++) { \
        _Col = schSchemGetiCol(Schem, _xCol); \
        if(_Col != schColNull) {
#define schEndSafeForeachSchemCol }}}
#define schSchemGetRoot(_Schem) ((_Schem)->Root)
#define schSchemSetRoot(_Schem, value) ((_Schem)->Root = (value))
#define schSchemGetSym(Schem) ((Schem)->h.Sym)
#define schSchemSetSym(Schem, _sym) ((Schem)->h.Sym = (_sym))
#define schSchemGetnextRootSchem(Schem) ((schSchem)((Schem)->h.nEntry))
#define schSchemGetSymbol(_Schem) ((_Schem)->Symbol)
#define schSchemSetSymbol(_Schem, value) ((_Schem)->Symbol = (value))

/*----------------------------------------------------------------------------
  Root methods.
----------------------------------------------------------------------------*/
#define schRootNull ((schRoot)(NULL))
extern schRoot schRootAlloc(void);
#define _schRootNextFree(Root) (*(schRoot *)(void *)(Root))
extern void schRootFree(schRoot Root);
#define schRootGetDestructorHook() (schRootDestructorHook)
#define schRootSetDestructorHook(func) (schRootDestructorHook = (func))
extern void schRootDestroy(schRoot Root);
extern void schRootInsertSchem(schRoot Root, schSchem _Schem);
extern void schRootRemoveSchem(schRoot Root, schSchem _Schem);
extern void schRootAppendSchem(schRoot Root, schSchem _Schem);
#define schRootFindSchem(Root, name) (schSchem)utqEntryHtblSym(&(Root)->Schems, name)
#define schRootGetnumSchems(Root) ((Root)->Schems.count)
#define schRootGetSchems(Root) (&(Root)->Schems)
#define schRootGetfirstSchem(Root) ((schSchem)(utfHtblEntry(schRootGetSchems(Root))))
#define schRootGetlastSchem(Root) ((schSchem)(utlHtblEntry(schRootGetSchems(Root))))
#define schForeachRootSchem(Root, _Schem) for(_Schem = schRootGetfirstSchem(Root); \
_Schem != schSchemNull; _Schem = schSchemGetnextRootSchem(_Schem))
#define schEndForeachRootSchem
#define schSafeForeachRootSchem(Root, _Schem) {\
    schSchem _nextSchem;\
    for(_Schem = schRootGetfirstSchem(Root); \
        _Schem != schSchemNull; _Schem = _nextSchem) {\
        _nextSchem = schSchemGetnextRootSchem(_Schem);
#define schEndSafeForeachRootSchem }}
extern void schRootInsertSymbol(schRoot Root, schSymbol _Symbol);
extern void schRootRemoveSymbol(schRoot Root, schSymbol _Symbol);
extern void schRootAppendSymbol(schRoot Root, schSymbol _Symbol);
#define schRootFindSymbol(Root, name) (schSymbol)utqEntryHtblSym(&(Root)->Symbols, name)
#define schRootGetnumSymbols(Root) ((Root)->Symbols.count)
#define schRootGetSymbols(Root) (&(Root)->Symbols)
#define schRootGetfirstSymbol(Root) ((schSymbol)(utfHtblEntry(schRootGetSymbols(Root))))
#define schRootGetlastSymbol(Root) ((schSymbol)(utlHtblEntry(schRootGetSymbols(Root))))
#define schForeachRootSymbol(Root, _Symbol) for(_Symbol = schRootGetfirstSymbol(Root); \
_Symbol != schSymbolNull; _Symbol = schSymbolGetnextRootSymbol(_Symbol))
#define schEndForeachRootSymbol
#define schSafeForeachRootSymbol(Root, _Symbol) {\
    schSymbol _nextSymbol;\
    for(_Symbol = schRootGetfirstSymbol(Root); \
        _Symbol != schSymbolNull; _Symbol = _nextSymbol) {\
        _nextSymbol = schSymbolGetnextRootSymbol(_Symbol);
#define schEndSafeForeachRootSymbol }}

/*----------------------------------------------------------------------------
  Symbol methods.
----------------------------------------------------------------------------*/
#define schSymbolNull ((schSymbol)(NULL))
extern schSymbol schSymbolAlloc(void);
#define _schSymbolNextFree(Symbol) (*(schSymbol *)(void *)(Symbol))
extern void schSymbolFree(schSymbol Symbol);
#define schSymbolGetDestructorHook() (schSymbolDestructorHook)
#define schSymbolSetDestructorHook(func) (schSymbolDestructorHook = (func))
extern void schSymbolDestroy(schSymbol Symbol);
#define schSymbolGetPath(Symbol) ((Symbol)->Path)
#define schSymbolSetPath(_Symbol, value) ((_Symbol)->Path = (value))
#define schSymbolGetDevice(Symbol) ((Symbol)->Device)
#define schSymbolSetDevice(_Symbol, value) ((_Symbol)->Device = (value))
#define schSymbolGetNetlist(Symbol) ((Symbol)->Netlist)
#define schSymbolSetNetlist(_Symbol, value) ((_Symbol)->Netlist = (value))
#define schSymbolGetType(Symbol) ((Symbol)->Type)
#define schSymbolSetType(_Symbol, value) ((_Symbol)->Type = (value))
#define schSymbolGetSchem(_Symbol) ((_Symbol)->Schem)
#define schSymbolSetSchem(_Symbol, value) ((_Symbol)->Schem = (value))
extern void schSymbolInsertMpin(schSymbol Symbol, schMpin _Mpin);
extern void schSymbolRemoveMpin(schSymbol Symbol, schMpin _Mpin);
extern void schSymbolAppendMpin(schSymbol Symbol, schMpin _Mpin);
#define schSymbolFindMpin(Symbol, name) (schMpin)utqEntryHtblSym(&(Symbol)->Mpins, name)
#define schSymbolGetnumMpins(Symbol) ((Symbol)->Mpins.count)
#define schSymbolGetMpins(Symbol) (&(Symbol)->Mpins)
#define schSymbolGetfirstMpin(Symbol) ((schMpin)(utfHtblEntry(schSymbolGetMpins(Symbol))))
#define schSymbolGetlastMpin(Symbol) ((schMpin)(utlHtblEntry(schSymbolGetMpins(Symbol))))
#define schForeachSymbolMpin(Symbol, _Mpin) for(_Mpin = schSymbolGetfirstMpin(Symbol); \
_Mpin != schMpinNull; _Mpin = schMpinGetnextSymbolMpin(_Mpin))
#define schEndForeachSymbolMpin
#define schSafeForeachSymbolMpin(Symbol, _Mpin) {\
    schMpin _nextMpin;\
    for(_Mpin = schSymbolGetfirstMpin(Symbol); \
        _Mpin != schMpinNull; _Mpin = _nextMpin) {\
        _nextMpin = schMpinGetnextSymbolMpin(_Mpin);
#define schEndSafeForeachSymbolMpin }}
#define schSymbolGetfirstComp(Symbol) ((Symbol)->firstComp)
#define schSymbolSetfirstComp(Symbol, _Comp) ((Symbol)->firstComp = (_Comp))
extern void schSymbolInsertComp(schSymbol Symbol, schComp _Comp);
extern void schSymbolRemoveComp(schSymbol Symbol, schComp _Comp);
#define schForeachSymbolComp(Symbol, _Comp) \
    for(_Comp = schSymbolGetfirstComp(Symbol); _Comp != schCompNull; \
        _Comp = schCompGetnextSymbolComp(_Comp))
#define schEndForeachSymbolComp
#define schSafeForeachSymbolComp(Symbol, _Comp) {\
    schComp _nextComp;\
    for(_Comp = schSymbolGetfirstComp(Symbol); _Comp != schCompNull; \
        _Comp = _nextComp) {\
        _nextComp = schCompGetnextSymbolComp(_Comp);
#define schEndSafeForeachSymbolComp }}
#define schSymbolGetlastComp(Symbol) ((Symbol)->lastComp)
#define schSymbolSetlastComp(Symbol, _Comp) ((Symbol)->lastComp = (_Comp))
extern void schSymbolAppendComp(schSymbol Symbol, schComp _Comp);
#define schSymbolGetAttr(_Symbol) ((_Symbol)->Attr)
#define schSymbolSetAttr(_Symbol, value) ((_Symbol)->Attr = (value))
#define schSymbolGetGraphic(_Symbol) ((_Symbol)->Graphic)
#define schSymbolSetGraphic(_Symbol, value) ((_Symbol)->Graphic = (value))
#define schSymbolGetRoot(_Symbol) ((_Symbol)->Root)
#define schSymbolSetRoot(_Symbol, value) ((_Symbol)->Root = (value))
#define schSymbolGetSym(Symbol) ((Symbol)->h.Sym)
#define schSymbolSetSym(Symbol, _sym) ((Symbol)->h.Sym = (_sym))
#define schSymbolGetnextRootSymbol(Symbol) ((schSymbol)((Symbol)->h.nEntry))

/*----------------------------------------------------------------------------
  Pin methods.
----------------------------------------------------------------------------*/
#define schPinNull ((schPin)(NULL))
extern schPin _schPinAlloc(void);
#define _schPinNextFree(Pin) (*(schPin *)(void *)(Pin))
#define schPinAlloc() (_schFirstFreePin == schPinNull? _schPinAlloc() : (\
    _schTempPin = _schFirstFreePin,\
    _schFirstFreePin = _schPinNextFree(_schFirstFreePin),\
    memset((void *)_schTempPin, 0, sizeof(struct _schPin)),\
    _schTempPin))
#define schPinFree(Pin) (_schPinNextFree(Pin) = _schFirstFreePin, _schFirstFreePin = (Pin))
#define schPinGetDestructorHook() (schPinDestructorHook)
#define schPinSetDestructorHook(func) (schPinDestructorHook = (func))
extern void schPinDestroy(schPin Pin);
#define schPinGetPort(Pin) ((Pin)->Port)
#define schPinSetPort(_Pin, value) ((_Pin)->Port = (value))
#define schPinGetY(Pin) ((Pin)->Y)
#define schPinSetY(_Pin, value) ((_Pin)->Y = (value))
#define schPinGetX(Pin) ((Pin)->X)
#define schPinSetX(_Pin, value) ((_Pin)->X = (value))
#define schPinGetComp(_Pin) ((_Pin)->Comp)
#define schPinSetComp(_Pin, value) ((_Pin)->Comp = (value))
#define schPinGetnextCompPin(Pin) ((Pin)->nextCompPin)
#define schPinSetnextCompPin(Pin, nextPin) ((Pin)->nextCompPin = (nextPin))
#define schPinGetMpin(_Pin) ((_Pin)->Mpin)
#define schPinSetMpin(_Pin, value) ((_Pin)->Mpin = (value))
#define schPinGetNet(_Pin) ((_Pin)->Net)
#define schPinSetNet(_Pin, value) ((_Pin)->Net = (value))
#define schPinGetnextNetPin(Pin) ((Pin)->nextNetPin)
#define schPinSetnextNetPin(Pin, nextPin) ((Pin)->nextNetPin = (nextPin))

/*----------------------------------------------------------------------------
  Wire methods.
----------------------------------------------------------------------------*/
#define schWireNull ((schWire)(NULL))
extern schWire _schWireAlloc(void);
#define _schWireNextFree(Wire) (*(schWire *)(void *)(Wire))
#define schWireAlloc() (_schFirstFreeWire == schWireNull? _schWireAlloc() : (\
    _schTempWire = _schFirstFreeWire,\
    _schFirstFreeWire = _schWireNextFree(_schFirstFreeWire),\
    memset((void *)_schTempWire, 0, sizeof(struct _schWire)),\
    _schTempWire))
#define schWireFree(Wire) (_schWireNextFree(Wire) = _schFirstFreeWire, _schFirstFreeWire = (Wire))
#define schWireGetDestructorHook() (schWireDestructorHook)
#define schWireSetDestructorHook(func) (schWireDestructorHook = (func))
extern void schWireDestroy(schWire Wire);
#define schWireBus(Wire) ((Wire)->Bus)
#define schWireSetBus(_Wire, value) ((_Wire)->Bus = (value))
#define schWireGetY2(Wire) ((Wire)->Y2)
#define schWireSetY2(_Wire, value) ((_Wire)->Y2 = (value))
#define schWireGetX2(Wire) ((Wire)->X2)
#define schWireSetX2(_Wire, value) ((_Wire)->X2 = (value))
#define schWireGetY1(Wire) ((Wire)->Y1)
#define schWireSetY1(_Wire, value) ((_Wire)->Y1 = (value))
#define schWireGetX1(Wire) ((Wire)->X1)
#define schWireSetX1(_Wire, value) ((_Wire)->X1 = (value))
#define schWireGetfirstRConn(Wire) ((Wire)->firstRConn)
#define schWireSetfirstRConn(Wire, _RConn) ((Wire)->firstRConn = (_RConn))
extern void schWireInsertRConn(schWire Wire, schConn _Conn);
extern void schWireRemoveRConn(schWire Wire, schConn _Conn);
#define schForeachWireRConn(Wire, _Conn) \
    for(_Conn = schWireGetfirstRConn(Wire); _Conn != schConnNull; \
        _Conn = schConnGetnextWireRConn(_Conn))
#define schEndForeachWireRConn
#define schSafeForeachWireRConn(Wire, _Conn) {\
    schConn _nextConn;\
    for(_Conn = schWireGetfirstRConn(Wire); _Conn != schConnNull; \
        _Conn = _nextConn) {\
        _nextConn = schConnGetnextWireRConn(_Conn);
#define schEndSafeForeachWireRConn }}
#define schWireGetfirstLConn(Wire) ((Wire)->firstLConn)
#define schWireSetfirstLConn(Wire, _LConn) ((Wire)->firstLConn = (_LConn))
extern void schWireInsertLConn(schWire Wire, schConn _Conn);
extern void schWireRemoveLConn(schWire Wire, schConn _Conn);
#define schForeachWireLConn(Wire, _Conn) \
    for(_Conn = schWireGetfirstLConn(Wire); _Conn != schConnNull; \
        _Conn = schConnGetnextWireLConn(_Conn))
#define schEndForeachWireLConn
#define schSafeForeachWireLConn(Wire, _Conn) {\
    schConn _nextConn;\
    for(_Conn = schWireGetfirstLConn(Wire); _Conn != schConnNull; \
        _Conn = _nextConn) {\
        _nextConn = schConnGetnextWireLConn(_Conn);
#define schEndSafeForeachWireLConn }}
#define schWireGetAttr(_Wire) ((_Wire)->Attr)
#define schWireSetAttr(_Wire, value) ((_Wire)->Attr = (value))
#define schWireGetNet(_Wire) ((_Wire)->Net)
#define schWireSetNet(_Wire, value) ((_Wire)->Net = (value))
#define schWireGetnextNetWire(Wire) ((Wire)->nextNetWire)
#define schWireSetnextNetWire(Wire, nextWire) ((Wire)->nextNetWire = (nextWire))
#define schWireGetSchem(_Wire) ((_Wire)->Schem)
#define schWireSetSchem(_Wire, value) ((_Wire)->Schem = (value))
#define schWireGetnextSchemWire(Wire) ((Wire)->nextSchemWire)
#define schWireSetnextSchemWire(Wire, nextWire) ((Wire)->nextSchemWire = (nextWire))
#define schWireGetprevSchemWire(Wire) ((Wire)->prevSchemWire)
#define schWireSetprevSchemWire(Wire, prevWire) ((Wire)->prevSchemWire = (prevWire))

/*----------------------------------------------------------------------------
  Attr methods.
----------------------------------------------------------------------------*/
#define schAttrNull ((schAttr)(NULL))
extern schAttr _schAttrAlloc(void);
#define _schAttrNextFree(Attr) (*(schAttr *)(void *)(Attr))
#define schAttrAlloc() (_schFirstFreeAttr == schAttrNull? _schAttrAlloc() : (\
    _schTempAttr = _schFirstFreeAttr,\
    _schFirstFreeAttr = _schAttrNextFree(_schFirstFreeAttr),\
    memset((void *)_schTempAttr, 0, sizeof(struct _schAttr)),\
    _schTempAttr))
#define schAttrFree(Attr) (_schAttrNextFree(Attr) = _schFirstFreeAttr, _schFirstFreeAttr = (Attr))
#define schAttrGetDestructorHook() (schAttrDestructorHook)
#define schAttrSetDestructorHook(func) (schAttrDestructorHook = (func))
extern void schAttrDestroy(schAttr Attr);
#define schAttrGetAngle(Attr) ((Attr)->Angle)
#define schAttrSetAngle(_Attr, value) ((_Attr)->Angle = (value))
#define schAttrGetAlignment(Attr) ((Attr)->Alignment)
#define schAttrSetAlignment(_Attr, value) ((_Attr)->Alignment = (value))
#define schAttrGetSize(Attr) ((Attr)->Size)
#define schAttrSetSize(_Attr, value) ((_Attr)->Size = (value))
#define schAttrGetColor(Attr) ((Attr)->Color)
#define schAttrSetColor(_Attr, value) ((_Attr)->Color = (value))
#define schAttrShowValue(Attr) ((Attr)->ShowValue)
#define schAttrSetShowValue(_Attr, value) ((_Attr)->ShowValue = (value))
#define schAttrShowName(Attr) ((Attr)->ShowName)
#define schAttrSetShowName(_Attr, value) ((_Attr)->ShowName = (value))
#define schAttrVisible(Attr) ((Attr)->Visible)
#define schAttrSetVisible(_Attr, value) ((_Attr)->Visible = (value))
#define schAttrGetValue(Attr) ((Attr)->Value)
#define schAttrSetValue(_Attr, value) ((_Attr)->Value = (value))
#define schAttrGetY(Attr) ((Attr)->Y)
#define schAttrSetY(_Attr, value) ((_Attr)->Y = (value))
#define schAttrGetX(Attr) ((Attr)->X)
#define schAttrSetX(_Attr, value) ((_Attr)->X = (value))
#define schAttrGetName(Attr) ((Attr)->Name)
#define schAttrSetName(_Attr, value) ((_Attr)->Name = (value))
#define schAttrGetNextAttr(_Attr) ((_Attr)->NextAttr)
#define schAttrSetNextAttr(_Attr, value) ((_Attr)->NextAttr = (value))

/*----------------------------------------------------------------------------
  Conn methods.
----------------------------------------------------------------------------*/
#define schConnNull ((schConn)(NULL))
extern schConn _schConnAlloc(void);
#define _schConnNextFree(Conn) (*(schConn *)(void *)(Conn))
#define schConnAlloc() (_schFirstFreeConn == schConnNull? _schConnAlloc() : (\
    _schTempConn = _schFirstFreeConn,\
    _schFirstFreeConn = _schConnNextFree(_schFirstFreeConn),\
    memset((void *)_schTempConn, 0, sizeof(struct _schConn)),\
    _schTempConn))
#define schConnFree(Conn) (_schConnNextFree(Conn) = _schFirstFreeConn, _schFirstFreeConn = (Conn))
#define schConnGetDestructorHook() (schConnDestructorHook)
#define schConnSetDestructorHook(func) (schConnDestructorHook = (func))
extern void schConnDestroy(schConn Conn);
#define schConnGetY(Conn) ((Conn)->Y)
#define schConnSetY(_Conn, value) ((_Conn)->Y = (value))
#define schConnGetX(Conn) ((Conn)->X)
#define schConnSetX(_Conn, value) ((_Conn)->X = (value))
#define schConnGetRWire(_Conn) ((_Conn)->RWire)
#define schConnSetRWire(_Conn, value) ((_Conn)->RWire = (value))
#define schConnGetnextWireRConn(Conn) ((Conn)->nextWireRConn)
#define schConnSetnextWireRConn(Conn, nextConn) ((Conn)->nextWireRConn = (nextConn))
#define schConnGetLWire(_Conn) ((_Conn)->LWire)
#define schConnSetLWire(_Conn, value) ((_Conn)->LWire = (value))
#define schConnGetnextWireLConn(Conn) ((Conn)->nextWireLConn)
#define schConnSetnextWireLConn(Conn, nextConn) ((Conn)->nextWireLConn = (nextConn))

/*----------------------------------------------------------------------------
  Graphic methods.
----------------------------------------------------------------------------*/
#define schGraphicNull ((schGraphic)(NULL))
extern schGraphic _schGraphicAlloc(void);
#define _schGraphicNextFree(Graphic) (*(schGraphic *)(void *)(Graphic))
#define schGraphicAlloc() (_schFirstFreeGraphic == schGraphicNull? _schGraphicAlloc() : (\
    _schTempGraphic = _schFirstFreeGraphic,\
    _schFirstFreeGraphic = _schGraphicNextFree(_schFirstFreeGraphic),\
    memset((void *)_schTempGraphic, 0, sizeof(struct _schGraphic)),\
    _schTempGraphic))
#define schGraphicFree(Graphic) (_schGraphicNextFree(Graphic) = _schFirstFreeGraphic, _schFirstFreeGraphic = (Graphic))
#define schGraphicGetDestructorHook() (schGraphicDestructorHook)
#define schGraphicSetDestructorHook(func) (schGraphicDestructorHook = (func))
extern void schGraphicDestroy(schGraphic Graphic);
#define schGraphicGetfirstLine(Graphic) ((Graphic)->firstLine)
#define schGraphicSetfirstLine(Graphic, _Line) ((Graphic)->firstLine = (_Line))
extern void schGraphicInsertLine(schGraphic Graphic, schLine _Line);
extern void schGraphicRemoveLine(schGraphic Graphic, schLine _Line);
#define schForeachGraphicLine(Graphic, _Line) \
    for(_Line = schGraphicGetfirstLine(Graphic); _Line != schLineNull; \
        _Line = schLineGetnextGraphicLine(_Line))
#define schEndForeachGraphicLine
#define schSafeForeachGraphicLine(Graphic, _Line) {\
    schLine _nextLine;\
    for(_Line = schGraphicGetfirstLine(Graphic); _Line != schLineNull; \
        _Line = _nextLine) {\
        _nextLine = schLineGetnextGraphicLine(_Line);
#define schEndSafeForeachGraphicLine }}
#define schGraphicGetfirstRect(Graphic) ((Graphic)->firstRect)
#define schGraphicSetfirstRect(Graphic, _Rect) ((Graphic)->firstRect = (_Rect))
extern void schGraphicInsertRect(schGraphic Graphic, schRect _Rect);
extern void schGraphicRemoveRect(schGraphic Graphic, schRect _Rect);
#define schForeachGraphicRect(Graphic, _Rect) \
    for(_Rect = schGraphicGetfirstRect(Graphic); _Rect != schRectNull; \
        _Rect = schRectGetnextGraphicRect(_Rect))
#define schEndForeachGraphicRect
#define schSafeForeachGraphicRect(Graphic, _Rect) {\
    schRect _nextRect;\
    for(_Rect = schGraphicGetfirstRect(Graphic); _Rect != schRectNull; \
        _Rect = _nextRect) {\
        _nextRect = schRectGetnextGraphicRect(_Rect);
#define schEndSafeForeachGraphicRect }}
#define schGraphicGetfirstCircle(Graphic) ((Graphic)->firstCircle)
#define schGraphicSetfirstCircle(Graphic, _Circle) ((Graphic)->firstCircle = (_Circle))
extern void schGraphicInsertCircle(schGraphic Graphic, schCircle _Circle);
extern void schGraphicRemoveCircle(schGraphic Graphic, schCircle _Circle);
#define schForeachGraphicCircle(Graphic, _Circle) \
    for(_Circle = schGraphicGetfirstCircle(Graphic); _Circle != schCircleNull; \
        _Circle = schCircleGetnextGraphicCircle(_Circle))
#define schEndForeachGraphicCircle
#define schSafeForeachGraphicCircle(Graphic, _Circle) {\
    schCircle _nextCircle;\
    for(_Circle = schGraphicGetfirstCircle(Graphic); _Circle != schCircleNull; \
        _Circle = _nextCircle) {\
        _nextCircle = schCircleGetnextGraphicCircle(_Circle);
#define schEndSafeForeachGraphicCircle }}
#define schGraphicGetfirstArc(Graphic) ((Graphic)->firstArc)
#define schGraphicSetfirstArc(Graphic, _Arc) ((Graphic)->firstArc = (_Arc))
extern void schGraphicInsertArc(schGraphic Graphic, schArc _Arc);
extern void schGraphicRemoveArc(schGraphic Graphic, schArc _Arc);
#define schForeachGraphicArc(Graphic, _Arc) \
    for(_Arc = schGraphicGetfirstArc(Graphic); _Arc != schArcNull; \
        _Arc = schArcGetnextGraphicArc(_Arc))
#define schEndForeachGraphicArc
#define schSafeForeachGraphicArc(Graphic, _Arc) {\
    schArc _nextArc;\
    for(_Arc = schGraphicGetfirstArc(Graphic); _Arc != schArcNull; \
        _Arc = _nextArc) {\
        _nextArc = schArcGetnextGraphicArc(_Arc);
#define schEndSafeForeachGraphicArc }}

/*----------------------------------------------------------------------------
  Line methods.
----------------------------------------------------------------------------*/
#define schLineNull ((schLine)(NULL))
extern schLine _schLineAlloc(void);
#define _schLineNextFree(Line) (*(schLine *)(void *)(Line))
#define schLineAlloc() (_schFirstFreeLine == schLineNull? _schLineAlloc() : (\
    _schTempLine = _schFirstFreeLine,\
    _schFirstFreeLine = _schLineNextFree(_schFirstFreeLine),\
    memset((void *)_schTempLine, 0, sizeof(struct _schLine)),\
    _schTempLine))
#define schLineFree(Line) (_schLineNextFree(Line) = _schFirstFreeLine, _schFirstFreeLine = (Line))
#define schLineGetDestructorHook() (schLineDestructorHook)
#define schLineSetDestructorHook(func) (schLineDestructorHook = (func))
extern void schLineDestroy(schLine Line);
#define schLineGetColor(Line) ((Line)->Color)
#define schLineSetColor(_Line, value) ((_Line)->Color = (value))
#define schLineGetY2(Line) ((Line)->Y2)
#define schLineSetY2(_Line, value) ((_Line)->Y2 = (value))
#define schLineGetX2(Line) ((Line)->X2)
#define schLineSetX2(_Line, value) ((_Line)->X2 = (value))
#define schLineGetY1(Line) ((Line)->Y1)
#define schLineSetY1(_Line, value) ((_Line)->Y1 = (value))
#define schLineGetX1(Line) ((Line)->X1)
#define schLineSetX1(_Line, value) ((_Line)->X1 = (value))
#define schLineGetGraphic(_Line) ((_Line)->Graphic)
#define schLineSetGraphic(_Line, value) ((_Line)->Graphic = (value))
#define schLineGetnextGraphicLine(Line) ((Line)->nextGraphicLine)
#define schLineSetnextGraphicLine(Line, nextLine) ((Line)->nextGraphicLine = (nextLine))

/*----------------------------------------------------------------------------
  Rect methods.
----------------------------------------------------------------------------*/
#define schRectNull ((schRect)(NULL))
extern schRect _schRectAlloc(void);
#define _schRectNextFree(Rect) (*(schRect *)(void *)(Rect))
#define schRectAlloc() (_schFirstFreeRect == schRectNull? _schRectAlloc() : (\
    _schTempRect = _schFirstFreeRect,\
    _schFirstFreeRect = _schRectNextFree(_schFirstFreeRect),\
    memset((void *)_schTempRect, 0, sizeof(struct _schRect)),\
    _schTempRect))
#define schRectFree(Rect) (_schRectNextFree(Rect) = _schFirstFreeRect, _schFirstFreeRect = (Rect))
#define schRectGetDestructorHook() (schRectDestructorHook)
#define schRectSetDestructorHook(func) (schRectDestructorHook = (func))
extern void schRectDestroy(schRect Rect);
#define schRectGetColor(Rect) ((Rect)->Color)
#define schRectSetColor(_Rect, value) ((_Rect)->Color = (value))
#define schRectGetBox(Rect) ((Rect)->Box)
#define schRectSetBox(_Rect, value) ((_Rect)->Box = (value))
#define schRectGetGraphic(_Rect) ((_Rect)->Graphic)
#define schRectSetGraphic(_Rect, value) ((_Rect)->Graphic = (value))
#define schRectGetnextGraphicRect(Rect) ((Rect)->nextGraphicRect)
#define schRectSetnextGraphicRect(Rect, nextRect) ((Rect)->nextGraphicRect = (nextRect))

/*----------------------------------------------------------------------------
  Circle methods.
----------------------------------------------------------------------------*/
#define schCircleNull ((schCircle)(NULL))
extern schCircle _schCircleAlloc(void);
#define _schCircleNextFree(Circle) (*(schCircle *)(void *)(Circle))
#define schCircleAlloc() (_schFirstFreeCircle == schCircleNull? _schCircleAlloc() : (\
    _schTempCircle = _schFirstFreeCircle,\
    _schFirstFreeCircle = _schCircleNextFree(_schFirstFreeCircle),\
    memset((void *)_schTempCircle, 0, sizeof(struct _schCircle)),\
    _schTempCircle))
#define schCircleFree(Circle) (_schCircleNextFree(Circle) = _schFirstFreeCircle, _schFirstFreeCircle = (Circle))
#define schCircleGetDestructorHook() (schCircleDestructorHook)
#define schCircleSetDestructorHook(func) (schCircleDestructorHook = (func))
extern void schCircleDestroy(schCircle Circle);
#define schCircleGetColor(Circle) ((Circle)->Color)
#define schCircleSetColor(_Circle, value) ((_Circle)->Color = (value))
#define schCircleGetRadius(Circle) ((Circle)->Radius)
#define schCircleSetRadius(_Circle, value) ((_Circle)->Radius = (value))
#define schCircleGetY(Circle) ((Circle)->Y)
#define schCircleSetY(_Circle, value) ((_Circle)->Y = (value))
#define schCircleGetX(Circle) ((Circle)->X)
#define schCircleSetX(_Circle, value) ((_Circle)->X = (value))
#define schCircleGetGraphic(_Circle) ((_Circle)->Graphic)
#define schCircleSetGraphic(_Circle, value) ((_Circle)->Graphic = (value))
#define schCircleGetnextGraphicCircle(Circle) ((Circle)->nextGraphicCircle)
#define schCircleSetnextGraphicCircle(Circle, nextCircle) ((Circle)->nextGraphicCircle = (nextCircle))

/*----------------------------------------------------------------------------
  Arc methods.
----------------------------------------------------------------------------*/
#define schArcNull ((schArc)(NULL))
extern schArc _schArcAlloc(void);
#define _schArcNextFree(Arc) (*(schArc *)(void *)(Arc))
#define schArcAlloc() (_schFirstFreeArc == schArcNull? _schArcAlloc() : (\
    _schTempArc = _schFirstFreeArc,\
    _schFirstFreeArc = _schArcNextFree(_schFirstFreeArc),\
    memset((void *)_schTempArc, 0, sizeof(struct _schArc)),\
    _schTempArc))
#define schArcFree(Arc) (_schArcNextFree(Arc) = _schFirstFreeArc, _schFirstFreeArc = (Arc))
#define schArcGetDestructorHook() (schArcDestructorHook)
#define schArcSetDestructorHook(func) (schArcDestructorHook = (func))
extern void schArcDestroy(schArc Arc);
#define schArcGetColor(Arc) ((Arc)->Color)
#define schArcSetColor(_Arc, value) ((_Arc)->Color = (value))
#define schArcGetEndAngle(Arc) ((Arc)->EndAngle)
#define schArcSetEndAngle(_Arc, value) ((_Arc)->EndAngle = (value))
#define schArcGetStartAngle(Arc) ((Arc)->StartAngle)
#define schArcSetStartAngle(_Arc, value) ((_Arc)->StartAngle = (value))
#define schArcGetRadius(Arc) ((Arc)->Radius)
#define schArcSetRadius(_Arc, value) ((_Arc)->Radius = (value))
#define schArcGetY(Arc) ((Arc)->Y)
#define schArcSetY(_Arc, value) ((_Arc)->Y = (value))
#define schArcGetX(Arc) ((Arc)->X)
#define schArcSetX(_Arc, value) ((_Arc)->X = (value))
#define schArcGetGraphic(_Arc) ((_Arc)->Graphic)
#define schArcSetGraphic(_Arc, value) ((_Arc)->Graphic = (value))
#define schArcGetnextGraphicArc(Arc) ((Arc)->nextGraphicArc)
#define schArcSetnextGraphicArc(Arc, nextArc) ((Arc)->nextGraphicArc = (nextArc))

/*----------------------------------------------------------------------------
  Signal methods.
----------------------------------------------------------------------------*/
#define schSignalNull ((schSignal)(NULL))
extern schSignal _schSignalAlloc(void);
#define _schSignalNextFree(Signal) (*(schSignal *)(void *)(Signal))
#define schSignalAlloc() (_schFirstFreeSignal == schSignalNull? _schSignalAlloc() : (\
    _schTempSignal = _schFirstFreeSignal,\
    _schFirstFreeSignal = _schSignalNextFree(_schFirstFreeSignal),\
    memset((void *)_schTempSignal, 0, sizeof(struct _schSignal)),\
    _schTempSignal))
#define schSignalFree(Signal) (_schSignalNextFree(Signal) = _schFirstFreeSignal, _schFirstFreeSignal = (Signal))
#define schSignalGetDestructorHook() (schSignalDestructorHook)
#define schSignalSetDestructorHook(func) (schSignalDestructorHook = (func))
extern void schSignalDestroy(schSignal Signal);
#define schSignalGetSym(Signal) ((Signal)->Sym)
#define schSignalSetSym(_Signal, value) ((_Signal)->Sym = (value))
#define schSignalGetNet(_Signal) ((_Signal)->Net)
#define schSignalSetNet(_Signal, value) ((_Signal)->Net = (value))
#define schSignalGetnextNetSignal(Signal) ((Signal)->nextNetSignal)
#define schSignalSetnextNetSignal(Signal, nextSignal) ((Signal)->nextNetSignal = (nextSignal))
#define schSignalGetBus(_Signal) ((_Signal)->Bus)
#define schSignalSetBus(_Signal, value) ((_Signal)->Bus = (value))

/*----------------------------------------------------------------------------
  Bus methods.
----------------------------------------------------------------------------*/
#define schBusNull ((schBus)(NULL))
extern schBus _schBusAlloc(void);
#define _schBusNextFree(Bus) (*(schBus *)(void *)(Bus))
#define schBusAlloc() (_schFirstFreeBus == schBusNull? _schBusAlloc() : (\
    _schTempBus = _schFirstFreeBus,\
    _schFirstFreeBus = _schBusNextFree(_schFirstFreeBus),\
    memset((void *)_schTempBus, 0, sizeof(struct _schBus)),\
    _schTempBus))
#define schBusFree(Bus) (_schBusNextFree(Bus) = _schFirstFreeBus, _schFirstFreeBus = (Bus))
#define schBusGetDestructorHook() (schBusDestructorHook)
#define schBusSetDestructorHook(func) (schBusDestructorHook = (func))
extern void schBusDestroy(schBus Bus);
#define schBusGetLeft(Bus) ((Bus)->Left)
#define schBusSetLeft(_Bus, value) ((_Bus)->Left = (value))
#define schBusGetRight(Bus) ((Bus)->Right)
#define schBusSetRight(_Bus, value) ((_Bus)->Right = (value))
#define schBusGetDbBus(Bus) ((Bus)->DbBus)
#define schBusSetDbBus(_Bus, value) ((_Bus)->DbBus = (value))
#define schBusGetSchem(_Bus) ((_Bus)->Schem)
#define schBusSetSchem(_Bus, value) ((_Bus)->Schem = (value))
#define schBusGetSym(Bus) ((Bus)->h.Sym)
#define schBusSetSym(Bus, _sym) ((Bus)->h.Sym = (_sym))
#define schBusGetnextSchemBus(Bus) ((schBus)((Bus)->h.nEntry))

/*----------------------------------------------------------------------------
  Col methods.
----------------------------------------------------------------------------*/
#define schColNull ((schCol)(NULL))
extern schCol schColAlloc(void);
#define _schColNextFree(Col) (*(schCol *)(void *)(Col))
extern void schColFree(schCol Col);
#define schColGetDestructorHook() (schColDestructorHook)
#define schColSetDestructorHook(func) (schColDestructorHook = (func))
extern void schColDestroy(schCol Col);
#define schColGetiComp(Col, x) ((Col)->Comps[x])
#define schColSetiComp(Col, x, _Comp) ((Col)->Comps[x] = (_Comp))
#define schColGetnumComps(Col) ((Col)->numComps)
#define schColSetusedComps(Col, numComps) ((Col)->usedComps = (numComps))
#define schColGetusedComps(Col) ((Col)->usedComps)
#define schColGetComps(Col) ((Col)->Comps)
#define schColAllocComps(Col, num) ((Col)->usedComps = (num), \
(Col)->numComps = (num), (Col)->Comps = mtNewA(schComp, (num)))
#define schColReallocComps(Col, num) ((Col)->numComps = (num), (Col)->Comps = mtResizeArray((Col)->Comps, (num)*sizeof(schComp)))
#define schColFreeComps(Col) (mtDelete((Col)->Comps), (Col)->Comps = NULL, \
    (Col)->numComps = 0, (Col)->usedComps = 0)
extern void schColInsertComp(schCol Col, schComp _Comp);
extern void schColRemoveComp(schCol Col, schComp _Comp);
#define schForeachColComp(Col, _Comp) { \
    U32 _xComp; \
    for(_xComp = 0; _xComp < schColGetusedComps(Col); \
        _xComp++) { \
        _Comp = schColGetiComp(Col, _xComp);
#define schEndForeachColComp }}
#define schSafeForeachColComp(Col, _Comp) { \
    U32 _xComp; \
    for(_xComp = 0; _xComp < schColGetusedComps(Col); \
        schColGetiComp(Col, _xComp) == _Comp &&_xComp++) { \
        _Comp = schColGetiComp(Col, _xComp); \
        if(_Comp != schCompNull) {
#define schEndSafeForeachColComp }}}
#define schColGetSchem(_Col) ((_Col)->Schem)
#define schColSetSchem(_Col, value) ((_Col)->Schem = (value))
#define schColGetSchemIndex(Col) ((Col)->SchemIndex)
#define schColSetSchemIndex(Col, value) ((Col)->SchemIndex = (value))

/*----------------------------------------------------------------------------
  Package level routines.
----------------------------------------------------------------------------*/
extern void schDDRStart(void);
extern void schDDRStop(void);

/*----------------------------------------------------------------------------
  Structure definitions.
----------------------------------------------------------------------------*/
struct _schNet {
    struct _utEntry h;
    schWire firstWire;
    schPin firstPin;
    schPin lastPin;
    schSignal firstSignal;
    schSignal lastSignal;
    schAttr Attr;
    schSchem Schem;
    bool NameGenerated:2;
    bool Bus:2;
};

struct _schComp {
    struct _utEntry h;
    U32 Right;
    U32 Left;
    dbInst Inst;
    utSym SymbolName;
    U16 Angle;
    S32 Y;
    S32 X;
    schPin firstPin;
    schPin lastPin;
    schAttr Attr;
    schSchem Schem;
    schSymbol Symbol;
    schComp nextSymbolComp;
    schComp prevSymbolComp;
    schMpin Mpin;
    schCol Col;
    U32 ColIndex;
    bool Array:2;
    bool Mirror:2;
    bool Selectable:2;
};

struct _schMpin {
    struct _utEntry h;
    dbMbus Mbus;
    dbMport Mport;
    U32 Right;
    U32 Left;
    S32 Y2;
    S32 X2;
    U32 Sequence;
    S32 Y;
    S32 X;
    dbMportType Type;
    schComp FlagComp;
    schAttr Attr;
    schSymbol Symbol;
    bool Bus:2;
};

struct _schSchem {
    struct _utEntry h;
    utSym Path;
    struct _utHtbl Comps;
    struct _utHtbl Nets;
    schWire firstWire;
    schWire lastWire;
    struct _utHtbl Buss;
    schAttr Attr;
    schCol *Cols;
    U32 numCols, usedCols;
    schRoot Root;
    schSymbol Symbol;
    bool Written:2;
};

struct _schRoot {
    struct _utHtbl Schems;
    struct _utHtbl Symbols;
};

struct _schSymbol {
    struct _utEntry h;
    utSym Path;
    utSym Device;
    dbNetlist Netlist;
    dbNetlistType Type;
    schSchem Schem;
    struct _utHtbl Mpins;
    schComp firstComp;
    schComp lastComp;
    schAttr Attr;
    schGraphic Graphic;
    schRoot Root;
};

struct _schPin {
    dbPort Port;
    S32 Y;
    S32 X;
    schComp Comp;
    schPin nextCompPin;
    schMpin Mpin;
    schNet Net;
    schPin nextNetPin;
};

struct _schWire {
    S32 Y2;
    S32 X2;
    S32 Y1;
    S32 X1;
    schConn firstRConn;
    schConn firstLConn;
    schAttr Attr;
    schNet Net;
    schWire nextNetWire;
    schSchem Schem;
    schWire nextSchemWire;
    schWire prevSchemWire;
    bool Bus:2;
};

struct _schAttr {
    U8 Angle;
    U8 Alignment;
    U8 Size;
    U8 Color;
    utSym Value;
    S32 Y;
    S32 X;
    utSym Name;
    schAttr NextAttr;
    bool ShowValue:2;
    bool ShowName:2;
    bool Visible:2;
};

struct _schConn {
    S32 Y;
    S32 X;
    schWire RWire;
    schConn nextWireRConn;
    schWire LWire;
    schConn nextWireLConn;
};

struct _schGraphic {
    schLine firstLine;
    schRect firstRect;
    schCircle firstCircle;
    schArc firstArc;
};

struct _schLine {
    U8 Color;
    S32 Y2;
    S32 X2;
    S32 Y1;
    S32 X1;
    schGraphic Graphic;
    schLine nextGraphicLine;
};

struct _schRect {
    U8 Color;
    utBox Box;
    schGraphic Graphic;
    schRect nextGraphicRect;
};

struct _schCircle {
    U8 Color;
    U32 Radius;
    S32 Y;
    S32 X;
    schGraphic Graphic;
    schCircle nextGraphicCircle;
};

struct _schArc {
    U8 Color;
    U8 EndAngle;
    U8 StartAngle;
    U32 Radius;
    S32 Y;
    S32 X;
    schGraphic Graphic;
    schArc nextGraphicArc;
};

struct _schSignal {
    utSym Sym;
    schNet Net;
    schSignal nextNetSignal;
    schBus Bus;
};

struct _schBus {
    struct _utEntry h;
    U32 Left;
    U32 Right;
    dbBus DbBus;
    schSchem Schem;
};

struct _schCol {
    schComp *Comps;
    U32 numComps, usedComps;
    schSchem Schem;
    U32 SchemIndex;
};

extern void (*schNetDestructorHook)(schNet);
extern schNet _schFirstFreeNet, _schTempNet;
extern void (*schCompDestructorHook)(schComp);
extern schComp _schFirstFreeComp, _schTempComp;
extern void (*schMpinDestructorHook)(schMpin);
extern schMpin _schFirstFreeMpin, _schTempMpin;
extern void (*schSchemDestructorHook)(schSchem);
extern schSchem _schFirstFreeSchem, _schTempSchem;
extern void (*schRootDestructorHook)(schRoot);
extern schRoot _schFirstFreeRoot, _schTempRoot;
extern void (*schSymbolDestructorHook)(schSymbol);
extern schSymbol _schFirstFreeSymbol, _schTempSymbol;
extern void (*schPinDestructorHook)(schPin);
extern schPin _schFirstFreePin, _schTempPin;
extern void (*schWireDestructorHook)(schWire);
extern schWire _schFirstFreeWire, _schTempWire;
extern void (*schAttrDestructorHook)(schAttr);
extern schAttr _schFirstFreeAttr, _schTempAttr;
extern void (*schConnDestructorHook)(schConn);
extern schConn _schFirstFreeConn, _schTempConn;
extern void (*schGraphicDestructorHook)(schGraphic);
extern schGraphic _schFirstFreeGraphic, _schTempGraphic;
extern void (*schLineDestructorHook)(schLine);
extern schLine _schFirstFreeLine, _schTempLine;
extern void (*schRectDestructorHook)(schRect);
extern schRect _schFirstFreeRect, _schTempRect;
extern void (*schCircleDestructorHook)(schCircle);
extern schCircle _schFirstFreeCircle, _schTempCircle;
extern void (*schArcDestructorHook)(schArc);
extern schArc _schFirstFreeArc, _schTempArc;
extern void (*schSignalDestructorHook)(schSignal);
extern schSignal _schFirstFreeSignal, _schTempSignal;
extern void (*schBusDestructorHook)(schBus);
extern schBus _schFirstFreeBus, _schTempBus;
extern void (*schColDestructorHook)(schCol);
extern schCol _schFirstFreeCol, _schTempCol;

#endif
