/*
 * Copyright (C) 2003 ViASIC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */

/*========================================================================
   Module header file for: ut
========================================================================*/

#ifndef UTHTBL_H
#define UTHTBL_H

/* Object handle definitions */
typedef struct _utHtbl *utHtblRef;
typedef struct _utEntry *utEntryRef;
typedef struct _utArray *utArrayRef;
typedef struct _utDynarray *utDynarrayRef;

/*--------------------------------------------------------------------------------------------------
   Object: Htbl
--------------------------------------------------------------------------------------------------*/
struct _utHtbl {
    U32 NumEntries, NameCounter;
    utEntryRef fEntry, lEntry;
    utArrayRef fArray;
    U16 SizeExp;
    utHtblRef _nHtbl;
    bool _used:1;
};

#define ut0Htbl 0
#define uttHtblExists(Htbl) ((Htbl) != ut0Htbl)
#define utgHtblSizeExp(Htbl) ((Htbl)->SizeExp)
#define utrHtblSizeExp(Htbl, _SizeExp) (utgHtblSizeExp(Htbl) = (_SizeExp))
#define utgHtblNumEntries(Htbl) ((Htbl)->NumEntries)
#define utgHtblNameCounter(Htbl) ((Htbl)->NameCounter)
#define utrHtblNumEntries(Htbl, _NumEntries) (utgHtblNumEntries(Htbl) = (_NumEntries))
#define utfHtblArray(Htbl) ((Htbl)->fArray)
#define utrfHtblArray(Htbl, _Array) (utfHtblArray(Htbl) = (_Array))
#define _utnHtbl(Htbl) ((Htbl)->_nHtbl)
#define _uttHtblUsed(Htbl) ((Htbl)->_used)
#define utfHtblEntry(Htbl) ((Htbl)->fEntry)
#define utlHtblEntry(Htbl) ((Htbl)->lEntry)
extern utHtblRef utfHtbl(void);
extern utHtblRef utnHtbl(utHtblRef Htbl);
extern void utdHtbl(utHtblRef Htbl);
extern utHtblRef utcHtbl(void);
extern utHtblRef utBuildHtbl(void);
extern void utInitHtbl(utHtblRef htbl);
extern void utRipHtbl(utHtblRef htbl);
extern void utInsertHtblEntry(utHtblRef htbl, utEntryRef entry);
extern void utDeleteHtblEntry(utHtblRef htbl, utEntryRef entry);
extern void utAppendHtblEntry(utHtblRef htbl, utEntryRef entry);
extern utEntryRef utqEntryHtblSym(utHtblRef htbl, utSym sym);
extern U32 utFindInHtbl(utHtblRef htbl, utSym sym);
extern void utMungeHtblNames(utHtblRef htbl);
extern utSym utHtblMakeUniqueName(utHtblRef htbl, char *name);

/*--------------------------------------------------------------------------------------------------
   Object: Entry
--------------------------------------------------------------------------------------------------*/
struct _utEntry {
    utHtblRef oHtbl;
    utSym Sym;
    U32 Data;
    utEntryRef fEntry;
    utEntryRef pEntry, nEntry;
    utEntryRef _nEntry;
    bool _used:1;
};

#define ut0Entry 0
#define uttEntryExists(Entry) ((Entry) != ut0Entry)
#define utoHtblEntry(Entry) ((Entry)->oHtbl)
#define utroHtblEntry(Entry, Htbl) ((Entry)->oHtbl = (Htbl))
#define utgEntrySym(Entry) ((Entry)->Sym)
#define utrEntrySym(Entry, _Sym) (utgEntrySym(Entry) = (_Sym))
#define utgEntryData(Entry) ((Entry)->Data)
#define utrEntryData(Entry, _Data) ((Entry)->Data = (_Data))
#define utfEntryEntry(Entry) ((Entry)->fEntry)
#define utrfEntryEntry(Entry, _Entry) (utfEntryEntry(Entry) = (_Entry))
#define _utnEntry(Entry) ((Entry)->_nEntry)
#define _uttEntryUsed(Entry) ((Entry)->_used)
#define utnHtblEntry(Entry) ((Entry)->nEntry)
#define utpHtblEntry(Entry) ((Entry)->pEntry)
extern utEntryRef utfEntry(void);
extern utEntryRef utnEntry(utEntryRef Entry);
extern void utdEntry(utEntryRef Entry);
extern utEntryRef utcEntry(void);
extern utEntryRef utBuildEntry(U32 data);
extern void utRipEntry(utEntryRef entry);

/*--------------------------------------------------------------------------------------------------
   Object: Array
--------------------------------------------------------------------------------------------------*/
struct _utArray {
    U32 _fxEntry;
    U32 _sEntry;
    utArrayRef _nArray;
    bool _used:1;
};

#define ut0Array 0
#define uttArrayExists(Array) ((Array) != ut0Array)
#define _utfxArrayEntry(Array) ((Array)->_fxEntry)
#define utxArrayEntry(Array, x) (utAssert((x) < utsArrayEntry(Array)),\
        _utHtblRoot.ArrayEntrys[_utfxArrayEntry(Array) + (x)])
#define utsArrayEntry(Array) ((Array)->_sEntry)
#define utrxArrayEntry(Array, x, _Entry) (utAssert((x) < utsArrayEntry(Array)),\
        _utHtblRoot.ArrayEntrys[_utfxArrayEntry(Array) + (x)] = (_Entry))
#define _utnArray(Array) ((Array)->_nArray)
#define _uttArrayUsed(Array) ((Array)->_used)
extern utArrayRef utfArray(void);
extern utArrayRef utnArray(utArrayRef Array);
extern void utdArray(utArrayRef Array);
extern utArrayRef utcArray(U32 sEntry);

/*--------------------------------------------------------------------------------------------------
   Object: Dynarray
--------------------------------------------------------------------------------------------------*/
struct _utDynarray {
    U32 Size;
    U16 ValueSize;
    void *Values;
    U32 NumUsed;
    utDynarrayRef _nDynarray;
    U32 _index;
    bool _used:1;
};

#define ut0Dynarray 0
#define uttDynarrayExists(Dynarray) ((Dynarray) != ut0Dynarray)
#define utgDynarraySize(Dynarray) ((Dynarray)->Size)
#define utrDynarraySize(Dynarray, _Size) (utgDynarraySize(Dynarray) = (_Size))
#define utgDynarrayValueSize(Dynarray) ((Dynarray)->ValueSize)
#define utrDynarrayValueSize(Dynarray, _ValueSize) (utgDynarrayValueSize(Dynarray) = (_ValueSize))
#define utgDynarrayValues(Dynarray, type) ((type *)((Dynarray)->Values))
#define utgDynarrayValues_(Dynarray) ((Dynarray)->Values)
#define utrDynarrayValues(Dynarray, type, _Values) ((Dynarray)->Values = (_Values))
#define utgDynarrayNumUsed(Dynarray) ((Dynarray)->NumUsed)
#define utrDynarrayNumUsed(Dynarray, _NumUsed) (utgDynarrayNumUsed(Dynarray) = (_NumUsed))
#define _utnDynarray(Dynarray) ((Dynarray)->_nDynarray)
#define _uttDynarrayUsed(Dynarray) ((Dynarray)->_used)
#define utgxDynarray(Dynarray) ((Dynarray)->_index)
#define utxDynarray(x) (_utHtblRoot.DynarrayArray[x])
#ifdef DDR_DEBUG
#define utxDynarrayValue(Dynarray, type, x) (utAssert((U32)(x) < utgDynarraySize( \
    Dynarray)), ((type *)((Dynarray)->Values))[x])
#define utrxDynarrayValue(Dynarray, type, x, Value) (utAssert((U32)(x) < \
    utgDynarraySize(Dynarray)), ((type *)(Dynarray)->Values)[x] = (Value))
#else
#define utxDynarrayValue(Dynarray, type, x) (((type *)((Dynarray)->Values))[x])
#define utrxDynarrayValue(Dynarray, type, x, Value) (((type *)(Dynarray)->Values)[x] = (Value))
#endif
extern utDynarrayRef utfDynarray(void);
extern utDynarrayRef utnDynarray(utDynarrayRef Dynarray);
extern void utdDynarray(utDynarrayRef Dynarray);
extern utDynarrayRef utBuildDynarray_(U16 valueSize);
#define utBuildDynarray(type) utBuildDynarray_(sizeof(type))
extern void utResizeDynarray(utDynarrayRef dynarray, U32 newSize);
#define utaDynarrayValue(dynarray, type, value) \
    (utgDynarrayNumUsed(dynarray) == utgDynarraySize(dynarray) && \
    (utResizeDynarray((dynarray), 1 + utgDynarraySize(dynarray) + (utgDynarraySize(dynarray) >> 1)), true),\
    utrxDynarrayValue(dynarray, type, utgDynarrayNumUsed(dynarray), (value)),\
    utrDynarrayNumUsed(dynarray, utgDynarrayNumUsed(dynarray) + 1))
#define utForEachDynarrayValue(dynarray, type, value) \
{\
    U32 _xValue;\
    for(_xValue = 0; _xValue < utgDynarrayNumUsed(dynarray); _xValue++) {\
        (value) = utxDynarrayValue((dynarray), type, _xValue);
#define utEndDynarrayValue }}

/*--------------------------------------------------------------------------------------------------
   Root structure
--------------------------------------------------------------------------------------------------*/
struct _utHtblRootType {
    bool inUse;
    utBlockRef HtblHeap;
    utHtblRef fFreeHtbl, fUsedHtbl, lUsedHtbl;
    U32 sUnusedHtbl, sHtbl;
    utBlockRef EntryHeap;
    utEntryRef fFreeEntry, fUsedEntry, lUsedEntry;
    U32 sUnusedEntry, sEntry;
    utBlockRef ArrayHeap;
    utArrayRef fFreeArray, fUsedArray, lUsedArray;
    U32 sUnusedArray, sArray;
    utEntryRef *ArrayEntrys;
    U32 sArrayEntry, mArrayEntry;
    utBlockRef DynarrayHeap;
    utDynarrayRef fFreeDynarray, fUsedDynarray, lUsedDynarray;
    U32 sUnusedDynarray, sDynarray;
    utDynarrayRef *DynarrayArray;
};

extern struct _utHtblRootType _utHtblRoot;

#define uttRootInUse() (_utHtblRoot.inUse)
#define _utfFreeHtbl() (_utHtblRoot.fFreeHtbl)
#define _utfUsedHtbl() (_utHtblRoot.fUsedHtbl)
#define _utlUsedHtbl() (_utHtblRoot.lUsedHtbl)
#define _utsUnusedHtbl() (_utHtblRoot.sUnusedHtbl)
#define utsHtbl() (_utHtblRoot.sHtbl)
#define _utfFreeEntry() (_utHtblRoot.fFreeEntry)
#define _utfUsedEntry() (_utHtblRoot.fUsedEntry)
#define _utlUsedEntry() (_utHtblRoot.lUsedEntry)
#define _utsUnusedEntry() (_utHtblRoot.sUnusedEntry)
#define utsEntry() (_utHtblRoot.sEntry)
#define _utfFreeArray() (_utHtblRoot.fFreeArray)
#define _utfUsedArray() (_utHtblRoot.fUsedArray)
#define _utlUsedArray() (_utHtblRoot.lUsedArray)
#define _utsUnusedArray() (_utHtblRoot.sUnusedArray)
#define utsArray() (_utHtblRoot.sArray)
#define _utsArrayEntry() (_utHtblRoot.sArrayEntry)
#define _utmArrayEntry() (_utHtblRoot.mArrayEntry)
#define _utfFreeDynarray() (_utHtblRoot.fFreeDynarray)
#define _utfUsedDynarray() (_utHtblRoot.fUsedDynarray)
#define _utlUsedDynarray() (_utHtblRoot.lUsedDynarray)
#define _utsUnusedDynarray() (_utHtblRoot.sUnusedDynarray)
#define utsDynarray() (_utHtblRoot.sDynarray)

extern void utHtblInit(void);
extern void utHtblClose(void);

#endif
