/*
 ============================================================================
 Name		: BenchmarkDocument.cpp
 Author	  : Konstantin Knizhnik
 Copyright   : GigaBASE is freeware
 Description : CBenchmarkDocument implementation
 ============================================================================
 */

// INCLUDE FILES
#include "BenchmarkAppUi.h"
#include "BenchmarkDocument.h"

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CBenchmarkDocument::NewL()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CBenchmarkDocument* CBenchmarkDocument::NewL(CEikApplication& aApp)
	{
	CBenchmarkDocument* self = NewLC(aApp);
	CleanupStack::Pop(self);
	return self;
	}

// -----------------------------------------------------------------------------
// CBenchmarkDocument::NewLC()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CBenchmarkDocument* CBenchmarkDocument::NewLC(CEikApplication& aApp)
	{
	CBenchmarkDocument* self = new (ELeave) CBenchmarkDocument(aApp);

	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
	}

// -----------------------------------------------------------------------------
// CBenchmarkDocument::ConstructL()
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//
void CBenchmarkDocument::ConstructL()
	{
	// No implementation required
	}

// -----------------------------------------------------------------------------
// CBenchmarkDocument::CBenchmarkDocument()
// C++ default constructor can NOT contain any code, that might leave.
// -----------------------------------------------------------------------------
//
CBenchmarkDocument::CBenchmarkDocument(CEikApplication& aApp) :
	CAknDocument(aApp)
	{
	// No implementation required
	}

// ---------------------------------------------------------------------------
// CBenchmarkDocument::~CBenchmarkDocument()
// Destructor.
// ---------------------------------------------------------------------------
//
CBenchmarkDocument::~CBenchmarkDocument()
	{
	// No implementation required
	}

// ---------------------------------------------------------------------------
// CBenchmarkDocument::CreateAppUiL()
// Constructs CreateAppUi.
// ---------------------------------------------------------------------------
//
CEikAppUi* CBenchmarkDocument::CreateAppUiL()
	{
	// Create the application user interface, and return a pointer to it;
	// the framework takes ownership of this object
	return new (ELeave) CBenchmarkAppUi;
	}

// End of File
