/*
 CEdit 
Copyright (C) 2002 Carlos RodrÃ­guez Caminero

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
/*
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <unistd.h>
#include "cedit.h"

    // English
    /*
    static char cedit_list_of_errors [] = {"CEdit paramter is NULL","cursor out of range"};
    */
    // Spanish
static char * cedit_list_of_errors [] = {"El parÃÂ¡metro de tipo CEdit es nulo",
    "cursor fuera de rango",
    "Texto invÃÂ¡lido",
    "Pila de cursores vacia",
    "Sin memoria",
    "ParÃÂ¡metro nulo",
    "Fichero no encontrado",
    "ParÃÂ¡metro fuera de rango",
    "No hay cambios",
    "No hay ninguna selecciÃÂ³n para copiar"};

typedef struct _suggest_data suggest_data;

struct _suggest_data
{
  char *word;
  long y;
  CEdit *cedit;
};


line * cedit_new_line (CEdit *cedit, line *prev, line *next);
int cedit_del_line (CEdit *cedit, line *act);
int cedit_realloc_text (CEdit *cedit, line *lin, long lenght);
int cedit_realloc_cursors (CEdit *cedit, long lenght);
stack_undo * cedit_in_undo_redo (CEdit *cedit, stack_undo *stack, int is_undo, int advance, int mode, char *text, long size, long x, long y, line *l_line);
element_undo * cedit_del_undo_redo (element_undo *undo);
int cedit_do_undo_redo (CEdit *cedit, int cursor, int is_undo);
int cedit_delete (CEdit *cedit);
int cedit_insert_reserved_word (CEdit *cedit, char *reserved_word);
int cedit_add_change (CEdit *cedit, long x, long y, line *l_line, int type);
list_change * cedit_del_this_change (CEdit *cedit, list_change * change);

int cedit_set_flags (CEdit *cedit, line *l_line, long y);
int cedit_is_reserved_word (CEdit *cedit, line *l_line, long x);
int cedit_load_reserved_words (CEdit *cedit);

int cedit_get_first_flag (CEdit *cedit, line *l_line);
int cedit_get_last_flag (CEdit *cedit, line *l_line);
long cedit_get_first_char_pos (CEdit *cedit, line *l_line);
long cedit_get_last_char_pos (CEdit *cedit, line *l_line);

int cedit_this_char_is_in_selection (CEdit *cedit, long x, long y);
long cedit_get_selection_num_char (CEdit *cedit);

int cedit_set_tabs (CEdit *cedit, line *l_line, long y);
int cedit_real_set_tabs (CEdit *cedit, line *l_line, long y);
int cedit_real_set_absolute_tabs (CEdit *cedit, line *l_line, long y);
int cedit_is_tab_reserved_word (CEdit *cedit, line *l_line, long x);

int cedit_delete_block_flag (CEdit *cedit);
int cedit_set_format (CEdit *cedit, int cursor, line *l_line, long y);

int cedit_is_mark (char ch);

gpointer cedit_fill_db (gpointer _cedit);
void cedit_exit_fill_db (void *cedit);
void cedit_fill_initial_db (CEdit *cedit);
gint cedit_compare_db_word (gconstpointer a, gconstpointer b, gpointer user_data);

definition_db *cedit_insert_definition_word (CEdit *cedit, 
					     char *name, 
					     int type, 
					     definition_db *father, 
					     int pointer, 
					     char is_function_variable,
					     definition_db **args_father, 
					     int n_args, 
					     long n_line, 
					     char *file, 
					     long min_bound, 
					     long max_bound,
					     include_db *incl_db);
void cedit_correct_file (CEdit *cedit);

int cedit_set_flag_to_error (CEdit *cedit, line *l_line, long x,long lenght, long y);
int cedit_set_flag_to_warning (CEdit *cedit, line *l_line, long x,long lenght, long y);
int cedit_unset_flag_to_error (CEdit *cedit, line *l_line, long x,long lenght, long y);
int cedit_unset_flag_to_error2 (CEdit *cedit, line *l_line, long prev_x, long prev_y, long x, long y);
char cedit_get_next_char_correct_file (CEdit *cedit, line *temp, long x, long y);
gint caca (gpointer key, gpointer value, gpointer data);
void cedit_free_words_db (CEdit *cedit);
void cedit_search_definitions (CEdit *cedit, line *first, char *filename, include_db *incl_db);
void cedit_correct_file_recursive (CEdit *cedit, CEditCursor *cursor, int *depth);
int cedit_get_next_char_word_definition (CEdit *cedit, CEditCursor *cursor, char *ch, int *depth);
int cedit_is_normal_char (CEdit *cedit, line *l_line, long x);

int cedit_get_next_word_correct_file (CEdit *cedit, CEditCursor *cursor, char *word, int *depth);
int cedit_get_next_word_correct (CEdit *cedit, CEditCursor *cursor, char *word, int *depth);
int cedit_get_next_word (CEdit *cedit, CEditCursor *cursor, char *word, int *depth);
int cedit_get_next_define_word (CEdit *cedit, CEditCursor *cursor, char *word,int *depth); // sale si encuentra return
int cedit_get_next_variable (CEdit *cedit, CEditCursor *cursor, char *word, char *pointer, int *depth);
int cedit_get_next_variable_enum (CEdit *cedit, CEditCursor *cursor, char *word, char *pointer,int *depth);

//int cedit_get_next_function_variable (CEdit *cedit, CEditCursor *cursor, char *word, char *pointer, int *depth);
int cedit_get_next_struct_variable (CEdit *cedit, CEditCursor *cursor, char *word, char *pointer,int *depth);
int cedit_get_real_char (CEdit *cedit, CEditCursor *cursor, int *depth);
int cedit_get_next_real_char (CEdit *cedit, CEditCursor *cursor, int *depth);
int cedit_skip_space (CEdit *cedit, CEditCursor *cursor,int *depth);
void cedit_words_db_key_destroy_func (gpointer data);
void cedit_words_db_value_destroy_func (gpointer data);

definition_db *cedit_search_db_value(CEdit *cedit, char *key, long y, int depth);
definition_db *cedit_search_db_value_extend(CEdit *cedit, char *key, long y, int depth);
int cedit_insert_db_value(CEdit *cedit, char *key, definition_db *def_db, include_db *incl_db);
long cedit_search_min_boundary(CEdit *cedit, CEditCursor cursor,char is_function, int depth);
long cedit_search_max_boundary(CEdit *cedit, CEditCursor cursor,char is_function, int depth);
definition_db *cedit_new_struct(CEdit *cedit, CEditCursor *cursor, char *word, int *depth, char *filename, include_db *incl_db);
definition_db *cedit_new_enum(CEdit *cedit, CEditCursor *cursor, char *word, int *depth, char *filename, include_db *incl_db);

line *cedit_load_include_file (CEdit *cedit, char *name, include_db *incl_db);
void cedit_free_include_file(CEdit *cedit, line *first);

line *cedit_insert_include_db(CEdit *cedit, char *word, include_db *incl_db);
int cedit_free_include_db(CEdit *cedit);

int cedit_file_exist(char *text);

int cedit_start_include_db(CEdit *cedit);
int cedit_del_include_db_not_readed(CEdit *cedit);

int cedit_get_include_file(CEdit *cedit, CEditCursor *cursor,char *word, int *depth); // obtengo el nombre del fichero ha incluir
int cedit_set_include_flags (CEdit *cedit, line *l_line, long y);

int cedit_new_define(CEdit *cedit, CEditCursor *cursor, char *word, int *depth, char *filename, include_db *incl_db);

definition_db *cedit_get_cursor_definition_db_recursive(CEdit *cedit, CEditCursor *cursor, int depth);
int cedit_get_last_real_word(CEdit *cedit, CEditCursor *cursor, char *word);
int cedit_get_this_real_char(CEdit *cedit, CEditCursor *cursor, char *ch, unsigned int *flag);

//definition_db *cedit_get_all_cursor_definition_db(CEdit *cedit, int n_cursor);
//definition_db *cedit_get_all_cursor_definition_db_recursive(CEdit *cedit, CEditCursor *cursor);
//definition_db *cedit_search_db_value_manual(CEdit *cedit, char *key, long y, int depth, int count);
definition_db *cedit_search_db_value_file(CEdit *cedit, char *key, long y, int depth, char *file, int no_insert_values);

int cedit_strcmp (char *a, char *b);

int cedit_insert_result_definition_db(CEdit *cedit, definition_db *def_db, result_definition_db *result);
int cedit_free_result_definition_db(CEdit *cedit, result_definition_db *result);

int cedit_search_all_suggest_db_value(CEdit *cedit, suggest_data *data, int extended);
gboolean cedit_get_all_suggested_words (gpointer _key,
					gpointer _value,
					gpointer _data);
gboolean cedit_get_all_suggested_words_extend (gpointer _key,
					       gpointer _value,
					       gpointer _data);

int cedit_get_last_real_word_position(CEdit *cedit, CEditCursor *cursor);
GTree* cedit_copy_tree(CEdit *cedit, GTree *source, GTree *dest);
gboolean cedit_copy_tree_callback (gpointer _key,
				   gpointer _value,
				   gpointer _cedit);
definition_db* cedit_copy_definition_db (CEdit *cedit, definition_db *def_db);
include_db* cedit_new_include_db(CEdit *cedit, char *word);
line *cedit_copy_lines(CEdit *cedit);
gboolean cedit_free_definitions_db_file_callback (gpointer _key,
						  gpointer _value,
						  gpointer _cedit);

int 
cedit_free_initial_db(CEdit *cedit);
int
cedit_free_definitions_db_file(CEdit *cedit, char *file);
int cedit_recursive_mark_to_readed(CEdit *cedit, include_db *incl_db);
char *cedit_get_directory(CEdit *cedit, char *orig);


    // --------------------------------------------------------------------------------------------------
    //                                      Inicializaciones y Destrucciones
    // --------------------------------------------------------------------------------------------------
    // ---------------------------
    //  Inicializa un CEdit nuevo
    // ---------------------------
CEdit *
cedit_init (void)
{
    CEdit *cedit;
    
    cedit = NULL;
    cedit =(CEdit *) malloc (sizeof (CEdit));  // nuevo cedit
    if (cedit == NULL) return NULL;
    
    if (!g_thread_supported())
      g_thread_init(NULL);
    /*    i_ret = pthread_create (&cedit -> fill_db, NULL, (void *) cedit_fill_db, cedit);
    if (i_ret)
    {
        g_free (cedit -> cursors);
        g_free (cedit);
        return NULL;
            //}
	    }*/
    cedit->mutex_text=g_mutex_new();

    cedit -> first = cedit_new_line (cedit,NULL, NULL);    // primera linea
        // cursores
    cedit -> cursors =(array_cursor *) malloc (CURSOR_BLOCK *sizeof (array_cursor));
    if (cedit -> cursors == NULL)
    {
        free (cedit);
        return NULL;
    }
    cedit -> num_cursors = 0;
    if (cedit_new_cursor (cedit) ==- 1)
    {
        free (cedit -> cursors);
        free (cedit);
        return NULL;
    }
    
    cedit -> first_stack_cursor = NULL;       // pila de cursores
    
    cedit_load_reserved_words (cedit);
    
        // otras inicializaciones
    cedit -> insert = true;
    cedit -> num_line = 0;
    cedit -> first_change = NULL;
    cedit -> last_change = NULL;
    cedit -> min_change_y =- 1;
    cedit -> min_change_x =- 1;
    cedit -> num_changes = 0;
    cedit -> temp. move_line = NULL;
    cedit -> temp. move_x = 0;
    cedit -> temp. move_y = 0;
    cedit -> temp. move_tabs = 0;
    cedit->filename=NULL;
    
    cedit -> fast_color = 0;
    cedit -> fast_autoident = 0;
    cedit->format=1;
    cedit->continuous_correction=0;
    cedit->correction=1;
    
    cedit -> something_has_changed = 0;
    
    cedit -> joined_undo = 0;
    
    cedit -> sel_ini_y =- 1;
    cedit -> sel_end_y =- 1;
    
    cedit -> block_x =- 1;
    cedit -> block_y =- 1;
    cedit -> block_line = NULL;
    
    cedit -> freeze = 0;
    cedit->mutex=0;
    cedit -> exit=0;

    cedit->list_include_db=NULL;
    cedit->list_include_path=NULL;

    cedit->result_def_db=NULL;
    cedit->result_suggest_def_db=NULL;
    
    cedit->fill_db=g_thread_create(cedit_fill_db, cedit, TRUE, NULL);
    g_thread_set_priority(cedit->fill_db,G_THREAD_PRIORITY_LOW);

  

    return cedit;
}


    // -------------------
    //  Destruye un cedit
    // -------------------
int
cedit_exit (CEdit *cedit)
{
    cedit_delete (cedit);
    return 0;
}

    // -----------------
    //  Limpia un cedit
    // -----------------
CEdit *
cedit_clear (CEdit *cedit)
{
    int ret;
    int fast_color;
    int fast_autoident;
    int format;
    int continuous_correction;
    int correction;
    include_path *inc_path;
    
    fast_color = cedit_get_fast_color(cedit); // mantengo el valor
    fast_autoident = cedit_get_fast_autoident(cedit);
    format = cedit_get_format(cedit);
    continuous_correction=cedit_get_continuous_correction(cedit);
    correction=cedit_get_correction(cedit);

    // guardo la lista de path incluidos
    inc_path=cedit->list_include_path;
    // le hago creer que no hay ninguno para que no los borre
    cedit->list_include_path=NULL;
    
    ret = cedit_delete (cedit);
    if (ret < 0) return NULL;
    
    cedit = cedit_init ();
    /*
    cedit_insert_include_path(cedit, "/usr/include/");
    cedit_insert_include_path(cedit, "/usr/local/include/");
    cedit_insert_include_path(cedit, "/usr/lib/gcc-lib/i386-redhat-linux/2.96/include/");
    cedit_insert_include_path(cedit, "/opt/garnome/include/gtk-2.0/");
    cedit_insert_include_path(cedit, "/opt/garnome/lib/gtk-2.0/include/");
    cedit_insert_include_path(cedit, "/opt/garnome/include/atk-1.0/");
    cedit_insert_include_path(cedit, "/opt/garnome/include/pango-1.0/");
    cedit_insert_include_path(cedit, "/usr/X11R6/include/");
    cedit_insert_include_path(cedit, "/opt/garnome/include/");
    cedit_insert_include_path(cedit, "/opt/garnome/include/freetype2/");
    cedit_insert_include_path(cedit, "/opt/garnome/include/glib-2.0/");
    cedit_insert_include_path(cedit, "/opt/garnome/lib/glib-2.0/include/");
    */

    // restauro los include path
    cedit->list_include_path=inc_path;

    if (cedit_get_fast_color(cedit)!=fast_color)
      cedit_toggle_fast_color(cedit);
    if (cedit_get_fast_autoident(cedit)!=fast_autoident)
      cedit_toggle_fast_autoident(cedit);
    if (cedit_get_format(cedit)!=format)
      cedit_toggle_format(cedit);
    if (cedit_get_continuous_correction(cedit)!=continuous_correction)
      cedit_toggle_continuous_correction(cedit);

    return cedit;
}

    // ----------------
    //  Borra un cedit
    // ----------------
int
cedit_delete (CEdit *cedit)
{
    line *temp;
    line *prev;
    stack_cursor *s_cursor;
    int cont;
    
    if (cedit == NULL) return - 1;

    if (cedit->correction==1) // si esta activado, lo desactivo
      {
	cedit -> exit = 1;
	g_thread_join (cedit -> fill_db);    
	cedit -> exit = 0;
      }
    
    
        // libero las lineas
    temp = cedit -> first;
    prev = cedit -> first;
    while (temp != NULL)
    {
        temp = prev -> next;
        cedit_del_line (cedit, prev);
        prev = temp;
    }
    
        // libero el array de cursores, pero antes, libero los undo's y redo's que tienen
    
    for (cont = 0; cont < cedit -> num_cursors; cont ++)
    {
        while (cedit -> cursors [cont] . undo -> first_undo != NULL)
            cedit -> cursors [cont] . undo -> first_undo = cedit_del_undo_redo (cedit -> cursors [cont] . undo -> first_undo);
        while (cedit -> cursors [cont] . undo -> first_redo != NULL)
            cedit -> cursors [cont] . undo -> first_redo = cedit_del_undo_redo (cedit -> cursors [cont] . undo -> first_redo);
        free (cedit -> cursors [cont] . undo);
    }
    
    free (cedit -> cursors);
    
        // libero la pila de cursores, por si queda alguno
    s_cursor = cedit -> first_stack_cursor;
    while (s_cursor != NULL)
    {
        cedit -> first_stack_cursor = cedit -> first_stack_cursor -> next;
        free (s_cursor);
        s_cursor = cedit -> first_stack_cursor;
    }
    
    for (cont = 0; cont < cedit -> num_reserved_words; cont ++)
      free (cedit -> reserved_words [cont]);

    cedit_free_include_path(cedit);
    cedit_free_include_db(cedit);
    
    free (cedit -> reserved_words);
    //    pthread_cancel (cedit -> fill_db);
    //    pthread_join (cedit -> fill_db, NULL);
    free (cedit);
    return 0;
}

    // ----------------------------
    //  Devuelve el texto de error
    // ----------------------------
char*
cedit_get_error (CEdit *cedit)
{
    if (cedit == NULL)
        return cedit_list_of_errors [0];
    cedit -> error = cedit_list_of_errors [cedit -> nError];
    return cedit -> error;
}

    // ------------------------------------------
    //  Congela el editor para que no varie, asi
    //   evito que analize cuando redibujo
    //   evitando cambios indeseados
    // ------------------------------------------
int
cedit_freeze (CEdit *cedit)
{
    int prev;
    
    if (cedit == NULL) return - 1;
    prev = cedit -> freeze;
    cedit -> freeze = 1;
    return prev;
}

    // ------------------------------------------
    //  Descongela el editor para que no varie, asi
    //   evito que analize cuando redibujo
    //   evitando cambios indeseados
    // ------------------------------------------
int
cedit_unfreeze (CEdit *cedit)
{
    int prev;
    prev = cedit -> freeze;
    cedit -> freeze = 0;
    return prev;
}

    // --------------------------------------------------------------------------------------------------
    //                                          EdiciÃÂ³n bÃÂ¡sica
    // --------------------------------------------------------------------------------------------------


    // -----------------------------
    //  Anyade una letra a un cedit
    // -----------------------------
int
cedit_cput_char (CEdit *cedit, int cursor, char ch)
{
    int cont;
    line *n_line;
    
    int lenght;
    char charact;
    int ret, ret2;
    char mutex;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    
        // no se permiten ni tabs ni espacios al principio
    if (ch == 9)
      ch=' ';
    //        return 0; // tab

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    
    ret = 0;
    ret2 = 0;
    cedit -> something_has_changed = 1;  // para que busque flags
    cedit_delete_block_flag (cedit);
    
        // corta el texto seleccionado si lo hay (no hara nada si no lo hay)
    cedit_ccut_text (cedit, cursor);
    
        // si el cursor esta fuera del texto hacia la derecha
    if (cedit -> cursors [cursor] . l_line -> num_char < cedit -> cursors [cursor] . x)
    {
            // reservo memoria
        if (cedit_realloc_text (cedit, cedit -> cursors [cursor] . l_line, (cedit -> cursors [cursor] . x + 1)) < 0)
        {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
            return - 1;
        }
            // anyado espacios
        for (cont = cedit -> cursors [cursor] . l_line -> num_char; cont < cedit -> cursors [cursor] . x; cont ++)
        {
            cedit -> cursors [cursor] . l_line -> text [cont] =' ';
            cedit -> cursors [cursor] . l_line -> flags [cont] = 0;
        }
            // pongo el numero de caracteres adecuado
        cedit -> cursors [cursor] . l_line -> num_char = cedit -> cursors [cursor] . x;
    }
    
    if (ch == 10)        // si es un return
    {
            // creo la nueva linea
        
            // ha habido un cambio
        cedit_add_change (cedit, cedit -> cursors [cursor] . x, cedit -> cursors [cursor] . y, cedit -> cursors [cursor] . l_line, cedit_change_to_end_of_text);
        
        n_line = cedit_new_line (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . l_line -> next);
        if (n_line == NULL)
        {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
            return - 1;
        }
        
        ret = 0;
        if (cedit -> cursors [cursor] . l_line -> num_char > cedit -> cursors [cursor] . x) // si hay algo que mover de texto
        {
            lenght = cedit -> cursors [cursor] . l_line -> num_char - cedit -> cursors [cursor] . x;
                // escribo todo lo que hay despues del cursor en la nueva linea
            if (cedit_realloc_text (cedit, n_line, lenght) >= 0)
            {
                for (cont = 0; cont < lenght; cont ++)
                {
                    n_line -> text [cont] = cedit -> cursors [cursor] . l_line -> text [cont + cedit -> cursors [cursor] . x];
                    n_line -> flags [cont] = 0; //cedit->cursors[cursor].l_line->flags[cont+cedit->cursors[cursor].x];
                }
                
                    // numero de caracteres
                cedit -> cursors [cursor] . l_line -> num_char = cedit -> cursors [cursor] . x;
                n_line -> num_char = lenght;
            }
            else
                ret =- 1;
            
                // reduzco el tamanyo de la linea actual
            
            ret2 = ret;
            ret = cedit_realloc_text (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . l_line -> num_char);
            if (ret < 0) ret2 =- 1;
            
                //         n_line->text[0]='a';
                //         n_line->num_char=1;
        }
        
        
        
        cedit -> cursors [cursor] . l_line = n_line;
        cedit -> cursors [cursor] . x = 0;
        cedit -> cursors [cursor] . y ++;
        
        cedit -> num_line ++;
        
            // undo o redo
        cedit -> cursors [cursor] . undo = cedit_in_undo_redo (cedit,
            cedit -> cursors [cursor] . undo,
            cedit -> cursors [cursor] . undo_or_redo,
            false,
            cedit_backspace,
            "\n",
            1,
            cedit -> cursors [cursor] . x,
            cedit -> cursors [cursor] . y,
            cedit -> cursors [cursor] . l_line);
        
        cedit -> something_has_changed = 1;  // para que busque flags
        cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line -> prev, cedit -> cursors [cursor] . y - 1);  // la linea anterior
        cedit -> something_has_changed = 1;  // para que busque flags
        cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);          // y la actual
        
        cedit -> something_has_changed = 1;  // para que busque flags
        cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line -> prev, cedit -> cursors [cursor] . y - 1);  // y ahora la autoidentacion
        cedit -> something_has_changed = 1;  // para que busque flags
        cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
        cedit -> something_has_changed = 1;  // para que corrija la linea
        
        cedit_set_format (cedit, cursor, cedit -> cursors [cursor] . l_line -> prev, cedit -> cursors [cursor] . y - 1);  // y ahora la autoidentacion
        cedit -> something_has_changed = 1;  // para que busque flags
        
    }
    else if (cedit -> insert) // insertar
    {
        if (cedit_realloc_text (cedit, cedit -> cursors [cursor] . l_line, (cedit -> cursors [cursor] . l_line -> num_char) + 1) < 0)     // hago espacio
        {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
            return - 1;
        }
        for (cont = cedit -> cursors [cursor] . l_line -> num_char - 1; cont >= cedit -> cursors [cursor] . x; cont --)     // desplazo las letras
        {
            cedit -> cursors [cursor] . l_line -> text [cont + 1] = cedit -> cursors [cursor] . l_line -> text [cont];
            cedit -> cursors [cursor] . l_line -> flags [cont + 1] = cedit -> cursors [cursor] . l_line -> flags [cont];
        }
        
            // ha habido un cambio
        cedit_add_change (cedit, cedit -> cursors [cursor] . x, cedit -> cursors [cursor] . y, cedit -> cursors [cursor] . l_line, cedit_change_to_end_of_line);
        
        cedit -> cursors [cursor] . l_line -> text [cedit -> cursors [cursor] . x] = ch;                           // anyado la letra
        cedit -> cursors [cursor] . l_line -> flags [cedit -> cursors [cursor] . x] = 0;
        cedit -> cursors [cursor] . x ++;
        cedit -> cursors [cursor] . l_line -> num_char ++;
        
            // undo o redo
        cedit -> cursors [cursor] . undo = cedit_in_undo_redo (cedit,
            cedit -> cursors [cursor] . undo,
            cedit -> cursors [cursor] . undo_or_redo,
            false,
            cedit_backspace,
            & ch,
            1,
            cedit -> cursors [cursor] . x,
            cedit -> cursors [cursor] . y,
            cedit -> cursors [cursor] . l_line);
        if (cedit -> fast_color == 0)
            cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
        
        cedit -> something_has_changed = 1;  // para que busque flags
        if (cedit -> fast_autoident == 0)
            cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
        cedit -> something_has_changed = 1;  // para que busque flags
        
    }
    else // reemplazar
    {
      // si estoy al borde del texto
      if (cedit -> cursors [cursor] . x == cedit -> cursors [cursor] . l_line -> num_char)
        {
	  charact =' ';
	  cedit -> cursors [cursor] . l_line -> num_char ++;
	  if (cedit_realloc_text (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . l_line -> num_char) < 0)     // hago espacio
            {
	      if (mutex==1)
		{
		  g_mutex_unlock (cedit -> mutex_text);    // desbloqueamos
		  cedit->mutex=0;
		}
	      return - 1;
            }
	}
      else
	charact = cedit -> cursors [cursor] . l_line -> text [cedit -> cursors [cursor] . x];
	  
      cedit -> cursors [cursor] . undo = cedit_in_undo_redo (cedit,
							     cedit -> cursors [cursor] . undo,
							     cedit -> cursors [cursor] . undo_or_redo,
							     false,
							     cedit_replace,
							     & charact,
							     1,
							     cedit -> cursors [cursor] . x,
							     cedit -> cursors [cursor] . y,
							     cedit -> cursors [cursor] . l_line);
      
      // ha habido un cambio
      cedit_add_change (cedit, cedit -> cursors [cursor] . x, cedit -> cursors [cursor] . y, cedit -> cursors [cursor] . l_line, cedit_change_this_char);
      
      cedit -> cursors [cursor] . l_line -> text [cedit -> cursors [cursor] . x] = ch;                           // anyado la letra
      cedit -> cursors [cursor] . l_line -> flags [cedit -> cursors [cursor] . x] = 0;
      cedit -> cursors [cursor] . x ++;
      
      if (cedit -> fast_color == 0)
	cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
      
      cedit -> something_has_changed = 1;  // para que busque flags
      if (cedit -> fast_autoident == 0)
	cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
      cedit -> something_has_changed = 1;  // para que busque
      
      //      cursors[cursor].l_line->num_char++;
      //}
    }
    //   cur.l_line->text[1]='a';
    if (mutex==1)
      {
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }
    return ret;
}


    // -------------------------------------
    //  Borra una letra siguiente del cedit
    // -------------------------------------
int
cedit_cdel_char (CEdit *cedit, int cursor)
{
    int cont;
    long x, y;
    line *lin;
    char ch;
    char mutex;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    
    cedit_delete_block_flag (cedit);
    
        // corta el texto seleccionado si lo hay (no hara nada si no lo hay)
    if (cedit_ccut_text (cedit, cursor) > 0) 
      {
	if (mutex==1)
	  {      
	    g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	    cedit->mutex=0;
	  }

	return 0;
      }
    
        //  cedit_del_selection(cedit);
    cedit -> something_has_changed = 1;  // para que busque flags
    
    x = cedit -> cursors [cursor] . x;
    y = cedit -> cursors [cursor] . y;
    lin = cedit -> cursors [cursor] . l_line;
    
        // si queda algun caracter por borrar lo borro
    if (x < lin -> num_char)
    {
        ch = lin -> text [x];
        
        for (cont = x; cont < lin -> num_char - 1; cont ++)
        {
            lin -> text [cont] = lin -> text [cont + 1];
            lin -> flags [cont] = lin -> flags [cont + 1];
        }
        lin -> num_char --;
        cedit_realloc_text (cedit, lin, lin -> num_char);
        
            // undo's o redo's
        cedit -> cursors [cursor] . undo = cedit_in_undo_redo (cedit,
            cedit -> cursors [cursor] . undo,
            cedit -> cursors [cursor] . undo_or_redo,
            false,
            cedit_write_left,
            & ch,
            1,
            cedit -> cursors [cursor] . x,
            cedit -> cursors [cursor] . y,
            cedit -> cursors [cursor] . l_line);
            // ha habido un cambio
        cedit_add_change (cedit, cedit -> cursors [cursor] . x, cedit -> cursors [cursor] . y, cedit -> cursors [cursor] . l_line, cedit_change_to_end_of_line);
        if (cedit -> fast_color == 0)
            cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
        cedit -> something_has_changed = 1;  // para que busque flags
        if (cedit -> fast_autoident == 0)
            cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
        cedit -> something_has_changed = 1;  // para que busque
    }
    else if (lin -> next != NULL) // si hay alguna linea mas
    {
        
            //undo's o redo's
        cedit -> cursors [cursor] . undo = cedit_in_undo_redo (cedit,
            cedit -> cursors [cursor] . undo,
            cedit -> cursors [cursor] . undo_or_redo,
            false,
            cedit_write_left,
            "\n",
            1,
            cedit -> cursors [cursor] . x,
            cedit -> cursors [cursor] . y,
            cedit -> cursors [cursor] . l_line);
        
        
            // primero, si el cursor esta mas lejos de num_char, anyado espacios
        if (lin -> num_char < x)
        {
                // reservo memoria
            cedit_realloc_text (cedit, lin, x + 1);
                // anyado espacios
            for (cont = lin -> num_char; cont < x; cont ++)
            {
                lin -> text [cont] =' ';
                lin -> flags [cont] = 0;
                    //      if (cont>0)
                    //lin->flags[cont]=lin->flags[cont-1];
                    //      else
                    //lin->flags[cont]=cedit_get_last_flag(cedit, lin->prev);
            }
                // pongo el numero de caracteres adecuado
            lin -> num_char = x;
        }
        
        cedit_realloc_text (cedit, lin, lin -> num_char + lin -> next -> num_char);
        for (cont = 0; cont < lin -> next -> num_char; cont ++)
        {
            lin -> text [cont + x] = lin -> next -> text [cont];
            lin -> flags [cont + x] = lin -> next -> flags [cont];
        }
        
        lin -> num_char += lin -> next -> num_char;
        cedit_del_line (cedit, lin -> next);
        cedit -> num_line --;
        
            // ha habido un cambio
        cedit_add_change (cedit, cedit -> cursors [cursor] . x, cedit -> cursors [cursor] . y, cedit -> cursors [cursor] . l_line, cedit_change_to_end_of_text);
        if (cedit -> fast_color == 0)
            cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
        cedit -> something_has_changed = 1;  // para que busque flags
        if (cedit -> fast_autoident == 0)
            cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
        cedit -> something_has_changed = 1;  // para que busque
    }
    if (mutex==1)
      {      
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }
    return 0;
}

    // -------------------------
    //  Borra la letra anterior
    // -------------------------
int
cedit_cbackspace_char (CEdit *cedit, int cursor)
{
    int cont;
    long x, y;
    line *lin;
    char ch;
    char mutex;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    
    cedit_delete_block_flag (cedit);
        // corta el texto seleccionado si lo hay (no hara nada si no lo hay)
    if (cedit_ccut_text (cedit, cursor) > 0)
      {

	if (mutex==1)
	  {      
	    g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	    cedit->mutex=0;
	  }

	return 0; // si se corta, no borro ademas
        //cedit_del_selection(cedit);
      }
    
    x = cedit -> cursors [cursor] . x;
    y = cedit -> cursors [cursor] . y;
    lin = cedit -> cursors [cursor] . l_line;
    
        // si estoy fuera del texto, no hago nada, solo retrocede el cursor
    if (x > lin -> num_char)
      {
	if (mutex==1)
	  {      
	    g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	    cedit->mutex=0;
	  }
        return cedit_move_cursor_left (cedit);
      }
    
        // si queda algun caracter por borrar lo borro
    if (x > 0)
    {
        ch = lin -> text [x - 1];
        for (cont = x - 1; cont < lin -> num_char; cont ++)
        {
            lin -> text [cont] = lin -> text [cont + 1];
            lin -> flags [cont] = lin -> flags [cont + 1];
        }
        lin -> num_char --;
        cedit -> cursors [cursor] . x --;
        cedit_realloc_text (cedit, lin, lin -> num_char);
        
            // undo's o red's
        cedit -> cursors [cursor] . undo = cedit_in_undo_redo (cedit,
            cedit -> cursors [cursor] . undo,
            cedit -> cursors [cursor] . undo_or_redo,
            true,
            cedit_write,
            & ch,
            1,
            cedit -> cursors [cursor] . x,
            cedit -> cursors [cursor] . y,
            cedit -> cursors [cursor] . l_line);
        
            // ha habido un cambio
        cedit_add_change (cedit, cedit -> cursors [cursor] . x, cedit -> cursors [cursor] . y, cedit -> cursors [cursor] . l_line, cedit_change_to_end_of_line);
        cedit -> something_has_changed = 1;  // para que busque flags
        if (cedit -> fast_color == 0)
            cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
        cedit -> something_has_changed = 1;  // para que busque flags
        if (cedit -> fast_autoident == 0)
            cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
        cedit -> something_has_changed = 1;  // para que busque flags
    }
    else if (lin -> prev != NULL) // si hay alguna linea anterior
    {
        
        cedit_cmove_cursor_up (cedit, cursor);
        cedit_cmove_cursor (cedit, cursor, lin -> prev -> num_char, cedit -> cursors [cursor] . y);
        
        cedit_realloc_text (cedit, lin -> prev, lin -> num_char + lin -> prev -> num_char);
        for (cont = 0; cont < lin -> num_char; cont ++)
        {
            lin -> prev -> text [cont + lin -> prev -> num_char] = lin -> text [cont];
            lin -> prev -> flags [cont + lin -> prev -> num_char] = 0;
                //  lin->prev->flags[cont+lin->prev->num_char] = lin->flags[cont];
        }
        
        cont = lin -> prev -> num_char;
        lin -> prev -> num_char += lin -> num_char;
        cedit_del_line (cedit, lin);
        cedit -> num_line --;
        
            // undo's o red's
        cedit -> cursors [cursor] . undo = cedit_in_undo_redo (cedit,
            cedit -> cursors [cursor] . undo,
            cedit -> cursors [cursor] . undo_or_redo,
            true,
            cedit_write,
            "\n",
            1,
            cedit -> cursors [cursor] . x,
            cedit -> cursors [cursor] . y,
            cedit -> cursors [cursor] . l_line);
            // ha habido un cambio
        
        cedit -> something_has_changed = 1;  // para que busque flags
        if (cedit -> fast_color == 0)
            cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
        cedit -> something_has_changed = 1;  // para que busque flags
        if (cedit -> fast_autoident == 0)
            cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
        cedit -> something_has_changed = 1;  // para que busque flags
        cedit_add_change (cedit, cedit -> cursors [cursor] . x, cedit -> cursors [cursor] . y, cedit -> cursors [cursor] . l_line, cedit_change_to_end_of_text);
    }
    if (mutex==1)
      {      
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }
    return 0;
}

    // -------------------------------------------------------
    //  Borra todos los caracteres hasta el final de la linea
    // -------------------------------------------------------
int
cedit_cdel_until_end_of_line (CEdit *cedit, int cursor)
{
  char mutex;
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    cedit_delete_block_flag (cedit);
    cedit -> cursors [cursor] . l_line -> num_char = cedit -> cursors [cursor] . x;
    cedit_realloc_text (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . l_line -> num_char);
    if (cedit -> fast_color == 0)
        cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
    if (cedit -> fast_autoident == 0)
        cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion

	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }

    return 0;
}

    // -------------------------------------------------------
    //  Borra todos los caracteres hasta el final del fichero
    // -------------------------------------------------------
int
cedit_cdel_until_end_of_file (CEdit *cedit, int cursor)
{
    line *temp;
    line *actual;
    char mutex;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    cedit_delete_block_flag (cedit);
    cedit -> cursors [cursor] . l_line -> num_char = cedit -> cursors [cursor] . x;
    cedit_realloc_text (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . l_line -> num_char);
    temp = cedit -> cursors [cursor] . l_line -> next;
    while (temp != NULL)
    {
        actual = temp -> next;
        cedit_del_line (cedit, temp);
        temp = actual;
    }
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return 0;
}

    // -----------------------------------
    //  Escribe un trozo de texto seguido
    // -----------------------------------
int cedit_cput_text (CEdit *cedit, int cursor, char *text)
{
    int state_fast_color;
    int state_fast_autoident;
    long cont;
    int ret, ret2;
    char mutex;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (text == NULL) {
        cedit -> nError = 2;
        return - 1;
    }
    if (text =="") {
        cedit -> nError = 2;
        return - 1;
    }

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    
    ret2 = 0;
        // pongo el modo de flags por linea, que es mas rapido, igual con autoident
    state_fast_color = cedit_get_fast_color (cedit);
    state_fast_autoident = cedit_get_fast_autoident (cedit);
    if (state_fast_color == 0) // desactivado
        cedit_toggle_fast_color (cedit);
    if (state_fast_autoident == 0) // desactivado
        cedit_toggle_fast_autoident (cedit);
    
    ret = 0;
    for (cont = 0; cont < strlen (text); cont ++)
    {
        ret = cedit_cput_char (cedit, cursor, text [cont]);
        if (ret < 0) ret2 =- 1;
    }
    
    if (state_fast_color == 0) // desactivado, lo activo ahora
        cedit_toggle_fast_color (cedit);
    if (state_fast_autoident == 0) // desactivado, lo activo ahora
        cedit_toggle_fast_autoident (cedit);

	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }

    return ret2;
}



    // --------------------------------------------------------------------------------------------------
    //                                          Consultar texto
    // --------------------------------------------------------------------------------------------------

    // -----------------------------------------------------------------
    // devuelve la letra actual FIXME: hay que devolver tambien el flag
    // -----------------------------------------------------------------
int
cedit_cget_char (CEdit *cedit, int cursor)
{
  char mutex;
  int ret;
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    if (cedit -> cursors [cursor] . x == cedit -> cursors [cursor] . l_line -> num_char)
      ret=10;                         // si es la ultima letra, devuelvo un return
    else if (cedit -> cursors [cursor] . x > cedit -> cursors [cursor] . l_line -> num_char)
        ret= ' ';
    else
        ret= cedit -> cursors [cursor] . l_line -> text [cedit -> cursors [cursor] . x];
    if (mutex==1)
      {
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }
    return ret;

}

    // --------------------------------------
    //  Devuelve la siguiente letra y avanza
    // --------------------------------------
int
cedit_cget_next_char (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    cedit_cnext_char (cedit, cursor);
    return cedit_cget_char (cedit, cursor);
}

    // ----------------------------------------
    //  Devuelve la letra anterior y retrocede
    // ----------------------------------------
int
cedit_cget_prev_char (CEdit *cedit, int cursor)
{
    int character;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    cedit_cprev_char (cedit, cursor);
    character = cedit_cget_char (cedit, cursor);
    cedit_cnext_char (cedit, cursor);
    return character;
}

    // -----------------------------
    //  avanza a la siguiente letra
    // -----------------------------
int
cedit_cnext_char (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    cedit -> cursors [cursor] . x ++;
    return 0;
}

    // --------------------------------
    //  Retrocede a la siguiente letra
    // --------------------------------
int
cedit_cprev_char (CEdit *cedit, int cursor)
{
  char mutex;
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    cedit_delete_block_flag (cedit);
    cedit -> cursors [cursor] . x --;
    while (cedit -> cursors [cursor] . x < 0)
    {
        if (cedit -> cursors [cursor] . l_line -> prev == NULL)
        {
            cedit -> cursors [cursor] . x = 0;
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
            return 1;       // no hay mas lineas
        }
        cedit -> cursors [cursor] . tabs -= cedit -> cursors [cursor] . tabs;
        cedit -> cursors [cursor] . l_line = cedit -> cursors [cursor] . l_line -> prev;
        cedit -> cursors [cursor] . x = cedit -> cursors [cursor] . l_line -> num_char;
    }
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return 0;
}

    // --------------------------------
    //  Devuelve el texto de una linea
    // --------------------------------
char*
cedit_cget_line_text (CEdit *cedit, int cursor)
{
  char mutex;
    if (cedit == NULL) return NULL;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return NULL;
    }
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    cedit -> cursors [cursor] . l_line -> text [cedit -> cursors [cursor] . l_line -> num_char] ='\0';
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return cedit -> cursors [cursor] . l_line -> text;
}

    // ---------------------------------
    //  Devuelve los flags de una linea
    // ---------------------------------
int*
cedit_cget_line_flags (CEdit *cedit, int cursor)
{
  char mutex;
  long x,y;

    if (cedit == NULL) return NULL;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return NULL;
    }
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    // pongo el flag de seleccion ahora
    y=cedit->cursors[cursor].y;
    for (x=0;x<cedit->cursors[cursor].l_line->num_char;x++)
      {
	if (cedit_this_char_is_in_selection (cedit, x, y) == 1)
	  {
	    if (!(cedit->cursors[cursor].l_line->flags[x] & cedit_flag_selected))
	      cedit->cursors[cursor].l_line->flags[x]+=cedit_flag_selected;
	  }
	else
	  {
	    if (cedit->cursors[cursor].l_line->flags[x] & cedit_flag_selected)
	      cedit->cursors[cursor].l_line->flags[x]-=cedit_flag_selected;
	  }
      }
      

    cedit -> cursors [cursor] . l_line -> flags [cedit -> cursors [cursor] . l_line -> num_char] = 655535;
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return cedit -> cursors [cursor] . l_line -> flags;
}

    // -------------------------------------------
    //  Devuelve el numero de letras de una linea
    // -------------------------------------------
long
cedit_cget_line_num_char (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    return cedit -> cursors [cursor] . l_line -> num_char;
}



    // --------------------------------------------------------------------------------------------------
    //                                          Cursores
    // --------------------------------------------------------------------------------------------------
    // ----------------------------------------
    //  Mueve el cursors a la posicion deseada
    // ----------------------------------------
int
cedit_cmove_cursor (CEdit *cedit, int cursor, long x, long y)
{
    long y2;
    line *l_temp;
    long dist1;
    long dist2;
    int tabs;
    int prev;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (x < 0 || y < 0) {
        cedit -> nError = 2;
        return - 1;
    }
    
        //  if (cedit->fast_color==1 && cedit_have_change(cedit)==1)
        // si se mueve en y, miro si ha cambiado algo
    if (y != cedit -> cursors [cursor] . y)
    {
        prev = cedit -> something_has_changed;
        cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
        cedit -> something_has_changed = prev;
        cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
	cedit -> something_has_changed = prev; 
        cedit_set_format (cedit, cursor, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
    }
    
        // evito movimientos innecesarios
    if (x == cedit -> cursors [cursor] . x && y == cedit -> cursors [cursor] . y)
        return true;
    
        // distancia entre el temporal y donde quiero ir
    dist1 = cedit -> temp. move_y - y;
    if (dist1 < 0) dist1 =- dist1;
    
    dist2 = cedit -> cursors [cursor] . y - y;
    if (dist2 < 0) dist2 =- dist2;
    
        // si sale mas a cuenta, usare el temporal
    if (dist1 <= y && dist1 <= dist2 && cedit -> temp. move_line != NULL) // la dist1 solo vale si el temporal es valido
    {
        y2 = cedit -> temp. move_y;
        l_temp = cedit -> temp. move_line;
        tabs = cedit -> temp. move_tabs;
    }
    else if (dist2 <= y && dist2 <= dist1)
    {
        l_temp = cedit -> cursors [cursor] . l_line;
        y2 = cedit -> cursors [cursor] . y;
        tabs = cedit -> cursors [cursor] . tabs;
    }
    else
    {
        l_temp = cedit -> first;
        y2 = 0;
        tabs = 0;
    }
    
    if (l_temp == NULL) return 0;
    
        // recorro secuencialmente hasta encontrar la linea que busco
        // if (l_temp!=NULL)
    while (y2 < y && l_temp -> next != NULL)
    {
        y2 ++;
        l_temp = l_temp -> next;
        tabs += l_temp -> tabs;
    }
    
    if (l_temp != NULL)
        while (y2 > y && l_temp -> prev != NULL)
    {
        y2 --;
        tabs -= l_temp -> tabs;
        l_temp = l_temp -> prev;
    }
    
    
        // si no exite
    if (y2 != y)
    {
        cedit -> cursors [cursor] . x = x;
        cedit -> cursors [cursor] . y = y2;
        cedit -> cursors [cursor] . l_line = l_temp;
        cedit -> cursors [cursor] . tabs = tabs;
        return false;
    }
    
    if (l_temp -> num_char < x)
        x = l_temp -> num_char;
        // si existe guardo la posicion actual, para luego
    cedit -> temp. move_y = y;
    cedit -> temp. move_line = l_temp;
    cedit -> temp. move_tabs = tabs;
    
        // resultado final
    cedit -> cursors [cursor] . x = x;
    cedit -> cursors [cursor] . y = y;
    cedit -> cursors [cursor] . l_line = l_temp;
    cedit -> cursors [cursor] . tabs = tabs;
    return true;
}

    // ------------------------------
    //  Mueve el cursor hacia arriba
    // ------------------------------
int
cedit_cmove_cursor_up (CEdit *cedit, int cursor)
{
    int prev;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    cedit_delete_block_flag (cedit);
    
        //  if (cedit->fast_color==1 && cedit_have_change(cedit)==1)
    prev = cedit -> something_has_changed;
    cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
    cedit -> something_has_changed = prev;
    cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
    cedit -> something_has_changed = prev;  // para que busque flags
    cedit_set_format (cedit, cursor, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
    
    if (cedit -> cursors [cursor] . y > 0)
    {
        cedit -> cursors [cursor] . tabs -= cedit -> cursors [cursor] . l_line -> tabs;
        cedit -> cursors [cursor] . y --;
        cedit -> cursors [cursor] . l_line = cedit -> cursors [cursor] . l_line -> prev;
        return 0;
    }
    return 1;
}

    // -----------------------------
    //  Mueve el cursor hacia abajo
    // -----------------------------
int
cedit_cmove_cursor_down (CEdit *cedit, int cursor)
{
    int prev;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    cedit_delete_block_flag (cedit);
    
        //  if (cedit->fast_color==1 && cedit_have_change(cedit)==1)
    prev = cedit -> something_has_changed;
    cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
    cedit -> something_has_changed = prev;
    cedit_set_tabs (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
    cedit -> something_has_changed = prev;  // para que busque flags
    cedit_set_format (cedit, cursor, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);  // y ahora la autoidentacion
    
    if (cedit -> cursors [cursor] . y < cedit -> num_line)
    {
        cedit -> cursors [cursor] . y ++;
        cedit -> cursors [cursor] . l_line = cedit -> cursors [cursor] . l_line -> next;
        cedit -> cursors [cursor] . tabs += cedit -> cursors [cursor] . l_line -> tabs;
        return 0;
    }
    return 1;
}

    // ------------------------------------
    //  Mueve el cursor hacia la izquierda
    // ------------------------------------
int
cedit_cmove_cursor_left (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    
    cedit_delete_block_flag (cedit);
    if (cedit -> cursors [cursor] . x <= 0)
    {
        cedit_cmove_cursor_up (cedit, cursor);
        cedit_cmove_cursor_end_line (cedit, cursor);
        return 0;
    }
    cedit -> cursors [cursor] . x --;
    return 0;
}

    // ----------------------------------
    //  Mueve el cursor hacia la derecha
    // ----------------------------------
int
cedit_cmove_cursor_right (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
        //    if (cedit==NULL) return -1;
    cedit -> cursors [cursor] . x ++;
    return 0;
}

    // --------------------------------------
    //  Mueve el cursor al final de la linea
    // --------------------------------------
int
cedit_cmove_cursor_end_line (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
        //    if (cedit==NULL) return -1;
    cedit -> cursors [cursor] . x = cedit -> cursors [cursor] . l_line -> num_char;
    return 0;
}

    // ---------------------------------------
    //  Mueve el cursor al inicio de la linea
    // ---------------------------------------
int
cedit_cmove_cursor_home_line (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
        //    if (cedit==NULL) return -1;
    cedit -> cursors [cursor] . x = 0;
    return 0;
}

    // --------------------------------------
    //  Mueve el cursor a la siguiente linea
    // --------------------------------------
int
cedit_cnext_line (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
        //    if (cedit==NULL) return -1;
    
        //  if (cedit->fast_color==1 && cedit_have_change(cedit)==1)
    cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
    
    cedit_cmove_cursor_down (cedit, cursor);
        //  if (cedit->cursors[cursor].l_line->next==NULL) return 1;
        //  cedit->cursors[cursor].l_line=cedit->cursors[cursor].l_line->next;
        //  cedit->cursors[cursor].y++;
    cedit -> cursors [cursor] . x = 0;
    return 0;
}

    // -------------------------------------
    //  Mueve el cursor a la linea anterior
    // -------------------------------------
int
cedit_cprev_line (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
        //    if (cedit==NULL) return -1;
    
        //  if (cedit->fast_color==1 && cedit_have_change(cedit)==1)
    cedit_set_flags (cedit, cedit -> cursors [cursor] . l_line, cedit -> cursors [cursor] . y);
    
    cedit_cmove_cursor_up (cedit, cursor);
        //  if (cedit->cursors[cursor].l_line->prev==NULL) return 1;
        //  cedit->cursors[cursor].l_line=cedit->cursors[cursor].l_line->prev;
        //  cedit->cursors[cursor].y--;
    cedit -> cursors [cursor] . x = 0;
    return true;
}


    // -------------------------
    //  Guarda el cursor actual
    // -------------------------
int
cedit_cpush_cursor (CEdit *cedit, int cursor)
{
    stack_cursor *new_cursor;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
        //    if (cedit==NULL) return -1;
    new_cursor =(stack_cursor *) malloc (sizeof (stack_cursor));
    if (new_cursor == NULL)
        return - 1;
    new_cursor -> cursor_x = cedit -> cursors [cursor] . x;
    new_cursor -> cursor_y = cedit -> cursors [cursor] . y;
    new_cursor -> cursor_line = cedit -> cursors [cursor] . l_line;
    new_cursor -> cursor_tabs = cedit -> cursors [cursor] . tabs;
        // new_cursor->undo=cedit->cursors[cursor].undo;
        //new_cursor->redo=cedit->cursors[cursor].redo;
    new_cursor -> next = cedit -> first_stack_cursor;
    
    cedit -> first_stack_cursor = new_cursor;
    return 0;
}

    // ---------------------------
    //  Recupera el cursor actual
    // ---------------------------
int
cedit_cpop_cursor (CEdit *cedit, int cursor)
{
    stack_cursor *last_cursor;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (cedit -> first_stack_cursor == NULL) {
        cedit -> nError = 3;
        return - 1;
    }
    cedit -> cursors [cursor] . x = cedit -> first_stack_cursor -> cursor_x;
    cedit -> cursors [cursor] . y = cedit -> first_stack_cursor -> cursor_y;
    cedit -> cursors [cursor] . l_line = cedit -> first_stack_cursor -> cursor_line;
    cedit -> cursors [cursor] . tabs = cedit -> first_stack_cursor -> cursor_tabs;
        /*
        // libero la pila de undo's, por si queda alguno
        while(cedit->cursors[cursor].undo!=NULL)
        cedit->cursors[cursor].undo=cedit_del_undo_redo(cedit->cursors[cursor].undo);
        while(cedit->cursors[cursor].redo!=NULL)
        cedit->cursors[cursor].redo=cedit_del_undo_redo(cedit->cursors[cursor].redo);
        cedit->cursors[cursor].undo = cedit->first_stack_cursor->undo;
        cedit->cursors[cursor].redo = cedit->first_stack_cursor->redo;
        */
        // pongo que el temporal sea este
    cedit -> temp. move_y = cedit -> first_stack_cursor -> cursor_y;
    cedit -> temp. move_line = cedit -> first_stack_cursor -> cursor_line;
    cedit -> temp. move_tabs = cedit -> first_stack_cursor -> cursor_tabs;
    
    
    last_cursor = cedit -> first_stack_cursor;
    cedit -> first_stack_cursor = cedit -> first_stack_cursor -> next;
    
    free (last_cursor);
    return true;
}

    // -------------------------
    //  Copia un cursor en otro
    // -------------------------
int
cedit_copy_cursor (CEdit *cedit, int source, int dest)
{
    
    if (cedit == NULL) return - 1;
    if (source < 0 || source >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (dest < 0 || dest >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    
    cedit -> cursors [dest] . x = cedit -> cursors [source] . x;
    cedit -> cursors [dest] . y = cedit -> cursors [source] . y;
    cedit -> cursors [dest] . l_line = cedit -> cursors [source] . l_line;
    cedit -> cursors [dest] . tabs = cedit -> cursors [source] . tabs;
    return 0;
}
    // ----------------------
    //  Crea un nuevo cursor
    // ----------------------
int
cedit_new_cursor (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    if (cedit_realloc_cursors (cedit, cedit -> num_cursors + 1) != 0) {
        cedit -> nError = 4;
        return - 1;
    }
    cedit -> cursors [cedit -> num_cursors] . x = 0;
    cedit -> cursors [cedit -> num_cursors] . y = 0;
    cedit -> cursors [cedit -> num_cursors] . l_line = cedit -> first;
    cedit -> cursors [cedit -> num_cursors] . tabs = 0;
    cedit -> cursors [cedit -> num_cursors] . undo_or_redo = true;
    cedit -> cursors [cedit -> num_cursors] . undo =(stack_undo *) malloc (sizeof (stack_undo));
    if (cedit -> cursors [cedit -> num_cursors] . undo == NULL)
    {
        cedit -> nError = 4;
        return - 1;
    }
    cedit -> cursors [cedit -> num_cursors] . undo -> first_undo = NULL;
    cedit -> cursors [cedit -> num_cursors] . undo -> first_redo = NULL;
    cedit -> cursors [cedit -> num_cursors] . undo -> last_undo = NULL;
    cedit -> cursors [cedit -> num_cursors] . undo -> last_redo = NULL;
    cedit -> cursors [cedit -> num_cursors] . undo -> undo_num_char = 0;
    cedit -> cursors [cedit -> num_cursors] . undo -> redo_num_char = 0;
    cedit -> cursors [cedit -> num_cursors] . undo -> limit_undo_redo = 0;
    cedit -> num_cursors ++;
    return (cedit -> num_cursors - 1);
}

    // -----------------
    //  Borra un cursor
    // -----------------
int
cedit_del_cursor (CEdit *cedit, int cursor)
{
        //  int cont;
    if (cedit == NULL) return - 1;
        //  for (cont=cursor;cont<cedit->num_cursors;cont++)
        //  cedit->cursors[cont]=cedit->cursors[cont+1];
        //cedit->num_cursors--;
        //if (realloc_cursors(cedit, cedit->num_cursors)!=0)
        //  return -1;
    return 0;
}

    // --------------------------------------
    //  Obtiene la posicion x e y del cursor
    // --------------------------------------
int
cedit_cget_cursor (CEdit *cedit, int cursor, long *x, long *y)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    *x = cedit -> cursors [cursor] . x;
    *y = cedit -> cursors [cursor] . y;
    return 0;
}

    // ----------------------------------
    //  Obtiene la posicion x del cursor
    // ----------------------------------
long
cedit_cget_cursor_x (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    return cedit -> cursors [cursor] . x;
}

    // ----------------------------------
    //  Obtiene la posicion y del cursor
    // ----------------------------------
long
cedit_cget_cursor_y (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    return cedit -> cursors [cursor] . y;
}

    // -------------------------------------------
    //  Obtiene el numero de lineas del documento
    // -------------------------------------------
long
cedit_get_file_num_line (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    return (cedit -> num_line + 1);
}

    // ---------------------------
    //  Cambia el modo de edicion
    // ---------------------------
int
cedit_toggle_insert_mode (CEdit *cedit)
{
    int previous;
    
    if (cedit == NULL) return - 1;
    previous = cedit -> insert;
    
    if (cedit -> insert == 0) cedit -> insert = 1; else cedit -> insert = 0;
    
    return previous;
}

    // -----------------------------
    //  Devuelve el modo de edicion
    // -----------------------------
int
cedit_get_insert_status (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    return cedit -> insert;
}

    // -----------------
    //  Abre un fichero
    // -----------------
CEdit *
cedit_open_file (CEdit *cedit, char *name, cedit_progress_callback callback, void *data)
{
    FILE *fp;
    long tam, maxtam;
    char character;
    int state_fast_color;
    int state_fast_autoident;
    long undo_tam;
    char mutex;
    
    if (cedit == NULL) return NULL;
    if (name == NULL) {
        cedit -> nError = 5;
        return NULL;
    }


    fp = fopen (name, "rb");
    if (fp == NULL) {
        cedit -> nError = 6;
        return NULL;
    }
    
    cedit = cedit_clear (cedit);
    if (cedit == NULL)
        return NULL;

    // almaceno el nombre del fichero para poder saber donde ir
    // a buscar los include's
    if (cedit->filename!=NULL)
      free(cedit->filename);
    cedit->filename=strdup(name);

        // miro el tamanyo del fichero
    fseek (fp, 0, SEEK_END);
    tam = ftell (fp);
    rewind (fp);

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    
    state_fast_color = cedit_get_fast_color (cedit);
    if (state_fast_color == 0) // si esta desactivado lo activo pa ir mas rapido
        cedit_toggle_fast_color (cedit);
    state_fast_autoident = cedit_get_fast_autoident (cedit);
    if (state_fast_autoident == 0) // si esta desactivado lo activo pa ir mas rapido
        cedit_toggle_fast_autoident (cedit);
    undo_tam = cedit_cset_limit_undo_redo (cedit, 0, 0);
    maxtam = tam;
        // por cada byte
    while (tam > 0)
    {
        if (tam % 10000 == 0)
            callback (1.0 -(double) ((double) tam /(double) maxtam), data);
        
        character = fgetc (fp);
        
        cedit_cput_char (cedit, 0, character);
        tam --;
    }
    fclose (fp);
    
    if (state_fast_color == 0) // y con este lo dejo como estaba
        cedit_toggle_fast_color (cedit);
    if (state_fast_autoident == 0) // y con este lo dejo como estaba
        cedit_toggle_fast_autoident (cedit);
    cedit_cset_limit_undo_redo (cedit, 0, undo_tam);
    cedit_cmove_cursor (cedit, 0, 0, 0);
    
    callback (1.0, data);

    if (mutex==1)
      {      
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }

        //   *progress=1.0;
    return cedit;
}

    // ------------------
    //  Graba un fichero
    // ------------------
int
cedit_save_file (CEdit *cedit, char *name)
{
    FILE *fp;
    line *temp;
    long x;
    int tabs;
    int count_tabs;
    char mutex;
    
    if (cedit == NULL) return - 1;
    fp = fopen (name, "wb");
    if (fp == NULL) {
        cedit -> nError = 6;
        return - 1;
    }

    // almaceno el nombre del fichero para poder saber donde ir
    // a buscar los include's
    if (cedit->filename!=NULL)
      free(cedit->filename);
    cedit->filename=strdup(name);

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    
    temp = cedit -> first;
    x = 0;
    count_tabs = 0;

    while (temp != NULL)
    {
            // meto los tabs
        if (temp -> absolute_tabs >= 0)
            tabs = temp -> absolute_tabs;
        else
        {
            count_tabs += temp -> tabs;
            tabs = count_tabs + temp -> add_tabs;
        }
        
        if (tabs < 0) tabs = 0;
        
        for (x = 0; x < 4 *tabs; x ++)
        fputc (' ', fp);
        
        for (x = 0; x < temp -> num_char; x ++)
        fputc (temp -> text [x], fp);
        temp = temp -> next;
        if (temp != NULL)
            fputc ('\n', fp);
    }
    fclose (fp);
    if (mutex==1)
      {
	//	cedit->restart_correct_now=1;
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }
    return 0;
}

    // -------------------------------------------
    //  Indica si esta o no al final de una linea
    // -------------------------------------------
int
cedit_cend_of_line (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (cedit -> cursors [cursor] . x >= cedit -> cursors [cursor] . l_line -> num_char) return 1;
    return 0;
}

    // ----------------------------------------
    //  Indica si esta o no en la ultima linea
    // ----------------------------------------
int
cedit_clast_line (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (cedit -> cursors [cursor] . l_line -> next == NULL) return 1;
    return 0;
}

    // ----------------------------------------
    //  Indica si esta o no al final del texto
    // ----------------------------------------
int
cedit_cend_of_file (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (cedit -> cursors [cursor] . l_line -> next == NULL &&
        cedit -> cursors [cursor] . x >= cedit -> cursors [cursor] . l_line -> num_char) return 1;
    return 0;
}

    // -----------------------------------------------------
    //  Mira si hay suficiente espacio o sobra de una linea
    // -----------------------------------------------------
int
cedit_realloc_text (CEdit *cedit, line *lin, long lenght)
{
    int num_pag;
    char *temp;
    int *temp2;
    char mutex;
    
    if (lin == NULL) return - 1;
    if (lenght < 0) return - 1;
    

	  cedit->restart_correct_now=1;
    lenght ++;     // pa asegurarnos de to
    
    mutex=0;
    if (lin -> num_assigned_step *TEXT_STEP < lenght)       // si necesito mas memoria
    {
      
      if (cedit->mutex==0)
	{      
	  g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	  mutex=1;
	  cedit->mutex=1;
	}
      
        num_pag =(lenght / TEXT_STEP) + 1;                       // numero de paginas ha assignar
        temp =(char *) realloc (lin -> text, sizeof (int) *num_pag *TEXT_STEP);
        if (temp == NULL) 
	  {
	    
	    if (mutex==1)
	      {
		g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
		cedit->mutex=0;
	      }	    	  
	    
	    return - 1;
	  }
        lin -> text = temp;

        temp2 =(int *) realloc (lin -> flags, sizeof (int) *num_pag *TEXT_STEP);
        if (temp2 == NULL) 
	  {
	    
	    if (mutex==1)
	      {
		g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
		cedit->mutex=0;
	      }	
	    
	    return - 1;
	  }
        lin -> flags = temp2;
        lin -> num_assigned_step = num_pag;
	//        cedit -> restart_correct_now = 1;
    }
    
    if (mutex==1)
      {
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }
    
    return 0;
}

    // ----------------------------------------------------------
    //  Mira si hay suficiente espacio o sobra para los cursores
    // ----------------------------------------------------------
int
cedit_realloc_cursors (CEdit *cedit, long lenght)
{
    int num_block;
    array_cursor *temp;
    
    if (cedit == NULL) return - 1;
    
    lenght ++;
    
    if (cedit -> num_block_cursors *CURSOR_BLOCK < lenght)       // si necesito mas memoria
    {
        num_block =(lenght / CURSOR_BLOCK) + 1;                       // numero de paginas ha assignar
        temp =(array_cursor *) realloc (cedit -> cursors, (num_block *CURSOR_BLOCK) *sizeof (array_cursor));
        if (temp == NULL) {
            cedit -> nError = 4;
            return - 1;
        }
        cedit -> cursors = temp;
        cedit -> num_block_cursors = num_block;
    }
    return 0;
}

    // ------------------------
    //  Genera una nueva linea
    // ------------------------
line*
cedit_new_line (CEdit *cedit, line *prev, line *next)
{
    line *n_line;
    char mutex;

    if (cedit == NULL) return NULL;
    
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    n_line = NULL;
    n_line =(line *) malloc (sizeof (line));
    if (n_line == NULL)
      {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
        return NULL;
      }
    n_line -> next = next;
    n_line -> prev = prev;
    if (prev != NULL)
        prev -> next = n_line;
    if (next != NULL)
        next -> prev = n_line;
    n_line -> text = NULL;
    n_line -> flags = NULL;
    n_line -> text =(char *) malloc (sizeof (char) *TEXT_STEP);
    if (n_line -> text == NULL)
    {
        free (n_line);
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
        return NULL;
    }
    n_line -> flags =(int *) malloc (sizeof (int) *TEXT_STEP);
    if (n_line -> flags == NULL)
    {
        free (n_line -> text);
        free (n_line);
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
        return NULL;
    }
    n_line -> num_char = 0;
    n_line -> tabs = 0;
    n_line -> add_tabs = 0;
    n_line -> absolute_tabs =- 1;
    n_line -> num_assigned_step = 1;
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return n_line;
}

    // -----------------
    //  Borra una linea
    // -----------------
int
cedit_del_line (CEdit *cedit, line *act)
{
    int cont;
    char mutex;

    if (cedit == NULL) return - 1;
    if (act == NULL) {
        cedit -> nError = 5;
        return - 1;
    }

    cedit->restart_correct_now=1;
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    
    if (act -> prev != NULL)
        act -> prev -> next = act -> next;
    if (act -> next != NULL)
        act -> next -> prev = act -> prev;
    if (cedit -> first == act)
        cedit -> first = cedit -> first -> next;
    if (act -> text != NULL) free (act -> text);
    if (act -> flags != NULL) free (act -> flags);
    
        // miro si algun cursor apunta a esta linea
    for (cont = 0; cont < cedit -> num_cursors; cont ++)
    {
        if (cedit -> cursors [cont] . l_line == act) // si lo hay
        {
            if (act -> prev != NULL)  // lo muevo a la linea anterior
            {
                cedit -> cursors [cont] . l_line = cedit -> cursors [cont] . l_line -> prev;
                cedit -> cursors [cont] . y --;
            }
            else                  // y sino a la siguiente (no se puede borrar todas las lineas)
            {
                cedit -> cursors [cont] . l_line = cedit -> cursors [cont] . l_line -> next;
                cedit -> cursors [cont] . y ++;
            }
        }
    }
    
        // ahora miro si algun temporal apunta a esta linea
    if (cedit -> temp. move_line == act) // si lo ha
    {
        if (act -> prev != NULL)  // lo muevo a la linea anterior
        {
            cedit -> temp. move_line = cedit -> temp. move_line -> prev;
            cedit -> temp. move_y --;
        }
        else                  // y sino a la siguiente (no se puede borrar todas las lineas)
        {
            cedit -> temp. move_line = cedit -> temp. move_line -> next;
            cedit -> temp. move_y ++;
        }
    }
    
    
    free (act);
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return 0;
}

    // -----------------------------
    //  Borra el primer undo o redo
    // -----------------------------
element_undo*
cedit_del_undo_redo (element_undo *undo)
{
    element_undo *temp;
    
    if (undo == NULL) return NULL;  // si esta vacio, no devuelvo nada
    temp = undo;
    
    if (undo -> next == NULL)         // si no se puede avanzar, retrocedo
        undo = undo -> prev;
    else                          // sino avanzo
        undo = undo -> next;
    
    if (temp -> prev != NULL)               // mantengo las relaciones de siguiente anterior
        temp -> prev -> next = temp -> next;
    if (temp -> next != NULL)
        temp -> next -> prev = temp -> prev;
    
    if (temp -> text != NULL)
        free (temp -> text);
    free (temp);
    return undo;
}

    // --------------------------------------------------------------------------------------------------
    //                                          Undo // Redo
    // --------------------------------------------------------------------------------------------------

    // -----------------------------------------------------------------
    //  Guarda en memoria el cambio, para luego hacer el undo o el redo
    // -----------------------------------------------------------------

stack_undo*
cedit_in_undo_redo (CEdit *cedit, stack_undo *stack, int is_undo, int advance, int mode, char *text, long size, long x, long y, line *l_line)
{
    element_undo *new_stack;
    char mutex;
    
    if (stack == NULL) return NULL;
    if (cedit == NULL) return stack;
    if (text == NULL) return stack;
    if (is_undo > 1 || is_undo < 0) return stack;
    if (stack -> limit_undo_redo == 0) return stack;     // si no hay espacio, pues no pongo ninguno y ahorro tiempo
    
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

        // si no cabe el nuevo undo, borro los ultimos para hacer espacio
    if (is_undo == true) // es un undo
    {
        while (stack -> undo_num_char + size > stack -> limit_undo_redo && stack -> last_undo != NULL)
        {
            stack -> undo_num_char --; //=stack->last_undo->num_char;      // quito el numero de letras al undo
            stack -> last_undo = cedit_del_undo_redo (stack -> last_undo);                 // borro el undo
        }
    }
    else // es un redo
    {
        while (stack -> redo_num_char + size > stack -> limit_undo_redo && stack -> last_redo != NULL)
        {
            stack -> redo_num_char --; //=stack->last_redo->num_char;      // quito el numero de letras al undo
            stack -> last_redo = cedit_del_undo_redo (stack -> last_redo);                 // borro el undo
        }
    }
    
        // si hemos acabado con los undo's o redo's, mantengo la integridad del primero y el ultimo
    if (stack -> last_undo == NULL)
        stack -> first_undo = NULL;
    if (stack -> last_redo == NULL)
        stack -> first_redo = NULL;
    
    
    new_stack =(element_undo *) malloc (sizeof (element_undo));         // nuevo undo o redo
    if (new_stack == NULL)                                           // si ha habido algun error, paro
      {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
        return stack;
      }
    
    new_stack -> mode = mode;                                          //datos del undo/redo
    new_stack -> text =(char *) malloc (size);
    memcpy (new_stack -> text, text, size);
    new_stack -> join = cedit -> joined_undo;
    new_stack -> x = x;
    new_stack -> y = y;
    new_stack -> l_line = l_line;
    new_stack -> advance = advance;
    
    if (is_undo == true)  // es un undo
    {
        new_stack -> next = stack -> first_undo;                         // apuntador al siguiente y al anterior
        new_stack -> prev = NULL;
        if (stack -> first_undo != NULL)
            stack -> first_undo -> prev = new_stack;
        stack -> first_undo = new_stack;
        if (stack -> last_undo == NULL) stack -> last_undo = new_stack;    // creo el apuntador al ultimo, sino existia
        stack -> undo_num_char += size;                                // aumento el numero de caracteres del undo
    }
    else            // es un redo
    {
        new_stack -> next = stack -> first_redo;
        new_stack -> prev = NULL;
        if (stack -> first_redo != NULL)
            stack -> first_redo -> prev = new_stack;
        stack -> first_redo = new_stack;
        if (stack -> last_redo == NULL) stack -> last_redo = new_stack;    // creao el apuntador al ultimo, sino existia
        stack -> redo_num_char += size;                                // aumento el numero de caracteres del redo
    }

	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    
    return stack;
}

    // --------------
    //  Hace el undo
    // --------------
int
cedit_do_undo_redo (CEdit *cedit, int cursor, int is_undo)
{
  char mutex;
    int salir;
    long prev_x, prev_y;
    int prev_mode;
    int prev_insert;
        //  int cont;
    element_undo *elem;
        //  int prev_join_undo;
    
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (is_undo < 0 || is_undo > 1) {
        cedit -> nError = 7;
        return - 1;
    }

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    prev_insert=cedit->insert;
    cedit->insert=TRUE;
    
    if (is_undo == true)
        elem = cedit -> cursors [cursor] . undo -> first_undo;
    else
        elem = cedit -> cursors [cursor] . undo -> first_redo;
    
    
    if (elem == NULL) 
      {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }

	  cedit->insert=prev_insert;
	return - 1;
      }
    
    
        // hago 1 undo
    cedit_cmove_cursor (cedit,
        cursor,
        elem -> x,
        elem -> y);
    prev_x = elem -> x;
    prev_y = elem -> y;
    
    if (is_undo == true)
        cedit -> cursors [cursor] . undo_or_redo = false;
    else
        cedit -> cursors [cursor] . undo_or_redo = true;
    
    if (elem -> mode == cedit_backspace)           // se ha de borrar
        if (cedit_cbackspace_char (cedit, cursor) < 0)
	  {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  cedit->insert=prev_insert;
            return - 1;
	  }
    if (elem -> mode == cedit_write)
        if (cedit_cput_char (cedit, cursor, elem -> text [0]) < 0)
	  {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  cedit->insert=prev_insert;
            return - 1;
	  }
    if (elem -> mode == cedit_replace)
    {
        if (cedit_get_insert_status (cedit) == cedit_insert_on)
        {
            cedit_toggle_insert_mode (cedit);
            if (cedit_cput_char (cedit, cursor, elem -> text [0]) < 0)
	      {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  cedit->insert=prev_insert;
                return - 1;
	      }
            cedit_toggle_insert_mode (cedit);
        }
        else
            if (cedit_cput_char (cedit, cursor, elem -> text [0]) < 0)
	      {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  cedit->insert=prev_insert;
                return - 1;
	      }
        cedit_cmove_cursor_left (cedit, cursor);
    }
    if (elem -> mode == cedit_write_left)
    {
        if (cedit_cput_char (cedit, cursor, elem -> text [0]) < 0)
	  {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  cedit->insert=prev_insert;
            return - 1;
	  }
        cedit_cmove_cursor_left (cedit, cursor);
    }
    
        // elimino el undo o el redo de la pila
    if (is_undo == true)
    {
        cedit -> cursors [cursor] . undo -> first_undo = cedit_del_undo_redo (elem);
        elem = cedit -> cursors [cursor] . undo -> first_undo;
    }
    else
    {
        cedit -> cursors [cursor] . undo -> first_redo = cedit_del_undo_redo (elem);
        elem = cedit -> cursors [cursor] . undo -> first_redo;
    }
    
        // mientras sea un undo o redo de borrar y sean letras, voy haciendo mas undo's o redo's
    prev_mode=FALSE;
    if (elem == NULL)
        salir = 1;
    else
      {
        salir = 0;    
	prev_mode=elem->mode;
      }
    while (salir == 0)
    {
        if ((//elem->mode==cedit_backspace &&
	     ((elem -> text [0] >='a' && elem -> text [0] <='z') ||
	      (elem -> text [0] >='A' && elem -> text [0] <='Z'))) &&
	    (elem->mode==prev_mode) &&
            ((elem -> x == prev_x - 1 && elem -> y == prev_y) ||
	     (elem -> x == prev_x + 1 && elem -> y == prev_y) ||
	     (elem -> x == prev_x && elem -> y == prev_y)))
	  // || elem->join==1) esto ultimo pa que al hacer undo se haga por bloque (copiar y pegar)
	  {
	    /*  if (elem->join==1)
                {
                prev_join_undo=cedit->joined_undo; // lo recuerdo para no machacarlo
                cedit->joined_undo=1; // lo activo para que el redo lo haga bien (o el undo)
                }
	    */
            
            cedit_cmove_cursor (cedit,                                                       // mueve el cursor
                cursor,
                elem -> x,
                elem -> y);
            prev_x = elem -> x;
	    prev_mode=elem->mode;
            
            if (elem -> mode == cedit_backspace)           // se ha de borrar
                if (cedit_cbackspace_char (cedit, cursor) < 0)
		  {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  cedit->insert=prev_insert;
                    return - 1;
		  }
            if (elem -> mode == cedit_write)
                if (cedit_cput_char (cedit, cursor, elem -> text [0]) < 0)
		  {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  cedit->insert=prev_insert;
                    return - 1;
		  }
            if (elem -> mode == cedit_replace)
            {
                if (cedit_get_insert_status (cedit) == cedit_insert_on)
                {
                    cedit_toggle_insert_mode (cedit);
                    if (cedit_cput_char (cedit, cursor, elem -> text [0]) < 0)
		      {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  cedit->insert=prev_insert;
                        return - 1;
		      }
                    cedit_toggle_insert_mode (cedit);
                }
                else
                    if (cedit_cput_char (cedit, cursor, elem -> text [0]) < 0)
		      {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  cedit->insert=prev_insert;
                        return - 1;
		      }
                cedit_cmove_cursor_left (cedit, cursor);
            }
            if (elem -> mode == cedit_write_left)
            {
                if (cedit_cput_char (cedit, cursor, elem -> text [0]) < 0)
		  {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  cedit->insert=prev_insert;
                    return - 1;
		  }
                cedit_cmove_cursor_left (cedit, cursor);
            }
            
                /*
                // devuelvo cedit->join_undo a su valor
                if (elem->join==1)
                cedit->joined_undo=prev_join_undo;
                */
            
                // elimino el undo o el redo de la pila
            if (is_undo == true)
            {
                cedit -> cursors [cursor] . undo -> first_undo = cedit_del_undo_redo (elem);
                elem = cedit -> cursors [cursor] . undo -> first_undo;
            }
            else
            {
                cedit -> cursors [cursor] . undo -> first_redo = cedit_del_undo_redo (elem);
                elem = cedit -> cursors [cursor] . undo -> first_redo;
            }
                //cedit->cursors[cursor].undo->first_undo=cedit_del_undo_redo(cedit->cursors[cursor].undo->first_undo); // borro el undo
            
                // si ya no quedan mas salgo
            if (elem == NULL)
                salir = 1;
        }
        else
            salir = 1;
    }
    
    if (cedit -> cursors [cursor] . undo -> first_undo == NULL) // si no hay undo's
        cedit -> cursors [cursor] . undo -> last_undo = NULL;     // pues quitamos este tambien
    if (cedit -> cursors [cursor] . undo -> first_redo == NULL) // si no hay undo's
        cedit -> cursors [cursor] . undo -> last_redo = NULL;     // pues quitamos este tambien
    
    cedit -> cursors [cursor] . undo_or_redo = true;
    if (mutex==1)
      {
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }
    cedit->insert=prev_insert;
    return 0;
}

    // -----------------------
    //  Borra todos los redos
    // -----------------------
int
cedit_cdel_all_redo (CEdit *cedit, int cursor)
{
  char mutex;
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

        // borro la pila de redo's
    while (cedit -> cursors [cursor] . undo -> first_redo != NULL)
        cedit -> cursors [cursor] . undo -> first_redo = cedit_del_undo_redo (cedit -> cursors [cursor] . undo -> first_redo);

	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return 0;
}
    // -------------------
    //  Interfaz del undo
    // -------------------
int
cedit_cundo (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    return cedit_do_undo_redo (cedit, cursor, true);
}

    // -------------------
    //  Interfaz del redo
    // -------------------
int
cedit_credo (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    return cedit_do_undo_redo (cedit, cursor, false);
}

    // -----------------------------------------------------
    //  Limite de memoria que puede coger el undo o el redo
    // -----------------------------------------------------
long
cedit_cset_limit_undo_redo (CEdit *cedit, int cursor, long limit)
{
    long ret;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    
    if (limit < 0) limit = 0;
    ret = cedit -> cursors [cursor] . undo -> limit_undo_redo / 1024;
    cedit -> cursors [cursor] . undo -> limit_undo_redo = limit *1024;
    return ret;
}

    // ---------------------------------
    //  Devuelve si hay algun undo o no
    // ---------------------------------

int
cedit_chave_undo (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (cedit -> cursors [cursor] . undo -> first_undo != NULL)
        return 1;
    return 0;
}

    // ---------------------------------
    //  Devuelve si hay algun redo o no
    // ---------------------------------

int
cedit_chave_redo (CEdit *cedit, int cursor)
{
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (cedit -> cursors [cursor] . undo -> first_redo != NULL)
        return 1;
    return 0;
}



    // --------------------------------------------------------------------------------------------------
    //                                          Pila de cambios
    // --------------------------------------------------------------------------------------------------

    // ---------------------------
    //  Apila un nuevo cambio
    // -------------------------

int
cedit_add_change (CEdit *cedit, long x, long y, line *l_line, int type)
{
    list_change *new_change;
    list_change *temp_change;
    
    if (cedit == NULL) return - 1;
    if (x < 0 || y < 0 || type < 0 || type > 2 || l_line == NULL) {
        cedit -> nError = 7;
        return - 1;
    }

        // si ya hay 20 cambios, pues hago uno que sea todo y no admito mas cambios
    if (cedit -> num_changes == 20)
    {
            // vacio todos los cambios
        while (cedit -> num_changes > 0)
            cedit_del_change (cedit);
        cedit_add_change (cedit, 0, 0, cedit -> first, cedit_change_to_end_of_text); // supercambio
    }
    
    if ((cedit -> min_change_y < y ||
            (cedit -> min_change_y == y && cedit -> min_change_x < x)) &&
        cedit -> min_change_y !=- 1)
      {
    return 0;
      }
        // primero compruebo que no estoy haciendo cambios innecesarios:
    if (type == cedit_change_to_end_of_text)
    {
        temp_change = cedit -> first_change;
        while (temp_change != NULL)
        {
            if (temp_change -> y > y ||
                (temp_change -> y == y && temp_change -> x > x))
            temp_change = cedit_del_this_change (cedit, temp_change);
            if (temp_change != NULL)
                temp_change = temp_change -> next;
        }
        cedit -> min_change_y = y;
        cedit -> min_change_x = x;
    }
    else if (type == cedit_change_to_end_of_line)
    {
        temp_change = cedit -> first_change;
        while (temp_change != NULL)
        {
            if (temp_change -> y == y && temp_change -> x > x && temp_change -> type != cedit_change_to_end_of_text)
                temp_change = cedit_del_this_change (cedit, temp_change);
            if (temp_change != NULL)
                temp_change = temp_change -> next;
        }
    }
    
        // creo un nuevo elemento
    new_change = NULL;
    new_change = (list_change *) malloc (sizeof (list_change));
    if (new_change == NULL) 
      {
	return - 1;
      }
    
        // valores del nuevo elemento
    new_change -> x = x;
    new_change -> y = y;
    new_change -> l_line = l_line;
    new_change -> type = type;
    new_change -> next = cedit -> first_change;
    new_change -> prev = NULL;
    if (new_change -> next != NULL)
        new_change -> next -> prev = new_change;
    
        // punteros al primero y al ultimo
    cedit -> first_change = new_change;
    if (cedit -> last_change == NULL)
        cedit -> last_change = new_change;
    
    cedit -> num_changes ++;
    return 0;
}

    // --------------------------------------------------------------------
    //  Desapila un nuevo cambio, me dicen que cambio: funcion interna mia
    // --------------------------------------------------------------------
list_change*
cedit_del_this_change (CEdit *cedit, list_change * change)
{
    list_change *temp_change;
    
        // errores evidentes
    if (cedit == NULL || change == NULL)
        return change;
    
    temp_change = change;
    change = change -> next;
    if (temp_change -> next != NULL)
        temp_change -> next -> prev = temp_change -> prev;
    if (temp_change -> prev != NULL)
        temp_change -> prev -> next = temp_change -> next;
    if (cedit -> first_change == temp_change)
        cedit -> first_change = cedit -> first_change -> next;
    if (cedit -> last_change == temp_change)
        cedit -> last_change = cedit -> last_change -> prev;
    free (temp_change);
    
    if (cedit -> last_change == NULL)
        cedit -> min_change_y =- 1;
    
    cedit -> num_changes --;
    return change;
}

    // --------------------------
    //  Desapila un nuevo cambio
    // --------------------------
int
cedit_del_change (CEdit *cedit)
{
    list_change *temp_change;
    
        // errores evidentes
    if (cedit == NULL || cedit -> last_change == NULL)
        return - 1;
    
    temp_change = cedit -> last_change;
    cedit -> last_change = cedit -> last_change -> prev; // me voy al anterior
    if (cedit -> last_change != NULL)                // si hay anterior
        cedit -> last_change -> next = NULL;             // pongo el enlace
    if (cedit -> first_change == temp_change)        // si el primero = el que voy a borrar
        cedit -> first_change = NULL;                  // no apunta a nadie
    free (temp_change);                           // libero
    
    if (cedit -> last_change == NULL)
        cedit -> min_change_y =- 1;
    
    cedit -> num_changes --;
    return 0;
}

    // ------------------------------------------
    //  Mueve un cursor a donde apunta el cambio
    // ------------------------------------------
int
cedit_cmove_cursor_to_change (CEdit *cedit, int cursor)
{
    int ret, prev;
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    
    if (cedit -> last_change == NULL)
    {
        cedit -> nError = 8;
        return - 1;
    }
    
    prev = cedit -> something_has_changed;
    cedit -> something_has_changed = 0;
    ret = cedit_cmove_cursor (cedit, cursor, cedit -> last_change -> x, cedit -> last_change -> y);
    cedit -> something_has_changed = prev;
    return ret;
        //  cedit->cursors[cursor].x=cedit->last_change->x;
        //  cedit->cursors[cursor].y=cedit->last_change->y;
        //  cedit->cursors[cursor].l_line=cedit->last_change->l_line;
    
        //  return 0;
}

    // ------------------------------
    //  Elimina cambios innecesarios
    // ------------------------------
int
cedit_prepare_to_change (CEdit *cedit)
{
    list_change *temp_change;
    long min_x, min_y;
    line *l_line;
    
    if (cedit == NULL) return - 1;
    
        // hay demasiados pequeÃÂ±os cambios, mejor 1 de cedit_change_to_end_of_text
    if (cedit -> num_changes > 10)
    {
            // busca la y,x minima
        temp_change = cedit -> first_change;
        min_x = temp_change -> x;
        min_y = temp_change -> y;
        l_line = temp_change -> l_line;
        temp_change = temp_change -> next;
        
        while (temp_change != NULL)
        {
            if ((temp_change -> y < min_y) ||
                (temp_change -> y == min_y && temp_change -> x < min_x))
            {
                min_x = temp_change -> x;
                min_y = temp_change -> y;
                l_line = temp_change -> l_line;
            }
            temp_change = temp_change -> next;
        }
        
            // borro todos los cambios, solo me voy a quedar con 1
        while (cedit -> num_changes > 0)
            cedit_del_change (cedit);
        
        cedit_add_change (cedit, min_x, min_y, l_line, cedit_change_to_end_of_text);
        return 1;
    }
    return 0;
}

    // -----------------------------------------------
    //  Devuelve si hay algun cambio, neg->no pos->si
    // -----------------------------------------------
int
cedit_have_change (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    
    if (cedit -> last_change == NULL) return - 1;
    return cedit -> num_changes;
}

    // ------------------
    //  Devuelve el tipo
    // ------------------
int
cedit_get_type_change (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    return cedit -> last_change -> type;
}



    // --------------------------------------------------------------------------------------------------
    //                                          Flags
    // --------------------------------------------------------------------------------------------------

    // --------------------------------------
    //  Pone los flags de una linea completa
    // --------------------------------------
int
cedit_set_flags (CEdit *cedit, line *l_line, long y)
{
  char mutex;
    unsigned int comment, line_comment, text, apostrophe_text, macro, reserved_word, number, character, mark, error, warning;  // posibles flags
    
    int last_flag;
    int temp_flag;
    int first_flag;
    int cont;
    int count, count2;
    int num_reserved_word;
    int num_text;
    int num_apostrophe_text;
    int num_comment;
    int last_char_pos;
    int exit_cond;
    line *prev_line, *next_line;
    
    if (cedit == NULL) return - 1;
    if (l_line == NULL)
    {
        cedit -> nError = 5;
        return - 1;
    }
    if (y < 0 || y > cedit -> num_line)
    {
        cedit -> nError = 7;
        return - 1;
    }
    if (cedit -> freeze == 1) return 0;
    if (cedit -> something_has_changed == 0) return 0;  // si no ha cambiado nada desde la ÃÂºltima vez que busque flags, no me mato
    cedit -> something_has_changed = 0;
    
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

        // primero, saco los flags de la ÃÂºltima linea, para continuar como lo dejo la ultima linea
    line_comment = 0;
    reserved_word = 0;
    number = 0;
    character = 0;
    mark = 0;
    macro = 0;
    //    selected = 0;
    comment = 0;
    text = 0;
    apostrophe_text = 0;
    macro = 0;
    num_reserved_word = 0;
    num_comment = 0;
    num_text = 0;
    num_apostrophe_text = 0;
    
        // busco la linea anterior de verdad, no me sirve si la linea anterior no tiene caracteres
    prev_line = l_line -> prev;
    if (prev_line==NULL)
      exit_cond=1;
    else
      {
	if (prev_line->num_char>0)
	  exit_cond=1;
	else
	  exit_cond=0;
      }
    while (exit_cond==0)
      {
	prev_line=prev_line->prev;
	if (prev_line==NULL)
	  exit_cond=1;
	else
	  {
	    if (prev_line->num_char>0)
	      exit_cond=1;
	    else
	      exit_cond=0;
	  }
      }
    //    while (prev_line != NULL && prev_line -> num_char == 0)
    //        prev_line = prev_line -> prev;
    

        // busco la linea siguiente de verdad, no me sirve si la linea anterior no tiene caracteres
    next_line = l_line -> next;
    if (next_line==NULL)
      exit_cond=1;
    else
      {
	if (next_line->num_char>0)
	  exit_cond=1;
	else
	  exit_cond=0;
      }
    while (exit_cond==0)
      {
	next_line=next_line->next;
	if (next_line==NULL)
	  exit_cond=1;
	else
	  {
	    if (next_line->num_char>0)
	      exit_cond=1;
	    else
	      exit_cond=0;
	  }
      }

    //    while (next_line != NULL && next_line -> num_char == 0)
    //        next_line = next_line -> next;
    
        // miro si en esta linea continua los flags de la anterior
    if (prev_line != NULL) // no es la primera linea
    {
        last_char_pos = cedit_get_last_char_pos (cedit, prev_line);
            //      last_flag=prev_line->flags[last_char_pos];
        last_flag = cedit_get_last_flag (cedit, prev_line);
        
            // si tiene mas de 1 letra, puede ser "*/"
        if (last_char_pos >= 1)
        {
            if ((last_flag & cedit_flag_comment) &&
                !(prev_line -> text [last_char_pos - 1] == '*' &&
                    prev_line -> text [last_char_pos] == '/'))
            comment = 1;
        }
        else
            if (last_flag & cedit_flag_comment)
                comment = 1;
        
        if ((last_flag & cedit_flag_text) &&
            prev_line -> text [last_char_pos] !='\"')
        text = 1;
        

	last_char_pos=cedit_get_last_char_pos (cedit, l_line->prev);
	if (last_char_pos<l_line->prev->num_char) // si el ultimo caracter es legal
	  {
	    if ((last_flag & cedit_flag_macro) && l_line -> prev -> text [last_char_pos] =='\\') macro = 1;
	    if ((last_flag & cedit_flag_line_comment) && l_line -> prev -> text [last_char_pos] =='\\') line_comment = 1;
	  }
    }
    
        // ahora calculo el flag de cada letra de la linea, si el ultimo flag ha variado, comprobare recursivamente
        //  el de la siguiente linea
    last_flag = cedit_get_last_flag (cedit, l_line);
        // si es una macro, lo se ahora
    if (l_line -> num_char > 0)
        if (l_line -> text [cedit_get_first_char_pos (cedit, l_line)] =='#')
            macro = 1;
    
    for (cont = 0; cont < l_line -> num_char; cont ++)
    {
        
            // miro si es una letra dentro de la selecciÃÂ³n
      /*        if (cedit_this_char_is_in_selection (cedit, cont, y) == 1)
            selected = 1;
        else
            selected = 0;
      */
            // miro si es un texto "asfasd"
        if (num_text > 0)
        {
            num_text --;
            if (num_text == 0)
                text = 0;
        }
        if (comment == 0 && line_comment == 0 && apostrophe_text == 0 && macro==0) // FIXME: lo de macro se puede quitar, entonces 
	  // cuando ponga: #include "caca.h", no podra leer caca.h, ya que se salta los textos (funcion: cedit_get_include_file)
        {
            if (l_line -> text [cont] =='\"')
            {
                count = cont - 1;
                count2 = 0;
                while (count >= 0 && l_line -> text [count] =='\\')
                {
                    count --;
                    if (count2 == 0) count2 = 1; else count2 = 0;
                }
                if (count2 == 0)
                {
                    if (text == 0) { text = 1; } else { num_text = 1; }
                }
            }
        }
        
            // miro si es un texto con apostrofes 'a'
        if (num_apostrophe_text > 0)
        {
            num_apostrophe_text --;
            if (num_apostrophe_text == 0)
                apostrophe_text = 0;
        }
        if (comment == 0 && line_comment == 0 && text == 0)
        {
            if (l_line -> text [cont] =='\'')
            {
                count = cont - 1;
                count2 = 0;
                while (count >= 0 && l_line -> text [count] =='\\')
                {
                    count --;
                    if (count2 == 0) count2 = 1; else count2 = 0;
                }
                if (count2 == 0)
                {
                    if (apostrophe_text == 0) { apostrophe_text = 1; } else { num_apostrophe_text = 1; }
                }
            }
        }
        
            // miro si es un comentario de linea, como este
        if (comment == 0 && line_comment == 0 && text == 0 && apostrophe_text == 0)
            if (cont < l_line -> num_char - 1)  // cuidado de no mirar demasiado lejos
                if (l_line -> text [cont] =='/' && l_line -> text [cont + 1] =='/')
                    line_comment = 1;
        
            // miro si es un comentario de muchas lineas: /* asdf */
            // primero busco el inicio /*
        if (num_comment > 0)  // contador para poder comentar el */ final, sino no saldria comentado
        {
            num_comment --;
            if (num_comment == 0)
                comment = 0;
        }
        if (comment == 0 && line_comment == 0 && text == 0 && apostrophe_text == 0)
            if (cont < l_line -> num_char - 1)  // cuidado de no mirar demasiado lejos
                if (l_line -> text [cont] =='/' && l_line -> text [cont + 1] =='*')
                    comment = 1;
            // ahora el final
        if (comment == 1)
            if (cont < l_line -> num_char - 1)  // cuidado de no mirar demasiado lejos
                if (l_line -> text [cont] =='*' && l_line -> text [cont + 1] =='/')
                    num_comment = 2;  // para que ponga como comentarios el */
        
        
            // si alguno de estos esta activo, no miro mas flags, ya que no son validos
            // (no se permite una palabra reservada en un comentario)
        if (line_comment == 0 && comment == 0 && text == 0 && apostrophe_text == 0)
        {
                // miro si es una letra, un numero o un signo
            if ((l_line -> text [cont] >='a' && l_line -> text [cont] <='z') ||
                (l_line -> text [cont] >='A' && l_line -> text [cont] <='Z') ||
		l_line->text[cont]=='_')
            {
                character = 1;
                number = 0;
                mark = 0;
            }
            else if (l_line -> text [cont] >='0' && l_line -> text [cont] <='9')
            {
                number = 1;
                mark = 0;
                character = 0;
            }
            else
            {
                mark = 1;
                character = 0;
                number = 0;
            }
            
            
                // miro si es una palabra reservada (solo lo miro si esta letra no es ya una palabra reservada)
                //  si es una letra y no es parte de una palabra reservada encontrada antes entonces...
            if (num_reserved_word > 0) // si he encontrado alguna
            {
                reserved_word = 1;     // esta letra pertenece a una palabra reservada
                num_reserved_word --; // y queda una letra menos de esta
                if (num_reserved_word == 0)
                    reserved_word = 0;
            }
            if (character == 1 && num_reserved_word == 0)
            {
                num_reserved_word = cedit_is_reserved_word (cedit, l_line, cont);  // devuelve el numero de letras de la palabra reservada
                if (num_reserved_word > 0)
                    reserved_word = 1;
            }
        }
        else
        {
            reserved_word = 0;
            character = 0;
            number = 0;
            mark = 0;
        }
        
            // ahora pongo el flag de la letra
        temp_flag = l_line -> flags [cont];  // lo guardo para ver si ha cambiado algo luego
        error = (l_line -> flags [cont] & cedit_flag_error);  // asi conservo el flag error, este no se toca aqui
	warning = (l_line -> flags [cont] & cedit_flag_warning);  // asi conservo el flag warning, este no se toca aqui
        l_line -> flags [cont] = error+warning;
        if (character) l_line -> flags [cont] += cedit_flag_character;
        if (number) l_line -> flags [cont] += cedit_flag_number;
        if (mark) l_line -> flags [cont] += cedit_flag_mark;
        if (macro) l_line -> flags [cont] += cedit_flag_macro;
        if (reserved_word) l_line -> flags [cont] += cedit_flag_reserved_word;
        if (line_comment) l_line -> flags [cont] += cedit_flag_line_comment;
        if (comment) l_line -> flags [cont] += cedit_flag_comment;
        if (text) l_line -> flags [cont] += cedit_flag_text;
        if (apostrophe_text) l_line -> flags [cont] += cedit_flag_apostrophe_text;
	//        if (selected) l_line -> flags [cont] += cedit_flag_selected;
        
            // si el flag ha cambiado, lo pongo en la pila de cambios
        if (temp_flag != l_line -> flags [cont])
        {
            cedit_add_change (cedit, cont, y, l_line, cedit_change_this_char);
        }
        
    }
    
        // si ha cambiado esta linea, puede que cambie la siguiente
        // FIXME: solo lo ha de hacer si es texto, text_apost, o comentario
    if (next_line != NULL)
    {
            //      if (
        if (last_flag != cedit_get_last_flag (cedit, l_line) ||
            l_line -> num_char == 0)
        {
                // cambiar los flags, pero no los tabs, pero sino lo hago, puede cometer errores luego el set tab (quedarse corto)
            cedit -> something_has_changed = 1;    // con esto le dejara pasar el if de arriba
            cedit_set_flags (cedit, l_line -> next, y + 1);
            cedit -> something_has_changed = 1;    // con esto le dejara pasar el if de arriba
            cedit_set_tabs (cedit, l_line -> next, y + 1);                                     // FIXME: puede que se quiera
            
        }
        else // si no ha cambiado esta, puede que si la otra. Solo ocurre en pocas excepciones:
        {
            last_flag = cedit_get_last_flag (cedit, l_line);
            first_flag = cedit_get_first_flag (cedit, next_line);
                // si mi ultima letra es macro y la primera de la siguiente tambien o
                // line comment, o text la miro, por si ahora la siguiente no lo es
            if (((last_flag & cedit_flag_macro) && (first_flag & cedit_flag_macro)) ||
                ((last_flag & cedit_flag_line_comment) && (first_flag & cedit_flag_line_comment)) ||
                ((last_flag & cedit_flag_text) && (first_flag & cedit_flag_text)) ||
                ((last_flag & cedit_flag_comment) && (l_line -> text [cedit_get_last_char_pos (cedit, l_line)] == '/')) ||
                    // ((last_flag & cedit_flag_comment) && (first_flag & cedit_flag_comment) && (l_line->text[cedit_get_last_char_pos(cedit, l_line)] == '/')) ||
                ((last_flag & cedit_flag_comment) && (l_line -> text [cedit_get_last_char_pos (cedit, l_line)] == '*')))
            {
                cedit -> something_has_changed = 1;    // con esto le dejara pasar el if de arriba
                cedit_set_flags (cedit, l_line -> next, y + 1);
            }
	    /*            else if (last_flag & cedit_flag_selected)
            {
                cedit -> something_has_changed = 1;    // con esto le dejara pasar el if de arriba
                cedit_set_flags (cedit, l_line -> next, y + 1);
            }
	    */
        }
    }
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return 0;
}

    // -------------------------------------------------------
    //  Devuelve si este carÃÂ¡cter esta dentro de la selecciÃÂ³n
    // -------------------------------------------------------
int
cedit_this_char_is_in_selection (CEdit *cedit, long x, long y)
{
    long min_y, max_y, min_x, max_x;
    
    if (cedit == NULL) return - 1;
    if (cedit -> sel_ini_y ==- 1 || cedit -> sel_end_y ==- 1)
        return 0;
    
        // primero miro que punto (el inicial o el final) es el que esta mas cerca del principo del fichero (cual es menor)
    if (cedit -> sel_ini_y < cedit -> sel_end_y ||
        (cedit -> sel_ini_y == cedit -> sel_end_y && cedit -> sel_ini_x < cedit -> sel_end_x))
    {
        min_x = cedit -> sel_ini_x;
        min_y = cedit -> sel_ini_y;
        max_x = cedit -> sel_end_x;
        max_y = cedit -> sel_end_y;
    }
    else
    {
        max_x = cedit -> sel_ini_x;
        max_y = cedit -> sel_ini_y;
        min_x = cedit -> sel_end_x;
        min_y = cedit -> sel_end_y;
    }
    
    
    if (y > min_y && y < max_y) return 1;
    if (y == min_y && x >= min_x && min_y != max_y) return 1;
    if (y == min_y && x >= min_x && min_y == max_y && x < max_x) return 1;
    if (y == max_y && x < max_x && min_y != max_y) return 1;
    return 0;
}
    // -------------------------------------
    //  Devuelve el primer flag de la linea
    // -------------------------------------
int
cedit_get_first_flag (CEdit *cedit, line *l_line)
{
        //  int cont;
    int pos;
    char mutex;
    
    if (cedit == NULL) return 0;
    if (l_line == NULL) return 0;

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    pos = cedit_get_first_char_pos (cedit, l_line);

	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }

    if (pos < 0) return 0;
    
    return l_line -> flags [pos];
}

    // -------------------------------------
    //  Devuelve el ÃÂºltimo flag de la linea
    // -------------------------------------
int
cedit_get_last_flag (CEdit *cedit, line *l_line)
{
    int cont;
    char mutex;
    
    if (cedit == NULL) return - 1;
    if (l_line == NULL) return - 1;
    if (l_line -> num_char <= 0) return 0;

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    
    cont = l_line -> num_char - 1;
    while (cont > 0 && l_line -> text [cont] ==' ')
        cont --;

	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return l_line -> flags [cont];
}

    // -----------------------------------------
    //  Devuelve la posiciÃÂ³n de la ÃÂºltima letra
    // -----------------------------------------
long
cedit_get_last_char_pos (CEdit *cedit, line *l_line)
{
    long cont;
    //    char mutex;
    
    if (cedit == NULL) return - 1;
    if (l_line == NULL) return - 1;
    if (l_line -> num_char <= 0) return - 1;
    /*
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    */

    cont = l_line -> num_char - 1;
    while (cont > 0 && l_line -> text [cont] ==' ')
        cont --;
    /*
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    */
    return cont;
}
    // -----------------------------------------
    //  Devuelve la posiciÃÂ³n de la ÃÂºltima letra
    // -----------------------------------------
long
cedit_get_first_char_pos (CEdit *cedit, line *l_line)
{
    int cont;
    char mutex;

    if (cedit == NULL) return - 1;
    if (l_line == NULL) return - 1;
    if (l_line -> num_char <= 0) return - 1;
    
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    cont = 0;
    while (cont < l_line -> num_char && l_line -> text [cont] ==' ')
        cont ++;
    
    if (cont == l_line -> num_char)
        cont --;
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return cont;  // siempre esta en la primera letra, no permito poner espacios ni tabs
}

    // ----------------------------------------------------------------
    //  Devuelve el numero de letras que tiene la palabra reservada
    //   la cual me piden que busque si esta en la posicion que me dan
    //   0 si no hay ninguna
    // ----------------------------------------------------------------
int
cedit_is_reserved_word (CEdit *cedit, line *l_line, long x)
{
    long cont;  // contador de cada palabra reservada
    int cont2;  // contador por cada letra de la palabra reservada
    char mutex;
    
    if (cedit == NULL) return - 1;
    if (l_line == NULL)
    {
        cedit -> nError = 5;
        return - 1;
    }
    if (x < 0 || x >= l_line -> num_char)
    {
        cedit -> nError = 7;
        return - 1;
    }
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    
        // solo puede ser una palabra reservada si empieza en la primera letra o no es precedida por una letra
    if (x > 0)
        if (!cedit_is_mark(l_line -> text [x - 1]) ||
        (l_line -> flags [x - 1] & cedit_flag_comment) == cedit_flag_comment ||
        (l_line -> flags [x - 1] & cedit_flag_line_comment) == cedit_flag_line_comment ||
        (l_line -> flags [x - 1] & cedit_flag_text) == cedit_flag_text ||
        (l_line -> flags [x - 1] & cedit_flag_apostrophe_text) == cedit_flag_apostrophe_text)
	  {
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
	  return 0;
	  }
    
    for (cont = 0; cont < cedit -> num_reserved_words; cont ++)
    {
            // si quedan suficientes caracteres para que quepa la palabra reservada, entonces me mato a buscarla
        if (x + strlen (cedit -> reserved_words [cont]) <= l_line -> num_char)
        {
            cont2 = 0;
            while (cont2 < strlen (cedit -> reserved_words [cont]) && 
		   l_line -> text [x + cont2] == cedit -> reserved_words [cont] [cont2])
                cont2 ++;
            if (cont2 == strlen (cedit -> reserved_words [cont])) // he encontrado una palabra
            {
	      // si el siguiente caracter no es una letra o numero
	      if (x + cont2 >= l_line -> num_char) // ultima letra
		{
		  if (mutex==1)
		    {
		      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
		      cedit->mutex=0;
		    }
		  return cont2;
		}
	      if (cedit_is_mark(l_line -> text [x +cont2]) ||
		(l_line -> flags [x +cont2] & cedit_flag_comment) == cedit_flag_comment ||
		(l_line -> flags [x +cont2] & cedit_flag_line_comment) == cedit_flag_line_comment ||
		(l_line -> flags [x +cont2] & cedit_flag_text) == cedit_flag_text ||
		(l_line -> flags [x +cont2] & cedit_flag_apostrophe_text) == cedit_flag_apostrophe_text)
	      {
		  if (mutex==1)
		    {
		      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
		      cedit->mutex=0;
		    }
		  return cont2;
		}
	    }
        }
    }
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return 0;
}

    // ----------------------------------------------------------
    //  Carga las palabras reservadas, por ahora, solo las aÃÂ±ade
    // ----------------------------------------------------------
int
cedit_load_reserved_words (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    cedit -> num_reserved_words = 0;
    cedit -> reserved_words = NULL;
    cedit_insert_reserved_word (cedit, "char");
    cedit_insert_reserved_word (cedit, "double");
    cedit_insert_reserved_word (cedit, "float");
    cedit_insert_reserved_word (cedit, "int");
    cedit_insert_reserved_word (cedit, "long");
    cedit_insert_reserved_word (cedit, "short");
    cedit_insert_reserved_word (cedit, "signed");
    cedit_insert_reserved_word (cedit, "unsigned");
    cedit_insert_reserved_word (cedit, "void");

    cedit_insert_reserved_word (cedit, "auto");
    cedit_insert_reserved_word (cedit, "const");
    cedit_insert_reserved_word (cedit, "extern");
    cedit_insert_reserved_word (cedit, "friend");
    cedit_insert_reserved_word (cedit, "private");
    cedit_insert_reserved_word (cedit, "public");
    cedit_insert_reserved_word (cedit, "protected");
    cedit_insert_reserved_word (cedit, "register");
    cedit_insert_reserved_word (cedit, "static");
    cedit_insert_reserved_word (cedit, "volatile");

    cedit_insert_reserved_word (cedit, "break");
    cedit_insert_reserved_word (cedit, "case");
    cedit_insert_reserved_word (cedit, "catch");
    cedit_insert_reserved_word (cedit, "continue");
    cedit_insert_reserved_word (cedit, "default");
    cedit_insert_reserved_word (cedit, "do");
    cedit_insert_reserved_word (cedit, "else");
    cedit_insert_reserved_word (cedit, "for");
    cedit_insert_reserved_word (cedit, "goto");
    cedit_insert_reserved_word (cedit, "if");
    cedit_insert_reserved_word (cedit, "return");
    cedit_insert_reserved_word (cedit, "switch");
    cedit_insert_reserved_word (cedit, "throw");
    cedit_insert_reserved_word (cedit, "try");
    cedit_insert_reserved_word (cedit, "while");

    cedit_insert_reserved_word (cedit, "class");
    cedit_insert_reserved_word (cedit, "enum");
    cedit_insert_reserved_word (cedit, "struct");
    cedit_insert_reserved_word (cedit, "template");
    cedit_insert_reserved_word (cedit, "typedef");
    cedit_insert_reserved_word (cedit, "union");

    cedit_insert_reserved_word (cedit, "delete");
    cedit_insert_reserved_word (cedit, "new");
    cedit_insert_reserved_word (cedit, "this");
    cedit_insert_reserved_word (cedit, "virtual")
;
    cedit_insert_reserved_word (cedit, "asm");
    cedit_insert_reserved_word (cedit, "inline");
    cedit_insert_reserved_word (cedit, "operator");
    cedit_insert_reserved_word (cedit, "sizeof");

    cedit_insert_reserved_word (cedit, "exit");
    cedit_insert_reserved_word (cedit, "NULL");

    return 0;
}
    // --------------------------------------------------------------------------
    //  Inserta una palabra reservada nueva, devuelve el numero de ellas que hay
    // --------------------------------------------------------------------------
int
cedit_insert_reserved_word (CEdit *cedit, char *reserved_word)
{
  int cont;
  char mutex;
    
    if (cedit == NULL) return - 1;
    if (reserved_word == NULL) return - 1;
    
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

        // reservo el espacio
    if (cedit -> reserved_words == NULL)
        cedit -> reserved_words =(char **) malloc (sizeof (char *) *(cedit -> num_reserved_words + 1));
    else
        cedit -> reserved_words =(char **) realloc (cedit -> reserved_words, sizeof (char *) *(cedit -> num_reserved_words + 1));
    cedit -> reserved_words [cedit -> num_reserved_words] =(char *) malloc (sizeof (char) *strlen (reserved_word) + 1);
    
        // copio
    for (cont = 0; cont < strlen (reserved_word); cont ++)
    cedit -> reserved_words [cedit -> num_reserved_words] [cont] = reserved_word [cont];
    
    cedit -> reserved_words [cedit -> num_reserved_words] [strlen (reserved_word)] ='\0';
    
    cedit -> num_reserved_words ++;
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return cedit -> num_reserved_words;
}

    // ----------------------------------------------------------------------------------------------
    //  intercambia entre colorear las lineas mientras se escribe o cuando cambie de linea el cursor
    // ----------------------------------------------------------------------------------------------
int
cedit_toggle_fast_color (CEdit *cedit)
{
    int prev;
    
    if (cedit == NULL) return - 1;
    
    prev = cedit -> fast_color;
    
    if (cedit -> fast_color == 0)
        cedit -> fast_color = 1;
    else
        cedit -> fast_color = 0;
    
    return prev;
}

    // ---------------------------------------------------------------------------------------------------------
    //  devuelve el estado de fast_color (colorear las lineas continuamente o cuando cambie de linea el cursor)
    // ---------------------------------------------------------------------------------------------------------
int
cedit_get_fast_color (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    return cedit -> fast_color;
}

    // --------------------------------------------------------------------------------------------------
    //                                  Selecciones copy, paste y cut
    // --------------------------------------------------------------------------------------------------
    // ---------------------------------------
    //  Situa el primer punto de la selecciÃÂ³n
    // ---------------------------------------
int
cedit_cset_first_selection_point (CEdit *cedit, int cursor)
{
    long ant_y;
    line *l_line;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    
    ant_y =- 1;
    l_line = NULL;
        // si no esta vacio, he de acordarme entre que lineas estaba para borrarlo
    if (cedit -> sel_ini_y !=- 1)
    {
            // ant_y es el mas pequeÃÂ±o
        if (cedit -> sel_ini_y < cedit -> sel_end_y)
        {
            ant_y = cedit -> sel_ini_y;
            l_line = cedit -> sel_ini_line;
        }
        else
        {
            ant_y = cedit -> sel_end_y;
            l_line = cedit -> sel_end_line;
        }
    }
    cedit -> sel_ini_x = cedit -> cursors [cursor] . x;
    cedit -> sel_ini_y = cedit -> cursors [cursor] . y;
    cedit -> sel_ini_line = cedit -> cursors [cursor] . l_line;
    cedit -> sel_end_x = cedit -> cursors [cursor] . x;
    cedit -> sel_end_y = cedit -> cursors [cursor] . y;
    cedit -> sel_end_line = cedit -> cursors [cursor] . l_line;
    
    if (ant_y !=- 1)
    {
      cedit_add_change (cedit, cedit -> sel_ini_x, cedit -> sel_ini_y, cedit -> sel_ini_line, cedit_change_to_end_of_text);
      //        cedit -> something_has_changed = 1;
      //        cedit_set_flags (cedit, l_line, ant_y);
    }
    return 0;
}

    // ---------------------------------------
    //  Situa el ÃÂºltimo punto de la selecciÃÂ³n
    // ---------------------------------------
int
cedit_cset_last_selection_point (CEdit *cedit, int cursor)
{
    long ant_y;
    line *l_line;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (cedit -> sel_ini_y ==- 1)
        return cedit_cset_first_selection_point (cedit, cursor);
    
        // si pasa esto, es que no estoy haciendo nada
    if (cedit -> sel_end_x == cedit -> cursors [cursor] . x &&
        cedit -> sel_end_y == cedit -> cursors [cursor] . y)
    return 0;
    
        // los flags se modifican del menor y de "sel_end_y" y "y"
    if (cedit -> sel_end_y < cedit -> cursors [cursor] . y)
    {
        ant_y = cedit -> sel_end_y;
        l_line = cedit -> sel_end_line;
    }
    else
    {
        ant_y = cedit -> cursors [cursor] . y;
        l_line = cedit -> cursors [cursor] . l_line;
    }
    
    cedit -> sel_end_x = cedit -> cursors [cursor] . x;
    cedit -> sel_end_y = cedit -> cursors [cursor] . y;
    cedit -> sel_end_line = cedit -> cursors [cursor] . l_line;
    
    cedit -> something_has_changed = 1;
    cedit_set_flags (cedit, l_line, ant_y);
    //    if (l_line -> next != NULL)
    //    {
      cedit_add_change (cedit, 0, ant_y,l_line, cedit_change_to_end_of_text);
      //        cedit -> something_has_changed = 1;
      //        cedit_set_flags (cedit, l_line -> next, ant_y + 1);
      
      //    }
    return 0;
}

    // --------------------------------
    //  Devuelve si hay seleccion o no
    // --------------------------------
int
cedit_have_selection (CEdit *cedit)
{
    if (cedit == NULL)
        return - 1;
    if (cedit -> sel_ini_y !=- 1 && cedit -> sel_end_y !=- 1)
        return 1;
    return 0;
}

    // --------------------
    //  Quita la selecciÃÂ³n
    // --------------------
int
cedit_del_selection (CEdit *cedit)
{
    long ant_y;
    line *l_line;
    
    if (cedit == NULL)
        return - 1;
    if (cedit -> sel_ini_y ==- 1)
        return 0;
    
        // ant_y es el mas pequeÃÂ±o
    if (cedit -> sel_ini_y < cedit -> sel_end_y)
    {
        ant_y = cedit -> sel_ini_y;
        l_line = cedit -> sel_ini_line;
    }
    else
    {
        ant_y = cedit -> sel_end_y;
        l_line = cedit -> sel_end_line;
	}
    
    cedit -> sel_ini_x =- 1;
    cedit -> sel_ini_y =- 1;
    cedit -> sel_ini_line = NULL;
    
    cedit -> sel_end_x =- 1;
    cedit -> sel_end_y =- 1;
    cedit -> sel_end_line = NULL;
    
        // dibujo los cambios
    //    cedit -> something_has_changed = 1;
    //    cedit_set_flags (cedit, l_line, ant_y);
    cedit_add_change (cedit, 0, ant_y,l_line, cedit_change_to_end_of_text);
    return 0;
}

    // --------------------------------------
    //  Devuelve la selecciÃÂ³n en texto llano
    // --------------------------------------
char *
cedit_get_selection_text (CEdit *cedit)
{
  char mutex;
    char *text;
    long x, y;
    long min_x, min_y, max_x, max_y;
    long num_char;
    line *l_line, *min_l_line;
    
    if (cedit == NULL)
        return NULL;
    if (cedit -> sel_ini_y ==- 1 || cedit -> sel_end_y ==- 1)
    {
        cedit -> nError = 1;
        return NULL;
    }
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    
    
        // primero miro que punto (el inicial o el final) es el que esta mas cerca del principo del fichero (cual es menor)
    if (cedit -> sel_ini_y < cedit -> sel_end_y ||
        (cedit -> sel_ini_y == cedit -> sel_end_y && cedit -> sel_ini_x < cedit -> sel_end_x))
    {
        min_x = cedit -> sel_ini_x;
        min_y = cedit -> sel_ini_y;
        max_x = cedit -> sel_end_x;
        max_y = cedit -> sel_end_y;
        min_l_line = cedit -> sel_ini_line;
    }
    else
    {
        max_x = cedit -> sel_ini_x;
        max_y = cedit -> sel_ini_y;
        min_x = cedit -> sel_end_x;
        min_y = cedit -> sel_end_y;
        min_l_line = cedit -> sel_end_line;
    }
    
    text =(char *) malloc (cedit_get_selection_num_char (cedit) *sizeof (char));
    
    x = min_x;
    y = min_y;
    l_line = min_l_line;
    
        /*
        if (x>=l_line->num_char)
        text[0]='\n';
        else
        text[0]=l_line->text[x];
        */
    
        /*    x++;
        if (x>l_line->num_char && y<max_y)
        {
        x=0;
        y++;
        l_line=l_line->next;
        }
        */
        //    num_char++;
    
    num_char = 0;
    while ((x < max_x || y != max_y) && y <= max_y)
    {
        
        if (x == l_line -> num_char && y != max_y)
            text [num_char] ='\n';
        else if (x > l_line -> num_char)
            text [num_char] =' ';
        else
            text [num_char] = l_line -> text [x];
        
        x ++;
        if (x > l_line -> num_char && y < max_y)
        {
            x = 0;
            y ++;
            l_line = l_line -> next;
        }
        num_char ++;
    }
    
    text [num_char] ='\0';
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return text;
}

    // -----------------------------------------------
    //  Devuelve el numero de letras de una seleccion
    // -----------------------------------------------
long cedit_get_selection_num_char (CEdit *cedit)
{
  char mutex;
    long x, y;
    long min_x, min_y, max_x, max_y;
    line *l_line, *min_l_line;
    long num_char;
    
    if (cedit == NULL) return - 1;
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    
        // primero miro que punto (el inicial o el final) es el que esta mas cerca del principo del fichero (cual es menor)
    if (cedit -> sel_ini_y < cedit -> sel_end_y ||
        (cedit -> sel_ini_y == cedit -> sel_end_y && cedit -> sel_ini_x < cedit -> sel_end_x))
    {
        min_x = cedit -> sel_ini_x;
        min_y = cedit -> sel_ini_y;
        max_x = cedit -> sel_end_x;
        max_y = cedit -> sel_end_y;
        min_l_line = cedit -> sel_ini_line;
    }
    else
    {
        max_x = cedit -> sel_ini_x;
        max_y = cedit -> sel_ini_y;
        min_x = cedit -> sel_end_x;
        min_y = cedit -> sel_end_y;
        min_l_line = cedit -> sel_end_line;
    }
    
    x = min_x;
    y = min_y;
    l_line = min_l_line;
    num_char = 1;
    while ((x < max_x || y != max_y) && y <= max_y)
    {
        x ++;
        if (x > l_line -> num_char) // && y < max_y)
        {
            x = 0;
            y ++;
            l_line = l_line -> next;
        }
	//	if (y<max_y)
	num_char ++;
    }
    
    if (y<=max_y)
      num_char ++;

    if (mutex==1)
      {
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }
    return num_char;
}

    // ------------------------
    //  Pega un trozo de texto
    // ------------------------
int cedit_cpaste_text (CEdit *cedit, int cursor, char *text)
{
    int ret;
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (text == NULL)
    {
        cedit -> nError = 5;
        return - 1;
    }
    cedit -> joined_undo = 1;
    ret = cedit_cput_text (cedit, cursor, text);
    cedit -> joined_undo = 0;
    return ret;
}

    // ------------------------
    //  corta un trozo de texto
    // ------------------------
int cedit_ccut_text (CEdit *cedit, int cursor)
{
  char mutex;
    int ret;
    unsigned long cont, maxcont;
    int state_fast_color, state_fast_autoident;
    

    ret = 0;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (cedit -> sel_ini_y ==- 1 || cedit -> sel_end_y ==- 1)
        return 0;
    if (cedit -> joined_undo == 1) // para no llamarnos recursivamente (joined_undo es para mantener junto un bloque de undo's)
        return 0;

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }


    if (cedit -> sel_ini_y == cedit -> sel_end_y &&
        cedit -> sel_ini_x == cedit -> sel_end_x)
    {
        cedit -> sel_ini_y =- 1;
        cedit -> sel_ini_x =- 1;
        cedit -> sel_ini_line = NULL;
        cedit -> sel_end_y =- 1;
        cedit -> sel_end_x =- 1;
        cedit -> sel_end_line = NULL;
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
        return 0;
    }
    
        // primero miro que punto (el inicial o el final) es el que esta mas cerca del principo del fichero (cual es menor)
    if (cedit -> sel_ini_y < cedit -> sel_end_y ||
        (cedit -> sel_ini_y == cedit -> sel_end_y && cedit -> sel_ini_x < cedit -> sel_end_x))
    {
        cedit_cmove_cursor (cedit, cursor, cedit -> sel_ini_x, cedit -> sel_ini_y);
            //      cedit->cursors[cursor].x=cedit->sel_ini_x;
            //      cedit->cursors[cursor].y=cedit->sel_ini_y;
            //      cedit->cursors[cursor].l_line=cedit->sel_ini_line;
    }
    else
    {
        cedit_cmove_cursor (cedit, cursor, cedit -> sel_end_x, cedit -> sel_end_y);
            //      cedit->cursors[cursor].x=cedit->sel_end_x;
            //      cedit->cursors[cursor].y=cedit->sel_end_y;
            //      cedit->cursors[cursor].l_line=cedit->sel_end_line;
    }
    
    cedit -> joined_undo = 1;
    maxcont = cedit_get_selection_num_char (cedit);
    maxcont --;
    maxcont --;
    
    cedit_del_selection (cedit);
    
    state_fast_color = cedit_get_fast_color (cedit);
    if (state_fast_color == 0) // si esta desactivado lo activo pa ir mas rapido
        cedit_toggle_fast_color (cedit);
    state_fast_autoident = cedit_get_fast_autoident (cedit);
    if (state_fast_autoident == 0) // si esta desactivado lo activo pa ir mas rapido
        cedit_toggle_fast_autoident (cedit);
    
    for (cont = 0; cont < maxcont; cont ++)
    ret = cedit_cdel_char (cedit, cursor);
    
    if (state_fast_color == 0) // y con este lo dejo como estaba
        cedit_toggle_fast_color (cedit);
    if (state_fast_autoident == 0) // y con este lo dejo como estaba
        cedit_toggle_fast_autoident (cedit);
    
    cedit -> joined_undo = 0;
    cedit -> something_has_changed = 1;  // para que busque flags
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    if (ret >= 0)
        return 1;
    return ret;
}

    // --------------------------------------------------------------------------------------------------
    //                                              Tabs
    // --------------------------------------------------------------------------------------------------

    // ---------------------------------------
    //  Devuelve el estado del fast autoident
    // ---------------------------------------
int
cedit_get_fast_autoident (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    return cedit -> fast_autoident;
}

    // ------------------------------------
    //  Activa/desactiva el fast autoident
    // ------------------------------------
int
cedit_toggle_fast_autoident (CEdit *cedit)
{
    int ret;
    
    if (cedit == NULL) return - 1;
    
    ret = cedit -> fast_autoident;
    if (cedit -> fast_autoident == 0)
        cedit -> fast_autoident = 1;
    else
        cedit -> fast_autoident = 0;
    return ret;
}

    // ---------------------------------------------------
    //  Incrementa o decrementa los tabs desde esta linea
    //   Hasta el final del fichero. >0 si hay cambios
    // ---------------------------------------------------
int
cedit_modify_tabs_until_end_of_file (CEdit *cedit, line *l_line, long y, int increment)
{
    int cont;
    stack_cursor *stk_cursor;
    int changes;
    
    changes = 0;
    
    if (cedit == NULL) return - 1;
    if (l_line == NULL) return - 1;
    
        // cambio los temporales
    if (cedit -> temp. move_y >= y)
    {
        changes = 1;
        cedit -> temp. move_tabs += increment;
    }
        // cambio todos los cursores que tienen el valor tab de la linea donde apuntan
    for (cont = 0; cont < cedit -> num_cursors; cont ++)
    {
        if (cedit -> cursors [cont] . y >= y)
        {
            changes = 1;
            cedit -> cursors [cont] . tabs += increment;
        }
    }
    
        // cambio todos los tabs en la pila de cursores
    stk_cursor = cedit -> first_stack_cursor;
    while (stk_cursor != NULL)
    {
        if (stk_cursor -> cursor_y >= y)
            stk_cursor -> cursor_tabs += increment;
    }
    
    return changes;
}

    // -------------------------------------
    //  Pone a cuantos tabs esta cada linea
    //   con respecto a la anterior
    // -------------------------------------
int
cedit_set_tabs (CEdit *cedit, line *l_line, long y)
{
  char mutex;
    if (cedit == NULL) return - 1;
    if (l_line == NULL) return - 1;
    if (y < 0) return - 1;
    if (cedit -> freeze == 1) return 0;
    if (cedit -> something_has_changed == 0) return 0;
    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    cedit -> something_has_changed = 0;
    cedit_real_set_tabs (cedit, l_line, y);
    if (l_line -> next != NULL)
        cedit_real_set_tabs (cedit, l_line -> next, y + 1);
    if (cedit_real_set_absolute_tabs (cedit, l_line, y) == 0 && l_line -> next != NULL)
        cedit_real_set_absolute_tabs (cedit, l_line -> next, y + 1);
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return 0;
}

    // ------------------------------------------
    //  esta es la funciÃÂ³n que lo hace realmente
    // ------------------------------------------
int
cedit_real_set_tabs (CEdit *cedit, line *l_line, long y)
{
    int cont;
    int tabs;
    int prev_tabs;
    int firstchar;
    int reserved_word_tab;
    
    if (cedit == NULL) return - 1;
    if (l_line == NULL) return - 1;
    if (l_line -> prev == NULL)
    {
        l_line -> tabs = 0;
        return 0;
    }
    
    tabs = 0;
    firstchar = 1;
    prev_tabs = l_line -> tabs;
    reserved_word_tab = 0;
    
    for (cont = 0; cont < l_line -> prev -> num_char; cont ++)
    {
        if (l_line -> prev -> text [cont] =='{' &&
            !(l_line -> prev -> flags [cont] & cedit_flag_line_comment) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_comment) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_text) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_apostrophe_text))
        
        tabs ++;
        else if (l_line -> prev -> text [cont] =='(' &&
            !(l_line -> prev -> flags [cont] & cedit_flag_line_comment) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_comment) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_text) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_apostrophe_text))
        tabs ++;
        else if (l_line -> prev -> text [cont] ==')' &&
            !(l_line -> prev -> flags [cont] & cedit_flag_line_comment) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_line_comment) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_comment) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_text) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_apostrophe_text))
        tabs --;
        else if (l_line -> prev -> text [cont] =='}' && firstchar == 0 && // los } despues de letras hacen que la siguiente tenga -1 tab
            !(l_line -> prev -> flags [cont] & cedit_flag_line_comment) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_comment) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_text) &&
            !(l_line -> prev -> flags [cont] & cedit_flag_apostrophe_text))
        tabs --;
        else
            firstchar = 0;
    }
    
    cont = cedit_get_first_char_pos (cedit, l_line);
    while (l_line -> text [cont] =='}' && cont < l_line -> num_char && // los } iniciales hacen que ESTA linea tenga -1 tab
        !(l_line -> flags [cont] & cedit_flag_line_comment) &&
        !(l_line -> flags [cont] & cedit_flag_comment) &&
        !(l_line -> flags [cont] & cedit_flag_text) &&
        !(l_line -> flags [cont] & cedit_flag_apostrophe_text))
    {
        tabs --;
        cont ++;
    }
    
    if (tabs == prev_tabs)
        return 0;
    
    l_line -> tabs = tabs;
    cedit_modify_tabs_until_end_of_file (cedit, l_line, y, tabs - prev_tabs);
    cedit_add_change (cedit, 0, y, l_line, cedit_change_to_end_of_text);
    
    return 1;
}

    // --------------------------------------------------
    //  Pone los tabs absolutos (MACROS, COMENTARIOS...)
    // --------------------------------------------------
int
cedit_real_set_absolute_tabs (CEdit *cedit, line *l_line, long y)
{
    int add_tabs, absolute_tabs;
    int prev_add_tabs, prev_absolute_tabs;
    int reserved_word_tab;
    int cont;
    int parenthesis;
    
    if (l_line -> num_char <= 0 && l_line -> next != NULL)
        return cedit_real_set_absolute_tabs (cedit, l_line -> next, y + 1);
    
    add_tabs = 0;
    absolute_tabs =- 1;
    prev_add_tabs = l_line -> add_tabs;
    prev_absolute_tabs = l_line -> absolute_tabs;
    reserved_word_tab = 0;
    
    if ((cedit_get_first_flag (cedit, l_line) & cedit_flag_comment) == cedit_flag_comment)
        add_tabs = 1;
    if ((cedit_get_first_flag (cedit, l_line) & cedit_flag_line_comment) == cedit_flag_line_comment)
        add_tabs = 1;
    if ((cedit_get_first_flag (cedit, l_line) & cedit_flag_macro) == cedit_flag_macro)
        absolute_tabs = 0;
    
    if (l_line -> prev != NULL)
    {
        cont = 0;
	parenthesis=0;
            // esto busca si hay que poner un tab despues de un if, else, while, for...
        while (cont < l_line -> prev -> num_char &&
            (((l_line -> prev -> text [cont] !=';' || parenthesis==0) && l_line -> prev -> text [cont] !='{') ||
                (l_line -> prev -> flags [cont] & cedit_flag_comment) == cedit_flag_comment ||
                (l_line -> prev -> flags [cont] & cedit_flag_line_comment) == cedit_flag_line_comment ||
                (l_line -> prev -> flags [cont] & cedit_flag_text) == cedit_flag_text ||
                (l_line -> prev -> flags [cont] & cedit_flag_apostrophe_text) == cedit_flag_apostrophe_text))
        {
	  if (l_line->prev->text[cont]==')')
	    parenthesis=1;
	  else
            if (cedit_is_tab_reserved_word (cedit, l_line -> prev, cont) > 0)
	      reserved_word_tab ++;
	  cont ++;
        }
            // si no se ha llegado al final, es por que se ha encontrado un ; o {, por lo que no hay add_tab
        if (cont != l_line -> prev -> num_char)
            reserved_word_tab = 0;
        
        if (l_line -> num_char > 0)
        {
            cont = cedit_get_first_char_pos (cedit, l_line);
            if (reserved_word_tab > 0 && add_tabs < 1 && l_line -> text [cont] !='{')
            {
                cont = cedit_get_first_char_pos (cedit, l_line -> prev);
                    // si el anterior tiene un add_tab, yo le sumo uno EXCEPTO que el addtab anterior por comentarios
                if (cont >= 0)
                {
                    if (((l_line -> prev -> flags [cont] & cedit_flag_comment) != cedit_flag_comment) &&
                        (l_line -> prev -> flags [cont] & cedit_flag_line_comment) != cedit_flag_line_comment &&
                        l_line -> tabs == 0)
                    add_tabs = 1 + l_line -> prev -> add_tabs;;
                }
                else
                    add_tabs = 1 + l_line -> prev -> add_tabs;
            }
        }
    }
    
        //  if (add_tabs>0)
    if (prev_add_tabs == add_tabs && prev_absolute_tabs == absolute_tabs) // && cedit_get_first_flag(cedit, l_line) & (cedit_flag_comment != cedit_flag_comment))
        return 0;
    
    l_line -> add_tabs = add_tabs;
    l_line -> absolute_tabs = absolute_tabs;
        //l_line->tabs=0;
    cedit_add_change (cedit, 0, y, l_line, cedit_change_to_end_of_line);
    if (l_line -> next != NULL)
        cedit_real_set_absolute_tabs (cedit, l_line -> next, y + 1);
    return 1;
}

    // ----------------------------------------------------------------
    //  Devuelve el numero de letras que tiene la palabra reservada
    //   solo if, while, else, for porque estos usan una linea mas
    // ----------------------------------------------------------------
int
cedit_is_tab_reserved_word (CEdit *cedit, line *l_line, long x)
{
    long cont;  // contador de cada palabra reservada
    int cont2;  // contador por cada letra de la palabra reservada
    char words [4] [10];
    
    strcpy (words [0],"if");
    strcpy (words [1],"while");
    strcpy (words [2],"else");
    strcpy (words [3],"for");
    
        // solo puede ser una palabra reservada si empieza en la primera letra o no es precedida por una letra o no es comentario o texto
    if (x > 0)
        if (!cedit_is_mark(l_line -> text [x - 1]) ||
	    (l_line -> flags [x - 1] & cedit_flag_comment) == cedit_flag_comment ||
	    (l_line -> flags [x - 1] & cedit_flag_line_comment) == cedit_flag_line_comment ||
	    (l_line -> flags [x - 1] & cedit_flag_text) == cedit_flag_text ||
	    (l_line -> flags [x - 1] & cedit_flag_apostrophe_text) == cedit_flag_apostrophe_text)
	  /*
        if ((l_line -> text [x - 1] !='(' && l_line -> text [x - 1] !=')' &&
            l_line -> text [x - 1] !='{' && l_line -> text [x - 1] !='}' &&
            l_line -> text [x - 1] !=' ' && l_line -> text [x - 1] !='[' &&
            l_line -> text [x - 1] !=']') ||
            //    if ((l_line->text[x-1]>='a' && l_line->text[x-1]<='z') ||
            //(l_line->text[x-1]>='A' && l_line->text[x-1]<='Z') ||
        (l_line -> flags [x - 1] & cedit_flag_comment) == cedit_flag_comment ||
        (l_line -> flags [x - 1] & cedit_flag_line_comment) == cedit_flag_line_comment ||
        (l_line -> flags [x - 1] & cedit_flag_text) == cedit_flag_text ||
        (l_line -> flags [x - 1] & cedit_flag_apostrophe_text) == cedit_flag_apostrophe_text)
	  */
    return 0;
    
    for (cont = 0; cont < 5; cont ++)
    {
            // si quedan suficientes caracteres para que quepa la palabra reservada, entonces me mato a buscarla
        if (x + strlen (words [cont]) <= l_line -> num_char)
        {
            cont2 = 0;
            while (cont2 < strlen (words [cont]) && l_line -> text [x + cont2] == words [cont] [cont2])
                cont2 ++;
            if (cont2 == strlen (words [cont])) // he encontrado una palabra
            {
                    // si el siguiente caracter no es una letra es un espacio
                if (x + cont2 >= l_line -> num_char) // ultima letra
                    return cont2;
	      if (cedit_is_mark(l_line -> text [x +cont2]) ||
		(l_line -> flags [x +cont2] & cedit_flag_comment) == cedit_flag_comment ||
		(l_line -> flags [x +cont2] & cedit_flag_line_comment) == cedit_flag_line_comment ||
		(l_line -> flags [x +cont2] & cedit_flag_text) == cedit_flag_text ||
		(l_line -> flags [x +cont2] & cedit_flag_apostrophe_text) == cedit_flag_apostrophe_text)
		/*		  if (l_line -> text [x + cont2] =='(' || l_line -> text [x + cont2] ==')' ||
                    l_line -> text [x + cont2] =='{' || l_line -> text [x + cont2] =='}' ||
                    l_line -> text [x + cont2] ==' ' || l_line -> text [x + cont2] =='[' ||
                    l_line -> text [x + cont2] ==']' || l_line -> text [x + cont2] ==';' ||
                    l_line -> text [x + cont2] =='*')*/
                    //      if (!((l_line->text[x+cont2]>='a' && l_line->text[x+cont2]<='z') ||
                    //    (l_line->text[x+cont2]>='A' && l_line->text[x+cont2]<='Z')))
                return cont2;
            }
        }
    }
    return 0;
}

    // ------------------------------------------------
    //  Devuelve el numero de tabs que tiene una linea
    // ------------------------------------------------
int
cedit_cget_tabs (CEdit *cedit, int cursor)
{
    int tabs;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (cedit -> cursors [cursor] . l_line -> absolute_tabs >= 0)
        tabs = cedit -> cursors [cursor] . l_line -> absolute_tabs;
    else
        tabs = cedit -> cursors [cursor] . tabs + cedit -> cursors [cursor] . l_line -> add_tabs;
    
    if (tabs < 0) return 0;
    else
        return tabs;
}

    // -------------------------------------------------------------
    //  Borra el cedit_flag_block es la marca que aparece al inicio
    //  o fin de bloque
    // -------------------------------------------------------------
int
cedit_delete_block_flag (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    if (cedit -> block_x ==- 1)
        return 0;
    
    if ((cedit -> block_line -> flags [cedit -> block_x] & cedit_flag_block) == cedit_flag_block)
        cedit -> block_line -> flags [cedit -> block_x] -= cedit_flag_block;
    
        // FIXME: no deberia de quitar el error, sino dejarlo hasta que este solucionado
    if ((cedit -> block_line -> flags [cedit -> block_x] & cedit_flag_error) == cedit_flag_error)
        cedit -> block_line -> flags [cedit -> block_x] -= cedit_flag_error;
    
    cedit_add_change (cedit, cedit -> block_x, cedit -> block_y, cedit -> block_line, cedit_change_this_char);
    cedit -> block_x =- 1;
    cedit -> block_y =- 1;
    cedit -> block_line = NULL;
    return 1;
}

    // -------------------------------------------------------------
    //  Busca el cedit_flag_block es la marca que aparece al inicio
    //  o fin de bloque a partir del cursor
    // -------------------------------------------------------------
int
cedit_csearch_block_flag (CEdit *cedit, int cursor)
{
  char mutex;
    char ch, ant_ch;
    int flag;
    int count; // numero de anidacion
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (cedit -> cursors [cursor] . x >= cedit -> cursors [cursor] . l_line -> num_char)  // no hay pareja si estoy fuerda de la linea
        return 0;
    if (cedit -> freeze == 1) return 0;

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    if (cedit -> block_x !=- 1)
        cedit_delete_block_flag (cedit);
    
    ch = cedit -> cursors [cursor] . l_line -> text [cedit -> cursors [cursor] . x];
    flag = cedit -> cursors [cursor] . l_line -> flags [cedit -> cursors [cursor] . x];
    ant_ch = ch;
    if ((ch =='{' ||
            ch =='[' ||
            ch =='(') &&
        ((flag & cedit_flag_comment) != cedit_flag_comment &&
            (flag & cedit_flag_line_comment) != cedit_flag_line_comment &&
            (flag & cedit_flag_text) != cedit_flag_text &&
            (flag & cedit_flag_apostrophe_text) != cedit_flag_apostrophe_text))
    {
        cedit -> block_x = cedit -> cursors [cursor] . x;
        cedit -> block_y = cedit -> cursors [cursor] . y;
        cedit -> block_line = cedit -> cursors [cursor] . l_line;
        count = 0;
        while (count >= 0 && cedit -> block_line != NULL)
        {
            cedit -> block_x ++;
            if (cedit -> block_x >= cedit -> block_line -> num_char)
            {
                cedit -> block_y ++;
                cedit -> block_x = 0;
                cedit -> block_line = cedit -> block_line -> next;
            }
            if (cedit -> block_line != NULL)
            {
                ch = cedit -> block_line -> text [cedit -> block_x];
                flag = cedit -> block_line -> flags [cedit -> block_x];
                if ((ch =='}' || ch ==']' || ch ==')') &&
                    ((flag & cedit_flag_comment) != cedit_flag_comment &&
                        (flag & cedit_flag_line_comment) != cedit_flag_line_comment &&
                        (flag & cedit_flag_text) != cedit_flag_text &&
                        (flag & cedit_flag_apostrophe_text) != cedit_flag_apostrophe_text))
                count --;
                else if ((ch =='{' || ch =='[' || ch =='(') &&
                    ((flag & cedit_flag_comment) != cedit_flag_comment &&
                        (flag & cedit_flag_line_comment) != cedit_flag_line_comment &&
                        (flag & cedit_flag_text) != cedit_flag_text &&
                        (flag & cedit_flag_apostrophe_text) != cedit_flag_apostrophe_text))
                count ++;
            }
        }
    }
    else if ((ch =='}' ||
            ch ==']' ||
            ch ==')') &&
        ((flag & cedit_flag_comment) != cedit_flag_comment &&
            (flag & cedit_flag_line_comment) != cedit_flag_line_comment &&
            (flag & cedit_flag_text) != cedit_flag_text &&
            (flag & cedit_flag_apostrophe_text) != cedit_flag_apostrophe_text))
    {
        cedit -> block_x = cedit -> cursors [cursor] . x;
        cedit -> block_y = cedit -> cursors [cursor] . y;
        cedit -> block_line = cedit -> cursors [cursor] . l_line;
        count = 0;
        while (count >= 0 && cedit -> block_line != NULL)
        {
            cedit -> block_x --;
            if (cedit -> block_x < 0)
            {
                cedit -> block_y --;
                cedit -> block_line = cedit -> block_line -> prev;
                if (cedit -> block_line != NULL)
                    cedit -> block_x = cedit -> block_line -> num_char - 1;
            }
            if (cedit -> block_line != NULL)
            {
                ch = cedit -> block_line -> text [cedit -> block_x];
                flag = cedit -> block_line -> flags [cedit -> block_x];
                
                if ((ch =='{' || ch =='[' || ch =='(') &&
                    ((flag & cedit_flag_comment) != cedit_flag_comment &&
                        (flag & cedit_flag_line_comment) != cedit_flag_line_comment &&
                        (flag & cedit_flag_text) != cedit_flag_text &&
                        (flag & cedit_flag_apostrophe_text) != cedit_flag_apostrophe_text))
                count --;
                else if ((ch =='}' || ch ==']' || ch ==')') &&
                    ((flag & cedit_flag_comment) != cedit_flag_comment &&
                        (flag & cedit_flag_line_comment) != cedit_flag_line_comment &&
                        (flag & cedit_flag_text) != cedit_flag_text &&
                        (flag & cedit_flag_apostrophe_text) != cedit_flag_apostrophe_text))
                count ++;
            }
        }
    }
    
    if (cedit -> block_line == NULL)
    {
        cedit -> block_x =- 1;
        cedit -> block_y =- 1;
    }
    else
    {
        if ((ch =='(' && ant_ch ==')') ||
            (ch =='{' && ant_ch =='}') ||
            (ch =='[' && ant_ch ==']') ||
            (ch ==')' && ant_ch =='(') ||
            (ch =='}' && ant_ch =='{') ||
            (ch ==']' && ant_ch =='['))
        {
            if ((cedit -> block_line -> flags [cedit -> block_x] & cedit_flag_block) == 0)
                cedit -> block_line -> flags [cedit -> block_x] += cedit_flag_block;
        }
        else
            if ((cedit -> block_line -> flags [cedit -> block_x] & cedit_flag_error) == 0)
                cedit -> block_line -> flags [cedit -> block_x] += cedit_flag_error;
    }
    cedit_add_change (cedit, cedit -> block_x, cedit -> block_y, cedit -> block_line, cedit_change_this_char);
	  if (mutex==1)
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      cedit->mutex=0;
	    }
    return 1;
}

    // ----------------------------------------------------------
    //  Pone la linea de una forma correcta, sin espacios de mas
    //   y con espacios allÃÂ­ donde hace falta
    // ----------------------------------------------------------
int
cedit_set_format (CEdit *cedit, int cursor, line *l_line, long y)
{
  char mutex;
    int cont;
    int count;
    int changes;
    if (cedit == NULL) return - 1;
    if (l_line == NULL) return - 1;
    if (y < 0) return - 1;
    
    if (cedit -> freeze == 1) return 0;
    if (cedit->format==0) return 0; // si no esta activado, salgo
    if (cedit->something_has_changed==0) return 0;
    cedit->something_has_changed=0;

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }

    cedit -> something_has_changed = 0;  // para que busque flags
    changes = 0;
    
        // borro los espacios al principio de la linea
    while (l_line -> text [0] ==' ' && l_line -> num_char > 0)
    {
        for (cont = 0; cont < l_line -> num_char - 1; cont ++)
        {
            l_line -> text [cont] = l_line -> text [cont + 1];
            l_line -> flags [cont] = l_line -> flags [cont + 1];
        }
        
        l_line -> num_char --;
            //    cedit_realloc_text(l_line, l_line->num_char);
        changes = 1;
    }
    
        // borro los espacios al final de la linea
    while (l_line -> text [l_line -> num_char - 1] ==' ' && l_line -> num_char > 0)
    {
        l_line -> num_char --;
        cedit_realloc_text (cedit, l_line, l_line -> num_char);
        changes = 1;
    }
    
        // depues de una , va un espacio
    count = 0;
    while (count < l_line -> num_char - 1)
    {
        if (((l_line -> flags [count] & cedit_flag_comment) == 0 &&
                (l_line -> flags [count] & cedit_flag_line_comment) == 0 &&
                (l_line -> flags [count] & cedit_flag_text) == 0 &&
                (l_line -> flags [count] & cedit_flag_apostrophe_text) == 0 &&
                (l_line -> flags [count] & cedit_flag_macro) == 0) &&
            l_line -> text [count] !=' ' && l_line -> text [count] !='_')
        {
                // espacio antes
            if (count > 0)
            {
                if (cedit_is_mark (l_line -> text [count]) && !cedit_is_mark (l_line -> text [count - 1]) && l_line -> text [count] !=' ' &&
                    l_line -> text [count] !=')' && l_line -> text [count] !='}' && l_line -> text [count] !=']' &&
                    l_line -> text [count] !=',' && l_line -> text [count] !='.' && l_line -> text [count] !=';' &&
                    l_line -> text [count] !=':')
                {
                    cedit_realloc_text (cedit, l_line, l_line -> num_char + 1);
                    for (cont = l_line -> num_char; cont > count; cont --)
                    {
                        l_line -> text [cont] = l_line -> text [cont - 1];
                        l_line -> flags [cont] = l_line -> flags [cont - 1];
                    }
                    l_line -> num_char ++;
                    l_line -> text [count] =' ';
                    l_line -> flags [count] = 0;
                    changes = 1;
                        //count=count+1;
                    
                }
            }
            
            
                // espacio despues
            if (count < l_line -> num_char - 1)
                if (cedit_is_mark (l_line -> text [count]) && !cedit_is_mark (l_line -> text [count + 1]) && 
		    l_line -> text [count] !=' ' &&
		    l_line -> text [count] !='(' && l_line -> text [count] !='{' && l_line -> text [count] !='[' &&
		    l_line -> text [count] !='*' && l_line -> text [count] !='!' && l_line -> text [count] !='&' &&
		    l_line -> text [count] !='.')
            {
                cedit_realloc_text (cedit, l_line, l_line -> num_char + 1);
                for (cont = l_line -> num_char; cont > count; cont --)
                {
                    l_line -> text [cont] = l_line -> text [cont - 1];
                    l_line -> flags [cont] = l_line -> flags [cont - 1];
                }
                l_line -> num_char ++;
                l_line -> text [count + 1] =' ';
                l_line -> flags [count + 1] = 0;
                changes = 1;
            }
                // espacio despues, casos especiales
            if (count < l_line -> num_char - 1)
                if ((l_line -> text [count] ==')' && l_line -> text [count + 1] !=')' &&
                    l_line -> text [count + 1] !=' ' && l_line -> text [count + 1] !=';' &&
                    l_line -> text [count + 1] !=',' && l_line -> text [count + 1] !=']') ||
                (l_line -> text [count] ==']' && l_line -> text [count + 1] !=']' &&
                    l_line -> text [count + 1] !=' ' && l_line -> text [count + 1] !=';' &&
                    l_line -> text [count + 1] !=',' && l_line -> text [count + 1] !=')'))
            {
                cedit_realloc_text (cedit, l_line, l_line -> num_char + 1);
                for (cont = l_line -> num_char; cont > count; cont --)
                {
                    l_line -> text [cont] = l_line -> text [cont - 1];
                    l_line -> flags [cont] = l_line -> flags [cont - 1];
                }
                l_line -> num_char ++;
                l_line -> text [count + 1] =' ';
                l_line -> flags [count + 1] = 0;
                changes = 1;
                    //count++;
            }
        }
        count ++;
    }
    if (changes == 1)
        cedit_add_change (cedit, 0, y, l_line, cedit_change_to_end_of_line);

    cedit -> correct_now = 1;

    if (mutex==1)
      {
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }
    return changes;
}

    // -------------------------------------------
    //  intercambia entre formatear el texto y no
    // -------------------------------------------
int
cedit_toggle_format (CEdit *cedit)
{
    int prev;
    
    if (cedit == NULL) return - 1;
    
    prev = cedit -> format;
    
    if (cedit -> format == 0)
        cedit -> format = 1;
    else
        cedit -> format = 0;
    
    return prev;
}

    // -------------------------------------------------------
    //  devuelve el estado de format (formatear el texto o no)
    // -------------------------------------------------------
int
cedit_get_format (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    return cedit -> format;
}


    // ----------------
    //  Busca un texto
    // ----------------
int
cedit_cfind (CEdit *cedit, int cursor, char *text)
{
    long x, y;
    line *l_line;
    int tabs;
    int found;
    int cont;
    char mutex;
    long prev_x, prev_y;
    
    if (cedit == NULL) return - 1;
    if (cursor < 0 || cursor >= cedit -> num_cursors) {
        cedit -> nError = 1;
        return - 1;
    }
    if (text == NULL) return - 1;

    mutex=0;
    if (cedit->mutex==0)
      {      
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	mutex=1;
	cedit->mutex=1;
      }
    

    x = cedit -> cursors [cursor] . x;
    y = cedit -> cursors [cursor] . y;
    prev_x=x;
    prev_y=y;
    l_line = cedit -> cursors [cursor] . l_line;
    tabs = cedit -> cursors [cursor] . tabs;
    found = 0;
    cont = 0;
    
    // si lo he encontrado, pero me he movido algo, entonces lo tengo
    while (l_line != NULL && found == 0)// && (x!=prev_x || y!=prev_y)))
    {
        cont = 0;
        found = 1;
        while (cont < strlen (text) && found == 1) // && cont+x<=l_line->num_char)
        {
            if (l_line -> text [x + cont] != text [cont])
                found = 0;
            
            cont ++;
        }
        
        if (found == 0 || (found==1 && x==prev_x && y==prev_y))
        {
	  found=0; // por si entro con la segunda condicion
            x ++;
            if (x + strlen (text) > l_line -> num_char)
            {
                x = 0;
                y ++;
                l_line = l_line -> next;
                tabs += l_line -> tabs;
            }
        }
    }
    if (found == 1)
    {
        cedit_cmove_cursor (cedit, cursor, x, y);
    }

    if (mutex==1)
      {
	g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	cedit->mutex=0;
      }
    return found;
}

    // ------------------------
    // Devuelve si es un signo
    // ------------------------
int cedit_is_mark (char ch)
{
    return !((ch >='a' && ch <='z') ||
        (ch >='A' && ch <='Z') ||
        (ch >='0' && ch <='9') || ch=='_');
}

    // --------------------------------------------------------------------------------------------
    //  HILOS
    // --------------------------------------------------------------------------------------------
    // --------------------------------------------
    //  funcion inicial del hilo que rellena la bd
    // --------------------------------------------
gpointer cedit_fill_db (gpointer _cedit)
{
  CEdit *cedit;

  line *search_line;
  //  time_t before, after;

  cedit=(CEdit*)_cedit;
    cedit -> words_db = g_tree_new_full (cedit_compare_db_word,
        NULL,
        cedit_words_db_key_destroy_func,
        cedit_words_db_value_destroy_func);
    cedit_fill_initial_db (cedit);
    cedit->num_definition_words_deleted=0;
    cedit->num_definition_words=0;

    /*
    cedit->definition_deleted=(definition_db*)malloc(sizeof(definition_db));
    cedit->definition_deleted->name=strdup("borrado");
    cedit->definition_deleted->type=cedit_dw_deleted;
    cedit->definition_deleted->n_args=0;
    */

    while (1)
    {
      if (cedit->correct_now==1 || cedit->continuous_correction==1)
        {
	  //	  time (&before);
	  /*	  cedit_free_words_db (cedit);
	  cedit -> words_db = g_tree_new_full (cedit_compare_db_word,
					       NULL,
					       cedit_words_db_key_destroy_func,
					       cedit_words_db_value_destroy_func);
	  */

	  cedit_free_initial_db (cedit); // libero todas las definiciones no usadas y necesarias
	  cedit_start_include_db(cedit);
	  cedit->restart_correct_now=0;


	  search_line=cedit_copy_lines(cedit);
	  cedit_search_definitions (cedit, search_line, NULL, NULL);
	  cedit_free_include_file(cedit, search_line);  // libero el archivo

	  //	  if (cedit->restart_correct_now==0) // si me lo han cancelado, no sigo
	    {
	      /*	      incl_db=cedit->list_include_db;
	      while (incl_db!=NULL)
		{	      
		  //	  g_tree_destroy (cedit -> global_db);
		  cedit->words_db=cedit_copy_tree(cedit, incl_db->db, cedit->words_db);
		  incl_db=incl_db->next;
		}
	      */
	      cedit_correct_file (cedit);
	      cedit_del_include_db_not_readed(cedit);

	      /*	      
	      g_print("que voy...");
	      g_tree_foreach(cedit->words_db,
			     caca,
			     cedit);
	      g_print("ya...");
	      */
	      
	    }
	  cedit -> correct_now = 0;
	  g_print("\n--%ld, %ld--\n", cedit->num_definition_words, cedit->num_definition_words_deleted);
	  //	  time (&after);

	  //	  g_print ("tiempo: %ld segs\n", (int) after - before);
	  /*	  cedit -> global_db = g_tree_new_full (cedit_compare_db_word,
						NULL,
						cedit_words_db_key_destroy_func,
						cedit_words_db_value_destroy_func);
	  */

	  
	

	}
      if (cedit -> exit == 1)
        {
	  cedit_free_words_db (cedit);
	  return NULL;
        }
      if (cedit->continuous_correction==0) // si no se quiere correccion continua, hago esta pausa
	sleep (1);
    }    
}

// -------------------------------------------------
//  Borra las definiciones del fichero que se edita
// -------------------------------------------------
int 
cedit_free_initial_db(CEdit *cedit)
{
  if (cedit->num_definition_words_deleted>10000) // hay ya demasiados borrados, rehago la base de datos
    {
      cedit_free_words_db (cedit);
      cedit -> words_db = g_tree_new_full (cedit_compare_db_word,
					   NULL,
					   cedit_words_db_key_destroy_func,
					   cedit_words_db_value_destroy_func);	  
      
      cedit_free_include_db(cedit);
      cedit_fill_initial_db (cedit);
      cedit->num_definition_words_deleted=0;
    }
  else
    cedit_free_definitions_db_file(cedit, NULL);
  return 0;
}

// ----------------------------------------------
//  Libera las definiciones del fichero indicado
// ----------------------------------------------
int
cedit_free_definitions_db_file(CEdit *cedit, char *file)
{
  cedit->file_to_delete=file;
  g_tree_foreach(cedit->words_db,
		 cedit_free_definitions_db_file_callback,
		 cedit);
  return 0;
}

gboolean cedit_free_definitions_db_file_callback (gpointer _key,
						  gpointer _value,
						  gpointer _cedit)
{
  char *key;
  definition_db *value;
  CEdit *cedit;

  key=(char*)_key;
  value=(definition_db*)_value;
  cedit=(CEdit*)_cedit;
  //  char *new_key;
  if (value==NULL || key==NULL)
    return 0;

  if (value->is_deleted>0) // no borro lo ya borrado
    return 0;

  if (cedit->file_to_delete==NULL || value->file==NULL)
    {
    if (value->file==cedit->file_to_delete)
      {
	//	g_print("borro %s\n", value->file);
	//	g_tree_insert(cedit->words_db, key, cedit->definition_deleted);
	value->is_deleted=1;
	cedit->num_definition_words_deleted++;
      }
    }
  else
    {
      //      g_print("%s - %s\n", value->file, cedit->file_to_delete);
      if (strcmp(value->file, cedit->file_to_delete)==0)
	{
	  //	  g_print("borro %s\n", value->file);
	  //  g_tree_insert(cedit->words_db, key, cedit->definition_deleted);
	  value->is_deleted=1;
	  cedit->num_definition_words_deleted++;
	}
    }
  return FALSE;
}

    // -----------------------------------------------
    //  intercambia entre corregir continuamente y no
    // -----------------------------------------------
int
cedit_toggle_continuous_correction (CEdit *cedit)
{
    int prev;
    
    if (cedit == NULL) return - 1;
    
    prev = cedit -> continuous_correction;
    
    if (cedit -> continuous_correction == 0)
        cedit -> continuous_correction = 1;
    else
        cedit -> continuous_correction = 0;
    
    return prev;
}

    // ----------------------------------------------
    //  devuelve el estado de corregir continuamente
    // ----------------------------------------------
int
cedit_get_continuous_correction (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    return cedit -> continuous_correction;
}

    // ---------------------------------
    //  intercambia entre corregir y no
    // ---------------------------------
int
cedit_toggle_correction (CEdit *cedit)
{
    int prev;
    
    if (cedit == NULL) return - 1;
    
    prev = cedit -> correction;
    
    if (cedit -> correction == 0)
      {
	cedit->exit=0;
	cedit->correct_now=1;
	cedit->fill_db=g_thread_create(cedit_fill_db, cedit, TRUE, NULL);
	g_thread_set_priority(cedit->fill_db,G_THREAD_PRIORITY_LOW);
	cedit->correction=1;
      }
    else
      {
	cedit -> exit = 1;
	g_thread_join (cedit -> fill_db);    
	cedit -> exit = 0;
	// vacio de error y warnings todo
	cedit_unset_flag_to_error2 (cedit, cedit->first, 0,0,0,cedit->num_line+1);
	cedit->correction=0;
      }
    
    return prev;
}

    // --------------------------------
    //  devuelve el estado de corregir
    // --------------------------------
int
cedit_get_correction (CEdit *cedit)
{
    if (cedit == NULL) return - 1;
    return cedit -> correction;
}


void cedit_words_db_key_destroy_func (gpointer data)
{
  
  char *key;

  key=(char*)data;
  if (key!=NULL)
    free(key);

}

void cedit_words_db_value_destroy_func (gpointer data)
{
    definition_db *def_db;

    if (data==NULL) return;


    def_db =(definition_db *) data;
    
    //    g_print("BORRO DE VERDAD: %s\n", def_db->name);
    //    if (def_db->type!=cedit_dw_deleted)
    //      {
	if (def_db -> name != NULL)
	  free (def_db -> name);
	if (def_db->typedef_name!=NULL)
	  free(def_db->typedef_name);
	if (def_db -> file != NULL)
	  free (def_db -> file);
	if (def_db -> n_args>0)
	  free(def_db->definition_type_args);

	free (def_db);
	//      }
}

    // -------------------------
    //  Libera la base de datos
    // -------------------------
void cedit_free_words_db (CEdit *cedit)
{
  cedit->num_definition_words=0;
  g_tree_destroy (cedit -> words_db);
}

    // ----------------------------------------------------------------------------
    //  funcin de comparacin de la bd, para tenerla ordenada y buscar mas rapido
    // ----------------------------------------------------------------------------
gint cedit_compare_db_word (gconstpointer a, gconstpointer b, gpointer user_data)
{
  //    int i;
    char *A,*B;
    //    int salir;
    
    A =(char *) a;
    B =(char *) b;
    
    if (a==NULL) return -1;
    if (b==NULL) return 1;
    return strcmp(A,B);
    /*
    salir=0;

    
    i = 0;

    while(salir==0)
      {
	if (i<strlen(A) && i<strlen(B))
	  {
	    if (A[i]==B[i])
	      i++;
	    else
	      salir=1;
	  }
	else
	  {
	    salir=1;
	  }
      }

    //    whi le (i < strlen (A) && i < strlen (B) && A [i] == B [i])
    //        i ++;
    
    if (i == strlen (A) && i == strlen (B))
        return 0;
    if (i == strlen (A))
        return - 1;
    if (i == strlen (B))
        return  1;
    if (A [i] == B [i])
        return 0;
    if (A [i] < B [i])
        return - 1;
    return 1;
    */
}

int cedit_strcmp (char *a, char *b)
{
    int i;
    
    if (a==NULL && b==NULL) return 0;
    if (a==NULL) return -1;
    if (b==NULL) return 1;
    i = 0;
    
    while (i < strlen (a) && i < strlen (b) && a [i] == b [i])
        i ++;
    
    if (i == strlen (a) && i == strlen (b))
        return 0;
    if (i == strlen (a))
        return - 1;
    if (i == strlen (b))
        return  1;
    if (a [i] == b [i])
        return 0;
    if (a [i] < b [i])
        return - 1;
    return 1;    
}

void cedit_exit_fill_db (void *cedit)
{
}
    // -------------------------------------------------------------
    //  rellena la bd con las definiciones iniciales (int, char...)
    // -------------------------------------------------------------
void cedit_fill_initial_db (CEdit *cedit)
{
  include_db *new_db;

  new_db=cedit_new_include_db(cedit, "pedazodeprincipalqwertyuiop01234");
  //new_db=NULL;
  cedit_insert_definition_word (cedit,"char", cedit_dw_data_type, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"int", cedit_dw_data_type, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"void", cedit_dw_data_type, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"long", cedit_dw_data_type, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"double", cedit_dw_data_type, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"short", cedit_dw_data_type, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"float", cedit_dw_data_type, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"unsigned", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"signed", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"define", cedit_dw_variable, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"include", cedit_dw_variable, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"throw", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"THROW", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  
  cedit_insert_definition_word (cedit,"auto", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"const", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"extern", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"friend", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"private", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"protected", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"public", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"register", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"static", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"volatile", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  
  cedit_insert_definition_word (cedit,"break", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"case", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"catch(", cedit_dw_function, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"continue", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"default", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"do", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"else", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"for(", cedit_dw_function, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db); 
  cedit_insert_definition_word (cedit,"goto", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"if(", cedit_dw_function, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"return", cedit_dw_nothing, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"switch(", cedit_dw_function, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"throw(", cedit_dw_function, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"try(", cedit_dw_function, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"while(", cedit_dw_function, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
    
  cedit_insert_definition_word (cedit,"class", cedit_dw_struct, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"enum", cedit_dw_struct, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"struct", cedit_dw_struct, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"template", cedit_dw_struct, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"typedef", cedit_dw_struct, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"union", cedit_dw_struct, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);

  cedit_insert_definition_word (cedit,"delete(", cedit_dw_function, NULL, 0,0,NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"new(", cedit_dw_function, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"this", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"virtual", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
    
  cedit_insert_definition_word (cedit,"sizeof(", cedit_dw_function, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"asm", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"inline", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"operador", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);

  cedit_insert_definition_word (cedit,"exit", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
  cedit_insert_definition_word (cedit,"NULL", cedit_dw_nothing, NULL, 0,0, NULL, 0, -1, "ficherobasico123513241", - 1, - 1, new_db);
}


    // --------------------------------------------------------------------------
    //  Funciones de corregir
    // --------------------------------------------------------------------------
void cedit_correct_file (CEdit *cedit)
{
  CEditCursor cursor;
  int depth;

  cursor.l_line = cedit -> first;
  cursor.x=0;
  cursor.y = 0;
  depth=0;

  // vacio de error y warnings todo
  cedit_unset_flag_to_error2 (cedit, cedit->first, 0,0,0,cedit->num_line+1);

  while (cursor.l_line != NULL && cedit->exit==0)
    {
      if (cedit -> restart_correct_now != 0)
        {
            cursor.l_line = cedit -> first;
	    cursor.y=0;
	    cursor.x=0;
	    depth=0;
            cedit -> restart_correct_now = 0;
        }
      
      cedit_correct_file_recursive (cedit, &cursor, &depth);
      if (cursor.l_line!=NULL)
	cedit_get_next_real_char(cedit, &cursor, &depth);
    }
  cedit_add_change (cedit, 0, 0, cedit->first, cedit_change_to_end_of_text);
}

    // --------------------------------------------------------------------------
    //  Funciones de corregir recursiva
    // --------------------------------------------------------------------------
void cedit_correct_file_recursive (CEdit *cedit, CEditCursor *cursor, int *depth)
{
   char *word;
    char ch;
    CEditCursor prev_cursor;
    definition_db *father;
    char see_args; // si esta a 1, la palabra ha de estar en los argumentos del padre (struct, class...)
    int count;
    char exit_cond;  // condicion de salida de un while
    
    word=(char*)malloc(1000*sizeof(char));
    father=NULL;
    //    depth=0;
    see_args=0;
    
    while (cursor->l_line!=NULL)
    {
      if (cedit -> exit)// || cedit->restart_correct_now)
	  {
	    free(word);
            return;
	  }

        g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto

	// me salto los signos y numeros, solo quiero letras	
	prev_cursor.x=cursor->x;
	prev_cursor.y=cursor->y;
	prev_cursor.l_line=cursor->l_line;
	cedit_get_real_char(cedit, cursor, depth);
	if (cursor->l_line == NULL)
	  {
	    //	    is_changed=cedit_unset_flag_to_error2 (cedit, prev_cursor.l_line, prev_cursor.x, prev_cursor.y, cursor->x, cursor->y);
	    //	    if (is_changed>0)
	    //	      changes=1;
	    g_mutex_unlock(cedit->mutex_text);
	    free(word);	    
	    return;
	  }
	if (cursor->x == cursor->l_line -> num_char)
	  ch =' ';
 	else
	  ch = cursor->l_line -> text [cursor->x];

	if (ch=='(' || ch=='[')  // si comienzo un bloque, me llamo recursivamente
	  {
	    cedit_get_next_real_char(cedit, cursor, depth);
	    g_mutex_unlock(cedit->mutex_text);
	    cedit_correct_file_recursive (cedit, cursor, depth);
	    g_mutex_lock(cedit->mutex_text);
	    cedit_get_next_real_char(cedit, cursor, depth);
	    if (cursor->l_line == NULL)
	      {
		g_mutex_unlock(cedit->mutex_text);
		free(word);	    
		return;
	      }
	    if (cursor->x == cursor->l_line -> num_char)
	      ch =' ';
	    else
	      ch = cursor->l_line -> text [cursor->x];
	  }
	if (ch==')' || ch==']') // si finaliza un bloque, salgo
	  {
	    g_mutex_unlock(cedit->mutex_text);
	    free(word);	    
	    //	    if (changes==1)
	    //	      cedit_add_change (cedit, 0, 0, cedit->first, cedit_change_to_end_of_text);
	    return;
	  }

	// me salto los signos y numeros, solo quiero letras (tampoco quiero macros, supongo q estan bien)
	while (!((ch >='a' && ch <='z') ||
		 (ch >='A' && ch <='Z') || ch =='_') || cursor->l_line->flags[cursor->x] & cedit_flag_macro)
	  {	    
	    cedit_get_next_real_char(cedit, cursor, depth);
	    if (cursor->l_line == NULL)
	      {
		//		is_changed=cedit_unset_flag_to_error2 (cedit, prev_cursor.l_line, prev_cursor.x, prev_cursor.y, cursor->x,cursor->y);
		//		if (is_changed>0)
		//		  changes=1;

		//		cedit_unset_flag_to_error (cedit, ant_temp, ant_x, x-ant_x, ant_y);
		g_mutex_unlock(cedit->mutex_text);
		free(word);
		return;
	      }
	    if (cursor->x == cursor->l_line -> num_char)
	      ch =' ';
	    else
	      ch = cursor->l_line -> text [cursor->x];	    

	    if (ch=='(' || ch=='[')  // si comienzo un bloque, me llamo recursivamente
	      {
		cedit_get_next_real_char(cedit, cursor, depth);
		g_mutex_unlock(cedit->mutex_text);
		cedit_correct_file_recursive (cedit, cursor, depth);
		g_mutex_lock(cedit->mutex_text);
		cedit_get_next_real_char(cedit, cursor, depth);
		if (cursor->l_line == NULL)
		  {
		    g_mutex_unlock(cedit->mutex_text);
		    free(word);	    
		    return;
		  }
		if (cursor->x == cursor->l_line -> num_char)
		  ch =' ';
		else
		  ch = cursor->l_line -> text [cursor->x];
	      }
	    if (ch==')' || ch==']') // si finaliza un bloque, salgo
	      {
		g_mutex_unlock(cedit->mutex_text);
		free(word);	    
		return;
	      }
	  }
	//	cedit_unset_flag_to_error (cedit, ant_temp, ant_x, x-ant_x, ant_y);

	//	is_changed=cedit_unset_flag_to_error2 (cedit, prev_cursor.l_line, prev_cursor.x, prev_cursor.y, cursor->x,cursor->y);
	//	if (is_changed>0)
	//	  changes=1;
	
	prev_cursor.x=cursor->x;
	prev_cursor.y=cursor->y;
	prev_cursor.l_line=cursor->l_line;

        cedit_get_next_word_correct_file (cedit, cursor, word, depth);
        if (cursor->l_line == NULL)
        {	  
	  g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	  free(word);
	  return;
        }

	
	if (see_args==0)  // si esta palabra no depende de la anterior
	  {
	    father=cedit_search_db_value(cedit, word, cursor->y,0);
	    
	    if (father == NULL) // no lo he encontrado
	      {
		// busco por si hay alguna definida, aunque sus limites no lleguen aqui
		father=cedit_search_db_value_extend(cedit, word, cursor->y,0);
		if (father == NULL) // no lo he encontrado
		    cedit_set_flag_to_error (cedit, prev_cursor.l_line, prev_cursor.x, strlen(word),prev_cursor.y);
		else
		    cedit_set_flag_to_warning (cedit, prev_cursor.l_line, prev_cursor.x, strlen(word),prev_cursor.y);
	      }
	    else
	      {
		if (father->type==cedit_dw_function)
		  {
		    cedit_get_next_real_char(cedit, cursor, depth);
		    g_mutex_unlock(cedit->mutex_text);
		    cedit_correct_file_recursive (cedit, cursor, depth);
		    g_mutex_lock(cedit->mutex_text);
		    cedit_get_next_real_char(cedit, cursor, depth);
		    if (cursor->l_line == NULL)
		      {
			g_mutex_unlock(cedit->mutex_text);
			free(word);	    
			return;
		      }
		    if (cursor->x == cursor->l_line -> num_char)
		      ch =' ';
		    else
		      ch = cursor->l_line -> text [cursor->x];
		  }
		//		is_changed=cedit_unset_flag_to_error (cedit, prev_cursor.l_line, prev_cursor.x, strlen(word), prev_cursor.y);
		//		if (is_changed>0)
		//		  changes=1;

	      }
	  }
	else             // si esta palabra tiene que estar en los argumentos del padre (struct, class...)
	  {
	    if (father==NULL) // si por algo, no hay padre, lo busco por metodos normales
	      {
		father=cedit_search_db_value(cedit, word, cursor->y,0);
		if (father==NULL)
		  {
		    // busco por si hay alguna definida, aunque sus limites no lleguen aqui
		    father=cedit_search_db_value_extend(cedit, word, cursor->y,0);
		    if (father == NULL) // no lo he encontrado
		      cedit_set_flag_to_error (cedit, prev_cursor.l_line, prev_cursor.x, strlen(word),prev_cursor.y);
		    else
		      cedit_set_flag_to_warning (cedit, prev_cursor.l_line, prev_cursor.x, strlen(word),prev_cursor.y);
		  }
		else
		  {
		    if (father->type==cedit_dw_function)
		      {
			cedit_get_next_real_char(cedit, cursor, depth);
			g_mutex_unlock(cedit->mutex_text);
			cedit_correct_file_recursive (cedit, cursor, depth);
			g_mutex_lock(cedit->mutex_text);
			cedit_get_next_real_char(cedit, cursor, depth);
			if (cursor->l_line == NULL)
			  {
			    g_mutex_unlock(cedit->mutex_text);
			    free(word);	    
			    return;
			  }
			if (cursor->x == cursor->l_line -> num_char)
			  ch =' ';
			else
			  ch = cursor->l_line -> text [cursor->x];
		      }
		  }
	      }
	    else
	      {
		count=0;
		exit_cond=1;
 		// miro el bucle con count = 0
		if (father->definition_type_args!=NULL) // si el padre tiene argumentos
		  exit_cond=cedit_strcmp(word, father->definition_type_args[count]->name); // miro si se llama igual que mi palabra

		// bucle para count>0
		while (count<father->n_args && exit_cond!=0) // lo busco en sus argumentos
		  {
		    count++;
		    if (count<father->n_args)
		      if (father->definition_type_args[count]!=NULL)
			exit_cond=cedit_strcmp(word, father->definition_type_args[count]->name);
		  }

		if (exit_cond==0) // si lo he encontrado
		  {
		    //		    is_changed=cedit_unset_flag_to_error (cedit, prev_cursor.l_line, prev_cursor.x, strlen(word), prev_cursor.y);
		    //		    if (is_changed>0)
		    //		      changes=1;
		    father=father->definition_type_args[count];
		    if (father->type==cedit_dw_function)
		      {
			cedit_get_next_real_char(cedit, cursor, depth);
			g_mutex_unlock(cedit->mutex_text);
			cedit_correct_file_recursive (cedit, cursor, depth);
			g_mutex_lock(cedit->mutex_text);
			cedit_get_next_real_char(cedit, cursor, depth);
			if (cursor->l_line == NULL)
			  {
			    g_mutex_unlock(cedit->mutex_text);
			    free(word);	    
			    return;
			  }
			if (cursor->x == cursor->l_line -> num_char)
			  ch =' ';
			else
			  ch = cursor->l_line -> text [cursor->x];
		      }
		  }
		else  // sino, la busco por metodos normales
		  {
		    father=cedit_search_db_value(cedit, word, cursor->y,0);
		    if (father == NULL)
		      {
			// busco por si hay alguna definida, aunque sus limites no lleguen aqui
			father=cedit_search_db_value_extend(cedit, word, cursor->y,0);
			if (father == NULL) // no lo he encontrado
			  cedit_set_flag_to_error (cedit, prev_cursor.l_line, prev_cursor.x, strlen(word),prev_cursor.y);
			else
			  cedit_set_flag_to_warning (cedit, prev_cursor.l_line, prev_cursor.x, strlen(word),prev_cursor.y);
		      }
		    else
		      {
			if (father->type==cedit_dw_function)
			  {
			    cedit_get_next_real_char(cedit, cursor, depth);
			    g_mutex_unlock(cedit->mutex_text);
			    cedit_correct_file_recursive (cedit, cursor, depth);
			    g_mutex_lock(cedit->mutex_text);
			    cedit_get_next_real_char(cedit, cursor, depth);
			    if (cursor->l_line == NULL)
			      {
				g_mutex_unlock(cedit->mutex_text);
				free(word);	    
				return;
			      }
			    if (cursor->x == cursor->l_line -> num_char)
			      ch =' ';
			    else
			      ch = cursor->l_line -> text [cursor->x];
			  }
			//			is_changed=cedit_unset_flag_to_error (cedit, prev_cursor.l_line, prev_cursor.x, strlen(word), prev_cursor.y);
			//			if (is_changed>0)
			//			  changes=1;
		      }
		  }
	      }
	  }
	//	cedit_unset_flag_to_error2 (cedit, prev_cursor.l_line, prev_cursor.x+strlen(word), prev_cursor.y, cursor->x,cursor->y);

	if (father!=NULL)
	  {
	    if (father->n_args>0 && father->type!=cedit_dw_function)
		see_args=1;
	    else if (father->definition_type!=NULL)
	      {
		if (father->definition_type->n_args>0 && father->type==cedit_dw_variable && father->definition_type->type!=cedit_dw_function)
		  {
		    see_args=1;
		    father=father->definition_type;
		  }
	      }
	    else
		see_args=0;
	  }
	else
	    see_args=0;

        g_mutex_unlock (cedit -> mutex_text);        
    }
    free(word);
}

    // devuelve la siguiente palabra
// es igual que la siguiente definicion, pero esta no se salta las palabras innecesarios (cedit_dw_nothing)
// ignora variables / funciones
int cedit_get_next_word_correct_file (CEdit *cedit, CEditCursor *cursor, char *word, int *depth)
{
    char ch;
    int flag;
    int i;
    
    if (cursor->l_line == NULL) return -1;
    word[0]='\0';

    cedit_get_real_char (cedit, cursor, depth);
    if (cursor->l_line == NULL) return -1;
    if (cursor->x == cursor->l_line -> num_char)
    {
        ch =' ';
        flag = 0;
    }
    else
    {
        ch = cursor->l_line -> text [cursor->x];
        flag = cursor->l_line -> flags [cursor->x];
    }
    
        // me salto los signos y demas, solo espero un caracter
    while (!((ch >='a' && ch <='z') || (ch >='A' && ch <='Z') || (ch =='_')))
    {
        cedit_get_next_real_char (cedit, cursor, depth);
        if (cursor->l_line == NULL) return -1;
        if (cursor->x == cursor->l_line -> num_char)
        {
            ch =' ';
            flag = 0;
        }
        else
        {
            ch = cursor->l_line -> text [cursor->x];
            flag = cursor->l_line -> flags [cursor->x];
        }
    }
    
        // ahora empieza una palabra
    i = 0;
    while ((ch >='a' && ch <='z') || (ch >='A' && ch <='Z') || (ch =='_') || (ch >='0' && ch <='9'))
    {
        word [i] = ch;
        i ++;

	cursor->x++;
	if (cursor->x==cursor->l_line->num_char)
	  {
	    word[i]='\0';
	    break;
	  }
	ch = cursor->l_line -> text [cursor->x];
    }

    word [i] ='\0'; // fin de la palabra
    
    return 0;
}


// -----------------------
//  Pone un texto a error
// -----------------------
int cedit_set_flag_to_error (CEdit *cedit, line *l_line, long x,long lenght, long y)
{
  int changes;
  long prev_x;

  changes=0;
  prev_x=x;
    while (lenght>0)
      {
	
	if (x<l_line->num_char)
	  {
	    if ((l_line -> flags [x] & cedit_flag_error) == 0)
	      {
		l_line -> flags [x] += cedit_flag_error;
		changes=1;
	      }
	  }
	x++;
	lenght--;
	if (x>=l_line->num_char)
	  break;
      }
    return changes;
}

// -------------------------
//  Pone un texto a warning
// -------------------------
int cedit_set_flag_to_warning (CEdit *cedit, line *l_line, long x,long lenght, long y)
{
  int changes;
  long prev_x;

  changes=0;
  prev_x=x;
    while (lenght>0)
      {
	
	if (x<l_line->num_char)
	  {
	    if ((l_line -> flags [x] & cedit_flag_warning) == 0)
	      {
		l_line -> flags [x] += cedit_flag_warning;
		changes=1;
	      }
	  }
	x++;
	lenght--;
	if (x>=l_line->num_char)
	  break;
      }
    return changes;
}

int cedit_unset_flag_to_error (CEdit *cedit, line *l_line, long x,long lenght, long y)
{
  int changes;
  long prev_x;
  changes=0;
  prev_x=x;
    while (lenght>0)
      {
	if (x<l_line->num_char)
	  {
	    if ((l_line -> flags [x] & cedit_flag_error) != 0)
	      {
		l_line -> flags [x] -= cedit_flag_error;
		changes=1;
	      }
	  }
	x++;
	lenght--;
	if (x>=l_line->num_char)
	  break;
      }
    //    if (changes==1)
    //      cedit_add_change (cedit, prev_x, y, l_line, cedit_change_to_end_of_line);
    return changes;
}

int cedit_unset_flag_to_error2 (CEdit *cedit, line *l_line, long prev_x, long prev_y, long x, long y)
{
  int changes;
  if (cedit==NULL) return -1;
  if (l_line==NULL) return -1;

  changes=0;
  while ((prev_x!=x || prev_y!=y) && l_line!=NULL)
      {
	if (prev_x<l_line->num_char)
	  {
	    if ((l_line -> flags [prev_x] & cedit_flag_error) != 0)
	      {
		l_line -> flags [prev_x] -= cedit_flag_error;
		changes=1;
		//		cedit_add_change (cedit, prev_x, prev_y, l_line, cedit_change_to_end_of_line);
	      }
	    if ((l_line -> flags [prev_x] & cedit_flag_warning) != 0)
	      {
		l_line -> flags [prev_x] -= cedit_flag_warning;
		changes=1;
		//		cedit_add_change (cedit, prev_x, prev_y, l_line, cedit_change_to_end_of_line);
	      }
	  }
	prev_x++;
	while (prev_x>=l_line->num_char)
	  {
	    prev_x=0;
	    prev_y++;
	    l_line=l_line->next;
	    if (l_line==NULL) return -1;
	  }
      }
  return changes;
}



    // ------------------------------------
    //  Busca las definiciones en el texto
    // ------------------------------------
void cedit_search_definitions (CEdit *cedit, line *first, char *filename, include_db *incl_db)
{
  //    line *temp;
  //    long x, y;
    char *word;
    //    char word2[3000];
    char pointer;
    char function_name [3000];
    char function_pointer;
    definition_db **definition_args;
    int n_args;
    definition_db *function_def_db; 
    definition_db *def_db;
    int depth;
    CEditCursor cursor;
    CEditCursor function_cursor;

    char is_define;
    char is_typedef;
    //    line *include_line;
    //    char *filenametonext;
    //    include_db *incl_dbtonext;
    char ch;
    int flag;
 
    word=(char*)malloc(30000*sizeof(char));
    
    cursor.l_line = first;
    cursor.x = 0;
    cursor.y = 0;
    depth=0;
    is_define=0;
    is_typedef=0;


    definition_args=(definition_db**) malloc (300 * sizeof(definition_db*));

    while (cursor.l_line != NULL)
    {        
      /*        if (cedit -> restart_correct_now == 1)
        {
	  if (cursor.l_line!=cedit->first) // si toca reiniciarse y soy una recursiva en un .h, salgo
	    {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      free(word);
	      free(definition_args);
	      return;
	    }
	    

            cursor.l_line = first;
            cursor.x = 0;
            cursor.y = 0;
	    depth=0;
            cedit -> restart_correct_now = 0;
	}
      */
        if (cedit -> exit == 1)
	  {
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      free(word);
	      free(definition_args);
	      return;
	  }
	g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
        cedit_get_next_word_correct (cedit, &cursor, word, &depth);
        if (cursor.l_line == NULL)
        {
	  
	  g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	  free(word);
	  free(definition_args);
	  return;
        }

	while (cedit_strcmp(word,"define")==0)
	  {
	    cedit_new_define(cedit, &cursor, word, &depth, filename, incl_db);	    
	    //	    g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	    //	    continue;
	  }
	
	if (cedit_strcmp(word,"typedef")==0)
	  {
	    is_typedef=1;
 	   
	    //	    cedit_get_next_function(cedit, &cursor, word, &depth); // cojo la siguiente palabra
	    cedit_get_next_word (cedit, &cursor, word, &depth); // cojo la siguiente palabra
	    //cedit_get_next_word_correct (cedit, &cursor, word, &depth); // cojo la siguiente palabra
	    if (cursor.l_line == NULL)
	      {
		
		g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
		free(word);
		free(definition_args);
		return;
	      }	  
	  }
	else
	  is_typedef=0;
	


	if (cedit_strcmp(word,"include")==0)
	  {
	    cedit_get_include_file(cedit, &cursor, word, &depth); // obtengo el nombre del fichero ha incluir
	    if (cursor.l_line == NULL)
	      {
		
		g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
		free(word);
		free(definition_args);
		return;
	      }

	    g_mutex_unlock(cedit->mutex_text);             // desprotejo
	    cedit_insert_include_db(cedit, word, incl_db);  // cargo el archivo
	    /*
	    filenametonext=NULL;
	    filenametonext=(char*)malloc(1000*sizeof(char));
	    include_line=cedit_insert_include_db(cedit, word, filenametonext, incl_db);  // cargo el archivo
	    incl_dbtonext=cedit->incl_dbtonext; // la funcion anterior rellena incl_dbtonext
	    if (include_line!=NULL)
	      {
	      cedit_search_definitions(cedit, include_line, filenametonext, incl_dbtonext); // que lo analice
		cedit_free_include_file(cedit, include_line);  // libero el archivo
	      }
 	    free(filenametonext);
	    */
	    //	    g_mutex_lock(cedit->mutex_text);               // protejo para continuar
	    continue;
	  }

	def_db = cedit_search_db_value(cedit, word,cursor.y,0);
	if (def_db != NULL)
	  {
	    cedit_get_this_real_char(cedit, &cursor, &ch, &flag);
	    if (def_db -> type == cedit_dw_data_type && cursor.l_line != NULL && ch!=')')  // si es de un tipo definitorio (int, char...)
	      {
		cedit_get_next_variable (cedit, &cursor, word, &pointer, &depth);  // cojo el nombre siguiente (a,b...)
		if (cursor.l_line == NULL) 
		  {
		    g_mutex_unlock (cedit -> mutex_text);
		    free(word);
		    free(definition_args);
		    return;
		  }
		if (word [strlen (word) - 1] =='(') // si es de tipo funcion int a(int c, int d);
		  {
		    // guardo los valores
		    strcpy (function_name, word);
		    function_pointer = pointer;
		    function_def_db = def_db;
		    function_cursor.y = cursor.y;
		    function_cursor.x = cursor.x;
		    function_cursor.l_line=cursor.l_line;
 		    n_args = 0;
		    
		    // busco ahora los parametros
		    cedit_get_next_word (cedit, &cursor, word, &depth);
		    def_db = cedit_search_db_value(cedit, word,cursor.y,0);    

		    if (def_db!=NULL && is_define==1)// esto provoca que si quieres hacer un define de una palabra
		      is_define=2;                   // ya existente, lo ignore

		    if (def_db != NULL && is_define==0)
		      while (cursor.l_line != NULL && word[0]!='\0')     // mientras encuentre palabras de tipo
			{
			  cedit_get_next_variable (cedit, &cursor, word, &pointer, &depth);
			  cedit_get_this_real_char(cedit, &cursor, &ch, &flag);
			  //			  g_print("%c",ch);
			  //			  cedit_get_next_function_variable (cedit, &cursor, word, &pointer, &depth);
			  if (cedit_strcmp (word, "") != 0)// && ch!=')') // si el tipo era void, ahora no habra nombre de variable
			    {
			      // lo inserto
			      def_db=cedit_insert_definition_word (cedit, word, cedit_dw_variable, def_db, pointer, 1, 
								   NULL, 0, cursor.y, filename,
								   cedit_search_min_boundary(cedit, cursor,1, depth), 
								   cedit_search_max_boundary(cedit, cursor,1, depth),
								   incl_db);
			      
			      
			      definition_args[n_args]=def_db;
			      n_args ++;
			      // busco el tipo del siguiente argumento
			      //			      cedit_get_next_word (cedit, &cursor, word, &depth);
			      cedit_get_next_variable (cedit, &cursor, word, &pointer, &depth);
			      def_db = cedit_search_db_value (cedit, word,cursor.y,0); // tipo para la siguiente variable
			      //			      if (def_db == NULL) break;
			    }
			}
		    // inserto la funcion                
		    cedit_insert_definition_word (cedit, function_name, cedit_dw_function, 
						  function_def_db, function_pointer,0, definition_args,n_args, 
						  function_cursor.y,  filename,
						  cedit_search_min_boundary(cedit, function_cursor,0, depth), 
						  cedit_search_max_boundary(cedit, function_cursor,0, depth),
						  incl_db);
		  }	      
		else
		  {		    
		    while (strlen(word)>0)
		      {
			if (is_typedef==0)
			  cedit_insert_definition_word (cedit, word, cedit_dw_variable, def_db, pointer,0,NULL, 0, 
							cursor.y, filename, 
							cedit_search_min_boundary(cedit, cursor,0, depth), 
							cedit_search_max_boundary(cedit, cursor,0, depth),
							incl_db);
			else // inserto la informacion del padre (def_db)
			  cedit_insert_definition_word (cedit, word, cedit_dw_typedef, def_db, pointer,0,NULL, 0, 
							cursor.y, filename, 
							cedit_search_min_boundary(cedit, cursor,0, depth), 
							cedit_search_max_boundary(cedit, cursor,0, depth),
							incl_db);

			  

			cedit_get_next_variable (cedit, &cursor, word, &pointer, &depth);  // por si hay mas -> int a,b,c,d;
			if (cursor.l_line==NULL) 
			  {
			    g_mutex_unlock (cedit -> mutex_text);
			    free(word);
			    free(definition_args);
			    return;
			  }
		      }
		  }
	      }	  
	    else if (def_db -> type == cedit_dw_struct && cursor.l_line != NULL) // si es de un tipo estructura la analizo recursivamente
	      {
		if (cedit_strcmp(word,"struct")==0 || cedit_strcmp(word,"union")==0)
		  def_db=cedit_new_struct(cedit, &cursor, word, &depth, filename, incl_db);
		else if (cedit_strcmp(word,"enum")==0)
		  def_db=cedit_new_enum(cedit, &cursor, word, &depth, filename, incl_db);
		else 
		  {
		    g_mutex_unlock (cedit -> mutex_text);
		    continue;
		  }

		if (cursor.l_line==NULL)
		  {
		    g_mutex_unlock (cedit -> mutex_text);
		    free(word);
		    free(definition_args);
		    return;
		  }
		
		while (strlen(word)>0)
		  {
		    if (is_typedef==0)
		      cedit_insert_definition_word (cedit, word, cedit_dw_variable, def_db, pointer,0,NULL, 0,
						    cursor.y, filename, 
						    cedit_search_min_boundary(cedit, cursor,0,depth), 
						    cedit_search_max_boundary(cedit, cursor,0,depth),
						    incl_db);
		    else
		      cedit_insert_definition_word (cedit, word, cedit_dw_typedef, def_db, pointer,0,NULL, 0,
						    cursor.y, filename, 
						    cedit_search_min_boundary(cedit, cursor,0,depth), 
						    cedit_search_max_boundary(cedit, cursor,0,depth),
						    incl_db);
		    
		      
		    cedit_get_next_variable (cedit, &cursor, word, &pointer,&depth);  // por si hay mas -> int a,b,c,d;
		    if (cursor.l_line==NULL) 
		      {
			g_mutex_unlock (cedit -> mutex_text);
			free(word);
			free(definition_args);
			    return;		      
		      }	    
		  }		
	      }
	  }
	g_mutex_unlock (cedit -> mutex_text);

    }
    free(word);
    free(definition_args);
}



    // ---------------------------------------------------------------
    //  Busca el siguiente carÃÂ¡cter, lo pone en ch e incrementa x e y
    //   retorna la linea donde lo ha dejado
    // ---------------------------------------------------------------
int
cedit_get_next_char_word_definition (CEdit *cedit, CEditCursor *cursor, char *ch, int *depth)
{
  if (cursor->l_line->text[cursor->x]=='{' && !((cursor->l_line -> flags [cursor->x] & cedit_flag_comment) || 
						(cursor->l_line -> flags [cursor->x] & cedit_flag_line_comment) ||
						(cursor->l_line -> flags [cursor->x] & cedit_flag_macro) ||
						(cursor->l_line -> flags [cursor->x] & cedit_flag_apostrophe_text) || 
						(cursor->l_line -> flags [cursor->x] & cedit_flag_text)))
      (*depth)++;
  if (cursor->l_line->text[cursor->x]=='}' && !((cursor->l_line -> flags [cursor->x] & cedit_flag_comment) || 
						(cursor->l_line -> flags [cursor->x] & cedit_flag_line_comment) ||
						(cursor->l_line -> flags [cursor->x] & cedit_flag_macro) ||
						(cursor->l_line -> flags [cursor->x] & cedit_flag_apostrophe_text) || 
						(cursor->l_line -> flags [cursor->x] & cedit_flag_text)))
    (*depth)--;

    cursor->x ++;
    while (cursor->x >= cursor->l_line -> num_char)
    {
        cursor->x = 0;
        cursor->y ++;
        cursor->l_line = cursor->l_line -> next;
        if (cursor->l_line == NULL)
            return 0;
    }
    *ch = cursor->l_line -> text [cursor->x];
    return 0;
}

    // -----------------------------------------------------------------------
    //  Devuelve si es un caracter valido (que no sea un texto, o comentario)
    // -----------------------------------------------------------------------
int cedit_is_normal_char (CEdit *cedit, line *l_line, long x)
{
    if (!(l_line -> flags [x] & cedit_flag_comment) && !(l_line -> flags [x] & cedit_flag_line_comment) &&
        !(l_line -> flags [x] & cedit_flag_apostrophe_text) && !(l_line -> flags [x] & cedit_flag_text))
    return 0;
    return 1;
}

    // devuelve la siguiente palabra
// es igual que la siguiente definicion, pero esta no se salta las palabras innecesarios (cedit_dw_nothing)
int cedit_get_next_word_correct (CEdit *cedit, CEditCursor *cursor, char *word, int *depth)
{
    char ch;
    int flag;
    int i;
    
    if (cursor->l_line == NULL) return -1;
    word[0]='\0';

    cedit_get_real_char (cedit, cursor, depth);
    if (cursor->l_line == NULL) return -1;
    if (cursor->x == cursor->l_line -> num_char)
    {
        ch =' ';
        flag = 0;
    }
    else
    {
        ch = cursor->l_line -> text [cursor->x];
        flag = cursor->l_line -> flags [cursor->x];
    }
    
        // me salto los signos y demas, solo espero un caracter
    while (!((ch >='a' && ch <='z') || (ch >='A' && ch <='Z') || (ch =='_')))
    {
        cedit_get_next_real_char (cedit, cursor, depth);
        if (cursor->l_line == NULL) return -1;
        if (cursor->x == cursor->l_line -> num_char)
        {
            ch =' ';
            flag = 0;
        }
        else
        {
            ch = cursor->l_line -> text [cursor->x];
            flag = cursor->l_line -> flags [cursor->x];
        }
    }
    
        // ahora empieza una palabra
    i = 0;
    while ((ch >='a' && ch <='z') || (ch >='A' && ch <='Z') || (ch =='_') || (ch >='0' && ch <='9'))
    {
        word [i] = ch;
        i ++;

	cursor->x++;
	if (cursor->x==cursor->l_line->num_char)
	  {
	    word[i]='\0';
	    break;
	  }
	ch = cursor->l_line -> text [cursor->x];
    }

    
        // miro ahora si despues de la palabra hay un (
    cedit_skip_space (cedit, cursor, depth);
    cedit_get_real_char (cedit, cursor, depth);
    if (cursor->l_line == NULL)
      {
	word[i]='\0';
	return -1;
      }
    if (cursor->x == cursor->l_line -> num_char)
        ch =' ';
    else
        ch = cursor->l_line -> text [cursor->x];
    
    while (ch ==' ' || ch=='*' || ch=='&')
      {
	cedit_get_next_real_char (cedit, cursor, depth);
	if (cursor->l_line == NULL)
	  {
	    word[i]='\0';
	    return -1;
	  }
	if (cursor->x == cursor->l_line -> num_char)
	  ch =' ';
	else
	  ch = cursor->l_line -> text [cursor->x];
      }

    if (ch =='(') // si lo hay, lo pongo en la palabra, para indicar que es una funcion
    {
        word [i] ='(';
        i ++;
    }
    
    word [i] ='\0'; // fin de la palabra
    
    return 0;
}

    // devuelve la siguiente palabra
int cedit_get_next_word (CEdit *cedit, CEditCursor *cursor, char *word, int *depth)
{
    char ch;
    int flag;
    int i;
    definition_db *def_db;
    
    if (cursor->l_line == NULL) return -1;
    word[0]='\0';

    cedit_get_real_char (cedit, cursor, depth);
    if (cursor->l_line == NULL) return -1;
    if (cursor->x == cursor->l_line -> num_char)
    {
        ch =' ';
        flag = 0;
    }
    else
    {
        ch = cursor->l_line -> text [cursor->x];
        flag = cursor->l_line -> flags [cursor->x];
    }
    
        // me salto los signos y demas, solo espero un caracter
    while (!((ch >='a' && ch <='z') || (ch >='A' && ch <='Z') || (ch =='_')))
    {
        cedit_get_next_real_char (cedit, cursor, depth);
        if (cursor->l_line == NULL) return -1;
        if (cursor->x == cursor->l_line -> num_char)
        {
            ch =' ';
            flag = 0;
        }
        else
        {
            ch = cursor->l_line -> text [cursor->x];
            flag = cursor->l_line -> flags [cursor->x];
        }
    }
    
        // ahora empieza una palabra
    i = 0;
    while ((ch >='a' && ch <='z') || (ch >='A' && ch <='Z') || (ch =='_') || (ch >='0' && ch <='9'))
    {
        word [i] = ch;
        i ++;
	//        l_line = cedit_get_next_real_char (cedit, l_line, x, y);
	cursor->x++;
	if (cursor->x==cursor->l_line->num_char)
	  {
	    word[i]='\0';
	    break;
	  }
	

	//        if (l_line == NULL) return NULL;
	//        if ((*x) == l_line -> num_char)  // si estoy al final de la linea, la palabra se ha acabado: no se pueden partir
	//        {
	//	  word[i]='\0';
	//  return l_line;
	  //            ch =' ';
	  //            flag = 0;
	//        }
	//        else
	//        {
            ch = cursor->l_line -> text [cursor->x];
	    //            flag = l_line -> flags [(*x)];
	    //        }
    }

    
        // miro ahora si despues de la palabra hay un (
    cedit_skip_space (cedit, cursor, depth);
    cedit_get_real_char (cedit, cursor, depth);
    if (cursor->l_line == NULL)
      {
	word[i]='\0';
	return -1;
      }
    if (cursor->x == cursor->l_line -> num_char)
        ch =' ';
    else
        ch = cursor->l_line -> text [cursor->x];
    
    while (ch ==')' || ch ==' ' || ch=='*' || ch=='&')
      {
	cedit_get_next_real_char (cedit, cursor, depth);
	if (cursor->l_line == NULL)
	  {
	    word[i]='\0';
	    return -1;
	  }
	if (cursor->x == cursor->l_line -> num_char)
	  ch =' ';
	else
	  ch = cursor->l_line -> text [cursor->x];
      }

    if (ch =='(') // si lo hay, lo pongo en la palabra, para indicar que es una funcion
    {
        word [i] ='(';
        i ++;
    }

    word [i] ='\0'; // fin de la palabra
    
    if (i>0) // si he encontrado una palabra
      {
	def_db = cedit_search_db_value(cedit, word, cursor->y,0);  
	if (def_db!=NULL)
	  if (def_db->type==cedit_dw_nothing)  // pero ha de ser ignorada
	    cedit_get_next_word (cedit, cursor, word, depth); // busco la siguiente
      }
    
    return 0;
}

    // Devuelve esta letra, ignora returns, comentarios y textos
int cedit_get_real_char (CEdit *cedit, CEditCursor *cursor, int *depth)
{
    cursor->x --;
    if (cursor->x>=0 && cursor->x<cursor->l_line->num_char)
      {
	if (cursor->l_line->text[cursor->x]=='}' && !((cursor->l_line -> flags [cursor->x] & cedit_flag_comment) || 
						      (cursor->l_line -> flags [cursor->x] & cedit_flag_line_comment) ||
						      (cursor->l_line -> flags [cursor->x] & cedit_flag_apostrophe_text) || 
						      (cursor->l_line -> flags [cursor->x] & cedit_flag_macro) ||
						      (cursor->l_line -> flags [cursor->x] & cedit_flag_text)))
	  (*depth)++;
	if (cursor->l_line->text[cursor->x]=='{' && !((cursor->l_line -> flags [cursor->x] & cedit_flag_comment) || 
						      (cursor->l_line -> flags [cursor->x] & cedit_flag_line_comment) ||
						      (cursor->l_line -> flags [cursor->x] & cedit_flag_macro) ||
						      (cursor->l_line -> flags [cursor->x] & cedit_flag_apostrophe_text) || 
						      (cursor->l_line -> flags [cursor->x] & cedit_flag_text)))
	  (*depth)--;
      }
    return cedit_get_next_real_char (cedit, cursor, depth);
}

    // Devuelve la siguiente letra, ignora returns, comentarios y textos
int cedit_get_next_real_char (CEdit *cedit, CEditCursor *cursor, int *depth)
{
  if (cedit==NULL) return -1;
  if (cursor->l_line==NULL) return -1;

  if (cursor->x>=0 && cursor->x<cursor->l_line->num_char)
    {
	if (cursor->l_line->text[cursor->x]=='{')
	  if (!((cursor->l_line -> flags [cursor->x] & cedit_flag_comment) || 
		(cursor->l_line -> flags [cursor->x] & cedit_flag_line_comment) ||
		(cursor->l_line -> flags [cursor->x] & cedit_flag_macro) ||
		(cursor->l_line -> flags [cursor->x] & cedit_flag_apostrophe_text) || 
		(cursor->l_line -> flags [cursor->x] & cedit_flag_text)))
	  (*depth)++;
	if (cursor->l_line->text[cursor->x]=='}')
	  if (!((cursor->l_line -> flags [cursor->x] & cedit_flag_comment) || 
		(cursor->l_line -> flags [cursor->x] & cedit_flag_line_comment) ||
		(cursor->l_line -> flags [cursor->x] & cedit_flag_macro) ||
		(cursor->l_line -> flags [cursor->x] & cedit_flag_apostrophe_text) || 
		(cursor->l_line -> flags [cursor->x] & cedit_flag_text)))
	  (*depth)--;
    }
  cursor->x ++;
    
        // si me he pasado por la izquierda, voy a la siguiente linea
    while (cursor->x > cursor->l_line -> num_char)
    {
        cursor->x = 0;
        cursor->y ++;
        cursor->l_line = cursor->l_line -> next;
        if (cursor->l_line == NULL) return -1;
    }
    while ((cursor->x < cursor->l_line -> num_char &&
            ((cursor->l_line -> flags [cursor->x] & cedit_flag_comment) || 
	     (cursor->l_line -> flags [cursor->x] & cedit_flag_line_comment) ||
	     (cursor->l_line -> flags [cursor->x] & cedit_flag_apostrophe_text) || 
	    (cursor->l_line -> flags [cursor->x] & cedit_flag_text))))
	   //	   ||
	   //	   ((*x)>0 && (*x)==l_line->num_char && 
	   //	    ((l_line -> flags [(*x) - 1] & cedit_flag_comment) || (l_line -> flags [(*x) - 1] & cedit_flag_line_comment) ||
	   //	     (l_line -> flags [(*x) - 1] & cedit_flag_apostrophe_text) || (l_line -> flags [(*x) - 1] & cedit_flag_text))))
      //	   || 
      //	   ((*x==0) && (*x)==l_line->num_char))
      {
	if (cursor->l_line->text[cursor->x]=='{')
	  if (!((cursor->l_line -> flags [cursor->x] & cedit_flag_comment) || 
		(cursor->l_line -> flags [cursor->x] & cedit_flag_line_comment) ||
		(cursor->l_line -> flags [cursor->x] & cedit_flag_apostrophe_text) || 
		(cursor->l_line -> flags [cursor->x] & cedit_flag_macro) ||
		(cursor->l_line -> flags [cursor->x] & cedit_flag_text)))
	  (*depth)++;
	if (cursor->l_line->text[cursor->x]=='}')
	  if (!((cursor->l_line -> flags [cursor->x] & cedit_flag_comment) || 
		(cursor->l_line -> flags [cursor->x] & cedit_flag_line_comment) ||
		(cursor->l_line -> flags [cursor->x] & cedit_flag_macro) ||
		(cursor->l_line -> flags [cursor->x] & cedit_flag_apostrophe_text) || 
		(cursor->l_line -> flags [cursor->x] & cedit_flag_text)))
	  (*depth)--;

        cursor->x ++;
        while (cursor->x > cursor->l_line -> num_char)
	       //||
	       //	       ((*x)==l_line->num_char && (*x)==0))
        {
            cursor->x = 0;
            cursor->y ++;
            cursor->l_line = cursor->l_line -> next;
            if (cursor->l_line == NULL) return -1;
        }
    }
    return 0;
}

    // Se salta los espacios en blanco
int cedit_skip_space (CEdit *cedit, CEditCursor *cursor, int *depth)
{
    char ch;
    
    ch = 0;
    if (cursor->l_line == NULL) return -1;
    cedit_get_real_char (cedit, cursor, depth);
    if (cursor->l_line == NULL) return -1;
    if (cursor->x == cursor->l_line -> num_char)
        ch =' ';
    else
        ch = cursor->l_line -> text [cursor->x];
    
    while (ch == ' ')
    {
        cursor->x ++;
        if (cursor->l_line == NULL) return -1;
        if (cursor->x == cursor->l_line -> num_char)
            ch =' ';
        else
            ch = cursor->l_line -> text [cursor->x];
    }
    return 0;
}
    // devuelve la siguiente palabra, para si encuentra una "," o un ";"
int cedit_get_next_variable (CEdit *cedit, CEditCursor *cursor, char *word, char *pointer,int *depth)
{
    char ch;
    int flag;
    int prev_depth;
    int ret;
    definition_db *def_db;
    
    ch = 0;
    prev_depth=(*depth);
    cedit_skip_space (cedit, cursor, depth);
    cedit_get_real_char (cedit, cursor, depth);    
    if (cursor->l_line == NULL) 
       {
	word[0]='\0';
	return -1;
      }
    if (cursor->x == cursor->l_line -> num_char)
    {
        ch =' ';
        flag = 0;
    }
    else
    {
         ch = cursor->l_line -> text [cursor->x];
        flag = cursor->l_line -> flags [cursor->x];
    }

    /*
    if (ch==';') // si la letra en la que estoy es esta, me la salto
      {
	cedit_get_next_real_char (cedit, cursor, depth);    
	word[0]='\0';
	return -1;
      }
    if (cursor->l_line == NULL) 
       {
	word[0]='\0';
	return -1;
      }
    if (cursor->x == cursor->l_line -> num_char)
    {
        ch =' ';
        flag = 0;
    }
    else
    {
         ch = cursor->l_line -> text [cursor->x];
        flag = cursor->l_line -> flags [cursor->x];
    }
    */
    
    (*pointer) = 0;
    while (ch!='=' && ch !=';' && !((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_')) // ya no hay mas definiciones
    {
      // si es un ) salgo, porque tengo algo asi como: (int) a; que no es una definicion de una variable
      if (prev_depth<(*depth))
	{
	  word [0] ='\0';
	  return -1;
	}
      if (ch =='*' || ch =='&') // es un puntero, ademas de guardarlo, me salto a la siguiente letra
	  (*pointer)=1;

      cedit_get_next_real_char (cedit, cursor, depth);    
      if (cursor->l_line == NULL) {
	word[0]='\0';
	return -1;
      }
      if (cursor->x == cursor->l_line -> num_char)
	{
	  ch =' ';
	  flag = 0;
	}
      else
	{
	  ch = cursor->l_line -> text [cursor->x];
	  flag = cursor->l_line -> flags [cursor->x];
	}
    }

    if (ch==';' || ch=='=')
      {
	word [0] ='\0';
        return -1;
      }

    
    /*    if (ch ==',') // si hay este caracter, lo descarto
    {
        l_line = cedit_get_next_real_char (cedit, l_line, x, y);
        if (l_line == NULL) return NULL;
        if ((*x) == l_line -> num_char)
        {
            ch =' ';
            flag = 0;
        }
        else
        {
            ch = l_line -> text [(*x)];
            flag = l_line -> flags [(*x)];
        }
        l_line = cedit_skip_space (cedit, l_line, x, y);
        if (l_line == NULL) return NULL;
    }
    */
    /*    
    (*pointer) = 0;
    if (ch =='*' || ch =='&') // es un puntero, ademas de guardarlo, me salto a la siguiente letra
    {
        cedit_get_next_real_char (cedit, cursor, depth);
        if (cursor->l_line == NULL) 
	  {
	    word[0]='\0';
	    return -1;
	  }
        if (cursor->x == cursor->l_line -> num_char)
        {
            ch =' ';
            flag = 0;
        }
        else
        {
            ch = cursor->l_line -> text [cursor->x];
            flag = cursor->l_line -> flags [cursor->x];
        }
        cedit_skip_space (cedit, cursor, depth);
        (*pointer) = 1;
        if (cursor->l_line == NULL)
	  {
	    word[0]='\0';
	    return -1;
	  }
    }
    */

    
        // si sigo aqui, ahora viene la palabra que es la definiciÃÂ³n
    ret = cedit_get_next_word_correct (cedit, cursor, word, depth); // cojo la primera palabra

    // si la que he encontrado no es nada, busco otra
    if (strlen(word)>0) // si he encontrado una palabra
      {
	def_db = cedit_search_db_value(cedit, word, cursor->y,0);  
	if (def_db!=NULL)
	  if (def_db->type==cedit_dw_nothing)  // pero ha de ser ignorada
	    ret= cedit_get_next_variable (cedit, cursor, word, pointer, depth);
      }
    return ret;

}

    // devuelve la siguiente palabra, para si encuentra una "," o un ";", los = se los salta
int cedit_get_next_variable_enum (CEdit *cedit, CEditCursor *cursor, char *word, char *pointer,int *depth)
{
    char ch;
    int flag;
    int prev_depth;
    int ret;
    definition_db *def_db;
    
    ch = 0;
    prev_depth=(*depth);
    cedit_skip_space (cedit, cursor, depth);
    cedit_get_real_char (cedit, cursor, depth);    
    if (cursor->l_line == NULL) 
       {
	word[0]='\0';
	return -1;
      }
    if (cursor->x == cursor->l_line -> num_char)
    {
        ch =' ';
        flag = 0;
    }
    else
    {
         ch = cursor->l_line -> text [cursor->x];
        flag = cursor->l_line -> flags [cursor->x];
    }

    
    (*pointer) = 0;
    while (ch !=';' && !((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_')) // ya no hay mas definiciones
    {
      // si es un ) salgo, porque tengo algo asi como: (int) a; que no es una definicion de una variable
      if (prev_depth<(*depth))
	{
	  word [0] ='\0';
	  return -1;
	}
      if (ch =='*' || ch =='&') // es un puntero, ademas de guardarlo, me salto a la siguiente letra
	  (*pointer)=1;

      cedit_get_next_real_char (cedit, cursor, depth);    
      if (cursor->l_line == NULL) {
	word[0]='\0';
	return -1;
      }
      if (cursor->x == cursor->l_line -> num_char)
	{
	  ch =' ';
	  flag = 0;
	}
      else
	{
	  ch = cursor->l_line -> text [cursor->x];
	  flag = cursor->l_line -> flags [cursor->x];
	}
    }

    if (ch==';')
      {
	word [0] ='\0';
        return -1;
      }

    
    
        // si sigo aqui, ahora viene la palabra que es la definiciÃÂ³n
    ret = cedit_get_next_word_correct (cedit, cursor, word, depth); // cojo la primera palabra

    // si la que he encontrado no es nada, busco otra
    if (strlen(word)>0) // si he encontrado una palabra
      {
	def_db = cedit_search_db_value(cedit, word, cursor->y,0);  
	if (def_db!=NULL)
	  if (def_db->type==cedit_dw_nothing)  // pero ha de ser ignorada
	    ret= cedit_get_next_variable (cedit, cursor, word, pointer, depth);
      }
    return ret;

}

    // devuelve la siguiente palabra, para si encuentra un salto de linea y no se salta palabras sin significado
int cedit_get_next_define_word (CEdit *cedit, CEditCursor *cursor, char *word,int *depth)
{
    char ch;
    int flag;
    int prev_depth;
    long last_char_pos;
    
    ch = 0;
    prev_depth=(*depth);
    cedit_skip_space (cedit, cursor, depth);
    cedit_get_real_char (cedit, cursor, depth);    
    if (cursor->l_line == NULL) 
       {
	word[0]='\0';
	return -1;
      }
    if (cursor->x == cursor->l_line -> num_char)
    {
      last_char_pos=cedit_get_last_char_pos(cedit, cursor->l_line);
      if (cursor->l_line->num_char>last_char_pos)
	{
	  if (cursor->l_line->text[last_char_pos]=='\\')
	    {
	      ch=' ';
	      flag=0;
	    }
	  else
	    {
	      word[0]='\0';
	      return -1;
	    }
	}
      else
	{
	  word[0]='\0';
	  return -1;
	}
    }
    else
    {
      ch = cursor->l_line -> text [cursor->x];
      flag = cursor->l_line -> flags [cursor->x];
    }

    while (!((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_')) // ya no hay mas definiciones
    {
      // si es un ) salgo, porque tengo algo asi como: (int) a; que no es una definicion de una variable
      if (prev_depth<(*depth))
	{
	  word [0] ='\0';
	  return -1;
	}

      cedit_get_next_real_char (cedit, cursor, depth);    
      if (cursor->l_line == NULL) {
	word[0]='\0';
	return -1;
      }
      if (cursor->x == cursor->l_line -> num_char)
	{
	  last_char_pos=cedit_get_last_char_pos(cedit, cursor->l_line);
	  if (cursor->l_line->num_char>last_char_pos)
	    {
	      if (cursor->l_line->text[last_char_pos]=='\\')
		{
		  ch=' ';
		  flag=0;
		}
	      else
		{
		  word[0]='\0';
		  return -1;
		}
	    }
	  else
	    {
	      word[0]='\0';
	      return -1;
	    }
	}
      else
	{
	  ch = cursor->l_line -> text [cursor->x];
	  flag = cursor->l_line -> flags [cursor->x];
	}
    }

    // si sigo aqui, ahora viene la palabra que es la definiciÃÂ³n
    return cedit_get_next_word_correct (cedit, cursor, word, depth);
    // cuidado, es (pa q tire) next_word (cedit...)
}

    // devuelve la siguiente palabra, para si encuentra una "," o un ";" se la salta
int cedit_get_next_struct_variable (CEdit *cedit, CEditCursor *cursor, char *word, char *pointer,int *depth)
{
    char ch;
    int flag;
    int prev_depth;
    
    ch = 0;
    prev_depth=(*depth);
    cedit_skip_space (cedit, cursor, depth);
    cedit_get_real_char (cedit, cursor, depth);    
    if (cursor->l_line == NULL) 
       {
	word[0]='\0';
	return -1;
      }
    if (cursor->x == cursor->l_line -> num_char)
    {
        ch =' ';
        flag = 0;
    }
    else
    {
         ch = cursor->l_line -> text [cursor->x];
        flag = cursor->l_line -> flags [cursor->x];
    }

    
    if (ch==';') // si la letra en la que estoy es esta, me la salto
      {
	cedit_get_next_real_char (cedit, cursor, depth);    
	word[0]='\0';
	return -1;
      }
    if (cursor->l_line == NULL) 
       {
	word[0]='\0';
	return -1;
      }
    if (cursor->x == cursor->l_line -> num_char)
    {
        ch =' ';
        flag = 0;
    }
    else
    {
         ch = cursor->l_line -> text [cursor->x];
        flag = cursor->l_line -> flags [cursor->x];
    }
    
    
    (*pointer) = 0;
    while (ch !=';' && !((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_')) // ya no hay mas definiciones
    {
      // si es un ) salgo, porque tengo algo asi como: (int) a; que no es una definicion de una variable
      if (prev_depth<(*depth))
	{
	  word [0] ='\0';
	  return -1;
	}
      if (ch =='*' || ch =='&') // es un puntero, ademas de guardarlo, me salto a la siguiente letra
	  (*pointer)=1;

      cedit_get_next_real_char (cedit, cursor, depth);    
      if (cursor->l_line == NULL) {
	word[0]='\0';
	return -1;
      }
      if (cursor->x == cursor->l_line -> num_char)
	{
	  ch =' ';
	  flag = 0;
	}
      else
	{
	  ch = cursor->l_line -> text [cursor->x];
	  flag = cursor->l_line -> flags [cursor->x];
	}
    }

    if (ch==';')
      {
	word [0] ='\0';
        return -1;
      }

    
    /*    if (ch ==',') // si hay este caracter, lo descarto
    {
        l_line = cedit_get_next_real_char (cedit, l_line, x, y);
        if (l_line == NULL) return NULL;
        if ((*x) == l_line -> num_char)
        {
            ch =' ';
            flag = 0;
        }
        else
        {
            ch = l_line -> text [(*x)];
            flag = l_line -> flags [(*x)];
        }
        l_line = cedit_skip_space (cedit, l_line, x, y);
        if (l_line == NULL) return NULL;
    }
    */
    /*    
    (*pointer) = 0;
    if (ch =='*' || ch =='&') // es un puntero, ademas de guardarlo, me salto a la siguiente letra
    {
        cedit_get_next_real_char (cedit, cursor, depth);
        if (cursor->l_line == NULL) 
	  {
	    word[0]='\0';
	    return -1;
	  }
        if (cursor->x == cursor->l_line -> num_char)
        {
            ch =' ';
            flag = 0;
        }
        else
        {
            ch = cursor->l_line -> text [cursor->x];
            flag = cursor->l_line -> flags [cursor->x];
        }
        cedit_skip_space (cedit, cursor, depth);
        (*pointer) = 1;
        if (cursor->l_line == NULL)
	  {
	    word[0]='\0';
	    return -1;
	  }
    }
    */
    
        // si sigo aqui, ahora viene la palabra que es la definiciÃÂ³n
    return cedit_get_next_word (cedit, cursor, word, depth);
}

    // devuelve la siguiente palabra, para si encuentra una "," o un ";"
/*
int cedit_get_next_function_variable (CEdit *cedit, CEditCursor *cursor, char *word, char *pointer, int *depth)
{
    char ch;
    int flag;
    
    ch = 0;
    cedit_skip_space (cedit, cursor, depth);
    cedit_get_real_char (cedit, cursor, depth);
    
    if (cursor->l_line == NULL)
      {
	word[0]='\0';
	return -1;
      }
    if (cursor->x == cursor->l_line -> num_char)
    {
        ch =' ';
        flag = 0;
    }
    else
    {
        ch = cursor->l_line -> text [cursor->x];
        flag = cursor->l_line -> flags [cursor->x];
    }
    
    if (ch ==';' || ch==')') // ya no hay mas definiciones
    {
        word [0] ='\0';
        return -1;
    }
    
    if (ch ==',') // si hay este caracter, lo descarto
    {
        cedit_get_next_real_char (cedit, cursor, depth);
        if (cursor->l_line == NULL)
	  {
	    word[0]='\0';
	    return -1;
	  }
        if (cursor->x == cursor->l_line -> num_char)
        {
            ch =' ';
            flag = 0;
        }
        else
        {
            ch = cursor->l_line -> text [cursor->x];
            flag = cursor->l_line -> flags [cursor->x];
        }
        cedit_skip_space (cedit, cursor, depth);
        if (cursor->l_line == NULL) 
	  {
	    word[0]='\0';
	    return -1;
	  }
    }
    
    (*pointer) = 0;
    if (ch =='*' || ch =='&') // es un puntero, ademas de guardarlo, me salto a la siguiente letra
    {
        cedit_get_next_real_char (cedit, cursor, depth);
        if (cursor->l_line == NULL)
	  {
	    word[0]='\0';
	    return -1;
	  }
        if (cursor->x == cursor->l_line -> num_char)
        {
            ch =' ';
            flag = 0;
        }
        else
        {
            ch = cursor->l_line -> text [cursor->x];
            flag = cursor->l_line -> flags [cursor->x];
        }
        cedit_skip_space (cedit, cursor, depth);
        (*pointer) = 1;
        if (cursor->l_line == NULL) 
	  {
	    word[0]='\0';
	    return -1;
	  }
    }
    
    
    word[0]='\0';
        // si sigo aqui, ahora viene la palabra que es la definiciÃÂ³n
    return cedit_get_next_word (cedit, cursor, word, depth);
}
*/
    // ---------------------------------------
    //  inserta una nueva definicion en la bd
    // ---------------------------------------
definition_db *cedit_insert_definition_word (CEdit *cedit, 
					     char *name, 
					     int type, 
					     definition_db *father, 
					     int pointer, 
					     char is_function_variable,
					     definition_db **args_father, 
					     int n_args, 
					     long n_line, 
					     char *file, 
					     long min_bound, 
					     long max_bound,
					     include_db *incl_db)
{ 
  definition_db *def_db;
  int i;
    char *key;
  char text[1000];
  int count;
  char name2[1000];

  if (cedit==NULL) return NULL;
  if (name==NULL && strlen(name)>0) return NULL;
  if (type<0 || type>7) return NULL;

  //  g_print("Inserto %s\n", name);

  strcpy(name2, name);
  if (name2[strlen(name2)-1]=='(') // las funciones son ignoradas
    name2[strlen(name2)-1]='\0';
  

  //  if (file!=NULL)
  //  if (file!=NULL)
  //  if (strcmp(file, "/opt/garnome/include/gtk-2.0/gtk/gtkmessagedialog.h")==0)
  /*
    file[10000000]='0';
  */

  
  if (file!=NULL && is_function_variable==0)
    {
      min_bound=-1;
      max_bound=-1;
    }
  

    // busco primero que no este ya incluido, para no repetir


  count=0;
  // las palabras se almacenan como texto y numero
  sprintf(text, "%s%d",name2,count);
  def_db=g_tree_lookup (cedit -> words_db, text);
  while (def_db!=NULL)
    {
      /*
      if (type==def_db->type && 
	  n_args==def_db->n_args &&
	  min_bound==def_db->n_line_min_boundary &&
	  max_bound==def_db->n_line_max_boundary) // son iguales
	return def_db; // devuelvo el que hay, no inserto otro
*/
      
      //      if (strcmp(name,"gint")==0)
	//	{
      //	  if (type<=def_db->type &&
      //	      min_bound==def_db->n_line_min_boundary &&
      //	      max_bound==def_db->n_line_max_boundary) // son iguales (mas restrictivo)
      //	    return def_db; // devuelvo el que hay, no inserto otro
	  //	}

      if (file!=NULL && def_db->file!=NULL)
	{
	  if (type<=def_db->type &&
	      min_bound==def_db->n_line_min_boundary &&
	      max_bound==def_db->n_line_max_boundary &&
	      cedit_strcmp(file,def_db->file)==0  && def_db->is_deleted==0) // son iguales (mas restrictivo)
	    return def_db; // devuelvo el que hay, no inserto otro
	}
      else if (type<=def_db->type &&
	       min_bound==def_db->n_line_min_boundary &&
	       max_bound==def_db->n_line_max_boundary &&
	       file==NULL && def_db->file==NULL  && def_db->is_deleted==0) // son iguales (mas restrictivo)
	return def_db; // devuelvo el que hay, no inserto otro
      /*      else if (type==cedit_dw_data_type && def_db->type==cedit_dw_data_type) // las redefiniciones de estructuras son como typedef
	{
	  type=cedit_dw_typedef;
	  father=def_db;
	}
      */
      count++;
      sprintf(text, "%s%d",name2,count);
      def_db=g_tree_lookup (cedit -> words_db, text);
    }
  
    def_db = NULL;
    def_db =(definition_db *) malloc (sizeof (definition_db));
    if (def_db == NULL) return NULL;
     
    def_db -> name = strdup(name2);
    if (def_db -> name == NULL)
    {
        free (def_db);
        return NULL;
    }

    def_db->typedef_name=NULL;
    if (type==cedit_dw_typedef && father!=NULL)
      if (father->name!=NULL)
	{
	  //	  def_db -> typedef_name =(char *) malloc ((strlen (father->name)+5) *sizeof (char));
	  def_db->typedef_name=strdup(father->name);
	  if (def_db -> typedef_name == NULL)
	    {
	      free (def_db->name);
	      free (def_db);
	      return NULL;
	    }
	  //	  strcpy(def_db->typedef_name, father->name);
	}
    

    //    strcpy (def_db -> name, name);

    def_db -> name_long = strlen (name2);
    def_db -> type = type;

    
    if (n_args >0)
    {
	def_db->definition_type_args=NULL;
        def_db -> definition_type_args =(definition_db **) malloc (n_args *sizeof (definition_db *));
        if (def_db -> definition_type_args == NULL)
        {
            free (def_db -> typedef_name);
            free (def_db -> name);
            free (def_db);
            return NULL;
        }
        for (i = 0; i < n_args; i ++)
        {
	    if (args_father!=NULL)
	      def_db->definition_type_args[i]=args_father[i];
        }
    }
    else
    {
	def_db->definition_type_args=NULL;
    }
    def_db->n_args=n_args;
    
    def_db -> definition_type = father;
    def_db -> n_line = n_line;
    def_db->file=NULL;
    
    if (file!=NULL)
      {
	//	def_db->file=(char*)malloc(strlen(file)*sizeof(char)+5);
	def_db->file=strdup(file);
	if (def_db->file==NULL)
	  {
	    free(def_db->name);
	    free(def_db->typedef_name);
	    free(def_db);	
	  }
	//	strcpy(def_db->file, file);
      }
    def_db -> n_line_min_boundary = min_bound;
    def_db -> n_line_max_boundary = max_bound;
    def_db->is_deleted=0;
    
    key=strdup(text);
    // reservo espacio para la palabra y 16 mas para ponerle un numero, con 16 sobra
        
    cedit_insert_db_value(cedit, key, def_db, incl_db);

    /*
    if (type==1) // si es 1, los define no los mira muy bien, por lo que mejor defino la variable y la funcion.
      {
	if (name[strlen(name)-1]=='(') // si es una funcion, ahora pongo el que no es funcion
	  {
	    name[strlen(name)-1]='\0';
	    def_db=cedit_search_db_value(cedit, name, n_line);
	    if (def_db==NULL)
	      {
		
	      }
	    
	  }
      }
    */
    return def_db;
}

// --------------------------------------------------------------------------------
//  inserta un valor en la base de datos, se usa esta funcion para que pueda haber
//  2 variables iguales, una global y otra local o diferentes locales con el mismo
//  nombre // --------------------------------------------------------------------------------
int cedit_insert_db_value(CEdit *cedit, char *key, definition_db *def_db, include_db *incl_db)
{
  int count;

  count=0;

  // formo la palabra que voy a guardar, que es la palabra original y un numero identificador y Ãºnico
  /*  sprintf(text, "%s%d",key,count);
  while (g_tree_lookup (cedit -> words_db, text)!=NULL)
    {
      count++;
      sprintf(text, "%s%d",key,count);
    }
  */
  // copio en key la palabra text, que es la siguiente libre
  // key ya tenia suficiente espacio para albergar el numero (16 char reservados)
  cedit->num_definition_words++;

  //  g_tree_insert (cedit -> words_db, key, def_db);
  //  if (incl_db==NULL) // si no estoy en un include
    g_tree_insert (cedit -> words_db, key, def_db);
    /*  else // si lo estoy
    {
      //      cedit->num_definition_words--;
      //      g_tree_insert (incl_db->db, key, def_db);      // inserto en memoria para luego
      //      g_tree_insert (cedit->words_db, strdup(key), cedit_copy_definition_db (cedit, def_db));   // y una copia en el principal
      //      g_tree_insert (cedit->words_db, key, def_db);   // y una copia en el principal
    }
    */
  return count;
}

// -------------------------------------------------------------------------------------
//  Busca una definicion, la peculiaridad es que la definicion es una definicion+numero
// -------------------------------------------------------------------------------------
definition_db *cedit_search_db_value(CEdit *cedit, char *key, long y, int depth)
{
  char text[1000];
  char key2[1000];
  int count;
  definition_db *def_db;
  definition_db *better_def_db;

  if (key==NULL) return NULL;
  if (strlen(key)==0) return NULL;
  if (depth>255 && depth<500) // si me he llamado recursivamente demasiado, paro (500 es especial, es q quiero buscar sin recursividad)
    return NULL;

  strcpy(key2,key);
  if (key2[strlen(key2)-1]=='(') // las funciones son ignoradas
    key2[strlen(key2)-1]='\0';

  count=0;

  // formo la palabra que voy a guardar, que es la palabra original y un numero identificador y Ãºnico
  sprintf(text, "%s%d",key2,count);
  def_db=g_tree_lookup (cedit -> words_db, text);
  while (def_db!=NULL)
    {
      if (((def_db->n_line_min_boundary<=y && def_db->n_line_max_boundary>=y) || // si la linea esta entre los limites
	  def_db->n_line_max_boundary==-1) && def_db->is_deleted==0)    // o es una variable global y no es un valor borrado
	{

	  /*
	  if (def_db->type==cedit_dw_typedef && def_db->typedef_name!=NULL)
	    {
	      return cedit_search_db_value(cedit, def_db->typedef_name, y);
	    }
	  */
	  
	  better_def_db=def_db;
	  
	  // ahora busco una definicion mejor, alguna que tenga mas argumentos o que tenga
	  // mayor , sino la encuentro
	  // pues dejo la que tengo
	      
	  count++;
	  sprintf(text, "%s%d",key2,count);
	  def_db=g_tree_lookup (cedit -> words_db, text);
	  while (def_db!=NULL)
	    {
	      if (((def_db->n_line_min_boundary<=y && def_db->n_line_max_boundary>=y) || // si la linea esta entre los limites
		  def_db->n_line_max_boundary==-1) && def_db->is_deleted==0)    // o es una variable global
		{
		  if (def_db->type > better_def_db->type)
		    better_def_db=def_db;
		  else if (def_db->n_args>better_def_db->n_args &&
			   def_db->type>=better_def_db->type)
		    better_def_db=def_db;
		  //		  else if (cedit_strcmp(def_db->file,file)==0)
		  //		    better_def_db=def_db;
		}
	      count++;
	      sprintf(text, "%s%d",key2,count);
	      def_db=g_tree_lookup (cedit -> words_db, text);
	    }

	  if (better_def_db->type==cedit_dw_typedef && better_def_db->typedef_name!=NULL) // si es de typedef, busco por el nombre de su tipo
	    {
	      //	      if (depth==500) depth=128; // si es el caso especial de 1 sola recursiva, necesito mas
	      if (cedit_strcmp(better_def_db->typedef_name,key2)!=0)
		return cedit_search_db_value(cedit, better_def_db->typedef_name, y, ++depth);
	      return better_def_db;
	      //	      if (def_db==NULL) continue;
	    }
	  return better_def_db;
	  
	}
      // busco la siguiente
      count++;
      sprintf(text, "%s%d",key2,count);
      def_db=g_tree_lookup (cedit -> words_db, text);
    }

  return NULL;
}

// -------------------------------------------------------------------------------------
//  Busca una definicion, la peculiaridad es que la definicion es una definicion+numero
//  esta funcion no tiene en cuenta variables locales-globales, todas son globales
// -------------------------------------------------------------------------------------
definition_db *cedit_search_db_value_extend(CEdit *cedit, char *key, long y, int depth)
{
  char text[1000];
  int count;
  definition_db *def_db;
  definition_db *better_def_db;

  if (key==NULL) return NULL;
  if (strlen(key)==0) return NULL;
  if (depth>255 && depth<500) // si me he llamado recursivamente demasiado, paro (500 es especial, es q quiero buscar sin recursividad)
    return NULL;

  if (key[strlen(key)-1]=='(') // las funciones son ignoradas
    key[strlen(key)-1]='\0';

  count=0;

  // formo la palabra que voy a guardar, que es la palabra original y un numero identificador y Ãºnico
  sprintf(text, "%s%d",key,count);
  def_db=g_tree_lookup (cedit -> words_db, text);
  while (def_db!=NULL)
    {
      if (def_db->is_deleted==0)
	better_def_db=def_db;
      else // busco otra
	{
	  count++;
	  sprintf(text, "%s%d",key,count);
	  def_db=g_tree_lookup (cedit -> words_db, text);
	  continue;
	}
      // ahora busco una definicion mejor, alguna que tenga mas argumentos o que tenga
      // mayor , sino la encuentro
      // pues dejo la que tengo
	      
      count++;
      sprintf(text, "%s%d",key,count);
      def_db=g_tree_lookup (cedit -> words_db, text);
      while (def_db!=NULL)
	{
	  if (def_db->n_args>better_def_db->n_args &&
	      def_db->type>=better_def_db->type  && def_db->is_deleted==0)
	    better_def_db=def_db;
	  if (def_db->type > better_def_db->type  && def_db->is_deleted==0)
	    better_def_db=def_db;

	  count++;
	  sprintf(text, "%s%d",key,count);
	  def_db=g_tree_lookup (cedit -> words_db, text);
	}
      
      if (better_def_db->type==cedit_dw_typedef && better_def_db->typedef_name!=NULL) // si es de typedef, busco por el nombre de su tipo
	{
	  if (cedit_strcmp(better_def_db->typedef_name,key)!=0)
	    return cedit_search_db_value(cedit, better_def_db->typedef_name, y, ++depth);
	  return better_def_db;
	}
      return better_def_db;
      
    }
  return NULL;
}

// ------------------------------------------------------------------
//  Busca el limite de accion de una variable (boundary), una global
//  sera todo el fichero, una local solo una funcion
// ------------------------------------------------------------------
long cedit_search_max_boundary(CEdit *cedit, CEditCursor cursor,char is_function, int depth)
{
  line *temp_line;
  long x,y;
  //  int depth;
  char init_function; // indica si ya hemos comenzado la funcion: a(int a,int b) {<- aqui vale 1

  if (cedit==NULL || cursor.l_line==NULL) return -2;

  // si es global, toy en profundidad 0, devolviendo -1 lo indico
  if (depth==0 && is_function==0) return -1;

  depth=0;
  temp_line=cursor.l_line;
  x=cursor.x;
  y=cursor.y;
  init_function=0;

  while (temp_line!=NULL)
    {
      if (is_function==1)
	{
	  if (temp_line->text[x]==';' && init_function==0) // si es int a(inc); el max boundary es y
	    return y;
	  if (temp_line->text[x]=='{')
	    if (!((temp_line -> flags [x] & cedit_flag_comment) || 
		  (temp_line -> flags [x] & cedit_flag_line_comment) ||
		  (temp_line -> flags [x] & cedit_flag_apostrophe_text) || 
		  (temp_line -> flags [x] & cedit_flag_text)))
	      {
		init_function=1;
		depth++;
	      }
	  if (temp_line->text[x]=='}')
	    if (!((temp_line -> flags [x] & cedit_flag_comment) || 
		  (temp_line -> flags [x] & cedit_flag_line_comment) ||
		  (temp_line -> flags [x] & cedit_flag_apostrophe_text) || 
		  (temp_line -> flags [x] & cedit_flag_text)))
	      {
		depth--;
		if (init_function==1 && depth<=0) break;
	      }
	}
      else
	{
	  if (temp_line->text[x]=='{')
	    if (!((temp_line -> flags [x] & cedit_flag_comment) || 
		  (temp_line -> flags [x] & cedit_flag_line_comment) ||
		  (temp_line -> flags [x] & cedit_flag_apostrophe_text) || 
		  (temp_line -> flags [x] & cedit_flag_text)))
	      depth++;
	  if (temp_line->text[x]=='}')
	    if (!((temp_line -> flags [x] & cedit_flag_comment) || 
		  (temp_line -> flags [x] & cedit_flag_line_comment) ||
		  (temp_line -> flags [x] & cedit_flag_apostrophe_text) || 
		  (temp_line -> flags [x] & cedit_flag_text)))
	      depth--;
	}
      if (depth<0) break;

      x++;
      while (x>=temp_line->num_char)
	{
	  x=0;
	  y++;
	  temp_line=temp_line->next;
	  if (temp_line==NULL)
	    {
	      return -1;
	    }
	}
    }

  if (temp_line==NULL) return -1;
  return y-1;
}

// ------------------------------------------------------------------
//  Busca el limite de accion de una variable (boundary), una global
//  sera todo el fichero, una local solo una funcion
// ------------------------------------------------------------------
long cedit_search_min_boundary(CEdit *cedit, CEditCursor cursor,char is_function, int depth)
{
  line *temp_line;
  long x,y;
  //  int depth;

  if (cedit==NULL || cursor.l_line==NULL) return -2;


    if (is_function==1)  // donde se define la variable de la funcion, es su minimo
        return (cursor.y-1);

  // si es global, toy en profundidad 0, devolviendo -1 lo indico
  if (depth==0 && is_function==0)
    return -1;

  depth=0;
  temp_line=cursor.l_line;
  x=cursor.x;
  y=cursor.y;
  
  // busco el primer } que encuentre que me lleve a depth<0
  while (temp_line!=NULL)
    {
      if (x<temp_line->num_char)
	{
	  if (temp_line->text[x]=='{' && !((temp_line -> flags [x] & cedit_flag_comment) || 
					   (temp_line -> flags [x] & cedit_flag_line_comment) ||
					   (temp_line -> flags [x] & cedit_flag_apostrophe_text) || 
					   (temp_line -> flags [x] & cedit_flag_text)))
	    depth--;
	  if (temp_line->text[x]=='}'&& !((temp_line -> flags [x] & cedit_flag_comment) || 
					  (temp_line -> flags [x] & cedit_flag_line_comment) ||
					  (temp_line -> flags [x] & cedit_flag_apostrophe_text) || 
					  (temp_line -> flags [x] & cedit_flag_text)))
	    depth++;
	  if (depth<0) break;
	}

      x--;
      while (x<0)
	{
	  temp_line=temp_line->prev;
	  if (temp_line==NULL) return -1;
	  x=temp_line->num_char-1;
	  y--;
	}
    }
  if (temp_line==NULL) return (y+1);
  if (y==0) return -1; // si esta en la linea 0, es que era global
  return y;
}



// -----------------------------------
//  funcin que coje las definiciones
// -----------------------------------
int cedit_new_define(CEdit *cedit, CEditCursor *cursor, char *word, int *depth, char *filename, include_db *incl_db)
{
  long prev_y;
  //  char pointer;
  long n_line;
  definition_db *def_db;
  char *temp_word;
  long last_char_pos;
  char exit_cond;

  // cojo la palabra
  prev_y=cursor->y;
  n_line=cursor->y;
   
 //cedit_get_next_variable (cedit, cursor, word, &pointer, depth);  // por si hay mas -> int a,b,c,d;
  cedit_get_next_define_word (cedit, cursor, word, depth); // intento obtener el nombre
  if (cursor->l_line==NULL) 
    return -1;

  if (strlen(word)>0)
    {
      if (prev_y==cursor->y)
	{
	  temp_word=(char*)malloc(300*sizeof(char));
	  cedit_get_next_define_word (cedit, cursor, temp_word, depth); // intento obtener el nombre
	  // la segunda palabra del define puede ser de un tipo, no valen funciones (sucede)

	  if (strlen(temp_word)>0 && cursor->l_line!=NULL)
	    if (temp_word[strlen(temp_word)-1]=='(')
	      temp_word[strlen(temp_word)-1]='\0';
	  
	  def_db = cedit_search_db_value(cedit, temp_word,cursor->y,0);
	  if (def_db!=NULL)
	    {
	      //	      if (def_db->type==cedit_dw_data_type)
	      //		{
		  //	      if (def_db->type==cedit_dw_data_type)
		  //	      cedit_insert_definition_word (cedit, word, def_db->type, def_db, 0,NULL, 0, 
		  cedit_insert_definition_word (cedit, word, cedit_dw_typedef, def_db, 0,0,NULL, 0, 
						n_line, filename, 
						-1, -1, incl_db);
		  //	      else
		  //		cedit_insert_definition_word (cedit, word, cedit_dw_nothing, NULL, 0,NULL, 0, 
		  //					      cursor->y, filename, 
		  //					      -1, -1);
		  strcpy(word, temp_word);
		  /*		}
	      else
		cedit_insert_definition_word (cedit, word, cedit_dw_nothing, NULL, 0,NULL, 0, 
					      cursor->y, filename, 
					      -1, -1);*/
	    }
	  else
	    {
	      cedit_insert_definition_word (cedit, word, cedit_dw_nothing, NULL, 0,0,NULL, 0, 
					    n_line, filename, 
					    -1, -1, incl_db);
	      if (strlen(temp_word)>0) // si he cogido algo, ahora no puedo ignorarlo
		strcpy(word,temp_word);
	    }
	  free(temp_word);
	}
      else
	cedit_insert_definition_word (cedit, word, cedit_dw_nothing, NULL, 0,0,NULL, 0, 
				      n_line, filename, 
				      -1, -1, incl_db);


	//cedit_get_next_variable (cedit, cursor, word, &pointer, depth);  // por si hay mas -> int a,b,c,d;
	if (cursor->l_line==NULL) 
	  return -1;
    }

  if (prev_y!=cursor->y) 
    {
      cedit_get_next_word_correct (cedit, cursor, word, depth); // intento obtener el nombre
      return 0;
    }


  if (cursor->l_line==NULL)
    return -1;

  /*
  if (prev_y==cursor->y)
    {
  // me salto las demas
  exit_cond=0;
  last_char_pos=cedit_get_last_char_pos(cedit, cursor->l_line);
  if (last_char_pos>=cursor->l_line->num_char)
    exit_cond=0;
  else
    if (cursor->l_line->text[last_char_pos]=='\\');
	exit_cond=1;
*/
  
  
  exit_cond=1;
  while(exit_cond==1)
    {
      exit_cond=0;
      last_char_pos=cedit_get_last_char_pos(cedit, cursor->l_line);
      if (last_char_pos<cursor->l_line->num_char)
	if (cursor->l_line->text[last_char_pos]=='\\')
	  exit_cond=1;

	  //	  cedit_get_next_word (cedit, cursor, word, depth); // intento obtener el nombre
	  //	  cedit_get_next_real_char (cedit, cursor, depth);
      cursor->l_line=cursor->l_line->next;
      cursor->y++;
      cursor->x=0;
      
      if (cursor->l_line==NULL)
	return -1;
	  
	
    }
  
  cedit_get_next_word_correct (cedit, cursor, word, depth); // intento obtener el nombre
  return 0;
}

 

// -----------------------------------------
//  funcin recursiva que trata de sacar
// todas las definiciones de una enum
// si encuentra un define por enmedio, lo hace, pero 
// rehace el cursor donde empezo y lo hace el.
// Los { } no han de contar en los define
// ------------------------------------------
definition_db *cedit_new_enum(CEdit *cedit, CEditCursor *cursor, char *word, int *depth, char *filename, include_db *incl_db)
{
  definition_db *new_definition_db; // el nuevo
  definition_db *def_db;
  definition_db *int_def_db;

  int prev_depth;

  int n_args;
  char pointer;
  long new_min_bound;
  long new_max_bound;
  char *new_name;
  long new_line;

  //  char *filenametonext;
  //  include_db *incl_dbtonext;
  //  line *include_line;

  long prev_y;
  line *prev_line;
  int temp_prev_depth;

  char exit_cond;
  long last_char_pos;

  word[0]='\0';

  new_min_bound = cedit_search_min_boundary(cedit, (*cursor), 0, (*depth));
  new_max_bound = cedit_search_max_boundary(cedit, (*cursor), 0, (*depth));
  new_line = cursor->y;
  n_args=0;

  prev_depth=(*depth);
  cedit_get_next_word (cedit, cursor, word, depth); // intento obtener el nombre
  if ((*depth)!=prev_depth) // no hay nombre, ha hecho: struct {
    {
      new_name=(char*)malloc(strlen("NoNameqmwnebrvtcyxuzi")*sizeof(char)+5); // nombre raro
      strcpy(new_name, "NoNameqmwnebrvtcyxuzi");
      new_name[strlen("NoNameqmwnebrvtcyxuzi")]='\0';
    }
  else
    {
      new_name=(char*)malloc(strlen(word)*sizeof(char)+5);
      strcpy(new_name, word);
      new_name[strlen(word)]='\0';
      cedit_get_next_word (cedit, cursor, word, depth); // ahora cojo la siguiente variable, la primera
      //      cedit_get_next_variable (cedit, cursor, word, &pointer, depth); // ahora cojo la siguiente variable, la primera
    }  

  int_def_db = cedit_search_db_value(cedit, "int", 0,0);
  new_definition_db=cedit_insert_definition_word (cedit, 
						  new_name, 
						  cedit_dw_data_type, 
						  int_def_db, 
						  0, 
						  0,
						  NULL, 
						  0, 
						  new_line, 
						  filename, 
						  new_min_bound, 
						  new_max_bound,
						  incl_db);
  free(new_name);
  if (cursor->l_line==NULL) 
      return new_definition_db;

  while (prev_depth<(*depth) && strlen(word)>0 && cursor->l_line!=NULL)
    {
      if (cedit -> exit == 1)
	  return new_definition_db;


      if (cedit_strcmp(word,"define")==0)
	{
	  
	  prev_y=cursor->y;
	  prev_line=cursor->l_line;
	  temp_prev_depth=(*depth);

	  cedit_new_define(cedit, cursor, word, depth, filename, incl_db);	    
	  if (prev_depth>=(*depth)) // el buscar define la ha cagado porque ha cogido la siguiente palabra, saliendo de la union
	    { // retrocedo y me recorro el define para quedarme donde debo
	      cursor->x=0;
	      cursor->y=prev_y;
	      cursor->l_line=prev_line;
	      (*depth)=temp_prev_depth;

	      exit_cond=1;
	      while(exit_cond==1)
		{
		  exit_cond=0;
		  last_char_pos=cedit_get_last_char_pos(cedit, cursor->l_line);
		  if (last_char_pos<cursor->l_line->num_char)
		    if (cursor->l_line->text[last_char_pos]=='\\')
		      exit_cond=1;
		  
		  //	  cedit_get_next_word (cedit, cursor, word, depth); // intento obtener el nombre
		  //	  cedit_get_next_real_char (cedit, cursor, depth);
		  cursor->l_line=cursor->l_line->next;
		  cursor->y++;
		  cursor->x=0;
		  
		  if (cursor->l_line==NULL)
		    return new_definition_db;		  	
		}	      
	      cedit_get_next_variable_enum (cedit, cursor, word, &pointer, depth);  // por si hay mas -> int a,b,c,d;
	    }
	  cedit_get_next_variable_enum (cedit, cursor, word, &pointer, depth);  // por si hay mas -> int a,b,c,d;
	  continue;
	}
	
      if (cedit_strcmp(word,"include")==0)
	{
	  cedit_get_include_file(cedit, cursor, word, depth); // obtengo el nombre del fichero ha incluir
	  if (cursor->l_line == NULL)
	    {
	      
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      return new_definition_db;
	    }
	  
	  //	  filenametonext=NULL;
	  //	  filenametonext=(char*)malloc(1000*sizeof(char));
	  g_mutex_unlock(cedit->mutex_text);             // desprotejo

	    cedit_insert_include_db(cedit, word, incl_db);  // cargo el archivo
	    /*
	  include_line=cedit_insert_include_db(cedit, word, filenametonext, incl_db);  // cargo el archivo
	  incl_dbtonext=cedit->incl_dbtonext; // la funcion anterior rellena incl_dbtonext
	  if (include_line!=NULL)
	    {
	      cedit_search_definitions(cedit, include_line, filenametonext, incl_dbtonext); // que lo analice
	      cedit_free_include_file(cedit, include_line);  // libero el archivo
	    }
	  g_mutex_lock(cedit->mutex_text);             // desprotejo
	  free(filenametonext);
	    */
	  //	    g_mutex_lock(cedit->mutex_text);               // protejo para continuar
	  continue;
	}

      if (cursor->l_line->flags[cursor->x] & cedit_flag_macro) // no acepto macros 
	{	  
	  cursor->l_line=cursor->l_line->next;
	  cursor->y++;
	  cursor->x=0;
	  continue;
	}
      def_db = cedit_search_db_value(cedit, word, cursor->y,0);
      if (def_db==NULL)
	{     
	  def_db=cedit_insert_definition_word (cedit, word, cedit_dw_variable, int_def_db, pointer,0,NULL, 0, 
					       cursor->y, filename, 
					       -1,-1, incl_db); //cedit_search_min_boundary(cedit, (*cursor),0, (*depth)), 
	  //					   cedit_search_max_boundary(cedit, (*cursor),0, (*depth)));
	}
      cedit_get_next_variable_enum (cedit, cursor, word, &pointer, depth);  // por si hay mas -> int a,b,c,d. No acepta macros
       
    }

  return new_definition_db;
}


// -----------------------------------------
//  funcion recursiva que trata de sacar
// todas las definiciones de las estructuras
// ------------------------------------------
definition_db *cedit_new_struct(CEdit *cedit, CEditCursor *cursor, char *word, int *depth, char *filename, include_db *incl_db)
{ 
  definition_db *new_definition_db; // el nuevo
  definition_db *def_db;
  definition_db *function_def_db;
  int prev_depth;

  char function_name [3000];
  char function_pointer;
  CEditCursor function_cursor;
  definition_db **function_args;
  int function_n_args;

  definition_db **new_args;
  int n_args;
  char pointer;
  long new_min_bound;
  long new_max_bound;
  char *new_name;
  long new_line;
  int count;

  long prev_y;
  line *prev_line;
  int temp_prev_depth;
  int exit_cond;
  long last_char_pos;
  //  char *filenametonext;
  //  include_db *incl_dbtonext;
  //  line *include_line;
  

  word[0]='\0';

  new_args=(definition_db**) malloc (1000 * sizeof(definition_db*));
  for (count=0;count<100;count++)
    new_args[count]=NULL;

  new_min_bound = cedit_search_min_boundary(cedit, (*cursor), 0, (*depth));
  new_max_bound = cedit_search_max_boundary(cedit, (*cursor), 0, (*depth));
  new_line = cursor->y;
  n_args=0;

  prev_depth=(*depth);
  cedit_get_next_word (cedit, cursor, word, depth); // intento obtener el nombre
  if ((*depth)!=prev_depth) // no hay nombre, ha hecho: struct {
    {
      new_name=(char*)malloc(strlen("NoNameqmwnebrvtcyxuzi")*sizeof(char)+5); // nombre raro
      strcpy(new_name, "NoNameqmwnebrvtcyxuzi");
      new_name[strlen("NoNameqmwnebrvtcyxuzi")]='\0';
    }
  else
    {
      new_name=(char*)malloc(strlen(word)*sizeof(char)+5);
      strcpy(new_name, word);
      new_name[strlen(word)]='\0';
      // cedit_get_next_word (cedit, cursor, word, depth); // ahora cojo la siguiente variable, la primera
      cedit_get_next_variable (cedit, cursor, word, &pointer, depth); // ahora cojo la siguiente variable, la primera
    }  

  //  cedit_insert_db_value(cedit, new_definition_db->name, new_definition_db)


  //  new_args=NULL;
  n_args=0;
  new_definition_db=cedit_insert_definition_word (cedit, 
						  new_name, 
						  cedit_dw_data_type, 
						  NULL, 
						  0, 
						  0,
						  NULL, 
						  n_args, 
						  new_line, 
						  filename, 
						  new_min_bound, 
						  new_max_bound,
						  incl_db);
  if (cursor->l_line==NULL) 
    {
      new_definition_db -> definition_type_args =(definition_db **) malloc (n_args *sizeof (definition_db *));
       
      for (count = 0; count < n_args; count ++)
	new_definition_db->definition_type_args[count]=new_args[count];
      new_definition_db->n_args=n_args;
      
      // inserta el nuevo tipo definido por esta estructura
      free(new_name);
      free(new_args);
      return new_definition_db;
    }

  while (prev_depth<(*depth))
    {
      if (cedit -> exit == 1)
	{
	  free(new_name);
	  free(new_args);
	  return new_definition_db;
	}


      // colocado y no probado
      if (cedit_strcmp(word,"define")==0)
	{
	  
	  prev_y=cursor->y;
	  prev_line=cursor->l_line;
	  temp_prev_depth=(*depth);

	  cedit_new_define(cedit, cursor, word, depth, filename, incl_db);	    
	  if (prev_depth>=(*depth)) // el buscar define la ha cagado porque ha cogido la siguiente palabra, saliendo de la union
	    { // retrocedo y me recorro el define para quedarme donde debo
	      cursor->x=0;
	      cursor->y=prev_y;
	      cursor->l_line=prev_line;
	      (*depth)=temp_prev_depth;

	      exit_cond=1;
	      while(exit_cond==1)
		{
		  exit_cond=0;
		  last_char_pos=cedit_get_last_char_pos(cedit, cursor->l_line);
		  if (last_char_pos<cursor->l_line->num_char)
		    if (cursor->l_line->text[last_char_pos]=='\\')
		      exit_cond=1;
		  
		  //	  cedit_get_next_word (cedit, cursor, word, depth); // intento obtener el nombre
		  //	  cedit_get_next_real_char (cedit, cursor, depth);
		  cursor->l_line=cursor->l_line->next;
		  cursor->y++;
		  cursor->x=0;
		  
		  if (cursor->l_line==NULL)
		    return new_definition_db;		  	
		}	      
	      cedit_get_next_struct_variable (cedit, cursor, word, &pointer, depth);  // por si hay mas -> int a,b,c,d;
	    }
	  cedit_get_next_struct_variable (cedit, cursor, word, &pointer, depth);  // por si hay mas -> int a,b,c,d;
	  continue;
	}
	
      if (cedit_strcmp(word,"include")==0)
	{
	  cedit_get_include_file(cedit, cursor, word, depth); // obtengo el nombre del fichero ha incluir
	  if (cursor->l_line == NULL)
	    {
	      
	      g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
	      return new_definition_db;
	    }
	  

	    //	  filenametonext=NULL;
	    //	  filenametonext=(char*)malloc(1000*sizeof(char));
	  g_mutex_unlock(cedit->mutex_text);             // desprotejo
	    cedit_insert_include_db(cedit, word, incl_db);  // cargo el archivo
	    /*
	    include_line=cedit_insert_include_db(cedit, word, filenametonext, incl_db);  // cargo el archivo
	  incl_dbtonext=cedit->incl_dbtonext; // la funcion anterior rellena incl_dbtonext
	  if (include_line!=NULL)
	    {
	      cedit_search_definitions(cedit, include_line, filenametonext, incl_dbtonext); // que lo analice
	      cedit_free_include_file(cedit, include_line);  // libero el archivo
	    }
	  g_mutex_lock(cedit->mutex_text);             // desprotejo
	  free(filenametonext);
	    */
	  //	    g_mutex_lock(cedit->mutex_text);               // protejo para continuar
	  continue;
	}



      def_db = cedit_search_db_value(cedit, word, cursor->y,0);
      if (def_db != NULL)	
	{
	  
	  if (def_db -> type == cedit_dw_data_type && cursor->l_line != NULL)  // si es de un tipo definitorio (int, char...)
	    {
	      cedit_get_next_struct_variable (cedit, cursor, word, &pointer, depth);  // cojo el nombre siguiente (a,b...)
	      if (cursor->l_line == NULL) {
		if (n_args>new_definition_db->n_args) // si he encontrado mas argumentos de los que tiene (tiene si estaba ya definido)
		  {
		    new_definition_db -> definition_type_args =(definition_db **) malloc ((1+n_args) *sizeof (definition_db *));
		    for (count = 0; count < n_args; count ++)
		      new_definition_db->definition_type_args[count]=new_args[count];
		    new_definition_db->n_args=n_args;
		  }
		free(new_name);
		free(new_args);
		return new_definition_db;
	      }

	      if (word [strlen (word) - 1] =='(') // si es de tipo funcion int a(int c, int d);
		{
		  // guardo los valores
		  strcpy (function_name, word);
		  function_pointer = pointer;
		  function_def_db = def_db;
		  function_cursor.y = cursor->y;
		  function_cursor.x = cursor->x;
		  function_cursor.l_line=cursor->l_line;
		  function_args=NULL;
		  function_args=(definition_db**) malloc (500*sizeof(definition_db*));
		  if (function_args==NULL)
		    {
		      g_print("SIN MEMORIA, POSIBLE FALLO EN LA CORRECCION\n");
		      return new_definition_db;
		    }
		  function_n_args = 0;
		  
		  // busco ahora los parametros
		  cedit_get_next_word (cedit, cursor, word, depth);
		  def_db = cedit_search_db_value(cedit, word, cursor->y,0);
		  if (def_db != NULL)
		    while (cursor->l_line != NULL && word[0]!='\0')     
		      //while (def_db -> type == cedit_dw_data_type && cursor->l_line != NULL && word[0]!='\0')     
		      // mientras encuentre palabras de tipo
		      {
			cedit_get_next_variable (cedit, cursor, word, &pointer, depth);
			//			cedit_get_next_function_variable (cedit, cursor, word, &pointer, depth);
			if (cedit_strcmp (word, "") != 0 || prev_depth>=(*depth)) // si el tipo era void, ahora no habra nombre de variable
			  {
			    // lo inserto
			    def_db=cedit_insert_definition_word (cedit, word, cedit_dw_variable, def_db, pointer,1,
								 NULL, 0, cursor->y, filename,
								 cedit_search_min_boundary(cedit, *cursor,1, (*depth)), 
								 cedit_search_max_boundary(cedit, *cursor,1, (*depth)),
								 incl_db);
			    
			    
			    function_args[function_n_args]=def_db;
			    function_n_args ++;
			    // busco el tipo del siguiente argumento

			    // cambio 1
			    //cedit_get_next_word (cedit, cursor, word, depth);
			    cedit_get_next_struct_variable (cedit, cursor, word, &pointer, depth);
			    //			    cedit_get_next_variable (cedit, cursor, word, &pointer, depth);
			    def_db = cedit_search_db_value (cedit, word, cursor->y,0);
			    //			    if (def_db == NULL)
			    //				break;
			  }
		      }
		  // inserto la funcion                
		  def_db=cedit_insert_definition_word (cedit, function_name, cedit_dw_function, 
						       function_def_db, function_pointer,1, function_args,function_n_args, 
						       function_cursor.y,  filename,
						       cedit_search_min_boundary(cedit, function_cursor,0, (*depth)), 
						       cedit_search_max_boundary(cedit, function_cursor,0, (*depth)),
						       incl_db);

		  if (n_args>1000) g_print("\n\n ESTOY EN ERROR \n\n");
		  if (function_n_args>1000) g_print("\n\n ESTOY EN ERROR \n\n");
		  new_args[n_args]=def_db;
		  n_args++;
		  free(function_args);
		  
		}
	      else
		{
		  while (strlen(word)>0)
		    {
		      def_db=cedit_insert_definition_word (cedit, word, cedit_dw_variable, def_db, pointer,1,NULL, 0, 
							   cursor->y, filename, 
							   cedit_search_min_boundary(cedit, *cursor,0, (*depth)), 
							   cedit_search_max_boundary(cedit, *cursor,0, (*depth)),
							   incl_db);
		      
		      if (n_args>1000) g_print("\n\n ESTOY EN ERROR \n\n");
		      new_args[n_args]=def_db;
		      n_args++;

		      cedit_get_next_struct_variable (cedit, cursor, word, &pointer, depth);  // por si hay mas -> int a,b,c,d;
		      if (cursor->l_line==NULL || prev_depth>=(*depth))
			{
			  if (n_args>new_definition_db->n_args) // si he encontrado mas argumentos de los que tiene (tiene si estaba ya definido)
			    {
			      new_definition_db -> definition_type_args =(definition_db **) malloc ((1+n_args) *sizeof (definition_db *));
			      for (count = 0; count < n_args; count ++)
				new_definition_db->definition_type_args[count]=new_args[count];
			      new_definition_db->n_args=n_args;
			    }
			  free(new_name);
			  free(new_args);
			  return new_definition_db;
			}
		    }
		}	     
	    }
	  
	  
	  else if (def_db -> type == cedit_dw_struct && cursor->l_line != NULL)  // si es de un tipo estructura la analizo recursivamente
	    {
	      def_db=cedit_new_struct(cedit, cursor, word, depth, filename, incl_db);
	      if (cursor->l_line==NULL)
		break;
	      while (strlen(word)>0)
		{
		  def_db=cedit_insert_definition_word (cedit, word, cedit_dw_variable, def_db, pointer,1, NULL, 0, 
						       cursor->y, filename, 
						       cedit_search_min_boundary(cedit, *cursor,0,(*depth)), 
						       cedit_search_max_boundary(cedit, *cursor,0,(*depth)),
						       incl_db);
		  if (n_args>1000) g_print("\n\n ESTOY EN ERROR \n\n");
		  new_args[n_args]=def_db;
		  n_args++;

		  cedit_get_next_variable (cedit, cursor, word, &pointer, depth);  // por si hay mas -> int a,b,c,d;
		  if (cursor->l_line==NULL || prev_depth>=(*depth)) 
		    {
		      if (n_args>new_definition_db->n_args) // si he encontrado mas argumentos de los que tiene (tiene si estaba ya definido)
			{
			  new_definition_db -> definition_type_args =(definition_db **) malloc ((1+n_args) *sizeof (definition_db *));
			  for (count = 0; count < n_args; count ++)
			    new_definition_db->definition_type_args[count]=new_args[count];
			  new_definition_db->n_args=n_args;
			}
		      free(new_name);
		      free(new_args);
		      return new_definition_db;
		    }
		}	    
	    }
	  
	}      
      //      cedit_get_next_word (cedit, cursor, word, depth); // ahora cojo la siguiente variable, la primera
      cedit_get_next_struct_variable (cedit, cursor, word, &pointer, depth); // ahora cojo la siguiente variable, la primera
      if (cursor->l_line==NULL)
	{
	  if (n_args>new_definition_db->n_args) // si he encontrado mas argumentos de los que tiene (tiene si estaba ya definido)
	    {
	      new_definition_db -> definition_type_args =(definition_db **) malloc ((1+n_args) *sizeof (definition_db *));
	      for (count = 0; count < n_args; count ++)
		new_definition_db->definition_type_args[count]=new_args[count];
	      new_definition_db->n_args=n_args;
	    }
	  free(new_name);
	  free(new_args);
	  return new_definition_db;
	}
    }
  if (n_args>new_definition_db->n_args) // si he encontrado mas argumentos de los que tiene (tiene si estaba ya definido)
    {
      new_definition_db -> definition_type_args =(definition_db **) malloc ((1+n_args) *sizeof (definition_db *));
      for (count = 0; count < n_args; count ++)
	new_definition_db->definition_type_args[count]=new_args[count];
      new_definition_db->n_args=n_args;
    }
  
  free(new_name);
  free(new_args);
  return new_definition_db;
}

// ------------------------------------------------------------------
//  Carga un fichero para analizarlo, lo hace para incluirlo
// ------------------------------------------------------------------     
line *
cedit_load_include_file (CEdit *cedit, char *name, include_db *incl_db)
{
    FILE *fp;
    long tam;
    char character;
    line *first;
    line *actual;
    line *new_line;
    long y;
    char text, apostrophe_text, comment, line_comment;
    char ignore;
    char prev_restart_correct_now;


    if (cedit == NULL) return NULL;
    if (name == NULL) {
        cedit -> nError = 5;
        return NULL;
    }

    
    fp = fopen (name, "rb");
    if (fp == NULL) {
        cedit -> nError = 6;
        return NULL;
    }
    
    // miro el tamanyo del fichero
    fseek (fp, 0, SEEK_END);
    tam = ftell (fp);
    rewind (fp);

    if (incl_db!=NULL)
      incl_db->filelenght=tam;  // lo guardo para saber si ha cambiado
 
    first=cedit_new_line(cedit, NULL, NULL);
    actual=first;

    text=0;
    apostrophe_text=0;
    comment=0;
    line_comment=0;
    ignore=0;

    //    g_mutex_unlock (cedit -> mutex_text);    // bloqueamos para no acceder al texto

        // por cada byte
    prev_restart_correct_now=cedit->restart_correct_now;
    while (tam > 0)
    {
        character = fgetc (fp);

	if (character<10) // un tab o cualquier caracter extrao
	  character=' ';
	if (character!=10)
	  {
	    if (cedit_realloc_text (cedit, actual, actual->num_char + 3) < 0)
	      {
		g_print("Sin memoria");
		//		g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
 		return first;
	      }

	    /*
	    if (character=='\"' && text==0 && apostrophe_text==0)
	      text=1; // lo activo
	    else
	      text=2; // queda activado solo esta letra

	    if (character=='\'' && apostrophe_text==0 && text==0)
	      apostrophe_text=1; // lo activo
	    else
	      apostrophe_text=2; // queda activado solo esta letra

	    if (character=='/' && line_comment==2 && text==0 && apostrophe_text==0) // segunda /
	      line_comment=1;
	    else if (character=='*' && line_comment==2 && text==0 && apostrophe_text==0) // el otro *
	      comment=1;
	    else if (character=='/' && line_comment==0 && text==0 && apostrophe_text==0) // primera /
	      line_comment=2;
	    else line_comment=0;

	    if (character=='*' && line_comment==2 && text==0 && apostrophe_text==0) // segunda /
	      {
		comment=1;
		line_comment
	      }
	    else if (character=='/' && comment==0 && text==0 && apostrophe_text==0) // primera /
	      comment=2;
	    else comment=0;
	    */

	    //	    g_print("%c",character);
	    actual->text[actual->num_char]=character;
	    actual->flags[actual->num_char]=0;

	    /*
	    if (text==1) actual->flags[actual->num_char]+=cedit_flag_text;
	    if (apostrophe_text==1) actual->flags[actual->num_char]+=cedit_flag_apostrophe_text;
	    if (line_comment==1) actual->flags[actual->num_char]+=cedit_flag_line_comment;
	    if (comment==1) actual->flags[actual->num_char]+=cedit_flag_comment;

	    if (text==2) text=0;
	    if (apostrophe_text==2) apostrophe_text=0;
	    */

	    actual->num_char++;
	  }
	else
	  {
	    line_comment=0;
	    actual->text[actual->num_char]='\0';
	    actual->flags[actual->num_char]=0;
	      
	    /*
	    if (text==1) actual->flags[actual->num_char]+=cedit_flag_text;
	    if (apostrophe_text==1) actual->flags[actual->num_char]+=cedit_flag_apostrophe_text;
	    if (line_comment==1) actual->flags[actual->num_char]+=cedit_flag_line_comment;
	    if (comment==1) actual->flags[actual->num_char]+=cedit_flag_comment;
	    */

	    new_line=cedit_new_line(cedit, actual, NULL);
	    actual->next=new_line;
	    new_line->prev=actual;
	    new_line->next=NULL;
	    actual=actual->next;
	  }
        tam --;
    }
    actual->text[actual->num_char]='\0';
    actual->flags[actual->num_char]=0;
    fclose (fp);

            
    y=0;
    actual=first;
    while (actual!=NULL)
    {
      cedit->something_has_changed=1;
      cedit_set_include_flags(cedit, actual, y);
      actual=actual->next;
      y++;
    }

    cedit->restart_correct_now=prev_restart_correct_now;
    
    //    g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
    
        //   *progress=1.0;
    return first;  
}

// ---------------------------
//  Libera un fichero cargado
// ---------------------------     
void
cedit_free_include_file(CEdit *cedit, line *first)
{
  line *prev_line;
  int prev_restart_correct_now;

  prev_restart_correct_now=cedit->restart_correct_now;

  while (first!=NULL)
    {
      prev_line=first;
      first=first->next;
      cedit_del_line(cedit, prev_line);
    }
  cedit->restart_correct_now=prev_restart_correct_now;
}

// ----------------------------------------------
//  Busca la dirección de un include y evita que 
// se incluya dos veces el mismo include
// ----------------------------------------------
line *
cedit_insert_include_db(CEdit *cedit, char *word, include_db *incl_db)
{
  include_db *new_db;
  include_db *temp;
  include_path *path;
  char finded;
  line *first;
  char text_path[500];
  char *filename;
  char *directory;
  include_db *find_db;
  FILE *fp;
  unsigned long int tam;

  first=NULL;
  
  finded=0;
  // primero busco si ya existe
  temp=cedit->list_include_db;
  while (temp!=NULL && finded==0)
    {
      if (temp->name!=NULL)
	{
	  if (cedit_strcmp(temp->name, word)==0)
	    {
	      finded=1;
	    }
	  else
	    temp=temp->next;
	}
      else
	temp=temp->next;
    }




  if (finded==0) // si no ha sido encontrado
    {      

      new_db=cedit_new_include_db(cedit, word);
      if (new_db==NULL) return NULL;
      temp=new_db;
    }

  if (incl_db!=NULL)
    if (g_list_find(incl_db->sons, temp)==NULL) // si no existe lo aado a la lista de hijos
      {
	incl_db->sons=g_list_append(incl_db->sons, temp);
      }
  
  cedit_recursive_mark_to_readed(cedit, temp);

  if (temp->fullname!=NULL)
    {
      fp = fopen (temp->fullname, "rb");
      if (fp != NULL) 
	{
	  // miro el tamanyo del fichero
	  fseek (fp, 0, SEEK_END);
	  tam = ftell (fp);
	  rewind (fp);
	}
      else
	tam=0;
    }
  else
    tam=0;
    


  if (finded>0 && tam==temp->filelenght)
    {
      if (temp->is_readed>0) // ya ha sido leido, no lo reeleo
	{	  
	  return NULL;
	}
      // marco como leidos todos sus hijos, es necesario si este include no se lee
      // porque ya esta en la base de datos, pues tambien sus hijos
      //      cedit_recursive_mark_to_readed(cedit, temp);
      return NULL;
    }
  // es para pasar el parmetro atras

  filename=(char*)malloc(3000*sizeof(char));

  // busco ahora la direccion exacta del fichero incluido
  // forma rapida, si esta en el directorio activo
  if (cedit_file_exist(word)>0)
    {
      g_print("leo %s...\n", word);
      temp->is_local=1;
      //      temp->is_readed=1;
      temp->fullname=strdup(word);
      strcpy(filename, word);

      first=cedit_load_include_file(cedit, word, temp);
      if (first!=NULL)
	cedit_search_definitions(cedit, first, word, temp); // que lo analice
      //      cedit_free_include_file(cedit, include_line);  // libero el archivo
      cedit_free_include_file(cedit, first);  // libero el archivo
      free(filename);
      return NULL;
      //      return cedit_load_include_file(cedit, word);
    }

  // si esta en el mismo directorio que el archivo analizado
  //  g_print("%s",cedit_get_directory(cedit, cedit->filename));
  directory=cedit_get_directory(cedit, cedit->filename);
  if (directory!=NULL)
    {
      sprintf(text_path,"%s%s", directory, word);
      free(directory);    

      if (cedit_file_exist(text_path)>0)
	{
	  g_print("leo %s...\n", text_path);
	  temp->is_local=0;
	  temp->is_readed=1;
	  temp->fullname=strdup(text_path);
	  strcpy(filename, text_path);
	  first=cedit_load_include_file(cedit, text_path, temp);
	  
	  if (first!=NULL)
	    cedit_search_definitions(cedit, first, text_path, temp); // que lo analice
	  
	  cedit_free_include_file(cedit, first);  // libero el archivo
	  free(filename);
	  return NULL;
	  //	  return cedit_load_include_file(cedit, text_path);
	}
    }

  // si esta en el mismo directorio que el ultimo include (o es relativo a este)
  if (incl_db!=NULL)
    {
      directory=cedit_get_directory(cedit, incl_db->fullname);
      if (directory!=NULL)
	{
	  sprintf(text_path,"%s%s", directory, word);
	  free(directory);    
	  if (cedit_file_exist(text_path)>0)
	    {
	      g_print("leo %s...\n", text_path);
	      temp->is_local=0;
	      temp->is_readed=1;
	      temp->fullname=strdup(text_path);
	      strcpy(filename, text_path);
	      first=cedit_load_include_file(cedit, text_path, temp);
	      
	      if (first!=NULL)
		cedit_search_definitions(cedit, first, text_path, temp); // que lo analice
	      
	      cedit_free_include_file(cedit, first);  // libero el archivo
	      free(filename);
	      return NULL;
	      //	  return cedit_load_include_file(cedit, text_path);
	    }
	}
    }
  
  // mirar en los directorios
  path=cedit->list_include_path;
  while (path!=NULL)
    {
      sprintf(text_path,"%s%s", path->name, word);
      if (cedit_file_exist(text_path)>0)
	{
	  g_print("leo %s...\n", text_path);
	  temp->is_local=0;
	  temp->is_readed=1;
	  temp->fullname=strdup(text_path);
	  strcpy(filename, text_path);
	  first=cedit_load_include_file(cedit, text_path, temp);

	  if (first!=NULL)
	      cedit_search_definitions(cedit, first, text_path, temp); // que lo analice

	  cedit_free_include_file(cedit, first);  // libero el archivo
	  free(filename);
	  return NULL;
	  //	  return cedit_load_include_file(cedit, text_path);
	}
      path=path->next;
    }

  // si esta en el mismo directorio que algun include (o es relativo a este)
  find_db=cedit->list_include_db;
  while (find_db!=NULL)
    {
      directory=cedit_get_directory(cedit, find_db->fullname);
      g_print("BUSCANDO EN %s\n", directory);
      if (directory!=NULL)
	{
	  sprintf(text_path,"%s%s", directory, word);
	  free(directory);    
	  if (cedit_file_exist(text_path)>0)
	    {
	      g_print("leo %s...\n", text_path);
	      temp->is_local=0;
	      temp->is_readed=1;
	      temp->fullname=strdup(text_path);
	      strcpy(filename, text_path);
	      first=cedit_load_include_file(cedit, text_path, temp);
	      
	      if (first!=NULL)
		cedit_search_definitions(cedit, first, text_path, temp); // que lo analice
	      
	      cedit_free_include_file(cedit, first);  // libero el archivo
	      free(filename);
	      return NULL;
	      //	  return cedit_load_include_file(cedit, text_path);
	    }
	}
      find_db=find_db->next;
    }
  
  g_print("NO ENCONTRADO EL FICHERO %s\n", word);
  
  // si estoy aqui es que el fichero no ha sido encontrado
  // FIXME hacer algo, ahora simplemente es ignorado el error
  //    }
  //  else
  //    return NULL;
  free(filename);
  return NULL;
}

// --------------------------------------------------
//  Marca como leido un include_db y todos sus hijos
// --------------------------------------------------
int cedit_recursive_mark_to_readed(CEdit *cedit, include_db *incl_db)
{
  int count;
  include_db *son;
  GList *element;

  count=0;
  son=NULL;

  incl_db->is_readed=1;
  //  son=g_list_nth_data(incl_db->sons, count);
  element=g_list_first(incl_db->sons); 
  if (element!=NULL)
    son=(include_db*)element->data;
  while (element!=NULL)
    {
      if (son->is_readed==0)
	cedit_recursive_mark_to_readed(cedit, son);
      element=g_list_next(element);
      if (element!=NULL)
	son=(include_db*)element->data;
    }
  return 0;
}

// --------------------------
//  Crea un nuevo include_db
// --------------------------
include_db* cedit_new_include_db(CEdit *cedit, char *word)
{
  include_db *new_db;
  include_db *temp;

  // lo inserto en la lista
  new_db=NULL;
  new_db=(include_db*)malloc(sizeof(include_db));
  if (new_db==NULL) return NULL;
  new_db->name=NULL;
  new_db->name=(char*)malloc(strlen(word)*sizeof(char)+5);
  if (new_db->name==NULL)
    {
      g_print("Sin memoria");
      free(new_db);
      return NULL;
    }
  strcpy(new_db->name, word);
  new_db->fullname=NULL;
  new_db->next=NULL;
  new_db->is_readed=1;
  new_db->sons=NULL;
  new_db->filelenght=0;
  
  temp=cedit->list_include_db;
  if (cedit->list_include_db==NULL) 
    cedit->list_include_db=new_db;
  else
    {
      while (temp->next!=NULL)
	temp=temp->next;
      temp->next=new_db;
    }
  
  new_db->db = g_tree_new_full (cedit_compare_db_word,
				NULL,
				cedit_words_db_key_destroy_func,
				cedit_words_db_value_destroy_func);
  return new_db;
}
// --------------------------------------
//  Devuelve 1 si existe el fichero text
// --------------------------------------
int
cedit_file_exist(char *text)
{
  FILE *fp;

  fp=NULL;
  fp=fopen(text,"r");
  if (fp==NULL) return 0;
  fclose(fp);
  return 1;
}

// ---------------------------------------
//  Libera la lista de ficheros incluidos
// ---------------------------------------
int
cedit_free_include_db(CEdit *cedit)
{
  include_db *prev;
  include_db *actual;

  actual=cedit->list_include_db;

  while(actual!=NULL)
    {
      prev=actual;
      actual=actual->next;
      g_tree_destroy (prev->db);
      free(prev->name);
      if (prev->fullname!=NULL)
	free(prev->fullname);
      free(prev);
    }
  cedit->list_include_db=NULL;
  return 0;
}

// -------------------------------------------
//  Inicializa la lista de ficheros incluidos
// -------------------------------------------
int
cedit_start_include_db(CEdit *cedit)
{
  include_db *point;

  point=cedit->list_include_db;
  
  while(point!=NULL)
    {
      point->is_readed=0;
      point=point->next;
    }
  return 0;
}

// ----------------------------------------------
//  Borra los includes guardados, pero no usados
// ----------------------------------------------
int
cedit_del_include_db_not_readed(CEdit *cedit)
{
  include_db *point;
  include_db *prev_point;
  
  point=cedit->list_include_db;
  prev_point=point;

  while(point!=NULL)
    {
      if (point->is_readed==0)
	{

	  if (prev_point==cedit->list_include_db)
	    {
	      cedit_free_definitions_db_file(cedit, point->fullname);
	      point=point->next;
	      cedit->list_include_db=point;
	      if (prev_point->name!=NULL)
		free(prev_point->name); 
	      free(prev_point);
	      prev_point=point;
	    }
	  else
	    {
	      cedit_free_definitions_db_file(cedit, point->fullname);
	      point=point->next;
	      if (prev_point->next->name!=NULL)
		free(prev_point->next->name); 
	      free(prev_point->next);
	      prev_point->next=point;
	    }

	}
      else
	{
	  prev_point=point;
	  point=point->next;
	}
    }
  return 0;
 
}

// -------------------------------------------------------
//  Añade un camino donde ir a buscar un fichero incluido
//  a la lista de include_path
// -------------------------------------------------------
int
cedit_insert_include_path(CEdit *cedit, char *path)
{
  include_path *new_path;
  include_path *temp;

  new_path=(include_path*)malloc(sizeof(include_path));
  new_path->name=(char*)malloc(strlen(path)*sizeof(char)+5);
  strcpy(new_path->name, path);
  new_path->next=NULL;

  temp=cedit->list_include_path;
  if (cedit->list_include_path==NULL) 
      cedit->list_include_path=new_path;
  else
    {
      while (temp->next!=NULL)
	temp=temp->next;
      temp->next=new_path;
    }
  return 0;
}

// -----------------------------------------------
//  Libera la lista de caminos a ficheros include
// -----------------------------------------------
int
cedit_free_include_path(CEdit *cedit)
{
  include_path *prev;
  include_path *actual;

  actual=cedit->list_include_path;

  while(actual!=NULL)
    {
      prev=actual;
      actual=actual->next;
      free(prev->name);
      free(prev);
    }
  cedit->list_include_path=NULL;
  return 0;
}

// -------------------------------------------------------
//  Obtiene el nombre del fichero que se va ha incluir,
// en #include <glib/glib.h> devuelev glib/glib.h
// -------------------------------------------------------
int
cedit_get_include_file(CEdit *cedit, CEditCursor *cursor,char *word, int *depth) // obtengo el nombre del fichero ha incluir
{
  char ch;
  char prev_ch;
  int count;

  word[0]='\0';
  prev_ch=' ';
  // me salto todo hasta llegar al " o <
  cedit_get_real_char (cedit, cursor, depth);
  if (cursor->l_line == NULL)
      return -1;
  if (cursor->x == cursor->l_line -> num_char)
    return -1;
  else
      ch = cursor->l_line -> text [cursor->x];

  while (ch!='\"' && ch!='<')
    {
      cedit_get_next_real_char (cedit, cursor, depth);
      if (cursor->l_line == NULL)
	return -1;
      if (cursor->x == cursor->l_line -> num_char && prev_ch=='\\')
	ch =' ';
      else if(cursor->x == cursor->l_line -> num_char)
	return -1;
      else
	ch = cursor->l_line -> text [cursor->x];
    }

  // voy a la siguiente letra, para no incluir el " o < en el nombre
  cedit_get_next_real_char (cedit, cursor, depth);
  if (cursor->l_line == NULL)
    return -1;
  if (cursor->x == cursor->l_line -> num_char && prev_ch=='\\')
    ch =' ';
  else if(cursor->x == cursor->l_line -> num_char)
    return -1;
  else
    ch = cursor->l_line -> text [cursor->x];
  count=0;

  // ahora lo cojo todo hasta " o >
  while (ch!='\"' && ch!='>')
    {
      word[count]=ch;
      count++;
      cedit_get_next_real_char (cedit, cursor, depth);
      if (cursor->l_line == NULL)
	{
	  word[count]='\0';
	  return -1;
	}
      if (cursor->x == cursor->l_line -> num_char && prev_ch=='\\')
	ch =' ';
      else if(cursor->x == cursor->l_line -> num_char)
	return -1;
      else
	ch = cursor->l_line -> text [cursor->x];
    }

  word[count]='\0';
  return 0;
}


// ------------------------------------------
//  Pone los flags para los ficheros include
// ------------------------------------------
int
cedit_set_include_flags (CEdit *cedit, line *l_line, long y)
{
    int comment, line_comment, text, apostrophe_text, macro, reserved_word, number, character, mark;  // posibles flags
    
    int last_flag;
    int cont;
    int count, count2;
    int num_reserved_word;
    int num_text;
    int num_apostrophe_text;
    int num_comment;
    int last_char_pos;
    line *prev_line, *next_line;
    int exit_cond;
    
    if (cedit == NULL) return - 1;
    if (l_line == NULL)
    {
        cedit -> nError = 5;
        return - 1;
    }

        // primero, saco los flags de la ÃÂºltima linea, para continuar como lo dejo la ultima linea
    line_comment = 0;
    reserved_word = 0;
    number = 0;
    character = 0;
    mark = 0;
    macro = 0;
    //    selected = 0;
    comment = 0;
    text = 0;
    apostrophe_text = 0;
    macro = 0;
    num_reserved_word = 0;
    num_comment = 0;
    num_text = 0;
    num_apostrophe_text = 0;
    

    prev_line = l_line -> prev;
    if (prev_line==NULL)
      exit_cond=1;
    else
      {
	if (prev_line->num_char>0)
	  exit_cond=1;
	else
	  exit_cond=0;
      }
    while (exit_cond==0)
      {
	prev_line=prev_line->prev;
	if (prev_line==NULL)
	  exit_cond=1;
	else
	  {
	    if (prev_line->num_char>0)
	      exit_cond=1;
	    else
	      exit_cond=0;
	  }
      }
    //    while (prev_line != NULL && prev_line -> num_char == 0)
    //        prev_line = prev_line -> prev;
    

        // busco la linea siguiente de verdad, no me sirve si la linea anterior no tiene caracteres
    next_line = l_line -> next;
    if (next_line==NULL)
      exit_cond=1;
    else
      {
	if (next_line->num_char>0)
	  exit_cond=1;
	else
	  exit_cond=0;
      }
    while (exit_cond==0)
      {
	next_line=next_line->next;
	if (next_line==NULL)
	  exit_cond=1;
	else
	  {
	    if (next_line->num_char>0)
	      exit_cond=1;
	    else
	      exit_cond=0;
	  }
      }

        // miro si en esta linea continua los flags de la anterior
    if (prev_line != NULL) // no es la primera linea
    {
        last_char_pos = cedit_get_last_char_pos (cedit, prev_line);
            //      last_flag=prev_line->flags[last_char_pos];
        last_flag = cedit_get_last_flag (cedit, prev_line);
        
            // si tiene mas de 1 letra, puede ser "*/"
        if (last_char_pos >= 1)
        {
            if ((last_flag & cedit_flag_comment) &&
                !(prev_line -> text [last_char_pos - 1] == '*' &&
                    prev_line -> text [last_char_pos] == '/'))
            comment = 1;
        }
        else
            if (last_flag & cedit_flag_comment)
                comment = 1;
        
        if ((last_flag & cedit_flag_text) &&
            prev_line -> text [last_char_pos] !='\"')
        text = 1;
        
	last_char_pos=cedit_get_last_char_pos (cedit, l_line->prev);
	if (last_char_pos<l_line->prev->num_char) // si el ultimo caracter es legal
	  {
	    if ((last_flag & cedit_flag_macro) && l_line -> prev -> text [last_char_pos] =='\\') macro = 1;
	    if ((last_flag & cedit_flag_line_comment) && l_line -> prev -> text [last_char_pos] =='\\') line_comment = 1;
	  }
    }
    
        // si es una macro, lo se ahora
    if (l_line -> num_char > 0)
        if (l_line -> text [cedit_get_first_char_pos (cedit, l_line)] =='#')
            macro = 1;
    
    for (cont = 0; cont < l_line -> num_char; cont ++)
    {
        
            // miro si es un texto "asfasd"
        if (num_text > 0)
        {
            num_text --;
            if (num_text == 0)
                text = 0;
        }
        if (comment == 0 && line_comment == 0 && apostrophe_text == 0 && macro==0) // FIXME: lo de macro se puede quitar, entonces 
	  // cuando ponga: #include "caca.h", no podra leer caca.h, ya que se salta los textos (funcion: cedit_get_include_file)
        {
            if (l_line -> text [cont] =='\"')
            {
                count = cont - 1;
                count2 = 0;
                while (count >= 0 && l_line -> text [count] =='\\')
                {
                    count --;
                    if (count2 == 0) count2 = 1; else count2 = 0;
                }
                if (count2 == 0)
                {
                    if (text == 0) { text = 1; } else { num_text = 1; }
                }
            }
        }
        
            // miro si es un texto con apostrofes 'a'
        if (num_apostrophe_text > 0)
        {
            num_apostrophe_text --;
            if (num_apostrophe_text == 0)
                apostrophe_text = 0;
        }
        if (comment == 0 && line_comment == 0 && text == 0)
        {
            if (l_line -> text [cont] =='\'')
            {
                count = cont - 1;
                count2 = 0;
                while (count >= 0 && l_line -> text [count] =='\\')
                {
                    count --;
                    if (count2 == 0) count2 = 1; else count2 = 0;
                }
                if (count2 == 0)
                {
                    if (apostrophe_text == 0) { apostrophe_text = 1; } else { num_apostrophe_text = 1; }
                }
            }
        }
        
            // miro si es un comentario de linea, como este
        if (comment == 0 && line_comment == 0 && text == 0 && apostrophe_text == 0)
            if (cont < l_line -> num_char - 1)  // cuidado de no mirar demasiado lejos
                if (l_line -> text [cont] =='/' && l_line -> text [cont + 1] =='/')
                    line_comment = 1;
        
            // miro si es un comentario de muchas lineas: /* asdf */
            // primero busco el inicio /*
        if (num_comment > 0)  // contador para poder comentar el */ final, sino no saldria comentado
        {
            num_comment --;
            if (num_comment == 0)
                comment = 0;
        }
        if (comment == 0 && line_comment == 0 && text == 0 && apostrophe_text == 0)
            if (cont < l_line -> num_char - 1)  // cuidado de no mirar demasiado lejos
                if (l_line -> text [cont] =='/' && l_line -> text [cont + 1] =='*')
                    comment = 1;
            // ahora el final
        if (comment == 1)
            if (cont < l_line -> num_char - 1)  // cuidado de no mirar demasiado lejos
                if (l_line -> text [cont] =='*' && l_line -> text [cont + 1] =='/')
                    num_comment = 2;  // para que ponga como comentarios el */
        
        
            // si alguno de estos esta activo, no miro mas flags, ya que no son validos
            // (no se permite una palabra reservada en un comentario)
        if (line_comment == 0 && comment == 0 && text == 0 && apostrophe_text == 0)
        {
                // miro si es una letra, un numero o un signo
            if ((l_line -> text [cont] >='a' && l_line -> text [cont] <='z') ||
                (l_line -> text [cont] >='A' && l_line -> text [cont] <='Z'))
            {
                character = 1;
                number = 0;
                mark = 0;
            }
            else if (l_line -> text [cont] >='0' && l_line -> text [cont] <='9')
            {
                number = 1;
                mark = 0;
                character = 0;
            }
            else
            {
                mark = 1;
                character = 0;
                number = 0;
            }
	    reserved_word=0;
        }
        else
        {
            reserved_word = 0;
            character = 0;
            number = 0;
            mark = 0;
        }
        
            // ahora pongo el flag de la letra
        l_line -> flags [cont] = 0;
        if (character) l_line -> flags [cont] += cedit_flag_character;
        if (number) l_line -> flags [cont] += cedit_flag_number;
        if (mark) l_line -> flags [cont] += cedit_flag_mark;
        if (macro) l_line -> flags [cont] += cedit_flag_macro;
        if (reserved_word) l_line -> flags [cont] += cedit_flag_reserved_word;
        if (line_comment) l_line -> flags [cont] += cedit_flag_line_comment;
        if (comment) l_line -> flags [cont] += cedit_flag_comment;
        if (text) l_line -> flags [cont] += cedit_flag_text;
        if (apostrophe_text) l_line -> flags [cont] += cedit_flag_apostrophe_text;
    }
    return 0;
}


// --------------------------------------------------------------------
//  Devuelve la linea y fichero del lugar donde se defini una palabra
// --------------------------------------------------------------------
definition_db *cedit_cgo_to_definition(CEdit *cedit, int n_cursor)
{
  CEditCursor cursor;
  char ch;
  unsigned int flag;

  cedit_free_result_definition_db(cedit,cedit->result_def_db);

  cursor.x=cedit->cursors[n_cursor].x;
  cursor.y=cedit->cursors[n_cursor].y;
  cursor.l_line=cedit->cursors[n_cursor].l_line;

  cedit_get_this_real_char(cedit, &cursor, &ch, &flag);
  if ((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' ||
      (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
      (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text)) 
    {   
      return cedit_get_cursor_definition_db_recursive(cedit, &cursor, 0);      
    }
  else
    return NULL;
}

// ---------------------------------------------------------
//  Devuelve la definicin que esta en el cursor, recursiva
// ---------------------------------------------------------
definition_db *cedit_get_cursor_definition_db_recursive(CEdit *cedit, CEditCursor *cursor, int depth)
{
  char *word;
  definition_db *def_db;
  int count;
  char exit_cond;

  word=(char*)malloc(sizeof(char)*1000);
  word[0]='\0';   

  if (cedit_get_last_real_word (cedit, cursor, word)==-1) // si no ha encontrado nada
    {
      g_print("No encontrado\n");
      free(word);
      return NULL;
    }

  //  g_print("..%s..", word);
  def_db=cedit_search_db_value_file(cedit, word, cursor->y,0, NULL, depth);
  if (def_db==NULL) // si no lo he encontrado, quizas sea un miembro de una estructura, miro la palabra anterior
    {
      def_db=cedit_get_cursor_definition_db_recursive(cedit, cursor,(depth+1)); // busco la anterior
      if (def_db!=NULL)
	{
	  if (def_db!=NULL && def_db->n_args>0 && def_db->is_deleted==0)
	    {
	      // miro si yo soy alguno de sus parmetros
	      count=0;
	      exit_cond=1;
	      // miro el bucle con count = 0
	      if (def_db->definition_type_args!=NULL) // si el padre tiene argumentos
		exit_cond=cedit_strcmp(word, def_db->definition_type_args[count]->name); // miro si se llama igual que mi palabra
	      
	      // bucle para count>0
	      while (count<def_db->n_args && exit_cond!=0) // lo busco en sus argumentos
		{
		  count++;
		  if (def_db->definition_type_args[count]!=NULL && count<def_db->n_args)
		    exit_cond=cedit_strcmp(word, def_db->definition_type_args[count]->name);
		}
	      
	      if (exit_cond==0) // si lo he encontrado
		cedit_insert_result_definition_db(cedit, def_db->definition_type_args[count],cedit->result_def_db);
	    }
	  
	  else if (def_db->definition_type!=NULL && def_db->definition_type->n_args>0  && def_db->is_deleted==0)
	    {
	      def_db=def_db->definition_type;
	      // miro si yo soy alguno de sus parmetros
	      count=0;
	      exit_cond=1;
	      // miro el bucle con count = 0
	      if (def_db->definition_type_args!=NULL) // si el padre tiene argumentos
		exit_cond=cedit_strcmp(word, def_db->definition_type_args[count]->name); // miro si se llama igual que mi palabra
	      
	      // bucle para count>0
	      while (count<def_db->n_args && exit_cond!=0) // lo busco en sus argumentos
		{
		  count++;
		  if (def_db->definition_type_args[count]!=NULL && count<def_db->n_args)
		    exit_cond=cedit_strcmp(word, def_db->definition_type_args[count]->name);
		}
	      
	      if (exit_cond==0) // si lo he encontrado
		cedit_insert_result_definition_db(cedit, def_db->definition_type_args[count],cedit->result_def_db);
	    }
	  else
	    def_db=NULL;
	}
      else
	def_db=NULL;
    }

  if (def_db!=NULL)
    if (def_db->is_deleted!=0)
      {
	g_print("s");
	def_db=NULL;
      }
  free(word);
  return def_db;
}

// ------------------------------
//  Devuelve la palabra anterior
// ------------------------------
int cedit_get_last_real_word(CEdit *cedit, CEditCursor *cursor, char *word)
{
  char ch;
  long i;
  long last_char_x;
  unsigned int flag;


  i=0;
  word[0]='\0';

  // esto es posible (que el cursor este fuera de rango)
  while (cursor->x<0)
    {
      cursor->y--;
      cursor->l_line=cursor->l_line->prev; // si he acabado el fichero, lo dejo
      if (cursor->l_line==NULL)
	return -1;
      cursor->x=cursor->l_line->num_char;
    }

  cedit_get_this_real_char(cedit, cursor, &ch, &flag);
  last_char_x=cursor->x;
  // retrocedo signos raros
  while (!((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' || (ch>='0' && ch<='9')) ||
	 (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
	 (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text))
    {
      cursor->x--;
      while (cursor->x<0)
	{
	  cursor->y--;
	  cursor->l_line=cursor->l_line->prev; // si he acabado el fichero, lo dejo
	  if (cursor->l_line==NULL)
	    return -1;
	  cursor->x=cursor->l_line->num_char;
	}
      cedit_get_this_real_char(cedit, cursor, &ch, &flag);
    }

  // retrocedo la palabra
  while ((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' || (ch>='0' && ch<='9') ||
	 (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
	 (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text))
    {
      if ((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' ||
	  (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
 	  (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text))
	last_char_x=cursor->x;

      cursor->x--;

      cedit_get_this_real_char(cedit, cursor, &ch, &flag);
    }

  cursor->x=last_char_x; // coloco el cursor en el ltimo carcter vlido

  // cojo la palabra
  cedit_get_this_real_char(cedit, cursor, &ch, &flag);
  while ((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' || (ch>='0' && ch<='9') ||
	 (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
	 (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text))
    {
      word[i]=ch;
      i++;
      cursor->x++;
      cedit_get_this_real_char(cedit, cursor, &ch, &flag);
    }
  word[i]='\0';

  cursor->x=last_char_x-1; // coloco el cursor en el ltimo carcter vlido
      if (i==0) return -1; // no he encontrado nada
      return 0;
      }
 
// ----------------------
//  Devuelve el caracter 
// ----------------------
int cedit_get_this_real_char(CEdit *cedit, CEditCursor *cursor, char *ch, unsigned int *flag)
{
  if (cursor->l_line==NULL) return 0;
  
  if (cursor->x>=0 && cursor->x<cursor->l_line->num_char)
    {
      (*ch)=cursor->l_line->text[cursor->x];
      (*flag)=cursor->l_line->flags[cursor->x];
      return 0;
    }
  else
    {
      (*ch)=' ';
      (*flag)=0;
      return -1;
    }
}
  
  
// ----------------------------------------------------
//  Devuelve una lista de definiciones que se sugieren
// ----------------------------------------------------
int cedit_cget_suggestion(CEdit *cedit, int n_cursor)
{
  suggest_data *data;
  CEditCursor cursor;
  char ch;
  unsigned int flag;
  char *word;

  cedit_free_result_definition_db(cedit,cedit->result_suggest_def_db);

  cursor.x=cedit->cursors[n_cursor].x;
  cursor.y=cedit->cursors[n_cursor].y;
  cursor.l_line=cedit->cursors[n_cursor].l_line;

  cedit_get_this_real_char(cedit, &cursor, &ch, &flag);
  if ((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' ||
      (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
      (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text)) 
    {   

      word=(char*)malloc(sizeof(char)*1000);
      word[0]='\0';   
      
      if (cedit_get_last_real_word (cedit, &cursor, word)==-1) // si no ha encontrado nada
	{
	  g_print("No encontrado\n");
	  free(word);
	  return -1;
	}

      data=(suggest_data*)malloc(sizeof(suggest_data));
      data->word=word;
      data->cedit=cedit;
      data->y=cursor.y;
      cedit_search_all_suggest_db_value(cedit, data,0);
      if (cedit->result_suggest_def_db==NULL) // no ha encontrado nada
	cedit_search_all_suggest_db_value(cedit, data,1);
      free(word);
      free(data);
      return 0;
    }
  else
    return -1;
  return -1; // para que no se queje el compilador
}

// ----------------------------------
//  Establece la sugerencia adoptada
// ----------------------------------
int cedit_cset_suggestion(CEdit *cedit, int n_cursor, char* text)
{
  CEditCursor cursor;
  char ch;
  unsigned int flag;

  cedit_free_result_definition_db(cedit,cedit->result_suggest_def_db);

  cursor.x=cedit->cursors[n_cursor].x;
  cursor.y=cedit->cursors[n_cursor].y;
  cursor.l_line=cedit->cursors[n_cursor].l_line;

  cedit_get_this_real_char(cedit, &cursor, &ch, &flag);
  if ((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' ||
      (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
      (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text)) 
    {   
      cedit_get_last_real_word_position(cedit, &cursor);

      cedit_cmove_cursor(cedit, n_cursor, cursor.x, cursor.y);

      cedit_get_this_real_char(cedit, &cursor, &ch, &flag);
      while((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' ||
	    (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
	    (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text)) 
	{
	  cedit_cdel_char(cedit, n_cursor);
	  cursor.x=cedit->cursors[n_cursor].x;
	  cursor.y=cedit->cursors[n_cursor].y;
	  cursor.l_line=cedit->cursors[n_cursor].l_line;
	  cedit_get_this_real_char(cedit, &cursor, &ch, &flag);
	}
      
      cedit_cput_text (cedit, n_cursor, text);
      
      return 0;
    }
  else
    return -1;
  return -1; // para que no se queje el compilador
}

// ---------------------------------------------
//  Mueve el cursor al inicio la palabra actual
// ---------------------------------------------
int cedit_get_last_real_word_position(CEdit *cedit, CEditCursor *cursor)
{
  char ch;
  long i;
  long last_char_x;
  unsigned int flag;


  i=0;

  // esto es posible (que el cursor este fuera de rango)
  while (cursor->x<0)
    {
      cursor->y--;
      cursor->l_line=cursor->l_line->prev; // si he acabado el fichero, lo dejo
      if (cursor->l_line==NULL)
	return -1;
      cursor->x=cursor->l_line->num_char;
    }

  cedit_get_this_real_char(cedit, cursor, &ch, &flag);
  last_char_x=cursor->x;
  // retrocedo signos raros
  while (!((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' || (ch>='0' && ch<='9')) ||
	 (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
	 (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text))
    {
      cursor->x--;
      while (cursor->x<0)
	{
	  cursor->y--;
	  cursor->l_line=cursor->l_line->prev; // si he acabado el fichero, lo dejo
	  if (cursor->l_line==NULL)
	    return -1;
	  cursor->x=cursor->l_line->num_char;
	}
      cedit_get_this_real_char(cedit, cursor, &ch, &flag);
    }

  // retrocedo la palabra
  while ((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' || (ch>='0' && ch<='9') ||
	 (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
	 (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text))
    {
      if ((ch>='a' && ch<='z') || (ch>='A' && ch<='Z') || ch=='_' ||
	  (flag & cedit_flag_comment) || (flag & cedit_flag_line_comment) || (flag & cedit_flag_macro) ||
 	  (flag & cedit_flag_text) || (flag & cedit_flag_apostrophe_text))
	last_char_x=cursor->x;

      cursor->x--;

      cedit_get_this_real_char(cedit, cursor, &ch, &flag);
    }

  cursor->x=last_char_x; // coloco el cursor en el ltimo carcter vlido
  return 0;
}

// -------------------------------------------------------------------------------------
//  Busca todas las definiciones, la peculiaridad es que la definicion es una definicion+numero
//  esta funcin se le ha de pasar el fichero. Los resultados lo mete en la pila de
//  _result_definition_db (solo si no_insert_values==0), devuelve el mejor de todos
// -------------------------------------------------------------------------------------
definition_db *cedit_search_db_value_file(CEdit *cedit, char *key, long y, int depth, char *file, int no_insert_values)
{
  char text[1000];
  char key2[1000];
  int count;
  definition_db *def_db;
  definition_db *better_def_db;

  if (key==NULL) return NULL;
  if (strlen(key)==0) return NULL;
  if (depth>255 && depth<500) // si me he llamado recursivamente demasiado, paro (500 es especial, es q quiero buscar sin recursividad)
    return NULL;

  strcpy(key2,key);
  if (key2[strlen(key2)-1]=='(') // las funciones son ignoradas
    key2[strlen(key2)-1]='\0';

  count=0;

  // formo la palabra que voy a guardar, que es la palabra original y un numero identificador y Ãºnico
  sprintf(text, "%s%d",key2,count);
  //  g_print("text:%s\n",text);
  def_db=g_tree_lookup (cedit -> words_db, text);
  while (def_db!=NULL)
    {
      if (((def_db->n_line_min_boundary<=y && def_db->n_line_max_boundary>=y) || // si la linea esta entre los limites
	  (def_db->n_line_max_boundary==-1)) && def_db->is_deleted==0)  // o es una variable global
	{
	  if (no_insert_values==0)
	    cedit_insert_result_definition_db(cedit, def_db,cedit->result_def_db); // lo inserto en los resultados
	  better_def_db=def_db;
	  
	  // ahora busco una definicion mejor, alguna que tenga mas argumentos o que tenga
	  // mayor , sino la encuentro
	  // pues dejo la que tengo
	      
	  count++;
	  sprintf(text, "%s%d",key2,count);
	  def_db=g_tree_lookup (cedit -> words_db, text);
	  while (def_db!=NULL)
	    {
	      if (((def_db->n_line_min_boundary<=y && def_db->n_line_max_boundary>=y) || // si la linea esta entre los limites
		  def_db->n_line_max_boundary==-1) && def_db->is_deleted==0) // o es una variable global
		{
		  if (no_insert_values==0)
		    cedit_insert_result_definition_db(cedit, def_db,cedit->result_def_db); // lo inserto en los resultados
		  if (def_db->type > better_def_db->type)
		    better_def_db=def_db;
		  else if (def_db->n_args>better_def_db->n_args &&
			   def_db->type>=better_def_db->type)
		    better_def_db=def_db;
		  else if (cedit_strcmp(def_db->file,file)==0)
		    better_def_db=def_db;
		}
	      count++;
	      sprintf(text, "%s%d",key2,count);
	      def_db=g_tree_lookup (cedit -> words_db, text);
	    }

	  if (better_def_db->type==cedit_dw_typedef && better_def_db->typedef_name!=NULL) // si es de typedef, busco por el nombre de su tipo
	    {
	      if (cedit_strcmp(better_def_db->typedef_name,key2)!=0)
		return cedit_search_db_value_file(cedit, better_def_db->typedef_name, y, ++depth, file, no_insert_values);
	      return better_def_db;
	    }
	  return better_def_db;
	  
	}
      // busco la siguiente
      count++;
      sprintf(text, "%s%d",key2,count);
      def_db=g_tree_lookup (cedit -> words_db, text);
    }
  return NULL;
}

// -------------------------------------------------------------------------------------
//  Busca todas las definiciones, la peculiaridad es que la definicion es una definicion+numero
//  esta funcin se le ha de pasar el fichero. Los resultados lo mete en la pila de
//  _result_definition_db (solo si no_insert_values==0), devuelve el mejor de todos
// la otra peculiaridad es que busca: "key*"
// -------------------------------------------------------------------------------------
int cedit_search_all_suggest_db_value(CEdit *cedit, suggest_data *data, gint extended)
{
  char key[1000];

  if (data->word==NULL) return -1;
  if (strlen(data->word)==0) return -1;

  strcpy(key,data->word);
  if (data->word[strlen(data->word)-1]=='(') // las funciones son ignoradas
    data->word[strlen(data->word)-1]='\0';

  if (extended==0)
    // los recorro todos
    g_tree_foreach(cedit->words_db,
		   cedit_get_all_suggested_words,
		   data);
  else
    // los recorro todos sin considerar el ambito
    g_tree_foreach(cedit->words_db,
		   cedit_get_all_suggested_words_extend,
		   data);
  strcpy(data->word,key);
  return 0;
}


// ------------------------------------------------------------
//  funcin que se recorre todos los nodos de la base de datos
//  inserta como resultado todos los que key >= data->word
// ------------------------------------------------------------
gboolean cedit_get_all_suggested_words (gpointer _key,
					gpointer _value,
					gpointer _data)
{
  char *key;
  definition_db *value;
  suggest_data *data;
    int i;
    char insert;
    int salir;
    
    key=(char*)_key;
    value=(definition_db*)_value;
    data=(suggest_data*) _data;
    if (key==NULL || data->word==NULL) return FALSE;
    if (value->is_deleted!=0) return FALSE;


    salir=0;

    
    i = 0;

    while(salir==0)
      {
	if (i<strlen(key) && i<strlen(data->word))
	  {
	    if (key[i]==data->word[i])
	      i++;
	    else
	      salir=1;
	  }
	else
	  {
	    salir=1;
	  }
	//	i++;
      }

    //    i = 0;    
    //    while (i < strlen (key) && i < strlen (data->word) && key [i] == data->word [i])
    //        i ++;
    
    insert=0;
    //    if (i == strlen (key) && i == strlen (data->word))
    //      insert=1;
    if (i == strlen (data->word))
      {
	insert=1;
      }

    // si esta en su rango
    if (insert==1 && 
	((value->n_line_min_boundary<=data->y && value->n_line_max_boundary>=data->y) || // si la linea esta entre los limites
	value->n_line_max_boundary==-1))                                    // o es una variable global
      {
      cedit_insert_result_definition_db(data->cedit, value, data->cedit->result_suggest_def_db); // lo inserto en los resultados de sugerencia
      //      g_print ("%s\n", (char *) key);
      }
    return FALSE;
}

// ------------------------------------------------------------
//  funcin que se recorre todos los nodos de la base de datos
//  inserta como resultado todos los que key >= data->word
//  no mira el mbito
// ------------------------------------------------------------
gboolean cedit_get_all_suggested_words_extend (gpointer _key,
					       gpointer _value,
					       gpointer _data)
{
  char *key;
  definition_db *value;
  suggest_data *data;
    int i;
    char insert;
    int salir;
    

    key=(char*)_key;
    value=(definition_db*)_value;
    data=(suggest_data*)_data;
    if (key==NULL || data->word==NULL) return FALSE;


    salir=0;

    
    i = 0;

    while(salir==0)
      {
	if (i<strlen(key) && i<strlen(data->word))
	  {
	    if (key[i]==data->word[i])
	      i++;
	    else
	      salir=1;
	  }
	else
	  {
	    salir=1;
	  }
      }
    
    insert=0;
    if (i == strlen (data->word))
      {
	cedit_insert_result_definition_db(data->cedit, value, data->cedit->result_suggest_def_db); // lo inserto en los resultados de sugerencia
      }
    return FALSE;
}

// -------------------------------------------
//  Inserta un valor en la pila de resultados
// -------------------------------------------
int cedit_insert_result_definition_db(CEdit *cedit, definition_db *def_db, result_definition_db *result)
{
  result_definition_db *temp;
  result_definition_db *new_result_def_db;
  definition_db *new_def_db;

  // creo el nuevo elemento
  new_result_def_db=(result_definition_db*)malloc(sizeof(result_definition_db)*1);
  new_result_def_db->next=NULL;


  new_def_db=cedit_copy_definition_db(cedit, def_db);
  if (new_def_db==NULL)
    {
      free (new_result_def_db);
      return -1;
    }
    

  new_result_def_db->def_db=new_def_db;

  // lo coloco
  temp=result;

  if (temp==NULL)
    {
      if (result==cedit->result_def_db)
	cedit->result_def_db=new_result_def_db;
      else if (result==cedit->result_suggest_def_db)
	cedit->result_suggest_def_db=new_result_def_db;
      return 0;
    }
  while (temp->next!=NULL)
    temp=temp->next;

  temp->next=new_result_def_db;
  return 0;
}

// ---------------------------------
//  Crea una copia un definition_db 
// ---------------------------------
definition_db *cedit_copy_definition_db (CEdit *cedit, definition_db *def_db)
{
  definition_db *new_def_db;
  int i;
  
  if (def_db==NULL) return NULL;

  // copio el def_db;
  new_def_db = NULL;
  new_def_db =(definition_db *) malloc (sizeof (definition_db));
  if (new_def_db == NULL) 
    {
      return NULL;
    }
     
  new_def_db->name=strdup(def_db->name);
   //  new_def_db -> name =(char *) malloc ((strlen (def_db->name)+2) *sizeof (char));
  if (new_def_db -> name == NULL)
    {
      free (new_def_db);
      return NULL;
    }
  //  strcpy (new_def_db -> name, def_db->name);

  new_def_db->typedef_name=NULL;
  if (def_db->typedef_name!=NULL)
    {
      new_def_db -> typedef_name = strdup(def_db->typedef_name);
      //      new_def_db -> typedef_name =(char *) malloc ((strlen (def_db->typedef_name)+2) *sizeof (char));
      if (new_def_db -> typedef_name == NULL)
	{
	  free (new_def_db->name);
	  free (new_def_db);
	  return NULL;
	}
      //      strcpy(new_def_db->typedef_name, def_db->typedef_name);      
    }
  
  new_def_db -> name_long = strlen (def_db->name);
  new_def_db -> type = def_db->type;
  
  
  if (def_db->n_args >0)
    {
      new_def_db->definition_type_args=NULL;
      new_def_db -> definition_type_args =(definition_db **) malloc (def_db->n_args *sizeof (definition_db *));
      if (new_def_db -> definition_type_args == NULL)
        {
	  free (new_def_db -> typedef_name);
	  free (new_def_db -> name);
	  free (new_def_db);
	  return NULL;
        }
      for (i = 0; i < def_db->n_args; i ++)
        {
	  if (def_db->definition_type_args!=NULL)
	    	    new_def_db->definition_type_args[i]=def_db->definition_type_args[i];
	  /*
	    {
	      //	      if (def_db->definition_type_args[i]->file!=NULL)
	      //		new_def_db->definition_type_args[i]=def_db->definition_type_args[i];
	      //	      else
		new_def_db->definition_type_args[i]=cedit_copy_definition_db(cedit, def_db->definition_type_args[i]);
	      //	      new_def_db->definition_type_args[i]=NULL;
	    }
	  */
	  else
	    new_def_db->definition_type_args=NULL;
        }
    }
  else
    {
      new_def_db->definition_type_args=NULL;
    }
  new_def_db->n_args=def_db->n_args;
  
  new_def_db -> definition_type = def_db->definition_type;
  //  new_def_db -> definition_type = cedit_copy_definition_db(cedit, def_db->definition_type);
  //	      if (def_db->definition_type_args[i]->file!=NULL)
  //		new_def_db->definition_type_args[i]=def_db->definition_type_args[i];
  //	      else
    //  new_def_db->definition_type_args[i]=
  //	      new_def_db->definition_type_args[i]=NULL;
  new_def_db -> n_line = def_db->n_line;
  new_def_db->file=NULL;
  
  if (def_db->file!=NULL)
    {
      new_def_db->file=strdup(def_db->file);
      //      new_def_db->file=(char*)malloc(strlen(def_db->file)*sizeof(char)+2);
      if (new_def_db->file==NULL)
	{
	  free(new_def_db->name);
	  free(new_def_db->typedef_name);
	  free(new_def_db);	
	  return NULL;
	}
      //      strcpy(new_def_db->file, def_db->file);
    }
  new_def_db -> n_line_min_boundary = def_db->n_line_min_boundary;
  new_def_db -> n_line_max_boundary = def_db->n_line_max_boundary;
  new_def_db->is_deleted=def_db->is_deleted;
  //  g_print("%s\n", new_def_db->name);
  return new_def_db;
}
// -----------------------------------------
//  Limpia de valores la pila de resultados
// -----------------------------------------
int cedit_free_result_definition_db(CEdit *cedit, result_definition_db *result)
{
  result_definition_db *actual;
  result_definition_db *prev;

  actual=result;
  while(actual!=NULL)
    {
      prev=actual;
      actual=actual->next;
      if (prev->def_db->name!=NULL)
	free(prev->def_db->name);
      if (prev->def_db->typedef_name!=NULL)
	free(prev->def_db->typedef_name);
      free(prev->def_db);	
      free(prev);
    }

  
  if (result==cedit->result_def_db)
    cedit->result_def_db=NULL;
  else if (result==cedit->result_suggest_def_db)
    cedit->result_suggest_def_db=NULL;
  return 0;
}


// ----------------------------------------------
//  Devuelve el primer resultado de una bsqueda
// ----------------------------------------------
result_definition_db *cedit_get_first_result(CEdit *cedit)
{
  return cedit->result_def_db;
}

// ----------------------------------------------
//  Devuelve el siguiente resultado de una bsqueda
// ----------------------------------------------
result_definition_db *cedit_get_next_result(CEdit *cedit, result_definition_db *def_db)
{
  if (def_db!=NULL)
    return def_db->next;
  return NULL;
}

// ----------------------------------------------
//  Devuelve el primer resultado de una bsqueda
// ----------------------------------------------
result_definition_db *cedit_get_first_result_suggest(CEdit *cedit)
{
  return cedit->result_suggest_def_db;
}

// ------------------------------------
//  Devuelve el nombre de una bsqueda
// ------------------------------------
char *cedit_get_name_result(CEdit *cedit, result_definition_db *res_def_db)
{
  //  char *name;

  if (res_def_db==NULL) return NULL;
  if (res_def_db->def_db==NULL) return NULL;
  if (res_def_db->def_db->name==NULL) return NULL;

  //  name=(char*)malloc(sizeof(char)*strlen(res_def_db->def_db->name));
  //  strcpy(name, res_def_db->def_db->name);
  return strdup(res_def_db->def_db->name);
}
// ------------------------------------
//  Devuelve la linea de una bsqueda
// ------------------------------------
long cedit_get_line_result(CEdit *cedit, result_definition_db *res_def_db)
{
  if (res_def_db==NULL) return -1;
  if (res_def_db->def_db==NULL) return -1;

  return res_def_db->def_db->n_line;
}
// ---------------------------------------------
//  Devuelve el nombre del fichero una bsqueda
// ---------------------------------------------
char *cedit_get_filename_result(CEdit *cedit, result_definition_db *res_def_db)
{

  if (res_def_db==NULL) return NULL;
  if (res_def_db->def_db==NULL) return NULL;
  if (res_def_db->def_db->file==NULL) return NULL;

  return strdup(res_def_db->def_db->file);
}

// ------------------------
//  Aade un rbol en otro
// ------------------------
GTree* cedit_copy_tree(CEdit *cedit, GTree *source, GTree *dest)
{
  cedit->copy_db=dest;
  g_tree_foreach(source,
		 cedit_copy_tree_callback,
		 cedit);
  return cedit->copy_db;
}

// -----------------------
//  Aade un nodo en otro
// -----------------------
gboolean cedit_copy_tree_callback (gpointer _key,
				   gpointer _value,
				   gpointer _cedit)
{
  char *key;
  definition_db *value;
  CEdit *cedit;
  definition_db *def_db;
  //  int count;
  //  char text[1000];

  key=(char*)_key;
  value=(definition_db*)_value;
  cedit=(CEdit*)_cedit;
  if (value==NULL || key==NULL)
    return 0;
  //  count=0;
  // las palabras se almacenan como texto y numero
  //  sprintf(text, "%s%d",name2,count);
  def_db=g_tree_lookup (cedit -> copy_db, key);
  if (def_db==NULL)
    //  while (def_db!=NULL)

    {  
      g_tree_insert (cedit->copy_db, strdup(key), cedit_copy_definition_db (cedit, value));  
      cedit->num_definition_words++;
    }
  return FALSE;
}


gint caca (gpointer key, gpointer value, gpointer data)
{
  definition_db *as;
  as=(definition_db*)value;
  g_print("%s %s\n",(char*)key, as->file);
  return 0;
}

// ---------------------------
//  Copia las lineas de CEdit
// ---------------------------
line *cedit_copy_lines(CEdit *cedit)
{
  /*
  line *first_line;
  line *l_line;
  
  l_line=cedit_new_line(NULL, NULL);
  */


  //    char character;
    line *first;
    line *actual;
    line *new_line;
    line *l_line; // apuntador al texto
    long count;
    //    long y;
    //    char ignore;
    char prev_restart_correct_now;


    if (cedit == NULL) return NULL;

    first=cedit_new_line(cedit, NULL, NULL);
    actual=first;
    l_line=cedit->first;

        // por cada byte
    prev_restart_correct_now=cedit->restart_correct_now;
    while (l_line !=NULL)
      {
	if (cedit_realloc_text (cedit, actual, l_line->num_char + 3) < 0)
	  {
	    g_print("Sin memoria");
	    return first;
	  }
	l_line->text[l_line->num_char]='\0';
	strcpy(actual->text, l_line->text);
	
	for (count=0;count<l_line->num_char;count++)
	  {
	    //	    actual->text[count]=l_line->text[count];
	    actual->flags[count]=l_line->flags[count];
	  }
	actual->num_char=l_line->num_char;
	actual->flags[actual->num_char]=0;

	
	new_line=cedit_new_line(cedit, actual, NULL);
	actual->next=new_line;
	new_line->prev=actual;
	new_line->next=NULL;
	actual=actual->next;
	l_line=l_line->next;
    }

    cedit->restart_correct_now=prev_restart_correct_now;
    
    //    g_mutex_lock (cedit -> mutex_text);    // bloqueamos para no acceder al texto
    
        //   *progress=1.0;
    return first;  
}

// -------------------------------------
//  Devuelve el directorio de un camino
// -------------------------------------
char *cedit_get_directory(CEdit *cedit, char *orig)
{
  char *dest;
  int i, j;
  int last_slash_pos;

  if (orig==NULL) return NULL;

  dest=NULL;
  dest=(char*)malloc(strlen(orig)*sizeof(char));
  if (dest==NULL)
    return NULL;

  i=0;
  last_slash_pos=0;
  while (i<strlen(orig))
    {
      if (orig[i]=='/')
	last_slash_pos=i;
      i++;
    }

  for (j=0;j<=last_slash_pos;j++)
    dest[j]=orig[j];

  if (dest[j]!='/')
    dest[j]='\0';
  else
    dest[j+1]='\0';
  return dest;

}
