/*
GtkCEdit
Copyright (C) 2002 Carlos RodrÃ­guez Caminero

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
/*
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#include "mark.xpm"
#include "gtkcedit.h"
#include <time.h>
#include <string.h>
#include <stdlib.h>

static void gtk_cedit_class_init        (GtkCEditClass    *class);
static void gtk_cedit_init              (GtkCEdit         *cedit);
static void gtk_cedit_destroy           (GtkObject        *object);
static void gtk_cedit_reset_values      (GtkCEdit *gtkcedit);
static void gtk_cedit_size_request      (GtkWidget        *widget, GtkRequisition   *requisition);
static void gtk_cedit_size_allocate     (GtkWidget        *widget, GtkAllocation    *allocation);
static gint gtk_cedit_expose            (GtkWidget        *widget, GdkEventExpose   *event);

static void gtk_cedit_realize           (GtkWidget        *widget);
static void gtk_cedit_draw        (GtkWidget        *widget,  GdkRectangle     *area);
static gint gtk_cedit_key_press         (GtkWidget        *widget, GdkEventKey      *event);
static gint gtk_cedit_button_press      (GtkWidget        *widget, GdkEventButton   *event);
static gint gtk_cedit_button_release    (GtkWidget        *widget, GdkEventButton   *event);
static gint gtk_cedit_motion_notify     (GtkWidget        *widget, GdkEventMotion   *event);

void gtk_cedit_paste_callback (GtkClipboard *clipboard, const gchar *text, gpointer _widget);

void gtk_cedit_redraw_back_buffer       (GtkWidget        *widget,  GdkRectangle *area);

static void gtk_cedit_adjustments_value_changed (GtkAdjustment *adjustment, GtkWidget *widget);

int gtk_cedit_NewColor (GdkColor *c, long red, long green, long blue);
GdkGC *gtk_cedit_GetPen (GtkWidget *widget, GdkColor *c);


void gtk_cedit_draw_back_cursor         (GtkWidget *widget);
void gtk_cedit_draw_cursor              (GtkWidget *widget);
gint gtk_cedit_move_scroll_to_show_cursor (GtkCEdit *cedit);
gint gtk_cedit_flick (gpointer data);
void gtk_cedit_progressbar_callback (double value, void *data);
void gtk_cedit_progressbar_set_text (GtkCEdit *gtkcedit, gchar *text);

int gtk_cedit_draw_line (GtkCEdit *gtkcedit, int x, int y, gchar *text, gint *flags, gint start, gint len, glong yline);
    //void gtk_cedit_test(GtkWidget *widget);
gint gtk_cedit_calculate_left_edge(GtkCEdit *gtkcedit);

void gtk_cedit_go_to_bookmark_0 (GtkCEdit *gtkcedit);
void gtk_cedit_go_to_bookmark_1 (GtkCEdit *gtkcedit);
void gtk_cedit_go_to_bookmark_2 (GtkCEdit *gtkcedit);
void gtk_cedit_go_to_bookmark_3 (GtkCEdit *gtkcedit);
void gtk_cedit_go_to_bookmark_4 (GtkCEdit *gtkcedit);
void gtk_cedit_go_to_bookmark_5 (GtkCEdit *gtkcedit);
void gtk_cedit_go_to_bookmark_6 (GtkCEdit *gtkcedit);
void gtk_cedit_go_to_bookmark_7 (GtkCEdit *gtkcedit);
void gtk_cedit_go_to_bookmark_8 (GtkCEdit *gtkcedit);
void gtk_cedit_go_to_bookmark_9 (GtkCEdit *gtkcedit);

void gtk_cedit_put_bookmark_0 (GtkCEdit *gtkcedit);
void gtk_cedit_put_bookmark_1 (GtkCEdit *gtkcedit);
void gtk_cedit_put_bookmark_2 (GtkCEdit *gtkcedit);
void gtk_cedit_put_bookmark_3 (GtkCEdit *gtkcedit);
void gtk_cedit_put_bookmark_4 (GtkCEdit *gtkcedit);
void gtk_cedit_put_bookmark_5 (GtkCEdit *gtkcedit);
void gtk_cedit_put_bookmark_6 (GtkCEdit *gtkcedit);
void gtk_cedit_put_bookmark_7 (GtkCEdit *gtkcedit);
void gtk_cedit_put_bookmark_8 (GtkCEdit *gtkcedit);
void gtk_cedit_put_bookmark_9 (GtkCEdit *gtkcedit);

void gtk_cedit_del_bookmark_0 (GtkCEdit *gtkcedit);
void gtk_cedit_del_bookmark_1 (GtkCEdit *gtkcedit);
void gtk_cedit_del_bookmark_2 (GtkCEdit *gtkcedit);
void gtk_cedit_del_bookmark_3 (GtkCEdit *gtkcedit);
void gtk_cedit_del_bookmark_4 (GtkCEdit *gtkcedit);
void gtk_cedit_del_bookmark_5 (GtkCEdit *gtkcedit);
void gtk_cedit_del_bookmark_6 (GtkCEdit *gtkcedit);
void gtk_cedit_del_bookmark_7 (GtkCEdit *gtkcedit);
void gtk_cedit_del_bookmark_8 (GtkCEdit *gtkcedit);
void gtk_cedit_del_bookmark_9 (GtkCEdit *gtkcedit);

gchar*
gtk_cedit_get_name (gchar *orig);


    //static GtkMiscClass *parent_class = NULL;
static GtkWidgetClass *parent_class = NULL;

static gboolean gtk_cedit_dead_grave, gtk_cedit_dead_acute, gtk_cedit_dead_diaeresis;  // para que funcione 'a `a ...

enum {
    HAVE_UNDO,
    HAVE_REDO,
    NO_HAVE_UNDO,
    NO_HAVE_REDO,
    LAST_SIGNAL
};

typedef struct _suggest_struct suggest_struct;

struct _suggest_struct
{
  GtkCEdit *gtkcedit;
  char *text;
};

void gtk_cedit_put_suggestion (suggest_struct *sug_res);

static guint gtk_cedit_signals [LAST_SIGNAL] = {0};


guint gtk_cedit_get_type (void)
{
    static guint cedit_type = 0;
    
        /* --- Si no esta creada todavia --- */
    if (!cedit_type)
    {
        static const GTypeInfo cedit_info =
        {
            sizeof (GtkCEditClass),
            NULL,           /* base_init */
            NULL,           /* base_finalize */
            (GClassInitFunc) gtk_cedit_class_init,
            NULL,           /* class_finalize */
            NULL,           /* class_data */
            sizeof (GtkCEdit),
            32,             /* n_preallocs */
            (GInstanceInitFunc) gtk_cedit_init,
        };
        
        cedit_type = g_type_register_static (GTK_TYPE_MISC, "GtkCEdit", &cedit_info, 0);
    }
    return cedit_type;
}


static void
gtk_cedit_class_init (GtkCEditClass *class)
{
        // inicializacion de los objetos basicos
        //GObjectClass *gobject_class = G_OBJECT_CLASS (class);
    GtkObjectClass *object_class = GTK_OBJECT_CLASS (class);
    GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (class);
    
    gtk_cedit_signals [HAVE_UNDO] =
    gtk_signal_new ("have_undo",
        GTK_RUN_FIRST,
        GTK_CLASS_TYPE (object_class),
        GTK_SIGNAL_OFFSET (GtkCEditClass, have_undo),
        gtk_marshal_NONE__NONE,
        GTK_TYPE_NONE, 0);
    gtk_cedit_signals [HAVE_REDO] =
    gtk_signal_new ("have_redo",
        GTK_RUN_FIRST,
        GTK_CLASS_TYPE (object_class),
        GTK_SIGNAL_OFFSET (GtkCEditClass, have_redo),
        gtk_marshal_NONE__NONE,
        GTK_TYPE_NONE, 0);
    gtk_cedit_signals [NO_HAVE_UNDO] =
    gtk_signal_new ("no_have_undo",
        GTK_RUN_FIRST,
        GTK_CLASS_TYPE (object_class),
        GTK_SIGNAL_OFFSET (GtkCEditClass, no_have_undo),
        gtk_marshal_NONE__NONE,
        GTK_TYPE_NONE, 0);
    gtk_cedit_signals [NO_HAVE_REDO] =
    gtk_signal_new ("no_have_redo",
        GTK_RUN_FIRST,
        GTK_CLASS_TYPE (object_class),
        GTK_SIGNAL_OFFSET (GtkCEditClass, no_have_redo),
        gtk_marshal_NONE__NONE,
        GTK_TYPE_NONE, 0);
    
    parent_class = gtk_type_class (gtk_widget_get_type ());
        //  parent_class = gtk_type_class (GTK_TYPE_MISC);
    
    object_class -> destroy = gtk_cedit_destroy;
    
    widget_class -> size_request = gtk_cedit_size_request;
    widget_class -> size_allocate = gtk_cedit_size_allocate;
    widget_class -> expose_event = gtk_cedit_expose;
    widget_class -> realize = gtk_cedit_realize;
    widget_class -> key_press_event = gtk_cedit_key_press;
    widget_class -> button_press_event = gtk_cedit_button_press;
    widget_class -> button_release_event = gtk_cedit_button_release;
    widget_class -> motion_notify_event = gtk_cedit_motion_notify;
    
}


static void
gtk_cedit_init (GtkCEdit *gtkcedit)
{
    GtkWidget *widget;
    gint count;
    
        //  g_print("--- inicializacion \n");
    widget = (GtkWidget *) gtkcedit;
    
    GTK_WIDGET_SET_FLAGS (widget, GTK_CAN_FOCUS);
    GTK_WIDGET_SET_FLAGS (widget, GTK_CAN_DEFAULT);
        //  GTK_WIDGET_SET_FLAGS(widget, GTK_HAS_FOCUS);
        //  gtk_widget_grab_focus(widget);
        //  gtk_widget_grab_default(widget);
    
        //    GTK_WIDGET_SET_FLAGS (cedit, GTK_NO_WINDOW);
        //cedit->char_height=20;
    
        // buffers graficos
    gtkcedit -> doble_buffer = NULL;
    gtkcedit -> Pleft_edge = NULL;
    
        //  gtkcedit->screen=cedit_init();
    gtkcedit -> edit = cedit_init ();
    if (gtkcedit -> edit == NULL)
    {
        g_error ("No se ha podido crear el gtkcedit");
        return;
    }
        //  cedit_toggle_insert_mode(gtkcedit->screen);
    cedit_set_limit_undo_redo (gtkcedit -> edit, 16);              // 16k de memoria para undo's
    
    gtkcedit -> Fnormal = gdk_font_load ("-Misc-Fixed-Medium-R-Normal--13-120-75-75-C-70-ISO8859-1");
    gtkcedit -> char_height = gdk_char_height (gtkcedit -> Fnormal, 'W');
    gtkcedit -> char_height += GTK_CEDIT_INTERLINE;
    gtkcedit -> char_width = gdk_char_width (gtkcedit -> Fnormal, 'G');
    
    gtkcedit -> hadj = GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, 1, 1, 0, 0));
    gtkcedit -> vadj = GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, gtkcedit -> char_height, gtkcedit -> char_height, 0, 0));
        //  cedit->last_hadj=GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, cedit->char_height, cedit->char_height, 0, 0));
        //cedit->last_vadj=GTK_ADJUSTMENT (gtk_adjustment_new (0, 0, cedit->char_height, cedit->char_height, 0, 0));
    
    gtk_signal_connect (GTK_OBJECT (gtkcedit -> vadj), "value_changed",
        (GtkSignalFunc) gtk_cedit_adjustments_value_changed,
        widget);
    gtk_signal_connect (GTK_OBJECT (gtkcedit -> hadj), "value_changed",
        (GtkSignalFunc) gtk_cedit_adjustments_value_changed,
        widget);
    
        //  strcpy(gtkcedit->name, "noname.c");
    gtkcedit -> name = NULL;
    
        //  gtkcedit->flick=true;
        //  gtkcedit->flick_interrupt = gtk_timeout_add(500, gtk_cedit_flick, gtkcedit);
    gtkcedit -> space_tabs = 4;
    gtkcedit -> space_width = gdk_char_width (gtkcedit -> Fnormal, ' ');
    
    gtkcedit -> flick = true;
    gtkcedit -> flick_interrupt = gtk_timeout_add (500, gtk_cedit_flick, gtkcedit);
    gtkcedit -> show_cursor = true;
    
    gtk_cedit_reset_values (gtkcedit);
    gtkcedit -> freeze = false;

    /*
    cedit_insert_include_path(gtkcedit->edit, "/usr/include/");
    cedit_insert_include_path(gtkcedit->edit, "/usr/local/include/");
    cedit_insert_include_path(gtkcedit->edit, "/usr/lib/gcc-lib/i386-redhat-linux/2.96/include/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/gtk-2.0/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/lib/gtk-2.0/include/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/atk-1.0/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/pango-1.0/");
    cedit_insert_include_path(gtkcedit->edit, "/usr/X11R6/include/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/freetype2/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/glib-2.0/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/lib/glib-2.0/include/");
    */

    gtkcedit->fast_scroll=true;
 
    for (count=0;count<10;count++)
      gtkcedit->line_mark[count]=-10;

    gtkcedit->mark_pixmap=NULL;

    gtkcedit->go_to_definition_callback=NULL;
    gtkcedit->go_to_definition_callback_data=NULL;

						      
        //cedit_toggle_fast_color(gtkcedit->edit);
        //cedit_toggle_fast_autoident(gtkcedit->edit);
}

    // valores iniciales de las variables
static void
gtk_cedit_reset_values (GtkCEdit *gtkcedit)
{
    GtkWidget *widget;
    
    widget =(GtkWidget *) gtkcedit;
    gtkcedit -> visible = TRUE;
    
    gtkcedit -> left_edge = 20;
    gtkcedit -> scroll_cursor = cedit_new_cursor (gtkcedit -> edit);
    if (gtkcedit -> scroll_cursor < 0)
    {
        g_error ("No se ha podido crear el cursor secundario");
        return;
    }
    
    if (gtkcedit -> name != NULL)
        free (gtkcedit -> name);
    gtkcedit -> name =(char *) malloc (10*sizeof(char));
    strcpy (gtkcedit -> name,"noname.c");
    
    gtk_cedit_dead_acute = false;
    gtk_cedit_dead_grave = false;
    gtk_cedit_dead_diaeresis = false;
    
    gtkcedit -> left_mouse_button = false;
    
    gtkcedit -> vadj -> value = 0;
    gtkcedit -> vadj -> lower = 0;
    gtkcedit -> vadj -> upper = gtkcedit -> char_height;
    gtkcedit -> vadj -> step_increment = 1;
    gtkcedit -> vadj -> page_increment = widget -> allocation.height;
    gtkcedit -> vadj -> page_size = widget -> allocation.height;
    
    gtkcedit -> hadj -> value = 0;
    gtkcedit -> hadj -> lower = 0;
    gtkcedit -> hadj -> upper = gtkcedit -> char_height;
    gtkcedit -> hadj -> step_increment = gtkcedit -> char_height;
    gtkcedit -> hadj -> page_increment =(widget -> allocation.width - gtkcedit -> left_edge) /(gdk_char_width (gtkcedit -> Fnormal, 'W'));
    gtkcedit -> hadj -> page_size =(widget -> allocation.width - gtkcedit -> left_edge) /(gdk_char_width (gtkcedit -> Fnormal, 'W'));
    
}


    // cuando se crea el cedit
GtkWidget*
gtk_cedit_new (void)
{
    GtkCEdit *gtkcedit;
    
#ifdef DEBUG
    g_print ("--- Nuevo \n");
#endif
    gtkcedit = gtk_type_new (GTK_TYPE_CEDIT);
    
    return GTK_WIDGET (gtkcedit);
        //  return gtk_type_new (gtk_cedit_get_type ());
}

    // cuando se destruye el cedit
static void
gtk_cedit_destroy (GtkObject *object)
{
    GtkCEdit *gtkcedit = GTK_CEDIT (object);
    
        // libero memoria del fichero de texto
#ifdef DEBUG
    g_print ("--- Destruccion \n");
#endif
    if (gtkcedit -> edit != NULL)
    {
        cedit_exit (gtkcedit -> edit);
        gtkcedit -> edit = NULL;
    }
    gtk_timeout_remove (gtkcedit -> flick_interrupt);
    
    GTK_OBJECT_CLASS (parent_class) -> destroy (object);
}


    /* es llamado cuando cambia de tamaÃ±o el cedit */
static void
gtk_cedit_size_allocate (GtkWidget     *widget,
    GtkAllocation *allocation)
{
    GtkCEdit *cedit;
        /* --- errores evidentes --- */
    g_return_if_fail (widget != NULL);
    g_return_if_fail (GTK_IS_CEDIT (widget));
    g_return_if_fail (allocation != NULL);
    
#ifdef DEBUG
    g_print ("--- allocate \n");
#endif
    
        //g_print("\nallocate %d %d %d %d", allocation->x, allocation->y, allocation->width, allocation->height);
    
    cedit = GTK_CEDIT (widget);
    
    
    
        // asi se redibuja todo
        //  clear_cedit(cedit->screen);
        // asi se redibuja todo
        //cedit_move_cursor(cedit->screen, 0, 0);
        //cedit_del_until_end_of_file(cedit->screen);
    
    widget -> allocation =*allocation;
    
    cedit -> vadj -> page_size = allocation -> height;
    cedit -> hadj -> page_size =(allocation -> width - cedit -> left_edge) /(gdk_char_width (cedit -> Fnormal, 'W'));
        //cedit->hadj->page_size=allocation->width;
    
    if (cedit -> vadj -> value + cedit -> vadj -> page_size > cedit -> vadj -> upper)
    {
        cedit -> vadj -> value = cedit -> vadj -> upper - cedit -> vadj -> page_size;
        if (cedit -> vadj -> value < 0) cedit -> vadj -> value = 0;
            //gtk_signal_emit_by_name(GTK_OBJECT(cedit->vadj), "changed");
    }
    
    
        //cedit->hadj->page_size=allocation->width/
        //gtk_signal_emit_by_name(GTK_OBJECT(cedit->vadj), "value_changed");
        //gtk_adjustment_changed(cedit->vadj);
    
        /* --- si no hay un doble buffer --- */
        //#ifdef GTK_CEDIT_DOBLE_BUFFER
    if (cedit -> doble_buffer)
        gdk_pixmap_unref (cedit -> doble_buffer);
    
        /* --- si ya existe el widget --- */
    if (GTK_WIDGET_REALIZED (widget))
    {
            //g_print("realized !!!");
        
            /* --- nuevo doble buffer --- */
        
        cedit -> doble_buffer = gdk_pixmap_new (widget -> window,
            allocation -> width,
            allocation -> height,
            - 1);
        
        cedit -> redraw_all = true;
        gtk_cedit_redraw_back_buffer (widget, NULL);
            //gtk_cedit_draw();
        
            /* ---se indica que se ha movido y tiene que ser redibujado --- */
        gdk_window_move_resize (widget -> window,
            allocation -> x, allocation -> y,
            allocation -> width, allocation -> height);
        
    }
        //#endif
        //#ifndef GTK_CEDIT_DOBLE_BUFFER
        //gtk_cedit_redraw_back_buffer(widget, allocation);
        //#endif
    
    cedit -> redraw_all = true;
    gtk_cedit_redraw_back_buffer (widget, NULL);
    
}


    /* es llamada cuando se expone una parte del cedit */
static gint
gtk_cedit_expose (GtkWidget      *widget,
    GdkEventExpose *event)
{
    GtkCEdit *cedit;
        /* --- errores evidentes --- */
    g_return_val_if_fail (widget != NULL, FALSE);
    g_return_val_if_fail (GTK_IS_CEDIT (widget), FALSE);
    g_return_val_if_fail (event != NULL, FALSE);
    
#ifdef DEBUG
    g_print ("--- expose %ld %ld %ld %ld\n", event -> area.x, event -> area.y, event -> area.width, event -> area.height);
#endif
    
    
        //g_print("\nexpose %d %d %d %d",event->area.x,event->area.y,event->area.width,event->area.height);
    
    cedit = GTK_CEDIT (widget);
    
        /* --- creo el doble_buffer si no ha sido creado --- */
    
    if (cedit -> doble_buffer == NULL)
        gtk_cedit_size_allocate (widget, &(widget -> allocation));
    
        /* --- dibujo sobre el doble buffer --- */
    
        ///    gtk_cedit_draw (widget, &(event->area));
        //#endif
    
        /* --- dibujo el doble buffer sobre la pantalla --- */
    
        /*  gdk_draw_pixmap(widget->window,
        widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
        cedit->doble_buffer,
        event->area.x, event->area.y,
        event->area.x, event->area.y,
        event->area.width, event->area.height);
        */
    gdk_draw_drawable (widget -> window,
        widget -> style -> fg_gc [GTK_WIDGET_STATE (widget)],
        cedit -> doble_buffer,
        event -> area.x, event -> area.y,
        event -> area.x, event -> area.y,
        event -> area.width, event -> area.height);
        //    return FALSE;
    
    gtk_cedit_draw_cursor (widget);
    return TRUE;
}


static void
gtk_cedit_realize (GtkWidget *widget)
{
    
    GtkCEdit *cedit;
    GdkWindowAttr attributes;
    gint attributes_mask;
    
        /* --- Compruebo fallos inmediatos --- */
    g_return_if_fail (widget != NULL);
    g_return_if_fail (GTK_IS_CEDIT (widget));
    
#ifdef DEBUG
    g_print ("--- realize\n");
#endif
    
    cedit = GTK_CEDIT (widget);
    GTK_WIDGET_SET_FLAGS (widget, GTK_REALIZED);
    
        /* --- atributos para crear la ventana --- */
    attributes.window_type = GDK_WINDOW_CHILD;
    attributes.x = widget -> allocation.x;
    attributes.y = widget -> allocation.y;
    attributes.width = widget -> allocation.width;
    attributes.height = widget -> allocation.height;
    attributes.wclass = GDK_INPUT_OUTPUT;
    attributes.visual = gtk_widget_get_visual (widget);
    attributes.colormap = gtk_widget_get_colormap (widget);
    
        /*  attributes.colormap.colors[*/
    
    attributes.event_mask = gtk_widget_get_events (widget) |
    GDK_EXPOSURE_MASK |
    GDK_BUTTON_PRESS_MASK |
    GDK_BUTTON_RELEASE_MASK |
    GDK_POINTER_MOTION_MASK |
        //    GDK_ENTER_NOTIFY_MASK |
    GDK_KEY_PRESS_MASK;
        //    GDK_KEY_RELEASE_MASK;
    
        /* --- Paso los valores x, y, visual y colormap --- */
    attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;
    
        /* --- Creo la ventana --- */
    widget -> window = gdk_window_new (gtk_widget_get_parent_window (widget),
        &attributes, attributes_mask);
    gdk_window_set_user_data (widget -> window, cedit);
    
    widget -> style = gtk_style_attach (widget -> style, widget -> window);
    
        //cedit->window2 = gdk_window_new (widget->window, &attributes, attributes_mask);
        //gdk_window_set_user_data(cedit->window2, cedit);
    
    
    gtk_cedit_NewColor (&(cedit -> colors [0]), 0xaaaa, 0xaaaa, 0xffff);
    gtk_cedit_NewColor (&(cedit -> colors [1]), 0xffff, 0xffff, 0xffff);
    gtk_cedit_NewColor (&(cedit -> colors [2]), 0x0,    0x0,    0x0);
    gtk_cedit_NewColor (&(cedit -> colors [3]), 0xcccc, 0xcccc, 0xcccc);
    gtk_cedit_NewColor (&(cedit -> colors [4]), 0x5555, 0x5555, 0xffff);  // palabras reservadas
    gtk_cedit_NewColor (&(cedit -> colors [5]), 0x0, 0xaaaa, 0x0);  // macros
    gtk_cedit_NewColor (&(cedit -> colors [6]), 0x9999, 0x9999, 0x9999);  // comentario
    gtk_cedit_NewColor (&(cedit -> colors [7]), 0xffff, 0x0000, 0xffff);  // numero
    gtk_cedit_NewColor (&(cedit -> colors [8]), 0x0000, 0x7777, 0x0000);  // texto "adsfasd"
    gtk_cedit_NewColor (&(cedit -> colors [9]), 0x0000, 0x0000, 0x0000);  // texto seleccionado fondo 
    gtk_cedit_NewColor (&(cedit -> colors [10]), 0xffff, 0xffff, 0xffff);  // fondo del error
    gtk_cedit_NewColor (&(cedit -> colors [11]), 0x9999, 0x9999, 0xffff);  // fondo de un inicio de bloque
    gtk_cedit_NewColor (&(cedit -> colors [12]), 0xffff, 0x0000, 0x0000);  // fondo del error
    gtk_cedit_NewColor (&(cedit -> colors [13]), 0xffff, 0xffff, 0x0000);  // fondo de la marcadores
    gtk_cedit_NewColor (&(cedit -> colors [14]), 0x0000, 0xbbbb, 0x0000);  // fondo de un warning 
    
    
    cedit -> Pleft_edge = gtk_cedit_GetPen (widget, &(cedit -> colors [0]));
    cedit -> Pbackground = gtk_cedit_GetPen (widget, &(cedit -> colors [1]));
    cedit -> Pnormal = gtk_cedit_GetPen (widget, &(cedit -> colors [2]));
    cedit -> Pendfile = gtk_cedit_GetPen (widget, &(cedit -> colors [3]));
    cedit -> Preserved_word = gtk_cedit_GetPen (widget, &(cedit -> colors [4]));
    cedit -> Pmacro = gtk_cedit_GetPen (widget, &(cedit -> colors [5]));
    cedit -> Pcomment = gtk_cedit_GetPen (widget, &(cedit -> colors [6]));
    cedit -> Pnumber = gtk_cedit_GetPen (widget, &(cedit -> colors [7]));
    cedit -> Ptext = gtk_cedit_GetPen (widget, &(cedit -> colors [8]));
    cedit -> PselectedBack = gtk_cedit_GetPen (widget, &(cedit -> colors [9]));
    cedit -> PselectedFore = gtk_cedit_GetPen (widget, &(cedit -> colors [10]));
    cedit -> PblockBack = gtk_cedit_GetPen (widget, &(cedit -> colors [11]));
    cedit -> PerrorBack = gtk_cedit_GetPen (widget, &(cedit -> colors [12]));
    cedit -> PMarkBack = gtk_cedit_GetPen (widget, &(cedit -> colors [13]));
    cedit -> PwarningBack = gtk_cedit_GetPen (widget, &(cedit -> colors [14]));
    
    
        //gdk_window_set_background(cedit->window2, &(cedit->colors[1]));
        //cedit->gc = gdk_gc_new(cedit->window2);
         //gdk_gc_set_exposures(cedit->gc, TRUE);
        //gdk_gc_set_foreground(cedit->gc, &(cedit->colors[2]));
        //  gdk_window_show(cedit->window2);
    
    cedit -> mouse_buffer = gdk_pixmap_new (widget -> window,
        gdk_char_width (cedit -> Fnormal, 'M') *2,
        cedit -> char_height + 5,
        - 1);

    cedit->mark_pixmap=NULL;
        cedit->mark_pixmap=gdk_pixmap_create_from_xpm_d(widget -> window,
    						     &cedit->mark_mask,
    						     NULL,
    						     mark_xpm);
    
        //    gdk_window_set_background (widget->window, gtk_cedit_NewColor(0xfa0,0xfa0,0xfa0));
}

static void
gtk_cedit_size_request (GtkWidget      *widget,
    GtkRequisition *requisition)
{
    g_return_if_fail (GTK_IS_CEDIT (widget));
    g_return_if_fail (requisition != NULL);
    
        //g_print("\nsize_request");
    
    requisition -> width = 20;
    requisition -> height = 20;
}

void gtk_cedit_progressbar_set_text (GtkCEdit *gtkcedit, gchar *text)
{
    g_return_if_fail (gtkcedit != NULL);
    g_return_if_fail (GTK_IS_CEDIT (gtkcedit));
    
    if (gtkcedit -> progressbar == NULL)
        g_print ("%s\n", text);
    else
        gtk_progress_bar_set_text (gtkcedit -> progressbar, text);
}

void gtk_cedit_progressbar_callback (double value, void *data)
{
        //  GtkCEdit *gtkcedit;
        //  GtkWidget *widget;
    GtkProgressBar *pb;
        /*
        gtkcedit= (GtkCEdit*)data;
        g_return_if_fail(gtkcedit!=NULL);
        g_return_if_fail(GTK_IS_CEDIT(gtkcedit));
        widget = (GtkWidget *)gtkcedit;
        */
    pb = (GtkProgressBar *) data;
    if (pb == NULL)
        g_print ("%3.2f %%\n", value *100);
    else
    {
        if (value <= 0.95)
            gtk_progress_bar_set_fraction (pb, value);
        else // fin de la barra
        {
            gtk_progress_bar_set_fraction (pb, 0.0);
            gtk_progress_bar_set_text (pb, "");
        }
    }
    
        // actualizo to
    while (gtk_events_pending ())
        gtk_main_iteration ();
}

gint gtk_cedit_flick (gpointer data)
{
    GtkCEdit *gtkcedit;
    GtkWidget *widget;
    
#ifdef DEBUG
    g_print ("--- Flick\n");
#endif
    
    if (data == NULL) return false;
    
    widget = (GtkWidget *) data;
    gtkcedit = data;
    if (!(GTK_IS_CEDIT (gtkcedit)))
        return false;
    gtk_cedit_redraw_back_buffer (widget, NULL);
    gtkcedit -> flick =!gtkcedit -> flick;
    if (gtkcedit -> flick == false) gtk_cedit_draw_back_cursor (widget);
    else gtk_cedit_draw_cursor (widget);
        /*  gdk_draw_drawable(widget->window,
        widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
        gtkcedit->doble_buffer,
        0,0,
        0,0,
        widget->allocation.width, widget->allocation.height);
        */
    return true;
}

void gtk_cedit_draw_cursor (GtkWidget *widget)
    //, GdkPixmap *destination, gint x, gint y, gint width, gint height)
{
    GtkCEdit *cedit;
    gint pixel_x, pixel_y;
    gint cursor_x, cursor_y;
    gint last_char_width;
    
    g_return_if_fail (widget != NULL);
    g_return_if_fail (GTK_IS_CEDIT (widget));
    
    cedit = GTK_CEDIT (widget);
    
    if (cedit -> freeze == true) return;
#ifdef DEBUG
    g_print ("--- Pone cursor\n");
#endif
    if (cedit -> show_cursor == true)
    {
        cursor_x = cedit_get_cursor_x (cedit -> edit);
        cursor_y = cedit_get_cursor_y (cedit -> edit);
        
        pixel_y =-(int) (cedit -> vadj -> value);
        pixel_y += cursor_y *cedit -> char_height;
        
            // si esta dentro del area a dibujar, solo miro en la vertical (por ahora)
        if (pixel_y >= 0 && pixel_y <= widget -> allocation.height) // && cursor_x>=cedit->hadj->value)
        {
            cedit_push_cursor (cedit -> edit);
            
                // esta diferencia es culpa de los tabs, si se ven, hay que sumar el espacio en blanco a la linea, sino no
            if (cedit_get_tabs (cedit -> edit) *cedit -> space_tabs >(int) cedit -> hadj -> value)
            {
                pixel_x =(cedit_get_tabs (cedit -> edit) *cedit -> space_tabs -(int) cedit -> hadj -> value) *cedit -> space_width;
                cedit_move_cursor (cedit -> edit, 0, cedit_get_cursor_y (cedit -> edit)); // situo el cursor en la linia y del |
            }
            else
            {
                pixel_x = 0;
                cedit_move_cursor (cedit -> edit, (int) cedit -> hadj -> value -(cedit_get_tabs (cedit -> edit) *cedit -> space_tabs), cedit_get_cursor_y (cedit -> edit)); // situo el cursor en la linia y del |
                cursor_x -=(int) cedit -> hadj -> value - cedit_get_tabs (cedit -> edit) *cedit -> space_tabs;
            }
            
                //      cursor_x -=(int)cedit->hadj->value; //-cedit_get_tabs(cedit->edit)*cedit->space_tabs;
            
            
                //      pixel_x=0;
                //      pixel_x=cedit_get_tabs(cedit->edit)*cedit->space_tabs*cedit->space_width;
            while (cursor_x > 0)
            {
                last_char_width = gdk_char_width (cedit -> Fnormal, cedit_get_char (cedit -> edit));
                pixel_x += last_char_width;
                cedit_next_char (cedit -> edit);
                cursor_x --;
            }
            cedit_pop_cursor (cedit -> edit);
                // si tambien esta dentro del area a dibujar, ahora en la horizontal
            if (pixel_x >= 0 && pixel_x <= widget -> allocation.width)
            {
                last_char_width = gdk_char_width (cedit -> Fnormal, cedit_get_char (cedit -> edit));
                if (last_char_width < 3) last_char_width = 3;
                
                    // si hay un backbuffer, primero lo recupero, antes de hacer nada
                    //if (cedit->mouse_drawed==true)
                    //      gtk_cedit_draw_back_cursor(widget);
                
                    // dibujo el cursor en el buffer para recuperarlo despues
                    /*  gdk_draw_drawable(cedit->mouse_buffer,
                    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                    cedit->doble_buffer,
                    pixel_x+cedit->left_edge, pixel_y,
                    0,0,
                    last_char_width, cedit->char_height);
                    */
                
                cedit -> mouse_drawed = true;
                cedit -> mouse_buffer_x = pixel_x + cedit -> left_edge;
                cedit -> mouse_buffer_y = pixel_y;
                cedit -> mouse_buffer_width = last_char_width;
                cedit -> mouse_buffer_height = cedit -> char_height;
                
                    // dibujo el cursor
                if (cedit_get_insert_status (cedit -> edit))
                {
                    gdk_draw_rectangle (widget -> window,
                        cedit -> Pnormal,
                        FALSE,
                        pixel_x + cedit -> left_edge, pixel_y + 1,
                        0, cedit -> char_height - 2);
                }
                else
                {
                    gdk_draw_rectangle (widget -> window,
                        cedit -> Pnormal,
                        FALSE,
                        pixel_x + 1 + cedit -> left_edge, pixel_y + 1,
                        last_char_width - 2, cedit -> char_height - 2);
                }
                    //  g_print("x: %d y:%d",x,y);
                    /*
                    gdk_draw_drawable(widget->window,
                    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                    cedit->doble_buffer,
                    area->x, area->y,
                    area->x, area->y,
                    area->width, area->height);
                    */
            }
        }
    }
}

void gtk_cedit_draw_back_cursor (GtkWidget *widget)
{
    GtkCEdit *cedit;
    
    cedit = GTK_CEDIT (widget);
    
#ifdef DEBUG
    g_print ("---quita cursor\n");
#endif
    
    if (cedit -> mouse_drawed == true)
    {
        gdk_draw_drawable (widget -> window,
            widget -> style -> fg_gc [GTK_WIDGET_STATE (widget)],
            cedit -> doble_buffer,
            cedit -> mouse_buffer_x, cedit -> mouse_buffer_y,
            cedit -> mouse_buffer_x, cedit -> mouse_buffer_y,
            cedit -> mouse_buffer_width, cedit -> mouse_buffer_height);
        cedit -> mouse_drawed = false;
    }
}

    // ----------------------------
    //  Dibuja una linea del texto
    // ----------------------------
gint gtk_cedit_draw_line (GtkCEdit *gtkcedit, int x, int y, gchar *text, gint *flags, gint start, gint len, glong yline)
{
    gint cont, ant_y;
    gint count,up;
    GdkGC *color;
    GtkWidget *widget;
    gint lenght;
    
    widget = (GtkWidget *) gtkcedit;

    cont=0;
    while (gtkcedit->line_mark[cont]!=yline && cont<10)
	cont++;

    // borro la letras que hubiesen de color de fondo o del color de un marcador
    if (gtkcedit->line_mark[cont]==yline)
      {
	gdk_draw_rectangle (gtkcedit -> doble_buffer,
			    gtkcedit -> PMarkBack,
			    TRUE,
			    x,
			    y,
			    (widget -> allocation.width - x),
			    gtkcedit -> char_height);
      }
    else
      {
	gdk_draw_rectangle (gtkcedit -> doble_buffer,
			    gtkcedit -> Pbackground,
			    TRUE,
			    x,
			    y,
			    (widget -> allocation.width - x),
			    gtkcedit -> char_height);
      }
    
        // correccion de la posiciÃ³n y para que se escriba las fuentes bien
    ant_y = y;
    y += gtkcedit -> char_height - GTK_CEDIT_INTERLINE / 2;
    
        // por cada letra del texto
    for (cont = start; cont < start + len; cont ++)
    {
      
            // miro de que color se dibuja, depende del flag
        if ((flags [cont] & cedit_flag_selected) == cedit_flag_selected)
        {
            gdk_draw_rectangle (gtkcedit -> doble_buffer,
                gtkcedit -> PselectedBack,
                TRUE,
                x,
                ant_y,
                gdk_char_width (gtkcedit -> Fnormal, text [cont]),
                gtkcedit -> char_height);
            color = gtkcedit -> PselectedFore;
        }
        else if ((flags [cont] & cedit_flag_block) == cedit_flag_block)
        {
            gdk_draw_rectangle (gtkcedit -> doble_buffer,
                gtkcedit -> PblockBack,
                TRUE,
                x,
                ant_y,
                gdk_char_width (gtkcedit -> Fnormal, text [cont]),
                gtkcedit -> char_height);
            color = gtkcedit -> PselectedFore;
        }
        else if ((flags [cont] & cedit_flag_line_comment) == cedit_flag_line_comment ||
            (flags [cont] & cedit_flag_comment) == cedit_flag_comment)
        color = gtkcedit -> Pcomment;
        else if ((flags [cont] & cedit_flag_macro) == cedit_flag_macro)
            color = gtkcedit -> Pmacro;
        else if ((flags [cont] & cedit_flag_reserved_word) == cedit_flag_reserved_word)
            color = gtkcedit -> Preserved_word;
        else if ((flags [cont] & cedit_flag_text) == cedit_flag_text ||
            (flags [cont] & cedit_flag_apostrophe_text) == cedit_flag_apostrophe_text)
        color = gtkcedit -> Ptext;
        else if ((flags [cont] & cedit_flag_number) == cedit_flag_number)
            color = gtkcedit -> Pnumber;
        else
            color = gtkcedit -> Pnormal;


	// raya de error
        if ((flags [cont] & cedit_flag_error) == cedit_flag_error)
        {
	  lenght=gdk_char_width (gtkcedit -> Fnormal, text [cont]);
	  up=0;
	  for (count=0;count<lenght;count+=(lenght/2))
	    {
	      gdk_draw_rectangle (gtkcedit -> doble_buffer,
				  gtkcedit -> PerrorBack,
				  TRUE,
				  x+count,
				  y+up,
				  (lenght/2),
				  1);
	      up++;
	      if (up==2) up=0;
	    }
        }
	// raya de warning
        else if ((flags [cont] & cedit_flag_warning) == cedit_flag_warning)
        {
	  lenght=gdk_char_width (gtkcedit -> Fnormal, text [cont]);
	  up=0;
	  for (count=0;count<lenght;count+=(lenght/2))
	    {
	      gdk_draw_rectangle (gtkcedit -> doble_buffer,
				  gtkcedit -> PwarningBack,
				  TRUE,
				  x+count,
				  y+up,
				  (lenght/2),
				  1);
	      up++;
	      if (up==2) up=0;
	    }
        }

        
            // escribo la letra
        gdk_draw_text (gtkcedit -> doble_buffer,
            gtkcedit -> Fnormal,
            color,
            x,
            y,
            &text [cont],
            1);
        x += gdk_char_width (gtkcedit -> Fnormal, text [cont]);
    }
    return 0;
}

    /*
    * gtk_cedit_draw
    *
    * Dibuja el widget
    */
static void gtk_cedit_draw (GtkWidget *widget, GdkRectangle *area)
{
    GtkCEdit *cedit;
        //GdkWindow *tempwindow;
        //  GdkPixmap *buffer;
    int pixel_x, pixel_y;
    int temp_y;               // para recorrerme la pantalla verticalmente
    int pos_x, pos_y;
    int scroll_cursor;
    int end_text;             // 1 si ha terminado el texto
    int contador;
    int type;                 // tipo de cambio
    gchar numeros [10];
    gchar number2[3];
    char *text;
    int *flags;
    GdkRectangle changes [100];
    gint num_changes;
    gint count;

        //  gchar real_char;
    
    g_return_if_fail (widget != NULL);
    g_return_if_fail (GTK_IS_CEDIT (widget));
    g_return_if_fail (area != NULL);
    
    cedit = GTK_CEDIT (widget);

    if (!GDK_IS_DRAWABLE(widget->window) || !GDK_IS_DRAWABLE(cedit->doble_buffer))
      return;
    
    if (cedit -> freeze == true) return;
#ifdef DEBUG
    g_print ("--- Draw %d\n", cedit -> redraw_all);
#endif
    
    cedit_freeze (cedit -> edit);
    num_changes = 0;
        /*
        pixel_x=cedit->left_edge; //-cedit->hadj->value+cedit->left_edge;
        pixel_y=-(int)(cedit->vadj->value); ///cedit->char_height);
        pos_y=cedit->vadj->value/cedit->char_height;
        pos_x=(int)cedit->hadj->value;
        pixel_y+=pos_y*cedit->char_height;
        */
    
        // por si acaso el valor esta fuera de rango
    if (cedit -> vadj -> value + cedit -> vadj -> page_size > cedit -> vadj -> upper) cedit -> vadj -> value = cedit -> vadj -> upper - cedit -> vadj -> page_size;
    if (cedit -> vadj -> value < 0) cedit -> vadj -> value = 0;
    
        //scroll_cursor=cedit->scroll_cursor;
    
        // posicion inicial de los cursores
        //cedit_move_cursor(cedit->screen, 0, 0);
        //copy_cursor(cedit->edit, cedit->scroll_cursor, cedit->temp_cursor);
        //cedit_cmove_cursor(cedit->edit, scroll_cursor, pos_x, pos_y);
    
    scroll_cursor = cedit -> scroll_cursor;
    
        // si se redibuja todo, pues lo hago
    if (cedit -> redraw_all == true)
    {
            // posicion inicial
        pixel_x = cedit -> left_edge; //-cedit->hadj->value+cedit->left_edge;
        pixel_y =-(int) (cedit -> vadj -> value); ///cedit->char_height);
        pos_y = cedit -> vadj -> value / cedit -> char_height;
        pos_x =(int) cedit -> hadj -> value;
        pixel_y += pos_y *cedit -> char_height;
        
        cedit_cmove_cursor (cedit -> edit, scroll_cursor, pos_x, pos_y);
        
            // parte izquierda del editor
        gdk_draw_rectangle (cedit -> doble_buffer,
            cedit -> Pleft_edge,
            TRUE,
            area -> x, area -> y,
            cedit -> left_edge, area -> height);
        contador = pos_y;
        for (temp_y = pixel_y; temp_y < area -> height; temp_y += cedit -> char_height)
        {
            sprintf (numeros, "%d", contador + 1);
            gdk_draw_text (cedit -> doble_buffer,
                cedit -> Fnormal,
                cedit -> Pnormal,
                3,
                temp_y + cedit -> char_height - GTK_CEDIT_INTERLINE / 2,
                numeros,
                strlen (numeros));
	    
	    count=0;
	    while (count<10 && contador!=cedit->line_mark[count])
	      count++;

	    // si esta linea tienen una marca, dibujo el simbolo al lado de los numeros
	    if (contador==cedit->line_mark[count])
	      {
		if (cedit->mark_pixmap!=NULL)
		  {
		    gdk_draw_drawable (cedit->doble_buffer,
				       widget -> style -> fg_gc [GTK_WIDGET_STATE (widget)],
				       cedit -> mark_pixmap,
				       0,0,
				       8+(strlen (numeros) *cedit -> char_width),temp_y,
				       -1,-1);
		    sprintf (number2, "%d", count);
		    gdk_draw_text (cedit -> doble_buffer,
				   cedit -> Fnormal,
				   cedit -> Pnormal,
				   12+(strlen (numeros) *cedit -> char_width),
				   temp_y + cedit -> char_height - GTK_CEDIT_INTERLINE / 2,
				   number2,
				   strlen(number2));
		    gdk_draw_text (cedit -> doble_buffer,
				   cedit -> Fnormal,
				   cedit -> Pnormal,
				   13+(strlen (numeros) *cedit -> char_width),
				   temp_y + cedit -> char_height - GTK_CEDIT_INTERLINE / 2,
				   number2,
				   strlen(number2));
		  }
	      }

            contador ++;
        }
        
            // limpio la zona que voy a dibujar
            //cedit_move_cursor(cedit->screen, 0, 0);
            //cedit_del_until_end_of_file(cedit->screen);
        
        gdk_draw_rectangle (cedit -> doble_buffer,
            cedit -> Pbackground,
            TRUE,
            cedit -> left_edge,
            0,
            widget -> allocation.width - cedit -> left_edge,
            widget -> allocation.height);
        
        
        end_text = 0;
        
        while (pixel_y < area -> y + area -> height && !end_text)
        {
            if (cedit_cget_line_num_char (cedit -> edit, scroll_cursor) + cedit_cget_tabs (cedit -> edit, scroll_cursor) *cedit -> space_tabs >(int) cedit -> hadj -> value)
            {
                
                contador = (cedit_cget_tabs (cedit -> edit, scroll_cursor) *cedit -> space_tabs -((int) cedit -> hadj -> value)) *cedit -> space_width;
                if (contador >= 0)
                {
                    pixel_x = cedit -> left_edge + contador;
                    contador = 0;
                }
                else
                {
                    pixel_x = cedit -> left_edge;
                    contador = ((int) cedit -> hadj -> value) -(cedit_cget_tabs (cedit -> edit, scroll_cursor) *cedit -> space_tabs);
                }
                
                
                text = cedit_cget_line_text (cedit -> edit, scroll_cursor);
                flags = cedit_cget_line_flags (cedit -> edit, scroll_cursor);
                
                gtk_cedit_draw_line (cedit,
				     pixel_x,
				     pixel_y,
				     text,
				     flags,
				     contador,
				     cedit_cget_line_num_char (cedit -> edit, scroll_cursor) - contador,
				     cedit_cget_cursor_y(cedit->edit,scroll_cursor));
                    /*
                    gdk_draw_text(cedit->doble_buffer,
                    cedit->Fnormal,
                    cedit->Pnormal,
                    cedit->left_edge,
                    pixel_y+cedit->char_height - GTK_CEDIT_INTERLINE/2,
                    &text[(int)cedit->hadj->value],
                    cedit_cget_line_num_char(cedit->edit, scroll_cursor)-(int)cedit->hadj->value);
                    */
                
            }
            pixel_y += cedit -> char_height;
            end_text = cedit_cmove_cursor_down (cedit -> edit, scroll_cursor);
        }
            // borro todos los posibles cambios
        
        while (cedit_del_change (cedit -> edit) !=- 1);  // mientras hayan cambios los borro
    }
    else
    {
        cedit_prepare_to_change (cedit -> edit);       // esto quita los cambios innecesarios
        while (cedit_have_change (cedit -> edit) !=- 1)  // mientras hayan cambios
        {
            cedit_cmove_cursor_to_change (cedit -> edit, scroll_cursor);  // muevo el cursor hacia el cambio
            
                // posicion inicial
            pixel_x = cedit -> left_edge + cedit_cget_tabs (cedit -> edit, scroll_cursor) *cedit -> space_tabs *cedit -> space_width; //-cedit->hadj->value+cedit->left_edge;
            pixel_y =-(int) (cedit -> vadj -> value); ///cedit->char_height);
            pos_y = cedit_cget_cursor_y (cedit -> edit, scroll_cursor);
            pos_x = cedit_cget_cursor_x (cedit -> edit, scroll_cursor);
            
                // miro a que distancia de la izquierda esta el cursor
            text = cedit_cget_line_text (cedit -> edit, scroll_cursor);
            for (contador =(int) cedit -> hadj -> value; contador < pos_x; contador ++)
            pixel_x += gdk_char_width (cedit -> Fnormal, text [contador]);
            
            pixel_y += pos_y *cedit -> char_height;
            
                // avanzo rapido si el cambio esta por encima
            while ((pixel_y + cedit -> char_height *2) < 0)
            {
                pixel_y += cedit -> char_height;
                pos_y ++;
                cedit_cmove_cursor_down (cedit -> edit, scroll_cursor);
            }
            
            
                // borro el espacio de los tabs, si el cambio es en la primera letra o hasta el final del texto
            if (cedit_cget_tabs (cedit -> edit, scroll_cursor) *cedit -> space_tabs >(int) cedit -> hadj -> value)
            {
                gdk_draw_rectangle (cedit -> doble_buffer,
                    cedit -> Pbackground,
                    TRUE,
                    cedit -> left_edge,
                    pixel_y,
                    (cedit_cget_tabs (cedit -> edit, scroll_cursor) *cedit -> space_tabs -(int) cedit -> hadj -> value) *cedit -> space_width,
                    cedit -> char_height);
                
                    // para restaurar solo lo que ha cambiado, si hay mas de 100 cambios, restauro toda la pantalla
                    //  y no trozo por trozo
                if (num_changes < 100)
                {
                    changes [num_changes] .x = cedit -> left_edge;
                    changes [num_changes] .y = pixel_y;
                    changes [num_changes] .width =(cedit_cget_tabs (cedit -> edit, scroll_cursor) *cedit -> space_tabs -(int) cedit -> hadj -> value) *cedit -> space_width;
                    changes [num_changes] .height = cedit -> char_height;
                    num_changes ++;
                }
                
            }
            
                // ahora, segun el tipo de cambio que sea, hago una cosa o otra
            type = cedit_get_type_change (cedit -> edit);
            
                // texto y flags a dibujar
            text = cedit_cget_line_text (cedit -> edit, scroll_cursor);
            flags = cedit_cget_line_flags (cedit -> edit, scroll_cursor);
            
            switch (type)
            {
                case cedit_change_to_end_of_line:
                case cedit_change_this_char:
                {
                        // para restaurar solo lo que ha cambiado, si hay mas de 100 cambios, restauro toda la pantalla
                        //  y no trozo por trozo
                    if (num_changes < 100)
                    {
                        changes [num_changes] .x = pixel_x;
                        changes [num_changes] .y = pixel_y;
                        changes [num_changes] .width = area -> width - pixel_x;
                        changes [num_changes] .height = cedit -> char_height;
                        num_changes ++;
                    }
                    
                    
                        //if (pos_x < cedit_cget_line_num_char(cedit->edit, scroll_cursor))
                        //  {
                        //    g_print("%d,%d,",cedit_cget_line_num_char(cedit->edit, scroll_cursor),pos_x);
                    gtk_cedit_draw_line (cedit,
					 pixel_x,
					 pixel_y,
					 text,
					 flags,
					 pos_x,
					 cedit_cget_line_num_char (cedit -> edit, scroll_cursor) - pos_x,
					 cedit_cget_cursor_y(cedit->edit, scroll_cursor));
                        /*
                        gdk_draw_text(cedit->doble_buffer,
                        cedit->Fnormal,
                        cedit->Pnormal,
                        pixel_x,
                        pixel_y + cedit->char_height - GTK_CEDIT_INTERLINE/2,
                        &text[pos_x],
                        cedit_cget_line_num_char(cedit->edit, scroll_cursor)-pos_x);
                        */
                        //      }
                    break;
                }
                case cedit_change_to_end_of_text:
                {
                        //text=cedit_cget_line_text(cedit->edit, scroll_cursor);
                        //flags=cedit_cget_line_flags(cedit->edit, scroll_cursor);
                        /*gdk_draw_rectangle(cedit->doble_buffer,
                        cedit->Pbackground,
                        TRUE,
                        pixel_x,
                        pixel_y,
                        area->width-pixel_x,
                        cedit->char_height);
                        */
                        // para restaurar solo lo que ha cambiado, si hay mas de 100 cambios, restauro toda la pantalla
                        //  y no trozo por trozo
                    if (num_changes < 100)
                    {
                        changes [num_changes] .x = pixel_x;
                        changes [num_changes] .y = pixel_y;
                        changes [num_changes] .width = area -> width - pixel_x;
                        changes [num_changes] .height = cedit -> char_height;
                        num_changes ++;
                    }
                    
                    
                        //if (pos_x < cedit_cget_line_num_char(cedit->edit, scroll_cursor))
                        //  {
                    gtk_cedit_draw_line (cedit,
                        pixel_x,
                        pixel_y,
                        text,
                        flags,
                        pos_x,
                        cedit_cget_line_num_char (cedit -> edit, scroll_cursor) - pos_x,
					 cedit_cget_cursor_y(cedit->edit,scroll_cursor));
                        /*    gdk_draw_text(cedit->doble_buffer,
                        cedit->Fnormal,
                        cedit->Pnormal,
                        pixel_x,
                        pixel_y + cedit->char_height - GTK_CEDIT_INTERLINE/2,
                        &text[pos_x],
                        cedit_cget_line_num_char(cedit->edit, scroll_cursor)-pos_x);
                        */
                        //  }
                    
                        // ahora a partir de aqui, hacia abajo, es como si redibujase todo
                    pos_x = 0;
                    pixel_y += cedit -> char_height;
                    end_text = cedit_cmove_cursor_down (cedit -> edit, scroll_cursor);
                        /*
                        gdk_draw_rectangle(cedit->doble_buffer,
                        cedit->Pbackground,
                        TRUE,
                        cedit->left_edge,
                        pixel_y,
                        area->width-cedit->left_edge,
                        area->height-pixel_y);
                        */
                        // para restaurar solo lo que ha cambiado, si hay mas de 100 cambios, restauro toda la pantalla
                        //  y no trozo por trozo
                    if (num_changes < 100)
                    {
                        changes [num_changes] .x = cedit -> left_edge; //+cedit_cget_tabs(cedit->edit, scroll_cursor)*SPACE_TABS;
                        changes [num_changes] .y = pixel_y;
                        changes [num_changes] .width = area -> width - cedit -> left_edge;
                        changes [num_changes] .height = area -> height - pixel_y;
                        num_changes ++;
                    }
                    
                    while (pixel_y < area -> y + area -> height && !end_text)
                    {
                            //    if (cedit_cget_line_num_char(cedit->edit, scroll_cursor)>(int)cedit->hadj->value)
                            //      {
                        contador = (cedit_cget_tabs (cedit -> edit, scroll_cursor) *cedit -> space_tabs -((int) cedit -> hadj -> value)) *cedit -> space_width;
                        if (contador >= 0)
                        {
                            pixel_x = cedit -> left_edge + contador;
                            contador = 0;
                        }
                        else
                        {
                            pixel_x = cedit -> left_edge;
                            contador = ((int) cedit -> hadj -> value) -(cedit_cget_tabs (cedit -> edit, scroll_cursor) *cedit -> space_tabs);
                        }
                        
                        
                        text = cedit_cget_line_text (cedit -> edit, scroll_cursor);
                        flags = cedit_cget_line_flags (cedit -> edit, scroll_cursor);
                        
                            // el espacio que deja los tabs
                        gdk_draw_rectangle (cedit -> doble_buffer,
                            cedit -> Pbackground,
                            TRUE,
                            cedit -> left_edge,
                            pixel_y,
                            (cedit_cget_tabs (cedit -> edit, scroll_cursor) - cedit -> hadj -> value) *cedit -> space_tabs *cedit -> space_width,
                            cedit -> char_height);
                        
                        gtk_cedit_draw_line (cedit,
                            pixel_x,
                            pixel_y,
                            text,
                            flags,
                            contador,
                            cedit_cget_line_num_char (cedit -> edit, scroll_cursor) - contador,
					     cedit_cget_cursor_y(cedit->edit,scroll_cursor));
                        
                        
                            //    text=cedit_cget_line_text(cedit->edit, scroll_cursor);
                            //    flags=cedit_cget_line_flags(cedit->edit, scroll_cursor);
                        
                            //    gtk_cedit_draw_line(cedit,
                            //cedit->left_edge+(cedit_cget_tabs(cedit->edit, scroll_cursor)-cedit->hadj->value)*cedit->space_tabs*cedit->space_width,
                            //pixel_y,
                            //text,
                            //flags,
                            //(int)cedit->hadj->value,
                            //cedit_cget_line_num_char(cedit->edit, scroll_cursor)-(int)cedit->hadj->value);
                            /*
                            gdk_draw_text(cedit->doble_buffer,
                            cedit->Fnormal,
                            cedit->Pnormal,
                            cedit->left_edge,
                            pixel_y+cedit->char_height - GTK_CEDIT_INTERLINE/2,
                            &text[(int)cedit->hadj->value],
                            cedit_cget_line_num_char(cedit->edit, scroll_cursor)-(int)cedit->hadj->value);
                            */
                        
                        
                            //      }
                        pixel_y += cedit -> char_height;
                        end_text = cedit_cmove_cursor_down (cedit -> edit, scroll_cursor);
                    }
                    
                        // termino de dibujar lo que no se haya borrado con las letras (de la Ãºltima linea dibujada hasta el final
                    gdk_draw_rectangle (cedit -> doble_buffer,
                        cedit -> Pbackground,
                        TRUE,
                        cedit -> left_edge,
                        pixel_y,
                        area -> width - cedit -> left_edge,
                        area -> height - pixel_y);
                    break;
                }
            }
            cedit_del_change (cedit -> edit);
            
        }
        
    }
    
        // se pega en la pantalla
    
    if (cedit -> redraw_all == true || num_changes == 100)
        gdk_draw_drawable (widget -> window,
        widget -> style -> fg_gc [GTK_WIDGET_STATE (widget)],
        cedit -> doble_buffer,
        area -> x, area -> y,
        area -> x, area -> y,
        area -> width, area -> height);
    else // solo restauro lo que ha cambiado (changes)
    {
        for (contador = 0; contador < num_changes; contador ++)
        {
            gdk_draw_drawable (widget -> window,
                widget -> style -> fg_gc [GTK_WIDGET_STATE (widget)],
                cedit -> doble_buffer,
                changes [contador] .x, changes [contador] .y,
                changes [contador] .x, changes [contador] .y,
                changes [contador] .width, changes [contador] .height);
        }
    }
    
    
        // ahora dibujo el cursor
    
    
    gtk_cedit_draw_back_cursor (widget);
    gtk_cedit_draw_cursor (widget);
    
    cedit -> redraw_all = false;
    cedit_unfreeze (cedit -> edit);
    
}


void gtk_cedit_redraw_back_buffer (GtkWidget *widget, GdkRectangle *area)
{
    GdkEventExpose expose;
    GdkRectangle area2;
    GtkCEdit *cedit;
    
    g_return_if_fail (widget != NULL);
    g_return_if_fail (GTK_IS_CEDIT (widget));

    cedit = GTK_CEDIT (widget);

    if (cedit->doble_buffer==NULL)
      return;

        //    g_return_if_fail (area != NULL);
    
#ifdef DEBUG
    g_print ("--- Draw backbuffer\n");
#endif
    
    if (cedit -> visible == TRUE)
    {
        
            /* --- si no hay area, es que se quiere un redibujado completo --- */
        if (area == NULL)
        {
                /* --- area expuesta --- */
            expose.area.x = 0;
            expose.area.y = 0;
            expose.area.width = widget -> allocation.width;
            expose.area.height = widget -> allocation.height;
            
                /* --- area a dibujar --- */
            area2.x = 0;
            area2.y = 0;
            area2.width = widget -> allocation.width;
            area2.height = widget -> allocation.height;
                /* --- dibujo el area en el doble buffer --- */
            gtk_cedit_draw (widget, &area2);
        }
        else
        {
                /* --- area expuesta --- */
            expose.area.x = area -> x;
            expose.area.y = area -> y;
            expose.area.width = area -> width;
            expose.area.height = area -> height;
                /* --- dibujo el area en el doble buffer --- */
            gtk_cedit_draw (widget, area);
        }
        
            /* --- expongo el area para que se dibuje del doble_buffer a la pantalla --- */
            /*
#ifndef GTK_CEDIT_DOBLE_BUFFER
            gdk_window_move_resize (widget->window,
            expose.area.x, expose.area.y,
            expose.area.width, expose.area.height);
#endif
            */
            //gtk_cedit_expose (widget, &expose);
    }
}


gint gtk_cedit_NewColor (GdkColor *c, long red, long green, long blue)
{
        /* --- creo un color vacio --- */
        //GdkColor *c= (GdkColor *) g_malloc(sizeof(GdkColor));
    
        /* --- lo relleno --- */
    c -> red = red;
    c -> green = green;
    c -> blue = blue;
    
    gdk_color_alloc (gdk_colormap_get_system (), c);
    
    return 0;
        //return (c);
}

GdkGC *gtk_cedit_GetPen (GtkWidget *widget, GdkColor *c)
{
    GdkGC *gc;
    
    gc = NULL;
    
    gc = gdk_gc_new (widget -> window);
    gdk_gc_set_foreground (gc, c);
    
    if (gc == NULL)
        g_warning ("Mal");
        //return 0;
    return gc;
}

static gint
gtk_cedit_key_press (GtkWidget *widget, GdkEventKey *event)
{
    GtkCEdit *cedit;
    gboolean noredraw;
    gint cont;
    gboolean have_undo_before, have_redo_before;
        // char *changes;
    
    g_return_val_if_fail (widget != NULL, FALSE);
    g_return_val_if_fail (GTK_IS_CEDIT (widget), FALSE);
    g_return_val_if_fail (event != NULL, FALSE);
    
    noredraw = false;
    
#ifdef DEBUG
        //  g_print("key_pressed: %d\n", event->keyval);
    g_print ("letra: %d %c %X   %s %d\n", event -> keyval, event -> keyval, event -> keyval, event -> string, event -> string [0]);
#endif
    
        //  for (cont=20;cont<2550;cont++)
        //g_print(" (%c %d %X)", cont,cont,cont);
    
    
        // falla la tecla a la derecha de la P y a la derecha de la Ã `^'Ã€
        // lo hago a mano, capturando cuando se pulsa.
    if (event -> keyval == GDK_dead_grave)
    {
        if (gtk_cedit_dead_grave == true)
        {
            gtk_cedit_dead_grave = false;
            event -> keyval = 96;
            event -> string [0] = 96;
            event -> string [1] ='\0';
        }
        else
        {
            gtk_cedit_dead_grave = true;
            return 0;
        }
    }
    
    if (event -> keyval == GDK_dead_acute)
    {
        if (gtk_cedit_dead_acute == true)
        {
            gtk_cedit_dead_acute = false;
            event -> keyval = 96;
            event -> string [0] = 39;
            event -> string [1] ='\0';
        }
        else
        {
            gtk_cedit_dead_acute = true;
            return 0;
        }
    }
    
    if (event -> keyval == GDK_dead_diaeresis)
    {
        gtk_cedit_dead_diaeresis = true;
        return 0;
    }
    
    
        // acento abierto
    if (event->string!=NULL)
      {
    if (event -> string [0] =='a' && gtk_cedit_dead_grave) event -> string [0] ='';
    if (event -> string [0] =='e' && gtk_cedit_dead_grave) event -> string [0] ='';
    if (event -> string [0] =='i' && gtk_cedit_dead_grave) event -> string [0] ='';
    if (event -> string [0] =='o' && gtk_cedit_dead_grave) event -> string [0] ='';
    if (event -> string [0] =='u' && gtk_cedit_dead_grave) event -> string [0] ='';
    if (event -> string [0] =='A' && gtk_cedit_dead_grave) event -> string [0] ='';
    if (event -> string [0] =='E' && gtk_cedit_dead_grave) event -> string [0] ='';
    if (event -> string [0] =='I' && gtk_cedit_dead_grave) event -> string [0] ='';
    if (event -> string [0] =='O' && gtk_cedit_dead_grave) event -> string [0] ='';
    if (event -> string [0] =='U' && gtk_cedit_dead_grave) event -> string [0] ='';
    
        // acento cerrado
    if (event -> string [0] =='a' && gtk_cedit_dead_acute) event -> string [0] ='';
    if (event -> string [0] =='e' && gtk_cedit_dead_acute) event -> string [0] ='';
    if (event -> string [0] =='i' && gtk_cedit_dead_acute) event -> string [0] ='';
    if (event -> string [0] =='o' && gtk_cedit_dead_acute) event -> string [0] ='';
    if (event -> string [0] =='u' && gtk_cedit_dead_acute) event -> string [0] ='';
    if (event -> string [0] =='A' && gtk_cedit_dead_acute) event -> string [0] ='';
    if (event -> string [0] =='E' && gtk_cedit_dead_acute) event -> string [0] ='';
    if (event -> string [0] =='I' && gtk_cedit_dead_acute) event -> string [0] ='';
    if (event -> string [0] =='O' && gtk_cedit_dead_acute) event -> string [0] ='';
    if (event -> string [0] =='U' && gtk_cedit_dead_acute) event -> string [0] ='';
    
        // dieresis
    if (event -> string [0] =='a' && gtk_cedit_dead_diaeresis) event -> string [0] ='';
    if (event -> string [0] =='e' && gtk_cedit_dead_diaeresis) event -> string [0] ='';
    if (event -> string [0] =='i' && gtk_cedit_dead_diaeresis) event -> string [0] ='';
    if (event -> string [0] =='o' && gtk_cedit_dead_diaeresis) event -> string [0] ='';
    if (event -> string [0] =='u' && gtk_cedit_dead_diaeresis) event -> string [0] ='';
    if (event -> string [0] =='A' && gtk_cedit_dead_diaeresis) event -> string [0] ='';
    if (event -> string [0] =='E' && gtk_cedit_dead_diaeresis) event -> string [0] ='';
    if (event -> string [0] =='I' && gtk_cedit_dead_diaeresis) event -> string [0] ='';
    if (event -> string [0] =='O' && gtk_cedit_dead_diaeresis) event -> string [0] ='';
    if (event -> string [0] =='U' && gtk_cedit_dead_diaeresis) event -> string [0] ='';
      }

    gtk_cedit_dead_acute = false;
    gtk_cedit_dead_grave = false;
    gtk_cedit_dead_diaeresis = false;
    
    
    cedit = GTK_CEDIT (widget);
    
    have_undo_before = cedit_have_undo (cedit -> edit);
    
        // shift pulsado
    if (event -> state & GDK_SHIFT_MASK) // si esta la tecla shift pulsada
    {
        if (cedit_have_selection (cedit -> edit) == 0) // si no hay ya una selecciÃ³n
            cedit_set_first_selection_point (cedit -> edit); // la pongo
    }
        /*
        else if (event->keyval != GDK_Shift_L &&
        event->keyval != GDK_Shift_R &&
        event->keyval != GDK_Control_L &&
        event->keyval != GDK_Control_R &&
        event->keyval != GDK_A_L &&
        event->keyval != GDK_Alt_R) // si no se tiene pulsado el shift-loquesea, pero esta pulsando LA TECLA shift
        {
        if (cedit_have_selection(cedit->edit)==1) // si hay una selecciÃ³n
        cedit_del_selection(cedit->edit);       // la quito
        }
        */
    if (event -> state & GDK_MOD1_MASK)
      {
        switch (event -> keyval)
	  {
	  case '0':
	  case '1':
	  case '2':
	  case '3':
	  case '4':
	  case '5':
	  case '6':
	  case '7':
	  case '8':
	  case '9':
	    {
	      gtk_cedit_go_to_bookmark(cedit, event->keyval-'0');
	      break;
	    }
	  }
      }
    else if (event -> state & GDK_CONTROL_MASK)
      {
        switch (event -> keyval)
        {
            case GDK_Home:
            case GDK_KP_Home:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)
                    cedit_del_selection (cedit -> edit);
                cedit_move_cursor (cedit -> edit, 0, 0);
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_End:
            case GDK_KP_End:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)
                    cedit_del_selection (cedit -> edit);
                cedit_move_cursor (cedit -> edit, 0, cedit_get_file_num_line (cedit -> edit) - 1);
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_Left:
            case GDK_KP_Left:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)  // quito la seleccion si se mueve
                    cedit_del_selection (cedit -> edit);
                cont = cedit_move_cursor_left (cedit -> edit);
                while (((cedit_get_char (cedit -> edit) >='a' && cedit_get_char (cedit -> edit) <='z') ||
                        (cedit_get_char (cedit -> edit) >='A' && cedit_get_char (cedit -> edit) <='Z')) && cont >= 0)
                cont = cedit_move_cursor_left (cedit -> edit);
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_Right:
            case GDK_KP_Right:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)  // quito la seleccion si se mueve
                    cedit_del_selection (cedit -> edit);
                cont = cedit_move_cursor_right (cedit -> edit);
                while (((cedit_get_char (cedit -> edit) >='a' && cedit_get_char (cedit -> edit) <='z') ||
                        (cedit_get_char (cedit -> edit) >='A' && cedit_get_char (cedit -> edit) <='Z')) && cont >= 0)
                cedit_move_cursor_right (cedit -> edit);
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	  {
	    if (cedit_get_cursor_y(cedit->edit)==cedit->line_mark[event->keyval-'0']) // si ya estaba puesto, se quita
	      gtk_cedit_del_bookmark(cedit, event->keyval-'0');
	    else
	      gtk_cedit_put_bookmark(cedit, event->keyval-'0');
	    break;
	  }
            
        }
    }
    else
    {
        switch (event -> keyval)
        {
            case GDK_Left:
            case GDK_KP_Left:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)  // quito la seleccion si se mueve
                    cedit_del_selection (cedit -> edit);
                    //g_print("ant: %d %d\n", cedit_get_cursor_x(cedit->edit), cedit_get_cursor_y(cedit->edit));
                if (cedit_move_cursor_left (cedit -> edit) < 0)
                    g_warning ("%s", cedit_get_error (cedit -> edit));
                    //g_print("des: %d %d\n", cedit_get_cursor_x(cedit->edit), cedit_get_cursor_y(cedit->edit));
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_Right:
            case GDK_KP_Right:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)  // quito la seleccion si se mueve
                    cedit_del_selection (cedit -> edit);
                if (cedit_move_cursor_right (cedit -> edit) < 0)
                    g_warning ("%s", cedit_get_error (cedit -> edit));
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_Up:
            case GDK_KP_Up:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)  // quito la seleccion si se mueve
                    cedit_del_selection (cedit -> edit);
                if (cedit_move_cursor_up (cedit -> edit) < 0)
                    g_warning ("%s", cedit_get_error (cedit -> edit));
                
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_Down:
            case GDK_KP_Down:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)  // quito la seleccion si se mueve
                    cedit_del_selection (cedit -> edit);
                if (cedit_move_cursor_down (cedit -> edit) < 0)
                    g_warning ("%s", cedit_get_error (cedit -> edit));
                
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_Home:
            case GDK_KP_Home:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)  // quito la seleccion si se mueve
                    cedit_del_selection (cedit -> edit);
                if (cedit_move_cursor_home_line (cedit -> edit) < 0)
                    g_warning ("%s", cedit_get_error (cedit -> edit));
                
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_End:
            case GDK_KP_End:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)  // quito la seleccion si se mueve
                    cedit_del_selection (cedit -> edit);
                if (cedit_move_cursor_end_line (cedit -> edit) < 0)
                    g_warning ("%s", cedit_get_error (cedit -> edit));
                
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_Page_Up:
            case GDK_KP_Page_Up:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)  // quito la seleccion si se mueve
                    cedit_del_selection (cedit -> edit);
                cont = (cedit -> vadj -> page_size / cedit -> char_height) *0.75;
                
                while (cont > 0)
                {
                    if (cedit_move_cursor_up (cedit -> edit) < 0)
                        g_warning ("%s", cedit_get_error (cedit -> edit));
                    
                    cont --;
                }
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_Page_Down:
            case GDK_KP_Page_Down:
            {
                if ((event -> state & GDK_SHIFT_MASK) == 0)  // quito la seleccion si se mueve
                    cedit_del_selection (cedit -> edit);
                cont = (cedit -> vadj -> page_size / cedit -> char_height) *0.75;
                
                while (cont > 0)
                {
                    if (cedit_move_cursor_down (cedit -> edit) < 0)
                        g_warning ("%s", cedit_get_error (cedit -> edit));
                    cont --;
                }
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                break;
            }
            case GDK_Return:
            case GDK_KP_Enter:
            {
                cedit_put_char (cedit -> edit, '\n');
                cedit -> vadj -> upper += cedit -> char_height;
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                
                    // miro si la barra izquierda es mas grande porque ahora hay mas lineas
		gtk_cedit_calculate_left_edge(cedit);
                    //gtk_signal_emit_by_name(GTK_OBJECT(cedit->vadj), "changed");
                break;
            }
            case GDK_Insert:
            case GDK_KP_Insert:
            {
                if (cedit_toggle_insert_mode (cedit -> edit) < 0)
                    g_warning ("%s", cedit_get_error (cedit -> edit));
                
                break;
            }
            case GDK_Delete:
            case GDK_KP_Delete:
            {
                if (cedit_end_of_line (cedit -> edit) && !cedit_end_of_file (cedit -> edit))
                {
                    cedit -> vadj -> upper -= cedit -> char_height;
                    
                        // si por culpa de haber quitado la linea, el scroll no sube (value no sube) pues lo subo yo
                    if (cedit -> vadj -> value + cedit -> vadj -> page_size > cedit -> vadj -> upper)
                    {
                        cedit -> vadj -> value = cedit -> vadj -> upper - cedit -> vadj -> page_size;
                        gtk_signal_emit_by_name (GTK_OBJECT (cedit -> vadj), "changed");
                        cedit -> redraw_all = true;
                        gtk_cedit_redraw_back_buffer (widget, NULL);
                    }
                    else
                    {
                        gtk_signal_emit_by_name (GTK_OBJECT (cedit -> vadj), "changed");
                    }
                }
                if (cedit_del_char (cedit -> edit) < 0)
                    g_warning ("%s", cedit_get_error (cedit -> edit));
                
                break;
            }
            case GDK_BackSpace:
            {
                if (cedit_get_cursor_x (cedit -> edit) == 0 && cedit_get_cursor_y (cedit -> edit) > 0)
                {
                    if (cedit_backspace_char (cedit -> edit) < 0)
                        g_warning ("%s", cedit_get_error (cedit -> edit));
                    cedit -> vadj -> upper -= cedit -> char_height;
                    gtk_signal_emit_by_name (GTK_OBJECT (cedit -> vadj), "changed");
                    cedit -> redraw_all = true;
                }
                else
                    if (cedit_backspace_char (cedit -> edit) < 0)
                        g_warning ("%s", cedit_get_error (cedit -> edit));
                
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                
                break;
            }
            default:
	      if (event->string!=NULL)
            if (event -> string [0] != 0)
            {
                if (cedit_put_char (cedit -> edit, event -> string [0]) != 0)
                    g_print ("error al poner la letra %d %c %X", event -> keyval, event -> keyval, event -> keyval);
                noredraw = gtk_cedit_move_scroll_to_show_cursor (cedit);
                if (cedit_get_line_num_char (cedit -> edit) >(int) cedit -> hadj -> upper)
                {
                    
                    cedit -> hadj -> upper = cedit_get_line_num_char (cedit -> edit);
                    gtk_signal_emit_by_name (GTK_OBJECT (cedit -> hadj), "changed");
                }
            }
        }
    }
    
        // shift pulsado
    if (event -> state & GDK_SHIFT_MASK)
    {
        noredraw = false;
        cedit_set_last_selection_point (cedit -> edit);
    }
    
        //  if (noredraw==false)
    cedit_search_block_flag (cedit -> edit); // busco el inicio o el fin del bloque ({[ ]})
    gtk_cedit_redraw_back_buffer (widget, NULL);
    
    
    if (cedit_have_undo (cedit -> edit) > 0 && have_undo_before < 1)        // si antes no habia undo, y ahora si, emito una seÃ±al
        gtk_signal_emit (GTK_OBJECT (widget), gtk_cedit_signals [HAVE_UNDO]);
    
    have_redo_before = cedit_have_redo (cedit -> edit);
    cedit_del_all_redo (cedit -> edit);
    if (have_redo_before > 0)
        gtk_signal_emit (GTK_OBJECT (widget), gtk_cedit_signals [NO_HAVE_REDO]);
    
    event -> state = 0;
    event -> keyval = 0;
    return - 1;
}


static gint
gtk_cedit_button_press (GtkWidget *widget, GdkEventButton *event)
{
    GtkCEdit *gtkcedit;
    glong pos_x, pos_y;
    glong pixel_x;
    gchar *filename;
    gchar text[30];
    gint count;
    gboolean have_items;
    
    GtkWidget *menu; // menu pup-up
    GtkWidget *submenu;
    GtkWidget *menuitem;
    GtkWidget *submenuitem;

    suggest_struct *new_suggest_result;

    result_definition_db *result;
    result_definition_db *result2;

    gtkcedit = GTK_CEDIT (widget);
    
        // si no tengo el foco, lo obtengo
    {
        GTK_WIDGET_SET_FLAGS (widget, GTK_HAS_FOCUS);
        gtk_widget_grab_focus (widget);
        gtk_widget_grab_default (widget);
    }

        // boton izquierdo del raton
    if (event -> button == 1)
      {
        cedit_del_selection (gtkcedit -> edit);
            // busco la letra pulsada (ahora solo la y)
        pos_y =((int) gtkcedit -> vadj -> value + event -> y) / gtkcedit -> char_height;
        pos_x =(int) gtkcedit -> hadj -> value;
        cedit_move_cursor (gtkcedit -> edit, pos_x, pos_y);
        if (pos_x <=(cedit_get_tabs (gtkcedit -> edit) *gtkcedit -> space_tabs))
            pixel_x = gtkcedit -> left_edge +((cedit_get_tabs (gtkcedit -> edit) *gtkcedit -> space_tabs) - pos_x) *gtkcedit -> space_width;
        else
        {
            pixel_x = gtkcedit -> left_edge;
            pos_x -=(cedit_get_tabs (gtkcedit -> edit) *gtkcedit -> space_tabs);
            cedit_move_cursor (gtkcedit -> edit, pos_x, pos_y);
        }
            //      pos_x-=cedit_get_tabs(gtkcedit->edit)*gtkcedit->space_tabs;
            //      cedit_move_cursor(gtkcedit->edit, pos_x, pos_y);
        
            //FIXME: hacer algo con los tabs
            // busco la letra pulsada (ahora solo la x)
            //      pixel_x=gtkcedit->left_edge;
        while (pixel_x + gdk_char_width (gtkcedit -> Fnormal, cedit_get_char (gtkcedit -> edit)) < event -> x)
        {
            pixel_x += gdk_char_width (gtkcedit -> Fnormal, cedit_get_char (gtkcedit -> edit));
            cedit_move_cursor_right (gtkcedit -> edit);
        }
        
            //gtkcedit->redraw_all=true;
        cedit_set_first_selection_point (gtkcedit -> edit);
        gtkcedit -> left_mouse_button = true;
        gtk_cedit_redraw_back_buffer (widget, NULL);
        
      }
	//    else if (event->button==3)
    if (event->button==3)
      {

	// situo el cursor
	// busco la letra pulsada (ahora solo la y)
        pos_y =((int) gtkcedit -> vadj -> value + event -> y) / gtkcedit -> char_height;
        pos_x =(int) gtkcedit -> hadj -> value;
        cedit_move_cursor (gtkcedit -> edit, pos_x, pos_y);
        if (pos_x <=(cedit_get_tabs (gtkcedit -> edit) *gtkcedit -> space_tabs))
            pixel_x = gtkcedit -> left_edge +((cedit_get_tabs (gtkcedit -> edit) *gtkcedit -> space_tabs) - pos_x) *gtkcedit -> space_width;
        else
        {
            pixel_x = gtkcedit -> left_edge;
            pos_x -=(cedit_get_tabs (gtkcedit -> edit) *gtkcedit -> space_tabs);
            cedit_move_cursor (gtkcedit -> edit, pos_x, pos_y);
        }
        
            //FIXME: hacer algo con los tabs
            // busco la letra pulsada (ahora solo la x)
            //      pixel_x=gtkcedit->left_edge;
        while (pixel_x + gdk_char_width (gtkcedit -> Fnormal, cedit_get_char (gtkcedit -> edit)) < event -> x)
        {
            pixel_x += gdk_char_width (gtkcedit -> Fnormal, cedit_get_char (gtkcedit -> edit));
            cedit_move_cursor_right (gtkcedit -> edit);
        }

        
	// creo el popup
	menu=gtk_menu_new();

	// primer item del menu: ir a definicin, solo si tengo la funcion que lo controla
	
	if (gtkcedit->go_to_definition_callback!=NULL)
	  {
	    menuitem=gtk_menu_item_new_with_label("Ir a definicion");
	    gtk_menu_append(GTK_MENU(menu), menuitem);
	    filename=gtk_cedit_go_to_definition(gtkcedit, &pos_y);
	    if (pos_y<0)
	      gtk_widget_set_sensitive(menuitem, FALSE);
	    gtk_widget_show(menuitem);

	    // ahora todas las posibilidades
	    submenu=gtk_menu_new();
	    result=cedit_get_first_result(gtkcedit->edit);
	    while(result!=NULL)
	      {
		//		if (cedit_get_filename_result(gtkcedit->edit, result)==NULL)
		  sprintf(text,"%s (linea: %ld)", 
			  cedit_get_name_result(gtkcedit->edit, result), 
			  cedit_get_line_result(gtkcedit->edit, result)+1);
		  /*		else
		  {
		    name=gtk_cedit_get_name(cedit_get_filename_result(gtkcedit->edit, result));		    
		    sprintf(text,"%s (linea: %ld  file: %s)", 
			    cedit_get_name_result(gtkcedit->edit, result), 
			    cedit_get_line_result(gtkcedit->edit, result)+1,
			    name);
		    free(name);
		  }
		  */
		submenuitem=gtk_menu_item_new_with_label(text);
		g_signal_connect_swapped(submenuitem, "activate", G_CALLBACK(gtkcedit->go_to_definition_callback), 
				 (result_definition_db*)result);
		gtk_menu_append(GTK_MENU(submenu), submenuitem);
		gtk_widget_show(submenuitem);
		result=cedit_get_next_result(gtkcedit->edit, result);
	      }
	    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu);

	  }

	menuitem=gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_widget_show(menuitem);
	menuitem=gtk_menu_item_new_with_label("Ir a marcador");
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_widget_show(menuitem);

	submenu=gtk_menu_new();
	have_items=FALSE;
	for (count=0;count<10;count++)
	  {	    
	    if (gtk_cedit_have_bookmark(gtkcedit, count)>0)
	      {
		have_items=TRUE;
		sprintf(text,"Marcador %d", count);	    
		submenuitem=gtk_menu_item_new_with_label(text);
		gtk_menu_append(GTK_MENU(submenu), submenuitem);
		if (count==0) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_go_to_bookmark_0),gtkcedit);
		if (count==1) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_go_to_bookmark_1),gtkcedit);
		if (count==2) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_go_to_bookmark_2),gtkcedit);
		if (count==3) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_go_to_bookmark_3),gtkcedit);
		if (count==4) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_go_to_bookmark_4),gtkcedit);
		if (count==5) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_go_to_bookmark_5),gtkcedit);
		if (count==6) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_go_to_bookmark_6),gtkcedit);
		if (count==7) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_go_to_bookmark_7),gtkcedit);
		if (count==8) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_go_to_bookmark_8),gtkcedit);
		if (count==9) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_go_to_bookmark_9),gtkcedit);
		gtk_widget_show(submenuitem);
	      }
 	  }
	if (have_items==FALSE)
	  gtk_widget_set_sensitive(menuitem, FALSE);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu);

	menuitem=gtk_menu_item_new_with_label("Poner marcador");
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_widget_show(menuitem);

	submenu=gtk_menu_new();
	have_items=FALSE;
	for (count=0;count<10;count++)
	  {
	    if (gtk_cedit_have_bookmark(gtkcedit, count)==0)
	      {
		have_items=TRUE;
		sprintf(text,"Marcador %d", count);	    
		submenuitem=gtk_menu_item_new_with_label(text);
		gtk_menu_append(GTK_MENU(submenu), submenuitem);
		if (count==0) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_put_bookmark_0),gtkcedit);
		if (count==1) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_put_bookmark_1),gtkcedit);
		if (count==2) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_put_bookmark_2),gtkcedit);
		if (count==3) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_put_bookmark_3),gtkcedit);
		if (count==4) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_put_bookmark_4),gtkcedit);
		if (count==5) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_put_bookmark_5),gtkcedit);
		if (count==6) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_put_bookmark_6),gtkcedit);
		if (count==7) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_put_bookmark_7),gtkcedit);
		if (count==8) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_put_bookmark_8),gtkcedit);
		if (count==9) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_put_bookmark_9),gtkcedit);
		gtk_widget_show(submenuitem);
	      }
	  }
	if (have_items==FALSE)
	  gtk_widget_set_sensitive(menuitem, FALSE);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu);

	menuitem=gtk_menu_item_new_with_label("Quitar marcador");
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_widget_show(menuitem);

	submenu=gtk_menu_new();
	have_items=FALSE;
	for (count=0;count<10;count++)
	  {	    
	    if (gtk_cedit_have_bookmark(gtkcedit, count)>0)
	      {
		have_items=TRUE;
		sprintf(text,"Marcador %d", count);	    
		submenuitem=gtk_menu_item_new_with_label(text);
		gtk_menu_append(GTK_MENU(submenu), submenuitem);
		if (count==0) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_del_bookmark_0),gtkcedit);
		if (count==1) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_del_bookmark_1),gtkcedit);
		if (count==2) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_del_bookmark_2),gtkcedit);
		if (count==3) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_del_bookmark_3),gtkcedit);
		if (count==4) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_del_bookmark_4),gtkcedit);
		if (count==5) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_del_bookmark_5),gtkcedit);
		if (count==6) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_del_bookmark_6),gtkcedit);
		if (count==7) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_del_bookmark_7),gtkcedit);
		if (count==8) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_del_bookmark_8),gtkcedit);
		if (count==9) g_signal_connect_swapped(G_OBJECT(submenuitem),"activate",G_CALLBACK(gtk_cedit_del_bookmark_9),gtkcedit);
		gtk_widget_show(submenuitem);
	      }
	  }
	if (have_items==FALSE)
	  gtk_widget_set_sensitive(menuitem, FALSE);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu);

	menuitem=gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu), menuitem);
	gtk_widget_show(menuitem);
	
	
	menuitem=gtk_menu_item_new_with_label("Deshacer");
	gtk_menu_append(GTK_MENU(menu), menuitem);
	g_signal_connect_swapped(G_OBJECT(menuitem),"activate",G_CALLBACK(gtk_cedit_undo),gtkcedit);
	if (gtk_cedit_have_undo(gtkcedit)==0)
	      gtk_widget_set_sensitive(menuitem, FALSE);
	gtk_widget_show(menuitem);

	menuitem=gtk_menu_item_new_with_label("Rehacer");
	gtk_menu_append(GTK_MENU(menu), menuitem);
	g_signal_connect_swapped(G_OBJECT(menuitem),"activate",G_CALLBACK(gtk_cedit_redo),gtkcedit);
	if (gtk_cedit_have_redo(gtkcedit)==0)
	      gtk_widget_set_sensitive(menuitem, FALSE);
	gtk_widget_show(menuitem);

	menuitem=gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu), menuitem);
		gtk_widget_show(menuitem);
		
	menuitem=gtk_menu_item_new_with_label("Sugerencias");
	gtk_menu_append(GTK_MENU(menu), menuitem);

	if (cedit_get_suggestion(gtkcedit->edit)>=0)
	  {
	    submenu=gtk_menu_new();
	    result=cedit_get_first_result_suggest(gtkcedit->edit);
	    while(result!=NULL)
	      {
		// miro que el nombre de result no este ya
		
		result2=cedit_get_first_result_suggest(gtkcedit->edit);
		while (result2!=NULL && result!=result2)
		  {
		    if (strcmp(cedit_get_name_result(gtkcedit->edit, result),
			       cedit_get_name_result(gtkcedit->edit, result2))==0)
		      // si son iguales
		      break; // corto este while			
		    result2=cedit_get_next_result(gtkcedit->edit, result2);
		  }

		if (result==result2) // no ha sido encontrado (solo me he encontrado yo)
		  {
		    sprintf(text,"%s", cedit_get_name_result(gtkcedit->edit, result));
		    new_suggest_result=(suggest_struct*)malloc(sizeof(suggest_struct));
		    new_suggest_result->gtkcedit=gtkcedit;
		    new_suggest_result->text=strdup(cedit_get_name_result(gtkcedit->edit, result));
		    submenuitem=gtk_menu_item_new_with_label(text);
		    g_signal_connect_swapped(submenuitem, "activate", G_CALLBACK(gtk_cedit_put_suggestion), 
					     new_suggest_result);
		    gtk_menu_append(GTK_MENU(submenu), submenuitem);
		    gtk_widget_show(submenuitem);
		  }
		result=cedit_get_next_result(gtkcedit->edit, result);
	      }
	    gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu);
	    gtk_widget_show(submenu);
	  }
	else
	  gtk_widget_set_sensitive(menuitem, FALSE);

	gtk_widget_show(menuitem);
		
	
	gtk_widget_show(menu);

	gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, event->button, event->time);	
	
      }
    return - 1;
}

static gint
gtk_cedit_button_release (GtkWidget *widget, GdkEventButton *event)
{
    GtkCEdit *gtkcedit;
    
    gtkcedit = GTK_CEDIT (widget);
    gtkcedit -> left_mouse_button = false;
    return - 1;
}

static gint gtk_cedit_motion_notify     (GtkWidget        *widget,
    GdkEventMotion   *event)
{
    GtkCEdit *gtkcedit;
    glong pos_x, pos_y;
    glong pixel_x;
    
    gtkcedit = GTK_CEDIT (widget);
    if (gtkcedit -> left_mouse_button == true)
    {
            // busco la letra pulsada (ahora solo la y)
        pos_y =((int) gtkcedit -> vadj -> value + event -> y) / gtkcedit -> char_height;
        pos_x =(int) gtkcedit -> hadj -> value;
        cedit_move_cursor (gtkcedit -> edit, pos_x, pos_y);
        if (pos_x <=(cedit_get_tabs (gtkcedit -> edit) *gtkcedit -> space_tabs))
            pixel_x = gtkcedit -> left_edge +((cedit_get_tabs (gtkcedit -> edit) *gtkcedit -> space_tabs) - pos_x) *gtkcedit -> space_width;
        else
        {
            pixel_x = gtkcedit -> left_edge;
            pos_x -=(cedit_get_tabs (gtkcedit -> edit) *gtkcedit -> space_tabs);
            cedit_move_cursor (gtkcedit -> edit, pos_x, pos_y);
        }
            //      pos_x-=cedit_get_tabs(gtkcedit->edit)*gtkcedit->space_tabs;
            //      cedit_move_cursor(gtkcedit->edit, pos_x, pos_y);
            //FIXME: hacer algo con los tabs
            // busco la letra pulsada (ahora solo la x)
            //      pixel_x=gtkcedit->left_edge+cedit_get_tabs(gtkcedit->edit)*gtkcedit->space_tabs;
            //      pixel_x=gtkcedit->left_edge+cedit_get_tabs(gtkcedit->edit)*gtkcedit->space_tabs*gtkcedit->space_width;
        while (pixel_x + gdk_char_width (gtkcedit -> Fnormal, cedit_get_char (gtkcedit -> edit)) < event -> x)
        {
            pixel_x += gdk_char_width (gtkcedit -> Fnormal, cedit_get_char (gtkcedit -> edit));
            cedit_move_cursor_right (gtkcedit -> edit);
        }
        
        cedit_set_last_selection_point (gtkcedit -> edit);
        gtk_cedit_redraw_back_buffer (widget, NULL);
    }
    return - 1;
}
static void gtk_cedit_adjustments_value_changed (GtkAdjustment *adjustment,
    GtkWidget *widget)
{
    GtkCEdit *cedit;
        // char *changes;
    
    g_return_if_fail (widget != NULL);
    g_return_if_fail (GTK_IS_CEDIT (widget));
    g_return_if_fail (adjustment != NULL);
    
        //g_print("adjustment\n");
        //  g_print("key_pressed: %d\n", event->keyval);
    cedit = GTK_CEDIT (widget);
    
    
        // mantengo los valores del scroll dentro de los limites
    if (cedit -> vadj -> value + cedit -> vadj -> page_size > cedit -> vadj -> upper) cedit -> vadj -> value = cedit -> vadj -> upper - cedit -> vadj -> page_size;
    if (cedit -> vadj -> value < 0) cedit -> vadj -> value = 0;
    
    
    if (cedit -> hadj -> value + cedit -> hadj -> page_size > cedit -> hadj -> upper) cedit -> hadj -> upper = cedit -> hadj -> value + cedit -> hadj -> page_size;
    if (cedit -> hadj -> value < 0) cedit -> hadj -> value = 0;
    
        //  g_print("REDIBUJO TODO\n");
    
        //  if (cedit->last_vadj->value!=cedit->vadj->value)
        //{
        // asi se redibuja todo
    
    cedit -> redraw_all = true;
    gtk_cedit_redraw_back_buffer (widget, NULL);
        // }
}

gint gtk_cedit_move_scroll_to_show_cursor (GtkCEdit *cedit)
{
    gint cursor_x, cursor_y;
    gint pixel_y;
    gboolean changes_x, changes_y;
    
    g_return_val_if_fail (cedit != NULL, false);
    
    //  g_print("move_scroll_to\n");
    
    changes_x = false;
    changes_y = false;
    
    cursor_x = cedit_get_cursor_x (cedit -> edit);
    cursor_y = cedit_get_cursor_y (cedit -> edit);
    
    //pixel_y=-(int)(cedit->vadj->value);
    pixel_y = cursor_y *cedit -> char_height;
    
    // si el cursor esta por encima del limite superior
    if (pixel_y <(int) (cedit -> vadj -> value + 0.2 *cedit -> vadj -> page_size))
      {
        if (cedit -> vadj -> value > 0) // si no esta ya al maximo el scroll
	  {
	    if (cedit->fast_scroll==true)
	      //#ifdef GTK_CEDIT_FAST_SCROLL
	      cedit -> vadj -> value = pixel_y -(int) (0.5 *cedit -> vadj -> page_size);
	    else
	      //#else
	      cedit -> vadj -> value = pixel_y - (int) (0.2 *cedit -> vadj -> page_size);

	    //#endif
	    if (cedit -> vadj -> value < 0)
	      cedit -> vadj -> value = 0;
	    changes_y = true;
	  }
      }
    
    // si el cursor esta por debajo del limite superior
    if (pixel_y > (int) (cedit -> vadj -> value + 0.8 * cedit -> vadj -> page_size))
      {
	if (cedit -> vadj -> value < cedit -> vadj -> upper - cedit -> vadj -> page_size)
	  {
	    //#ifdef GTK_CEDIT_FAST_SCROLL
	    if (cedit->fast_scroll==true)
	      cedit -> vadj -> value = pixel_y -(int) (0.5 *cedit -> vadj -> page_size);
	    //#else
	    else
	      cedit -> vadj -> value = pixel_y -(int) (0.8 *cedit -> vadj -> page_size);
	    //#endif
	    changes_y = true;
	  }
      }
    
    // si esta por la izquierda
    if (cursor_x - 1 + cedit_get_tabs (cedit -> edit) *cedit -> space_tabs < cedit -> hadj -> value)
      {
	if (cedit -> hadj -> value > 1)
	  {
	    cedit -> hadj -> value = cursor_x - 1 - cedit_get_tabs (cedit -> edit) *cedit -> space_tabs;
	    changes_x = true;
	  }
      }
    
    // si esta por la derecha
    if (cursor_x + 1 + cedit_get_tabs (cedit -> edit) *cedit -> space_tabs > cedit -> hadj -> value + cedit -> hadj -> page_size)
      {
	cedit -> hadj -> value = cursor_x - cedit -> hadj -> page_size + 1 + cedit_get_tabs (cedit -> edit) *cedit -> space_tabs;
	changes_x = true;
      }
    
    if (changes_y == true)
      {
	gtk_signal_emit_by_name (GTK_OBJECT (cedit -> vadj), "value_changed");
	return - 1;
      }
    if (changes_x == true)
      {
	gtk_signal_emit_by_name (GTK_OBJECT (cedit -> hadj), "value_changed");
	return 1;
      }
    return 0;
}

int
gtk_cedit_open_file (GtkCEdit *gtkcedit, gchar *filename)
{

  CEdit *ret;

  g_return_val_if_fail (gtkcedit != NULL, - 1);
  g_return_val_if_fail (filename != NULL, - 1);
  g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit),- 1);
  
  if (gtk_cedit_new_file (gtkcedit) < 0)
    return - 1;

  gtkcedit -> freeze = true;
  
  //  g_print("Abro %s en %d", filename, cedit->edit->cursors[0].y);


  //  gtk_timeout_add(100, gtk_cedit_progressbar_callback, gtkcedit);

  gtkcedit -> show_cursor = false; // para que no moleste
  ret=cedit_open_file (gtkcedit -> edit, filename, gtk_cedit_progressbar_callback, gtkcedit -> progressbar);
  if (ret==NULL)
    {
      gtkcedit -> show_cursor = true; // para que no moleste
      gtkcedit -> freeze = false;
      gtkcedit -> vadj -> upper = cedit_get_file_num_line (gtkcedit -> edit) *gtkcedit -> char_height;
      
      gtk_signal_emit_by_name (GTK_OBJECT (gtkcedit -> vadj), "value_changed");
      
      if (gtk_cedit_calculate_left_edge(gtkcedit)==0)
	{
	  gtkcedit -> redraw_all = true;
	  gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);
	}
      return -1;
    }

  gtk_cedit_set_filename (gtkcedit, filename);
  gtk_cedit_progressbar_set_text (gtkcedit, "Cargando...");
  gtkcedit -> edit = ret;
  cedit_set_limit_undo_redo (gtkcedit -> edit, 16);              // 16k de memoria para undo's
  
  gtkcedit -> scroll_cursor = cedit_new_cursor (gtkcedit -> edit);
  if (gtkcedit -> scroll_cursor < 0)
    {
      g_error ("No se ha podido crear el cursor secundario");
      gtkcedit -> freeze = false;
      return - 1;
    }
  
  gtkcedit -> freeze = false;
  gtkcedit -> vadj -> upper = cedit_get_file_num_line (gtkcedit -> edit) *gtkcedit -> char_height;
  
  gtk_signal_emit_by_name (GTK_OBJECT (gtkcedit -> vadj), "value_changed");
  
  if (gtk_cedit_calculate_left_edge(gtkcedit)==0)
    {
      gtkcedit -> redraw_all = true;
      gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);
    }
  // asi se redibuja todo
  //   move_cursor(cedit->screen, 0, 0);
  //  del_until_end_of_file(cedit->screen);
  //  gtk_cedit_redraw_back_buffer(widget, NULL);
  gtkcedit -> show_cursor = true;
  return 0;
}



int
gtk_cedit_save_file (GtkCEdit *gtkcedit)
{
  g_return_val_if_fail (gtkcedit != NULL, - 1);
  g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit), - 1);
  
  g_print ("Grabando %s...\n", gtkcedit -> name);
  cedit_save_file (gtkcedit -> edit, gtkcedit -> name);
  
  return 0;
}

int
gtk_cedit_save_as_file (GtkCEdit *gtkcedit, gchar *filename)
{
g_return_val_if_fail (gtkcedit != NULL, - 1);
g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit), - 1);
g_return_val_if_fail (filename != NULL, - 1);

//free (gtkcedit -> name);
gtk_cedit_set_filename (gtkcedit, filename);
g_print ("Grabando a %s...\n", gtkcedit -> name);
cedit_save_file (gtkcedit -> edit, gtkcedit -> name);

return 0;
}

int
gtk_cedit_new_file (GtkCEdit *gtkcedit)
{
  g_return_val_if_fail (gtkcedit != NULL, - 1);
  g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit), - 1);
  
  gtkcedit -> freeze = true;
  
  gtkcedit -> edit = cedit_clear (gtkcedit -> edit);
  if (gtkcedit -> edit == NULL)
    {
      g_warning ("No se ha podido crear el objeto CEdit principal");
      return - 1;
    }
  gtk_cedit_reset_values (gtkcedit);
  cedit_set_limit_undo_redo (gtkcedit -> edit, 16);              // 16k de memoria para undo's
  
  gtk_adjustment_changed (gtkcedit -> hadj);
  gtk_adjustment_changed (gtkcedit -> vadj);
  
  /*
  cedit_insert_include_path(gtkcedit->edit, "/usr/include/");
    cedit_insert_include_path(gtkcedit->edit, "/usr/local/include/");
    cedit_insert_include_path(gtkcedit->edit, "/usr/lib/gcc-lib/i386-redhat-linux/2.96/include/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/gtk-2.0/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/lib/gtk-2.0/include/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/atk-1.0/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/pango-1.0/");
    cedit_insert_include_path(gtkcedit->edit, "/usr/X11R6/include/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/freetype2/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/include/glib-2.0/");
    cedit_insert_include_path(gtkcedit->edit, "/opt/garnome/lib/glib-2.0/include/");
  */

//  gtk_signal_emit_by_name(GTK_OBJECT(gtkcedit->hadj), "value_changed");
//  gtk_signal_emit_by_name(GTK_OBJECT(gtkcedit->vadj), "value_changed");

gtkcedit -> freeze = false;
gtkcedit -> redraw_all = TRUE;

gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);

return 0;
}

int
gtk_cedit_set_filename (GtkCEdit *gtkcedit, gchar *filename)
{
  g_return_val_if_fail (gtkcedit != NULL, - 1);
  g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit), - 1);
  g_return_val_if_fail (filename != NULL, - 1);
  
  if (gtkcedit -> name!=NULL)
    free (gtkcedit -> name);
  gtkcedit -> name =(gchar *) malloc (strlen (filename) *sizeof (gchar)+5);
  strcpy (gtkcedit -> name, filename);
  return 0;
}

gchar*
gtk_cedit_get_filename (GtkCEdit *gtkcedit)
{
g_return_val_if_fail (gtkcedit != NULL, NULL);
g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit), NULL);

return gtkcedit -> name;
}

int
gtk_cedit_undo (GtkCEdit *gtkcedit)
{
int retorno;
gboolean have_redo_before;

g_return_val_if_fail (gtkcedit != NULL, - 1);
g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit), - 1);

have_redo_before = cedit_have_redo (gtkcedit -> edit);

retorno = cedit_undo (gtkcedit -> edit);
if (!gtk_cedit_move_scroll_to_show_cursor (gtkcedit))
gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);

if (cedit_have_undo (gtkcedit -> edit) < 1)                            // si ahora no quedan undo
gtk_signal_emit (GTK_OBJECT ((GtkWidget *) gtkcedit), gtk_cedit_signals [NO_HAVE_UNDO]);    // mando la seÃ±al de que ya no hay

if (cedit_have_redo (gtkcedit -> edit) > 0 && have_redo_before < 1)        // si antes no habia undo, y ahora si, emito una seÃ±al
gtk_signal_emit (GTK_OBJECT ((GtkWidget *) gtkcedit), gtk_cedit_signals [HAVE_REDO]);
return retorno;
}

int
gtk_cedit_redo (GtkCEdit *gtkcedit)
{
int retorno;
gboolean have_undo_before;

g_return_val_if_fail (gtkcedit != NULL, - 1);
g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit), - 1);

have_undo_before = cedit_have_undo (gtkcedit -> edit);

retorno = cedit_redo (gtkcedit -> edit);
if (!gtk_cedit_move_scroll_to_show_cursor (gtkcedit))
gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);

if (cedit_have_redo (gtkcedit -> edit) < 1)                            // si ahora no quedan undo
gtk_signal_emit (GTK_OBJECT ((GtkWidget *) gtkcedit), gtk_cedit_signals [NO_HAVE_REDO]);    // mando la seÃ±al de que ya no hay

if (cedit_have_undo (gtkcedit -> edit) > 0 && have_undo_before < 1)        // si antes no habia undo, y ahora si, emito una seÃ±al
gtk_signal_emit (GTK_OBJECT ((GtkWidget *) gtkcedit), gtk_cedit_signals [HAVE_UNDO]);

return retorno;
}

gint gtk_cedit_cut (GtkCEdit *gtkcedit)
{
  GtkClipboard *clipb;
  char *text;
  char *textUTF;
  glong num_lines;
  gboolean have_undo_before;
  
  g_return_val_if_fail (gtkcedit != NULL, - 1);
  g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit), - 1);
  
  have_undo_before = cedit_have_undo (gtkcedit -> edit);
  
  text = cedit_get_selection_text (gtkcedit -> edit);
  if (text == NULL)
    {
      g_warning ("%s", cedit_get_error (gtkcedit -> edit));
      return - 1;
    }
  
  
  cedit_cut_text (gtkcedit -> edit); // corto el texto
  cedit_del_selection (gtkcedit -> edit);
  // el texto que he de dar al portapeles esta en UTF-8. Esto significa que no soporta
  // acentos ni na, lo convierto de ISO-8859-1, que es nuestro codigo
  // FIXME: que pasa con otros cÃ³digos?
  textUTF = g_convert (text,
		       strlen (text),
		       "UTF-8",
		       "ISO-8859-1",
		       NULL,
		       NULL,
		       NULL);
  
  clipb = gtk_clipboard_get (GDK_NONE);
  gtk_clipboard_set_text (clipb, textUTF, strlen (textUTF));
  
  // miro si la barra izquierda es mas grande porque ahora hay mas lineas
  num_lines = cedit_get_file_num_line (gtkcedit -> edit);
  gtkcedit -> vadj -> upper = num_lines *gtkcedit -> char_height;
  //      if (gtkcedit->vadj->value>gtkcedit->vadj->upper)
  //gtkcedit->vadj->value=gtkcedit->vadj->value;
  gtk_cedit_calculate_left_edge(gtkcedit);
  
  gtkcedit -> show_cursor = true;
  if (cedit_have_undo (gtkcedit -> edit) > 0 && have_undo_before < 1)        // si antes no habia undo, y ahora si, emito una seÃ±al
    gtk_signal_emit (GTK_OBJECT ((GtkWidget *) gtkcedit), gtk_cedit_signals [HAVE_UNDO]);
  
  //  if (gtk_cedit_move_scroll_to_show_cursor (gtkcedit) == false)
  //    gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);
  gtk_cedit_move_scroll_to_show_cursor (gtkcedit);
  gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);
  //      free(text);
  //    free(text);
  //  free(textUTF);
  return 0;
}

gint gtk_cedit_copy (GtkCEdit *gtkcedit)
{
GtkClipboard *clipb;
char *text;
char *textUTF;

g_return_val_if_fail (gtkcedit != NULL, - 1);
g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit), - 1);

text = cedit_get_selection_text (gtkcedit -> edit);
if (text == NULL)
{
g_warning ("%s", cedit_get_error (gtkcedit -> edit));
return - 1;
}

cedit_del_selection (gtkcedit -> edit);
// el texto que he de dar al portapeles esta en UTF-8. Esto significa que no soporta
// acentos ni na, lo convierto de ISO-8859-1, que es nuestro codigo
// FIXME: que pasa con otros cÃ³digos?
textUTF = g_convert (text,
strlen (text),
"UTF-8",
"ISO-8859-1",
NULL,
NULL,
NULL);

clipb = gtk_clipboard_get (GDK_NONE);
gtk_clipboard_set_text (clipb, textUTF, strlen (textUTF));

//    free(text);
//  free(textUTF);
return 0;
}

gint gtk_cedit_paste (GtkCEdit *gtkcedit)
{
  GtkClipboard *clipb;
  
  clipb = gtk_clipboard_get (GDK_NONE);
  gtk_clipboard_request_text (clipb, gtk_cedit_paste_callback, (GtkWidget *) gtkcedit);
  return 0;
}

void gtk_cedit_paste_callback (GtkClipboard *clipboard,
			       const gchar *text,
			       gpointer _widget)
{
  GtkWidget *widget;
  GtkCEdit *gtkcedit;
  //  gint cont;
  gchar *sol;
  glong num_lines;
  //  gint state_fast_color;
  gboolean have_undo_before;
  
  widget=(GtkWidget*)_widget;
  gtkcedit = GTK_CEDIT (widget);
  
if (text != NULL)
{

have_undo_before = cedit_have_undo (gtkcedit -> edit);

    // el texto que me devuelve el portapeles esta en UTF-8. Esto significa que no soporta
    // acentos ni na, lo convierto a ISO-8859-1, que es nuestro codigo
    // FIXME: que pasa con otros cÃ³digos?
sol = g_convert (text,
    strlen (text),
    "ISO-8859-1",
    "UTF-8",
    NULL,
    NULL,
    NULL);

gtkcedit -> show_cursor = false;
cedit_paste_text (gtkcedit -> edit, sol);
    // pongo el modo de flags por linea, que es mas rapido
    /*      state_fast_color=cedit_get_fast_color(gtkcedit->edit);
    if (state_fast_color==0) // desactivado
    cedit_toggle_fast_color(gtkcedit->edit);
    
    
    for (cont=0;cont<strlen(sol);cont++)
    {
    if (text[cont]=='\n')
    {
    cedit_put_char(gtkcedit->edit, '\n');
    gtkcedit->vadj->upper+=gtkcedit->char_height;
    }
    else
    cedit_put_char(gtkcedit->edit, text[cont]);
    }

    if (state_fast_color==0) // desactivado, lo activo ahora
    cedit_toggle_fast_color(gtkcedit->edit);
    */

cedit_del_selection (gtkcedit -> edit);

    // miro si la barra izquierda es mas grande porque ahora hay mas lineas

num_lines = cedit_get_file_num_line (gtkcedit -> edit);
gtkcedit -> vadj -> upper = num_lines *gtkcedit -> char_height;
    //      if (gtkcedit->vadj->value>gtkcedit->vadj->upper)
    //gtkcedit->vadj->value=gtkcedit->vadj->value;
 gtk_cedit_calculate_left_edge(gtkcedit);

gtkcedit -> show_cursor = true;
if (cedit_have_undo (gtkcedit -> edit) > 0 && have_undo_before < 1)        // si antes no habia undo, y ahora si, emito una seÃ±al
    gtk_signal_emit (GTK_OBJECT (widget), gtk_cedit_signals [HAVE_UNDO]);

if (gtk_cedit_move_scroll_to_show_cursor (gtkcedit) == false)
    gtk_cedit_redraw_back_buffer (widget, NULL);
    //      free(text);
free (sol);
}
if (gtk_cedit_move_scroll_to_show_cursor (gtkcedit) == false)
gtk_cedit_redraw_back_buffer (widget, NULL);
}

void gtk_cedit_test (GtkWidget *widget)
{
GtkCEdit *gtkcedit;
glong chars;
glong lines;
GdkEventKey event;
time_t before, after;

g_return_if_fail (widget != NULL);

gtkcedit = GTK_CEDIT (widget);

time (&before);

//  gtk_timeout_add(200, gtk_cedit_progressbar_callback, gtkcedit);

gtk_cedit_new_file (gtkcedit);
event.string =(char *) malloc (2);

// primer paso del test -> escribir un pedazo de texto
for (lines = 1000; lines > 0; lines --)
{
for (chars = 100; chars > 0; chars --)
{
    event.keyval ='a' + rand () % 25;
    event.string [0] = event.keyval;
    event.string [1] ='\0';
    gtk_cedit_key_press (widget, &event);
}
event.keyval = GDK_Return;
gtk_cedit_key_press (widget, &event);
if (lines % 100 == 0)
    gtk_cedit_progressbar_callback (1.0 -(double) ((double) lines / 1000),(void *) gtkcedit -> progressbar);
    //*g_print("faltan: %ld\n", lines);
}

for (lines = 100; lines > 0; lines --)
{
event.keyval = GDK_Up;
gtk_cedit_key_press (widget, &event);
}
free (event.string);
time (&after);

g_print ("tiempo: %ld segs\n", (int) after - before);

}

// pone la barra de progreso
gint
gtk_cedit_set_progress_bar (GtkCEdit *gtkcedit, GtkProgressBar *pb)
{
gtkcedit -> progressbar = pb;
return 0;
}

gint
gtk_cedit_have_undo (GtkCEdit *gtkcedit)
{
return cedit_have_undo (gtkcedit -> edit);
}

gint
gtk_cedit_have_redo (GtkCEdit *gtkcedit)
{
return cedit_have_redo (gtkcedit -> edit);
}

gint
gtk_cedit_find (GtkCEdit *gtkcedit, char *text)
{
int ret;
g_return_val_if_fail (GTK_IS_CEDIT (gtkcedit), - 1);
g_return_val_if_fail (text != NULL, - 1);

ret = cedit_find (gtkcedit -> edit, text);

if (gtk_cedit_move_scroll_to_show_cursor (gtkcedit) == false)
gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);
return ret;
}

gint
gtk_cedit_calculate_left_edge(GtkCEdit *gtkcedit)
{
  char text[100];
  gint more_left_space;
  gint count;
  gboolean mark;

  more_left_space=0;
  // calculo el espacio extra (more_left_space)
  mark=false;
  for (count=0;count<10;count++)
    if (gtkcedit->line_mark[count]>=0)
      mark=true;
  if (mark==true)
      more_left_space+=20;

  sprintf (text,"%ld", cedit_get_file_num_line(gtkcedit->edit));
  //  g_print("%d %d %d   %d\n", num_lines, cedit->char_width, cedit->left_edge, strlen(text)*cedit->char_width);
  if ((strlen (text) *gtkcedit -> char_width) + 5 +more_left_space > gtkcedit -> left_edge)
    {
      gtkcedit -> redraw_all = true;
      gtkcedit -> left_edge =(strlen (text) *gtkcedit -> char_width) + 5 + more_left_space;
      gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);
      return 1;
    }
  return 0;
}


gboolean
gtk_cedit_set_continuous_color (GtkCEdit *gtkcedit, gboolean status)
{
	gboolean prev;
	prev=cedit_get_fast_color(gtkcedit->edit);
	if (prev!=status)
	{
		cedit_toggle_fast_color(gtkcedit->edit);
	}
	return prev;
}

gboolean
gtk_cedit_set_continuous_autoidentation (GtkCEdit *gtkcedit, gboolean status)
{
	gboolean prev;
	prev=cedit_get_fast_autoident(gtkcedit->edit);
	if (prev!=status)
	{
		cedit_toggle_fast_autoident(gtkcedit->edit);
	}
	return prev;
}
gboolean
gtk_cedit_set_fast_scroll (GtkCEdit *gtkcedit, gboolean status)
{
  gboolean prev;
  prev=gtkcedit->fast_scroll;
  gtkcedit->fast_scroll=status;
  return prev;
}
gboolean
gtk_cedit_set_text_format (GtkCEdit *gtkcedit, gboolean status)
{
	gboolean prev;
	prev=cedit_get_format(gtkcedit->edit);
	if (prev!=status)
	{
		cedit_toggle_format(gtkcedit->edit);
	}
	return prev;
}
gboolean
gtk_cedit_set_continuous_correction (GtkCEdit *gtkcedit, gboolean status)
{
	gboolean prev;
	prev=cedit_get_continuous_correction(gtkcedit->edit);
	if (prev!=status)
	{
		cedit_toggle_continuous_correction(gtkcedit->edit);
	}
	return prev;
}
gboolean
gtk_cedit_set_correction (GtkCEdit *gtkcedit, gboolean status)
{
	gboolean prev;
	prev=cedit_get_correction(gtkcedit->edit);
	if (prev!=status)
	{
		cedit_toggle_correction(gtkcedit->edit);
	}
	return prev;
}


// ----------------------------------------------------
//  devuelve la linea y fichero de la mejor definicin
// ----------------------------------------------------
gchar *gtk_cedit_go_to_definition(GtkCEdit *gtkcedit, gulong *line)
{
  definition_db *def_db;

  def_db=cedit_go_to_definition(gtkcedit->edit);
  if (def_db!=NULL) // si ha sido encontrado
    {

      (*line)=def_db->n_line;
      return def_db->file;
    }

  // no encontrado
  (*line)=-1;
  return NULL;
}

// -----------------------------------------------
//  devuelve la linea y fichero de una definicin
// -----------------------------------------------
gchar *gtk_cedit_result_go_to_definition(GtkCEdit *gtkcedit, gulong *line, result_definition_db *res_definition_db)
{
  (*line)=cedit_get_line_result(gtkcedit->edit, res_definition_db);
  return cedit_get_filename_result(gtkcedit->edit, res_definition_db);
}



gint
gtk_cedit_move_cursor(GtkCEdit *gtkcedit, gulong x, gulong y)
{
  int ret;
  ret=cedit_move_cursor(gtkcedit->edit, x, y);
  gtk_cedit_move_scroll_to_show_cursor (gtkcedit);
  return ret;
}

gint 
gtk_cedit_set_go_to_definition_callback(GtkCEdit *gtkcedit, GtkSignalFunc func, gpointer data)
{
  gtkcedit->go_to_definition_callback=func;
  gtkcedit->go_to_definition_callback_data=data;
  return 0;
}

gint 
gtk_cedit_have_bookmark(GtkCEdit *gtkcedit, gint nBookMark)
{
  if (gtkcedit->line_mark[nBookMark]<0) return 0;
  return 1;
}

gint 
gtk_cedit_go_to_bookmark(GtkCEdit *gtkcedit, gint nBookMark)
{             
  if (gtkcedit->line_mark[nBookMark]>=0)
    {
      cedit_move_cursor (gtkcedit -> edit, 0, gtkcedit->line_mark[nBookMark]);
      gtk_cedit_move_scroll_to_show_cursor (gtkcedit);
      return 1;
    }
  return 0;
}


gint 
gtk_cedit_del_bookmark(GtkCEdit *gtkcedit, gint nBookMark)
{
  gtkcedit->line_mark[nBookMark]=-10;
  gtk_cedit_calculate_left_edge(gtkcedit);
  gtkcedit -> redraw_all = true;
  gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);
  return 0;
}


gint 
gtk_cedit_put_bookmark(GtkCEdit *gtkcedit, gint nBookMark)
{
  gint cont;
  // si ninguna marca esta en esta linea
  
  cont=0;
  while (gtkcedit->line_mark[cont]!=cedit_get_cursor_y(gtkcedit->edit) && cont<10)
    cont++;
  
  // si esto se da, es que no hay ninguna marca en esta linea ya
  if (cont==10)
    {
      gtkcedit->line_mark[nBookMark]=cedit_get_cursor_y(gtkcedit->edit);
      gtk_cedit_calculate_left_edge(gtkcedit);
      gtkcedit -> redraw_all = true;
      gtk_cedit_redraw_back_buffer ((GtkWidget *) gtkcedit, NULL);
      return 1;
    }
  return 0;
}


void gtk_cedit_go_to_bookmark_0 (GtkCEdit *gtkcedit)
{
  gtk_cedit_go_to_bookmark(gtkcedit, 0);
}
void gtk_cedit_go_to_bookmark_1 (GtkCEdit *gtkcedit)
{
  gtk_cedit_go_to_bookmark(gtkcedit, 1);
}
void gtk_cedit_go_to_bookmark_2 (GtkCEdit *gtkcedit)
{
  gtk_cedit_go_to_bookmark(gtkcedit, 2);
}
void gtk_cedit_go_to_bookmark_3 (GtkCEdit *gtkcedit)
{
  gtk_cedit_go_to_bookmark(gtkcedit, 3);
}
void gtk_cedit_go_to_bookmark_4 (GtkCEdit *gtkcedit)
{
  gtk_cedit_go_to_bookmark(gtkcedit, 4);
}
void gtk_cedit_go_to_bookmark_5 (GtkCEdit *gtkcedit)
{
  gtk_cedit_go_to_bookmark(gtkcedit, 5);
}
void gtk_cedit_go_to_bookmark_6 (GtkCEdit *gtkcedit)
{
  gtk_cedit_go_to_bookmark(gtkcedit, 6);
}
void gtk_cedit_go_to_bookmark_7 (GtkCEdit *gtkcedit)
{
  gtk_cedit_go_to_bookmark(gtkcedit, 7);
}
void gtk_cedit_go_to_bookmark_8 (GtkCEdit *gtkcedit)
{
  gtk_cedit_go_to_bookmark(gtkcedit, 8);
}
void gtk_cedit_go_to_bookmark_9 (GtkCEdit *gtkcedit)
{
  gtk_cedit_go_to_bookmark(gtkcedit, 9);
}

void gtk_cedit_put_bookmark_0 (GtkCEdit *gtkcedit)
{
  gtk_cedit_put_bookmark(gtkcedit, 0);
}
void gtk_cedit_put_bookmark_1 (GtkCEdit *gtkcedit)
{
  gtk_cedit_put_bookmark(gtkcedit, 1);
}
void gtk_cedit_put_bookmark_2 (GtkCEdit *gtkcedit)
{
  gtk_cedit_put_bookmark(gtkcedit, 2);
}
void gtk_cedit_put_bookmark_3 (GtkCEdit *gtkcedit)
{
  gtk_cedit_put_bookmark(gtkcedit, 3);
}
void gtk_cedit_put_bookmark_4 (GtkCEdit *gtkcedit)
{
  gtk_cedit_put_bookmark(gtkcedit, 4);
}
void gtk_cedit_put_bookmark_5 (GtkCEdit *gtkcedit)
{
  gtk_cedit_put_bookmark(gtkcedit, 5);
}
void gtk_cedit_put_bookmark_6 (GtkCEdit *gtkcedit)
{
  gtk_cedit_put_bookmark(gtkcedit, 6);
}
void gtk_cedit_put_bookmark_7 (GtkCEdit *gtkcedit)
{
  gtk_cedit_put_bookmark(gtkcedit, 7);
}
void gtk_cedit_put_bookmark_8 (GtkCEdit *gtkcedit)
{
  gtk_cedit_put_bookmark(gtkcedit, 8);
}
void gtk_cedit_put_bookmark_9 (GtkCEdit *gtkcedit)
{
  gtk_cedit_put_bookmark(gtkcedit, 9);
}

void gtk_cedit_del_bookmark_0 (GtkCEdit *gtkcedit)
{
  gtk_cedit_del_bookmark(gtkcedit, 0);
}
void gtk_cedit_del_bookmark_1 (GtkCEdit *gtkcedit)
{
  gtk_cedit_del_bookmark(gtkcedit, 1);
}
void gtk_cedit_del_bookmark_2 (GtkCEdit *gtkcedit)
{
  gtk_cedit_del_bookmark(gtkcedit, 2);
}
void gtk_cedit_del_bookmark_3 (GtkCEdit *gtkcedit)
{
  gtk_cedit_del_bookmark(gtkcedit, 3);
}
void gtk_cedit_del_bookmark_4 (GtkCEdit *gtkcedit)
{
  gtk_cedit_del_bookmark(gtkcedit, 4);
}
void gtk_cedit_del_bookmark_5 (GtkCEdit *gtkcedit)
{
  gtk_cedit_del_bookmark(gtkcedit, 5);
}
void gtk_cedit_del_bookmark_6 (GtkCEdit *gtkcedit)
{
  gtk_cedit_del_bookmark(gtkcedit, 6);
}
void gtk_cedit_del_bookmark_7 (GtkCEdit *gtkcedit)
{
  gtk_cedit_del_bookmark(gtkcedit, 7);
}
void gtk_cedit_del_bookmark_8 (GtkCEdit *gtkcedit)
{
  gtk_cedit_del_bookmark(gtkcedit, 8);
}
void gtk_cedit_del_bookmark_9 (GtkCEdit *gtkcedit)
{
  gtk_cedit_del_bookmark(gtkcedit, 9);
}


// ---------------------------------------------
//  dado un nombre completo, devuelve el nombre
// ---------------------------------------------
gchar *
gtk_cedit_get_name (gchar *orig)
{
  gchar *dest;
  gint i, j;

  if (orig==NULL) return NULL;

  dest=NULL;
  dest=(char*)malloc(strlen(orig)*sizeof(char));
  if (dest==NULL)
    return NULL;

  i = strlen (orig);
  while (i > 0 && orig [i]!='/')
    i--;
  
  if (i > 0) i ++;
  for (j = 0; j <= strlen (orig)- i; j ++)
    dest [j]= orig [j + i];
  return dest;
}

// -----------------------------------
//  Devuelve el color del texto color
// -----------------------------------
GdkColor*
gtk_cedit_get_color(GtkCEdit *gtkcedit, gint color)
{
  return &gtkcedit->colors[color];
}

// -----------------------------------
//  Establece el color del texto color
// -----------------------------------
gint
gtk_cedit_set_color(GtkCEdit *gtkcedit, gint color, GdkColor *gdkcolor)
{
  GtkWidget *widget;

  gtk_cedit_NewColor (&(gtkcedit -> colors [color]), gdkcolor->red, gdkcolor->green, gdkcolor->blue);

  widget=(GtkWidget *)gtkcedit;

  if (color==0)
    gtkcedit -> Pleft_edge = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [0]));
  if (color==1)
    gtkcedit -> Pbackground = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [1]));
  if (color==2)
    gtkcedit -> Pnormal = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [2]));
  if (color==3)
    gtkcedit -> Pendfile = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [3]));
  if (color==4)
    gtkcedit -> Preserved_word = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [4]));
  if (color==5)
    gtkcedit -> Pmacro = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [5]));
  if (color==6)
    gtkcedit -> Pcomment = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [6]));
  if (color==7)
    gtkcedit -> Pnumber = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [7]));
  if (color==8)
    gtkcedit -> Ptext = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [8]));
  if (color==9)
    gtkcedit -> PselectedBack = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [9]));
  if (color==10)
    gtkcedit -> PselectedFore = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [10]));
  if (color==11)
    gtkcedit -> PblockBack = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [11]));
  if (color==12)
    gtkcedit -> PerrorBack = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [12]));
  if (color==13)
    gtkcedit -> PMarkBack = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [13]));
  if (color==14)
    gtkcedit -> PwarningBack = gtk_cedit_GetPen (widget, &(gtkcedit -> colors [14]));

    gtkcedit -> redraw_all = true;
    gtk_cedit_redraw_back_buffer (widget, NULL);

  return 0;
}

// ---------------------------------------------
//  Escribe una sugerencia, este es el callback
//  del men emergente
// ---------------------------------------------
void gtk_cedit_put_suggestion (suggest_struct *sug_res)
{
  cedit_cset_suggestion(sug_res->gtkcedit->edit, 0, sug_res->text);
}

// -----------------------
//  Inserta un nuevo path
// -----------------------
gint gtk_cedit_insert_include_path(GtkCEdit *gtkcedit, char *text)
{
  g_return_val_if_fail (gtkcedit!=NULL, -1);
  g_return_val_if_fail (GTK_IS_CEDIT(gtkcedit), -1);
  g_return_val_if_fail (text!=NULL, -1);
  return cedit_insert_include_path(gtkcedit->edit, text);    
}

// ----------------------
//  Quita todos los path
// ----------------------

gint gtk_cedit_remove_include_path(GtkCEdit *gtkcedit)
{
  g_return_val_if_fail (gtkcedit!=NULL, -1);
  g_return_val_if_fail (GTK_IS_CEDIT(gtkcedit), -1);
  cedit_free_include_path(gtkcedit->edit);
}

