/*
ICE Intelligent C Editor
Copyright (C) 2002 Carlos RodrÃguez Caminero

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
/*
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "main.h"

GtkWidget *file_selector;
gchar *selected_filename;

void
file_new (GtkWidget *button,
    gpointer   data)
{
    statusbar_text("Nuevo fichero creado");
    create_page ();
        //   gtk_cedit_new_file (gtkcedit);
}


void store_filename (GtkFileSelection *selector, gpointer user_data)
{
  //    gint i;
    gchar *text;
    //    gchar temp_text [300];
    
    text = strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_selector)));
    cargar(text);
    /*
    text=NULL;
    i = create_page ();
    if (i >= 0)
    {
        get_name (text, filename [i]);
            //      strcpy(filename[i],);
        
        gtk_cedit_open_file (GTK_CEDIT (gtkcedit [i]), text);
        gtk_label_set_text (GTK_LABEL (label [i]), filename [i]);
        sprintf (temp_text,"Fichero %s cargado", filename [i]);
        statusbar_text(temp_text);	
       
    }
    */
}

void cargar (gchar *text)
{
    gint i;
    //    gchar *text;
    gchar temp_text [300];

    if (text==NULL) return;
    
    i = create_page ();
    if (i >= 0)
    {
        get_name (text, filename [i]);
            //      strcpy(filename[i],);
        
        if (gtk_cedit_open_file (GTK_CEDIT (gtkcedit [i]), text)<0)
	  {
	    msg_box("No se ha podido abrir el fichero.\n verifique que exista y que tiene permisos de lectura",GTK_MESSAGE_WARNING);
	    text=strcpy(text,"noname.c");
	    return;
	  }
        gtk_label_set_text (GTK_LABEL (label [i]), filename [i]);
        sprintf (temp_text,"Fichero %s cargado", filename [i]);
        statusbar_text(temp_text);	       
    }
}

void
file_open (GtkWidget *button,
    gpointer   data)
{
        /* Create the selector */
    
    file_selector = gtk_file_selection_new ("Abrir Fichero...");
    
    g_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)-> ok_button),
        "clicked",
        G_CALLBACK (store_filename),
        NULL);
    
        /* Ensure that the dialog box is destroyed when the user clicks a button. */
    
    g_signal_connect_swapped (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)-> ok_button),
        "clicked",
        G_CALLBACK (gtk_widget_destroy),
        (gpointer) file_selector);
    
    g_signal_connect_swapped (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)-> cancel_button),
        "clicked",
        G_CALLBACK (gtk_widget_destroy),
        (gpointer) file_selector);
    
        /* Display that dialog */
    
    gtk_widget_show (file_selector);
}

void
file_close (GtkWidget *button,
    gpointer   data)
{
    int i, j;
    
    i = actual_page ();
    if (i >= 0)
    {
    gtk_widget_destroy (GTK_WIDGET (gtkcedit [i]));
        gtk_notebook_remove_page (GTK_NOTEBOOK (notebook),
            virtual_page [i]);
        
        for (j = 0; j < max_pages; j ++)
        {
            if (virtual_page [j]> virtual_page [i])
                virtual_page [j]--;
        }
        
        filled [i]= 0;
        virtual_page [i]=- 1;
    }
}

void
file_save (GtkWidget *button,
    gpointer   data)
{
    gint i;
    gchar temp_text [300];
    
    i = actual_page ();
    if (strcmp (filename [i],"noname.c")== 0)
        file_save_as (button, data);
    else
        gtk_cedit_save_file (GTK_CEDIT (gtkcedit [i]));
    sprintf (temp_text,"Fichero %s grabado", filename [i]);
    statusbar_text(temp_text);

}

void save_filename (GtkFileSelection *selector, gpointer user_data)
{
    gint i;
    gchar *text;
    
    i = actual_page ();
    text = strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_selector)));
        //  for (c=0;c<strlen(text);c++)
        //    filename[i][c]=text[c];
        //filename[i][c+1]='\0';
    get_name (text, filename [i]);
        //  strcpy(filename[i],gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_selector)));
    gtk_cedit_save_as_file (GTK_CEDIT (gtkcedit [i]), strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_selector))));
    gtk_label_set_text (GTK_LABEL (label [i]), filename [i]);
}

void
file_save_as (GtkWidget *button,
    gpointer   data)
{
        /* Create the selector */
    
    file_selector = gtk_file_selection_new ("Guardar fichero como...");
    
    g_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)-> ok_button),
        "clicked",
        G_CALLBACK (save_filename),
        NULL);
    
        /* Ensure that the dialog box is destroyed when the user clicks a button. */
    
    g_signal_connect_swapped (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)-> ok_button),
        "clicked",
        G_CALLBACK (gtk_widget_destroy),
        (gpointer) file_selector);
    
    g_signal_connect_swapped (GTK_OBJECT (GTK_FILE_SELECTION (file_selector)-> cancel_button),
        "clicked",
        G_CALLBACK (gtk_widget_destroy),
        (gpointer) file_selector);
    
        /* Display that dialog */
    
    gtk_widget_show (file_selector);
}

void
file_preferences (GtkWidget *button,
    gpointer   data)
{
  create_preferences(AceptarPreferencias, AplicarPreferencias, CancelarPreferencias);
}

void
file_exit (GtkWidget *button,
    gpointer   data)
{
  CerrarAplicacion(button, data);
  //    gtk_main_quit ();
}

void
edit_undo (GtkWidget *button,
    gpointer   data)
{
    
    gtk_cedit_undo (GTK_CEDIT (gtkcedit [actual_page ()]));
}
void
edit_redo (GtkWidget *button,
    gpointer   data)
{
    
    gtk_cedit_redo (GTK_CEDIT (gtkcedit [actual_page ()]));
}
void
edit_test (GtkWidget *button,
    gpointer   data)
{
    
//    gtk_cedit_test (GTK_CEDIT (gtkcedit [actual_page ()]));
}
void
edit_cut (GtkWidget *button,
    gpointer   data)
{
    
    gtk_cedit_cut (GTK_CEDIT (gtkcedit [actual_page ()]));
}
void
edit_copy (GtkWidget *button,
    gpointer   data)
{
    
    gtk_cedit_copy (GTK_CEDIT (gtkcedit [actual_page ()]));
}
void
edit_paste (GtkWidget *button,
    gpointer   data)
{
    
    gtk_cedit_paste (GTK_CEDIT (gtkcedit [actual_page ()]));
}
void
edit_find (GtkWidget *button,
    gpointer   data)
{
    FindStringDialog ("Buscar", FindNext, CancelFind);
    
        //gtk_cedit_paste (gtkcedit[actual_page()]);
}

void
edit_find_next (GtkWidget *button,
    gpointer   data)
{
    int i;
    
    i = actual_page ();
    if (i >= 0 && filled [i]== 1)
        if (gtk_cedit_find (GTK_CEDIT(gtkcedit [i]), lastfind)== 0)
            msg_box ("No se ha encontrado el texto",GTK_MESSAGE_INFO);
} 

void
edit_go_to_def (GtkWidget *button,
		gpointer   data)
{
  gulong line;
  gchar *filename;

  filename=gtk_cedit_go_to_definition (GTK_CEDIT (gtkcedit [actual_page ()]), &line);
  if (filename==NULL && line>=0) // si esta en este fichero y en una linea valida
      gtk_cedit_move_cursor(GTK_CEDIT (gtkcedit [actual_page ()]), 0, line);
  else if (filename!=NULL && line>=0) // si no es este fichero y la linea es vÎlida
    {
      g_print("Cargando: %s linea: %ld", filename, line);
      cargar(filename);
      gtk_cedit_move_cursor(GTK_CEDIT (gtkcedit [actual_page ()]), 0, line);
    }
  else
    msg_box ("No se conoce la definicion",GTK_MESSAGE_INFO);
}

void
edit_go_to_def_popup (result_definition_db *res_def_db)//gpointer   data)
{
  gulong line;
  gchar *filename;
  //  result_definition_db *res_def_db;

  //  res_def_db=(result_definition_db*)data;
  g_print("aaaaa%ld", res_def_db->def_db->n_line);


  filename=gtk_cedit_result_go_to_definition(GTK_CEDIT (gtkcedit [actual_page ()]), &line,res_def_db);
  if (filename==NULL && line>=0) // si esta en este fichero y en una linea valida
      gtk_cedit_move_cursor(GTK_CEDIT (gtkcedit [actual_page ()]), 0, line);
  else if (filename!=NULL && line>=0) // si no es este fichero y la linea es vÎlida
    {
      g_print("Cargando: %s linea: %ld", filename, line);
      cargar(filename);
      gtk_cedit_move_cursor(GTK_CEDIT (gtkcedit [actual_page ()]), 0, line);
    }
  else
    msg_box ("No se conoce la definicion",GTK_MESSAGE_INFO);
}

void
have_undo (GtkWidget *widget,
    gpointer   data)
{
    gtk_widget_set_sensitive (button_undo, TRUE);
}
void
no_have_undo (GtkWidget *widget,
    gpointer   data)
{
    gtk_widget_set_state (button_undo, GTK_STATE_INSENSITIVE);
}
void
have_redo (GtkWidget *widget,
    gpointer   data)
{
    gtk_widget_set_sensitive (button_redo, TRUE);
}
void
no_have_redo (GtkWidget *widget,
    gpointer   data)
{
    gtk_widget_set_state (button_redo, GTK_STATE_INSENSITIVE);
}
void
notebook_select_page (GtkWidget *widget,
    GtkNotebookPage *page,
    gint page_num,
    gpointer data)
{
    int i;
    
    if (closing == true) return;
    i = actual_page2 (page_num);
    if (i >= 0 && filled [i]== 1)
    {
        if (gtk_cedit_have_undo (GTK_CEDIT (gtkcedit [i]))== 0)
            no_have_undo (gtkcedit [i], NULL);
        else
            have_undo (gtkcedit [i], NULL);
        
        if (gtk_cedit_have_redo (GTK_CEDIT (gtkcedit [i]))== 0)
            no_have_redo (gtkcedit [i], NULL);
        else
            have_redo (gtkcedit [i], NULL);
        gtk_widget_grab_focus (GTK_WIDGET (gtkcedit [i]));
    }
}

void FindNext (GtkWidget *widget, gpointer data)
{
    int i;
    
    strcpy (lastfind, gtk_editable_get_chars (GTK_EDITABLE (entry), 0, - 1));
    i = actual_page ();
    if (i >= 0 && filled [i]== 1)
        if (gtk_cedit_find (GTK_CEDIT(gtkcedit [i]), lastfind)== 0)
            msg_box ("No se ha encontrado",GTK_MESSAGE_INFO);
    
    gtk_widget_destroy (GTK_WIDGET (data));
    dialog_window = NULL;
}


void AceptarPreferencias (GtkWidget *widget, gpointer data)
{
    AplicarPreferencias (widget, data);
    CancelarPreferencias (widget, data);   
}
void AplicarPreferencias (GtkWidget *widget, gpointer data)
{
  gint a;

  lastColor=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(coloreado));
  lastIdentation=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(identacion));
  lastScroll=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(scroll));
  lastFormat=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(formateado));
  lastContinuousCorrection=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(correccioncontinua));
  lastCorrection=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(correccion));   
   
   for (a=0;a<max_pages;a++)
     {
       if (filled[a]!=0)
	 {
	   usar_preferencias(a);
	 }
     }
}

void usar_preferencias(int a)
{
  gint index;
  if (filled[a]!=0)
    {
      gtk_cedit_set_continuous_color (GTK_CEDIT(gtkcedit[a]), lastColor);
      gtk_cedit_set_continuous_autoidentation (GTK_CEDIT(gtkcedit[a]), lastIdentation);
      gtk_cedit_set_fast_scroll (GTK_CEDIT(gtkcedit[a]), lastScroll);
      gtk_cedit_set_text_format (GTK_CEDIT(gtkcedit[a]), lastFormat);
      gtk_cedit_set_continuous_correction (GTK_CEDIT(gtkcedit[a]), lastContinuousCorrection);
      gtk_cedit_set_correction (GTK_CEDIT(gtkcedit[a]), lastCorrection);
      
      // paths
      
      index=0;
      gtk_cedit_remove_include_path(GTK_CEDIT(gtkcedit[a]));
      while (index<ArrayPath->len)
	{
	  gtk_cedit_insert_include_path(GTK_CEDIT(gtkcedit[a]),g_array_index (ArrayPath, Item, index).Direccion);
	  index++;
	}
      
    }
}

void CancelarPreferencias (GtkWidget *widget, gpointer data)
{
    gtk_widget_destroy (GTK_WIDGET (Preferencias));
    Preferencias = NULL;
}

gint statusbar_interrupt (gpointer data)
{
	gtk_statusbar_pop(GTK_STATUSBAR(statusbar1), 
		gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbar1), "nada"));
	return 1;
}

/*
void
InsertarPath (GtkWidget *widget,
	      gpointer   data)
{
  //  gtk_list_append_items(
}
*/

void
cell_edited (GtkCellRendererText *cell,
	     const gchar         *path_string,
	     const gchar         *new_text,
	     gpointer             data)
{
   GtkTreeModel *model = (GtkTreeModel *)data;
  GtkTreePath *treepath = gtk_tree_path_new_from_string (path_string);
  GtkTreeIter iter;

  gint *column;
  
  column = g_object_get_data (G_OBJECT (cell), "column");

  gtk_tree_model_get_iter (model, &iter, treepath);
  switch (GPOINTER_TO_INT (column))
    {
    case COLUMN_DESCRIPTION:
      {
	gint i;
	gchar *old_text;

        gtk_tree_model_get (model, &iter, column, &old_text, -1);
	g_free (old_text);

	i = gtk_tree_path_get_indices (treepath)[0];
	g_free (g_array_index (ArrayPath, Item, i).Direccion);
	g_array_index (ArrayPath, Item, i).Direccion = g_strdup (new_text);

	gtk_list_store_set (GTK_LIST_STORE (model), &iter, column,
                            g_array_index (ArrayPath, Item, i).Direccion, -1);
      }
      break;
    }

  gtk_tree_path_free (treepath);
  
}

void
add_item (GtkWidget *button, gpointer data)
{
  Item foo;
  GtkTreeIter iter;
  GtkTreeModel *model = (GtkTreeModel *)data;

  g_return_if_fail (ArrayPath != NULL);

  foo.Direccion = g_strdup ("Escribe la direccin aqui");
  foo.editable=TRUE;
  g_array_append_vals (ArrayPath, &foo, 1);

  gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter,
		      COLUMN_PATH_DESCRIPTION, foo.Direccion,
		      COLUMN_PATH_EDITABLE, foo.editable,
		      -1);
}

void
remove_item (GtkWidget *widget, gpointer data)
{
  GtkTreeIter iter;
  GtkTreeView *treeview = (GtkTreeView *)data;
  GtkTreeModel *model = gtk_tree_view_get_model (treeview);
  GtkTreeSelection *selection = gtk_tree_view_get_selection (treeview);

  if (gtk_tree_selection_get_selected (selection, NULL, &iter))
    {
      gint i;
      GtkTreePath *treepath;

      treepath = gtk_tree_model_get_path (model, &iter);
      i = gtk_tree_path_get_indices (treepath)[0];
      gtk_list_store_remove (GTK_LIST_STORE (model), &iter);

      g_array_remove_index (ArrayPath, i);

      gtk_tree_path_free (treepath);
    }
}

void
CambiaColor (GtkWidget *button,
		       gpointer	  data)
{
  GtkWidget *dialog;
  GtkColorSelection *colorsel;
  GdkColor *color;
  gint count;
  gint response;

  GtkTreeIter iter;
  GtkTreeView *treeview = (GtkTreeView *)data;
  GtkTreeModel *model = gtk_tree_view_get_model (treeview);
  GtkTreeSelection *selection = gtk_tree_view_get_selection (treeview);

  if (gtk_tree_selection_get_selected (selection, NULL, &iter))
    {
      gint i;
      GtkTreePath *treepath;

      treepath = gtk_tree_model_get_path (model, &iter);
      i = gtk_tree_path_get_indices (treepath)[0];

      dialog = gtk_color_selection_dialog_new ("Nuevo color");
      
      gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (window));
      
      colorsel = GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (dialog)->colorsel);
     
      
      color=gtk_cedit_get_color(GTK_CEDIT (gtkcedit [actual_page()]),i);

      //      caca.red=0;
      //      caca.blue=0;
      //      caca.green=0;
      //      color=&caca;
      
      gtk_color_selection_set_previous_color (colorsel, color);
      gtk_color_selection_set_current_color (colorsel, color);
      gtk_color_selection_set_has_palette (colorsel, TRUE);
      
      response = gtk_dialog_run (GTK_DIALOG (dialog));
      
      if (response == GTK_RESPONSE_OK)
	{
	  gtk_color_selection_get_current_color (colorsel,
						 color);
	  
	  // cambio el color
	  for (count=0;count<max_pages;count++)
	    {
	      if (filled[count]!=0)
		gtk_cedit_set_color(GTK_CEDIT (gtkcedit [count]),i,color);
	    }
	  //      gtk_widget_modify_bg (da, GTK_STATE_NORMAL, &color);
	}
  
      gtk_widget_destroy (dialog);
    }
}
