/*
  db.c
  
  Jonathan B. Leffert <jonathan@leffert.net>
  24 April 2000
  
  $Id: db.c,v 1.18 2000/04/27 14:52:27 jonathan Exp $
  
  Copyright (c) 2000 Jonathan B. Leffert <jonathan@leffert.net>
  All rights reserved.
*/

#include "db.h"

/*
  function defs
*/

/*
  a generic function for opening a GDBM database with the "usual
  options" but allowing the user to pick the open flags.
*/
GDBM_FILE open_gdbm_database(char *name, int flag)
{
  GDBM_FILE db = NULL;

  db = gdbm_open(name,
		 0,
		 flag,
		 DEFAULT_MODE,
		 NULL);
  return db;
}

/* open GDBM db read-only */
GDBM_FILE open_gdbm_database_ro(char *name)
{
  return open_gdbm_database(name, GDBM_READER);
}

/* open GDBM db read-write */
GDBM_FILE open_gdbm_database_rw(char *name)
{
  return open_gdbm_database(name, GDBM_WRITER);
}
