from Observable import Observable

import time
import gtk



class TimeWatcher(Observable):

    OBS_NEWDAY = 0
    OBS_SAVE_CONFIG = 1



    def __init__(self):

        # (day, month, year)
        self.__today = (1, 1, 1)

        gtk.idle_add(self.__watchtime)
        gtk.timeout_add(3000, self.__save_config)



    #
    # Reports when a new day starts.
    #
    def __watchtime(self):

        now = time.localtime(time.time())
        year, month, day = now[:3]

        if ((day, month, year) != self.__today):
            self.__today = (day, month, year)
            self.update_observer(self.OBS_NEWDAY, day, month, year)

        gtk.timeout_add(1000, self.__watchtime)



    #
    # Reports when the configuration should be saved.
    #
    def __save_config(self):

        self.update_observer(self.OBS_SAVE_CONFIG)
        return gtk.TRUE
