/*****************************************************************************
 *  FTools - Freenet Client Protocol Tools
 *
 *  Copyright (C) 2002 Juergen Buchmueller <juergen@pullmoll.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *	$Id: ftlog.h,v 1.6 2003/11/07 19:21:06 pullmoll Exp $
 *****************************************************************************/
#ifndef	_ftlog_h
#define	_ftlog_h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#define	L_NONE		0
#define	L_ERROR		1
#define	L_NORMAL	2
#define	L_MINOR		3
#define	L_DEBUG		4
#define	L_DEBUGX	5

#if		_DEBUG
#ifdef	__cplusplus
extern "C" {
#endif
extern FILE *logfile;
void logprint(const char *fmt, ...);
extern int verbose;
#ifdef	__cplusplus
}
#endif
#define	LOG(l,msg) if (verbose >= (l)) { \
	logfile = ((l) >= L_MINOR) ? stderr : stdout; \
	logprint msg; \
}

#else	/* !_DEBUG */
#define	LOG(l,msg)
#endif

#endif	/* _ftlog_h */
