/*****************************************************************************
 *  FTools - Freenet Client Protocol Tools
 *
 *  Copyright (C) 2002 Juergen Buchmueller <juergen@pullmoll.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *	$Id: ftlog.c,v 1.5 2003/11/07 19:21:06 pullmoll Exp $
 *****************************************************************************/
#include "ftlog.h"

FILE *logfile = NULL;

void logprint(const char *fmt, ...)
{
	va_list ap;
	char *buff;
	size_t max = 1024, len;

	for (;;) {
		buff = calloc(max, sizeof(char));
		if (NULL == buff) {
			return;
		}
		va_start(ap, fmt);
		len = vsnprintf(buff, max, fmt, ap);
		va_end(ap);
		if (len < max - 8)
			break;
		free(buff);
		max *= 2;
	}

	if (NULL != logfile)
		fprintf(logfile, "%s", buff);

	free(buff);
}
