#!/bin/sh
# Run this to generate initial makefiles, etc

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

THEDIR="`pwd`"
cd "$srcdir"
DIE=0

(autoconf --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have autoconf installed to create the configure script"
	echo "for freezetag.  Download the appropriate package for your distro"
	echo "or get the source tarball @ ftp://ftp.gnu.org/pub/gnu/"
	DIE=1
}

(automake --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have automake installed to create the configure script"
	echo "for freezetag.  Download the appropriate package for your distro"
	echo "or get the source tarball @ ftp://ftp.gnu.org/pub/gnu/"
	DIE=1
}

if test "$DIE" -eq 1; then
	exit 1
fi

(test -d src) || {
	echo "You must run this script in the top-level freezetag directory"
	exit 1
}

if test -z "$*"; then 
	echo "I am going to run ./configure with no arguments - if you wish"
	echo "to pass any to it, please specify them on the $0 command line."
fi

echo
echo processing...


aclocal $ACLOCAL_FLAGS
automake --add-missing
autoconf

./configure $@

echo "Now type 'make' to compile freezetag"
