(**************************************************************************)
(*                                                                        *)
(*  Copyright (C) 2001-2003                                               *)
(*   George C. Necula    <necula@cs.berkeley.edu>                         *)
(*   Scott McPeak        <smcpeak@cs.berkeley.edu>                        *)
(*   Wes Weimer          <weimer@cs.berkeley.edu>                         *)
(*   Ben Liblit          <liblit@cs.berkeley.edu>                         *)
(*  All rights reserved.                                                  *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*                                                                        *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*                                                                        *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*                                                                        *)
(*  3. The names of the contributors may not be used to endorse or        *)
(*  promote products derived from this software without specific prior    *)
(*  written permission.                                                   *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   *)
(*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     *)
(*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS     *)
(*  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE        *)
(*  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,   *)
(*  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,  *)
(*  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      *)
(*  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER      *)
(*  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT    *)
(*  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN     *)
(*  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE       *)
(*  POSSIBILITY OF SUCH DAMAGE.                                           *)
(*                                                                        *)
(*  File modified by CEA (Commissariat  l'nergie atomique et aux        *)
(*                        nergies alternatives).                         *)
(**************************************************************************)


(** Compute dominators using data flow analysis *)
(** Author: George Necula
      5/28/2004
 **)

(** complete rewrite in order not to rely on data flow analysis 
    (bad time-complexity).
    now based on "A Simple, Fast Dominance Algorithm" by K. D. Cooper et al
*)

(** Invoke on a code after filling in the CFG info and it computes the
 * immediate dominator information. We map each statement to its immediate
 * dominator (None for the start statement, and for the unreachable
 * statements). *)
val computeIDom: Cil_types.fundec -> Cil_types.stmt option Datatype.Int.Hashtbl.t


(** This is like Datatype.Int.Hashtbl.find but gives an error if the information is
 * Not_found *)
val getIdom:  Cil_types.stmt option Datatype.Int.Hashtbl.t -> Cil_types.stmt -> Cil_types.stmt option

(** Check whether one statement dominates another. *)
val dominates: Cil_types.stmt option Datatype.Int.Hashtbl.t -> Cil_types.stmt -> Cil_types.stmt -> bool


(** Compute the start of the natural loops. This assumes that the "idom"
 * field has been computed. For each start, keep a list of origin of a back
 * edge. The loop consists of the loop start and all predecessors of the
 * origins of back edges, up to and including the loop start *)
val findNaturalLoops: Cil_types.fundec ->
                      Cil_types.stmt option Datatype.Int.Hashtbl.t ->
                      (Cil_types.stmt * Cil_types.stmt list) list
