#!/bin/sh
#
# A small script to update the fisg stats for multiple channels.
#
# Created 2004-04-26 by Johan Fredin <griffin@legonet.org>
#
# Copyright (c) 2004 Johan Fredin <griffin@legonet.org>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#

#
# This script assumes two things: 
#
# - Keep your config files all in the same directory, named <channel>.cfg. 
#   In that same directory the user files should be located, 
#   named <chan>-users.cfg.
#
# - The logfiles should be in subdirectories of one common directory, i.e. 
#   ~/bot/logs/channel1 and ~/bot/logs/channel2.
#

# Path to the fisg binary, if not in path
FISG=fisg

# This is the directory where all you <chan>.cfg files are
CFG_DIR="${HOME}/fisg"

# Filename of your default config
# The settings in this file will be overriden by
# the channel specific file.
DEFAULT_CFG="default.cfg"

# Where are your logs?
LOG_DIR="${HOME}/bots/logs/"

# We want our HTML-pages to be generated in this dir
HTML_DIR='/var/www/htdocs/fisg/'

# How many days back worth of logs should we analyze?
DAYS_BACK=30


for cfg in ${CFG_DIR}/*.cfg; do
	# We want nothing to do with the users files
	if [ ! "${cfg}" = "${cfg%-users.cfg}" \
		-o ! "${cfg}" = "${cfg%${DEFAULT_CFG}}" ]; then
		continue
	fi
	
	# Clean up
	chan=${cfg#${CFG_DIR}/}
	chan=${chan%.cfg}

	# If you want to analyze all your logs, use this
	#logs="${LOG_DIR}${chan}/*"

	# This suites my needs
	logs=`find ${LOG_DIR}${chan} -type f -ctime -${DAYS_BACK}`

	${FISG} -c ${CFG_DIR}/${DEFAULT_CFG} -c ${cfg} -u ${CFG_DIR}/${chan}-users.cfg \
	-f eggdrop ${logs} -o ${HTML_DIR}/${chan}.html
done

