/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.85 95/04/24 10:48:47 vern Exp $
 */

#define FLEX_SCANNER
#define BF_FLEX_MAJOR_VERSION 2
#define BF_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define BF_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define BF_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define BF_USE_PROTOS
#define BF_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define BF_USE_CONST
#define BF_USE_PROTOS
#endif

#ifdef BF_USE_CONST
#define bfconst const
#else
#define bfconst
#endif


#ifdef BF_USE_PROTOS
#define BF_PROTO(proto) proto
#else
#define BF_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define BF_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define BF_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN bf_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The BFSTATE alias is for lex
 * compatibility.
 */
#define BF_START ((bf_start - 1) / 2)
#define BFSTATE BF_START

/* Action number for EOF rule of a given start state. */
#define BF_STATE_EOF(state) (BF_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define BF_NEW_FILE bfrestart( bfin )

#define BF_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define BF_BUF_SIZE 16384

typedef struct bf_buffer_state *BF_BUFFER_STATE;

extern int bfleng;
extern FILE *bfin, *bfout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		bfless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the bfless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define bfless(n) \
	do \
		{ \
		/* Undo effects of setting up bftext. */ \
		*bf_cp = bf_hold_char; \
		bf_c_buf_p = bf_cp = bf_bp + n - BF_MORE_ADJ; \
		BF_DO_BEFORE_ACTION; /* set up bftext again */ \
		} \
	while ( 0 )

#define unput(c) bfunput( c, bftext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int bf_size_t;


struct bf_buffer_state
	{
	FILE *bf_input_file;

	char *bf_ch_buf;		/* input buffer */
	char *bf_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	bf_size_t bf_buf_size;

	/* Number of characters read into bf_ch_buf, not including EOB
	 * characters.
	 */
	int bf_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int bf_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int bf_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int bf_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int bf_fill_buffer;

	int bf_buffer_status;
#define BF_BUFFER_NEW 0
#define BF_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as BF_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via bfrestart()), so that the user can continue scanning by
	 * just pointing bfin at a new input file.
	 */
#define BF_BUFFER_EOF_PENDING 2
	};

static BF_BUFFER_STATE bf_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define BF_CURRENT_BUFFER bf_current_buffer


/* bf_hold_char holds the character lost when bftext is formed. */
static char bf_hold_char;

static int bf_n_chars;		/* number of characters read into bf_ch_buf */


int bfleng;

/* Points to current character in buffer. */
static char *bf_c_buf_p = (char *) 0;
static int bf_init = 1;		/* whether we need to initialize */
static int bf_start = 0;	/* start state number */

/* Flag which is used to allow bfwrap()'s to do buffer switches
 * instead of setting up a fresh bfin.  A bit of a hack ...
 */
static int bf_did_buffer_switch_on_eof;

void bfrestart BF_PROTO(( FILE *input_file ));

void bf_switch_to_buffer BF_PROTO(( BF_BUFFER_STATE new_buffer ));
void bf_load_buffer_state BF_PROTO(( void ));
BF_BUFFER_STATE bf_create_buffer BF_PROTO(( FILE *file, int size ));
void bf_delete_buffer BF_PROTO(( BF_BUFFER_STATE b ));
void bf_init_buffer BF_PROTO(( BF_BUFFER_STATE b, FILE *file ));
void bf_flush_buffer BF_PROTO(( BF_BUFFER_STATE b ));
#define BF_FLUSH_BUFFER bf_flush_buffer( bf_current_buffer )

BF_BUFFER_STATE bf_scan_buffer BF_PROTO(( char *base, bf_size_t size ));
BF_BUFFER_STATE bf_scan_string BF_PROTO(( bfconst char *str ));
BF_BUFFER_STATE bf_scan_bytes BF_PROTO(( bfconst char *bytes, int len ));

static void *bf_flex_alloc BF_PROTO(( bf_size_t ));
static void *bf_flex_realloc BF_PROTO(( void *, bf_size_t ));
static void bf_flex_free BF_PROTO(( void * ));

#define bf_new_buffer bf_create_buffer

#define bf_set_interactive(is_interactive) \
	{ \
	if ( ! bf_current_buffer ) \
		bf_current_buffer = bf_create_buffer( bfin, BF_BUF_SIZE ); \
	bf_current_buffer->bf_is_interactive = is_interactive; \
	}

#define bf_set_bol(at_bol) \
	{ \
	if ( ! bf_current_buffer ) \
		bf_current_buffer = bf_create_buffer( bfin, BF_BUF_SIZE ); \
	bf_current_buffer->bf_at_bol = at_bol; \
	}

#define BF_AT_BOL() (bf_current_buffer->bf_at_bol)

typedef unsigned char BF_CHAR;
FILE *bfin = (FILE *) 0, *bfout = (FILE *) 0;
typedef int bf_state_type;
extern char *bftext;
#define bftext_ptr bftext

static bf_state_type bf_get_previous_state BF_PROTO(( void ));
static bf_state_type bf_try_NUL_trans BF_PROTO(( bf_state_type current_state ));
static int bf_get_next_buffer BF_PROTO(( void ));
static void bf_fatal_error BF_PROTO(( bfconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up bftext.
 */
#define BF_DO_BEFORE_ACTION \
	bftext_ptr = bf_bp; \
	bfleng = (int) (bf_cp - bf_bp); \
	bf_hold_char = *bf_cp; \
	*bf_cp = '\0'; \
	bf_c_buf_p = bf_cp;

#define BF_NUM_RULES 58
#define BF_END_OF_BUFFER 59
static bfconst short int bf_accept[152] =
    {   0,
        0,    0,    0,    0,   49,   49,   59,   57,   57,   55,
       33,   57,   57,   29,   57,   32,   35,   36,   27,   25,
       39,   26,   34,   28,   44,   24,   40,   20,   15,   21,
       43,   37,   30,   38,   31,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   57,
       58,   49,   50,   51,   57,   19,    0,   42,    0,    0,
       56,   17,   41,   31,   47,   48,   46,   44,    0,   15,
       22,   18,   23,   43,   43,   54,   43,   43,   43,    2,
       43,   43,   43,   43,   43,    8,    9,   43,   43,   43,
       16,   43,   43,   43,   43,   16,   49,   50,   51,   52,

       51,   53,    0,   46,    0,    0,   45,   17,   43,   28,
       43,    4,    5,   43,   43,   29,   43,   33,   43,   43,
       43,   43,    0,   47,    0,    0,   46,   43,    3,   43,
       43,   10,   43,   43,   13,   43,    0,   46,    1,   43,
       43,   43,   43,   14,   43,    7,   11,   12,   43,    6,
        0
    } ;

static bfconst int bf_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    7,    8,    9,   10,
       11,   12,   13,   14,   15,   16,   17,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   19,   20,   21,
       22,   23,   24,    1,   25,   25,   25,   25,   26,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       27,   28,   29,   30,   25,    1,   31,   32,   33,   34,

       35,   36,   37,   38,   39,   25,   40,   41,   42,   43,
       44,   25,   25,   45,   46,   47,   48,   49,   50,   51,
       25,   25,    1,   52,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static bfconst int bf_meta[53] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    2,    1,    1,
        1,    3,    1,    1,    1,    1,    1,    4,    1,    1,
        1,    1,    1,    4,    5,    5,    1,    1,    1,    1,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    1
    } ;

static bfconst short int bf_base[160] =
    {   0,
        0,    0,    0,    0,   50,   51,  285,  286,  282,  286,
      261,   50,  279,  286,  273,  286,  286,  286,  268,  286,
      286,  286,  261,  266,   40,  255,  286,   37,  254,  253,
      250,  286,  270,  286,  286,   33,   37,   40,   44,   45,
       47,   56,   46,   59,   41,   67,   43,   71,   72,  220,
      286,  268,  286,   94,  268,  286,   72,  286,    0,  266,
      286,  286,  260,  286,   86,  286,   87,   98,  102,  286,
      286,  286,  286,  243,  286,  286,   74,   83,   77,  242,
       95,  101,   99,  103,  104,  241,  240,  105,  106,  107,
      239,  108,  112,  110,  113,  286,  259,  286,  139,  286,

      146,  286,  146,  142,  152,  243,  242,  235,  116,  234,
      138,  233,  225,  142,  147,  219,  129,  218,  126,  145,
      148,  154,  201,  200,  167,  199,  197,  157,  190,  159,
      162,  188,  160,  163,  187,  164,  190,  189,  179,  165,
      168,  170,  176,  178,  172,  114,   50,   49,  177,   48,
      286,  220,  225,  230,  235,  239,  241,  246,  251
    } ;

static bfconst short int bf_def[160] =
    {   0,
      151,    1,  152,  152,  153,  153,  151,  151,  151,  151,
      151,  154,  155,  151,  156,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      157,  151,  151,  151,  151,  157,  157,  157,  157,  157,
      157,  157,  157,  157,  157,  157,  157,  157,  157,  151,
      151,  158,  151,  159,  151,  151,  154,  151,  154,  155,
      151,  151,  156,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  157,  151,  151,  157,  157,  157,  157,
      157,  157,  157,  157,  157,  157,  157,  157,  157,  157,
      157,  157,  157,  157,  157,  151,  158,  151,  159,  151,

      159,  151,  151,  151,  151,  151,  151,  157,  157,  157,
      157,  157,  157,  157,  157,  157,  157,  157,  157,  157,
      157,  157,  151,  151,  151,  151,  151,  157,  157,  157,
      157,  157,  157,  157,  157,  157,  151,  151,  157,  157,
      157,  157,  157,  157,  157,  157,  157,  157,  157,  157,
        0,  151,  151,  151,  151,  151,  151,  151,  151
    } ;

static bfconst short int bf_nxt[339] =
    {   0,
        8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
       18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
       28,   29,   30,    8,   31,   31,   32,   33,   34,   35,
       36,   37,   31,   38,   39,   40,   41,   31,   42,   31,
       31,   43,   44,   45,   46,   47,   48,   31,   31,   49,
       31,   50,   53,   53,   58,   67,   75,   68,   71,   56,
       75,   54,   54,   75,   75,   69,   75,   75,   75,   75,
       75,   75,   75,   75,   69,   77,   58,   59,   79,   75,
       93,   78,   75,   80,   81,   91,   82,   85,   83,   88,
       75,   86,   84,   89,   75,   75,  100,   75,   87,   59,

       75,   92,   90,   65,  104,  101,   75,  108,   94,   95,
      102,  103,  105,   67,  106,   68,  106,  109,   75,  107,
      103,  105,   75,   69,   75,  110,   75,   75,   75,   75,
       75,   75,   69,   75,  112,   75,   75,   75,  116,   75,
      111,  100,  120,  113,  121,  114,  128,  115,  100,   75,
      151,  122,   75,  118,  119,  151,  117,  101,  123,  104,
      123,   75,  102,  124,  126,   75,  126,  125,   75,  127,
       75,   75,  129,  133,  130,  132,  125,   75,  131,  137,
       75,  137,   75,   75,  138,   75,   75,   75,   75,  134,
      135,   75,  141,   75,  136,   75,  139,  143,  144,   75,

       75,   75,   75,  145,  142,  140,  138,  138,  146,  148,
       75,   75,  147,   75,  127,  149,  127,  124,  124,  150,
       51,   51,   51,   51,   51,   52,   52,   52,   52,   52,
       57,   57,   57,   57,   57,   60,   60,   60,   60,   60,
       63,   75,   75,   63,   74,   74,   97,   97,   75,   97,
       97,   99,   99,   99,   99,   99,   75,   75,   75,  107,
      107,   98,   75,   75,   75,   75,   75,  151,   61,   55,
       98,   96,   76,   75,   73,   72,   70,   66,   65,   64,
       62,   61,   56,   55,  151,    7,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,

      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151
    } ;

static bfconst short int bf_chk[339] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    5,    6,   12,   25,   36,   25,   28,   28,
       37,    5,    6,   38,   45,   25,   47,   39,   40,   43,
       41,  150,  148,  147,   25,   36,   57,   12,   38,   42,
       47,   37,   44,   38,   39,   45,   39,   41,   40,   43,
       46,   42,   40,   44,   48,   49,   54,   77,   42,   57,

       79,   46,   44,   65,   67,   54,   78,   77,   48,   49,
       54,   65,   67,   68,   69,   68,   69,   78,   81,   69,
       65,   67,   83,   68,   82,   79,   84,   85,   88,   89,
       90,   92,   68,   94,   82,   93,   95,  146,   88,  109,
       81,   99,   93,   83,   94,   84,  109,   85,  101,  119,
       99,   95,  117,   90,   92,   99,   89,  101,  103,  104,
      103,  111,  101,  103,  105,  114,  105,  104,  120,  105,
      115,  121,  111,  119,  114,  117,  104,  122,  115,  125,
      128,  125,  130,  133,  125,  131,  134,  136,  140,  120,
      121,  141,  131,  142,  122,  145,  128,  134,  136,  143,

      149,  144,  139,  140,  133,  130,  138,  137,  141,  143,
      135,  132,  142,  129,  127,  145,  126,  124,  123,  149,
      152,  152,  152,  152,  152,  153,  153,  153,  153,  153,
      154,  154,  154,  154,  154,  155,  155,  155,  155,  155,
      156,  118,  116,  156,  157,  157,  158,  158,  113,  158,
      158,  159,  159,  159,  159,  159,  112,  110,  108,  107,
      106,   97,   91,   87,   86,   80,   74,   63,   60,   55,
       52,   50,   33,   31,   30,   29,   26,   24,   23,   19,
       15,   13,   11,    9,    7,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,

      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151
    } ;

static bf_state_type bf_last_accepting_state;
static char *bf_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define bfmore() bfmore_used_but_not_detected
#define BF_MORE_ADJ 0
char *bftext;
#line 1 "lexer.l"
#define INITIAL 0
#line 2 "lexer.l"
/*
    This file is part of the FElt finite element analysis package.
    Copyright (C) 1993-2000 Jason I. Gobat and Darren C. Atkinson

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/************************************************************************
 * File:	lexer.l							*
 *									*
 * Description:	This file contains the specification for the lexical	*
 *		analyzer for burlap - a mathematical notation /		*
 *		language for finite element analysis.  The lexer has	*
 *		several idiosyncracies.  First, all occurrences of "bf"	*
 *		are replaced by "bf" to avoid naming conflicts.  Next,	*
 *		an IF token is replaced by an ELIF token if the last	*
 *		token returned to the parser was an ELSE.  This allows	*
 *		a single END for a sequence of nested IF-THEN-ELSEs by	*
 *		resolving a conflict in the parser.  If the lexer is in	*
 *		interactive mode (reading from the keyboard) and a line	*
 *		ends with a token that may end an expression, then a	*
 *		semicolon will be returned on the next call to bflex().	*
 *		If the lexer is reading from a file and a line ends	*
 *		with a token that may end an expression and the next	*
 *		token may begin an expression, then the token that	*
 *		would have been returned is saved and a semicolon is	*
 *		returned (a semicolon is "inserted" into the input).	*
 *		The saved token is returned on the next call to		*
 *		bflex().  Finally, an EOF rule is used to return a	*
 *		semicolon to "terminate" a file.  Note that since a	*
 *		re-entrant parser is needed to support the nested	*
 *		processing of files, bflval is an argument to bflex(),	*
 *		rather than a global variable.				*
 ************************************************************************/

# include <stdio.h>
# include <string.h>
# include <unistd.h>
# include "error.h"
# include "lexer.h"
# include "parser.h"
# include "toktab.h"
# include "execute.h"
# include "globals.h"
# include "allocate.h"
# include "interactive.h"

# undef BF_INPUT
# define BF_INPUT(buf,result,max_size)\
    (result = interactive ? (buf [0] = readchar ( )) != 0 :\
				fread (buf, 1, max_size, bfin))

# define BF_DECL int bflex (bflval) BFSTYPE *bflval;


int   line_num;
int   file_num;
char *file_name;
int   interactive;

static int	depth;
static int	newline;
static int	last_token;
static int	saved_token;
static BFSTYPE	saved_value;
static BFSTYPE *value;

static int process	    PROTO ((int));
static int process_operator PROTO ((int));
static int process_literal  PROTO ((int));
static int process_newline  PROTO ((void));
static int process_eof	    PROTO ((void));
#define quit 1

#define comment 2

#line 575 "lex.bf.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef BF_SKIP_BFWRAP
#ifdef __cplusplus
extern "C" int bfwrap BF_PROTO(( void ));
#else
extern int bfwrap BF_PROTO(( void ));
#endif
#endif

#ifndef BF_NO_UNPUT
static void bfunput BF_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef bftext_ptr
static void bf_flex_strncpy BF_PROTO(( char *, bfconst char *, int ));
#endif

#ifndef BF_NO_INPUT
#ifdef __cplusplus
static int bfinput BF_PROTO(( void ));
#else
static int input BF_PROTO(( void ));
#endif
#endif

#if BF_STACK_USED
static int bf_start_stack_ptr = 0;
static int bf_start_stack_depth = 0;
static int *bf_start_stack = 0;
#ifndef BF_NO_PUSH_STATE
static void bf_push_state BF_PROTO(( int new_state ));
#endif
#ifndef BF_NO_POP_STATE
static void bf_pop_state BF_PROTO(( void ));
#endif
#ifndef BF_NO_TOP_STATE
static int bf_top_state BF_PROTO(( void ));
#endif

#else
#define BF_NO_PUSH_STATE 1
#define BF_NO_POP_STATE 1
#define BF_NO_TOP_STATE 1
#endif

#ifdef BF_MALLOC_DECL
BF_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef BF_READ_BUF_SIZE
#define BF_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( bftext, bfleng, 1, bfout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or BF_NULL,
 * is returned in "result".
 */
#ifndef BF_INPUT
#define BF_INPUT(buf,result,max_size) \
	if ( bf_current_buffer->bf_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( bfin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( bfin ) ) \
			BF_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, bfin )) == 0) \
		  && ferror( bfin ) ) \
		BF_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "bfterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef bfterminate
#define bfterminate() return BF_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef BF_START_STACK_INCR
#define BF_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef BF_FATAL_ERROR
#define BF_FATAL_ERROR(msg) bf_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef BF_DECL
#define BF_DECL int bflex BF_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after bftext and bfleng
 * have been set up.
 */
#ifndef BF_USER_ACTION
#define BF_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef BF_BREAK
#define BF_BREAK break;
#endif

#define BF_RULE_SETUP \
	BF_USER_ACTION

BF_DECL
	{
	register bf_state_type bf_current_state;
	register char *bf_cp, *bf_bp;
	register int bf_act;

#line 94 "lexer.l"


    /* If a saved token exists then return it to the parser.  This code
       will be placed at the top of bflex().   The private variable
       "value" is used to convey the value of bflval, which is now a
       parameter to bflex() to the called functions. */

    value = bflval;

    if (saved_token) {
	int token = saved_token;
	*bflval = saved_value;
	last_token = token;
	saved_token = 0;
	return token;
    }



#line 742 "lex.bf.c"

	if ( bf_init )
		{
		bf_init = 0;

#ifdef BF_USER_INIT
		BF_USER_INIT;
#endif

		if ( ! bf_start )
			bf_start = 1;	/* first start state */

		if ( ! bfin )
			bfin = stdin;

		if ( ! bfout )
			bfout = stdout;

		if ( ! bf_current_buffer )
			bf_current_buffer =
				bf_create_buffer( bfin, BF_BUF_SIZE );

		bf_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		bf_cp = bf_c_buf_p;

		/* Support of bftext. */
		*bf_cp = bf_hold_char;

		/* bf_bp points to the position in bf_ch_buf of the start of
		 * the current run.
		 */
		bf_bp = bf_cp;

		bf_current_state = bf_start;
bf_match:
		do
			{
			register BF_CHAR bf_c = bf_ec[BF_SC_TO_UI(*bf_cp)];
			if ( bf_accept[bf_current_state] )
				{
				bf_last_accepting_state = bf_current_state;
				bf_last_accepting_cpos = bf_cp;
				}
			while ( bf_chk[bf_base[bf_current_state] + bf_c] != bf_current_state )
				{
				bf_current_state = (int) bf_def[bf_current_state];
				if ( bf_current_state >= 152 )
					bf_c = bf_meta[(unsigned int) bf_c];
				}
			bf_current_state = bf_nxt[bf_base[bf_current_state] + (unsigned int) bf_c];
			++bf_cp;
			}
		while ( bf_base[bf_current_state] != 286 );

bf_find_action:
		bf_act = bf_accept[bf_current_state];
		if ( bf_act == 0 )
			{ /* have to back up */
			bf_cp = bf_last_accepting_cpos;
			bf_current_state = bf_last_accepting_state;
			bf_act = bf_accept[bf_current_state];
			}

		BF_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( bf_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of BF_DO_BEFORE_ACTION */
			*bf_cp = bf_hold_char;
			bf_cp = bf_last_accepting_cpos;
			bf_current_state = bf_last_accepting_state;
			goto bf_find_action;

case 1:
BF_RULE_SETUP
#line 113 "lexer.l"
{return process_operator (BREAK);}
	BF_BREAK
case 2:
BF_RULE_SETUP
#line 114 "lexer.l"
{return process_operator (DO);}
	BF_BREAK
case 3:
BF_RULE_SETUP
#line 115 "lexer.l"
{return process_operator (ELSE);}
	BF_BREAK
case 4:
BF_RULE_SETUP
#line 116 "lexer.l"
{return process_operator (END);}
	BF_BREAK
case 5:
BF_RULE_SETUP
#line 117 "lexer.l"
{return process_operator (FOR);}
	BF_BREAK
case 6:
BF_RULE_SETUP
#line 118 "lexer.l"
{return process_operator (FUNCTION);}
	BF_BREAK
case 7:
BF_RULE_SETUP
#line 119 "lexer.l"
{return process_operator (GLOBAL);}
	BF_BREAK
case 8:
BF_RULE_SETUP
#line 120 "lexer.l"
{return process_operator (IF);}
	BF_BREAK
case 9:
BF_RULE_SETUP
#line 121 "lexer.l"
{return process_operator (IN);}
	BF_BREAK
case 10:
BF_RULE_SETUP
#line 122 "lexer.l"
{return process_operator (NEXT);}
	BF_BREAK
case 11:
BF_RULE_SETUP
#line 123 "lexer.l"
{return process_operator (RETURN);}
	BF_BREAK
case 12:
BF_RULE_SETUP
#line 124 "lexer.l"
{return process_operator (SHARED);}
	BF_BREAK
case 13:
BF_RULE_SETUP
#line 125 "lexer.l"
{return process_operator (THEN);}
	BF_BREAK
case 14:
BF_RULE_SETUP
#line 126 "lexer.l"
{return process_operator (WHILE);}
	BF_BREAK
case 15:
BF_RULE_SETUP
#line 128 "lexer.l"
{return process_operator (ASSIGN);}
	BF_BREAK
case 16:
BF_RULE_SETUP
#line 129 "lexer.l"
{return process_operator (OR);}
	BF_BREAK
case 17:
BF_RULE_SETUP
#line 130 "lexer.l"
{return process_operator (AND);}
	BF_BREAK
case 18:
BF_RULE_SETUP
#line 131 "lexer.l"
{return process_operator (EQ);}
	BF_BREAK
case 19:
BF_RULE_SETUP
#line 132 "lexer.l"
{return process_operator (NE);}
	BF_BREAK
case 20:
BF_RULE_SETUP
#line 133 "lexer.l"
{return process_operator (LT);}
	BF_BREAK
case 21:
BF_RULE_SETUP
#line 134 "lexer.l"
{return process_operator (GT);}
	BF_BREAK
case 22:
BF_RULE_SETUP
#line 135 "lexer.l"
{return process_operator (LE);}
	BF_BREAK
case 23:
BF_RULE_SETUP
#line 136 "lexer.l"
{return process_operator (GE);}
	BF_BREAK
case 24:
BF_RULE_SETUP
#line 137 "lexer.l"
{return process_operator (COLON);}
	BF_BREAK
case 25:
BF_RULE_SETUP
#line 138 "lexer.l"
{return process_operator (PLUS);}
	BF_BREAK
case 26:
BF_RULE_SETUP
#line 139 "lexer.l"
{return process_operator (MINUS);}
	BF_BREAK
case 27:
BF_RULE_SETUP
#line 140 "lexer.l"
{return process_operator (MULT);}
	BF_BREAK
case 28:
BF_RULE_SETUP
#line 141 "lexer.l"
{return process_operator (DIV);}
	BF_BREAK
case 29:
BF_RULE_SETUP
#line 142 "lexer.l"
{return process_operator (MOD);}
	BF_BREAK
case 30:
BF_RULE_SETUP
#line 143 "lexer.l"
{return process_operator (BKSLV);}
	BF_BREAK
case 31:
BF_RULE_SETUP
#line 144 "lexer.l"
{return process_operator (POW);}
	BF_BREAK
case 32:
BF_RULE_SETUP
#line 145 "lexer.l"
{return process_operator (TRANS);}
	BF_BREAK
case 33:
BF_RULE_SETUP
#line 146 "lexer.l"
{return process_operator (NOT);}
	BF_BREAK
case 34:
BF_RULE_SETUP
#line 147 "lexer.l"
{return process_operator (DOT);}
	BF_BREAK
case 35:
BF_RULE_SETUP
#line 148 "lexer.l"
{return process_operator (LPAREN);}
	BF_BREAK
case 36:
BF_RULE_SETUP
#line 149 "lexer.l"
{return process_operator (RPAREN);}
	BF_BREAK
case 37:
BF_RULE_SETUP
#line 150 "lexer.l"
{return process_operator (LBRACK);}
	BF_BREAK
case 38:
BF_RULE_SETUP
#line 151 "lexer.l"
{return process_operator (RBRACK);}
	BF_BREAK
case 39:
BF_RULE_SETUP
#line 152 "lexer.l"
{return process_operator (COMMA);}
	BF_BREAK
case 40:
BF_RULE_SETUP
#line 153 "lexer.l"
{return process_operator (SEMICOL);}
	BF_BREAK
case 41:
BF_RULE_SETUP
#line 155 "lexer.l"
{return process_literal (CONSTANT);}
	BF_BREAK
case 42:
BF_RULE_SETUP
#line 157 "lexer.l"
{return process_literal (STRLIT);}
	BF_BREAK
case 43:
BF_RULE_SETUP
#line 158 "lexer.l"
{return process_literal (ID);}
	BF_BREAK
case 44:
BF_RULE_SETUP
#line 160 "lexer.l"
{return process_literal (NUMLIT);}
	BF_BREAK
case 45:
BF_RULE_SETUP
#line 161 "lexer.l"
{return process_literal (NUMLIT);}
	BF_BREAK
case 46:
BF_RULE_SETUP
#line 162 "lexer.l"
{return process_literal (NUMLIT);}
	BF_BREAK
case 47:
BF_RULE_SETUP
#line 163 "lexer.l"
{return process_literal (NUMLIT);}
	BF_BREAK
case 48:
BF_RULE_SETUP
#line 165 "lexer.l"
{BEGIN (comment);}
	BF_BREAK
case 49:
BF_RULE_SETUP
#line 166 "lexer.l"

	BF_BREAK
case 50:
BF_RULE_SETUP
#line 167 "lexer.l"
{if (process_newline ( )) return SEMICOL;}
	BF_BREAK
case 51:
BF_RULE_SETUP
#line 168 "lexer.l"

	BF_BREAK
case 52:
BF_RULE_SETUP
#line 169 "lexer.l"
{if (process_newline ( )) return SEMICOL;}
	BF_BREAK
case 53:
BF_RULE_SETUP
#line 170 "lexer.l"
{BEGIN (INITIAL);}
	BF_BREAK
case 54:
BF_RULE_SETUP
#line 172 "lexer.l"
{if (!interactive) line_num ++;}
	BF_BREAK
case 55:
BF_RULE_SETUP
#line 173 "lexer.l"
{if (process_newline ( )) return SEMICOL;}
	BF_BREAK
case 56:
BF_RULE_SETUP
#line 174 "lexer.l"
{if (process_newline ( )) return SEMICOL;}
	BF_BREAK
case 57:
BF_RULE_SETUP
#line 175 "lexer.l"

	BF_BREAK
case BF_STATE_EOF(INITIAL):
#line 177 "lexer.l"
{return process_eof ( );}
	BF_BREAK
case 58:
BF_RULE_SETUP
#line 178 "lexer.l"
ECHO;
	BF_BREAK
#line 1119 "lex.bf.c"
case BF_STATE_EOF(quit):
case BF_STATE_EOF(comment):
	bfterminate();

	case BF_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int bf_amount_of_matched_text = (int) (bf_cp - bftext_ptr) - 1;

		/* Undo the effects of BF_DO_BEFORE_ACTION. */
		*bf_cp = bf_hold_char;

		if ( bf_current_buffer->bf_buffer_status == BF_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed bfin at a new source and called
			 * bflex().  If so, then we have to assure
			 * consistency between bf_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			bf_n_chars = bf_current_buffer->bf_n_chars;
			bf_current_buffer->bf_input_file = bfin;
			bf_current_buffer->bf_buffer_status = BF_BUFFER_NORMAL;
			}

		/* Note that here we test for bf_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since bf_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( bf_c_buf_p <= &bf_current_buffer->bf_ch_buf[bf_n_chars] )
			{ /* This was really a NUL. */
			bf_state_type bf_next_state;

			bf_c_buf_p = bftext_ptr + bf_amount_of_matched_text;

			bf_current_state = bf_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * bf_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			bf_next_state = bf_try_NUL_trans( bf_current_state );

			bf_bp = bftext_ptr + BF_MORE_ADJ;

			if ( bf_next_state )
				{
				/* Consume the NUL. */
				bf_cp = ++bf_c_buf_p;
				bf_current_state = bf_next_state;
				goto bf_match;
				}

			else
				{
				bf_cp = bf_c_buf_p;
				goto bf_find_action;
				}
			}

		else switch ( bf_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				bf_did_buffer_switch_on_eof = 0;

				if ( bfwrap() )
					{
					/* Note: because we've taken care in
					 * bf_get_next_buffer() to have set up
					 * bftext, we can now set up
					 * bf_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * BF_NULL, it'll still work - another
					 * BF_NULL will get returned.
					 */
					bf_c_buf_p = bftext_ptr + BF_MORE_ADJ;

					bf_act = BF_STATE_EOF(BF_START);
					goto do_action;
					}

				else
					{
					if ( ! bf_did_buffer_switch_on_eof )
						BF_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				bf_c_buf_p =
					bftext_ptr + bf_amount_of_matched_text;

				bf_current_state = bf_get_previous_state();

				bf_cp = bf_c_buf_p;
				bf_bp = bftext_ptr + BF_MORE_ADJ;
				goto bf_match;

			case EOB_ACT_LAST_MATCH:
				bf_c_buf_p =
				&bf_current_buffer->bf_ch_buf[bf_n_chars];

				bf_current_state = bf_get_previous_state();

				bf_cp = bf_c_buf_p;
				bf_bp = bftext_ptr + BF_MORE_ADJ;
				goto bf_find_action;
			}
		break;
		}

	default:
		BF_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of bflex */


/* bf_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int bf_get_next_buffer()
	{
	register char *dest = bf_current_buffer->bf_ch_buf;
	register char *source = bftext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( bf_c_buf_p > &bf_current_buffer->bf_ch_buf[bf_n_chars + 1] )
		BF_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( bf_current_buffer->bf_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( bf_c_buf_p - bftext_ptr - BF_MORE_ADJ == 1 )
			{
			/* We matched a singled characater, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (bf_c_buf_p - bftext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( bf_current_buffer->bf_buffer_status == BF_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		bf_n_chars = 0;

	else
		{
		int num_to_read =
			bf_current_buffer->bf_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef BF_USES_REJECT
			BF_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			BF_BUFFER_STATE b = bf_current_buffer;

			int bf_c_buf_p_offset =
				(int) (bf_c_buf_p - b->bf_ch_buf);

			if ( b->bf_is_our_buffer )
				{
				int new_size = b->bf_buf_size * 2;

				if ( new_size <= 0 )
					b->bf_buf_size += b->bf_buf_size / 8;
				else
					b->bf_buf_size *= 2;

				b->bf_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					bf_flex_realloc( (void *) b->bf_ch_buf,
							 b->bf_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->bf_ch_buf = 0;

			if ( ! b->bf_ch_buf )
				BF_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			bf_c_buf_p = &b->bf_ch_buf[bf_c_buf_p_offset];

			num_to_read = bf_current_buffer->bf_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > BF_READ_BUF_SIZE )
			num_to_read = BF_READ_BUF_SIZE;

		/* Read in more data. */
		BF_INPUT( (&bf_current_buffer->bf_ch_buf[number_to_move]),
			bf_n_chars, num_to_read );
		}

	if ( bf_n_chars == 0 )
		{
		if ( number_to_move == BF_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			bfrestart( bfin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			bf_current_buffer->bf_buffer_status =
				BF_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	bf_n_chars += number_to_move;
	bf_current_buffer->bf_ch_buf[bf_n_chars] = BF_END_OF_BUFFER_CHAR;
	bf_current_buffer->bf_ch_buf[bf_n_chars + 1] = BF_END_OF_BUFFER_CHAR;

	bftext_ptr = &bf_current_buffer->bf_ch_buf[0];

	return ret_val;
	}


/* bf_get_previous_state - get the state just before the EOB char was reached */

static bf_state_type bf_get_previous_state()
	{
	register bf_state_type bf_current_state;
	register char *bf_cp;

	bf_current_state = bf_start;

	for ( bf_cp = bftext_ptr + BF_MORE_ADJ; bf_cp < bf_c_buf_p; ++bf_cp )
		{
		register BF_CHAR bf_c = (*bf_cp ? bf_ec[BF_SC_TO_UI(*bf_cp)] : 1);
		if ( bf_accept[bf_current_state] )
			{
			bf_last_accepting_state = bf_current_state;
			bf_last_accepting_cpos = bf_cp;
			}
		while ( bf_chk[bf_base[bf_current_state] + bf_c] != bf_current_state )
			{
			bf_current_state = (int) bf_def[bf_current_state];
			if ( bf_current_state >= 152 )
				bf_c = bf_meta[(unsigned int) bf_c];
			}
		bf_current_state = bf_nxt[bf_base[bf_current_state] + (unsigned int) bf_c];
		}

	return bf_current_state;
	}


/* bf_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = bf_try_NUL_trans( current_state );
 */

#ifdef BF_USE_PROTOS
static bf_state_type bf_try_NUL_trans( bf_state_type bf_current_state )
#else
static bf_state_type bf_try_NUL_trans( bf_current_state )
bf_state_type bf_current_state;
#endif
	{
	register int bf_is_jam;
	register char *bf_cp = bf_c_buf_p;

	register BF_CHAR bf_c = 1;
	if ( bf_accept[bf_current_state] )
		{
		bf_last_accepting_state = bf_current_state;
		bf_last_accepting_cpos = bf_cp;
		}
	while ( bf_chk[bf_base[bf_current_state] + bf_c] != bf_current_state )
		{
		bf_current_state = (int) bf_def[bf_current_state];
		if ( bf_current_state >= 152 )
			bf_c = bf_meta[(unsigned int) bf_c];
		}
	bf_current_state = bf_nxt[bf_base[bf_current_state] + (unsigned int) bf_c];
	bf_is_jam = (bf_current_state == 151);

	return bf_is_jam ? 0 : bf_current_state;
	}


#ifndef BF_NO_UNPUT
#ifdef BF_USE_PROTOS
static void bfunput( int c, register char *bf_bp )
#else
static void bfunput( c, bf_bp )
int c;
register char *bf_bp;
#endif
	{
	register char *bf_cp = bf_c_buf_p;

	/* undo effects of setting up bftext */
	*bf_cp = bf_hold_char;

	if ( bf_cp < bf_current_buffer->bf_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = bf_n_chars + 2;
		register char *dest = &bf_current_buffer->bf_ch_buf[
					bf_current_buffer->bf_buf_size + 2];
		register char *source =
				&bf_current_buffer->bf_ch_buf[number_to_move];

		while ( source > bf_current_buffer->bf_ch_buf )
			*--dest = *--source;

		bf_cp += (int) (dest - source);
		bf_bp += (int) (dest - source);
		bf_n_chars = bf_current_buffer->bf_buf_size;

		if ( bf_cp < bf_current_buffer->bf_ch_buf + 2 )
			BF_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--bf_cp = (char) c;


	bftext_ptr = bf_bp;
	bf_hold_char = *bf_cp;
	bf_c_buf_p = bf_cp;
	}
#endif	/* ifndef BF_NO_UNPUT */


#ifdef __cplusplus
static int bfinput()
#else
static int input()
#endif
	{
	int c;

	*bf_c_buf_p = bf_hold_char;

	if ( *bf_c_buf_p == BF_END_OF_BUFFER_CHAR )
		{
		/* bf_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( bf_c_buf_p < &bf_current_buffer->bf_ch_buf[bf_n_chars] )
			/* This was really a NUL. */
			*bf_c_buf_p = '\0';

		else
			{ /* need more input */
			bftext_ptr = bf_c_buf_p;
			++bf_c_buf_p;

			switch ( bf_get_next_buffer() )
				{
				case EOB_ACT_END_OF_FILE:
					{
					if ( bfwrap() )
						{
						bf_c_buf_p =
						bftext_ptr + BF_MORE_ADJ;
						return EOF;
						}

					if ( ! bf_did_buffer_switch_on_eof )
						BF_NEW_FILE;
#ifdef __cplusplus
					return bfinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					bf_c_buf_p = bftext_ptr + BF_MORE_ADJ;
					break;

				case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
					BF_FATAL_ERROR(
					"unexpected last match in bfinput()" );
#else
					BF_FATAL_ERROR(
					"unexpected last match in input()" );
#endif
				}
			}
		}

	c = *(unsigned char *) bf_c_buf_p;	/* cast for 8-bit char's */
	*bf_c_buf_p = '\0';	/* preserve bftext */
	bf_hold_char = *++bf_c_buf_p;


	return c;
	}


#ifdef BF_USE_PROTOS
void bfrestart( FILE *input_file )
#else
void bfrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! bf_current_buffer )
		bf_current_buffer = bf_create_buffer( bfin, BF_BUF_SIZE );

	bf_init_buffer( bf_current_buffer, input_file );
	bf_load_buffer_state();
	}


#ifdef BF_USE_PROTOS
void bf_switch_to_buffer( BF_BUFFER_STATE new_buffer )
#else
void bf_switch_to_buffer( new_buffer )
BF_BUFFER_STATE new_buffer;
#endif
	{
	if ( bf_current_buffer == new_buffer )
		return;

	if ( bf_current_buffer )
		{
		/* Flush out information for old buffer. */
		*bf_c_buf_p = bf_hold_char;
		bf_current_buffer->bf_buf_pos = bf_c_buf_p;
		bf_current_buffer->bf_n_chars = bf_n_chars;
		}

	bf_current_buffer = new_buffer;
	bf_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (bfwrap()) processing, but the only time this flag
	 * is looked at is after bfwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	bf_did_buffer_switch_on_eof = 1;
	}


#ifdef BF_USE_PROTOS
void bf_load_buffer_state( void )
#else
void bf_load_buffer_state()
#endif
	{
	bf_n_chars = bf_current_buffer->bf_n_chars;
	bftext_ptr = bf_c_buf_p = bf_current_buffer->bf_buf_pos;
	bfin = bf_current_buffer->bf_input_file;
	bf_hold_char = *bf_c_buf_p;
	}


#ifdef BF_USE_PROTOS
BF_BUFFER_STATE bf_create_buffer( FILE *file, int size )
#else
BF_BUFFER_STATE bf_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	BF_BUFFER_STATE b;

	b = (BF_BUFFER_STATE) bf_flex_alloc( sizeof( struct bf_buffer_state ) );
	if ( ! b )
		BF_FATAL_ERROR( "out of dynamic memory in bf_create_buffer()" );

	b->bf_buf_size = size;

	/* bf_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->bf_ch_buf = (char *) bf_flex_alloc( b->bf_buf_size + 2 );
	if ( ! b->bf_ch_buf )
		BF_FATAL_ERROR( "out of dynamic memory in bf_create_buffer()" );

	b->bf_is_our_buffer = 1;

	bf_init_buffer( b, file );

	return b;
	}


#ifdef BF_USE_PROTOS
void bf_delete_buffer( BF_BUFFER_STATE b )
#else
void bf_delete_buffer( b )
BF_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == bf_current_buffer )
		bf_current_buffer = (BF_BUFFER_STATE) 0;

	if ( b->bf_is_our_buffer )
		bf_flex_free( (void *) b->bf_ch_buf );

	bf_flex_free( (void *) b );
	}


#ifndef BF_ALWAYS_INTERACTIVE
#ifndef BF_NEVER_INTERACTIVE
extern int isatty BF_PROTO(( int ));
#endif
#endif

#ifdef BF_USE_PROTOS
void bf_init_buffer( BF_BUFFER_STATE b, FILE *file )
#else
void bf_init_buffer( b, file )
BF_BUFFER_STATE b;
FILE *file;
#endif


	{
	bf_flush_buffer( b );

	b->bf_input_file = file;
	b->bf_fill_buffer = 1;

#if BF_ALWAYS_INTERACTIVE
	b->bf_is_interactive = 1;
#else
#if BF_NEVER_INTERACTIVE
	b->bf_is_interactive = 0;
#else
	b->bf_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef BF_USE_PROTOS
void bf_flush_buffer( BF_BUFFER_STATE b )
#else
void bf_flush_buffer( b )
BF_BUFFER_STATE b;
#endif

	{
	b->bf_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->bf_ch_buf[0] = BF_END_OF_BUFFER_CHAR;
	b->bf_ch_buf[1] = BF_END_OF_BUFFER_CHAR;

	b->bf_buf_pos = &b->bf_ch_buf[0];

	b->bf_at_bol = 1;
	b->bf_buffer_status = BF_BUFFER_NEW;

	if ( b == bf_current_buffer )
		bf_load_buffer_state();
	}


#ifndef BF_NO_SCAN_BUFFER
#ifdef BF_USE_PROTOS
BF_BUFFER_STATE bf_scan_buffer( char *base, bf_size_t size )
#else
BF_BUFFER_STATE bf_scan_buffer( base, size )
char *base;
bf_size_t size;
#endif
	{
	BF_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != BF_END_OF_BUFFER_CHAR ||
	     base[size-1] != BF_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (BF_BUFFER_STATE) bf_flex_alloc( sizeof( struct bf_buffer_state ) );
	if ( ! b )
		BF_FATAL_ERROR( "out of dynamic memory in bf_scan_buffer()" );

	b->bf_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->bf_buf_pos = b->bf_ch_buf = base;
	b->bf_is_our_buffer = 0;
	b->bf_input_file = 0;
	b->bf_n_chars = b->bf_buf_size;
	b->bf_is_interactive = 0;
	b->bf_at_bol = 1;
	b->bf_fill_buffer = 0;
	b->bf_buffer_status = BF_BUFFER_NEW;

	bf_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef BF_NO_SCAN_STRING
#ifdef BF_USE_PROTOS
BF_BUFFER_STATE bf_scan_string( bfconst char *str )
#else
BF_BUFFER_STATE bf_scan_string( str )
bfconst char *str;
#endif
	{
	int len;
	for ( len = 0; str[len]; ++len )
		;

	return bf_scan_bytes( str, len );
	}
#endif


#ifndef BF_NO_SCAN_BYTES
#ifdef BF_USE_PROTOS
BF_BUFFER_STATE bf_scan_bytes( bfconst char *bytes, int len )
#else
BF_BUFFER_STATE bf_scan_bytes( bytes, len )
bfconst char *bytes;
int len;
#endif
	{
	BF_BUFFER_STATE b;
	char *buf;
	bf_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) bf_flex_alloc( n );
	if ( ! buf )
		BF_FATAL_ERROR( "out of dynamic memory in bf_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = BF_END_OF_BUFFER_CHAR;

	b = bf_scan_buffer( buf, n );
	if ( ! b )
		BF_FATAL_ERROR( "bad buffer in bf_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->bf_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef BF_NO_PUSH_STATE
#ifdef BF_USE_PROTOS
static void bf_push_state( int new_state )
#else
static void bf_push_state( new_state )
int new_state;
#endif
	{
	if ( bf_start_stack_ptr >= bf_start_stack_depth )
		{
		bf_size_t new_size;

		bf_start_stack_depth += BF_START_STACK_INCR;
		new_size = bf_start_stack_depth * sizeof( int );

		if ( ! bf_start_stack )
			bf_start_stack = (int *) bf_flex_alloc( new_size );

		else
			bf_start_stack = (int *) bf_flex_realloc(
					(void *) bf_start_stack, new_size );

		if ( ! bf_start_stack )
			BF_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	bf_start_stack[bf_start_stack_ptr++] = BF_START;

	BEGIN(new_state);
	}
#endif


#ifndef BF_NO_POP_STATE
static void bf_pop_state()
	{
	if ( --bf_start_stack_ptr < 0 )
		BF_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(bf_start_stack[bf_start_stack_ptr]);
	}
#endif


#ifndef BF_NO_TOP_STATE
static int bf_top_state()
	{
	return bf_start_stack[bf_start_stack_ptr - 1];
	}
#endif

#ifndef BF_EXIT_FAILURE
#define BF_EXIT_FAILURE 2
#endif

#ifdef BF_USE_PROTOS
static void bf_fatal_error( bfconst char msg[] )
#else
static void bf_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( BF_EXIT_FAILURE );
	}



/* Redefine bfless() so it works in section 3 code. */

#undef bfless
#define bfless(n) \
	do \
		{ \
		/* Undo effects of setting up bftext. */ \
		bftext[bfleng] = bf_hold_char; \
		bf_c_buf_p = bftext + n - BF_MORE_ADJ; \
		bf_hold_char = *bf_c_buf_p; \
		*bf_c_buf_p = '\0'; \
		bfleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef bftext_ptr
#ifdef BF_USE_PROTOS
static void bf_flex_strncpy( char *s1, bfconst char *s2, int n )
#else
static void bf_flex_strncpy( s1, s2, n )
char *s1;
bfconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif


#ifdef BF_USE_PROTOS
static void *bf_flex_alloc( bf_size_t size )
#else
static void *bf_flex_alloc( size )
bf_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef BF_USE_PROTOS
static void *bf_flex_realloc( void *ptr, bf_size_t size )
#else
static void *bf_flex_realloc( ptr, size )
void *ptr;
bf_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef BF_USE_PROTOS
static void bf_flex_free( void *ptr )
#else
static void bf_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if BF_MAIN
int main()
	{
	bflex();
	return 0;
	}
#endif
#line 178 "lexer.l"



/************************************************************************
 * Function:	bferror							*
 *									*
 * Description:	Reports a syntax error using the error mechanism.	*
 ************************************************************************/

void bferror (message)
    char *message;
{
    int c;


    if (*bftext == '\n') {
	line_num --;
	cterror ("%s before end of line", message);
	line_num ++;
    } else if (*bftext)
	cterror ("%s before '%s'", message, bftext);
    else
	cterror ("%s before end of file", message);


    if (interactive) {
	while ((c = input ( )) && c != '\n');
	last_token = 0;
	newline = 0;
	line_num ++;
    }
}


/************************************************************************
 * Function:	process							*
 *									*
 * Description:	Processes the current token.  This entails inserting a	*
 *		semicolon in the input and mapping an IF token to an	*
 *		ELIF token if necessary as described above.		*
 ************************************************************************/

static int process (this_token)
    int this_token;
{
    if (newline && toktab [last_token].end && toktab [this_token].begin) {
	saved_token = this_token;
	saved_value = *value;
	this_token = SEMICOL;
	value -> loc.line = line_num;
	value -> loc.file = file_num;
    } else if (last_token == ELSE && this_token == IF)
	this_token = ELIF;

    newline = 0;
    last_token = this_token;
    return this_token;
}


/************************************************************************
 * Function:	process_operator					*
 *									*
 * Description:	Process the current operator (symbol or keyword) token.	*
 *		The location information consisting of the current line	*
 *		and file number is set.					*
 ************************************************************************/

static int process_operator (this_token)
    int this_token;
{
    value -> loc.line = line_num;
    value -> loc.file = file_num;

    return process (this_token);
}


/************************************************************************
 * Function:	process_literal						*
 *									*
 * Description:	Process the current literal token.			*
 ************************************************************************/

static int process_literal (this_token)
    int this_token;
{
    char *dest;
    char *src;


    value -> sval = Strdup (bftext);

    if (this_token == STRLIT) {
	dest = value -> sval;
	for (src = bftext + 1; *src; src ++)
	    if (*src == '\\')
		switch (*++ src) {
		case '\n': line_num ++; break;
		case 'a':  *dest ++ = '\a'; break;
		case 'b':  *dest ++ = '\b'; break;
		case 'f':  *dest ++ = '\f'; break;
		case 'n':  *dest ++ = '\n'; break;
		case 'r':  *dest ++ = '\r'; break;
		case 't':  *dest ++ = '\t'; break;
		case 'v':  *dest ++ = '\v'; break;
		default:   *dest ++ = *src; break;
		}
	    else
		*dest ++ = *src;
	*(dest - 1) = 0;
    }

    return process (this_token);
}


/************************************************************************
 * Function:	process_newline						*
 *									*
 * Description:	Processes a newline token.				*
 ************************************************************************/

static int process_newline ( )
{
    value -> loc.line = line_num;
    value -> loc.file = file_num;

    if (interactive) {
	if (toktab [last_token].end) {
	    last_token = SEMICOL;
	    newline = 0;
	    line_num ++;
	    return 1;
	}
    } else
	line_num ++;

    newline = 1;
    return 0;
}


/************************************************************************
 * Function:	process_eof						*
 *									*
 * Description:	Processes an end of file.  If a file was being read	*
 *		then a semicolon is returned to terminate the file.	*
 ************************************************************************/

static int process_eof ( )
{
    BEGIN (quit);
    return interactive ? BF_NULL : SEMICOL;
}


/************************************************************************
 * Function:	bfinclude						*
 *									*
 * Description:	Includes a named file for interpreting.  If the file is	*
 *		successfully opened then any existing state information	*
 *		is saved on the stack, the lexer is initialized, and	*
 *		the file is parsed.  After parsing, any state		*
 *		information is restored.				*
 ************************************************************************/

int bfinclude (file)
    char *file;
{
    int		    old_newline;
    int		    old_last_token;
    int		    old_saved_token;
    int		    old_start_state;
    int		    old_line_num;
    int		    old_file_num;
    int		    old_interactive;
    int		    old_curr_line_num;
    int		    old_curr_file_num;
    char	   *old_curr_file_name;
    char	   *old_file_name;
    BFSTYPE	    old_saved_value;
    FILE	   *stream;
    ste		   *s;
    int		    status;
    ExecState	    state;
    BF_BUFFER_STATE buffer;


    /* Determine the file name and stream. */

    if (!file) {
	stream = NULL;
	file = "stdin";
    } else if (!strcmp (file, "-")) {
	stream = stdin;
	file = "stdin";
    } else if (!(stream = fopen (file, "r")))
	return -1;


    /* Save the current state. */

    if (depth ++) {
	SaveState (&state);
	old_start_state	= bf_start;

	old_line_num  = line_num;
	old_file_num  = file_num;
	old_file_name = file_name;

	old_curr_line_num  = curr_line_num;
	old_curr_file_num  = curr_file_num;
	old_curr_file_name = curr_file_name;

	old_newline	= newline;
	old_last_token	= last_token;
	old_saved_token	= saved_token;
	old_saved_value	= saved_value;
	old_interactive	= interactive;

	buffer = BF_CURRENT_BUFFER;
	bf_switch_to_buffer (bf_create_buffer (stream, BF_BUF_SIZE));

    } else if (!bfin)
	bfin = stream;
    else
	bfrestart (stream);


    /* Initialize and parse. */

    BEGIN (INITIAL);

    newline = 0;
    line_num = 1;
    last_token = 0;
    saved_token = 0;
    interactive = !stream;

    s = add_literal (&str_st, file, StrOp);
    file_name = s -> name;
    file_num = s -> idx;

    global_cs = cs = new_cs ( );
    status = bfparse ( );
    free_cs (cs);


    /* Restore the old state. */

    if (-- depth) {
	RestoreState (&state);
	global_cs = cs;
	bf_start = old_start_state;

	line_num  = old_line_num;
	file_num  = old_file_num;
	file_name = old_file_name;

	curr_line_num  = old_curr_line_num;
	curr_file_num  = old_curr_file_num;
	curr_file_name = old_curr_file_name;

	newline     = old_newline;
	last_token  = old_last_token;
	saved_token = old_saved_token;
	interactive = old_interactive;
	saved_value = old_saved_value;

	bf_delete_buffer (BF_CURRENT_BUFFER);
	bf_switch_to_buffer (buffer);
    }


    /* Close the file and return the status. */

    if (stream && stream != stdin)
	fclose (stream);

    return status;
}


/************************************************************************
 * Function:	bfwrap							*
 *									*
 * Description:	Return nonzero, indicating the end of input.		*
 ************************************************************************/

int bfwrap ( )
{
    if (0) unput (0);
    return 1;
}
