/*****************************************************************
 * fbinfo.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * fbinfo.c: 
 *
 * USAGE
 *	% fbinfo files...
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:03:01 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbinfo.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 03-May-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.93) mlm@cs.cmu.edu
 *
 * 26-Sep-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/


# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE "Usage: fbinfo files..."

#ifndef lint
static char *fbmid =
"$FBM fbinfo.c <1.0> 25-Jun-90  (C) 1989,1990 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ register int i;
  FILE *infile;
  char name[128], cmd[256];

  if (argc == 1)
  { binfo ((char *) NULL, stdin); }
  else
  { for (i=1; i<argc; i++)
    { strcpy (name, argv[i]);

      if (strcmp (name + strlen (name) - 2, ".Z") == 0)
      { sprintf (cmd, "(uncompress < %s | select 0 255) 2> /dev/null", name); 
        if (infile = popen (cmd, "r"))
	{ binfo (name, infile); pclose (infile); }
	else
	{ perror (cmd); }
      }
      else if (infile = fopen (argv[i], "r"))
      { binfo (argv[i], infile); fclose (infile); }
      else
      { perror (argv[i]); }
    }
  }
}

binfo (name, file)
char *name;
FILE *file;
{ FBM image;
  FBMHDR *hdr;

  image.cm = image.bm = (unsigned char *) NULL;

  /* Read the file header format the bitmap description */
  if (read_hdr_fbm (&image, file, (char *) NULL, 0))
  { hdr = &(image.hdr);

    if (name) printf ("%-15s\t", name);

    if (hdr->title[0])		{ printf ("\"%s\"\n", hdr->title); }
    else			{ printf ("(untitled)\n"); }

    if (hdr->credits[0])
    { if (name) printf ("\t\t");
      printf ("[ %s ]\n", hdr->credits);
    }
    
    if (name) printf ("\t\t");

    if (hdr->planes == 1)
    { printf ("[%dx%dx%d]    %d physbits  %1.4lg aspect ratio\n",
	      hdr->cols, hdr->rows, hdr->bits, hdr->physbits, hdr->aspect);
    }
    else
    { printf ("[%dx%dx%dx%d]  %d physbits  %1.4lg aspect ratio\n",
	      hdr->planes, hdr->cols, hdr->rows, hdr->bits, hdr->physbits, 
	      hdr->aspect);
    }

    if (name) printf ("\t\t");

    printf ("row length %d, plane length %d, colormap length %d\n",
	    hdr->rowlen, hdr->plnlen, hdr->clrlen);

    return (1);
  }

  return (0);
}
