
#if !defined(EC_INET_STRUCTURES_H)
#define EC_INET_STRUCTURES_H

#ifdef CYGWIN
   #include <windows.h>
   #include <winsock2.h>
   #include "../missing/inet_aton.h"
#else
   #include <sys/socket.h>
#endif

#ifndef HAVE_SOCKLEN_T
   typedef unsigned int socklen_t;
#endif

#ifdef LINUX
   #include <features.h>         /* for the glibc version number */

   #if __GLIBC__ >= 2 && __GLIBC_MINOR__ >= 1
      #include <netpacket/packet.h>
      #include <net/ethernet.h>     /* the L2 protocols */
		#define NETPACKET_PACKET_H
   #else
      #include <asm/types.h>
      #include <linux/if_packet.h>
      #include <linux/if_ether.h>   /* The L2 protocols */
      #ifdef HAVE_NET_ETHERNET_H
         #include <net/ethernet.h>
      #endif
   #endif
#endif

#if !defined(OPENBSD) && !defined(CYGWIN)
   #include <net/if_arp.h>
#endif

#ifdef CYGWIN
   #include "../missing/include/if_arp.h"
#endif


#include <sys/types.h>
#include <netinet/in_systm.h>

#ifdef CYGWIN
   #include <netinet/tcp.h>
   #include <netinet/ip.h>
   #include "../missing/include/ip_icmp.h"
#else
   #include <net/if.h>
   #include <netdb.h>
   #include <netinet/tcp.h>
   #include <netinet/in.h>
   #include <netinet/ip.h>
   #include <netinet/ip_icmp.h>
   #include <arpa/inet.h>
#endif



typedef struct {
   char dest_mac[6];          // dest ethernet address
   char source_mac[6];        // source ethernet address
   u_int16 type;              // type of packet
} ETH_header;


typedef struct {
   u_int16 hw_type;           // hardware type
   u_int16 proto_type;        // protocol type
   u_int8 ha_len;             // hardware address len
   u_int8 pa_len;             // protocol address len
   u_int16 opcode;            // arp opcode
   char source_add[6];        // source mac
   char source_ip[4];         // source ip
   char dest_add[6];          // dest mac
   char dest_ip[4];           // dest ip
} ARP_header;


typedef struct {
#ifdef WORDS_BIGENDIAN
   u_int8 version:4;          // ip version
   u_int8 h_len:4;            // header len
#else
   u_int8 h_len:4;            // header len
   u_int8 version:4;          // ip version
#endif
   u_int8 tos;                // type of service
   u_int16 t_len;             // total len
   u_int16 ident;             // ip ident
   u_int16 frag_and_flags;    // fragments and flags
   u_int8  ttl;               // time to live
   u_int8 proto;              // transport protocol
   u_int16 checksum;          // IP checksum
   u_int32 source_ip;         // source ip
   u_int32 dest_ip;           // destination ip
} IP_header;


typedef struct {
   u_int8 type;               // icmp type
   u_int8 code;               // type sub code
   u_int16 checksum;          // ones complement checksum of struct
   union
   {
       struct
       {
           u_int16 id;        // ident
           u_int16 seq;       // sequence number
       } echo;
       u_int32 gateway;        // gateway address
       struct
       {
           u_int16 unused;
           u_int16 mtu;
       } frag;                // path mtu discovery
    } un;
} ICMP_header;


typedef struct
{
   u_int16 source;            // source port
   u_int16 dest;              // destination port
   u_int32 seq;                // sequence number
   u_int32 ack_seq;            // acknowledgement number
#ifdef WORDS_BIGENDIAN
   u_int8 doff:4;             // data offset
   u_int8 unused:4;           // unused
#else
   u_int8 unused:4;           // unused
   u_int8 doff:4;             // data offset
#endif
   u_int8  flags;             // tcp flags
   u_int16 window;            // window
   u_int16 checksum;          // checksum
   u_int16 urg_ptr;           // urgent pointer
} TCP_header;


typedef struct
{
   u_int16 source;             // source port
   u_int16 dest;               // destination port
   u_int16 len;                // packet length
   u_int16 checksum;           // checksum
} UDP_header;


#define MAX_PACKET_SIZE      0xffff

#define ETH_HEADER           0xe     // Etherner header:     14 bytes
#define ARP_HEADER           0x1c    // ARP header:          28 bytes

#define IP_HEADER            0x14    // IP header:           20 bytes

#define ICMP_HEADER          0x8     // ICMP header:          8 bytes

#define TCP_HEADER           0x14    // TCP header:          20 bytes
#define UDP_HEADER           0x8     // UDP header:           8 bytes

#define TH_FIN  0x01    // TCP Flags
#define TH_SYN  0x02
#define TH_RST  0x04
#define TH_PSH  0x08
#define TH_ACK  0x10
#define TH_URG  0x20

#define TCPOPT_EOL              0
#define TCPOPT_NOP              1
#define TCPOPT_MAXSEG           2
#define TCPOPT_WSCALE           3
#define TCPOPT_SACKOK           4
#define TCPOPT_TIMESTAMP        8


#ifndef IP_DF
#define IP_DF 0x4000
#endif

#ifndef IP_OFFMASK
#define IP_OFFMASK 0x1fff
#endif

#ifndef SOL_PACKET      // glibc 2.1 bug
#define SOL_PACKET 263
#endif

#ifndef ETH_P_IP
#define ETH_P_IP 0x0800
#endif

#ifndef ETH_P_ARP
#define ETH_P_ARP 0x0806
#endif

#ifndef MSG_TRUNC
#define MSG_TRUNC 0x20
#endif

#ifndef ETHER_ADDR_LEN
#define ETHER_ADDR_LEN 6
#endif

#ifndef PACKET_HOST
#define PACKET_HOST 0
#endif

#ifndef ICMP_DEST_UNREACH
#define ICMP_DEST_UNREACH 3
#endif

#ifndef ICMP_SOURCE_QUENCH
#define ICMP_SOURCE_QUENCH 4
#endif


#ifdef WORDS_BIGENDIAN
   #define ptohs(x) ( (u_int16)                       \
                      ((u_int16)*((u_int8 *)x+1)<<8|  \
                      (u_int16)*((u_int8 *)x+0)<<0)   \
                    )

   #define ptohl(x) ( (u_int32)*((u_int8 *)x+3)<<24|  \
                      (u_int32)*((u_int8 *)x+2)<<16|  \
                      (u_int32)*((u_int8 *)x+1)<<8|   \
                      (u_int32)*((u_int8 *)x+0)<<0    \
                    )
#else
   #define ptohs(x) *(u_int16 *)(x)
   #define ptohl(x) *(u_int32 *)(x)
#endif

#define int_ntoa(x)   inet_ntoa(*((struct in_addr *)&(x)))


#endif // EC_INET_STRUCTURES_H

/* EOF */

// vim:ts=3:expandtab

