/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-cfg-account.h,v 1.7 2003/12/15 16:08:53 hoa Exp $
 */

#ifndef ETPAN_CFG_ACCOUNT_DECL_H

#define ETPAN_CFG_ACCOUNT_DECL_H

#include <libetpan/clist.h>
#include "etpan-cfg-global-types.h"
#include "etpan-cfg-account-types.h"

int etpan_account_config_read(char * filename,
    struct etpan_account_config ** result);

struct etpan_account_info *
etpan_account_get(struct etpan_account_config * config,
    char * name);

struct etpan_account_config *
etpan_account_config_new(clist * list,
    struct etpan_account_info * default_account);

void etpan_account_config_free(struct etpan_account_config * config);

struct etpan_account_info * etpan_account_info_new(char * id,
    char * name, char * addr, char * signature,
    char * security_driver, char * security_encryption);

void etpan_account_info_free(struct etpan_account_info * account);

int etpan_cfg_account_write(char * filename,
    struct etpan_account_config * config);

#endif
