
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <ethos/ethos.h>
#include <stdio.h>


#define BASIC_TYPE_EXAMPLE (basic_example_get_type ())
#define BASIC_EXAMPLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BASIC_TYPE_EXAMPLE, BasicExample))
#define BASIC_EXAMPLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BASIC_TYPE_EXAMPLE, BasicExampleClass))
#define BASIC_IS_EXAMPLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BASIC_TYPE_EXAMPLE))
#define BASIC_IS_EXAMPLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BASIC_TYPE_EXAMPLE))
#define BASIC_EXAMPLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BASIC_TYPE_EXAMPLE, BasicExampleClass))

typedef struct _BasicExample BasicExample;
typedef struct _BasicExampleClass BasicExampleClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BasicExamplePrivate BasicExamplePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

struct _BasicExample {
	GObject parent_instance;
	BasicExamplePrivate * priv;
};

struct _BasicExampleClass {
	GObjectClass parent_class;
};

struct _BasicExamplePrivate {
	EthosManager* manager;
	GtkWindow* window;
	GtkButton* button;
};


static gpointer basic_example_parent_class = NULL;

BasicExample* basic_example_new (void);
BasicExample* basic_example_construct (GType object_type);
GType basic_example_get_type (void);
void basic_example_run (BasicExample* self);
void basic_main (char** args, int args_length1);
#define BASIC_EXAMPLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BASIC_TYPE_EXAMPLE, BasicExamplePrivate))
enum  {
	BASIC_EXAMPLE_DUMMY_PROPERTY
};
static void _g_list_free_g_object_unref (GList* self);
static void _lambda0_ (BasicExample* self);
static void __lambda0__ethos_manager_initialized (EthosManager* _sender, gpointer self);
static void _lambda1_ (EthosManager* _, EthosPluginInfo* plugin_info, BasicExample* self);
static void __lambda1__ethos_manager_plugin_loaded (EthosManager* _sender, EthosPluginInfo* plugin_info, gpointer self);
static void _lambda2_ (EthosManager* _, EthosPluginInfo* plugin_info, BasicExample* self);
static void __lambda2__ethos_manager_plugin_unloaded (EthosManager* _sender, EthosPluginInfo* plugin_info, gpointer self);
static void _lambda3_ (BasicExample* self);
static void __lambda3__gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * basic_example_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void basic_example_finalize (GObject* obj);



void basic_main (char** args, int args_length1) {
	BasicExample* example;
	gtk_init (&args_length1, &args);
	example = basic_example_new ();
	basic_example_run (example);
	_g_object_unref0 (example);
}


int main (int argc, char ** argv) {
	g_type_init ();
	basic_main (argv, argc);
	return 0;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void basic_example_run (BasicExample* self) {
	g_return_if_fail (self != NULL);
	ethos_manager_initialize (self->priv->manager);
	{
		GList* loader_collection;
		GList* loader_it;
		loader_collection = ethos_manager_get_plugin_loaders (self->priv->manager);
		for (loader_it = loader_collection; loader_it != NULL; loader_it = loader_it->next) {
			EthosPluginLoader* loader;
			loader = _g_object_ref0 ((EthosPluginLoader*) loader_it->data);
			{
				char* name;
				name = g_strdup (ethos_plugin_loader_get_name (loader));
				if (name == NULL) {
					char* _tmp0_;
					name = (_tmp0_ = g_strdup ("default"), _g_free0 (name), _tmp0_);
				}
				g_debug ("basic.vala:40: Loaded loader %s", name);
				_g_object_unref0 (loader);
				_g_free0 (name);
			}
		}
		__g_list_free_g_object_unref0 (loader_collection);
	}
	gtk_main ();
}


BasicExample* basic_example_construct (GType object_type) {
	BasicExample * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


BasicExample* basic_example_new (void) {
	return basic_example_construct (BASIC_TYPE_EXAMPLE);
}


static void _lambda0_ (BasicExample* self) {
	fprintf (stdout, "Ethos was initialized\n");
}


static void __lambda0__ethos_manager_initialized (EthosManager* _sender, gpointer self) {
	_lambda0_ (self);
}


static void _lambda1_ (EthosManager* _, EthosPluginInfo* plugin_info, BasicExample* self) {
	g_return_if_fail (_ != NULL);
	g_return_if_fail (plugin_info != NULL);
	fprintf (stdout, "%s plugin was loaded\n", ethos_plugin_info_get_id (plugin_info));
}


static void __lambda1__ethos_manager_plugin_loaded (EthosManager* _sender, EthosPluginInfo* plugin_info, gpointer self) {
	_lambda1_ (_sender, plugin_info, self);
}


static void _lambda2_ (EthosManager* _, EthosPluginInfo* plugin_info, BasicExample* self) {
	g_return_if_fail (_ != NULL);
	g_return_if_fail (plugin_info != NULL);
	fprintf (stdout, "%s plugin was unloaded\n", ethos_plugin_info_get_id (plugin_info));
}


static void __lambda2__ethos_manager_plugin_unloaded (EthosManager* _sender, EthosPluginInfo* plugin_info, gpointer self) {
	_lambda2_ (_sender, plugin_info, self);
}


static void _lambda3_ (BasicExample* self) {
	gtk_main_quit ();
}


static void __lambda3__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda3_ (self);
}


static GObject * basic_example_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	BasicExampleClass * klass;
	GObjectClass * parent_class;
	BasicExample * self;
	klass = BASIC_EXAMPLE_CLASS (g_type_class_peek (BASIC_TYPE_EXAMPLE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = BASIC_EXAMPLE (obj);
	{
		EthosManager* _tmp0_;
		GtkWindow* _tmp1_;
		GtkButton* _tmp2_;
		self->priv->manager = (_tmp0_ = ethos_manager_new (), _g_object_unref0 (self->priv->manager), _tmp0_);
		g_signal_connect_object (self->priv->manager, "initialized", (GCallback) __lambda0__ethos_manager_initialized, self, 0);
		g_signal_connect_object (self->priv->manager, "plugin-loaded", (GCallback) __lambda1__ethos_manager_plugin_loaded, self, 0);
		g_signal_connect_object (self->priv->manager, "plugin-unloaded", (GCallback) __lambda2__ethos_manager_plugin_unloaded, self, 0);
		self->priv->window = (_tmp1_ = g_object_ref_sink ((GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL)), _g_object_unref0 (self->priv->window), _tmp1_);
		gtk_window_set_title (self->priv->window, "Vala Example");
		gtk_widget_show ((GtkWidget*) self->priv->window);
		self->priv->button = (_tmp2_ = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock (GTK_STOCK_QUIT)), _g_object_unref0 (self->priv->button), _tmp2_);
		g_signal_connect_object (self->priv->button, "clicked", (GCallback) __lambda3__gtk_button_clicked, self, 0);
		gtk_container_add ((GtkContainer*) self->priv->window, (GtkWidget*) self->priv->button);
		gtk_widget_show ((GtkWidget*) self->priv->button);
	}
	return obj;
}


static void basic_example_class_init (BasicExampleClass * klass) {
	basic_example_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BasicExamplePrivate));
	G_OBJECT_CLASS (klass)->constructor = basic_example_constructor;
	G_OBJECT_CLASS (klass)->finalize = basic_example_finalize;
}


static void basic_example_instance_init (BasicExample * self) {
	self->priv = BASIC_EXAMPLE_GET_PRIVATE (self);
}


static void basic_example_finalize (GObject* obj) {
	BasicExample * self;
	self = BASIC_EXAMPLE (obj);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->button);
	G_OBJECT_CLASS (basic_example_parent_class)->finalize (obj);
}


GType basic_example_get_type (void) {
	static GType basic_example_type_id = 0;
	if (basic_example_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (BasicExampleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) basic_example_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BasicExample), 0, (GInstanceInitFunc) basic_example_instance_init, NULL };
		basic_example_type_id = g_type_register_static (G_TYPE_OBJECT, "BasicExample", &g_define_type_info, 0);
	}
	return basic_example_type_id;
}




